/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.importers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import ru.autosome.perfectosape.importers.BufferedPushbackReader;
import ru.autosome.perfectosape.importers.MotifImporter;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.motifModels.Named;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public class MotifCollectionImporter<ModelType extends Named & ScoringModel> {
    MotifImporter<ModelType> importer;

    public MotifCollectionImporter(MotifImporter<ModelType> importer) {
        this.importer = importer;
    }

    public List<ModelType> loadPWMCollection(File pathToPwms) throws FileNotFoundException {
        if (pathToPwms.isDirectory()) {
            return this.loadPWMCollectionFromFolder(pathToPwms);
        }
        return this.loadPWMCollectionFromFile(pathToPwms);
    }

    private List<ModelType> loadPWMCollectionFromFolder(File pathToPWMs) throws FileNotFoundException {
        ArrayList<ModelType> result = new ArrayList<ModelType>();
        File[] files = pathToPWMs.listFiles();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            ModelType pwm = this.importer.loadPWMFromFile(file);
            result.add(pwm);
        }
        return result;
    }

    private List<ModelType> loadPWMCollectionFromFile(File pathToPWMs) {
        try {
            ArrayList<ModelType> result = new ArrayList<ModelType>();
            BufferedPushbackReader reader = new BufferedPushbackReader(new FileInputStream(pathToPWMs));
            boolean canExtract = true;
            while (canExtract) {
                PMParser parser = PMParser.loadFromStream(reader);
                boolean bl = canExtract = canExtract && parser != null;
                if (parser == null) {
                    canExtract = false;
                    continue;
                }
                ModelType pwm = this.importer.loadPWMFromParser(parser);
                result.add(pwm);
            }
            return result;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

