/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.motifModels;

import java.util.ArrayList;
import ru.autosome.perfectosape.Sequence;
import ru.autosome.perfectosape.backgroundModels.DiBackgroundModel;
import ru.autosome.perfectosape.backgroundModels.DiWordwiseBackground;
import ru.autosome.perfectosape.calculations.ScoringModelDistributions.CountingDiPWM;
import ru.autosome.perfectosape.calculations.ScoringModelDistributions.ScoringModelDistibutions;
import ru.autosome.perfectosape.importers.PMParser;
import ru.autosome.perfectosape.motifModels.DiPM;
import ru.autosome.perfectosape.motifModels.Discretable;
import ru.autosome.perfectosape.motifModels.PWM;
import ru.autosome.perfectosape.motifModels.PositionWeightModel;
import ru.autosome.perfectosape.motifModels.ScoreDistribution;
import ru.autosome.perfectosape.motifModels.ScoreStatistics;
import ru.autosome.perfectosape.motifModels.ScoringModel;

public class DiPWM
extends DiPM
implements ScoringModel,
Discretable<DiPWM>,
ScoreStatistics<DiBackgroundModel>,
ScoreDistribution<DiBackgroundModel>,
PositionWeightModel {
    private double[][] cache_best_suffices;
    private double[][] cache_worst_suffices;

    public DiPWM(double[][] matrix, String name) {
        super(matrix, name);
    }

    public static DiPWM fromPWM(PWM pwm) {
        double[][] matrix = new double[pwm.matrix.length - 1][];
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = new double[16];
            for (int letter = 0; letter < 16; ++letter) {
                matrix[i][letter] = pwm.matrix[i][letter / 4];
            }
        }
        for (int letter = 0; letter < 16; ++letter) {
            double[] dArray = matrix[matrix.length - 1];
            int n = letter;
            dArray[n] = dArray[n] + pwm.matrix[matrix.length][letter % 4];
        }
        return new DiPWM(matrix, pwm.name);
    }

    public static DiPWM fromParser(PMParser parser) {
        double[][] matrix = parser.matrix();
        String name = parser.name();
        return new DiPWM(matrix, name);
    }

    private static DiPWM new_from_text(ArrayList<String> input_lines) {
        return DiPWM.fromParser(new PMParser(input_lines));
    }

    double score(String word, DiBackgroundModel background) throws IllegalArgumentException {
        if ((word = word.toUpperCase()).length() != this.length()) {
            throw new IllegalArgumentException("word in PWM#score(word) should have the same length as matrix");
        }
        double sum = 0.0;
        for (int pos_index = 0; pos_index < this.matrix.length; ++pos_index) {
            String dinucleotide = word.substring(pos_index, pos_index + 2);
            Integer superletter_index = (Integer)indexByLetter.get(dinucleotide);
            if (superletter_index != null) {
                sum += this.matrix[pos_index][superletter_index];
                continue;
            }
            throw new IllegalArgumentException("word in PWM#score(#{word}) should have only {ACGT}^2 dinucleotides , but has '" + dinucleotide + "' dinucleotide");
        }
        return sum;
    }

    public double score(Sequence word, DiBackgroundModel background) throws IllegalArgumentException {
        return this.score(word.sequence, background);
    }

    @Override
    public double score(Sequence word) throws IllegalArgumentException {
        return this.score(word, (DiBackgroundModel)new DiWordwiseBackground());
    }

    public double best_score() {
        double best_score = Double.NEGATIVE_INFINITY;
        for (int letter = 0; letter < 4; ++letter) {
            best_score = Math.max(best_score, this.best_suffix(0, letter));
        }
        return best_score;
    }

    public double worst_score() {
        double worst_score = Double.POSITIVE_INFINITY;
        for (int letter = 0; letter < 4; ++letter) {
            worst_score = Math.min(worst_score, this.worst_suffix(0, letter));
        }
        return worst_score;
    }

    public double best_suffix(int pos, int letter) {
        return this.best_suffices()[pos][letter];
    }

    public double worst_suffix(int pos, int letter) {
        return this.worst_suffices()[pos][letter];
    }

    private double[][] best_suffices() {
        if (this.cache_best_suffices == null) {
            this.cache_best_suffices = this.calculate_best_suffices();
        }
        return this.cache_best_suffices;
    }

    private double[][] worst_suffices() {
        if (this.cache_worst_suffices == null) {
            this.cache_worst_suffices = this.calculate_worst_suffices();
        }
        return this.cache_worst_suffices;
    }

    private double[][] calculate_best_suffices() {
        double[][] result = new double[this.matrix.length + 1][];
        for (int letter = 0; letter < 4; ++letter) {
            result[this.matrix.length] = new double[16];
            result[this.matrix.length][letter] = 0.0;
        }
        for (int i = this.matrix.length - 1; i >= 0; --i) {
            result[i] = new double[16];
            for (int letter = 0; letter < 4; ++letter) {
                double best_score = Double.NEGATIVE_INFINITY;
                for (int next_letter = 0; next_letter < 4; ++next_letter) {
                    best_score = Math.max(best_score, this.matrix[i][4 * letter + next_letter] + result[i + 1][next_letter]);
                }
                result[i][letter] = best_score;
            }
        }
        return result;
    }

    private double[][] calculate_worst_suffices() {
        double[][] result = new double[this.matrix.length + 1][];
        for (int letter = 0; letter < 4; ++letter) {
            result[this.matrix.length] = new double[16];
            result[this.matrix.length][letter] = 0.0;
        }
        for (int i = this.matrix.length - 1; i >= 0; --i) {
            result[i] = new double[16];
            for (int letter = 0; letter < 4; ++letter) {
                double worst_score = Double.POSITIVE_INFINITY;
                for (int next_letter = 0; next_letter < 4; ++next_letter) {
                    worst_score = Math.min(worst_score, this.matrix[i][4 * letter + next_letter] + result[i + 1][next_letter]);
                }
                result[i][letter] = worst_score;
            }
        }
        return result;
    }

    @Override
    public DiPWM discrete(Double rate) {
        if (rate == null) {
            return this;
        }
        double[][] mat_result = new double[this.matrix.length][];
        for (int i = 0; i < this.matrix.length; ++i) {
            mat_result[i] = new double[16];
            for (int j = 0; j < 16; ++j) {
                mat_result[i][j] = Math.ceil(this.matrix[i][j] * rate);
            }
        }
        return new DiPWM(mat_result, this.name);
    }

    @Override
    public double score_mean(DiBackgroundModel background) {
        double result = 0.0;
        for (double[] pos : this.matrix) {
            result += background.mean_value(pos);
        }
        return result;
    }

    @Override
    public double score_variance(DiBackgroundModel background) {
        double variance = 0.0;
        for (double[] pos : this.matrix) {
            double mean_square = background.mean_square_value(pos);
            double mean = background.mean_value(pos);
            double squared_mean = mean * mean;
            variance += mean_square - squared_mean;
        }
        return variance;
    }

    @Override
    public ScoringModelDistibutions scoringModelDistibutions(DiBackgroundModel background, Integer maxHashSize) {
        return new CountingDiPWM(this, background, maxHashSize);
    }
}

