/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ytilib;

import java.util.Arrays;
import java.util.List;
import ru.autosome.assist.AMatrix;
import ru.autosome.ytilib.Sequence;

public class Peak
extends Sequence {
    protected double[] pdirect;
    protected double[] prevcomp;

    public Peak(String sour) {
        super(sour);
        this.pdirect = new double[this.direct.length];
        this.prevcomp = new double[this.revcomp.length];
        Arrays.fill(this.pdirect, 1.0);
        Arrays.fill(this.prevcomp, 1.0);
    }

    public Peak(String sour, double[] pdirect) {
        super(sour);
        this.pdirect = pdirect;
        this.prevcomp = new double[pdirect.length];
        for (int i = 0; i < pdirect.length; ++i) {
            this.prevcomp[pdirect.length - 1 - i] = this.pdirect[i];
        }
    }

    public Peak(String newseq, double[] newprof, double weight) {
        this(newseq, newprof);
        this.weight = weight;
    }

    @Override
    public void bestHits(AMatrix wpcm, List<Integer> prihit, List<Integer> revhit) {
        prihit.clear();
        revhit.clear();
        double best_hit = wpcm.hits(this.direct, this.revcomp, this.hdirect, this.hrevcomp, this.pdirect, this.prevcomp);
        for (int i = 0; i <= this.direct.length - wpcm.length(); ++i) {
            if (this.hdirect[i] >= best_hit) {
                prihit.add(i);
            }
            if (!(this.hrevcomp[i] >= best_hit)) continue;
            revhit.add(i);
        }
    }

    @Override
    public void rebuild(AMatrix wpcm, List<Integer> prihits, List<Integer> revhits) {
        int j;
        double total_weight = this.weight / (double)(prihits.size() + revhits.size());
        for (Integer prihit : prihits) {
            for (j = 0; j < wpcm.length(); ++j) {
                double[] dArray = wpcm.matrix()[this.direct[prihit + j]];
                int n = j;
                dArray[n] = dArray[n] + total_weight * this.pdirect[prihit + j];
                double[] dArray2 = wpcm.matrix()[14];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + total_weight * (1.0 - this.pdirect[prihit + j]);
            }
        }
        for (Integer revhit : revhits) {
            for (j = 0; j < wpcm.length(); ++j) {
                double[] dArray = wpcm.matrix()[this.revcomp[revhit + j]];
                int n = j;
                dArray[n] = dArray[n] + total_weight * this.prevcomp[revhit + j];
                double[] dArray3 = wpcm.matrix()[14];
                int n3 = j;
                dArray3[n3] = dArray3[n3] + total_weight * (1.0 - this.prevcomp[revhit + j]);
            }
        }
    }

    public double top() {
        double top = -1.7976931348623157E308;
        for (double d : this.pdirect) {
            top = d > top ? d : top;
        }
        return top;
    }

    public Peak normalize(boolean logWeighting) {
        double peakTop = this.top();
        this.weight = logWeighting ? Math.log(peakTop + 1.0) * this.weight : peakTop * this.weight;
        int i = 0;
        while (i < this.pdirect.length) {
            int n = i;
            this.pdirect[n] = this.pdirect[n] / peakTop;
            int n2 = i++;
            this.prevcomp[n2] = this.prevcomp[n2] / peakTop;
        }
        return this;
    }

    public int leftMaximaIndex() {
        double top = this.top();
        for (int i = 0; i < this.pdirect.length; ++i) {
            if (this.pdirect[i] != top) continue;
            return i;
        }
        return -1;
    }

    public int rightMaximaIndex() {
        double top = this.top();
        for (int i = this.pdirect.length - 1; i >= 0; --i) {
            if (this.pdirect[i] != top) continue;
            return i;
        }
        return -1;
    }

    public int localLeftMinimaIndex(int from) {
        int mini = from;
        int i = from;
        while (i >= 0) {
            if (this.pdirect[i] > this.pdirect[mini]) {
                return mini;
            }
            mini = i--;
        }
        return mini;
    }

    public int localRightMinimaIndex(int from) {
        int maxi = from;
        int i = from;
        while (i < this.pdirect.length) {
            if (this.pdirect[i] > this.pdirect[maxi]) {
                return maxi;
            }
            maxi = i++;
        }
        return maxi;
    }

    public void soften(int length) {
        double[] newpd = new double[this.pdirect.length];
        double[] newpr = new double[this.prevcomp.length];
        for (int i = 0; i < this.pdirect.length; ++i) {
            newpd[i] = this.max(this.pdirect, i - length + 1, i + length - 1);
            newpr[i] = this.max(this.prevcomp, i - length + 1, i + length - 1);
        }
        this.pdirect = newpd;
        this.prevcomp = newpr;
    }

    private double max(double[] pri, int start, int send) {
        int rs = Math.max(0, start);
        int re = Math.min(send, pri.length - 1);
        double max = pri[rs];
        for (int i = rs + 1; i <= re; ++i) {
            max = max > pri[i] ? max : pri[i];
        }
        return max;
    }

    public Peak(byte[] cdirect, byte[] crevcomp, double weight, double[] cpdirect, double[] cprevcomp) {
        super(cdirect, crevcomp, weight);
        this.pdirect = cpdirect;
        this.prevcomp = cprevcomp;
    }

    @Override
    public Sequence copy() {
        byte[] cdirect = new byte[this.direct.length];
        byte[] crevcomp = new byte[this.revcomp.length];
        System.arraycopy(this.direct, 0, cdirect, 0, this.direct.length);
        System.arraycopy(this.revcomp, 0, crevcomp, 0, this.revcomp.length);
        double[] cpdirect = new double[this.pdirect.length];
        double[] cprevcomp = new double[this.prevcomp.length];
        System.arraycopy(this.pdirect, 0, cpdirect, 0, this.pdirect.length);
        System.arraycopy(this.prevcomp, 0, cprevcomp, 0, this.prevcomp.length);
        return new Peak(cdirect, crevcomp, this.weight, cpdirect, cprevcomp);
    }
}

