/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ytilib;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.assist.AMatrix;
import ru.autosome.assist.ASequence;
import ru.autosome.assist.Occurrence;
import ru.autosome.ytilib.Peak;
import ru.autosome.ytilib.Sequence;

public class RNASequence
extends Peak {
    public RNASequence(String sour) {
        super(sour);
        this.revcomp = null;
        this.prevcomp = null;
    }

    public RNASequence(String sour, double[] pdirect) {
        super(sour, pdirect);
        this.revcomp = null;
        this.prevcomp = null;
    }

    public RNASequence(String newseq, double[] newprof, double weight) {
        super(newseq, newprof, weight);
        this.revcomp = null;
        this.prevcomp = null;
    }

    public RNASequence(byte[] cdirect, byte[] crevcomp, double weight, double[] cpdirect, double[] cprevcomp) {
        super(cdirect, crevcomp, weight, cpdirect, cprevcomp);
        this.revcomp = null;
        this.prevcomp = null;
    }

    public RNASequence(byte[] cdirect, double weight, double[] cpdirect) {
        super(cdirect, null, weight, cpdirect, null);
    }

    @Override
    public void bestHits(AMatrix wpcm, List<Integer> prihit, List<Integer> revhit) {
        prihit.clear();
        revhit.clear();
        double best_hit = wpcm.hits(this.direct, this.hdirect, this.pdirect);
        for (int i = 0; i <= this.direct.length - wpcm.length(); ++i) {
            if (!(this.hdirect[i] >= best_hit)) continue;
            prihit.add(i);
        }
    }

    @Override
    public Sequence copy() {
        byte[] cdirect = new byte[this.direct.length];
        System.arraycopy(this.direct, 0, cdirect, 0, this.direct.length);
        double[] cpdirect = new double[this.pdirect.length];
        System.arraycopy(this.pdirect, 0, cpdirect, 0, this.pdirect.length);
        return new RNASequence(cdirect, this.weight, cpdirect);
    }

    @Override
    public List<Occurrence> gatherOccurrences(AMatrix pm, double threshold) {
        ArrayList<Occurrence> result = new ArrayList<Occurrence>();
        for (int i = 0; i <= this.direct.length - pm.length(); ++i) {
            double direct_score = pm.score(this.direct, i);
            if (!(direct_score >= threshold)) continue;
            result.add(new Occurrence(this.word2str(this.direct, i, pm.length()), i, ASequence.Strand.DIRECT, direct_score));
        }
        return result;
    }

    @Override
    public boolean hasOccurrence(AMatrix pm, double threshold) {
        for (int i = 0; i <= this.direct.length - pm.length(); ++i) {
            double direct_score = pm.score(this.direct, i);
            if (!(direct_score >= threshold)) continue;
            return true;
        }
        return false;
    }
}

