/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ytilib;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import ru.autosome.assist.AMatrix;
import ru.autosome.di.ytilib.Din;
import ru.autosome.ytilib.Sequence;

public class WPCM
extends AMatrix {
    public static final double KDIC_MAX = -Math.log(0.25);

    public WPCM(int length, List<Integer>[] prihits, List<Integer>[] revhits, Sequence[] sequences, List<Integer> sequenceOrder, int sequenceCount) {
        int i;
        this.length = length;
        double totalWeight = 0.0;
        for (i = 0; i < sequenceCount; ++i) {
            totalWeight += sequences[sequenceOrder.get((int)i).intValue()].weight;
        }
        this.N = totalWeight;
        this.matrix = new double[15][];
        for (i = 0; i < 15; ++i) {
            this.matrix[i] = new double[length];
        }
        for (i = 0; i < sequenceCount; ++i) {
            int j;
            int k = sequenceOrder.get(i);
            Sequence sequence = sequences[k];
            double hitWeight = sequence.weight / (double)(prihits[k].size() + revhits[k].size());
            for (Integer prihit : prihits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.direct()[prihit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + hitWeight;
                }
            }
            for (Integer revhit : revhits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.revcomp()[revhit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + hitWeight;
                }
            }
        }
        this.processIUPAC();
    }

    public WPCM(int length, Sequence sequence, int shift) {
        this.length = length;
        double totalWeight = 1.0;
        this.matrix = new double[15][length];
        for (int i = 0; i < length; ++i) {
            this.matrix[sequence.direct()[shift + i]][i] = totalWeight;
        }
        this.N = totalWeight;
        this.processIUPAC();
    }

    public WPCM(ru.autosome.di.ytilib.WPCM dim) {
        int i;
        this.length = dim.length() + 1;
        this.matrix = new double[15][this.length];
        double[][] dimatrix = dim.getMatrix();
        for (i = 0; i < dim.length(); ++i) {
            this.matrix[0][i] = dimatrix[(byte)Din.AA.ordinal()][i] + dimatrix[(byte)Din.AC.ordinal()][i] + dimatrix[(byte)Din.AG.ordinal()][i] + dimatrix[(byte)Din.AT.ordinal()][i];
            this.matrix[1][i] = dimatrix[(byte)Din.CA.ordinal()][i] + dimatrix[(byte)Din.CC.ordinal()][i] + dimatrix[(byte)Din.CG.ordinal()][i] + dimatrix[(byte)Din.CT.ordinal()][i];
            this.matrix[2][i] = dimatrix[(byte)Din.GA.ordinal()][i] + dimatrix[(byte)Din.GC.ordinal()][i] + dimatrix[(byte)Din.GG.ordinal()][i] + dimatrix[(byte)Din.GT.ordinal()][i];
            this.matrix[3][i] = dimatrix[(byte)Din.TA.ordinal()][i] + dimatrix[(byte)Din.TC.ordinal()][i] + dimatrix[(byte)Din.TG.ordinal()][i] + dimatrix[(byte)Din.TT.ordinal()][i];
        }
        i = dim.length() - 1;
        this.matrix[0][i + 1] = dimatrix[(byte)Din.AA.ordinal()][i] + dimatrix[(byte)Din.CA.ordinal()][i] + dimatrix[(byte)Din.GA.ordinal()][i] + dimatrix[(byte)Din.TA.ordinal()][i];
        this.matrix[1][i + 1] = dimatrix[(byte)Din.AC.ordinal()][i] + dimatrix[(byte)Din.CC.ordinal()][i] + dimatrix[(byte)Din.GC.ordinal()][i] + dimatrix[(byte)Din.TC.ordinal()][i];
        this.matrix[2][i + 1] = dimatrix[(byte)Din.AG.ordinal()][i] + dimatrix[(byte)Din.CG.ordinal()][i] + dimatrix[(byte)Din.GG.ordinal()][i] + dimatrix[(byte)Din.TG.ordinal()][i];
        this.matrix[3][i + 1] = dimatrix[(byte)Din.AT.ordinal()][i] + dimatrix[(byte)Din.CT.ordinal()][i] + dimatrix[(byte)Din.GT.ordinal()][i] + dimatrix[(byte)Din.TT.ordinal()][i];
        this.N = dim.getN();
        this.processIUPAC();
    }

    public WPCM(double n, double[][] matrix) {
        this.length = matrix[0].length;
        this.N = n;
        this.matrix = matrix;
    }

    public WPCM(double[][] matrix, boolean processIUPAC) {
        this(matrix[0][0] + matrix[1][0] + matrix[2][0] + matrix[3][0], matrix);
        if (processIUPAC) {
            this.processIUPAC();
        }
    }

    public WPCM(WPCM base) {
        this.matrix = new double[base.matrix.length][];
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = (double[])base.matrix[i].clone();
        }
        this.length = base.length;
        this.N = base.N;
    }

    public static void iupacomprobs(double[] probs) {
        double pa = probs[0];
        double pc = probs[1];
        double pg = probs[2];
        double pt = probs[3];
        probs[14] = 0.25;
        probs[13] = (pa + pc + pg) / 3.0;
        probs[12] = (pa + pc + pt) / 3.0;
        probs[11] = (pa + pg + pt) / 3.0;
        probs[10] = (pc + pg + pt) / 3.0;
        probs[9] = (pa + pt) / 2.0;
        probs[8] = (pc + pg) / 2.0;
        probs[7] = (pa + pc) / 2.0;
        probs[6] = (pg + pt) / 2.0;
        probs[5] = (pc + pt) / 2.0;
        probs[4] = (pa + pg) / 2.0;
    }

    public WPCM(int length, List<Integer>[] prihits, List<Integer>[] revhits, Sequence[] sequences, boolean discardWeights) {
        this.length = length;
        this.N = sequences.length;
        this.matrix = new double[15][];
        for (int i = 0; i < 15; ++i) {
            this.matrix[i] = new double[length];
        }
        for (int k = 0; k < sequences.length; ++k) {
            int j;
            Sequence sequence = sequences[k];
            double total_weight = (discardWeights ? 1.0 : sequence.weight) / (double)(prihits[k].size() + revhits[k].size());
            for (Integer prihit : prihits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.direct()[prihit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + total_weight;
                }
            }
            for (Integer revhit : revhits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.revcomp()[revhit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + total_weight;
                }
            }
        }
        this.processIUPAC();
    }

    public WPCM(int length, List<Integer>[] prihits, List<Integer>[] revhits, Sequence[] sequences) {
        this.length = length;
        this.N = sequences.length;
        this.matrix = new double[15][];
        for (int i = 0; i < 15; ++i) {
            this.matrix[i] = new double[length];
        }
        for (int k = 0; k < sequences.length; ++k) {
            int j;
            Sequence sequence = sequences[k];
            double total_weight = sequence.weight / (double)(prihits[k].size() + revhits[k].size());
            for (Integer prihit : prihits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.direct()[prihit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + total_weight;
                }
            }
            for (Integer revhit : revhits[k]) {
                j = 0;
                while (j < length) {
                    double[] dArray = this.matrix[sequence.revcomp()[revhit + j]];
                    int n = j++;
                    dArray[n] = dArray[n] + total_weight;
                }
            }
        }
        this.processIUPAC();
    }

    public WPCM(byte[][] alignment) {
        this.N = alignment.length;
        this.length = alignment[0].length;
        this.matrix = new double[15][];
        for (int i = 0; i < 15; ++i) {
            this.matrix[i] = new double[this.length];
        }
        for (byte[] word : alignment) {
            int j = 0;
            while (j < this.length) {
                double[] dArray = this.matrix[word[j]];
                int n = j++;
                dArray[n] = dArray[n] + 1.0;
            }
        }
        this.processIUPAC();
    }

    public WPCM(double[][] matrix) {
        this(matrix, false);
    }

    public WPCM toPWM(double[] background) {
        double pseudocount = this.N == 1.0 ? Math.log(2.0) : Math.log(this.N);
        for (int j = 0; j < this.length; ++j) {
            for (int i = 0; i < 15; ++i) {
                this.matrix[i][j] = Math.log((this.matrix[i][j] + background[i] * pseudocount) / ((this.N + pseudocount) * background[i]));
            }
        }
        return this;
    }

    public void rebuild(List<Integer>[] prihits, List<Integer>[] revhits, Sequence[] sequences) {
        for (int i = 0; i < 15; ++i) {
            Arrays.fill(this.matrix[i], 0.0);
        }
        for (int k = 0; k < sequences.length; ++k) {
            Sequence sequence = sequences[k];
            sequence.rebuild(this, prihits[k], revhits[k]);
        }
        this.processIUPAC();
    }

    private void processIUPAC() {
        int j;
        for (j = 0; j < this.length; ++j) {
            double[] dArray = this.matrix[0];
            int n = j;
            dArray[n] = dArray[n] + this.matrix[14][j] / 4.0;
            double[] dArray2 = this.matrix[1];
            int n2 = j;
            dArray2[n2] = dArray2[n2] + this.matrix[14][j] / 4.0;
            double[] dArray3 = this.matrix[2];
            int n3 = j;
            dArray3[n3] = dArray3[n3] + this.matrix[14][j] / 4.0;
            double[] dArray4 = this.matrix[3];
            int n4 = j;
            dArray4[n4] = dArray4[n4] + this.matrix[14][j] / 4.0;
            double[] dArray5 = this.matrix[0];
            int n5 = j;
            dArray5[n5] = dArray5[n5] + this.matrix[13][j] / 3.0;
            double[] dArray6 = this.matrix[1];
            int n6 = j;
            dArray6[n6] = dArray6[n6] + this.matrix[13][j] / 3.0;
            double[] dArray7 = this.matrix[2];
            int n7 = j;
            dArray7[n7] = dArray7[n7] + this.matrix[13][j] / 3.0;
            double[] dArray8 = this.matrix[0];
            int n8 = j;
            dArray8[n8] = dArray8[n8] + this.matrix[12][j] / 3.0;
            double[] dArray9 = this.matrix[1];
            int n9 = j;
            dArray9[n9] = dArray9[n9] + this.matrix[12][j] / 3.0;
            double[] dArray10 = this.matrix[3];
            int n10 = j;
            dArray10[n10] = dArray10[n10] + this.matrix[12][j] / 3.0;
            double[] dArray11 = this.matrix[0];
            int n11 = j;
            dArray11[n11] = dArray11[n11] + this.matrix[11][j] / 3.0;
            double[] dArray12 = this.matrix[2];
            int n12 = j;
            dArray12[n12] = dArray12[n12] + this.matrix[11][j] / 3.0;
            double[] dArray13 = this.matrix[3];
            int n13 = j;
            dArray13[n13] = dArray13[n13] + this.matrix[11][j] / 3.0;
            double[] dArray14 = this.matrix[1];
            int n14 = j;
            dArray14[n14] = dArray14[n14] + this.matrix[10][j] / 3.0;
            double[] dArray15 = this.matrix[2];
            int n15 = j;
            dArray15[n15] = dArray15[n15] + this.matrix[10][j] / 3.0;
            double[] dArray16 = this.matrix[3];
            int n16 = j;
            dArray16[n16] = dArray16[n16] + this.matrix[10][j] / 3.0;
            double[] dArray17 = this.matrix[0];
            int n17 = j;
            dArray17[n17] = dArray17[n17] + this.matrix[9][j] / 2.0;
            double[] dArray18 = this.matrix[3];
            int n18 = j;
            dArray18[n18] = dArray18[n18] + this.matrix[9][j] / 2.0;
            double[] dArray19 = this.matrix[1];
            int n19 = j;
            dArray19[n19] = dArray19[n19] + this.matrix[8][j] / 2.0;
            double[] dArray20 = this.matrix[2];
            int n20 = j;
            dArray20[n20] = dArray20[n20] + this.matrix[8][j] / 2.0;
            double[] dArray21 = this.matrix[0];
            int n21 = j;
            dArray21[n21] = dArray21[n21] + this.matrix[7][j] / 2.0;
            double[] dArray22 = this.matrix[1];
            int n22 = j;
            dArray22[n22] = dArray22[n22] + this.matrix[7][j] / 2.0;
            double[] dArray23 = this.matrix[2];
            int n23 = j;
            dArray23[n23] = dArray23[n23] + this.matrix[6][j] / 2.0;
            double[] dArray24 = this.matrix[3];
            int n24 = j;
            dArray24[n24] = dArray24[n24] + this.matrix[6][j] / 2.0;
            double[] dArray25 = this.matrix[1];
            int n25 = j;
            dArray25[n25] = dArray25[n25] + this.matrix[5][j] / 2.0;
            double[] dArray26 = this.matrix[3];
            int n26 = j;
            dArray26[n26] = dArray26[n26] + this.matrix[5][j] / 2.0;
            double[] dArray27 = this.matrix[0];
            int n27 = j;
            dArray27[n27] = dArray27[n27] + this.matrix[4][j] / 2.0;
            double[] dArray28 = this.matrix[2];
            int n28 = j;
            dArray28[n28] = dArray28[n28] + this.matrix[4][j] / 2.0;
        }
        for (j = 0; j < this.length; ++j) {
            this.matrix[14][j] = (this.matrix[0][j] + this.matrix[1][j] + this.matrix[2][j] + this.matrix[3][j]) / 4.0;
            this.matrix[13][j] = (this.matrix[0][j] + this.matrix[1][j] + this.matrix[2][j]) / 3.0;
            this.matrix[12][j] = (this.matrix[0][j] + this.matrix[1][j] + this.matrix[3][j]) / 3.0;
            this.matrix[11][j] = (this.matrix[0][j] + this.matrix[2][j] + this.matrix[3][j]) / 3.0;
            this.matrix[10][j] = (this.matrix[1][j] + this.matrix[2][j] + this.matrix[3][j]) / 3.0;
            this.matrix[9][j] = (this.matrix[0][j] + this.matrix[3][j]) / 2.0;
            this.matrix[8][j] = (this.matrix[1][j] + this.matrix[2][j]) / 2.0;
            this.matrix[7][j] = (this.matrix[0][j] + this.matrix[1][j]) / 2.0;
            this.matrix[6][j] = (this.matrix[2][j] + this.matrix[3][j]) / 2.0;
            this.matrix[5][j] = (this.matrix[1][j] + this.matrix[3][j]) / 2.0;
            this.matrix[4][j] = (this.matrix[0][j] + this.matrix[2][j]) / 2.0;
        }
    }

    public static WPCM load(String arg) {
        ArrayList<Double> aw = new ArrayList<Double>();
        ArrayList<Double> cw = new ArrayList<Double>();
        ArrayList<Double> gw = new ArrayList<Double>();
        ArrayList<Double> tw = new ArrayList<Double>();
        try {
            String s;
            BufferedReader bin = new BufferedReader(new InputStreamReader(new FileInputStream(arg)));
            while ((s = bin.readLine()) != null) {
                String[] tores;
                if (s.length() == 0 || (tores = s.split(" ")).length != 4) continue;
                aw.add(Double.parseDouble(tores[0]));
                cw.add(Double.parseDouble(tores[1]));
                gw.add(Double.parseDouble(tores[2]));
                tw.add(Double.parseDouble(tores[3]));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("unable to load matrix from " + arg);
        }
        double[][] resmat = new double[15][aw.size()];
        for (int i = 0; i < aw.size(); ++i) {
            resmat[0][i] = (Double)aw.get(i);
            resmat[1][i] = (Double)cw.get(i);
            resmat[2][i] = (Double)gw.get(i);
            resmat[3][i] = (Double)tw.get(i);
        }
        return new WPCM(resmat, true);
    }

    public double kdic(double[] background, int j) {
        double kdic = WPCM.logFact(this.N);
        for (int i = 0; i < 4; ++i) {
            kdic -= WPCM.logFact(this.matrix[i][j]);
            kdic += this.matrix[i][j] * Math.log(background[i]);
        }
        kdic = -kdic / this.N;
        return kdic / KDIC_MAX;
    }

    public double kdic(double[] background) {
        double kdic = 0.0;
        for (int j = 0; j < this.length; ++j) {
            kdic += this.kdic(background, j);
        }
        return kdic / (double)this.length;
    }

    public double thresholdLC() {
        double io = this.N / 6.0;
        double icdpart = (WPCM.logFact(io * 2.0) * 2.0 + WPCM.logFact(io) * 2.0 - WPCM.logFact(this.N)) / this.N;
        double kpart = Math.log(0.25);
        return (icdpart - kpart) / KDIC_MAX;
    }

    public double thresholdHC() {
        double io = this.N / 3.0;
        double icdpart = (WPCM.logFact(io) * 3.0 - WPCM.logFact(this.N)) / this.N;
        double kpart = Math.log(0.25);
        return (icdpart - kpart) / KDIC_MAX;
    }

    public double kdic2of4() {
        double io = this.N / 2.0;
        double icdpart = (WPCM.logFact(io) * 2.0 - WPCM.logFact(this.N)) / this.N;
        double kpart = Math.log(0.25);
        return (icdpart - kpart) / KDIC_MAX;
    }

    public WPCM toPWM(double pseudocount, double[] background) {
        for (int j = 0; j < this.length; ++j) {
            for (int i = 0; i < 15; ++i) {
                this.matrix[i][j] = Math.log((this.matrix[i][j] + background[i] * pseudocount) / ((this.N + pseudocount) * background[i]));
            }
        }
        return this;
    }

    public String consensus2(double[] background) {
        String strand2;
        String strand1 = this.consensus1(background);
        return strand1.compareTo(strand2 = WPCM.revcomp(strand1)) < 0 ? strand1 : strand2;
    }

    public String consensus1() {
        return this.consensus1(Sequence.uniformBackground);
    }

    public String consensus1(double[] background) {
        StringBuilder resc = new StringBuilder(this.length);
        for (int j = 0; j < this.length; ++j) {
            double lk = this.kdic(background, j);
            int letn = 4;
            if (lk >= this.kdic2of4()) {
                letn = 1;
            } else if (lk >= this.thresholdHC()) {
                letn = 2;
            } else if (lk >= this.thresholdLC()) {
                letn = 3;
            }
            String toAppend = this.conslets(this.matrix[0][j], this.matrix[1][j], this.matrix[2][j], this.matrix[3][j], letn);
            if (letn > 2) {
                toAppend = toAppend.toLowerCase();
            }
            resc.append(toAppend);
        }
        return resc.toString();
    }

    private String conslets(double a, double c, double g, double t, int letn) {
        String[] letters = new String[]{"A", "C", "G", "T"};
        final HashMap<String, Double> letcon = new HashMap<String, Double>(4);
        letcon.put("A", a);
        letcon.put("C", c);
        letcon.put("G", g);
        letcon.put("T", t);
        Arrays.sort(letters, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Double)letcon.get(o2)).compareTo((Double)letcon.get(o1));
            }
        });
        ArrayList<String> rcl = new ArrayList<String>(letn);
        int i = 0;
        while (i < letn || i < 4 && ((Double)letcon.get(letters[i])).equals(letcon.get(rcl.get(rcl.size() - 1)))) {
            rcl.add(letters[i++]);
        }
        Object[] rcls = rcl.toArray(new String[rcl.size()]);
        Arrays.sort(rcls);
        StringBuilder sbrcls = new StringBuilder(rcls.length);
        for (Object s : rcls) {
            sbrcls.append((String)s);
        }
        return (String)CONSENSUS.get(sbrcls.toString());
    }

    @Override
    public AMatrix makePWM(double[] background) {
        return new WPCM(this).toPWM(background);
    }
}

