# Generated by Django 3.2.4 on 2022-01-09 14:57
import django.contrib.auth.models
import django.contrib.auth.validators
import django.db.models.deletion
import django.utils.timezone
import taggit.managers
from django.db import migrations
from django.db import models

import kustosz.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        ("taggit", "0003_taggeditem_add_unique_index"),
    ]

    operations = [
        migrations.CreateModel(
            name="Channel",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "url",
                    kustosz.models.ChannelURLField(max_length=2048, unique=True),
                ),
                (
                    "channel_type",
                    models.CharField(
                        choices=[("manual", "Manual"), ("feed", "RSS/Atom feed")],
                        max_length=20,
                    ),
                ),
                (
                    "title",
                    models.TextField(blank=True, help_text="Title (name) of channel"),
                ),
                (
                    "title_upstream",
                    models.TextField(
                        blank=True,
                        help_text="Channel title, as specified by channel itself",
                    ),
                ),
                (
                    "link",
                    models.TextField(
                        blank=True,
                        help_text=(
                            "Channel link attribute, e.g. "
                            "URL of content index in HTML format"
                        ),
                    ),
                ),
                (
                    "last_check_time",
                    models.DateTimeField(
                        blank=True, help_text="When channel was last checked", null=True
                    ),
                ),
                (
                    "last_successful_check_time",
                    models.DateTimeField(
                        blank=True,
                        help_text="When last check of channel did not result in error",
                        null=True,
                    ),
                ),
                (
                    "added_time",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="When channel was added to database",
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Is this channel actively checked for new content?",
                    ),
                ),
                (
                    "update_frequency",
                    models.IntegerField(
                        default=3600,
                        help_text="How often channel should be checked, in seconds",
                    ),
                ),
                (
                    "deduplication_enabled",
                    models.BooleanField(
                        default=True,
                        help_text=(
                            "Is new content from this "
                            "channel subject to deduplication?"
                        ),
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        help_text="A comma-separated list of tags.",
                        through="taggit.TaggedItem",
                        to="taggit.Tag",
                        verbose_name="Tags",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Entry",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "gid",
                    models.TextField(
                        help_text="Unique identifier of entry", max_length=2048
                    ),
                ),
                (
                    "archived",
                    models.BooleanField(
                        default=False, help_text="Is this entry archived (read)?"
                    ),
                ),
                (
                    "link",
                    models.URLField(
                        blank=True, help_text="URL of entry", max_length=2048
                    ),
                ),
                (
                    "title",
                    models.TextField(blank=True, help_text="Title (subject) of entry"),
                ),
                ("author", models.TextField(blank=True, help_text="Author of entry")),
                (
                    "note",
                    models.TextField(
                        blank=True, help_text="Note associated with entry"
                    ),
                ),
                (
                    "reader_position",
                    models.FloatField(
                        blank=True,
                        default=0,
                        help_text=(
                            "Last position of reader viewport, as percentage; "
                            "enables clients to implement 'continue reading' "
                            "functionality"
                        ),
                    ),
                ),
                (
                    "added_time",
                    models.DateTimeField(
                        auto_now_add=True, help_text="When entry was added to database"
                    ),
                ),
                (
                    "updated_time",
                    models.DateTimeField(
                        blank=True,
                        help_text="When entry was last updated in database",
                        null=True,
                    ),
                ),
                (
                    "published_time_upstream",
                    models.DateTimeField(
                        blank=True, help_text="Publication date of entry", null=True
                    ),
                ),
                (
                    "updated_time_upstream",
                    models.DateTimeField(
                        blank=True,
                        help_text="When entry/channel claims entry was last updated",
                        null=True,
                    ),
                ),
                (
                    "readability_fetch_time",
                    models.DateTimeField(
                        blank=True,
                        help_text="When did we fetch readability content for entry",
                        null=True,
                    ),
                ),
                (
                    "channel",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="entries",
                        to="kustosz.channel",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "entries",
            },
        ),
        migrations.CreateModel(
            name="EntryFilter",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "enabled",
                    models.BooleanField(
                        default=True, help_text="Is this filtering rule enabled?"
                    ),
                ),
                ("name", models.TextField(help_text="Name of the filtering rule")),
                (
                    "condition",
                    models.TextField(
                        help_text="Condition to match entries (as filterset definition)"
                    ),
                ),
                (
                    "action_name",
                    models.CharField(
                        choices=[
                            ("nothing", "Do nothing"),
                            ("mark_as_read", "Mark as read"),
                            ("assign_tag", "Assign tag"),
                            ("run_script", "Run external application"),
                        ],
                        max_length=20,
                    ),
                ),
                (
                    "action_argument",
                    models.TextField(
                        blank=True,
                        help_text=(
                            "Argument to action (name of tag, path to script etc.)"
                        ),
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EntryContent",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "source",
                    models.CharField(
                        choices=[
                            ("summary", "Feed - summary field"),
                            ("content", "Feed - content field"),
                            ("readability", "Readability (Python implementation)"),
                            ("nodereadability", "Readability (Node.js implementation)"),
                        ],
                        help_text="Source of this content",
                        max_length=20,
                    ),
                ),
                ("content", models.TextField(help_text="Content itself")),
                ("mimetype", models.TextField(blank=True, help_text="Type of content")),
                (
                    "language",
                    models.TextField(blank=True, help_text="Language of content"),
                ),
                (
                    "estimated_reading_time",
                    models.FloatField(
                        blank=True, help_text="Estimated read time, in minutes"
                    ),
                ),
                (
                    "updated_time",
                    models.DateTimeField(help_text="When content was last updated"),
                ),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="content_set",
                        to="kustosz.entry",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="entry",
            name="selected_preferred_content",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Last entry content selected by user",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="preferred_content_for",
                to="kustosz.entrycontent",
            ),
        ),
        migrations.AddField(
            model_name="entry",
            name="tags",
            field=taggit.managers.TaggableManager(
                help_text="A comma-separated list of tags.",
                through="taggit.TaggedItem",
                to="taggit.Tag",
                verbose_name="Tags",
            ),
        ),
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                (
                    "last_login",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="last login"
                    ),
                ),
                (
                    "is_superuser",
                    models.BooleanField(
                        default=False,
                        help_text=(
                            "Designates that this user has all permissions without "
                            "explicitly assigning them."
                        ),
                        verbose_name="superuser status",
                    ),
                ),
                (
                    "username",
                    models.CharField(
                        error_messages={
                            "unique": "A user with that username already exists."
                        },
                        help_text=(
                            "Required. 150 characters or fewer. "
                            "Letters, digits and @/./+/-/_ only."
                        ),
                        max_length=150,
                        unique=True,
                        validators=[
                            django.contrib.auth.validators.UnicodeUsernameValidator()
                        ],
                        verbose_name="username",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="first name"
                    ),
                ),
                (
                    "last_name",
                    models.CharField(
                        blank=True, max_length=150, verbose_name="last name"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True, max_length=254, verbose_name="email address"
                    ),
                ),
                (
                    "is_staff",
                    models.BooleanField(
                        default=False,
                        help_text=(
                            "Designates whether the user can log into this admin site."
                        ),
                        verbose_name="staff status",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text=(
                            "Designates whether this user should be treated as "
                            "active. Unselect this instead of deleting accounts."
                        ),
                        verbose_name="active",
                    ),
                ),
                (
                    "date_joined",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="date joined"
                    ),
                ),
                (
                    "default_filter",
                    models.TextField(
                        blank=True,
                        help_text=(
                            "Entry search filter definition used by "
                            "default on entries view"
                        ),
                    ),
                ),
                (
                    "theme_color",
                    models.TextField(
                        blank=True, help_text="User preferred color theme"
                    ),
                ),
                (
                    "theme_view",
                    models.TextField(blank=True, help_text="User preferred view"),
                ),
                (
                    "entry_open_read_timeout",
                    models.IntegerField(
                        default=2,
                        help_text=(
                            "When after opening entry it should be "
                            "marked as read (in seconds)"
                        ),
                    ),
                ),
                (
                    "entry_open_scroll_to_top",
                    models.BooleanField(
                        default=True,
                        help_text=(
                            "Should entry scroll to top " "automatically after opening?"
                        ),
                    ),
                ),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text=(
                            "The groups this user belongs to. A user "
                            "will get all permissions granted to each of their groups."
                        ),
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.Group",
                        verbose_name="groups",
                    ),
                ),
                (
                    "user_permissions",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Specific permissions for this user.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.Permission",
                        verbose_name="user permissions",
                    ),
                ),
            ],
            options={
                "verbose_name": "user",
                "verbose_name_plural": "users",
                "abstract": False,
            },
            managers=[
                ("objects", django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.AddConstraint(
            model_name="entry",
            constraint=models.UniqueConstraint(
                fields=("channel", "gid"), name="unique_channel_gid"
            ),
        ),
    ]
