import { GestureTool, GestureToolView } from "./gesture_tool";
import { BoxAnnotation } from "../../annotations/box_annotation";
import { CartesianFrame } from "../../canvas/cartesian_frame";
import * as p from "../../../core/properties";
import { PanEvent, KeyEvent } from "../../../core/ui_events";
import { Dimensions, BoxOrigin } from "../../../core/enums";
import { MenuItem } from "../../../core/util/menus";
declare type Point = [number, number];
export declare class BoxZoomToolView extends GestureToolView {
    model: BoxZoomTool;
    protected _base_point: Point | null;
    _match_aspect([bx, by]: Point, [cx, cy]: Point, frame: CartesianFrame): [Point, Point];
    protected _compute_limits(base_point: Point, curr_point: Point): [Point, Point];
    _pan_start(ev: PanEvent): void;
    _pan(ev: PanEvent): void;
    _pan_end(ev: PanEvent): void;
    _stop(): void;
    _keydown(ev: KeyEvent): void;
    _update([sx0, sx1]: Point, [sy0, sy1]: Point): void;
}
export declare namespace BoxZoomTool {
    type Attrs = p.AttrsOf<Props>;
    type Props = GestureTool.Props & {
        dimensions: p.Property<Dimensions | "auto">;
        overlay: p.Property<BoxAnnotation>;
        match_aspect: p.Property<boolean>;
        origin: p.Property<BoxOrigin>;
    };
}
export interface BoxZoomTool extends BoxZoomTool.Attrs {
}
export declare class BoxZoomTool extends GestureTool {
    properties: BoxZoomTool.Props;
    __view_type__: BoxZoomToolView;
    overlay: BoxAnnotation;
    constructor(attrs?: Partial<BoxZoomTool.Attrs>);
    tool_name: string;
    event_type: "pan";
    default_order: number;
    get computed_icon(): string;
    get tooltip(): string;
    get computed_overlays(): import("../..").Renderer[];
    get menu(): MenuItem[] | null;
}
export {};
//# sourceMappingURL=box_zoom_tool.d.ts.map