"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasMapping = exports.findMappings = void 0;
const section_1 = require("./section");
function findMappings(inspector, logicalId, props = {}) {
    const section = inspector.value.Mappings;
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findMappings = findMappings;
function hasMapping(inspector, logicalId, props) {
    const section = inspector.value.Mappings;
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return 'No mappings found in the template';
    }
    return [
        `Template has ${result.analyzedCount} mappings, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasMapping = hasMapping;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFwcGluZ3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJtYXBwaW5ncy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSx1Q0FBeUU7QUFFekUsU0FBZ0IsWUFBWSxDQUFDLFNBQXlCLEVBQUUsU0FBaUIsRUFBRSxRQUFhLEVBQUU7SUFDeEYsTUFBTSxPQUFPLEdBQTJCLFNBQVMsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDO0lBQ2pFLE1BQU0sTUFBTSxHQUFHLHNCQUFZLENBQUMseUJBQWUsQ0FBQyxPQUFPLEVBQUUsU0FBUyxDQUFDLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFFeEUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUU7UUFDakIsT0FBTyxFQUFFLENBQUM7S0FDWDtJQUVELE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQztBQUN4QixDQUFDO0FBVEQsb0NBU0M7QUFFRCxTQUFnQixVQUFVLENBQUMsU0FBeUIsRUFBRSxTQUFpQixFQUFFLEtBQVU7SUFDakYsTUFBTSxPQUFPLEdBQTBCLFNBQVMsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDO0lBQ2hFLE1BQU0sTUFBTSxHQUFHLHNCQUFZLENBQUMseUJBQWUsQ0FBQyxPQUFPLEVBQUUsU0FBUyxDQUFDLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFFeEUsSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFO1FBQ2hCLE9BQU87S0FDUjtJQUVELElBQUksTUFBTSxDQUFDLGFBQWEsS0FBSyxTQUFTLEVBQUU7UUFDdEMsT0FBTyxtQ0FBbUMsQ0FBQztLQUM1QztJQUVELE9BQU87UUFDTCxnQkFBZ0IsTUFBTSxDQUFDLGFBQWEsd0NBQXdDO1FBQzVFLHVCQUFhLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQztLQUNwQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUNmLENBQUM7QUFoQkQsZ0NBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU3RhY2tJbnNwZWN0b3IgfSBmcm9tICcuLi92ZW5kb3JlZC9hc3NlcnQnO1xuaW1wb3J0IHsgZmlsdGVyTG9naWNhbElkLCBmb3JtYXRGYWlsdXJlLCBtYXRjaFNlY3Rpb24gfSBmcm9tICcuL3NlY3Rpb24nO1xuXG5leHBvcnQgZnVuY3Rpb24gZmluZE1hcHBpbmdzKGluc3BlY3RvcjogU3RhY2tJbnNwZWN0b3IsIGxvZ2ljYWxJZDogc3RyaW5nLCBwcm9wczogYW55ID0ge30pOiB7IFtrZXk6IHN0cmluZ106IHsgW2tleTogc3RyaW5nXTogYW55IH0gfSB7XG4gIGNvbnN0IHNlY3Rpb246IHsgW2tleTogc3RyaW5nXSA6IHt9IH0gPSBpbnNwZWN0b3IudmFsdWUuTWFwcGluZ3M7XG4gIGNvbnN0IHJlc3VsdCA9IG1hdGNoU2VjdGlvbihmaWx0ZXJMb2dpY2FsSWQoc2VjdGlvbiwgbG9naWNhbElkKSwgcHJvcHMpO1xuXG4gIGlmICghcmVzdWx0Lm1hdGNoKSB7XG4gICAgcmV0dXJuIHt9O1xuICB9XG5cbiAgcmV0dXJuIHJlc3VsdC5tYXRjaGVzO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaGFzTWFwcGluZyhpbnNwZWN0b3I6IFN0YWNrSW5zcGVjdG9yLCBsb2dpY2FsSWQ6IHN0cmluZywgcHJvcHM6IGFueSk6IHN0cmluZyB8IHZvaWQge1xuICBjb25zdCBzZWN0aW9uOiB7IFtrZXk6IHN0cmluZ106IHt9IH0gPSBpbnNwZWN0b3IudmFsdWUuTWFwcGluZ3M7XG4gIGNvbnN0IHJlc3VsdCA9IG1hdGNoU2VjdGlvbihmaWx0ZXJMb2dpY2FsSWQoc2VjdGlvbiwgbG9naWNhbElkKSwgcHJvcHMpO1xuXG4gIGlmIChyZXN1bHQubWF0Y2gpIHtcbiAgICByZXR1cm47XG4gIH1cblxuICBpZiAocmVzdWx0LmNsb3Nlc3RSZXN1bHQgPT09IHVuZGVmaW5lZCkge1xuICAgIHJldHVybiAnTm8gbWFwcGluZ3MgZm91bmQgaW4gdGhlIHRlbXBsYXRlJztcbiAgfVxuXG4gIHJldHVybiBbXG4gICAgYFRlbXBsYXRlIGhhcyAke3Jlc3VsdC5hbmFseXplZENvdW50fSBtYXBwaW5ncywgYnV0IG5vbmUgbWF0Y2ggYXMgZXhwZWN0ZWQuYCxcbiAgICBmb3JtYXRGYWlsdXJlKHJlc3VsdC5jbG9zZXN0UmVzdWx0KSxcbiAgXS5qb2luKCdcXG4nKTtcbn0iXX0=