"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasResource = exports.findResources = void 0;
const section_1 = require("./section");
function findResources(inspector, type, props = {}) {
    const section = inspector.value.Resources;
    const result = section_1.matchSection(filterType(section, type), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findResources = findResources;
function hasResource(inspector, type, props) {
    const section = inspector.value.Resources;
    const result = section_1.matchSection(filterType(section, type), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return `No resource with type ${type} found`;
    }
    return [
        `Template has ${result.analyzedCount} resources with type ${type}, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasResource = hasResource;
function filterType(section, type) {
    return Object.entries(section !== null && section !== void 0 ? section : {})
        .filter(([_, v]) => v.Type === type)
        .reduce((agg, [k, v]) => { return { ...agg, [k]: v }; }, {});
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzb3VyY2VzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicmVzb3VyY2VzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHVDQUF3RDtBQU94RCxTQUFnQixhQUFhLENBQUMsU0FBeUIsRUFBRSxJQUFZLEVBQUUsUUFBYSxFQUFFO0lBQ3BGLE1BQU0sT0FBTyxHQUFpQyxTQUFTLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQztJQUN4RSxNQUFNLE1BQU0sR0FBRyxzQkFBWSxDQUFDLFVBQVUsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFFOUQsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUU7UUFDakIsT0FBTyxFQUFFLENBQUM7S0FDWDtJQUVELE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQztBQUN4QixDQUFDO0FBVEQsc0NBU0M7QUFFRCxTQUFnQixXQUFXLENBQUMsU0FBeUIsRUFBRSxJQUFZLEVBQUUsS0FBVTtJQUM3RSxNQUFNLE9BQU8sR0FBZ0MsU0FBUyxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUM7SUFDdkUsTUFBTSxNQUFNLEdBQUcsc0JBQVksQ0FBQyxVQUFVLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxFQUFFLEtBQUssQ0FBQyxDQUFDO0lBRTlELElBQUksTUFBTSxDQUFDLEtBQUssRUFBRTtRQUNoQixPQUFPO0tBQ1I7SUFFRCxJQUFJLE1BQU0sQ0FBQyxhQUFhLEtBQUssU0FBUyxFQUFFO1FBQ3RDLE9BQU8seUJBQXlCLElBQUksUUFBUSxDQUFDO0tBQzlDO0lBRUQsT0FBTztRQUNMLGdCQUFnQixNQUFNLENBQUMsYUFBYSx3QkFBd0IsSUFBSSwrQkFBK0I7UUFDL0YsdUJBQWEsQ0FBQyxNQUFNLENBQUMsYUFBYSxDQUFDO0tBQ3BDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO0FBQ2YsQ0FBQztBQWhCRCxrQ0FnQkM7QUFFRCxTQUFTLFVBQVUsQ0FBQyxPQUFvQyxFQUFFLElBQVk7SUFDcEUsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE9BQU8sYUFBUCxPQUFPLGNBQVAsT0FBTyxHQUFJLEVBQUUsQ0FBQztTQUNqQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLElBQUksS0FBSyxJQUFJLENBQUM7U0FDbkMsTUFBTSxDQUFDLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLEVBQUUsR0FBRyxPQUFPLEVBQUUsR0FBRyxHQUFHLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUNqRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU3RhY2tJbnNwZWN0b3IgfSBmcm9tICcuLi92ZW5kb3JlZC9hc3NlcnQnO1xuaW1wb3J0IHsgZm9ybWF0RmFpbHVyZSwgbWF0Y2hTZWN0aW9uIH0gZnJvbSAnLi9zZWN0aW9uJztcblxuLy8gUGFydGlhbCB0eXBlIGZvciBDbG91ZEZvcm1hdGlvbiBSZXNvdXJjZVxudHlwZSBSZXNvdXJjZSA9IHtcbiAgVHlwZTogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZmluZFJlc291cmNlcyhpbnNwZWN0b3I6IFN0YWNrSW5zcGVjdG9yLCB0eXBlOiBzdHJpbmcsIHByb3BzOiBhbnkgPSB7fSk6IHsgW2tleTogc3RyaW5nXTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSB9IHtcbiAgY29uc3Qgc2VjdGlvbjogeyBba2V5OiBzdHJpbmddIDogUmVzb3VyY2UgfSA9IGluc3BlY3Rvci52YWx1ZS5SZXNvdXJjZXM7XG4gIGNvbnN0IHJlc3VsdCA9IG1hdGNoU2VjdGlvbihmaWx0ZXJUeXBlKHNlY3Rpb24sIHR5cGUpLCBwcm9wcyk7XG5cbiAgaWYgKCFyZXN1bHQubWF0Y2gpIHtcbiAgICByZXR1cm4ge307XG4gIH1cblxuICByZXR1cm4gcmVzdWx0Lm1hdGNoZXM7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBoYXNSZXNvdXJjZShpbnNwZWN0b3I6IFN0YWNrSW5zcGVjdG9yLCB0eXBlOiBzdHJpbmcsIHByb3BzOiBhbnkpOiBzdHJpbmcgfCB2b2lkIHtcbiAgY29uc3Qgc2VjdGlvbjogeyBba2V5OiBzdHJpbmddOiBSZXNvdXJjZSB9ID0gaW5zcGVjdG9yLnZhbHVlLlJlc291cmNlcztcbiAgY29uc3QgcmVzdWx0ID0gbWF0Y2hTZWN0aW9uKGZpbHRlclR5cGUoc2VjdGlvbiwgdHlwZSksIHByb3BzKTtcblxuICBpZiAocmVzdWx0Lm1hdGNoKSB7XG4gICAgcmV0dXJuO1xuICB9XG5cbiAgaWYgKHJlc3VsdC5jbG9zZXN0UmVzdWx0ID09PSB1bmRlZmluZWQpIHtcbiAgICByZXR1cm4gYE5vIHJlc291cmNlIHdpdGggdHlwZSAke3R5cGV9IGZvdW5kYDtcbiAgfVxuXG4gIHJldHVybiBbXG4gICAgYFRlbXBsYXRlIGhhcyAke3Jlc3VsdC5hbmFseXplZENvdW50fSByZXNvdXJjZXMgd2l0aCB0eXBlICR7dHlwZX0sIGJ1dCBub25lIG1hdGNoIGFzIGV4cGVjdGVkLmAsXG4gICAgZm9ybWF0RmFpbHVyZShyZXN1bHQuY2xvc2VzdFJlc3VsdCksXG4gIF0uam9pbignXFxuJyk7XG59XG5cbmZ1bmN0aW9uIGZpbHRlclR5cGUoc2VjdGlvbjogeyBba2V5OiBzdHJpbmddOiBSZXNvdXJjZSB9LCB0eXBlOiBzdHJpbmcpOiB7IFtrZXk6IHN0cmluZ106IFJlc291cmNlIH0ge1xuICByZXR1cm4gT2JqZWN0LmVudHJpZXMoc2VjdGlvbiA/PyB7fSlcbiAgICAuZmlsdGVyKChbXywgdl0pID0+IHYuVHlwZSA9PT0gdHlwZSlcbiAgICAucmVkdWNlKChhZ2csIFtrLCB2XSkgPT4geyByZXR1cm4geyAuLi5hZ2csIFtrXTogdiB9OyB9LCB7fSk7XG59Il19