<h1 align = "center">:rocket: AppZoo :facepunch:</h1>

---

## Install
```bash
pip install -U appzoo
```
## Usage
- Rest Api
```python
import jieba
from appzoo import App

pred1 = lambda **kwargs: kwargs['x'] + kwargs['y']
pred2 = lambda x=1, y=1: x - y
pred3 = lambda text='小米是家不错的公司': jieba.lcut(text)

app = App(verbose=True)
app.add_route("/", pred1, result_key='result')
app.add_route("/f1", pred1, version="1")
app.add_route("/f2", pred2, version="2")
app.add_route("/f3", pred3, version="3")

app.run()
```

- FastApi
```bash
app-run - fastapi demo.py
app-run - fastapi -- --help

```

- Streamlit App
```bash
app-run - streamlit demo.py
app-run - streamlit -- --help
```

---
## TODO
- add logger
- add scheduler
