"""add tables

Revision ID: e077a31ad00b
Revises: 4398f463d243
Create Date: 2021-09-22 14:28:11.609615

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'e077a31ad00b'
down_revision = '4398f463d243'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('field',
    sa.Column('field_id', sa.Integer(), nullable=False),
    sa.Column('name', sa.UnicodeText(), nullable=False),
    sa.Column('type_', sa.Enum('UnicodeText', 'Boolean', 'Int', 'Float', 'Date', 'DateTime', 'Time', name='fieldtype'), nullable=False),
    sa.PrimaryKeyConstraint('field_id', name=op.f('pk_field'))
    )
    op.create_table('type_field_association',
    sa.Column('type_id', sa.Integer(), nullable=False),
    sa.Column('field_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['field_id'], ['field.field_id'], name=op.f('fk_type_field_association_field_id_field')),
    sa.ForeignKeyConstraint(['type_id'], ['product_types.type_id'], name=op.f('fk_type_field_association_type_id_product_types')),
    sa.PrimaryKeyConstraint('type_id', 'field_id', name=op.f('pk_type_field_association'))
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('type_field_association')
    op.drop_table('field')
    # ### end Alembic commands ###
