"""add column to attribute tables

Revision ID: e58cc402c887
Revises: 0ff075f16b94
Create Date: 2021-11-03 16:32:18.594542

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'e58cc402c887'
down_revision = '0ff075f16b94'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('attribute_boolean', schema=None) as batch_op:
        batch_op.add_column(sa.Column('type_field_association_iid', sa.Integer(), nullable=True))
        batch_op.create_foreign_key(batch_op.f('fk_attribute_boolean_type_field_association_iid_type_field_association'), 'type_field_association', ['type_field_association_iid'], ['iid'])

    with op.batch_alter_table('attribute_date', schema=None) as batch_op:
        batch_op.add_column(sa.Column('type_field_association_iid', sa.Integer(), nullable=True))
        batch_op.create_foreign_key(batch_op.f('fk_attribute_date_type_field_association_iid_type_field_association'), 'type_field_association', ['type_field_association_iid'], ['iid'])

    with op.batch_alter_table('attribute_date_time', schema=None) as batch_op:
        batch_op.add_column(sa.Column('type_field_association_iid', sa.Integer(), nullable=True))
        batch_op.create_foreign_key(batch_op.f('fk_attribute_date_time_type_field_association_iid_type_field_association'), 'type_field_association', ['type_field_association_iid'], ['iid'])

    with op.batch_alter_table('attribute_float', schema=None) as batch_op:
        batch_op.add_column(sa.Column('type_field_association_iid', sa.Integer(), nullable=True))
        batch_op.create_foreign_key(batch_op.f('fk_attribute_float_type_field_association_iid_type_field_association'), 'type_field_association', ['type_field_association_iid'], ['iid'])

    with op.batch_alter_table('attribute_integer', schema=None) as batch_op:
        batch_op.add_column(sa.Column('type_field_association_iid', sa.Integer(), nullable=True))
        batch_op.create_foreign_key(batch_op.f('fk_attribute_integer_type_field_association_iid_type_field_association'), 'type_field_association', ['type_field_association_iid'], ['iid'])

    with op.batch_alter_table('attribute_time', schema=None) as batch_op:
        batch_op.add_column(sa.Column('type_field_association_iid', sa.Integer(), nullable=True))
        batch_op.create_foreign_key(batch_op.f('fk_attribute_time_type_field_association_iid_type_field_association'), 'type_field_association', ['type_field_association_iid'], ['iid'])

    with op.batch_alter_table('attribute_unicode_text', schema=None) as batch_op:
        batch_op.add_column(sa.Column('type_field_association_iid', sa.Integer(), nullable=True))
        batch_op.create_foreign_key(batch_op.f('fk_attribute_unicode_text_type_field_association_iid_type_field_association'), 'type_field_association', ['type_field_association_iid'], ['iid'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('attribute_unicode_text', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_attribute_unicode_text_type_field_association_iid_type_field_association'), type_='foreignkey')
        batch_op.drop_column('type_field_association_iid')

    with op.batch_alter_table('attribute_time', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_attribute_time_type_field_association_iid_type_field_association'), type_='foreignkey')
        batch_op.drop_column('type_field_association_iid')

    with op.batch_alter_table('attribute_integer', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_attribute_integer_type_field_association_iid_type_field_association'), type_='foreignkey')
        batch_op.drop_column('type_field_association_iid')

    with op.batch_alter_table('attribute_float', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_attribute_float_type_field_association_iid_type_field_association'), type_='foreignkey')
        batch_op.drop_column('type_field_association_iid')

    with op.batch_alter_table('attribute_date_time', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_attribute_date_time_type_field_association_iid_type_field_association'), type_='foreignkey')
        batch_op.drop_column('type_field_association_iid')

    with op.batch_alter_table('attribute_date', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_attribute_date_type_field_association_iid_type_field_association'), type_='foreignkey')
        batch_op.drop_column('type_field_association_iid')

    with op.batch_alter_table('attribute_boolean', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_attribute_boolean_type_field_association_iid_type_field_association'), type_='foreignkey')
        batch_op.drop_column('type_field_association_iid')

    # ### end Alembic commands ###
