"""update type_field_association

Revision ID: f84493df4297
Revises: 6bd27755b1a8
Create Date: 2021-11-02 16:07:32.303654

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'f84493df4297'
down_revision = '6bd27755b1a8'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('type_field_association', schema=None) as batch_op:
        batch_op.add_column(sa.Column('iid', sa.Integer(), nullable=False))
        batch_op.alter_column('type_id',
               existing_type=sa.INTEGER(),
               nullable=True)
        batch_op.drop_constraint('pk_type_field_association', type_='primary')
        batch_op.create_unique_constraint('_type_field', ['type_id', 'field_id'])
        batch_op.create_primary_key('pk_type_field_association', ['iid'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('type_field_association', schema=None) as batch_op:
        batch_op.drop_constraint('_type_field', type_='unique')
        batch_op.alter_column('type_id',
               existing_type=sa.INTEGER(),
               nullable=False)
        batch_op.drop_column('iid')
        batch_op.drop_constraint('pk_type_field_association', type_='primary')
        batch_op.create_primary_key('pk_type_field_association', ['type_id', 'field_id'])

    # ### end Alembic commands ###
