# zanon

A module to anonymize data streams with zero-delay called z-anonymity.

When instantiating the *zanonymity* object the constructor receives a value in seconds for **Delta_t** and a value for **z**.

The *anonymize()* method accepts a string in the form of a triple **(t,u,a)** - meaning that at time **t** a user **u** exposes an attribute **a** - and a file object. 

If the triple exposes an attribute that has not been exposed by other **z - 1** users in the past **Delta_t** the triple is simply ignored. Otherwise, the triple is printed with the file object.

The algorithm can handle generalization when providing the attribute with a hierarchy using \* as separator (*max_generalization\*...\*min_generalization\*attribute*).
Whenever is not possibile to release the attribute the algorithm will look for the most specific generalization exposed by **z - 1** users in the past **Delta_t**. If none is found, nothing is print out.

## example of usage
```python
from zanonymity import zanon

file_in = "trace.txt"
deltat = 3600 #in seconds
z = 20

z = zanon.zanon(deltat,z)
file_out = open('simulation_output.txt', 'w+')

for line in open(file_in, 'r'):
	z.anonymize(line,file_out)

f.close()
```
