# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Servicev1']


class Servicev1(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1AclArgs']]]]] = None,
                 activate: Optional[pulumi.Input[bool]] = None,
                 backends: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BackendArgs']]]]] = None,
                 bigqueryloggings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BigqueryloggingArgs']]]]] = None,
                 blobstorageloggings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BlobstorageloggingArgs']]]]] = None,
                 cache_settings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1CacheSettingArgs']]]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1ConditionArgs']]]]] = None,
                 default_host: Optional[pulumi.Input[str]] = None,
                 default_ttl: Optional[pulumi.Input[float]] = None,
                 dictionaries: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DictionaryArgs']]]]] = None,
                 directors: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DirectorArgs']]]]] = None,
                 domains: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DomainArgs']]]]] = None,
                 dynamicsnippets: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DynamicsnippetArgs']]]]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 gcsloggings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1GcsloggingArgs']]]]] = None,
                 gzips: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1GzipArgs']]]]] = None,
                 headers: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HeaderArgs']]]]] = None,
                 healthchecks: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HealthcheckArgs']]]]] = None,
                 httpsloggings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HttpsloggingArgs']]]]] = None,
                 logentries: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LogentryArgs']]]]] = None,
                 logging_cloudfiles: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingCloudfileArgs']]]]] = None,
                 logging_datadogs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingDatadogArgs']]]]] = None,
                 logging_digitaloceans: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingDigitaloceanArgs']]]]] = None,
                 logging_elasticsearches: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingElasticsearchArgs']]]]] = None,
                 logging_ftps: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingFtpArgs']]]]] = None,
                 logging_googlepubsubs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingGooglepubsubArgs']]]]] = None,
                 logging_heroku: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingHerokuArgs']]]]] = None,
                 logging_honeycombs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingHoneycombArgs']]]]] = None,
                 logging_kafkas: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingKafkaArgs']]]]] = None,
                 logging_logglies: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingLogglyArgs']]]]] = None,
                 logging_logshuttles: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingLogshuttleArgs']]]]] = None,
                 logging_newrelics: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingNewrelicArgs']]]]] = None,
                 logging_openstacks: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingOpenstackArgs']]]]] = None,
                 logging_scalyrs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingScalyrArgs']]]]] = None,
                 logging_sftps: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingSftpArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 papertrails: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1PapertrailArgs']]]]] = None,
                 request_settings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1RequestSettingArgs']]]]] = None,
                 response_objects: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1ResponseObjectArgs']]]]] = None,
                 s3loggings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1S3loggingArgs']]]]] = None,
                 snippets: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SnippetArgs']]]]] = None,
                 splunks: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SplunkArgs']]]]] = None,
                 sumologics: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SumologicArgs']]]]] = None,
                 syslogs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SyslogArgs']]]]] = None,
                 vcls: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1VclArgs']]]]] = None,
                 version_comment: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Fastly Service, representing the configuration for a website, app,
        API, or anything else to be served through Fastly. A Service encompasses Domains
        and Backends.

        The Service resource requires a domain name that is correctly set up to direct
        traffic to the Fastly service. See Fastly's guide on [Adding CNAME Records][fastly-cname]
        on their documentation site for guidance.

        ## Example Usage
        ### Basic usage

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo = fastly.Servicev1("demo",
            backends=[fastly.Servicev1BackendArgs(
                address="127.0.0.1",
                name="localhost",
                port=80,
            )],
            domains=[fastly.Servicev1DomainArgs(
                comment="demo",
                name="demo.notexample.com",
            )],
            force_destroy=True)
        ```
        ### Basic usage with custom VCL:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo = fastly.Servicev1("demo",
            backends=[fastly.Servicev1BackendArgs(
                address="127.0.0.1",
                name="localhost",
                port=80,
            )],
            domains=[fastly.Servicev1DomainArgs(
                comment="demo",
                name="demo.notexample.com",
            )],
            force_destroy=True,
            vcls=[
                fastly.Servicev1VclArgs(
                    content=(lambda path: open(path).read())(f"{path['module']}/my_custom_main.vcl"),
                    main=True,
                    name="my_custom_main_vcl",
                ),
                fastly.Servicev1VclArgs(
                    content=(lambda path: open(path).read())(f"{path['module']}/my_custom_library.vcl"),
                    name="my_custom_library_vcl",
                ),
            ])
        ```
        ### Basic usage with custom Director

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo = fastly.Servicev1("demo",
            backends=[
                fastly.Servicev1BackendArgs(
                    address="127.0.0.1",
                    name="origin1",
                    port=80,
                ),
                fastly.Servicev1BackendArgs(
                    address="127.0.0.2",
                    name="origin2",
                    port=80,
                ),
            ],
            directors=[fastly.Servicev1DirectorArgs(
                backends=[
                    "origin1",
                    "origin2",
                ],
                name="mydirector",
                quorum=0,
                type=3,
            )],
            domains=[fastly.Servicev1DomainArgs(
                comment="demo",
                name="demo.notexample.com",
            )],
            force_destroy=True)
        ```

        > **Note:** For an AWS S3 Bucket, the Backend address is
        `<domain>.s3-website-<region>.amazonaws.com`. The `default_host` attribute
        should be set to `<bucket_name>.s3-website-<region>.amazonaws.com`. See the
        Fastly documentation on [Amazon S3][fastly-s3].

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1AclArgs']]]] acls: A set of ACL configuration blocks.  Defined below.
        :param pulumi.Input[bool] activate: Conditionally prevents the Service from being activated. The apply step will continue to create a new draft version but will not activate it if this is set to false. Default true.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BackendArgs']]]] backends: A set of Backends to service requests from your Domains.
               Defined below. Backends must be defined in this argument, or defined in the
               `vcl` argument below
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BigqueryloggingArgs']]]] bigqueryloggings: A BigQuery endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BlobstorageloggingArgs']]]] blobstorageloggings: An Azure Blob Storage endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1CacheSettingArgs']]]] cache_settings: A set of Cache Settings, allowing you to override
        :param pulumi.Input[str] comment: An optional comment about the Director.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1ConditionArgs']]]] conditions: A set of conditions to add logic to any basic
               configuration object in this service. Defined below.
        :param pulumi.Input[str] default_host: Sets the host header.
        :param pulumi.Input[float] default_ttl: The default Time-to-live (TTL) for
               requests.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DictionaryArgs']]]] dictionaries: A set of dictionaries that allow the storing of key values pair for use within VCL functions. Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DirectorArgs']]]] directors: A director to allow more control over balancing traffic over backends.
               when an item is not to be cached based on an above `condition`. Defined below
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DomainArgs']]]] domains: The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DynamicsnippetArgs']]]] dynamicsnippets: A set of custom, "dynamic" VCL Snippet configuration blocks.  Defined below.
        :param pulumi.Input[bool] force_destroy: Services that are active cannot be destroyed. In
               order to destroy the Service, set `force_destroy` to `true`. Default `false`.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1GcsloggingArgs']]]] gcsloggings: A gcs endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1GzipArgs']]]] gzips: A set of gzip rules to control automatic gzipping of
               content. Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HeaderArgs']]]] headers: A set of Headers to manipulate for each request. Defined
               below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HealthcheckArgs']]]] healthchecks: Name of a defined `healthcheck` to assign to this backend.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HttpsloggingArgs']]]] httpsloggings: An HTTPS endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LogentryArgs']]]] logentries: A logentries endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingCloudfileArgs']]]] logging_cloudfiles: A Rackspace Cloud Files endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingDatadogArgs']]]] logging_datadogs: A Datadog endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingDigitaloceanArgs']]]] logging_digitaloceans: A DigitalOcean Spaces endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingElasticsearchArgs']]]] logging_elasticsearches: An Elasticsearch endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingFtpArgs']]]] logging_ftps: An FTP endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingGooglepubsubArgs']]]] logging_googlepubsubs: A Google Cloud Pub/Sub endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingHerokuArgs']]]] logging_heroku: A Heroku endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingHoneycombArgs']]]] logging_honeycombs: A Honeycomb endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingKafkaArgs']]]] logging_kafkas: A Kafka endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingLogglyArgs']]]] logging_logglies: A Loggly endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingLogshuttleArgs']]]] logging_logshuttles: A Log Shuttle endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingNewrelicArgs']]]] logging_newrelics: A New Relic endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingOpenstackArgs']]]] logging_openstacks: An OpenStack endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingScalyrArgs']]]] logging_scalyrs: A Scalyr endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingSftpArgs']]]] logging_sftps: An SFTP endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[str] name: A unique name to identify this dictionary.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1PapertrailArgs']]]] papertrails: A Papertrail endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1RequestSettingArgs']]]] request_settings: A set of Request modifiers. Defined below
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1ResponseObjectArgs']]]] response_objects: Allows you to create synthetic responses that exist entirely on the varnish machine. Useful for creating error or maintenance pages that exists outside the scope of your datacenter. Best when used with Condition objects.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1S3loggingArgs']]]] s3loggings: A set of S3 Buckets to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SnippetArgs']]]] snippets: A set of custom, "regular" (non-dynamic) VCL Snippet configuration blocks.  Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SplunkArgs']]]] splunks: A Splunk endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SumologicArgs']]]] sumologics: A Sumologic endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SyslogArgs']]]] syslogs: A syslog endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1VclArgs']]]] vcls: A set of custom VCL configuration blocks. See the [Fastly documentation](https://docs.fastly.com/vcl/custom-vcl/uploading-custom-vcl/) for more information on using custom VCL.
        :param pulumi.Input[str] version_comment: Description field for the version.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acls'] = acls
            __props__['activate'] = activate
            __props__['backends'] = backends
            __props__['bigqueryloggings'] = bigqueryloggings
            __props__['blobstorageloggings'] = blobstorageloggings
            __props__['cache_settings'] = cache_settings
            __props__['comment'] = comment
            __props__['conditions'] = conditions
            __props__['default_host'] = default_host
            __props__['default_ttl'] = default_ttl
            __props__['dictionaries'] = dictionaries
            __props__['directors'] = directors
            if domains is None:
                raise TypeError("Missing required property 'domains'")
            __props__['domains'] = domains
            __props__['dynamicsnippets'] = dynamicsnippets
            __props__['force_destroy'] = force_destroy
            __props__['gcsloggings'] = gcsloggings
            __props__['gzips'] = gzips
            __props__['headers'] = headers
            __props__['healthchecks'] = healthchecks
            __props__['httpsloggings'] = httpsloggings
            __props__['logentries'] = logentries
            __props__['logging_cloudfiles'] = logging_cloudfiles
            __props__['logging_datadogs'] = logging_datadogs
            __props__['logging_digitaloceans'] = logging_digitaloceans
            __props__['logging_elasticsearches'] = logging_elasticsearches
            __props__['logging_ftps'] = logging_ftps
            __props__['logging_googlepubsubs'] = logging_googlepubsubs
            __props__['logging_heroku'] = logging_heroku
            __props__['logging_honeycombs'] = logging_honeycombs
            __props__['logging_kafkas'] = logging_kafkas
            __props__['logging_logglies'] = logging_logglies
            __props__['logging_logshuttles'] = logging_logshuttles
            __props__['logging_newrelics'] = logging_newrelics
            __props__['logging_openstacks'] = logging_openstacks
            __props__['logging_scalyrs'] = logging_scalyrs
            __props__['logging_sftps'] = logging_sftps
            __props__['name'] = name
            __props__['papertrails'] = papertrails
            __props__['request_settings'] = request_settings
            __props__['response_objects'] = response_objects
            __props__['s3loggings'] = s3loggings
            __props__['snippets'] = snippets
            __props__['splunks'] = splunks
            __props__['sumologics'] = sumologics
            __props__['syslogs'] = syslogs
            __props__['vcls'] = vcls
            __props__['version_comment'] = version_comment
            __props__['active_version'] = None
            __props__['cloned_version'] = None
        super(Servicev1, __self__).__init__(
            'fastly:index/servicev1:Servicev1',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acls: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1AclArgs']]]]] = None,
            activate: Optional[pulumi.Input[bool]] = None,
            active_version: Optional[pulumi.Input[float]] = None,
            backends: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BackendArgs']]]]] = None,
            bigqueryloggings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BigqueryloggingArgs']]]]] = None,
            blobstorageloggings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BlobstorageloggingArgs']]]]] = None,
            cache_settings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1CacheSettingArgs']]]]] = None,
            cloned_version: Optional[pulumi.Input[float]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            conditions: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1ConditionArgs']]]]] = None,
            default_host: Optional[pulumi.Input[str]] = None,
            default_ttl: Optional[pulumi.Input[float]] = None,
            dictionaries: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DictionaryArgs']]]]] = None,
            directors: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DirectorArgs']]]]] = None,
            domains: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DomainArgs']]]]] = None,
            dynamicsnippets: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DynamicsnippetArgs']]]]] = None,
            force_destroy: Optional[pulumi.Input[bool]] = None,
            gcsloggings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1GcsloggingArgs']]]]] = None,
            gzips: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1GzipArgs']]]]] = None,
            headers: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HeaderArgs']]]]] = None,
            healthchecks: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HealthcheckArgs']]]]] = None,
            httpsloggings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HttpsloggingArgs']]]]] = None,
            logentries: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LogentryArgs']]]]] = None,
            logging_cloudfiles: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingCloudfileArgs']]]]] = None,
            logging_datadogs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingDatadogArgs']]]]] = None,
            logging_digitaloceans: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingDigitaloceanArgs']]]]] = None,
            logging_elasticsearches: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingElasticsearchArgs']]]]] = None,
            logging_ftps: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingFtpArgs']]]]] = None,
            logging_googlepubsubs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingGooglepubsubArgs']]]]] = None,
            logging_heroku: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingHerokuArgs']]]]] = None,
            logging_honeycombs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingHoneycombArgs']]]]] = None,
            logging_kafkas: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingKafkaArgs']]]]] = None,
            logging_logglies: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingLogglyArgs']]]]] = None,
            logging_logshuttles: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingLogshuttleArgs']]]]] = None,
            logging_newrelics: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingNewrelicArgs']]]]] = None,
            logging_openstacks: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingOpenstackArgs']]]]] = None,
            logging_scalyrs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingScalyrArgs']]]]] = None,
            logging_sftps: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingSftpArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            papertrails: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1PapertrailArgs']]]]] = None,
            request_settings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1RequestSettingArgs']]]]] = None,
            response_objects: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1ResponseObjectArgs']]]]] = None,
            s3loggings: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1S3loggingArgs']]]]] = None,
            snippets: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SnippetArgs']]]]] = None,
            splunks: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SplunkArgs']]]]] = None,
            sumologics: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SumologicArgs']]]]] = None,
            syslogs: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SyslogArgs']]]]] = None,
            vcls: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1VclArgs']]]]] = None,
            version_comment: Optional[pulumi.Input[str]] = None) -> 'Servicev1':
        """
        Get an existing Servicev1 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1AclArgs']]]] acls: A set of ACL configuration blocks.  Defined below.
        :param pulumi.Input[bool] activate: Conditionally prevents the Service from being activated. The apply step will continue to create a new draft version but will not activate it if this is set to false. Default true.
        :param pulumi.Input[float] active_version: The currently active version of your Fastly Service.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BackendArgs']]]] backends: A set of Backends to service requests from your Domains.
               Defined below. Backends must be defined in this argument, or defined in the
               `vcl` argument below
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BigqueryloggingArgs']]]] bigqueryloggings: A BigQuery endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1BlobstorageloggingArgs']]]] blobstorageloggings: An Azure Blob Storage endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1CacheSettingArgs']]]] cache_settings: A set of Cache Settings, allowing you to override
        :param pulumi.Input[float] cloned_version: The latest cloned version by the provider. The value gets only set after running `pulumi up`.
        :param pulumi.Input[str] comment: An optional comment about the Director.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1ConditionArgs']]]] conditions: A set of conditions to add logic to any basic
               configuration object in this service. Defined below.
        :param pulumi.Input[str] default_host: Sets the host header.
        :param pulumi.Input[float] default_ttl: The default Time-to-live (TTL) for
               requests.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DictionaryArgs']]]] dictionaries: A set of dictionaries that allow the storing of key values pair for use within VCL functions. Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DirectorArgs']]]] directors: A director to allow more control over balancing traffic over backends.
               when an item is not to be cached based on an above `condition`. Defined below
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DomainArgs']]]] domains: The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1DynamicsnippetArgs']]]] dynamicsnippets: A set of custom, "dynamic" VCL Snippet configuration blocks.  Defined below.
        :param pulumi.Input[bool] force_destroy: Services that are active cannot be destroyed. In
               order to destroy the Service, set `force_destroy` to `true`. Default `false`.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1GcsloggingArgs']]]] gcsloggings: A gcs endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1GzipArgs']]]] gzips: A set of gzip rules to control automatic gzipping of
               content. Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HeaderArgs']]]] headers: A set of Headers to manipulate for each request. Defined
               below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HealthcheckArgs']]]] healthchecks: Name of a defined `healthcheck` to assign to this backend.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1HttpsloggingArgs']]]] httpsloggings: An HTTPS endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LogentryArgs']]]] logentries: A logentries endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingCloudfileArgs']]]] logging_cloudfiles: A Rackspace Cloud Files endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingDatadogArgs']]]] logging_datadogs: A Datadog endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingDigitaloceanArgs']]]] logging_digitaloceans: A DigitalOcean Spaces endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingElasticsearchArgs']]]] logging_elasticsearches: An Elasticsearch endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingFtpArgs']]]] logging_ftps: An FTP endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingGooglepubsubArgs']]]] logging_googlepubsubs: A Google Cloud Pub/Sub endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingHerokuArgs']]]] logging_heroku: A Heroku endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingHoneycombArgs']]]] logging_honeycombs: A Honeycomb endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingKafkaArgs']]]] logging_kafkas: A Kafka endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingLogglyArgs']]]] logging_logglies: A Loggly endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingLogshuttleArgs']]]] logging_logshuttles: A Log Shuttle endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingNewrelicArgs']]]] logging_newrelics: A New Relic endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingOpenstackArgs']]]] logging_openstacks: An OpenStack endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingScalyrArgs']]]] logging_scalyrs: A Scalyr endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1LoggingSftpArgs']]]] logging_sftps: An SFTP endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[str] name: A unique name to identify this dictionary.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1PapertrailArgs']]]] papertrails: A Papertrail endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1RequestSettingArgs']]]] request_settings: A set of Request modifiers. Defined below
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1ResponseObjectArgs']]]] response_objects: Allows you to create synthetic responses that exist entirely on the varnish machine. Useful for creating error or maintenance pages that exists outside the scope of your datacenter. Best when used with Condition objects.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1S3loggingArgs']]]] s3loggings: A set of S3 Buckets to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SnippetArgs']]]] snippets: A set of custom, "regular" (non-dynamic) VCL Snippet configuration blocks.  Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SplunkArgs']]]] splunks: A Splunk endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SumologicArgs']]]] sumologics: A Sumologic endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1SyslogArgs']]]] syslogs: A syslog endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['Servicev1VclArgs']]]] vcls: A set of custom VCL configuration blocks. See the [Fastly documentation](https://docs.fastly.com/vcl/custom-vcl/uploading-custom-vcl/) for more information on using custom VCL.
        :param pulumi.Input[str] version_comment: Description field for the version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acls"] = acls
        __props__["activate"] = activate
        __props__["active_version"] = active_version
        __props__["backends"] = backends
        __props__["bigqueryloggings"] = bigqueryloggings
        __props__["blobstorageloggings"] = blobstorageloggings
        __props__["cache_settings"] = cache_settings
        __props__["cloned_version"] = cloned_version
        __props__["comment"] = comment
        __props__["conditions"] = conditions
        __props__["default_host"] = default_host
        __props__["default_ttl"] = default_ttl
        __props__["dictionaries"] = dictionaries
        __props__["directors"] = directors
        __props__["domains"] = domains
        __props__["dynamicsnippets"] = dynamicsnippets
        __props__["force_destroy"] = force_destroy
        __props__["gcsloggings"] = gcsloggings
        __props__["gzips"] = gzips
        __props__["headers"] = headers
        __props__["healthchecks"] = healthchecks
        __props__["httpsloggings"] = httpsloggings
        __props__["logentries"] = logentries
        __props__["logging_cloudfiles"] = logging_cloudfiles
        __props__["logging_datadogs"] = logging_datadogs
        __props__["logging_digitaloceans"] = logging_digitaloceans
        __props__["logging_elasticsearches"] = logging_elasticsearches
        __props__["logging_ftps"] = logging_ftps
        __props__["logging_googlepubsubs"] = logging_googlepubsubs
        __props__["logging_heroku"] = logging_heroku
        __props__["logging_honeycombs"] = logging_honeycombs
        __props__["logging_kafkas"] = logging_kafkas
        __props__["logging_logglies"] = logging_logglies
        __props__["logging_logshuttles"] = logging_logshuttles
        __props__["logging_newrelics"] = logging_newrelics
        __props__["logging_openstacks"] = logging_openstacks
        __props__["logging_scalyrs"] = logging_scalyrs
        __props__["logging_sftps"] = logging_sftps
        __props__["name"] = name
        __props__["papertrails"] = papertrails
        __props__["request_settings"] = request_settings
        __props__["response_objects"] = response_objects
        __props__["s3loggings"] = s3loggings
        __props__["snippets"] = snippets
        __props__["splunks"] = splunks
        __props__["sumologics"] = sumologics
        __props__["syslogs"] = syslogs
        __props__["vcls"] = vcls
        __props__["version_comment"] = version_comment
        return Servicev1(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acls(self) -> pulumi.Output[Optional[List['outputs.Servicev1Acl']]]:
        """
        A set of ACL configuration blocks.  Defined below.
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter
    def activate(self) -> pulumi.Output[Optional[bool]]:
        """
        Conditionally prevents the Service from being activated. The apply step will continue to create a new draft version but will not activate it if this is set to false. Default true.
        """
        return pulumi.get(self, "activate")

    @property
    @pulumi.getter(name="activeVersion")
    def active_version(self) -> pulumi.Output[float]:
        """
        The currently active version of your Fastly Service.
        """
        return pulumi.get(self, "active_version")

    @property
    @pulumi.getter
    def backends(self) -> pulumi.Output[Optional[List['outputs.Servicev1Backend']]]:
        """
        A set of Backends to service requests from your Domains.
        Defined below. Backends must be defined in this argument, or defined in the
        `vcl` argument below
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter
    def bigqueryloggings(self) -> pulumi.Output[Optional[List['outputs.Servicev1Bigquerylogging']]]:
        """
        A BigQuery endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "bigqueryloggings")

    @property
    @pulumi.getter
    def blobstorageloggings(self) -> pulumi.Output[Optional[List['outputs.Servicev1Blobstoragelogging']]]:
        """
        An Azure Blob Storage endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "blobstorageloggings")

    @property
    @pulumi.getter(name="cacheSettings")
    def cache_settings(self) -> pulumi.Output[Optional[List['outputs.Servicev1CacheSetting']]]:
        """
        A set of Cache Settings, allowing you to override
        """
        return pulumi.get(self, "cache_settings")

    @property
    @pulumi.getter(name="clonedVersion")
    def cloned_version(self) -> pulumi.Output[float]:
        """
        The latest cloned version by the provider. The value gets only set after running `pulumi up`.
        """
        return pulumi.get(self, "cloned_version")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        An optional comment about the Director.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[List['outputs.Servicev1Condition']]]:
        """
        A set of conditions to add logic to any basic
        configuration object in this service. Defined below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="defaultHost")
    def default_host(self) -> pulumi.Output[str]:
        """
        Sets the host header.
        """
        return pulumi.get(self, "default_host")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> pulumi.Output[Optional[float]]:
        """
        The default Time-to-live (TTL) for
        requests.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter
    def dictionaries(self) -> pulumi.Output[Optional[List['outputs.Servicev1Dictionary']]]:
        """
        A set of dictionaries that allow the storing of key values pair for use within VCL functions. Defined below.
        """
        return pulumi.get(self, "dictionaries")

    @property
    @pulumi.getter
    def directors(self) -> pulumi.Output[Optional[List['outputs.Servicev1Director']]]:
        """
        A director to allow more control over balancing traffic over backends.
        when an item is not to be cached based on an above `condition`. Defined below
        """
        return pulumi.get(self, "directors")

    @property
    @pulumi.getter
    def domains(self) -> pulumi.Output[List['outputs.Servicev1Domain']]:
        """
        The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def dynamicsnippets(self) -> pulumi.Output[Optional[List['outputs.Servicev1Dynamicsnippet']]]:
        """
        A set of custom, "dynamic" VCL Snippet configuration blocks.  Defined below.
        """
        return pulumi.get(self, "dynamicsnippets")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Services that are active cannot be destroyed. In
        order to destroy the Service, set `force_destroy` to `true`. Default `false`.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def gcsloggings(self) -> pulumi.Output[Optional[List['outputs.Servicev1Gcslogging']]]:
        """
        A gcs endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "gcsloggings")

    @property
    @pulumi.getter
    def gzips(self) -> pulumi.Output[Optional[List['outputs.Servicev1Gzip']]]:
        """
        A set of gzip rules to control automatic gzipping of
        content. Defined below.
        """
        return pulumi.get(self, "gzips")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[List['outputs.Servicev1Header']]]:
        """
        A set of Headers to manipulate for each request. Defined
        below.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def healthchecks(self) -> pulumi.Output[Optional[List['outputs.Servicev1Healthcheck']]]:
        """
        Name of a defined `healthcheck` to assign to this backend.
        """
        return pulumi.get(self, "healthchecks")

    @property
    @pulumi.getter
    def httpsloggings(self) -> pulumi.Output[Optional[List['outputs.Servicev1Httpslogging']]]:
        """
        An HTTPS endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "httpsloggings")

    @property
    @pulumi.getter
    def logentries(self) -> pulumi.Output[Optional[List['outputs.Servicev1Logentry']]]:
        """
        A logentries endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "logentries")

    @property
    @pulumi.getter(name="loggingCloudfiles")
    def logging_cloudfiles(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingCloudfile']]]:
        """
        A Rackspace Cloud Files endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_cloudfiles")

    @property
    @pulumi.getter(name="loggingDatadogs")
    def logging_datadogs(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingDatadog']]]:
        """
        A Datadog endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_datadogs")

    @property
    @pulumi.getter(name="loggingDigitaloceans")
    def logging_digitaloceans(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingDigitalocean']]]:
        """
        A DigitalOcean Spaces endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_digitaloceans")

    @property
    @pulumi.getter(name="loggingElasticsearches")
    def logging_elasticsearches(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingElasticsearch']]]:
        """
        An Elasticsearch endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_elasticsearches")

    @property
    @pulumi.getter(name="loggingFtps")
    def logging_ftps(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingFtp']]]:
        """
        An FTP endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_ftps")

    @property
    @pulumi.getter(name="loggingGooglepubsubs")
    def logging_googlepubsubs(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingGooglepubsub']]]:
        """
        A Google Cloud Pub/Sub endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_googlepubsubs")

    @property
    @pulumi.getter(name="loggingHeroku")
    def logging_heroku(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingHeroku']]]:
        """
        A Heroku endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_heroku")

    @property
    @pulumi.getter(name="loggingHoneycombs")
    def logging_honeycombs(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingHoneycomb']]]:
        """
        A Honeycomb endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_honeycombs")

    @property
    @pulumi.getter(name="loggingKafkas")
    def logging_kafkas(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingKafka']]]:
        """
        A Kafka endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_kafkas")

    @property
    @pulumi.getter(name="loggingLogglies")
    def logging_logglies(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingLoggly']]]:
        """
        A Loggly endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_logglies")

    @property
    @pulumi.getter(name="loggingLogshuttles")
    def logging_logshuttles(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingLogshuttle']]]:
        """
        A Log Shuttle endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_logshuttles")

    @property
    @pulumi.getter(name="loggingNewrelics")
    def logging_newrelics(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingNewrelic']]]:
        """
        A New Relic endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_newrelics")

    @property
    @pulumi.getter(name="loggingOpenstacks")
    def logging_openstacks(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingOpenstack']]]:
        """
        An OpenStack endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_openstacks")

    @property
    @pulumi.getter(name="loggingScalyrs")
    def logging_scalyrs(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingScalyr']]]:
        """
        A Scalyr endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_scalyrs")

    @property
    @pulumi.getter(name="loggingSftps")
    def logging_sftps(self) -> pulumi.Output[Optional[List['outputs.Servicev1LoggingSftp']]]:
        """
        An SFTP endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_sftps")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def papertrails(self) -> pulumi.Output[Optional[List['outputs.Servicev1Papertrail']]]:
        """
        A Papertrail endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "papertrails")

    @property
    @pulumi.getter(name="requestSettings")
    def request_settings(self) -> pulumi.Output[Optional[List['outputs.Servicev1RequestSetting']]]:
        """
        A set of Request modifiers. Defined below
        """
        return pulumi.get(self, "request_settings")

    @property
    @pulumi.getter(name="responseObjects")
    def response_objects(self) -> pulumi.Output[Optional[List['outputs.Servicev1ResponseObject']]]:
        """
        Allows you to create synthetic responses that exist entirely on the varnish machine. Useful for creating error or maintenance pages that exists outside the scope of your datacenter. Best when used with Condition objects.
        """
        return pulumi.get(self, "response_objects")

    @property
    @pulumi.getter
    def s3loggings(self) -> pulumi.Output[Optional[List['outputs.Servicev1S3logging']]]:
        """
        A set of S3 Buckets to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "s3loggings")

    @property
    @pulumi.getter
    def snippets(self) -> pulumi.Output[Optional[List['outputs.Servicev1Snippet']]]:
        """
        A set of custom, "regular" (non-dynamic) VCL Snippet configuration blocks.  Defined below.
        """
        return pulumi.get(self, "snippets")

    @property
    @pulumi.getter
    def splunks(self) -> pulumi.Output[Optional[List['outputs.Servicev1Splunk']]]:
        """
        A Splunk endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "splunks")

    @property
    @pulumi.getter
    def sumologics(self) -> pulumi.Output[Optional[List['outputs.Servicev1Sumologic']]]:
        """
        A Sumologic endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "sumologics")

    @property
    @pulumi.getter
    def syslogs(self) -> pulumi.Output[Optional[List['outputs.Servicev1Syslog']]]:
        """
        A syslog endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "syslogs")

    @property
    @pulumi.getter
    def vcls(self) -> pulumi.Output[Optional[List['outputs.Servicev1Vcl']]]:
        """
        A set of custom VCL configuration blocks. See the [Fastly documentation](https://docs.fastly.com/vcl/custom-vcl/uploading-custom-vcl/) for more information on using custom VCL.
        """
        return pulumi.get(self, "vcls")

    @property
    @pulumi.getter(name="versionComment")
    def version_comment(self) -> pulumi.Output[Optional[str]]:
        """
        Description field for the version.
        """
        return pulumi.get(self, "version_comment")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

