"use strict";
const util_1 = require("../lib/util");
module.exports = {
    mergeEventPattern: {
        'happy case'(test) {
            test.deepEqual(util_1.mergeEventPattern({
                bar: [1, 2],
                hey: ['happy'],
                hello: {
                    world: ['hi', 'dude'],
                    case: [1],
                },
            }, {
                hey: ['day', 'today'],
                hello: {
                    world: ['you'],
                },
            }), {
                bar: [1, 2],
                hey: ['happy', 'day', 'today'],
                hello: {
                    world: ['hi', 'dude', 'you'],
                    case: [1],
                },
            });
            test.done();
        },
        'merge into an empty destination'(test) {
            test.deepEqual(util_1.mergeEventPattern(undefined, { foo: ['123'] }), { foo: [123] });
            test.deepEqual(util_1.mergeEventPattern(undefined, { foo: { bar: ['123'] } }), { foo: { bar: [123] } });
            test.deepEqual(util_1.mergeEventPattern({}, { foo: { bar: ['123'] } }), { foo: { bar: [123] } });
            test.done();
        },
        'fails if a field is not an array'(test) {
            test.throws(() => util_1.mergeEventPattern(undefined, 123), /Invalid event pattern '123', expecting an object or an array/);
            test.throws(() => util_1.mergeEventPattern(undefined, 'Hello'), /Invalid event pattern '"Hello"', expecting an object or an array/);
            test.throws(() => util_1.mergeEventPattern(undefined, { foo: '123' }), /Invalid event pattern field { foo: "123" }. All fields must be arrays/);
            test.done();
        },
        'fails if mismatch between dest and src'(test) {
            test.throws(() => util_1.mergeEventPattern({
                obj: {
                    array: [1],
                },
            }, {
                obj: {
                    array: {
                        value: ['hello'],
                    },
                },
            }), /Invalid event pattern field array. Type mismatch between existing pattern \[1\] and added pattern \{"value":\["hello"\]\}/);
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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