"""
Do not modify by hand
Generated by: bin/parse_android
"""

__module__ = 'tlstrust.stores.android_12'
__version__ = 'android_12'
__description__ = 'Android 12 2021'

UNTRUSTED = [
    "4aa0aa5884d35e3c",
    "7571a7194819bc9d9dea4147df94c4487799d379",
    "8b4b6dedd329b90619ec3939a9f097846acbefdf",
    "c4a7b1a47b2c71fadbe14b9075ffc41560858910",
    "fdda14c49f30de21bd1e4239fcab632349e0f184"
]
PEM_FILES = {
    "03de503556d14cbb66f0a3e21b1bc397b23dd155": "-----BEGIN CERTIFICATE-----\nMIIDrzCCApegAwIBAgIQCDvgVpBCRrGhdWrJWZHHSjANBgkqhkiG9w0BAQUFADBh\nMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3\nd3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBD\nQTAeFw0wNjExMTAwMDAwMDBaFw0zMTExMTAwMDAwMDBaMGExCzAJBgNVBAYTAlVT\nMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j\nb20xIDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IENBMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4jvhEXLeqKTTo1eqUKKPC3eQyaKl7hLOllsB\nCSDMAZOnTjC3U/dDxGkAV53ijSLdhwZAAIEJzs4bg7/fzTtxRuLWZscFs3YnFo97\nnh6Vfe63SKMI2tavegw5BmV/Sl0fvBf4q77uKNd0f3p4mVmFaG5cIzJLv07A6Fpt\n43C/dxC//AH2hdmoRBBYMql1GNXRor5H4idq9Joz+EkIYIvUX7Q6hL+hqkpMfT7P\nT19sdl6gSzeRntwi5m3OFBqOasv+zbMUZBfHWymeMr/y7vrTC0LUq7dBMtoM1O/4\ngdW7jVg/tRvoSSiicNoxBN33shbyTApOB6jtSj1etX+jkMOvJwIDAQABo2MwYTAO\nBgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUA95QNVbR\nTLtm8KPiGxvDl7I90VUwHwYDVR0jBBgwFoAUA95QNVbRTLtm8KPiGxvDl7I90VUw\nDQYJKoZIhvcNAQEFBQADggEBAMucN6pIExIK+t1EnE9SsPTfrgT1eXkIoyQY/Esr\nhMAtudXH/vTBH1jLuG2cenTnmCmrEbXjcKChzUyImZOMkXDiqw8cvpOp/2PV5Adg\n06O/nVsJ8dWO41P0jmP6P6fbtGbfYmbW0W5BjfIttep3Sp+dWOIrWcBAI+0tKIJF\nPnlUkiaY4IBIqDfv8NZ5YBberOgOzW6sRBc4L0na4UU+Krk2U886UAb3LujEV0ls\nYSEY1QSteDwsOoBrp+uvFRTp2InBuThs4pFsiv9kuXclVzDAGySj4dzp30d8tbQk\nCAUw7C29C79Fv1C5qfPrmAESrciIxpg0X40KPMbp1ZWVbd4=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            08:3b:e0:56:90:42:46:b1:a1:75:6a:c9:59:91:c7:4a\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root CA\n        Validity\n            Not Before: Nov 10 00:00:00 2006 GMT\n            Not After : Nov 10 00:00:00 2031 GMT\n        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:e2:3b:e1:11:72:de:a8:a4:d3:a3:57:aa:50:a2:\n                    8f:0b:77:90:c9:a2:a5:ee:12:ce:96:5b:01:09:20:\n                    cc:01:93:a7:4e:30:b7:53:f7:43:c4:69:00:57:9d:\n                    e2:8d:22:dd:87:06:40:00:81:09:ce:ce:1b:83:bf:\n                    df:cd:3b:71:46:e2:d6:66:c7:05:b3:76:27:16:8f:\n                    7b:9e:1e:95:7d:ee:b7:48:a3:08:da:d6:af:7a:0c:\n                    39:06:65:7f:4a:5d:1f:bc:17:f8:ab:be:ee:28:d7:\n                    74:7f:7a:78:99:59:85:68:6e:5c:23:32:4b:bf:4e:\n                    c0:e8:5a:6d:e3:70:bf:77:10:bf:fc:01:f6:85:d9:\n                    a8:44:10:58:32:a9:75:18:d5:d1:a2:be:47:e2:27:\n                    6a:f4:9a:33:f8:49:08:60:8b:d4:5f:b4:3a:84:bf:\n                    a1:aa:4a:4c:7d:3e:cf:4f:5f:6c:76:5e:a0:4b:37:\n                    91:9e:dc:22:e6:6d:ce:14:1a:8e:6a:cb:fe:cd:b3:\n                    14:64:17:c7:5b:29:9e:32:bf:f2:ee:fa:d3:0b:42:\n                    d4:ab:b7:41:32:da:0c:d4:ef:f8:81:d5:bb:8d:58:\n                    3f:b5:1b:e8:49:28:a2:70:da:31:04:dd:f7:b2:16:\n                    f2:4c:0a:4e:07:a8:ed:4a:3d:5e:b5:7f:a3:90:c3:\n                    af:27\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                03:DE:50:35:56:D1:4C:BB:66:F0:A3:E2:1B:1B:C3:97:B2:3D:D1:55\n            X509v3 Authority Key Identifier: \n                keyid:03:DE:50:35:56:D1:4C:BB:66:F0:A3:E2:1B:1B:C3:97:B2:3D:D1:55\n\n    Signature Algorithm: sha1WithRSAEncryption\n         cb:9c:37:aa:48:13:12:0a:fa:dd:44:9c:4f:52:b0:f4:df:ae:\n         04:f5:79:79:08:a3:24:18:fc:4b:2b:84:c0:2d:b9:d5:c7:fe:\n         f4:c1:1f:58:cb:b8:6d:9c:7a:74:e7:98:29:ab:11:b5:e3:70:\n         a0:a1:cd:4c:88:99:93:8c:91:70:e2:ab:0f:1c:be:93:a9:ff:\n         63:d5:e4:07:60:d3:a3:bf:9d:5b:09:f1:d5:8e:e3:53:f4:8e:\n         63:fa:3f:a7:db:b4:66:df:62:66:d6:d1:6e:41:8d:f2:2d:b5:\n         ea:77:4a:9f:9d:58:e2:2b:59:c0:40:23:ed:2d:28:82:45:3e:\n         79:54:92:26:98:e0:80:48:a8:37:ef:f0:d6:79:60:16:de:ac:\n         e8:0e:cd:6e:ac:44:17:38:2f:49:da:e1:45:3e:2a:b9:36:53:\n         cf:3a:50:06:f7:2e:e8:c4:57:49:6c:61:21:18:d5:04:ad:78:\n         3c:2c:3a:80:6b:a7:eb:af:15:14:e9:d8:89:c1:b9:38:6c:e2:\n         91:6c:8a:ff:64:b9:77:25:57:30:c0:1b:24:a3:e1:dc:e9:df:\n         47:7c:b5:b4:24:08:05:30:ec:2d:bd:0b:bf:45:bf:50:b9:a9:\n         f3:eb:98:01:12:ad:c8:88:c6:98:34:5f:8d:0a:3c:c6:e9:d5:\n         95:95:6d:de\nSHA1 Fingerprint=A8:98:5D:3A:65:E5:E5:C4:B2:D7:D6:6D:40:C6:DD:2F:B1:9C:54:36\n",
    "071fd2e79cdac26ea240b4b07a50105074c4c8bd": "-----BEGIN CERTIFICATE-----\nMIIDTDCCAjSgAwIBAgIIfE8EORzUmS0wDQYJKoZIhvcNAQEFBQAwRDELMAkGA1UE\nBhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MR8wHQYDVQQDDBZBZmZpcm1UcnVz\ndCBOZXR3b3JraW5nMB4XDTEwMDEyOTE0MDgyNFoXDTMwMTIzMTE0MDgyNFowRDEL\nMAkGA1UEBhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MR8wHQYDVQQDDBZBZmZp\ncm1UcnVzdCBOZXR3b3JraW5nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEAtITMMxcua5Rsa2FSoOujz3mUTOWUgJnLVWREZY9nZOIG41w3SfYvm4SEHi3y\nYJ0wTsyEheIszx6e/jarM3c1RNg1lho9Nuh6DtjVR6FqaYvZ/Ls6rnla1fTWcbua\nkCNrmreIdIcMHl+5ni36q1Mr3Lt2PpNMCAiMHqIjHNRqrSK6mQEubWXLviRmVSRL\nQESxG9fhwoXA3hA/Pe24/PHxI1Pcv2WXb9n5QHGNfb2V1M6+oF4nI979ptAmDgAp\n6zxG8D1gvz9Q0twmQVGeFDdCBKNwV6gbh+0t+nvujArjqWaJGctB+d1ENmHP4ndG\nyH329JKBNv3bNPFyfvMMFr20FQIDAQABo0IwQDAdBgNVHQ4EFgQUBx/S55zawm6i\nQLSwelAQUHTEyL0wDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwDQYJ\nKoZIhvcNAQEFBQADggEBAIlXshZ6qML91tmbmzTCnLQyFE2npN/svqe++EPbkTfO\ntDIuUFUaNU52Q3Eg75N3ThVwLofDwR1t3Mu1J9QsVtFSUzpE0nPIxBsFZVpikpzu\nQY0x2+c06lkh1QF612S4ZDnNye2v7UsDSKegmQGA3GWjNq5lWUhPgkvIZfFXHeVZ\nLgo/bNjR9eUJtGxUAArgFU2HdW23WJZa3W3SAKD0m0i+wzekujbgfIeFlxoVot4u\nolu9rxj5kFDNcFn4J2dHy8egBzp90SxdbBk6ZrV9/ZFvgrG+CJPbFEfxojfHRZ48\nx3evZKiT3/Zpg4Jg8klCNO1aAFSFHBY2kgxc+qatv9s=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 8957382827206547757 (0x7c4f04391cd4992d)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=US, O=AffirmTrust, CN=AffirmTrust Networking\n        Validity\n            Not Before: Jan 29 14:08:24 2010 GMT\n            Not After : Dec 31 14:08:24 2030 GMT\n        Subject: C=US, O=AffirmTrust, CN=AffirmTrust Networking\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:b4:84:cc:33:17:2e:6b:94:6c:6b:61:52:a0:eb:\n                    a3:cf:79:94:4c:e5:94:80:99:cb:55:64:44:65:8f:\n                    67:64:e2:06:e3:5c:37:49:f6:2f:9b:84:84:1e:2d:\n                    f2:60:9d:30:4e:cc:84:85:e2:2c:cf:1e:9e:fe:36:\n                    ab:33:77:35:44:d8:35:96:1a:3d:36:e8:7a:0e:d8:\n                    d5:47:a1:6a:69:8b:d9:fc:bb:3a:ae:79:5a:d5:f4:\n                    d6:71:bb:9a:90:23:6b:9a:b7:88:74:87:0c:1e:5f:\n                    b9:9e:2d:fa:ab:53:2b:dc:bb:76:3e:93:4c:08:08:\n                    8c:1e:a2:23:1c:d4:6a:ad:22:ba:99:01:2e:6d:65:\n                    cb:be:24:66:55:24:4b:40:44:b1:1b:d7:e1:c2:85:\n                    c0:de:10:3f:3d:ed:b8:fc:f1:f1:23:53:dc:bf:65:\n                    97:6f:d9:f9:40:71:8d:7d:bd:95:d4:ce:be:a0:5e:\n                    27:23:de:fd:a6:d0:26:0e:00:29:eb:3c:46:f0:3d:\n                    60:bf:3f:50:d2:dc:26:41:51:9e:14:37:42:04:a3:\n                    70:57:a8:1b:87:ed:2d:fa:7b:ee:8c:0a:e3:a9:66:\n                    89:19:cb:41:f9:dd:44:36:61:cf:e2:77:46:c8:7d:\n                    f6:f4:92:81:36:fd:db:34:f1:72:7e:f3:0c:16:bd:\n                    b4:15\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                07:1F:D2:E7:9C:DA:C2:6E:A2:40:B4:B0:7A:50:10:50:74:C4:C8:BD\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha1WithRSAEncryption\n         89:57:b2:16:7a:a8:c2:fd:d6:d9:9b:9b:34:c2:9c:b4:32:14:\n         4d:a7:a4:df:ec:be:a7:be:f8:43:db:91:37:ce:b4:32:2e:50:\n         55:1a:35:4e:76:43:71:20:ef:93:77:4e:15:70:2e:87:c3:c1:\n         1d:6d:dc:cb:b5:27:d4:2c:56:d1:52:53:3a:44:d2:73:c8:c4:\n         1b:05:65:5a:62:92:9c:ee:41:8d:31:db:e7:34:ea:59:21:d5:\n         01:7a:d7:64:b8:64:39:cd:c9:ed:af:ed:4b:03:48:a7:a0:99:\n         01:80:dc:65:a3:36:ae:65:59:48:4f:82:4b:c8:65:f1:57:1d:\n         e5:59:2e:0a:3f:6c:d8:d1:f5:e5:09:b4:6c:54:00:0a:e0:15:\n         4d:87:75:6d:b7:58:96:5a:dd:6d:d2:00:a0:f4:9b:48:be:c3:\n         37:a4:ba:36:e0:7c:87:85:97:1a:15:a2:de:2e:a2:5b:bd:af:\n         18:f9:90:50:cd:70:59:f8:27:67:47:cb:c7:a0:07:3a:7d:d1:\n         2c:5d:6c:19:3a:66:b5:7d:fd:91:6f:82:b1:be:08:93:db:14:\n         47:f1:a2:37:c7:45:9e:3c:c7:77:af:64:a8:93:df:f6:69:83:\n         82:60:f2:49:42:34:ed:5a:00:54:85:1c:16:36:92:0c:5c:fa:\n         a6:ad:bf:db\nSHA1 Fingerprint=29:36:21:02:8B:20:ED:02:F5:66:C5:32:D1:D6:ED:90:9F:45:00:2F\n",
    "0876cdcb07ff24f6c5cdedbb90bce284374675f7": "-----BEGIN CERTIFICATE-----\nMIIDuzCCAqOgAwIBAgIDBETAMA0GCSqGSIb3DQEBBQUAMH4xCzAJBgNVBAYTAlBM\nMSIwIAYDVQQKExlVbml6ZXRvIFRlY2hub2xvZ2llcyBTLkEuMScwJQYDVQQLEx5D\nZXJ0dW0gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxIjAgBgNVBAMTGUNlcnR1bSBU\ncnVzdGVkIE5ldHdvcmsgQ0EwHhcNMDgxMDIyMTIwNzM3WhcNMjkxMjMxMTIwNzM3\nWjB+MQswCQYDVQQGEwJQTDEiMCAGA1UEChMZVW5pemV0byBUZWNobm9sb2dpZXMg\nUy5BLjEnMCUGA1UECxMeQ2VydHVtIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MSIw\nIAYDVQQDExlDZXJ0dW0gVHJ1c3RlZCBOZXR3b3JrIENBMIIBIjANBgkqhkiG9w0B\nAQEFAAOCAQ8AMIIBCgKCAQEA4/t9o3K6wvDJFIf1awFO4W5AB7ptJ11/91sts1rH\nUV+rpDKmYYe2bg+G0jACl/jXaVehGDldamR5xgFZrDwxSjh80gTSSyjoIF87B6LM\nTXPb865Px1bVWqeWifrzq2jUI4ZZJ88JJ7ysbnKDHDBy3+Ci6dLhdHUZvSqeexVU\nBBvXQzmtVSjF4hq79MDkrjhJM8x2hZ85RdKknvISjFH4fOQtf/WsX+sWn7Et0brM\nkUJ3TCXJkDhv2/DM+44el1k+1WBO5gUo7Ul5E0u6SNsv+XLTOcr+H9g0cvW0QM8x\nAcPs3hEtF10fuFDRXhmnad4HMyjKUJX5p1TLVIZQRan5SQIDAQABo0IwQDAPBgNV\nHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQIds3LB/8k9sXN7buQvOKEN0Z19zAOBgNV\nHQ8BAf8EBAMCAQYwDQYJKoZIhvcNAQEFBQADggEBAKaorSLOAT2mo/9i0Eidi15y\nsHhE49wcrwn9I0j6vSrEuVUEtRCjjSfeC4Jj0O7eDDd5QVsisrCaQVymcODU0HfL\nI9MA4GxWL+FpDQ3Zqr8hgVDZBqWo/5U30Kr+4rP1mS1FhIrlQgnXdAIv94nYmem8\nJ9RHjboNRhx3zxSkHLmkMcScKHQDNP8zGSal6Q10tz6XxnboJ5ajZt3hrvJBW8qY\nVoNzcOSGGtIxQbovvi0TWnZvTuhOgQ4/WwMioBK+ZlgRSssDxLQqKi2WF+A5VLxI\n03YnnZotBqbJ7DnSq9ufmgsnAjUpsUCV5/nonFWIGUbWtzT1fs45mtk48VH3Tyw=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 279744 (0x444c0)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=PL, O=Unizeto Technologies S.A., OU=Certum Certification Authority, CN=Certum Trusted Network CA\n        Validity\n            Not Before: Oct 22 12:07:37 2008 GMT\n            Not After : Dec 31 12:07:37 2029 GMT\n        Subject: C=PL, O=Unizeto Technologies S.A., OU=Certum Certification Authority, CN=Certum Trusted Network CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:e3:fb:7d:a3:72:ba:c2:f0:c9:14:87:f5:6b:01:\n                    4e:e1:6e:40:07:ba:6d:27:5d:7f:f7:5b:2d:b3:5a:\n                    c7:51:5f:ab:a4:32:a6:61:87:b6:6e:0f:86:d2:30:\n                    02:97:f8:d7:69:57:a1:18:39:5d:6a:64:79:c6:01:\n                    59:ac:3c:31:4a:38:7c:d2:04:d2:4b:28:e8:20:5f:\n                    3b:07:a2:cc:4d:73:db:f3:ae:4f:c7:56:d5:5a:a7:\n                    96:89:fa:f3:ab:68:d4:23:86:59:27:cf:09:27:bc:\n                    ac:6e:72:83:1c:30:72:df:e0:a2:e9:d2:e1:74:75:\n                    19:bd:2a:9e:7b:15:54:04:1b:d7:43:39:ad:55:28:\n                    c5:e2:1a:bb:f4:c0:e4:ae:38:49:33:cc:76:85:9f:\n                    39:45:d2:a4:9e:f2:12:8c:51:f8:7c:e4:2d:7f:f5:\n                    ac:5f:eb:16:9f:b1:2d:d1:ba:cc:91:42:77:4c:25:\n                    c9:90:38:6f:db:f0:cc:fb:8e:1e:97:59:3e:d5:60:\n                    4e:e6:05:28:ed:49:79:13:4b:ba:48:db:2f:f9:72:\n                    d3:39:ca:fe:1f:d8:34:72:f5:b4:40:cf:31:01:c3:\n                    ec:de:11:2d:17:5d:1f:b8:50:d1:5e:19:a7:69:de:\n                    07:33:28:ca:50:95:f9:a7:54:cb:54:86:50:45:a9:\n                    f9:49\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                08:76:CD:CB:07:FF:24:F6:C5:CD:ED:BB:90:BC:E2:84:37:46:75:F7\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha1WithRSAEncryption\n         a6:a8:ad:22:ce:01:3d:a6:a3:ff:62:d0:48:9d:8b:5e:72:b0:\n         78:44:e3:dc:1c:af:09:fd:23:48:fa:bd:2a:c4:b9:55:04:b5:\n         10:a3:8d:27:de:0b:82:63:d0:ee:de:0c:37:79:41:5b:22:b2:\n         b0:9a:41:5c:a6:70:e0:d4:d0:77:cb:23:d3:00:e0:6c:56:2f:\n         e1:69:0d:0d:d9:aa:bf:21:81:50:d9:06:a5:a8:ff:95:37:d0:\n         aa:fe:e2:b3:f5:99:2d:45:84:8a:e5:42:09:d7:74:02:2f:f7:\n         89:d8:99:e9:bc:27:d4:47:8d:ba:0d:46:1c:77:cf:14:a4:1c:\n         b9:a4:31:c4:9c:28:74:03:34:ff:33:19:26:a5:e9:0d:74:b7:\n         3e:97:c6:76:e8:27:96:a3:66:dd:e1:ae:f2:41:5b:ca:98:56:\n         83:73:70:e4:86:1a:d2:31:41:ba:2f:be:2d:13:5a:76:6f:4e:\n         e8:4e:81:0e:3f:5b:03:22:a0:12:be:66:58:11:4a:cb:03:c4:\n         b4:2a:2a:2d:96:17:e0:39:54:bc:48:d3:76:27:9d:9a:2d:06:\n         a6:c9:ec:39:d2:ab:db:9f:9a:0b:27:02:35:29:b1:40:95:e7:\n         f9:e8:9c:55:88:19:46:d6:b7:34:f5:7e:ce:39:9a:d9:38:f1:\n         51:f7:4f:2c\nSHA1 Fingerprint=07:E0:32:E0:20:B7:2C:3F:19:2F:06:28:A2:59:3A:19:A7:0F:06:9E\n",
    "09cb597f86b2708f1ac339e3c0d9e9bfbb4db223": "-----BEGIN CERTIFICATE-----\nMIIFqDCCA5CgAwIBAgIQHtOXCV/YtLNHcB6qvn9FszANBgkqhkiG9w0BAQwFADBl\nMQswCQYDVQQGEwJVUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTYw\nNAYDVQQDEy1NaWNyb3NvZnQgUlNBIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5\nIDIwMTcwHhcNMTkxMjE4MjI1MTIyWhcNNDIwNzE4MjMwMDIzWjBlMQswCQYDVQQG\nEwJVUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTYwNAYDVQQDEy1N\naWNyb3NvZnQgUlNBIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTcwggIi\nMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDKW76UM4wplZEWCpW9R2LBifOZ\nNt9GkMml7Xhqb0eRaPgnZ1AzHaGm++DlQ6OEAlcBXZxIQIJTELy/xztokLaCLeX0\nZdDMbRnMlfl7rEqUrQ7eS0MdhweSE5CAg2Q1OQT85elss7YfUJQ4ZVBcF0a5toW1\nHLUX6NZFndiyJrDKxHBKrmCk3bPZ7Pw71VdyvD/IybLeS2v4I2wDwAW9lcfNcztm\ngGTjGqwu+UcF8ga2m3P1eDNbx6H7JyqhtJqRjJHTOoI+dkC0zVJhUXAoP8XFWvLJ\njEm7FFtNyP9nTUwSlq31/niol4fX/V4ggNyhSyL71Imtus5Hl0dVe49FyGcohJUc\naDDv70ngNXtk55iwlNpNhTs+VcQor1fznhPbRiefHqJeRIOkpcrVE7NLP8TjwuaG\nYaRSMLl6IE9vDzhTyzMMEyuP1pq9KsgtsRx9S1HKR9FIJ3Jdh+vVReZIZZ2vUpC6\nW6IYZVcSn2i51BVrlMRpIpj0M+Dt+VGOQVDJNE92kKz8OMHY4Xu54+OU4UZpyw4K\nUGsTuqwPN1q3ErWQgR5WrlcihtnJ0tHXUeOrO8ZV/R4O03QK0dqq6mm4lyiPSMQH\n+FJDOvTKVTUssKZqwJz58oHhEmrARdlns87/I6KJClTUFLkqqNfs+avNJVgyeY+Q\nW5g5xAgGwax/Dj0ApQIDAQABo1QwUjAOBgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/\nBAUwAwEB/zAdBgNVHQ4EFgQUCctZf4aycI8awznjwNnpv7tNsiMwEAYJKwYBBAGC\nNxUBBAMCAQAwDQYJKoZIhvcNAQEMBQADggIBAKyvPl3CEZaJjqPnktaXFbgToqZC\nLgLNFgVZJ8og6Lq46BrsTaiXVq5lQ7GPAJtSzVXNUzltYkyLDVt8LkS/gxCP81OC\ngMNPOsduET/m4xaRhPtthH80dK2Jp86519efhGSSvpWhrQlTM93uCupKUY5vVau6\ntZRGrox/2KJQJWVggEbbMwSubLWYdFQl3JPk+ONVFT24bcMKpBLBaYVu32TxU5nh\nSnUgnZUP5NbcA/FZGOhHibJXWpS2qdgXKxdJ5XbLwVaZOjex/2kskZGT4d9Mozd2\nTaGf+G0eHdP67Pv0RR0Tbc/3WeUiJ3IrhvNXuzDtJE3cfVa7o7P4NHmJweDyAmH3\npvwPuxwXC65B2Xy9J6P9LjrRk5Sxcx0ki69bIImtt2dmefU6xqaWM/5TkshGsRGR\nxpl/j8nWZjEgQRCHLQzWwa80mMpkg/sTV9HB8Dx6jKXB/ZUhoHHBk2dxEuqPiApp\nGWSZI1b7rCoucL5mxAyE7+WL85MB+GqQk2dLsmijtWKP6T+MejteD+eMuMZ87zf9\ndOLITzNy4ZQ5bb0Sr74MTnB8G2+NszKTc0QWbej09+CVgI+WXTik9KveCjCHk9hN\nAHFiRSdLOkKEW39lt2c0Ui2cFmuqqNh7o0JMcccMyj6D5KbvtwEwXlGjefVwaaZB\nRA+GsCyRxj3qrg+E\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            1e:d3:97:09:5f:d8:b4:b3:47:70:1e:aa:be:7f:45:b3\n        Signature Algorithm: sha384WithRSAEncryption\n        Issuer: C=US, O=Microsoft Corporation, CN=Microsoft RSA Root Certificate Authority 2017\n        Validity\n            Not Before: Dec 18 22:51:22 2019 GMT\n            Not After : Jul 18 23:00:23 2042 GMT\n        Subject: C=US, O=Microsoft Corporation, CN=Microsoft RSA Root Certificate Authority 2017\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:ca:5b:be:94:33:8c:29:95:91:16:0a:95:bd:47:\n                    62:c1:89:f3:99:36:df:46:90:c9:a5:ed:78:6a:6f:\n                    47:91:68:f8:27:67:50:33:1d:a1:a6:fb:e0:e5:43:\n                    a3:84:02:57:01:5d:9c:48:40:82:53:10:bc:bf:c7:\n                    3b:68:90:b6:82:2d:e5:f4:65:d0:cc:6d:19:cc:95:\n                    f9:7b:ac:4a:94:ad:0e:de:4b:43:1d:87:07:92:13:\n                    90:80:83:64:35:39:04:fc:e5:e9:6c:b3:b6:1f:50:\n                    94:38:65:50:5c:17:46:b9:b6:85:b5:1c:b5:17:e8:\n                    d6:45:9d:d8:b2:26:b0:ca:c4:70:4a:ae:60:a4:dd:\n                    b3:d9:ec:fc:3b:d5:57:72:bc:3f:c8:c9:b2:de:4b:\n                    6b:f8:23:6c:03:c0:05:bd:95:c7:cd:73:3b:66:80:\n                    64:e3:1a:ac:2e:f9:47:05:f2:06:b6:9b:73:f5:78:\n                    33:5b:c7:a1:fb:27:2a:a1:b4:9a:91:8c:91:d3:3a:\n                    82:3e:76:40:b4:cd:52:61:51:70:28:3f:c5:c5:5a:\n                    f2:c9:8c:49:bb:14:5b:4d:c8:ff:67:4d:4c:12:96:\n                    ad:f5:fe:78:a8:97:87:d7:fd:5e:20:80:dc:a1:4b:\n                    22:fb:d4:89:ad:ba:ce:47:97:47:55:7b:8f:45:c8:\n                    67:28:84:95:1c:68:30:ef:ef:49:e0:35:7b:64:e7:\n                    98:b0:94:da:4d:85:3b:3e:55:c4:28:af:57:f3:9e:\n                    13:db:46:27:9f:1e:a2:5e:44:83:a4:a5:ca:d5:13:\n                    b3:4b:3f:c4:e3:c2:e6:86:61:a4:52:30:b9:7a:20:\n                    4f:6f:0f:38:53:cb:33:0c:13:2b:8f:d6:9a:bd:2a:\n                    c8:2d:b1:1c:7d:4b:51:ca:47:d1:48:27:72:5d:87:\n                    eb:d5:45:e6:48:65:9d:af:52:90:ba:5b:a2:18:65:\n                    57:12:9f:68:b9:d4:15:6b:94:c4:69:22:98:f4:33:\n                    e0:ed:f9:51:8e:41:50:c9:34:4f:76:90:ac:fc:38:\n                    c1:d8:e1:7b:b9:e3:e3:94:e1:46:69:cb:0e:0a:50:\n                    6b:13:ba:ac:0f:37:5a:b7:12:b5:90:81:1e:56:ae:\n                    57:22:86:d9:c9:d2:d1:d7:51:e3:ab:3b:c6:55:fd:\n                    1e:0e:d3:74:0a:d1:da:aa:ea:69:b8:97:28:8f:48:\n                    c4:07:f8:52:43:3a:f4:ca:55:35:2c:b0:a6:6a:c0:\n                    9c:f9:f2:81:e1:12:6a:c0:45:d9:67:b3:ce:ff:23:\n                    a2:89:0a:54:d4:14:b9:2a:a8:d7:ec:f9:ab:cd:25:\n                    58:32:79:8f:90:5b:98:39:c4:08:06:c1:ac:7f:0e:\n                    3d:00:a5\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                09:CB:59:7F:86:B2:70:8F:1A:C3:39:E3:C0:D9:E9:BF:BB:4D:B2:23\n            1.3.6.1.4.1.311.21.1: \n                ...\n    Signature Algorithm: sha384WithRSAEncryption\n         ac:af:3e:5d:c2:11:96:89:8e:a3:e7:92:d6:97:15:b8:13:a2:\n         a6:42:2e:02:cd:16:05:59:27:ca:20:e8:ba:b8:e8:1a:ec:4d:\n         a8:97:56:ae:65:43:b1:8f:00:9b:52:cd:55:cd:53:39:6d:62:\n         4c:8b:0d:5b:7c:2e:44:bf:83:10:8f:f3:53:82:80:c3:4f:3a:\n         c7:6e:11:3f:e6:e3:16:91:84:fb:6d:84:7f:34:74:ad:89:a7:\n         ce:b9:d7:d7:9f:84:64:92:be:95:a1:ad:09:53:33:dd:ee:0a:\n         ea:4a:51:8e:6f:55:ab:ba:b5:94:46:ae:8c:7f:d8:a2:50:25:\n         65:60:80:46:db:33:04:ae:6c:b5:98:74:54:25:dc:93:e4:f8:\n         e3:55:15:3d:b8:6d:c3:0a:a4:12:c1:69:85:6e:df:64:f1:53:\n         99:e1:4a:75:20:9d:95:0f:e4:d6:dc:03:f1:59:18:e8:47:89:\n         b2:57:5a:94:b6:a9:d8:17:2b:17:49:e5:76:cb:c1:56:99:3a:\n         37:b1:ff:69:2c:91:91:93:e1:df:4c:a3:37:76:4d:a1:9f:f8:\n         6d:1e:1d:d3:fa:ec:fb:f4:45:1d:13:6d:cf:f7:59:e5:22:27:\n         72:2b:86:f3:57:bb:30:ed:24:4d:dc:7d:56:bb:a3:b3:f8:34:\n         79:89:c1:e0:f2:02:61:f7:a6:fc:0f:bb:1c:17:0b:ae:41:d9:\n         7c:bd:27:a3:fd:2e:3a:d1:93:94:b1:73:1d:24:8b:af:5b:20:\n         89:ad:b7:67:66:79:f5:3a:c6:a6:96:33:fe:53:92:c8:46:b1:\n         11:91:c6:99:7f:8f:c9:d6:66:31:20:41:10:87:2d:0c:d6:c1:\n         af:34:98:ca:64:83:fb:13:57:d1:c1:f0:3c:7a:8c:a5:c1:fd:\n         95:21:a0:71:c1:93:67:71:12:ea:8f:88:0a:69:19:64:99:23:\n         56:fb:ac:2a:2e:70:be:66:c4:0c:84:ef:e5:8b:f3:93:01:f8:\n         6a:90:93:67:4b:b2:68:a3:b5:62:8f:e9:3f:8c:7a:3b:5e:0f:\n         e7:8c:b8:c6:7c:ef:37:fd:74:e2:c8:4f:33:72:e1:94:39:6d:\n         bd:12:af:be:0c:4e:70:7c:1b:6f:8d:b3:32:93:73:44:16:6d:\n         e8:f4:f7:e0:95:80:8f:96:5d:38:a4:f4:ab:de:0a:30:87:93:\n         d8:4d:00:71:62:45:27:4b:3a:42:84:5b:7f:65:b7:67:34:52:\n         2d:9c:16:6b:aa:a8:d8:7b:a3:42:4c:71:c7:0c:ca:3e:83:e4:\n         a6:ef:b7:01:30:5e:51:a3:79:f5:70:69:a6:41:44:0f:86:b0:\n         2c:91:c6:3d:ea:ae:0f:84\nSHA1 Fingerprint=73:A5:E6:4A:3B:FF:83:16:FF:0E:DC:CC:61:8A:90:6E:4E:AE:4D:74\n",
    "0a85a9776505987c4081f80f972c38f10aec3ccf": "-----BEGIN CERTIFICATE-----\nMIIDdzCCAl+gAwIBAgIBADANBgkqhkiG9w0BAQsFADBdMQswCQYDVQQGEwJKUDEl\nMCMGA1UEChMcU0VDT00gVHJ1c3QgU3lzdGVtcyBDTy4sTFRELjEnMCUGA1UECxMe\nU2VjdXJpdHkgQ29tbXVuaWNhdGlvbiBSb290Q0EyMB4XDTA5MDUyOTA1MDAzOVoX\nDTI5MDUyOTA1MDAzOVowXTELMAkGA1UEBhMCSlAxJTAjBgNVBAoTHFNFQ09NIFRy\ndXN0IFN5c3RlbXMgQ08uLExURC4xJzAlBgNVBAsTHlNlY3VyaXR5IENvbW11bmlj\nYXRpb24gUm9vdENBMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANAV\nOVKxUrO6xVmCxF1SrjpDZYBLx/KWvNs2l9amZIyoXvDjChz335c9S672XewhtUGr\nzbl+dp+++T42NKA7wfYxEUV0kz1XgMX5iZnK5atq1LXaQZAQwdbWQonCv/Q4EpVM\nVAX3NuRFg3sUZdbcDE3R3n4MqzvEFb46VqZab3ZpUql6ucjrappdUtAtCms1FgkQ\nhNBqyjoGADdH5H5XTz+L62e4iKrFvlNVspHEfbmwhRkGeC7bYRr6hfVKkaHnFtWO\nojnflLhwHyg/i/xAXmODPIMqGplrz95Zajv8bxbXH/1KEOtOghY6rCcMU/Gt1SSw\nawNQwS08Ft1ENCcadfsCAwEAAaNCMEAwHQYDVR0OBBYEFAqFqXdlBZh8QIH4D5cs\nOPEK7DzPMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3\nDQEBCwUAA4IBAQBMOqNErLlFsceTfsgLCkLfZOoc7llsCLqJX2rKSpWeeo8HxdpF\ncoJxDjrSzG+ntKEju/Ykn8sX/oymzsLS28yN/HH8AynBbF0zX2S2ZTuJbxh2ePXc\nokgfGT+Ok+vx+hfuzU7jBBJV1uXk3fs+BXziHV7Gp7yXT2g69ekuCkO2r1dcYmh8\nt/2jioSgrGK+KwmHNPBqAbubKVY8/gA3zyNs8U6qtnRGEmyR7jTV7JqR50S+kDFy\n1UkC9gLl9B/rfNmWVan/7Ir5mUf/NVoCqgTLiluHcSmRvaS0eg29mvVXIwAHIRc/\nSjnRBUkLp7Y3gaVdjKozXoEofKd9J+sAro03\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 0 (0x0)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=JP, O=SECOM Trust Systems CO.,LTD., OU=Security Communication RootCA2\n        Validity\n            Not Before: May 29 05:00:39 2009 GMT\n            Not After : May 29 05:00:39 2029 GMT\n        Subject: C=JP, O=SECOM Trust Systems CO.,LTD., OU=Security Communication RootCA2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:d0:15:39:52:b1:52:b3:ba:c5:59:82:c4:5d:52:\n                    ae:3a:43:65:80:4b:c7:f2:96:bc:db:36:97:d6:a6:\n                    64:8c:a8:5e:f0:e3:0a:1c:f7:df:97:3d:4b:ae:f6:\n                    5d:ec:21:b5:41:ab:cd:b9:7e:76:9f:be:f9:3e:36:\n                    34:a0:3b:c1:f6:31:11:45:74:93:3d:57:80:c5:f9:\n                    89:99:ca:e5:ab:6a:d4:b5:da:41:90:10:c1:d6:d6:\n                    42:89:c2:bf:f4:38:12:95:4c:54:05:f7:36:e4:45:\n                    83:7b:14:65:d6:dc:0c:4d:d1:de:7e:0c:ab:3b:c4:\n                    15:be:3a:56:a6:5a:6f:76:69:52:a9:7a:b9:c8:eb:\n                    6a:9a:5d:52:d0:2d:0a:6b:35:16:09:10:84:d0:6a:\n                    ca:3a:06:00:37:47:e4:7e:57:4f:3f:8b:eb:67:b8:\n                    88:aa:c5:be:53:55:b2:91:c4:7d:b9:b0:85:19:06:\n                    78:2e:db:61:1a:fa:85:f5:4a:91:a1:e7:16:d5:8e:\n                    a2:39:df:94:b8:70:1f:28:3f:8b:fc:40:5e:63:83:\n                    3c:83:2a:1a:99:6b:cf:de:59:6a:3b:fc:6f:16:d7:\n                    1f:fd:4a:10:eb:4e:82:16:3a:ac:27:0c:53:f1:ad:\n                    d5:24:b0:6b:03:50:c1:2d:3c:16:dd:44:34:27:1a:\n                    75:fb\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                0A:85:A9:77:65:05:98:7C:40:81:F8:0F:97:2C:38:F1:0A:EC:3C:CF\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: sha256WithRSAEncryption\n         4c:3a:a3:44:ac:b9:45:b1:c7:93:7e:c8:0b:0a:42:df:64:ea:\n         1c:ee:59:6c:08:ba:89:5f:6a:ca:4a:95:9e:7a:8f:07:c5:da:\n         45:72:82:71:0e:3a:d2:cc:6f:a7:b4:a1:23:bb:f6:24:9f:cb:\n         17:fe:8c:a6:ce:c2:d2:db:cc:8d:fc:71:fc:03:29:c1:6c:5d:\n         33:5f:64:b6:65:3b:89:6f:18:76:78:f5:dc:a2:48:1f:19:3f:\n         8e:93:eb:f1:fa:17:ee:cd:4e:e3:04:12:55:d6:e5:e4:dd:fb:\n         3e:05:7c:e2:1d:5e:c6:a7:bc:97:4f:68:3a:f5:e9:2e:0a:43:\n         b6:af:57:5c:62:68:7c:b7:fd:a3:8a:84:a0:ac:62:be:2b:09:\n         87:34:f0:6a:01:bb:9b:29:56:3c:fe:00:37:cf:23:6c:f1:4e:\n         aa:b6:74:46:12:6c:91:ee:34:d5:ec:9a:91:e7:44:be:90:31:\n         72:d5:49:02:f6:02:e5:f4:1f:eb:7c:d9:96:55:a9:ff:ec:8a:\n         f9:99:47:ff:35:5a:02:aa:04:cb:8a:5b:87:71:29:91:bd:a4:\n         b4:7a:0d:bd:9a:f5:57:23:00:07:21:17:3f:4a:39:d1:05:49:\n         0b:a7:b6:37:81:a5:5d:8c:aa:33:5e:81:28:7c:a7:7d:27:eb:\n         00:ae:8d:37\nSHA1 Fingerprint=5F:3B:8C:F2:F8:10:B3:7D:78:B4:CE:EC:19:19:C3:73:34:B9:C7:74\n",
    "0b58e58bc64c1537a440a930a921be47365a56ff": "-----BEGIN CERTIFICATE-----\nMIIEHTCCAwWgAwIBAgIQToEtioJl4AsC7j41AkblPTANBgkqhkiG9w0BAQUFADCB\ngTELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4G\nA1UEBxMHU2FsZm9yZDEaMBgGA1UEChMRQ09NT0RPIENBIExpbWl0ZWQxJzAlBgNV\nBAMTHkNPTU9ETyBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wNjEyMDEwMDAw\nMDBaFw0yOTEyMzEyMzU5NTlaMIGBMQswCQYDVQQGEwJHQjEbMBkGA1UECBMSR3Jl\nYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRowGAYDVQQKExFDT01P\nRE8gQ0EgTGltaXRlZDEnMCUGA1UEAxMeQ09NT0RPIENlcnRpZmljYXRpb24gQXV0\naG9yaXR5MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0ECLi3LjkRv3\nUcEbVASY06m/weaKXTuH+7uIzg3jLz8GlvCiKVCZrts7oVewdFFxze1CkU1B/qnI\n2GqGd0S7WWaXUF601CxwRM/aN5VCaTwwxHGzUvAhTaHYujl8HJ6jJJ3ygxaYqhZ8\nQ5sVW7euNJH+1GImGEaaP+vB+fGQV+useg2L23IwambV4EajcNxo2f8ESIl33rXp\n+2dtQem8Ob0y2WIC8bGoPW43nOIv4tOiJovGuFVDiOEjPqXSJDlqR6sA1KGzqSX+\nDT+nHbrTUcELpNqsOO9VUCQFZUaTNE8tja3G1CEZ0o7KBWFxB3NH5YoZEr0ETc5O\nnKVIrLsm9wIDAQABo4GOMIGLMB0GA1UdDgQWBBQLWOWLxkwVN6RAqTCpIb5HNlpW\n/zAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zBJBgNVHR8EQjBAMD6g\nPKA6hjhodHRwOi8vY3JsLmNvbW9kb2NhLmNvbS9DT01PRE9DZXJ0aWZpY2F0aW9u\nQXV0aG9yaXR5LmNybDANBgkqhkiG9w0BAQUFAAOCAQEAPpiem/Yb6dc5t3iuHXIY\nSdOH5EOC6z/JqvWote9VfCFSZfnVDeFs9D6Mk3ORLgLETgdxb8CPOGEIqB6BCsAv\nIC9Bi5HcSEW88cbeunZrM8gALTFGTO3nnc+IlP8zwFboJIYmuNg4ON8qa90SzMc/\nRxdMosIGlgnW2/4/PEZB31jiVg88O8EckzXZOFKs7sjsLjBOlDW0JB9LeGna8gI4\nzJVSk/BwJVmcIGfE7vmLV2H0knZ9P4SNVbfo5azV8fUZVqZa+5Acr5Pr5RzUZ5dd\nBA6+C4OmF4O5MBKgxTMVBbkN+8cFduPYSo38NBejxiEovjBFMR7HeL5YYTisO+IB\nZQ==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            4e:81:2d:8a:82:65:e0:0b:02:ee:3e:35:02:46:e5:3d\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO Certification Authority\n        Validity\n            Not Before: Dec  1 00:00:00 2006 GMT\n            Not After : Dec 31 23:59:59 2029 GMT\n        Subject: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:d0:40:8b:8b:72:e3:91:1b:f7:51:c1:1b:54:04:\n                    98:d3:a9:bf:c1:e6:8a:5d:3b:87:fb:bb:88:ce:0d:\n                    e3:2f:3f:06:96:f0:a2:29:50:99:ae:db:3b:a1:57:\n                    b0:74:51:71:cd:ed:42:91:4d:41:fe:a9:c8:d8:6a:\n                    86:77:44:bb:59:66:97:50:5e:b4:d4:2c:70:44:cf:\n                    da:37:95:42:69:3c:30:c4:71:b3:52:f0:21:4d:a1:\n                    d8:ba:39:7c:1c:9e:a3:24:9d:f2:83:16:98:aa:16:\n                    7c:43:9b:15:5b:b7:ae:34:91:fe:d4:62:26:18:46:\n                    9a:3f:eb:c1:f9:f1:90:57:eb:ac:7a:0d:8b:db:72:\n                    30:6a:66:d5:e0:46:a3:70:dc:68:d9:ff:04:48:89:\n                    77:de:b5:e9:fb:67:6d:41:e9:bc:39:bd:32:d9:62:\n                    02:f1:b1:a8:3d:6e:37:9c:e2:2f:e2:d3:a2:26:8b:\n                    c6:b8:55:43:88:e1:23:3e:a5:d2:24:39:6a:47:ab:\n                    00:d4:a1:b3:a9:25:fe:0d:3f:a7:1d:ba:d3:51:c1:\n                    0b:a4:da:ac:38:ef:55:50:24:05:65:46:93:34:4f:\n                    2d:8d:ad:c6:d4:21:19:d2:8e:ca:05:61:71:07:73:\n                    47:e5:8a:19:12:bd:04:4d:ce:4e:9c:a5:48:ac:bb:\n                    26:f7\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                0B:58:E5:8B:C6:4C:15:37:A4:40:A9:30:A9:21:BE:47:36:5A:56:FF\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 CRL Distribution Points: \n\n                Full Name:\n                  URI:http://crl.comodoca.com/COMODOCertificationAuthority.crl\n\n    Signature Algorithm: sha1WithRSAEncryption\n         3e:98:9e:9b:f6:1b:e9:d7:39:b7:78:ae:1d:72:18:49:d3:87:\n         e4:43:82:eb:3f:c9:aa:f5:a8:b5:ef:55:7c:21:52:65:f9:d5:\n         0d:e1:6c:f4:3e:8c:93:73:91:2e:02:c4:4e:07:71:6f:c0:8f:\n         38:61:08:a8:1e:81:0a:c0:2f:20:2f:41:8b:91:dc:48:45:bc:\n         f1:c6:de:ba:76:6b:33:c8:00:2d:31:46:4c:ed:e7:9d:cf:88:\n         94:ff:33:c0:56:e8:24:86:26:b8:d8:38:38:df:2a:6b:dd:12:\n         cc:c7:3f:47:17:4c:a2:c2:06:96:09:d6:db:fe:3f:3c:46:41:\n         df:58:e2:56:0f:3c:3b:c1:1c:93:35:d9:38:52:ac:ee:c8:ec:\n         2e:30:4e:94:35:b4:24:1f:4b:78:69:da:f2:02:38:cc:95:52:\n         93:f0:70:25:59:9c:20:67:c4:ee:f9:8b:57:61:f4:92:76:7d:\n         3f:84:8d:55:b7:e8:e5:ac:d5:f1:f5:19:56:a6:5a:fb:90:1c:\n         af:93:eb:e5:1c:d4:67:97:5d:04:0e:be:0b:83:a6:17:83:b9:\n         30:12:a0:c5:33:15:05:b9:0d:fb:c7:05:76:e3:d8:4a:8d:fc:\n         34:17:a3:c6:21:28:be:30:45:31:1e:c7:78:be:58:61:38:ac:\n         3b:e2:01:65\nSHA1 Fingerprint=66:31:BF:9E:F7:4F:9E:B6:C9:D5:A6:0C:BA:6A:BE:D1:F7:BD:EF:7B\n",
    "155f35575155fb25b2ad0369fc01a3fabe1155d5": "-----BEGIN CERTIFICATE-----\nMIICrjCCAjWgAwIBAgIQPLL0SAoA4v7rJDteYD7DazAKBggqhkjOPQQDAzCBmDEL\nMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUdlb1RydXN0IEluYy4xOTA3BgNVBAsTMChj\nKSAyMDA3IEdlb1RydXN0IEluYy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTE2\nMDQGA1UEAxMtR2VvVHJ1c3QgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0\neSAtIEcyMB4XDTA3MTEwNTAwMDAwMFoXDTM4MDExODIzNTk1OVowgZgxCzAJBgNV\nBAYTAlVTMRYwFAYDVQQKEw1HZW9UcnVzdCBJbmMuMTkwNwYDVQQLEzAoYykgMjAw\nNyBHZW9UcnVzdCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxNjA0BgNV\nBAMTLUdlb1RydXN0IFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBH\nMjB2MBAGByqGSM49AgEGBSuBBAAiA2IABBWx6P0DFUPlrOuHNxFi79KDNlJ9RVcL\nSo17VDs6bl8VAsBQps8lL33KSLjHUGMcKiEIfJo22Av+0SbFWDEwKCXzXV2juLal\ntJLtbCyf691DiaI8S0iRHVDsJt/WYC69IaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAO\nBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFBVfNVdRVfslsq0DafwBo/q+EVXVMAoG\nCCqGSM49BAMDA2cAMGQCMGSWWaboCd6LuvpaiIjwH5HTRqjySkwCY/tsXzjbLkGT\nqQ7mndwxHLKgpxgceeHHNgIwOlavmnRs9vuD4DPTCF+hnMJbn0bWtsuRBmOiBucz\nrD6ogRLQy7rQkgu2npaqBA+K\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            3c:b2:f4:48:0a:00:e2:fe:eb:24:3b:5e:60:3e:c3:6b\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, O=GeoTrust Inc., OU=(c) 2007 GeoTrust Inc. - For authorized use only, CN=GeoTrust Primary Certification Authority - G2\n        Validity\n            Not Before: Nov  5 00:00:00 2007 GMT\n            Not After : Jan 18 23:59:59 2038 GMT\n        Subject: C=US, O=GeoTrust Inc., OU=(c) 2007 GeoTrust Inc. - For authorized use only, CN=GeoTrust Primary Certification Authority - G2\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:15:b1:e8:fd:03:15:43:e5:ac:eb:87:37:11:62:\n                    ef:d2:83:36:52:7d:45:57:0b:4a:8d:7b:54:3b:3a:\n                    6e:5f:15:02:c0:50:a6:cf:25:2f:7d:ca:48:b8:c7:\n                    50:63:1c:2a:21:08:7c:9a:36:d8:0b:fe:d1:26:c5:\n                    58:31:30:28:25:f3:5d:5d:a3:b8:b6:a5:b4:92:ed:\n                    6c:2c:9f:eb:dd:43:89:a2:3c:4b:48:91:1d:50:ec:\n                    26:df:d6:60:2e:bd:21\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                15:5F:35:57:51:55:FB:25:B2:AD:03:69:FC:01:A3:FA:BE:11:55:D5\n    Signature Algorithm: ecdsa-with-SHA384\n         30:64:02:30:64:96:59:a6:e8:09:de:8b:ba:fa:5a:88:88:f0:\n         1f:91:d3:46:a8:f2:4a:4c:02:63:fb:6c:5f:38:db:2e:41:93:\n         a9:0e:e6:9d:dc:31:1c:b2:a0:a7:18:1c:79:e1:c7:36:02:30:\n         3a:56:af:9a:74:6c:f6:fb:83:e0:33:d3:08:5f:a1:9c:c2:5b:\n         9f:46:d6:b6:cb:91:06:63:a2:06:e7:33:ac:3e:a8:81:12:d0:\n         cb:ba:d0:92:0b:b6:9e:96:aa:04:0f:8a\nSHA1 Fingerprint=8D:17:84:D5:37:F3:03:7D:EC:70:FE:57:8B:51:9A:99:E6:10:D7:B0\n",
    "179dcd1e8bd6392b70d35cd4a0b81fb000fcc561": "-----BEGIN CERTIFICATE-----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\nmpv0\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            08:16:5f:8a:4c:a5:ec:00:c9:93:40:df:c4:c6:ae:23:b8:1c:5a:a4\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=HK, ST=Hong Kong, L=Hong Kong, O=Hongkong Post, CN=Hongkong Post Root CA 3\n        Validity\n            Not Before: Jun  3 02:29:46 2017 GMT\n            Not After : Jun  3 02:29:46 2042 GMT\n        Subject: C=HK, ST=Hong Kong, L=Hong Kong, O=Hongkong Post, CN=Hongkong Post Root CA 3\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:b3:88:d7:ea:ce:0f:20:4e:be:e6:d6:03:6d:ee:\n                    59:fc:c2:57:df:29:68:a1:83:0e:3e:68:c7:68:58:\n                    9c:1c:60:4b:89:43:0c:b9:d4:15:b2:ee:c1:4e:75:\n                    e9:b5:a7:ef:e5:e9:35:99:e4:cc:1c:e7:4b:5f:8d:\n                    33:30:20:33:53:d9:a6:bb:d5:3e:13:8e:e9:1f:87:\n                    49:ad:50:2d:50:ca:18:be:01:58:a2:13:70:96:bb:\n                    89:88:56:80:5c:f8:bd:2c:3c:e1:4c:57:88:bb:d3:\n                    b9:95:ef:cb:c7:f6:da:31:74:28:a6:e6:54:89:f5:\n                    41:31:ca:e5:26:1a:cd:82:e0:70:da:3b:29:bb:d5:\n                    03:f5:99:ba:55:f5:64:d1:60:0e:b3:89:49:b8:8a:\n                    2f:05:d2:84:45:28:7c:8f:68:50:12:78:fc:0b:b5:\n                    53:cb:c2:98:1c:84:a3:9e:b0:be:23:a4:da:dc:c8:\n                    2b:1e:da:6e:45:1e:89:98:da:f9:00:2e:06:e9:0c:\n                    3b:70:d5:50:25:88:99:cb:cd:73:60:f7:d5:ff:35:\n                    67:c5:a1:bc:5e:ab:cd:4a:b8:45:eb:c8:68:1e:0d:\n                    0d:14:46:12:e3:d2:64:62:8a:42:98:bc:b4:c6:08:\n                    08:f8:fd:a8:4c:64:9c:76:01:bd:2f:a9:6c:33:0f:\n                    d8:3f:28:b8:3c:69:01:42:86:7e:69:c1:c9:06:ca:\n                    e5:7a:46:65:e9:c2:d6:50:41:2e:3f:b7:e4:ed:6c:\n                    d7:bf:26:01:11:a2:16:29:4a:6b:34:06:90:ec:13:\n                    d2:b6:fb:6a:76:d2:3c:ed:f0:d6:2d:dd:e1:15:ec:\n                    a3:9b:2f:2c:c9:3e:2b:e4:69:3b:ff:72:25:b1:36:\n                    86:5b:c7:7f:6b:8b:55:1b:4a:c5:20:61:3d:ae:cb:\n                    50:e1:08:3a:be:b0:8f:63:41:53:30:08:59:3c:98:\n                    1d:77:ba:63:91:7a:ca:10:50:60:bf:f0:d7:bc:95:\n                    87:8f:97:c5:fe:97:6a:01:94:a3:7c:5b:85:1d:2a:\n                    39:3a:d0:54:a1:d1:39:71:9d:fd:21:f9:b5:7b:f0:\n                    e2:e0:02:8f:6e:96:24:25:2c:a0:1e:2c:a8:c4:89:\n                    a7:ef:ed:99:06:2f:b6:0a:4c:4f:db:a2:cc:37:1a:\n                    af:47:85:2d:8a:5f:c4:34:34:4c:00:fd:18:93:67:\n                    13:d1:37:e6:48:b4:8b:06:c5:57:7b:19:86:0a:79:\n                    cb:00:c9:52:af:42:ff:37:8f:e1:a3:1e:7a:3d:50:\n                    ab:63:06:e7:15:b5:3f:b6:45:37:94:37:b1:7e:f2:\n                    48:c3:7f:c5:75:fe:97:8d:45:8f:1a:a7:1a:72:28:\n                    1a:40:0f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Authority Key Identifier: \n                keyid:17:9D:CD:1E:8B:D6:39:2B:70:D3:5C:D4:A0:B8:1F:B0:00:FC:C5:61\n\n            X509v3 Subject Key Identifier: \n                17:9D:CD:1E:8B:D6:39:2B:70:D3:5C:D4:A0:B8:1F:B0:00:FC:C5:61\n    Signature Algorithm: sha256WithRSAEncryption\n         56:d5:7b:6e:e6:22:01:d2:42:9b:18:d5:0e:d7:66:23:5c:e3:\n         fe:a0:c7:92:d2:e9:94:ad:4b:a2:c6:ec:12:7c:74:d5:48:d2:\n         59:14:99:c0:eb:b9:d1:eb:f4:48:30:5b:ad:a7:57:73:99:a9:\n         d3:e5:b7:d1:2e:59:24:58:dc:68:2e:2e:62:d8:6a:e4:70:0b:\n         2d:20:50:20:a4:32:95:d1:00:98:bb:d3:fd:f7:32:f2:49:ae:\n         c6:7a:e0:47:be:6e:ce:cb:a3:72:3a:2d:69:5d:cb:c8:e8:45:\n         39:d4:fa:42:c1:11:4c:77:5d:92:fb:6a:ff:58:44:e5:eb:81:\n         9e:af:a0:99:ad:be:a9:01:66:cb:38:1d:3c:df:43:1f:f4:4d:\n         6e:b4:ba:17:46:fc:7d:fd:87:81:79:6a:0d:33:0f:fa:2f:f8:\n         14:b9:80:b3:5d:4d:aa:97:e1:f9:e4:18:c5:f8:d5:38:8c:26:\n         3c:fd:f2:28:e2:ee:5a:49:88:2c:df:79:3d:8e:9e:90:3c:bd:\n         41:4a:3a:dd:5b:f6:9a:b4:ce:3f:25:30:7f:32:7d:a2:03:94:\n         d0:dc:7a:a1:52:de:6e:93:8d:18:26:fd:55:ac:bd:8f:9b:d2:\n         cf:af:e7:86:2c:cb:1f:09:6f:a3:6f:a9:84:d4:73:bf:4d:a1:\n         74:1b:4e:23:60:f2:cc:0e:aa:7f:a4:9c:4c:25:a8:b2:66:3b:\n         38:ff:d9:94:30:f6:72:84:be:68:55:10:0f:c6:73:2c:16:69:\n         93:07:fe:b1:45:ed:bb:a2:55:6a:b0:da:b5:4a:02:25:27:85:\n         d7:b7:b7:86:44:16:89:6c:80:2b:3e:97:a9:9c:d5:7e:55:4c:\n         c6:de:45:10:1c:ea:e9:3b:9f:03:53:ee:ee:7a:01:02:16:78:\n         d4:e8:c2:be:46:76:88:13:3f:22:bb:48:12:1d:52:00:b4:02:\n         7e:21:1a:1e:9c:25:f4:f3:3d:5e:1e:d2:1c:f9:b3:2d:b6:f7:\n         37:5c:c6:cb:21:4e:b0:f7:99:47:18:85:c1:2b:ba:55:ae:06:\n         ea:d0:07:b2:dc:ab:d0:82:96:75:ce:d2:50:fe:99:e7:cf:2f:\n         9f:e7:76:d1:61:2a:fb:21:bb:31:d0:aa:9f:47:a4:b2:22:ca:\n         16:3a:50:57:c4:5b:43:67:c5:65:62:03:49:01:eb:43:d9:d8:\n         f8:9e:ad:cf:b1:63:0e:45:f4:a0:5a:2c:9b:2d:c5:a6:c0:ad:\n         a8:47:f4:27:4c:38:0d:2e:1b:49:3b:52:f4:e8:88:83:2b:54:\n         28:d4:f2:35:52:b4:32:83:62:69:64:0c:91:9c:9f:97:ea:74:\n         16:fd:1f:11:06:9a:9b:f4\nSHA1 Fingerprint=58:A2:D0:EC:20:52:81:5B:C1:F3:F8:64:02:24:4E:C2:8E:02:4B:02\n",
    "17a0cdc1e441b63a5b3bcb459dbd1cc298fa8658": "-----BEGIN CERTIFICATE-----\nMIIFvTCCA6WgAwIBAgIITxvUL1S7L0swDQYJKoZIhvcNAQEFBQAwRzELMAkGA1UE\nBhMCQ0gxFTATBgNVBAoTDFN3aXNzU2lnbiBBRzEhMB8GA1UEAxMYU3dpc3NTaWdu\nIFNpbHZlciBDQSAtIEcyMB4XDTA2MTAyNTA4MzI0NloXDTM2MTAyNTA4MzI0Nlow\nRzELMAkGA1UEBhMCQ0gxFTATBgNVBAoTDFN3aXNzU2lnbiBBRzEhMB8GA1UEAxMY\nU3dpc3NTaWduIFNpbHZlciBDQSAtIEcyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8A\nMIICCgKCAgEAxPGHf9N4Mfc4yfjDmUO8x/e8N+dOcbpLj6VzHVxumK4DV644N0Mv\nFz0fyM5oEMF4rhkDKxD6LHmD9ui5aLlV8gREpzn5/ASLHvGiTSf5YXu6t+WiE7br\nYT7QbNHm+/pe7R20nqA1W6GSy/BJkv6FCgU+5tkL4k+73JU3/JHpMjUi0R86TieF\nnbAVlDLaYQ1HTWBCrpJH6INaUFjpiou5XaHc3ZlKHzZnu0jkg7Y360g6rw9njxcH\n6ATK72oxh9TAtvmUcXtnZLi2kUpCe2UuMGoM9ZDulebyzYLs2aFK7PayS+VFheZt\neJMELpyCbTapxDFkH4aDCyr0NQp4yVXPQbBH6TCfmb5hqAaEuSh6XzjZG6k4sIN/\nc8HDO0gqgg8hm7jMqDXDhBuDsz6+pJVpATqJAHgE2cn0mRmrVn5bi4Y5FZGkECwJ\nMoBgs5PAKrYYC51+jUnyEEp/+dVGLxmSo5mnJqy7jDzmDrxHB9xzUfFwZC8I+bRH\nHTBsROopN4WSaGa8gzj+ezku01DwH/teYLappvonQfGbGHLy9YR0SslnxFSuSGTf\njNFusB3hB48IHpmccelM2KX3RxIfdNFRnobzwqIjQAtz20um53MGjMGg6cFZrEb6\n5i/4z3GcRm25xBWNOHkDRUjvxF3XCO6HOSKGsg0PWEP3calILv3q1h8CAwEAAaOB\nrDCBqTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU\nF6DNweRBtjpbO8tFnb0cwpj6hlgwHwYDVR0jBBgwFoAUF6DNweRBtjpbO8tFnb0c\nwpj6hlgwRgYDVR0gBD8wPTA7BglghXQBWQEDAQEwLjAsBggrBgEFBQcCARYgaHR0\ncDovL3JlcG9zaXRvcnkuc3dpc3NzaWduLmNvbS8wDQYJKoZIhvcNAQEFBQADggIB\nAHPGgeAn0i0P4JUw4ppBf1AsX19iYamGamkYDHRJ1l2E6kFSGG9YrVBWIGrGvShp\nWJHckRE1qTodvBqlYJ7YH39FkWnZfrt4csEGDyrOj4VwYaygzQu4OSlWhDJOhrs9\nxCrZ1x9y7v5RoSJBsXECYxqCsGKrXlcSH9/L3XWgwF15kIwb4FDm3jH+mHtwX6WQ\n2K34ArZv02DdQEsixT2tOnqfGhpHkXkzuoLcMmkDlm4fS/Bx/uNncqCxv1yL5PqZ\nIseEuRuNI5c/7SXgz2W79WEE790eslpBIlqhn10s6FvJbakMDHiqYMZWjwFaDGi8\naRl5xB9+lwW/xekkUV7U1UtT7dkjWjYDZaPBA61BMPNGG4WQr2W11bHkFlt4dR2X\nem1ZqSqPe97Dh4kQmUlzeMg9vVE1dCrV8X5pGyq7O70luJpaPXJhkGaH7gzWTdQR\ndAtq/gsD/KNVV4n+SsuuWxcFyPKNIzFTONItaj+CuY0IavdeQXRuwxF+B6wpYJE/\nOMpXEA29MC/HpeZBoNquBYeaoKRlbEwJDIm6uNO5wJOKMPqN5ZprFQFOZ6raYlY+\nhAhm0sQ2fac+EPyI4NSA5QC9qvNOBqN6avlicuMJT+ubDgEj8Z+7fNzcbBGXJbLy\ntGMU0gYqZ4yD9c7qB9iaah7s5Aq7KkzrCWA5zspi2C5u\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 5700383053117599563 (0x4f1bd42f54bb2f4b)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=CH, O=SwissSign AG, CN=SwissSign Silver CA - G2\n        Validity\n            Not Before: Oct 25 08:32:46 2006 GMT\n            Not After : Oct 25 08:32:46 2036 GMT\n        Subject: C=CH, O=SwissSign AG, CN=SwissSign Silver CA - G2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:c4:f1:87:7f:d3:78:31:f7:38:c9:f8:c3:99:43:\n                    bc:c7:f7:bc:37:e7:4e:71:ba:4b:8f:a5:73:1d:5c:\n                    6e:98:ae:03:57:ae:38:37:43:2f:17:3d:1f:c8:ce:\n                    68:10:c1:78:ae:19:03:2b:10:fa:2c:79:83:f6:e8:\n                    b9:68:b9:55:f2:04:44:a7:39:f9:fc:04:8b:1e:f1:\n                    a2:4d:27:f9:61:7b:ba:b7:e5:a2:13:b6:eb:61:3e:\n                    d0:6c:d1:e6:fb:fa:5e:ed:1d:b4:9e:a0:35:5b:a1:\n                    92:cb:f0:49:92:fe:85:0a:05:3e:e6:d9:0b:e2:4f:\n                    bb:dc:95:37:fc:91:e9:32:35:22:d1:1f:3a:4e:27:\n                    85:9d:b0:15:94:32:da:61:0d:47:4d:60:42:ae:92:\n                    47:e8:83:5a:50:58:e9:8a:8b:b9:5d:a1:dc:dd:99:\n                    4a:1f:36:67:bb:48:e4:83:b6:37:eb:48:3a:af:0f:\n                    67:8f:17:07:e8:04:ca:ef:6a:31:87:d4:c0:b6:f9:\n                    94:71:7b:67:64:b8:b6:91:4a:42:7b:65:2e:30:6a:\n                    0c:f5:90:ee:95:e6:f2:cd:82:ec:d9:a1:4a:ec:f6:\n                    b2:4b:e5:45:85:e6:6d:78:93:04:2e:9c:82:6d:36:\n                    a9:c4:31:64:1f:86:83:0b:2a:f4:35:0a:78:c9:55:\n                    cf:41:b0:47:e9:30:9f:99:be:61:a8:06:84:b9:28:\n                    7a:5f:38:d9:1b:a9:38:b0:83:7f:73:c1:c3:3b:48:\n                    2a:82:0f:21:9b:b8:cc:a8:35:c3:84:1b:83:b3:3e:\n                    be:a4:95:69:01:3a:89:00:78:04:d9:c9:f4:99:19:\n                    ab:56:7e:5b:8b:86:39:15:91:a4:10:2c:09:32:80:\n                    60:b3:93:c0:2a:b6:18:0b:9d:7e:8d:49:f2:10:4a:\n                    7f:f9:d5:46:2f:19:92:a3:99:a7:26:ac:bb:8c:3c:\n                    e6:0e:bc:47:07:dc:73:51:f1:70:64:2f:08:f9:b4:\n                    47:1d:30:6c:44:ea:29:37:85:92:68:66:bc:83:38:\n                    fe:7b:39:2e:d3:50:f0:1f:fb:5e:60:b6:a9:a6:fa:\n                    27:41:f1:9b:18:72:f2:f5:84:74:4a:c9:67:c4:54:\n                    ae:48:64:df:8c:d1:6e:b0:1d:e1:07:8f:08:1e:99:\n                    9c:71:e9:4c:d8:a5:f7:47:12:1f:74:d1:51:9e:86:\n                    f3:c2:a2:23:40:0b:73:db:4b:a6:e7:73:06:8c:c1:\n                    a0:e9:c1:59:ac:46:fa:e6:2f:f8:cf:71:9c:46:6d:\n                    b9:c4:15:8d:38:79:03:45:48:ef:c4:5d:d7:08:ee:\n                    87:39:22:86:b2:0d:0f:58:43:f7:71:a9:48:2e:fd:\n                    ea:d6:1f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                17:A0:CD:C1:E4:41:B6:3A:5B:3B:CB:45:9D:BD:1C:C2:98:FA:86:58\n            X509v3 Authority Key Identifier: \n                keyid:17:A0:CD:C1:E4:41:B6:3A:5B:3B:CB:45:9D:BD:1C:C2:98:FA:86:58\n\n            X509v3 Certificate Policies: \n                Policy: 2.16.756.1.89.1.3.1.1\n                  CPS: http://repository.swisssign.com/\n\n    Signature Algorithm: sha1WithRSAEncryption\n         73:c6:81:e0:27:d2:2d:0f:e0:95:30:e2:9a:41:7f:50:2c:5f:\n         5f:62:61:a9:86:6a:69:18:0c:74:49:d6:5d:84:ea:41:52:18:\n         6f:58:ad:50:56:20:6a:c6:bd:28:69:58:91:dc:91:11:35:a9:\n         3a:1d:bc:1a:a5:60:9e:d8:1f:7f:45:91:69:d9:7e:bb:78:72:\n         c1:06:0f:2a:ce:8f:85:70:61:ac:a0:cd:0b:b8:39:29:56:84:\n         32:4e:86:bb:3d:c4:2a:d9:d7:1f:72:ee:fe:51:a1:22:41:b1:\n         71:02:63:1a:82:b0:62:ab:5e:57:12:1f:df:cb:dd:75:a0:c0:\n         5d:79:90:8c:1b:e0:50:e6:de:31:fe:98:7b:70:5f:a5:90:d8:\n         ad:f8:02:b6:6f:d3:60:dd:40:4b:22:c5:3d:ad:3a:7a:9f:1a:\n         1a:47:91:79:33:ba:82:dc:32:69:03:96:6e:1f:4b:f0:71:fe:\n         e3:67:72:a0:b1:bf:5c:8b:e4:fa:99:22:c7:84:b9:1b:8d:23:\n         97:3f:ed:25:e0:cf:65:bb:f5:61:04:ef:dd:1e:b2:5a:41:22:\n         5a:a1:9f:5d:2c:e8:5b:c9:6d:a9:0c:0c:78:aa:60:c6:56:8f:\n         01:5a:0c:68:bc:69:19:79:c4:1f:7e:97:05:bf:c5:e9:24:51:\n         5e:d4:d5:4b:53:ed:d9:23:5a:36:03:65:a3:c1:03:ad:41:30:\n         f3:46:1b:85:90:af:65:b5:d5:b1:e4:16:5b:78:75:1d:97:7a:\n         6d:59:a9:2a:8f:7b:de:c3:87:89:10:99:49:73:78:c8:3d:bd:\n         51:35:74:2a:d5:f1:7e:69:1b:2a:bb:3b:bd:25:b8:9a:5a:3d:\n         72:61:90:66:87:ee:0c:d6:4d:d4:11:74:0b:6a:fe:0b:03:fc:\n         a3:55:57:89:fe:4a:cb:ae:5b:17:05:c8:f2:8d:23:31:53:38:\n         d2:2d:6a:3f:82:b9:8d:08:6a:f7:5e:41:74:6e:c3:11:7e:07:\n         ac:29:60:91:3f:38:ca:57:10:0d:bd:30:2f:c7:a5:e6:41:a0:\n         da:ae:05:87:9a:a0:a4:65:6c:4c:09:0c:89:ba:b8:d3:b9:c0:\n         93:8a:30:fa:8d:e5:9a:6b:15:01:4e:67:aa:da:62:56:3e:84:\n         08:66:d2:c4:36:7d:a7:3e:10:fc:88:e0:d4:80:e5:00:bd:aa:\n         f3:4e:06:a3:7a:6a:f9:62:72:e3:09:4f:eb:9b:0e:01:23:f1:\n         9f:bb:7c:dc:dc:6c:11:97:25:b2:f2:b4:63:14:d2:06:2a:67:\n         8c:83:f5:ce:ea:07:d8:9a:6a:1e:ec:e4:0a:bb:2a:4c:eb:09:\n         60:39:ce:ca:62:d8:2e:6e\nSHA1 Fingerprint=9B:AA:E5:9F:56:EE:21:CB:43:5A:BE:25:93:DF:A7:F0:40:D1:1D:CB\n",
    "188756e06e77ee24353c4e739a1fd6e1e2797e2b": "-----BEGIN CERTIFICATE-----\nMIIGWzCCBEOgAwIBAgIRAMrpG4nxVQMNo+ZBbcTjpuEwDQYJKoZIhvcNAQELBQAw\nWjELMAkGA1UEBhMCRlIxEjAQBgNVBAoMCURoaW15b3RpczEcMBoGA1UECwwTMDAw\nMiA0ODE0NjMwODEwMDAzNjEZMBcGA1UEAwwQQ2VydGlnbmEgUm9vdCBDQTAeFw0x\nMzEwMDEwODMyMjdaFw0zMzEwMDEwODMyMjdaMFoxCzAJBgNVBAYTAkZSMRIwEAYD\nVQQKDAlEaGlteW90aXMxHDAaBgNVBAsMEzAwMDIgNDgxNDYzMDgxMDAwMzYxGTAX\nBgNVBAMMEENlcnRpZ25hIFJvb3QgQ0EwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAw\nggIKAoICAQDNGDllGlmx6mQWDoyUJJV8g9PFOSbcDO8WV43X2KyjQn+Cyu3NW9sO\nty3tRQgXstmzy9YXUnIo245Onoq2C/mehJpNdt4iKVzSs9IGPjA5qXSjklYcoW9M\nCiBtnyN6tMbaLOQdLNyzKNAT8kxOAkmhVECe5uUFoC2EyP+YbNDrihqECB63aCPu\nI9Vwzm1RaRDuoXrC0SIxwoKF0vJVdlB8JXrJhFwLrN1CTivngqIkicuQstDuI7pm\nTLtipPlTWmR7fJj6o0ieD5Wupxj0auwuA0Wv8HT4Ks16XdG+RCYyKfHx9WzMfgIh\nC59vpD++nVPiz32pLHxYGpfhPTc3GGYo0kDFUYqMwy3OU4gkWGQwFsWq4NYKpkDf\nePb1BHxpE4S80dGnBs8B92jAqFe7OmGtBIyT46388NtEbVncSVmurJqZNjBBe3Yz\nIoejwpKGbvlw7q6Hh5UbxHq9MfPU0uWZ/75I7HX1eBYdpnDBfzwboZL7z8g81sWT\nCo/1VTp2lc5ZmIoJlXcymoO6LAQ6l73UL77XbJuiyn1tJslV1c/DeVIICZkHJC1k\nJWumIWmbat10TWuXekG9qxf5kBdIjzb5LdXF2+6qhUVB+s06RbFo5jZMm5BX7CO5\nhwjCxAnxl4YqKE3idMDaxIzb3+KhF1nOJFl0Mdp//TBt2dzhauH8XwIDAQABo4IB\nGjCCARYwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYE\nFBiHVuBud+4kNTxOc5of1uHieX4rMB8GA1UdIwQYMBaAFBiHVuBud+4kNTxOc5of\n1uHieX4rMEQGA1UdIAQ9MDswOQYEVR0gADAxMC8GCCsGAQUFBwIBFiNodHRwczov\nL3d3d3cuY2VydGlnbmEuZnIvYXV0b3JpdGVzLzBtBgNVHR8EZjBkMC+gLaArhilo\ndHRwOi8vY3JsLmNlcnRpZ25hLmZyL2NlcnRpZ25hcm9vdGNhLmNybDAxoC+gLYYr\naHR0cDovL2NybC5kaGlteW90aXMuY29tL2NlcnRpZ25hcm9vdGNhLmNybDANBgkq\nhkiG9w0BAQsFAAOCAgEAlLieT/DjlQgi581oQfccVdV8AOItOoldaDgvUSILSo3L\n6btdPrtcPbEo/uRTVRPPoZAbAh1fZkYJMyjhDSSXcNMQH+pkV5a7XdrnxIxPTGRG\nHVyH41neQtGbqH6mid2PHMkwgu07nM3A6RngatgCdTer9zQoKJHyBApPNeNgJgH6\n0BGM+RFq7q89w1DTj18zeTyGqHNFkIwgtnJzFyO+B2XleJINugHA64wcZr+shncB\nlA2c5uk5jR+mUYyZDDl34bSb+hxnV29qao6pK0xXeXpXIs/NX2NGjVxZOob4Mkdi\no2cNGJHc+6Zr9UhhcyNZjgKnvETq9Emd8VRY+WCv2hikLyhF3HqgiIZd8zvn/yk1\ngPxkQ5Tm4xxvvq0OKmOZK8l+hfZx6AYDlf7ej0gcWtSS6Cvu5zHbugRqh5jnxV/v\nfaci9wHYTfmJ0A6aBVmknpjZbyvKcL5kwlWj9Omvw5Ip3IgWJJk8jSaYtlu3zM63\nNwf9JtmYhST/WSMDmu2dnajkXjjO11INb9I/bbEFa0nOipFGc/T2L/Coc3cOZayh\njWZSaX5LaAzHHjcng6WMxwLkFM1JAbBzs/3GkDpv0mztO+7skb6iQ12LAEpmJURw\n3kAP+HwV96LOPNdeE4yBFxgX0b3xdxA61GU5wSesVywlVP+i2k+KYTlerj1KjL0=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            ca:e9:1b:89:f1:55:03:0d:a3:e6:41:6d:c4:e3:a6:e1\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=FR, O=Dhimyotis, OU=0002 48146308100036, CN=Certigna Root CA\n        Validity\n            Not Before: Oct  1 08:32:27 2013 GMT\n            Not After : Oct  1 08:32:27 2033 GMT\n        Subject: C=FR, O=Dhimyotis, OU=0002 48146308100036, CN=Certigna Root CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:cd:18:39:65:1a:59:b1:ea:64:16:0e:8c:94:24:\n                    95:7c:83:d3:c5:39:26:dc:0c:ef:16:57:8d:d7:d8:\n                    ac:a3:42:7f:82:ca:ed:cd:5b:db:0e:b7:2d:ed:45:\n                    08:17:b2:d9:b3:cb:d6:17:52:72:28:db:8e:4e:9e:\n                    8a:b6:0b:f9:9e:84:9a:4d:76:de:22:29:5c:d2:b3:\n                    d2:06:3e:30:39:a9:74:a3:92:56:1c:a1:6f:4c:0a:\n                    20:6d:9f:23:7a:b4:c6:da:2c:e4:1d:2c:dc:b3:28:\n                    d0:13:f2:4c:4e:02:49:a1:54:40:9e:e6:e5:05:a0:\n                    2d:84:c8:ff:98:6c:d0:eb:8a:1a:84:08:1e:b7:68:\n                    23:ee:23:d5:70:ce:6d:51:69:10:ee:a1:7a:c2:d1:\n                    22:31:c2:82:85:d2:f2:55:76:50:7c:25:7a:c9:84:\n                    5c:0b:ac:dd:42:4e:2b:e7:82:a2:24:89:cb:90:b2:\n                    d0:ee:23:ba:66:4c:bb:62:a4:f9:53:5a:64:7b:7c:\n                    98:fa:a3:48:9e:0f:95:ae:a7:18:f4:6a:ec:2e:03:\n                    45:af:f0:74:f8:2a:cd:7a:5d:d1:be:44:26:32:29:\n                    f1:f1:f5:6c:cc:7e:02:21:0b:9f:6f:a4:3f:be:9d:\n                    53:e2:cf:7d:a9:2c:7c:58:1a:97:e1:3d:37:37:18:\n                    66:28:d2:40:c5:51:8a:8c:c3:2d:ce:53:88:24:58:\n                    64:30:16:c5:aa:e0:d6:0a:a6:40:df:78:f6:f5:04:\n                    7c:69:13:84:bc:d1:d1:a7:06:cf:01:f7:68:c0:a8:\n                    57:bb:3a:61:ad:04:8c:93:e3:ad:fc:f0:db:44:6d:\n                    59:dc:49:59:ae:ac:9a:99:36:30:41:7b:76:33:22:\n                    87:a3:c2:92:86:6e:f9:70:ee:ae:87:87:95:1b:c4:\n                    7a:bd:31:f3:d4:d2:e5:99:ff:be:48:ec:75:f5:78:\n                    16:1d:a6:70:c1:7f:3c:1b:a1:92:fb:cf:c8:3c:d6:\n                    c5:93:0a:8f:f5:55:3a:76:95:ce:59:98:8a:09:95:\n                    77:32:9a:83:ba:2c:04:3a:97:bd:d4:2f:be:d7:6c:\n                    9b:a2:ca:7d:6d:26:c9:55:d5:cf:c3:79:52:08:09:\n                    99:07:24:2d:64:25:6b:a6:21:69:9b:6a:dd:74:4d:\n                    6b:97:7a:41:bd:ab:17:f9:90:17:48:8f:36:f9:2d:\n                    d5:c5:db:ee:aa:85:45:41:fa:cd:3a:45:b1:68:e6:\n                    36:4c:9b:90:57:ec:23:b9:87:08:c2:c4:09:f1:97:\n                    86:2a:28:4d:e2:74:c0:da:c4:8c:db:df:e2:a1:17:\n                    59:ce:24:59:74:31:da:7f:fd:30:6d:d9:dc:e1:6a:\n                    e1:fc:5f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                18:87:56:E0:6E:77:EE:24:35:3C:4E:73:9A:1F:D6:E1:E2:79:7E:2B\n            X509v3 Authority Key Identifier: \n                keyid:18:87:56:E0:6E:77:EE:24:35:3C:4E:73:9A:1F:D6:E1:E2:79:7E:2B\n\n            X509v3 Certificate Policies: \n                Policy: X509v3 Any Policy\n                  CPS: https://wwww.certigna.fr/autorites/\n\n            X509v3 CRL Distribution Points: \n\n                Full Name:\n                  URI:http://crl.certigna.fr/certignarootca.crl\n\n                Full Name:\n                  URI:http://crl.dhimyotis.com/certignarootca.crl\n\n    Signature Algorithm: sha256WithRSAEncryption\n         94:b8:9e:4f:f0:e3:95:08:22:e7:cd:68:41:f7:1c:55:d5:7c:\n         00:e2:2d:3a:89:5d:68:38:2f:51:22:0b:4a:8d:cb:e9:bb:5d:\n         3e:bb:5c:3d:b1:28:fe:e4:53:55:13:cf:a1:90:1b:02:1d:5f:\n         66:46:09:33:28:e1:0d:24:97:70:d3:10:1f:ea:64:57:96:bb:\n         5d:da:e7:c4:8c:4f:4c:64:46:1d:5c:87:e3:59:de:42:d1:9b:\n         a8:7e:a6:89:dd:8f:1c:c9:30:82:ed:3b:9c:cd:c0:e9:19:e0:\n         6a:d8:02:75:37:ab:f7:34:28:28:91:f2:04:0a:4f:35:e3:60:\n         26:01:fa:d0:11:8c:f9:11:6a:ee:af:3d:c3:50:d3:8f:5f:33:\n         79:3c:86:a8:73:45:90:8c:20:b6:72:73:17:23:be:07:65:e5:\n         78:92:0d:ba:01:c0:eb:8c:1c:66:bf:ac:86:77:01:94:0d:9c:\n         e6:e9:39:8d:1f:a6:51:8c:99:0c:39:77:e1:b4:9b:fa:1c:67:\n         57:6f:6a:6a:8e:a9:2b:4c:57:79:7a:57:22:cf:cd:5f:63:46:\n         8d:5c:59:3a:86:f8:32:47:62:a3:67:0d:18:91:dc:fb:a6:6b:\n         f5:48:61:73:23:59:8e:02:a7:bc:44:ea:f4:49:9d:f1:54:58:\n         f9:60:af:da:18:a4:2f:28:45:dc:7a:a0:88:86:5d:f3:3b:e7:\n         ff:29:35:80:fc:64:43:94:e6:e3:1c:6f:be:ad:0e:2a:63:99:\n         2b:c9:7e:85:f6:71:e8:06:03:95:fe:de:8f:48:1c:5a:d4:92:\n         e8:2b:ee:e7:31:db:ba:04:6a:87:98:e7:c5:5f:ef:7d:a7:22:\n         f7:01:d8:4d:f9:89:d0:0e:9a:05:59:a4:9e:98:d9:6f:2b:ca:\n         70:be:64:c2:55:a3:f4:e9:af:c3:92:29:dc:88:16:24:99:3c:\n         8d:26:98:b6:5b:b7:cc:ce:b7:37:07:fd:26:d9:98:85:24:ff:\n         59:23:03:9a:ed:9d:9d:a8:e4:5e:38:ce:d7:52:0d:6f:d2:3f:\n         6d:b1:05:6b:49:ce:8a:91:46:73:f4:f6:2f:f0:a8:73:77:0e:\n         65:ac:a1:8d:66:52:69:7e:4b:68:0c:c7:1e:37:27:83:a5:8c:\n         c7:02:e4:14:cd:49:01:b0:73:b3:fd:c6:90:3a:6f:d2:6c:ed:\n         3b:ee:ec:91:be:a2:43:5d:8b:00:4a:66:25:44:70:de:40:0f:\n         f8:7c:15:f7:a2:ce:3c:d7:5e:13:8c:81:17:18:17:d1:bd:f1:\n         77:10:3a:d4:65:39:c1:27:ac:57:2c:25:54:ff:a2:da:4f:8a:\n         61:39:5e:ae:3d:4a:8c:bd\nSHA1 Fingerprint=2D:0D:52:14:FF:9E:AD:99:24:01:74:20:47:6E:6C:85:27:27:F5:43\n",
    "1a8462bc484c332504d4eed0f603c41946d1946b": "-----BEGIN CERTIFICATE-----\nMIIFtzCCA5+gAwIBAgICBQkwDQYJKoZIhvcNAQEFBQAwRTELMAkGA1UEBhMCQk0x\nGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxGzAZBgNVBAMTElF1b1ZhZGlzIFJv\nb3QgQ0EgMjAeFw0wNjExMjQxODI3MDBaFw0zMTExMjQxODIzMzNaMEUxCzAJBgNV\nBAYTAkJNMRkwFwYDVQQKExBRdW9WYWRpcyBMaW1pdGVkMRswGQYDVQQDExJRdW9W\nYWRpcyBSb290IENBIDIwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCa\nGMpLlA0ALa8DKYrwD4HIrkwZhR0In6spRIXzL4GtMh6QRr+jhiYaHv5+HBg6XJxg\nFyo6dIMzMH1hVBHL7avg5tKifvVrbxi3Cgst/ek+7wrGsxDp3MJGF/hd/aTa/55J\nWpzmM+Yklvc/ulsrHHo1wtZn/qtmUIttKGAr79dgw8eTvI02kfN/+NsRE8Scd3bB\nrrcCaoF6qUWD4gXmuVbBlDePSHFjIuwXZQeVikvfj8ZaCuWw419eaxGrDPmF60Tp\n+ARz8un+XJiM9XOva7R+zdRcAitMOeGylZUtQofX1bOQQ7dsE/He3fbE+Ik/0XX1\nksOR1YqI0JDs3G3eicJlcZaLDQP9nL9bFqyS2+r+eXyt66/3FsvbzSUr5R/7mp/i\nUcw6UwxI5g69ybR2BlLmEROFcmMDBOAENisgGQLodKcftslWZvB1JdxnwQ5hYIiz\nPtGo/KPaHbDRsSNU30R2be1B2MGyIrZTHN81Hdyhdyox5C315eXbyOD/5YDXC2Og\n/zOhD7osFRXql7PSorW+8oyWHhqPHWykYTe5hnMz15eWniN9gqRMgeKh0bpnX5UH\noycR7hYQe7xFSkyyBNKr79X9DFHOUGoIMfmR2gyPZFwDwzqLID9ujWc9Otb+fVuI\nyV77zGHcizN300QyNQliBJIWENieJ0f7OyHj+OsdWwIDAQABo4GwMIGtMA8GA1Ud\nEwEB/wQFMAMBAf8wCwYDVR0PBAQDAgEGMB0GA1UdDgQWBBQahGK8SEwzJQTU7tD2\nA8QZRtGUazBuBgNVHSMEZzBlgBQahGK8SEwzJQTU7tD2A8QZRtGUa6FJpEcwRTEL\nMAkGA1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxGzAZBgNVBAMT\nElF1b1ZhZGlzIFJvb3QgQ0EgMoICBQkwDQYJKoZIhvcNAQEFBQADggIBAD4KFk2f\nBluornFdLwUvZ+YTRYPENvbzwCYMDbVHZF34tHLJRqUDGCdViXh9duqWNIAXINzn\ng/iN/Ae42l9NLmeyhP3ZRPx3UIHmfLTJDQtyU/h2BwdBR5YM++CCJpNVjP4iH2Bl\nfF/nJrP3MpCYUNQ3cVX2kiF495V5+vgtJodmVjB3pjd4M1IQWK4/YY7yarHvGH5K\nWWPKjaJW1acvvFYfzznB4vsKqBUsfU16Y8Zsl0Q80m/DShcK+JDSV6IZUaUtl0Ha\nB0+pUNqQjZRG4T7wlP0QADj1O+hA4bRuVhogzG9Yje0uRY/W6ZM/57Es3zrWIozc\nhLsib9D45MY56QSIPMO661V6bYCZJPVsAfv4l7CUW+v90m/xd2gNNWQjrLhVoQPR\nTUIZ3Ph1WVaj+ahJefivDrkRoHy3au000LYmYjgahwz46P0u05B/B5EqHdZ+XIWD\nmbA4CD/pXvk1B+TJYm5Xf6dQlfe6yJvmjqIBxdZmv3lh8zwc4bmCXF2gw+nYSL0Z\nohEUGW6yhhtoPkg3Goi3XZZenMfvJ2II4pEZXNLxId26F0KCl3GBUzGpn/Z9Yr9y\n4aOTHcyKJloJONDO1w2AFrR4pTqHTI2KpdVGl/IsELm8VCLAAVBpQ570su9t+Oza\n8eOx79+Rj1QqCyXBJhnEUhAFZdWCEOrCMc0u\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 1289 (0x509)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 2\n        Validity\n            Not Before: Nov 24 18:27:00 2006 GMT\n            Not After : Nov 24 18:23:33 2031 GMT\n        Subject: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:9a:18:ca:4b:94:0d:00:2d:af:03:29:8a:f0:0f:\n                    81:c8:ae:4c:19:85:1d:08:9f:ab:29:44:85:f3:2f:\n                    81:ad:32:1e:90:46:bf:a3:86:26:1a:1e:fe:7e:1c:\n                    18:3a:5c:9c:60:17:2a:3a:74:83:33:30:7d:61:54:\n                    11:cb:ed:ab:e0:e6:d2:a2:7e:f5:6b:6f:18:b7:0a:\n                    0b:2d:fd:e9:3e:ef:0a:c6:b3:10:e9:dc:c2:46:17:\n                    f8:5d:fd:a4:da:ff:9e:49:5a:9c:e6:33:e6:24:96:\n                    f7:3f:ba:5b:2b:1c:7a:35:c2:d6:67:fe:ab:66:50:\n                    8b:6d:28:60:2b:ef:d7:60:c3:c7:93:bc:8d:36:91:\n                    f3:7f:f8:db:11:13:c4:9c:77:76:c1:ae:b7:02:6a:\n                    81:7a:a9:45:83:e2:05:e6:b9:56:c1:94:37:8f:48:\n                    71:63:22:ec:17:65:07:95:8a:4b:df:8f:c6:5a:0a:\n                    e5:b0:e3:5f:5e:6b:11:ab:0c:f9:85:eb:44:e9:f8:\n                    04:73:f2:e9:fe:5c:98:8c:f5:73:af:6b:b4:7e:cd:\n                    d4:5c:02:2b:4c:39:e1:b2:95:95:2d:42:87:d7:d5:\n                    b3:90:43:b7:6c:13:f1:de:dd:f6:c4:f8:89:3f:d1:\n                    75:f5:92:c3:91:d5:8a:88:d0:90:ec:dc:6d:de:89:\n                    c2:65:71:96:8b:0d:03:fd:9c:bf:5b:16:ac:92:db:\n                    ea:fe:79:7c:ad:eb:af:f7:16:cb:db:cd:25:2b:e5:\n                    1f:fb:9a:9f:e2:51:cc:3a:53:0c:48:e6:0e:bd:c9:\n                    b4:76:06:52:e6:11:13:85:72:63:03:04:e0:04:36:\n                    2b:20:19:02:e8:74:a7:1f:b6:c9:56:66:f0:75:25:\n                    dc:67:c1:0e:61:60:88:b3:3e:d1:a8:fc:a3:da:1d:\n                    b0:d1:b1:23:54:df:44:76:6d:ed:41:d8:c1:b2:22:\n                    b6:53:1c:df:35:1d:dc:a1:77:2a:31:e4:2d:f5:e5:\n                    e5:db:c8:e0:ff:e5:80:d7:0b:63:a0:ff:33:a1:0f:\n                    ba:2c:15:15:ea:97:b3:d2:a2:b5:be:f2:8c:96:1e:\n                    1a:8f:1d:6c:a4:61:37:b9:86:73:33:d7:97:96:9e:\n                    23:7d:82:a4:4c:81:e2:a1:d1:ba:67:5f:95:07:a3:\n                    27:11:ee:16:10:7b:bc:45:4a:4c:b2:04:d2:ab:ef:\n                    d5:fd:0c:51:ce:50:6a:08:31:f9:91:da:0c:8f:64:\n                    5c:03:c3:3a:8b:20:3f:6e:8d:67:3d:3a:d6:fe:7d:\n                    5b:88:c9:5e:fb:cc:61:dc:8b:33:77:d3:44:32:35:\n                    09:62:04:92:16:10:d8:9e:27:47:fb:3b:21:e3:f8:\n                    eb:1d:5b\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: \n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                1A:84:62:BC:48:4C:33:25:04:D4:EE:D0:F6:03:C4:19:46:D1:94:6B\n            X509v3 Authority Key Identifier: \n                keyid:1A:84:62:BC:48:4C:33:25:04:D4:EE:D0:F6:03:C4:19:46:D1:94:6B\n                DirName:/C=BM/O=QuoVadis Limited/CN=QuoVadis Root CA 2\n                serial:05:09\n\n    Signature Algorithm: sha1WithRSAEncryption\n         3e:0a:16:4d:9f:06:5b:a8:ae:71:5d:2f:05:2f:67:e6:13:45:\n         83:c4:36:f6:f3:c0:26:0c:0d:b5:47:64:5d:f8:b4:72:c9:46:\n         a5:03:18:27:55:89:78:7d:76:ea:96:34:80:17:20:dc:e7:83:\n         f8:8d:fc:07:b8:da:5f:4d:2e:67:b2:84:fd:d9:44:fc:77:50:\n         81:e6:7c:b4:c9:0d:0b:72:53:f8:76:07:07:41:47:96:0c:fb:\n         e0:82:26:93:55:8c:fe:22:1f:60:65:7c:5f:e7:26:b3:f7:32:\n         90:98:50:d4:37:71:55:f6:92:21:78:f7:95:79:fa:f8:2d:26:\n         87:66:56:30:77:a6:37:78:33:52:10:58:ae:3f:61:8e:f2:6a:\n         b1:ef:18:7e:4a:59:63:ca:8d:a2:56:d5:a7:2f:bc:56:1f:cf:\n         39:c1:e2:fb:0a:a8:15:2c:7d:4d:7a:63:c6:6c:97:44:3c:d2:\n         6f:c3:4a:17:0a:f8:90:d2:57:a2:19:51:a5:2d:97:41:da:07:\n         4f:a9:50:da:90:8d:94:46:e1:3e:f0:94:fd:10:00:38:f5:3b:\n         e8:40:e1:b4:6e:56:1a:20:cc:6f:58:8d:ed:2e:45:8f:d6:e9:\n         93:3f:e7:b1:2c:df:3a:d6:22:8c:dc:84:bb:22:6f:d0:f8:e4:\n         c6:39:e9:04:88:3c:c3:ba:eb:55:7a:6d:80:99:24:f5:6c:01:\n         fb:f8:97:b0:94:5b:eb:fd:d2:6f:f1:77:68:0d:35:64:23:ac:\n         b8:55:a1:03:d1:4d:42:19:dc:f8:75:59:56:a3:f9:a8:49:79:\n         f8:af:0e:b9:11:a0:7c:b7:6a:ed:34:d0:b6:26:62:38:1a:87:\n         0c:f8:e8:fd:2e:d3:90:7f:07:91:2a:1d:d6:7e:5c:85:83:99:\n         b0:38:08:3f:e9:5e:f9:35:07:e4:c9:62:6e:57:7f:a7:50:95:\n         f7:ba:c8:9b:e6:8e:a2:01:c5:d6:66:bf:79:61:f3:3c:1c:e1:\n         b9:82:5c:5d:a0:c3:e9:d8:48:bd:19:a2:11:14:19:6e:b2:86:\n         1b:68:3e:48:37:1a:88:b7:5d:96:5e:9c:c7:ef:27:62:08:e2:\n         91:19:5c:d2:f1:21:dd:ba:17:42:82:97:71:81:53:31:a9:9f:\n         f6:7d:62:bf:72:e1:a3:93:1d:cc:8a:26:5a:09:38:d0:ce:d7:\n         0d:80:16:b4:78:a5:3a:87:4c:8d:8a:a5:d5:46:97:f2:2c:10:\n         b9:bc:54:22:c0:01:50:69:43:9e:f4:b2:ef:6d:f8:ec:da:f1:\n         e3:b1:ef:df:91:8f:54:2a:0b:25:c1:26:19:c4:52:10:05:65:\n         d5:82:10:ea:c2:31:cd:2e\nSHA1 Fingerprint=CA:3A:FB:CF:12:40:36:4B:44:B2:16:20:88:80:48:39:19:93:7C:F7\n",
    "1aedfe413990b42459be01f252d545f65a39dc11": "-----BEGIN CERTIFICATE-----\nMIIDqDCCApCgAwIBAgIJAP7c4wEPyUj/MA0GCSqGSIb3DQEBBQUAMDQxCzAJBgNV\nBAYTAkZSMRIwEAYDVQQKDAlEaGlteW90aXMxETAPBgNVBAMMCENlcnRpZ25hMB4X\nDTA3MDYyOTE1MTMwNVoXDTI3MDYyOTE1MTMwNVowNDELMAkGA1UEBhMCRlIxEjAQ\nBgNVBAoMCURoaW15b3RpczERMA8GA1UEAwwIQ2VydGlnbmEwggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQDIaPHJ1tazNHUmgh7stL7qXOEm7RFHYeGifBZ4\nQCHkYJ5ayGPhxLGWkv8YbWkj4Sti993iNi+RB7lIzw7sebYs5zRLcAglozyHGxny\ngQcPOJAZ0xH+hrTy0V4eHpbNgGzOOzGTtvKg0KmVEn2lmsxryIRWijOp5yIVUxbw\nzBfsV1/pogqYCd7jX5xv3EjjhQsVWqa6n6xI4wmy9/Qy3l40vhx4XUJbzg4ij02Q\n130yGLMLLGq/jj8UEYkgDncUtT2UCIf3JR7VsmAA7G8qKCVuKj4YYxclPz5EIBb2\nJsglrgVKtOdjLPOMFlN+XPsRGgjBRmKfIrjxwo1p3Po6WAbfAgMBAAGjgbwwgbkw\nDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUGu3+QTmQtCRZvgHyUtVF9lo53BEw\nZAYDVR0jBF0wW4AUGu3+QTmQtCRZvgHyUtVF9lo53BGhOKQ2MDQxCzAJBgNVBAYT\nAkZSMRIwEAYDVQQKDAlEaGlteW90aXMxETAPBgNVBAMMCENlcnRpZ25hggkA/tzj\nAQ/JSP8wDgYDVR0PAQH/BAQDAgEGMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG\n9w0BAQUFAAOCAQEAhQMeknH2Qq/ho2Ge6/PAD/Kl1NqV5ta+aDY9fm4fTIrv0Q8h\nbV6lUmPOEvjvKtpv6zf+EwLHyzs+ImvaYS5/1HI93TDhHkxAGYwP15zRgzB7mFnc\nfca5DClMoTOi62c6ZYTTluLtdkVwj7Ur3vkj1kluPBS1xp81HlDQwY9qcEQCYsuu\nHWhBp6pX6FOqB9IG9tUUBguRA3UsbHK1YZWaDYu5Def131TN3ubY1gkIl2PlwS6w\nt0QmwCbAr1UwnjvVNioZBPRcHv/PLLf/0P2HQBHVESO7SMAhqaQoLf0V+LBOK/Qw\nWyH8EZE0vkHve52Xdf+XlcCWWC/qu0bXu+TZLg==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            fe:dc:e3:01:0f:c9:48:ff\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=FR, O=Dhimyotis, CN=Certigna\n        Validity\n            Not Before: Jun 29 15:13:05 2007 GMT\n            Not After : Jun 29 15:13:05 2027 GMT\n        Subject: C=FR, O=Dhimyotis, CN=Certigna\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:c8:68:f1:c9:d6:d6:b3:34:75:26:82:1e:ec:b4:\n                    be:ea:5c:e1:26:ed:11:47:61:e1:a2:7c:16:78:40:\n                    21:e4:60:9e:5a:c8:63:e1:c4:b1:96:92:ff:18:6d:\n                    69:23:e1:2b:62:f7:dd:e2:36:2f:91:07:b9:48:cf:\n                    0e:ec:79:b6:2c:e7:34:4b:70:08:25:a3:3c:87:1b:\n                    19:f2:81:07:0f:38:90:19:d3:11:fe:86:b4:f2:d1:\n                    5e:1e:1e:96:cd:80:6c:ce:3b:31:93:b6:f2:a0:d0:\n                    a9:95:12:7d:a5:9a:cc:6b:c8:84:56:8a:33:a9:e7:\n                    22:15:53:16:f0:cc:17:ec:57:5f:e9:a2:0a:98:09:\n                    de:e3:5f:9c:6f:dc:48:e3:85:0b:15:5a:a6:ba:9f:\n                    ac:48:e3:09:b2:f7:f4:32:de:5e:34:be:1c:78:5d:\n                    42:5b:ce:0e:22:8f:4d:90:d7:7d:32:18:b3:0b:2c:\n                    6a:bf:8e:3f:14:11:89:20:0e:77:14:b5:3d:94:08:\n                    87:f7:25:1e:d5:b2:60:00:ec:6f:2a:28:25:6e:2a:\n                    3e:18:63:17:25:3f:3e:44:20:16:f6:26:c8:25:ae:\n                    05:4a:b4:e7:63:2c:f3:8c:16:53:7e:5c:fb:11:1a:\n                    08:c1:46:62:9f:22:b8:f1:c2:8d:69:dc:fa:3a:58:\n                    06:df\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                1A:ED:FE:41:39:90:B4:24:59:BE:01:F2:52:D5:45:F6:5A:39:DC:11\n            X509v3 Authority Key Identifier: \n                keyid:1A:ED:FE:41:39:90:B4:24:59:BE:01:F2:52:D5:45:F6:5A:39:DC:11\n                DirName:/C=FR/O=Dhimyotis/CN=Certigna\n                serial:FE:DC:E3:01:0F:C9:48:FF\n\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            Netscape Cert Type: \n                SSL CA, S/MIME CA, Object Signing CA\n    Signature Algorithm: sha1WithRSAEncryption\n         85:03:1e:92:71:f6:42:af:e1:a3:61:9e:eb:f3:c0:0f:f2:a5:\n         d4:da:95:e6:d6:be:68:36:3d:7e:6e:1f:4c:8a:ef:d1:0f:21:\n         6d:5e:a5:52:63:ce:12:f8:ef:2a:da:6f:eb:37:fe:13:02:c7:\n         cb:3b:3e:22:6b:da:61:2e:7f:d4:72:3d:dd:30:e1:1e:4c:40:\n         19:8c:0f:d7:9c:d1:83:30:7b:98:59:dc:7d:c6:b9:0c:29:4c:\n         a1:33:a2:eb:67:3a:65:84:d3:96:e2:ed:76:45:70:8f:b5:2b:\n         de:f9:23:d6:49:6e:3c:14:b5:c6:9f:35:1e:50:d0:c1:8f:6a:\n         70:44:02:62:cb:ae:1d:68:41:a7:aa:57:e8:53:aa:07:d2:06:\n         f6:d5:14:06:0b:91:03:75:2c:6c:72:b5:61:95:9a:0d:8b:b9:\n         0d:e7:f5:df:54:cd:de:e6:d8:d6:09:08:97:63:e5:c1:2e:b0:\n         b7:44:26:c0:26:c0:af:55:30:9e:3b:d5:36:2a:19:04:f4:5c:\n         1e:ff:cf:2c:b7:ff:d0:fd:87:40:11:d5:11:23:bb:48:c0:21:\n         a9:a4:28:2d:fd:15:f8:b0:4e:2b:f4:30:5b:21:fc:11:91:34:\n         be:41:ef:7b:9d:97:75:ff:97:95:c0:96:58:2f:ea:bb:46:d7:\n         bb:e4:d9:2e\nSHA1 Fingerprint=B1:2E:13:63:45:86:A4:6F:1A:B2:60:68:37:58:2D:C4:AC:FD:94:97\n",
    "1d1c650ea8f2257bb491cfe4b1b1e6bd55746c05": "-----BEGIN CERTIFICATE-----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\nQyYBNWNgVYkDOnXYukrZVP/u3oDYLdE41V4tC5h9Pmzb/CaIxw==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            b0:b7:5a:16:48:5f:bf:e1:cb:f5:8b:d7:19:e6:7d\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=ES, O=IZENPE S.A., CN=Izenpe.com\n        Validity\n            Not Before: Dec 13 13:08:28 2007 GMT\n            Not After : Dec 13 08:27:25 2037 GMT\n        Subject: C=ES, O=IZENPE S.A., CN=Izenpe.com\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:c9:d3:7a:ca:0f:1e:ac:a7:86:e8:16:65:6a:b1:\n                    c2:1b:45:32:71:95:d9:fe:10:5b:cc:af:e7:a5:79:\n                    01:8f:89:c3:ca:f2:55:71:f7:77:be:77:94:f3:72:\n                    a4:2c:44:d8:9e:92:9b:14:3a:a1:e7:24:90:0a:0a:\n                    56:8e:c5:d8:26:94:e1:d9:48:e1:2d:3e:da:0a:72:\n                    dd:a3:99:15:da:81:a2:87:f4:7b:6e:26:77:89:58:\n                    ad:d6:eb:0c:b2:41:7a:73:6e:6d:db:7a:78:41:e9:\n                    08:88:12:7e:87:2e:66:11:63:6c:54:fb:3c:9d:72:\n                    c0:bc:2e:ff:c2:b7:dd:0d:76:e3:3a:d7:f7:b4:68:\n                    be:a2:f5:e3:81:6e:c1:46:6f:5d:8d:e0:4d:c6:54:\n                    55:89:1a:33:31:0a:b1:57:b9:a3:8a:98:c3:ec:3b:\n                    34:c5:95:41:69:7e:75:c2:3c:20:c5:61:ba:51:47:\n                    a0:20:90:93:a1:90:4b:f3:4e:7c:85:45:54:9a:d1:\n                    05:26:41:b0:b5:4d:1d:33:be:c4:03:c8:25:7c:c1:\n                    70:db:3b:f4:09:2d:54:27:48:ac:2f:e1:c4:ac:3e:\n                    c8:cb:92:4c:53:39:37:23:ec:d3:01:f9:e0:09:44:\n                    4d:4d:64:c0:e1:0d:5a:87:22:bc:ad:1b:a3:fe:26:\n                    b5:15:f3:a7:fc:84:19:e9:ec:a1:88:b4:44:69:84:\n                    83:f3:89:d1:74:06:a9:cc:0b:d6:c2:de:27:85:50:\n                    26:ca:17:b8:c9:7a:87:56:2c:1a:01:1e:6c:be:13:\n                    ad:10:ac:b5:24:f5:38:91:a1:d6:4b:da:f1:bb:d2:\n                    de:47:b5:f1:bc:81:f6:59:6b:cf:19:53:e9:8d:15:\n                    cb:4a:cb:a9:6f:44:e5:1b:41:cf:e1:86:a7:ca:d0:\n                    6a:9f:bc:4c:8d:06:33:5a:a2:85:e5:90:35:a0:62:\n                    5c:16:4e:f0:e3:a2:fa:03:1a:b4:2c:71:b3:58:2c:\n                    de:7b:0b:db:1a:0f:eb:de:21:1f:06:77:06:03:b0:\n                    c9:ef:99:fc:c0:b9:4f:0b:86:28:fe:d2:b9:ea:e3:\n                    da:a5:c3:47:69:12:e0:db:f0:f6:19:8b:ed:7b:70:\n                    d7:02:d6:ed:87:18:28:2c:04:24:4c:77:e4:48:8a:\n                    1a:c6:3b:9a:d4:0f:ca:fa:75:d2:01:40:5a:8d:79:\n                    bf:8b:cf:4b:cf:aa:16:c1:95:e4:ad:4c:8a:3e:17:\n                    91:d4:b1:62:e5:82:e5:80:04:a4:03:7e:8d:bf:da:\n                    7f:a2:0f:97:4f:0c:d3:0d:fb:d7:d1:e5:72:7e:1c:\n                    c8:77:ff:5b:9a:0f:b7:ae:05:46:e5:f1:a8:16:ec:\n                    47:a4:17\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Alternative Name: \n                email:info@izenpe.com, DirName:/O=IZENPE S.A. - CIF A01337260-RMerc.Vitoria-Gasteiz T1055 F62 S8/street=Avda del Mediterraneo Etorbidea 14 - 01010 Vitoria-Gasteiz\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                1D:1C:65:0E:A8:F2:25:7B:B4:91:CF:E4:B1:B1:E6:BD:55:74:6C:05\n    Signature Algorithm: sha256WithRSAEncryption\n         78:a6:0c:16:4a:9f:4c:88:3a:c0:cb:0e:a5:16:7d:9f:b9:48:\n         5f:18:8f:0d:62:36:f6:cd:19:6b:ac:ab:d5:f6:91:7d:ae:71:\n         f3:3f:b3:0e:78:85:9b:95:a4:27:21:47:42:4a:7c:48:3a:f5:\n         45:7c:b3:0c:8e:51:78:ac:95:13:de:c6:fd:7d:b8:1a:90:4c:\n         ab:92:03:c7:ed:42:01:ce:0f:d8:b1:fa:a2:92:e1:60:6d:ae:\n         7a:6b:09:aa:c6:29:ee:68:49:67:30:80:24:7a:31:16:39:5b:\n         7e:f1:1c:2e:dd:6c:09:ad:f2:31:c1:82:4e:b9:bb:f9:be:bf:\n         2a:85:3f:c0:40:a3:3a:59:fc:59:4b:3c:28:24:db:b4:15:75:\n         ae:0d:88:ba:2e:73:c0:bd:58:87:e5:42:f2:eb:5e:ee:1e:30:\n         22:99:cb:37:d1:c4:21:6c:81:ec:be:6d:26:e6:1c:e4:42:20:\n         9e:47:b0:ac:83:59:70:2c:35:d6:af:36:34:b4:cd:3b:f8:32:\n         a8:ef:e3:78:89:fb:8d:45:2c:da:9c:b8:7e:40:1c:61:e7:3e:\n         a2:92:2c:4b:f2:cd:fa:98:b6:29:ff:f3:f2:7b:a9:1f:2e:a0:\n         93:57:2b:de:85:03:f9:69:37:cb:9e:78:6a:05:b4:c5:31:78:\n         89:ec:7a:a7:85:e1:b9:7b:3c:de:be:1e:79:84:ce:9f:70:0e:\n         59:c2:35:2e:90:2a:31:d9:e4:45:7a:41:a4:2e:13:9b:34:0e:\n         66:7b:49:ab:64:97:d0:46:c3:79:9d:72:50:63:a6:98:5b:06:\n         bd:48:6d:d8:39:83:70:e8:35:f0:05:d1:aa:bc:e3:db:c8:02:\n         ea:7c:fd:82:da:c2:5b:52:35:ae:98:3a:ad:ba:35:93:23:a7:\n         1f:48:dd:35:46:98:b2:10:68:e4:a5:31:c2:0a:58:2e:19:81:\n         10:c9:50:75:fc:ea:5a:16:ce:11:d7:ee:ef:50:88:2d:61:ff:\n         3f:42:73:05:94:43:d5:8e:3c:4e:01:3a:19:a5:1f:46:4e:77:\n         d0:5d:e5:81:22:21:87:fe:94:7d:84:d8:93:ad:d6:68:43:48:\n         b2:db:eb:73:24:e7:91:7f:54:a4:b6:80:3e:9d:a3:3c:4c:72:\n         c2:57:c4:a0:d4:cc:38:27:ce:d5:06:9e:a2:48:d9:e9:9f:ce:\n         82:70:36:93:9a:3b:df:96:21:e3:59:b7:0c:da:91:37:f0:fd:\n         59:5a:b3:99:c8:69:6c:43:26:01:35:63:60:55:89:03:3a:75:\n         d8:ba:4a:d9:54:ff:ee:de:80:d8:2d:d1:38:d5:5e:2d:0b:98:\n         7d:3e:6c:db:fc:26:88:c7\nSHA1 Fingerprint=2F:78:3D:25:52:18:A7:4A:65:39:71:B5:2C:A2:9C:45:15:6F:E9:19\n",
    "1e0cf7b667f2e192260945c055392e773f424aa2": "-----BEGIN CERTIFICATE-----\nMIIFsDCCA5igAwIBAgIQFci9ZUdcr7iXAF7kBtK8nTANBgkqhkiG9w0BAQUFADBe\nMQswCQYDVQQGEwJUVzEjMCEGA1UECgwaQ2h1bmdod2EgVGVsZWNvbSBDby4sIEx0\nZC4xKjAoBgNVBAsMIWVQS0kgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAe\nFw0wNDEyMjAwMjMxMjdaFw0zNDEyMjAwMjMxMjdaMF4xCzAJBgNVBAYTAlRXMSMw\nIQYDVQQKDBpDaHVuZ2h3YSBUZWxlY29tIENvLiwgTHRkLjEqMCgGA1UECwwhZVBL\nSSBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIICIjANBgkqhkiG9w0BAQEF\nAAOCAg8AMIICCgKCAgEA4SUP7o3biDN1Z82tH306Tm2d0y8U82N0ywEhajfqhFAH\nSyZbCUNsIZ5qyNUD9WBpj8zwIuQf5/dqIjG3LBXy4P4AakP/h2XGtRrBp0xtInAh\nijHyl3SJCRImHJ7K2RKilTza6We/CKBk49ZCt0Xvl/T29de1ShUCWH2YWEtgvM3X\nDZoTM1PRYfl61dd4s5oz9wCGzh1NlDivqOx4UXCKXBCDUSH3ET00hl7lSM2XgYI1\nTBnsZfZrxQWh7kcT1rMhJ5QQCtkkO7q+RBNGMD+XPNjX12ruOzjjK9SXDrkb5wdJ\nfzcq+Xd4z1TtW0ado4AOkUPB1ltfFLqfpo0kR0BZv3I4sjZsN/+Z0V0OWQqraffA\nsgRFelQArr5T9rXn4fg8ozHSqf4hUmTFpmfwdQcGlBSBVcYn5AGPF8Fqcde+S/uU\nWH1+ETOxQvdibBjWzwloPn9s9h6PYq2lY9sJpx8iQkEeb5mKPtf5P0B6ebClAZLS\nnT0IFaUQAS2zMnaolQ2zepr7BxB4EW/hj8e6DyUadCrlHJhBmd8hh+iVBmoKs2pH\ndmX2Os+PYhcZewoozRrSgx4hxyy/vv9haLdnG7t4TY3OZ+XkwY63I2binZB1NJip\nNiuKmpS5nezMirH4JYlcWrYvjB9teSSnUmjDhDXiZo1jDiVN1Rmy5nk3pyKdVDEC\nAwEAAaNqMGgwHQYDVR0OBBYEFB4M97Zn8uGSJglFwFU5Lnc/QkqiMAwGA1UdEwQF\nMAMBAf8wOQYEZyoHAAQxMC8wLQIBADAJBgUrDgMCGgUAMAcGBWcqAwAABBRFsMLH\nClZ87lt4DJX5GFPBphzYEDANBgkqhkiG9w0BAQUFAAOCAgEACbODU1kBPpVJufGB\nuvl2ICO1J2B01GqZNF5sAFPZn/KmsSQHRGoqxqWOeBLoR9lYGxMqXnmbnwoqZ6Yl\nPwZpVnPDimZI+ymBV3QGypzqKOg4ZyYr8dW1P2WT+DZdjo2NQCCHGervJ8A9tDkP\nJXtoUHRVnAxZfVo9QZQlUgjgRywVMRnVvwdVxrsStZf0X4OFunHB2WyBEXYKCrC/\ngpf36j36+uwtqSiUO1bd0lEursC9CBWMd1I0ltabrNMdjmEPNXubrjlpC2JgQCA2\nj6/7Nu4tCEoduL+bXPjqpRugc6bY+G7gMwRfaKonh+3ZwZCc7b3jajWvY9+rGNm6\n5ulK6lCKD2GTHuItGeIwlDWSXQ62B68ZgI9HkFFLLk3dheLSClIKF5r8GrBQAuUB\no2M3IUxExJtRmREOc5wGj1QupyheRDmHVi03vYVElOEMSyycw5KFNGHLD7ibSkNS\n/jQ6fbjpKdx2qcgw+BRxgMYeNkh0IkFch4LoGHGLQYlE535YW6i4jRPpp2zDR+2z\nGp1iro2C6pSe3VkQw63d4k3jMdXH7OjysP6SHhYKGvzZ8/gntsm+HbRsZJB/9OTE\nW9c3rkIO3aQab3yIVMUWbuF6aC74Or8NpDyJO3inTmODBCEIZ43ygknQW/2xzQ+D\nhNQ+IIX3Sj0rnP0qCglN6oH4EZw=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            15:c8:bd:65:47:5c:af:b8:97:00:5e:e4:06:d2:bc:9d\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=TW, O=Chunghwa Telecom Co., Ltd., OU=ePKI Root Certification Authority\n        Validity\n            Not Before: Dec 20 02:31:27 2004 GMT\n            Not After : Dec 20 02:31:27 2034 GMT\n        Subject: C=TW, O=Chunghwa Telecom Co., Ltd., OU=ePKI Root Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:e1:25:0f:ee:8d:db:88:33:75:67:cd:ad:1f:7d:\n                    3a:4e:6d:9d:d3:2f:14:f3:63:74:cb:01:21:6a:37:\n                    ea:84:50:07:4b:26:5b:09:43:6c:21:9e:6a:c8:d5:\n                    03:f5:60:69:8f:cc:f0:22:e4:1f:e7:f7:6a:22:31:\n                    b7:2c:15:f2:e0:fe:00:6a:43:ff:87:65:c6:b5:1a:\n                    c1:a7:4c:6d:22:70:21:8a:31:f2:97:74:89:09:12:\n                    26:1c:9e:ca:d9:12:a2:95:3c:da:e9:67:bf:08:a0:\n                    64:e3:d6:42:b7:45:ef:97:f4:f6:f5:d7:b5:4a:15:\n                    02:58:7d:98:58:4b:60:bc:cd:d7:0d:9a:13:33:53:\n                    d1:61:f9:7a:d5:d7:78:b3:9a:33:f7:00:86:ce:1d:\n                    4d:94:38:af:a8:ec:78:51:70:8a:5c:10:83:51:21:\n                    f7:11:3d:34:86:5e:e5:48:cd:97:81:82:35:4c:19:\n                    ec:65:f6:6b:c5:05:a1:ee:47:13:d6:b3:21:27:94:\n                    10:0a:d9:24:3b:ba:be:44:13:46:30:3f:97:3c:d8:\n                    d7:d7:6a:ee:3b:38:e3:2b:d4:97:0e:b9:1b:e7:07:\n                    49:7f:37:2a:f9:77:78:cf:54:ed:5b:46:9d:a3:80:\n                    0e:91:43:c1:d6:5b:5f:14:ba:9f:a6:8d:24:47:40:\n                    59:bf:72:38:b2:36:6c:37:ff:99:d1:5d:0e:59:0a:\n                    ab:69:f7:c0:b2:04:45:7a:54:00:ae:be:53:f6:b5:\n                    e7:e1:f8:3c:a3:31:d2:a9:fe:21:52:64:c5:a6:67:\n                    f0:75:07:06:94:14:81:55:c6:27:e4:01:8f:17:c1:\n                    6a:71:d7:be:4b:fb:94:58:7d:7e:11:33:b1:42:f7:\n                    62:6c:18:d6:cf:09:68:3e:7f:6c:f6:1e:8f:62:ad:\n                    a5:63:db:09:a7:1f:22:42:41:1e:6f:99:8a:3e:d7:\n                    f9:3f:40:7a:79:b0:a5:01:92:d2:9d:3d:08:15:a5:\n                    10:01:2d:b3:32:76:a8:95:0d:b3:7a:9a:fb:07:10:\n                    78:11:6f:e1:8f:c7:ba:0f:25:1a:74:2a:e5:1c:98:\n                    41:99:df:21:87:e8:95:06:6a:0a:b3:6a:47:76:65:\n                    f6:3a:cf:8f:62:17:19:7b:0a:28:cd:1a:d2:83:1e:\n                    21:c7:2c:bf:be:ff:61:68:b7:67:1b:bb:78:4d:8d:\n                    ce:67:e5:e4:c1:8e:b7:23:66:e2:9d:90:75:34:98:\n                    a9:36:2b:8a:9a:94:b9:9d:ec:cc:8a:b1:f8:25:89:\n                    5c:5a:b6:2f:8c:1f:6d:79:24:a7:52:68:c3:84:35:\n                    e2:66:8d:63:0e:25:4d:d5:19:b2:e6:79:37:a7:22:\n                    9d:54:31\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                1E:0C:F7:B6:67:F2:E1:92:26:09:45:C0:55:39:2E:77:3F:42:4A:A2\n            X509v3 Basic Constraints: \n                CA:TRUE\n            setCext-hashedRoot: \n                0/0-...0...+......0...g*.....E...\nV|.[x....S.....\n    Signature Algorithm: sha1WithRSAEncryption\n         09:b3:83:53:59:01:3e:95:49:b9:f1:81:ba:f9:76:20:23:b5:\n         27:60:74:d4:6a:99:34:5e:6c:00:53:d9:9f:f2:a6:b1:24:07:\n         44:6a:2a:c6:a5:8e:78:12:e8:47:d9:58:1b:13:2a:5e:79:9b:\n         9f:0a:2a:67:a6:25:3f:06:69:56:73:c3:8a:66:48:fb:29:81:\n         57:74:06:ca:9c:ea:28:e8:38:67:26:2b:f1:d5:b5:3f:65:93:\n         f8:36:5d:8e:8d:8d:40:20:87:19:ea:ef:27:c0:3d:b4:39:0f:\n         25:7b:68:50:74:55:9c:0c:59:7d:5a:3d:41:94:25:52:08:e0:\n         47:2c:15:31:19:d5:bf:07:55:c6:bb:12:b5:97:f4:5f:83:85:\n         ba:71:c1:d9:6c:81:11:76:0a:0a:b0:bf:82:97:f7:ea:3d:fa:\n         fa:ec:2d:a9:28:94:3b:56:dd:d2:51:2e:ae:c0:bd:08:15:8c:\n         77:52:34:96:d6:9b:ac:d3:1d:8e:61:0f:35:7b:9b:ae:39:69:\n         0b:62:60:40:20:36:8f:af:fb:36:ee:2d:08:4a:1d:b8:bf:9b:\n         5c:f8:ea:a5:1b:a0:73:a6:d8:f8:6e:e0:33:04:5f:68:aa:27:\n         87:ed:d9:c1:90:9c:ed:bd:e3:6a:35:af:63:df:ab:18:d9:ba:\n         e6:e9:4a:ea:50:8a:0f:61:93:1e:e2:2d:19:e2:30:94:35:92:\n         5d:0e:b6:07:af:19:80:8f:47:90:51:4b:2e:4d:dd:85:e2:d2:\n         0a:52:0a:17:9a:fc:1a:b0:50:02:e5:01:a3:63:37:21:4c:44:\n         c4:9b:51:99:11:0e:73:9c:06:8f:54:2e:a7:28:5e:44:39:87:\n         56:2d:37:bd:85:44:94:e1:0c:4b:2c:9c:c3:92:85:34:61:cb:\n         0f:b8:9b:4a:43:52:fe:34:3a:7d:b8:e9:29:dc:76:a9:c8:30:\n         f8:14:71:80:c6:1e:36:48:74:22:41:5c:87:82:e8:18:71:8b:\n         41:89:44:e7:7e:58:5b:a8:b8:8d:13:e9:a7:6c:c3:47:ed:b3:\n         1a:9d:62:ae:8d:82:ea:94:9e:dd:59:10:c3:ad:dd:e2:4d:e3:\n         31:d5:c7:ec:e8:f2:b0:fe:92:1e:16:0a:1a:fc:d9:f3:f8:27:\n         b6:c9:be:1d:b4:6c:64:90:7f:f4:e4:c4:5b:d7:37:ae:42:0e:\n         dd:a4:1a:6f:7c:88:54:c5:16:6e:e1:7a:68:2e:f8:3a:bf:0d:\n         a4:3c:89:3b:78:a7:4e:63:83:04:21:08:67:8d:f2:82:49:d0:\n         5b:fd:b1:cd:0f:83:84:d4:3e:20:85:f7:4a:3d:2b:9c:fd:2a:\n         0a:09:4d:ea:81:f8:11:9c\nSHA1 Fingerprint=67:65:0D:F1:7E:8E:7E:5B:82:40:A4:F4:56:4B:CF:E2:3D:69:C6:F0\n",
    "2130c9fb00d74e98da87aa2ad0a72eb14031a74c": "-----BEGIN CERTIFICATE-----\nMIID5jCCAs6gAwIBAgIQV8szb8JcFuZHFhfjkDFo4DANBgkqhkiG9w0BAQUFADBi\nMQswCQYDVQQGEwJVUzEhMB8GA1UEChMYTmV0d29yayBTb2x1dGlvbnMgTC5MLkMu\nMTAwLgYDVQQDEydOZXR3b3JrIFNvbHV0aW9ucyBDZXJ0aWZpY2F0ZSBBdXRob3Jp\ndHkwHhcNMDYxMjAxMDAwMDAwWhcNMjkxMjMxMjM1OTU5WjBiMQswCQYDVQQGEwJV\nUzEhMB8GA1UEChMYTmV0d29yayBTb2x1dGlvbnMgTC5MLkMuMTAwLgYDVQQDEydO\nZXR3b3JrIFNvbHV0aW9ucyBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDkvH6SMG3G2I4rC7xGzuAnlt7e+foS0zwz\nc7MEL7xxjOWftiJgPl9dzgn/ggwbmlFQGiaJ3dVhXRncEg8tCqJDXRfQNJIg6nPP\nOCwGJgl6cvf6UDL4wpPTaaIjzkGxzOTVHzbRijr4jGPiFFlp7Q3Tf2vouAPlT2rl\nmGNpSAW+Lv8ztumXWWn4Zxmuk2GWRBXTcrA/vGp97Eh/jcOrqnErU2lBUzS1sLnF\nBgrEsEX1QV1uiUV7PTsmjHTC5dLRfbIR1PtYMiKagMnc/Qzpf14Dl847ABSHJ3A4\nqY5usyd2mFHgBeMhqxrVhSI8KbWaFsWAqPS7azCPL0YCorEMIuDTAgMBAAGjgZcw\ngZQwHQYDVR0OBBYEFCEwyfsA106Y2oeqKtCnLrFAMadMMA4GA1UdDwEB/wQEAwIB\nBjAPBgNVHRMBAf8EBTADAQH/MFIGA1UdHwRLMEkwR6BFoEOGQWh0dHA6Ly9jcmwu\nbmV0c29sc3NsLmNvbS9OZXR3b3JrU29sdXRpb25zQ2VydGlmaWNhdGVBdXRob3Jp\ndHkuY3JsMA0GCSqGSIb3DQEBBQUAA4IBAQC7rkvnt1frf6ott3NHhWrB5KUd5Oc8\n6fRZZXe1eltajSU24HqXLjjAV2CDmAaDn7l2em5Q4LqILPxFzBiwmZVRDuwduIj/\nh1AcgsLj4DKAv6ALR8jDMe+ZZzKATxcheQxpXN5eNK4CtSbqUN9/GGUsyfJj4akH\n/nxxH2szJGoeBfcFaMBqEssuXmHLrijTfsK0ZpEmXzwuJF/LWA/rKOyvEZbz3Htv\nwKeI8lN3s2Berq4o2jUsbzRF0ybh3uxbTydrFny9RAQYgrOJeRcQcT16ohZO9QHN\npGxlaKFJdlxDydi8NmdspZS11My5vWo1ViHe2MPr+8ukYEywVaCge1ey\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            57:cb:33:6f:c2:5c:16:e6:47:16:17:e3:90:31:68:e0\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=US, O=Network Solutions L.L.C., CN=Network Solutions Certificate Authority\n        Validity\n            Not Before: Dec  1 00:00:00 2006 GMT\n            Not After : Dec 31 23:59:59 2029 GMT\n        Subject: C=US, O=Network Solutions L.L.C., CN=Network Solutions Certificate Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:e4:bc:7e:92:30:6d:c6:d8:8e:2b:0b:bc:46:ce:\n                    e0:27:96:de:de:f9:fa:12:d3:3c:33:73:b3:04:2f:\n                    bc:71:8c:e5:9f:b6:22:60:3e:5f:5d:ce:09:ff:82:\n                    0c:1b:9a:51:50:1a:26:89:dd:d5:61:5d:19:dc:12:\n                    0f:2d:0a:a2:43:5d:17:d0:34:92:20:ea:73:cf:38:\n                    2c:06:26:09:7a:72:f7:fa:50:32:f8:c2:93:d3:69:\n                    a2:23:ce:41:b1:cc:e4:d5:1f:36:d1:8a:3a:f8:8c:\n                    63:e2:14:59:69:ed:0d:d3:7f:6b:e8:b8:03:e5:4f:\n                    6a:e5:98:63:69:48:05:be:2e:ff:33:b6:e9:97:59:\n                    69:f8:67:19:ae:93:61:96:44:15:d3:72:b0:3f:bc:\n                    6a:7d:ec:48:7f:8d:c3:ab:aa:71:2b:53:69:41:53:\n                    34:b5:b0:b9:c5:06:0a:c4:b0:45:f5:41:5d:6e:89:\n                    45:7b:3d:3b:26:8c:74:c2:e5:d2:d1:7d:b2:11:d4:\n                    fb:58:32:22:9a:80:c9:dc:fd:0c:e9:7f:5e:03:97:\n                    ce:3b:00:14:87:27:70:38:a9:8e:6e:b3:27:76:98:\n                    51:e0:05:e3:21:ab:1a:d5:85:22:3c:29:b5:9a:16:\n                    c5:80:a8:f4:bb:6b:30:8f:2f:46:02:a2:b1:0c:22:\n                    e0:d3\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                21:30:C9:FB:00:D7:4E:98:DA:87:AA:2A:D0:A7:2E:B1:40:31:A7:4C\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 CRL Distribution Points: \n\n                Full Name:\n                  URI:http://crl.netsolssl.com/NetworkSolutionsCertificateAuthority.crl\n\n    Signature Algorithm: sha1WithRSAEncryption\n         bb:ae:4b:e7:b7:57:eb:7f:aa:2d:b7:73:47:85:6a:c1:e4:a5:\n         1d:e4:e7:3c:e9:f4:59:65:77:b5:7a:5b:5a:8d:25:36:e0:7a:\n         97:2e:38:c0:57:60:83:98:06:83:9f:b9:76:7a:6e:50:e0:ba:\n         88:2c:fc:45:cc:18:b0:99:95:51:0e:ec:1d:b8:88:ff:87:50:\n         1c:82:c2:e3:e0:32:80:bf:a0:0b:47:c8:c3:31:ef:99:67:32:\n         80:4f:17:21:79:0c:69:5c:de:5e:34:ae:02:b5:26:ea:50:df:\n         7f:18:65:2c:c9:f2:63:e1:a9:07:fe:7c:71:1f:6b:33:24:6a:\n         1e:05:f7:05:68:c0:6a:12:cb:2e:5e:61:cb:ae:28:d3:7e:c2:\n         b4:66:91:26:5f:3c:2e:24:5f:cb:58:0f:eb:28:ec:af:11:96:\n         f3:dc:7b:6f:c0:a7:88:f2:53:77:b3:60:5e:ae:ae:28:da:35:\n         2c:6f:34:45:d3:26:e1:de:ec:5b:4f:27:6b:16:7c:bd:44:04:\n         18:82:b3:89:79:17:10:71:3d:7a:a2:16:4e:f5:01:cd:a4:6c:\n         65:68:a1:49:76:5c:43:c9:d8:bc:36:67:6c:a5:94:b5:d4:cc:\n         b9:bd:6a:35:56:21:de:d8:c3:eb:fb:cb:a4:60:4c:b0:55:a0:\n         a0:7b:57:b2\nSHA1 Fingerprint=74:F8:A3:C3:EF:E7:B3:90:06:4B:83:90:3C:21:64:60:20:E5:DF:CE\n",
    "2e16a94a18b5cbccf56f50f3235ff85de7acf0c8": "-----BEGIN CERTIFICATE-----\nMIIDcjCCAlqgAwIBAgIUPopdB+xV0jLVt+O2XwHrLdzk1uQwDQYJKoZIhvcNAQEL\nBQAwUTELMAkGA1UEBhMCUEwxKDAmBgNVBAoMH0tyYWpvd2EgSXpiYSBSb3psaWN6\nZW5pb3dhIFMuQS4xGDAWBgNVBAMMD1NaQUZJUiBST09UIENBMjAeFw0xNTEwMTkw\nNzQzMzBaFw0zNTEwMTkwNzQzMzBaMFExCzAJBgNVBAYTAlBMMSgwJgYDVQQKDB9L\ncmFqb3dhIEl6YmEgUm96bGljemVuaW93YSBTLkEuMRgwFgYDVQQDDA9TWkFGSVIg\nUk9PVCBDQTIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC3vD5QqEvN\nQLXOYeeWyrSh2gwisPq1e3YAd4wLz32ohswmUeQgPYUM1ljj5/QqGJ3a0a4m7utT\n3PSQ1hNKDJA8w/Ta0o4NkjrcsbH/ON7Dui1fgLkCvUqdGw+0w8LBZwPd3BucPbOw\n3gAeqDRHu5rr/gsUvTaE2g0gv/pby6kWIK05YO4vdbbnl5z5Pv1+TW9NL++IDWr6\n3fE9biCloBK0TXC5ztdyO4mTp4CEHCdJckm1/zuVnsHMyAHs6A6KCpbns6aH5db5\nBSsNl0BwPLqsdVqc1U2dAgrSS5tmS0YHF2Wtn2yIANwiieDhZNRnvDF5YTy7ykHN\nXGoAyDw4jlivAgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQD\nAgEGMB0GA1UdDgQWBBQuFqlKGLXLzPVvUPMjX/hd56zwyDANBgkqhkiG9w0BAQsF\nAAOCAQEAtXP4A9xZWx126aMqe5Aosk3AM0+qmrHUuOQn/6mWmc5G4G18TKI4pAZw\n8PRBEew/R40/cof5O/2kbytTAOD/OblqBw7rHRz2onKQy4I9EYKL0rufKq8h5mOG\nnXkZ7/e7DDWQw4rtTw/1zBLZpD67oPwglV9PJi8RI4NOdQcPv5vRtB3pEAT+ymCP\noky4rc/hkA/NrgrHXXu3UNLUYfrVFdvXn4dRVOul4+vJhaAlIDf7js4MNIThPIGy\nd05DpYhfhmehPea0XGG2Ptv+tyjFogeutcrKjSoS75ftwjCkySp6+/NNIxuZMzSg\nLvWpCz/UXeHPhJ/iGcJfitYgHuNztw==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            3e:8a:5d:07:ec:55:d2:32:d5:b7:e3:b6:5f:01:eb:2d:dc:e4:d6:e4\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=PL, O=Krajowa Izba Rozliczeniowa S.A., CN=SZAFIR ROOT CA2\n        Validity\n            Not Before: Oct 19 07:43:30 2015 GMT\n            Not After : Oct 19 07:43:30 2035 GMT\n        Subject: C=PL, O=Krajowa Izba Rozliczeniowa S.A., CN=SZAFIR ROOT CA2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:b7:bc:3e:50:a8:4b:cd:40:b5:ce:61:e7:96:ca:\n                    b4:a1:da:0c:22:b0:fa:b5:7b:76:00:77:8c:0b:cf:\n                    7d:a8:86:cc:26:51:e4:20:3d:85:0c:d6:58:e3:e7:\n                    f4:2a:18:9d:da:d1:ae:26:ee:eb:53:dc:f4:90:d6:\n                    13:4a:0c:90:3c:c3:f4:da:d2:8e:0d:92:3a:dc:b1:\n                    b1:ff:38:de:c3:ba:2d:5f:80:b9:02:bd:4a:9d:1b:\n                    0f:b4:c3:c2:c1:67:03:dd:dc:1b:9c:3d:b3:b0:de:\n                    00:1e:a8:34:47:bb:9a:eb:fe:0b:14:bd:36:84:da:\n                    0d:20:bf:fa:5b:cb:a9:16:20:ad:39:60:ee:2f:75:\n                    b6:e7:97:9c:f9:3e:fd:7e:4d:6f:4d:2f:ef:88:0d:\n                    6a:fa:dd:f1:3d:6e:20:a5:a0:12:b4:4d:70:b9:ce:\n                    d7:72:3b:89:93:a7:80:84:1c:27:49:72:49:b5:ff:\n                    3b:95:9e:c1:cc:c8:01:ec:e8:0e:8a:0a:96:e7:b3:\n                    a6:87:e5:d6:f9:05:2b:0d:97:40:70:3c:ba:ac:75:\n                    5a:9c:d5:4d:9d:02:0a:d2:4b:9b:66:4b:46:07:17:\n                    65:ad:9f:6c:88:00:dc:22:89:e0:e1:64:d4:67:bc:\n                    31:79:61:3c:bb:ca:41:cd:5c:6a:00:c8:3c:38:8e:\n                    58:af\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                2E:16:A9:4A:18:B5:CB:CC:F5:6F:50:F3:23:5F:F8:5D:E7:AC:F0:C8\n    Signature Algorithm: sha256WithRSAEncryption\n         b5:73:f8:03:dc:59:5b:1d:76:e9:a3:2a:7b:90:28:b2:4d:c0:\n         33:4f:aa:9a:b1:d4:b8:e4:27:ff:a9:96:99:ce:46:e0:6d:7c:\n         4c:a2:38:a4:06:70:f0:f4:41:11:ec:3f:47:8d:3f:72:87:f9:\n         3b:fd:a4:6f:2b:53:00:e0:ff:39:b9:6a:07:0e:eb:1d:1c:f6:\n         a2:72:90:cb:82:3d:11:82:8b:d2:bb:9f:2a:af:21:e6:63:86:\n         9d:79:19:ef:f7:bb:0c:35:90:c3:8a:ed:4f:0f:f5:cc:12:d9:\n         a4:3e:bb:a0:fc:20:95:5f:4f:26:2f:11:23:83:4e:75:07:0f:\n         bf:9b:d1:b4:1d:e9:10:04:fe:ca:60:8f:a2:4c:b8:ad:cf:e1:\n         90:0f:cd:ae:0a:c7:5d:7b:b7:50:d2:d4:61:fa:d5:15:db:d7:\n         9f:87:51:54:eb:a5:e3:eb:c9:85:a0:25:20:37:fb:8e:ce:0c:\n         34:84:e1:3c:81:b2:77:4e:43:a5:88:5f:86:67:a1:3d:e6:b4:\n         5c:61:b6:3e:db:fe:b7:28:c5:a2:07:ae:b5:ca:ca:8d:2a:12:\n         ef:97:ed:c2:30:a4:c9:2a:7a:fb:f3:4d:23:1b:99:33:34:a0:\n         2e:f5:a9:0b:3f:d4:5d:e1:cf:84:9f:e2:19:c2:5f:8a:d6:20:\n         1e:e3:73:b7\nSHA1 Fingerprint=E2:52:FA:95:3F:ED:DB:24:60:BD:6E:28:F3:9C:CC:CF:5E:B3:3F:DE\n",
    "2ee3dbb249d09c54795cfa272afecc4ed2e84e54": "-----BEGIN CERTIFICATE-----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\nNL/+I5c30jn6PQ0GC7TbO6Orb1wdtn7os4I07QZcJA==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 7667447206703254355 (0x6a683e9c519bcb53)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=TR, L=Ankara, O=E-Tu\\xC4\\x9Fra EBG Bili\\xC5\\x9Fim Teknolojileri ve Hizmetleri A.\\xC5\\x9E., OU=E-Tugra Sertifikasyon Merkezi, CN=E-Tugra Certification Authority\n        Validity\n            Not Before: Mar  5 12:09:48 2013 GMT\n            Not After : Mar  3 12:09:48 2023 GMT\n        Subject: C=TR, L=Ankara, O=E-Tu\\xC4\\x9Fra EBG Bili\\xC5\\x9Fim Teknolojileri ve Hizmetleri A.\\xC5\\x9E., OU=E-Tugra Sertifikasyon Merkezi, CN=E-Tugra Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:e2:f5:3f:93:05:51:1e:85:62:54:5e:7a:0b:f5:\n                    18:07:83:ae:7e:af:7c:f7:d4:8a:6b:a5:63:43:39:\n                    b9:4b:f7:c3:c6:64:89:3d:94:2e:54:80:52:39:39:\n                    07:4b:4b:dd:85:07:76:87:cc:bf:2f:95:4c:cc:7d:\n                    a7:3d:bc:47:0f:98:70:f8:8c:85:1e:74:8e:92:6d:\n                    1b:40:d1:99:0d:bb:75:6e:c8:a9:6b:9a:c0:84:31:\n                    af:ca:43:cb:eb:2b:34:e8:8f:97:6b:01:9b:d5:0e:\n                    4a:08:aa:5b:92:74:85:43:d3:80:ae:a1:88:5b:ae:\n                    b3:ea:5e:cb:16:9a:77:44:c8:a1:f6:54:68:ce:de:\n                    8f:97:2b:ba:5b:40:02:0c:64:17:c0:b5:93:cd:e1:\n                    f1:13:66:ce:0c:79:ef:d1:91:28:ab:5f:a0:12:52:\n                    30:73:19:8e:8f:e1:8c:07:a2:c3:bb:4a:f0:ea:1f:\n                    15:a8:ee:25:cc:a4:46:f8:1b:22:ef:b3:0e:43:ba:\n                    2c:24:b8:c5:2c:5c:d4:1c:f8:5d:64:bd:c3:93:5e:\n                    28:a7:3f:27:f1:8e:1e:d3:2a:50:05:a3:55:d9:cb:\n                    e7:39:53:c0:98:9e:8c:54:62:8b:26:b0:f7:7d:8d:\n                    7c:e4:c6:9e:66:42:55:82:47:e7:b2:58:8d:66:f7:\n                    07:7c:2e:36:e6:50:1c:3f:db:43:24:c5:bf:86:47:\n                    79:b3:79:1c:f7:5a:f4:13:ec:6c:f8:3f:e2:59:1f:\n                    95:ee:42:3e:b9:ad:a8:32:85:49:97:46:fe:4b:31:\n                    8f:5a:cb:ad:74:47:1f:e9:91:b7:df:28:04:22:a0:\n                    d4:0f:5d:e2:79:4f:ea:6c:85:86:bd:a8:a6:ce:e4:\n                    fa:c3:e1:b3:ae:de:3c:51:ee:cb:13:7c:01:7f:84:\n                    0e:5d:51:94:9e:13:0c:b6:2e:a5:4c:f9:39:70:36:\n                    6f:96:ca:2e:0c:44:55:c5:ca:fa:5d:02:a3:df:d6:\n                    64:8c:5a:b3:01:0a:a9:b5:0a:47:17:ff:ef:91:40:\n                    2a:8e:a1:46:3a:31:98:e5:11:fc:cc:bb:49:56:8a:\n                    fc:b9:d0:61:9a:6f:65:6c:e6:c3:cb:3e:75:49:fe:\n                    8f:a7:e2:89:c5:67:d7:9d:46:13:4e:31:76:3b:24:\n                    b3:9e:11:65:86:ab:7f:ef:1d:d4:f8:bc:e7:ac:5a:\n                    5c:b7:5a:47:5c:55:ce:55:b4:22:71:5b:5b:0b:f0:\n                    cf:dc:a0:61:64:ea:a9:d7:68:0a:63:a7:e0:0d:3f:\n                    a0:af:d3:aa:d2:7e:ef:51:a0:e6:51:2b:55:92:15:\n                    17:53:cb:b7:66:0e:66:4c:f8:f9:75:4c:90:e7:12:\n                    70:c7:45\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                2E:E3:DB:B2:49:D0:9C:54:79:5C:FA:27:2A:FE:CC:4E:D2:E8:4E:54\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Authority Key Identifier: \n                keyid:2E:E3:DB:B2:49:D0:9C:54:79:5C:FA:27:2A:FE:CC:4E:D2:E8:4E:54\n\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         05:37:3a:f4:4d:b7:45:e2:45:75:24:8f:b6:77:52:e8:1c:d8:\n         10:93:65:f3:f2:59:06:a4:3e:1e:29:ec:5d:d1:d0:ab:7c:e0:\n         0a:90:48:78:ed:4e:98:03:99:fe:28:60:91:1d:30:1d:b8:63:\n         7c:a8:e6:35:b5:fa:d3:61:76:e6:d6:07:4b:ca:69:9a:b2:84:\n         7a:77:93:45:17:15:9f:24:d0:98:13:12:ff:bb:a0:2e:fd:4e:\n         4c:87:f8:ce:5c:aa:98:1b:05:e0:00:46:4a:82:80:a5:33:8b:\n         28:dc:ed:38:d3:df:e5:3e:e9:fe:fb:59:dd:61:84:4f:d2:54:\n         96:13:61:13:3e:8f:80:69:be:93:47:b5:35:43:d2:5a:bb:3d:\n         5c:ef:b3:42:47:cd:3b:55:13:06:b0:09:db:fd:63:f6:3a:88:\n         0a:99:6f:7e:e1:ce:1b:53:6a:44:66:23:51:08:7b:bc:5b:52:\n         a2:fd:06:37:38:40:61:8f:4a:96:b8:90:37:f8:66:c7:78:90:\n         00:15:2e:8b:ad:51:35:53:07:a8:6b:68:ae:f9:4e:3c:07:26:\n         cd:08:05:70:cc:39:3f:76:bd:a5:d3:67:26:01:86:a6:53:d2:\n         60:3b:7c:43:7f:55:8a:bc:95:1a:c1:28:39:4c:1f:43:d2:91:\n         f4:72:59:8a:b9:56:fc:3f:b4:9d:da:70:9c:76:5a:8c:43:50:\n         ee:8e:30:72:4d:df:ff:49:f7:c6:a9:67:d9:6d:ac:02:11:e2:\n         3a:16:25:a7:58:08:cb:6f:53:41:9c:48:38:47:68:33:d1:d7:\n         c7:8f:d4:74:21:d4:c3:05:90:7a:ff:ce:96:88:b1:15:29:5d:\n         23:ab:d0:60:a1:12:4f:de:f4:17:cd:32:e5:c9:bf:c8:43:ad:\n         fd:2e:8e:f1:af:e2:f4:98:fa:12:1f:20:d8:c0:a7:0c:85:c5:\n         90:f4:3b:2d:96:26:b1:2c:be:4c:ab:eb:b1:d2:8a:c9:db:78:\n         13:0f:1e:09:9d:6d:8f:00:9f:02:da:c1:fa:1f:7a:7a:09:c4:\n         4a:e6:88:2a:97:9f:89:8b:fd:37:5f:5f:3a:ce:38:59:86:4b:\n         af:71:0b:b4:d8:f2:70:4f:9f:32:13:e3:b0:a7:57:e5:da:da:\n         43:cb:84:34:f2:28:c4:ea:6d:f4:2a:ef:c1:6b:76:da:fb:7e:\n         bb:85:3c:d2:53:c2:4d:be:71:e1:45:d1:fd:23:67:0d:13:75:\n         fb:cf:65:67:22:9d:ae:b0:09:d1:09:ff:1d:34:bf:fe:23:97:\n         37:d2:39:fa:3d:0d:06:0b:b4:db:3b:a3:ab:6f:5c:1d:b6:7e:\n         e8:b3:82:34:ed:06:5c:24\nSHA1 Fingerprint=51:C6:E7:08:49:06:6E:F3:92:D4:5C:A0:0D:6D:A3:62:8F:C3:52:39\n",
    "350fc836635ee2a3ecf93b6615ce5152e3919a3d": "-----BEGIN CERTIFICATE-----\nMIIDtTCCAp2gAwIBAgIQdrEgUnTwhYdGs/gjGvbCwDANBgkqhkiG9w0BAQsFADBt\nMQswCQYDVQQGEwJDSDEQMA4GA1UEChMHV0lTZUtleTEiMCAGA1UECxMZT0lTVEUg\nRm91bmRhdGlvbiBFbmRvcnNlZDEoMCYGA1UEAxMfT0lTVEUgV0lTZUtleSBHbG9i\nYWwgUm9vdCBHQiBDQTAeFw0xNDEyMDExNTAwMzJaFw0zOTEyMDExNTEwMzFaMG0x\nCzAJBgNVBAYTAkNIMRAwDgYDVQQKEwdXSVNlS2V5MSIwIAYDVQQLExlPSVNURSBG\nb3VuZGF0aW9uIEVuZG9yc2VkMSgwJgYDVQQDEx9PSVNURSBXSVNlS2V5IEdsb2Jh\nbCBSb290IEdCIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2Be3\nHEokKtaXscriHvt9OO+Y9bI5mE4nuBFde9IllIiCFSZqGzG7qFshISvYD06fWvGx\nWuR51jIjK+FTzJlFXHtPrby/h0oLS5daqPZI7H17Dc0hBt+eFf1Biki3IPShehtX\n1F1Q/7pn2COZH8g/497/b1t3sWtuuMlk9+HKQUYOKXHQuSP8yYFfTvdv37+ErXNk\nu7dCjmn21HYdfp2nuFeKUWdy19SouJVUQHMD9ur06/4oQnc/nSMbsrY9gBQHTC5P\n99UKFg29ZkM3fiNDecNAhvVMKdqOmq0NpQSHiB6F4+lT1ZvIiwNjeOvgGUpuuy9r\nM2RYk61pv48b74JIxwIDAQABo1EwTzALBgNVHQ8EBAMCAYYwDwYDVR0TAQH/BAUw\nAwEB/zAdBgNVHQ4EFgQUNQ/INmNe4qPs+TtmFc5RUuORmj0wEAYJKwYBBAGCNxUB\nBAMCAQAwDQYJKoZIhvcNAQELBQADggEBAEBM+4eymYGQfp3FsLAmzYh7KzKNbrgh\ncViXfa43FK8+5/ea4n32cZiZBKpDdHij40lhPnOMTZTg+XHEthYOU3gf1qKHLwI5\ngSk8rxWYITD+KJAAjNHhy/peyP34EEY7onhCkRd0VQreUGdNZtGn//3ZwLWoo4rO\nZvUPQ82nK1d7Y0Zqqi5S2PTt4W2tKZB4SLrhI6qjiey1q5bAtEuiHZeeevJuQHHf\naPFlTc58Bd9TZaml8LGXBHAVRgOY1NK/VLSgWH1Sb9pWJmLU2NuJMW8c8CLC02Ic\nNc1MaRVUGpCY3useX8p3x8uOPUNpnJpY0CQ73xtAln41rYHHTnG6iBM=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            76:b1:20:52:74:f0:85:87:46:b3:f8:23:1a:f6:c2:c0\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=CH, O=WISeKey, OU=OISTE Foundation Endorsed, CN=OISTE WISeKey Global Root GB CA\n        Validity\n            Not Before: Dec  1 15:00:32 2014 GMT\n            Not After : Dec  1 15:10:31 2039 GMT\n        Subject: C=CH, O=WISeKey, OU=OISTE Foundation Endorsed, CN=OISTE WISeKey Global Root GB CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:d8:17:b7:1c:4a:24:2a:d6:97:b1:ca:e2:1e:fb:\n                    7d:38:ef:98:f5:b2:39:98:4e:27:b8:11:5d:7b:d2:\n                    25:94:88:82:15:26:6a:1b:31:bb:a8:5b:21:21:2b:\n                    d8:0f:4e:9f:5a:f1:b1:5a:e4:79:d6:32:23:2b:e1:\n                    53:cc:99:45:5c:7b:4f:ad:bc:bf:87:4a:0b:4b:97:\n                    5a:a8:f6:48:ec:7d:7b:0d:cd:21:06:df:9e:15:fd:\n                    41:8a:48:b7:20:f4:a1:7a:1b:57:d4:5d:50:ff:ba:\n                    67:d8:23:99:1f:c8:3f:e3:de:ff:6f:5b:77:b1:6b:\n                    6e:b8:c9:64:f7:e1:ca:41:46:0e:29:71:d0:b9:23:\n                    fc:c9:81:5f:4e:f7:6f:df:bf:84:ad:73:64:bb:b7:\n                    42:8e:69:f6:d4:76:1d:7e:9d:a7:b8:57:8a:51:67:\n                    72:d7:d4:a8:b8:95:54:40:73:03:f6:ea:f4:eb:fe:\n                    28:42:77:3f:9d:23:1b:b2:b6:3d:80:14:07:4c:2e:\n                    4f:f7:d5:0a:16:0d:bd:66:43:37:7e:23:43:79:c3:\n                    40:86:f5:4c:29:da:8e:9a:ad:0d:a5:04:87:88:1e:\n                    85:e3:e9:53:d5:9b:c8:8b:03:63:78:eb:e0:19:4a:\n                    6e:bb:2f:6b:33:64:58:93:ad:69:bf:8f:1b:ef:82:\n                    48:c7\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: \n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                35:0F:C8:36:63:5E:E2:A3:EC:F9:3B:66:15:CE:51:52:E3:91:9A:3D\n            1.3.6.1.4.1.311.21.1: \n                ...\n    Signature Algorithm: sha256WithRSAEncryption\n         40:4c:fb:87:b2:99:81:90:7e:9d:c5:b0:b0:26:cd:88:7b:2b:\n         32:8d:6e:b8:21:71:58:97:7d:ae:37:14:af:3e:e7:f7:9a:e2:\n         7d:f6:71:98:99:04:aa:43:74:78:a3:e3:49:61:3e:73:8c:4d:\n         94:e0:f9:71:c4:b6:16:0e:53:78:1f:d6:a2:87:2f:02:39:81:\n         29:3c:af:15:98:21:30:fe:28:90:00:8c:d1:e1:cb:fa:5e:c8:\n         fd:f8:10:46:3b:a2:78:42:91:17:74:55:0a:de:50:67:4d:66:\n         d1:a7:ff:fd:d9:c0:b5:a8:a3:8a:ce:66:f5:0f:43:cd:a7:2b:\n         57:7b:63:46:6a:aa:2e:52:d8:f4:ed:e1:6d:ad:29:90:78:48:\n         ba:e1:23:aa:a3:89:ec:b5:ab:96:c0:b4:4b:a2:1d:97:9e:7a:\n         f2:6e:40:71:df:68:f1:65:4d:ce:7c:05:df:53:65:a9:a5:f0:\n         b1:97:04:70:15:46:03:98:d4:d2:bf:54:b4:a0:58:7d:52:6f:\n         da:56:26:62:d4:d8:db:89:31:6f:1c:f0:22:c2:d3:62:1c:35:\n         cd:4c:69:15:54:1a:90:98:de:eb:1e:5f:ca:77:c7:cb:8e:3d:\n         43:69:9c:9a:58:d0:24:3b:df:1b:40:96:7e:35:ad:81:c7:4e:\n         71:ba:88:13\nSHA1 Fingerprint=0F:F9:40:76:18:D3:D7:6A:4B:98:F0:A8:35:9E:0C:FD:27:AC:CC:ED\n",
    "3a9a8507106728b6eff6bd05416e20c194da0fde": "-----BEGIN CERTIFICATE-----\nMIIDxTCCAq2gAwIBAgIBADANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCVVMx\nEDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxGjAYBgNVBAoT\nEUdvRGFkZHkuY29tLCBJbmMuMTEwLwYDVQQDEyhHbyBEYWRkeSBSb290IENlcnRp\nZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTA5MDkwMTAwMDAwMFoXDTM3MTIzMTIz\nNTk1OVowgYMxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6b25hMRMwEQYDVQQH\nEwpTY290dHNkYWxlMRowGAYDVQQKExFHb0RhZGR5LmNvbSwgSW5jLjExMC8GA1UE\nAxMoR28gRGFkZHkgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgLSBHMjCCASIw\nDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAL9xYgjx+lk09xvJGKP3gElY6SKD\nE6bFIEMBO4Tx5oVJnyfq9oQbTqC023CYxzIBsQU+B07u9PpPL1kwIuerGVZr4oAH\n/PMWdYA5UXvl+TW2dE6pjYIT5LY/qQOD+qK+ihVqf94Lw7YZFAXK6sOoBJQ7Rnwy\nDfMAZiLIjWltNowRGLfTshxgtDj6AozO091GB94KPutdfMh8+7ArU6SSYmlRJQVh\nGkSBjCypQ5Yj36w6gZoOKcUcqeldHraenjAKOc7xiID7S13MMuyFYkMlNAJWJwGR\ntDtwKj9useiciAF9n9T521NtYJ2/LOdYq7hfRvzOxBsDPAnrSTFcaUaz4EcCAwEA\nAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYE\nFDqahQcQZyi27/a9BUFuIMGU2g/eMA0GCSqGSIb3DQEBCwUAA4IBAQCZ21151fmX\nWWcDYfF+OwYxdS2hII5PZYe096acvNjpL9DbWu7PdIxztDhC2gV7+AJ1uP2lsdeu\n9tfeE8tTEH6KRtGX+rcuKxGrkLAngPnon1rpN5+r5N9ss4UXnT3ZJE95kTXWXwTr\ngIOrmgIttRD02JDHBHNA7XIloKmf7J6raBKZV8aPEjoJpL1E/QYVN8Gb5DKj7Tjo\n2GTzLH4U/ALqn83/B2gX2yKQOC16jdFU8WnjXzPKej17CuPKf1855eJ1usV2GDPO\nLPAvTK33sefOT6jEm0pUBsV/fdUID+Ic/n4XuKxe9tQWskMJDE32p2u0mYRlynqI\n4uJEvlz36hz1\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 0 (0x0)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., CN=Go Daddy Root Certificate Authority - G2\n        Validity\n            Not Before: Sep  1 00:00:00 2009 GMT\n            Not After : Dec 31 23:59:59 2037 GMT\n        Subject: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., CN=Go Daddy Root Certificate Authority - G2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:bf:71:62:08:f1:fa:59:34:f7:1b:c9:18:a3:f7:\n                    80:49:58:e9:22:83:13:a6:c5:20:43:01:3b:84:f1:\n                    e6:85:49:9f:27:ea:f6:84:1b:4e:a0:b4:db:70:98:\n                    c7:32:01:b1:05:3e:07:4e:ee:f4:fa:4f:2f:59:30:\n                    22:e7:ab:19:56:6b:e2:80:07:fc:f3:16:75:80:39:\n                    51:7b:e5:f9:35:b6:74:4e:a9:8d:82:13:e4:b6:3f:\n                    a9:03:83:fa:a2:be:8a:15:6a:7f:de:0b:c3:b6:19:\n                    14:05:ca:ea:c3:a8:04:94:3b:46:7c:32:0d:f3:00:\n                    66:22:c8:8d:69:6d:36:8c:11:18:b7:d3:b2:1c:60:\n                    b4:38:fa:02:8c:ce:d3:dd:46:07:de:0a:3e:eb:5d:\n                    7c:c8:7c:fb:b0:2b:53:a4:92:62:69:51:25:05:61:\n                    1a:44:81:8c:2c:a9:43:96:23:df:ac:3a:81:9a:0e:\n                    29:c5:1c:a9:e9:5d:1e:b6:9e:9e:30:0a:39:ce:f1:\n                    88:80:fb:4b:5d:cc:32:ec:85:62:43:25:34:02:56:\n                    27:01:91:b4:3b:70:2a:3f:6e:b1:e8:9c:88:01:7d:\n                    9f:d4:f9:db:53:6d:60:9d:bf:2c:e7:58:ab:b8:5f:\n                    46:fc:ce:c4:1b:03:3c:09:eb:49:31:5c:69:46:b3:\n                    e0:47\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                3A:9A:85:07:10:67:28:B6:EF:F6:BD:05:41:6E:20:C1:94:DA:0F:DE\n    Signature Algorithm: sha256WithRSAEncryption\n         99:db:5d:79:d5:f9:97:59:67:03:61:f1:7e:3b:06:31:75:2d:\n         a1:20:8e:4f:65:87:b4:f7:a6:9c:bc:d8:e9:2f:d0:db:5a:ee:\n         cf:74:8c:73:b4:38:42:da:05:7b:f8:02:75:b8:fd:a5:b1:d7:\n         ae:f6:d7:de:13:cb:53:10:7e:8a:46:d1:97:fa:b7:2e:2b:11:\n         ab:90:b0:27:80:f9:e8:9f:5a:e9:37:9f:ab:e4:df:6c:b3:85:\n         17:9d:3d:d9:24:4f:79:91:35:d6:5f:04:eb:80:83:ab:9a:02:\n         2d:b5:10:f4:d8:90:c7:04:73:40:ed:72:25:a0:a9:9f:ec:9e:\n         ab:68:12:99:57:c6:8f:12:3a:09:a4:bd:44:fd:06:15:37:c1:\n         9b:e4:32:a3:ed:38:e8:d8:64:f3:2c:7e:14:fc:02:ea:9f:cd:\n         ff:07:68:17:db:22:90:38:2d:7a:8d:d1:54:f1:69:e3:5f:33:\n         ca:7a:3d:7b:0a:e3:ca:7f:5f:39:e5:e2:75:ba:c5:76:18:33:\n         ce:2c:f0:2f:4c:ad:f7:b1:e7:ce:4f:a8:c4:9b:4a:54:06:c5:\n         7f:7d:d5:08:0f:e2:1c:fe:7e:17:b8:ac:5e:f6:d4:16:b2:43:\n         09:0c:4d:f6:a7:6b:b4:99:84:65:ca:7a:88:e2:e2:44:be:5c:\n         f7:ea:1c:f5\nSHA1 Fingerprint=47:BE:AB:C9:22:EA:E8:0E:78:78:34:62:A7:9F:45:C2:54:FD:E6:8B\n",
    "3ae10986d4cf19c29676744976dce035c663639a": "-----BEGIN CERTIFICATE-----\nMIICjzCCAhWgAwIBAgIQXIuZxVqUxdJxVt7NiYDMJjAKBggqhkjOPQQDAzCBiDEL\nMAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxFDASBgNVBAcTC0plcnNl\neSBDaXR5MR4wHAYDVQQKExVUaGUgVVNFUlRSVVNUIE5ldHdvcmsxLjAsBgNVBAMT\nJVVTRVJUcnVzdCBFQ0MgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTAwMjAx\nMDAwMDAwWhcNMzgwMTE4MjM1OTU5WjCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgT\nCk5ldyBKZXJzZXkxFDASBgNVBAcTC0plcnNleSBDaXR5MR4wHAYDVQQKExVUaGUg\nVVNFUlRSVVNUIE5ldHdvcmsxLjAsBgNVBAMTJVVTRVJUcnVzdCBFQ0MgQ2VydGlm\naWNhdGlvbiBBdXRob3JpdHkwdjAQBgcqhkjOPQIBBgUrgQQAIgNiAAQarFRaqflo\nI+d61SRvU8Za2EurxtW20eZzca7dnNYMYf3boIkDuAUU7FfO7l0/4iGzzvfUinng\no4N+LZfQYcTxmdwlkWOrfzCjtHDix6EznPO/LlxTsV+zfTJ/ijTjeXmjQjBAMB0G\nA1UdDgQWBBQ64QmG1M8ZwpZ2dEl23OA1xmNjmjAOBgNVHQ8BAf8EBAMCAQYwDwYD\nVR0TAQH/BAUwAwEB/zAKBggqhkjOPQQDAwNoADBlAjA2Z6EWCNzklwBBHU6+4WMB\nzzuqQhFkoJ2UOQIReVx7Hfpkue4WQrO/isIJxOzksU0CMQDpKmFHjFJKS04YcPbW\nRNZu9YO6bVi9JNlWSOrvxKJGgYhqOkbRqZtNyWHa0V1Xahg=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            5c:8b:99:c5:5a:94:c5:d2:71:56:de:cd:89:80:cc:26\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, ST=New Jersey, L=Jersey City, O=The USERTRUST Network, CN=USERTrust ECC Certification Authority\n        Validity\n            Not Before: Feb  1 00:00:00 2010 GMT\n            Not After : Jan 18 23:59:59 2038 GMT\n        Subject: C=US, ST=New Jersey, L=Jersey City, O=The USERTRUST Network, CN=USERTrust ECC Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:1a:ac:54:5a:a9:f9:68:23:e7:7a:d5:24:6f:53:\n                    c6:5a:d8:4b:ab:c6:d5:b6:d1:e6:73:71:ae:dd:9c:\n                    d6:0c:61:fd:db:a0:89:03:b8:05:14:ec:57:ce:ee:\n                    5d:3f:e2:21:b3:ce:f7:d4:8a:79:e0:a3:83:7e:2d:\n                    97:d0:61:c4:f1:99:dc:25:91:63:ab:7f:30:a3:b4:\n                    70:e2:c7:a1:33:9c:f3:bf:2e:5c:53:b1:5f:b3:7d:\n                    32:7f:8a:34:e3:79:79\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                3A:E1:09:86:D4:CF:19:C2:96:76:74:49:76:DC:E0:35:C6:63:63:9A\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: ecdsa-with-SHA384\n         30:65:02:30:36:67:a1:16:08:dc:e4:97:00:41:1d:4e:be:e1:\n         63:01:cf:3b:aa:42:11:64:a0:9d:94:39:02:11:79:5c:7b:1d:\n         fa:64:b9:ee:16:42:b3:bf:8a:c2:09:c4:ec:e4:b1:4d:02:31:\n         00:e9:2a:61:47:8c:52:4a:4b:4e:18:70:f6:d6:44:d6:6e:f5:\n         83:ba:6d:58:bd:24:d9:56:48:ea:ef:c4:a2:46:81:88:6a:3a:\n         46:d1:a9:9b:4d:c9:61:da:d1:5d:57:6a:18\nSHA1 Fingerprint=D1:CB:CA:5D:B2:D5:2A:7F:69:3B:67:4D:E5:F0:5A:1D:0C:95:7D:F0\n",
    "3de629489bea07ca21444a26de6eded283d09f59": "-----BEGIN CERTIFICATE-----\nMIICHjCCAaSgAwIBAgIRYFlJ4CYuu1X5CneKcflK2GwwCgYIKoZIzj0EAwMwUDEk\nMCIGA1UECxMbR2xvYmFsU2lnbiBFQ0MgUm9vdCBDQSAtIFI1MRMwEQYDVQQKEwpH\nbG9iYWxTaWduMRMwEQYDVQQDEwpHbG9iYWxTaWduMB4XDTEyMTExMzAwMDAwMFoX\nDTM4MDExOTAzMTQwN1owUDEkMCIGA1UECxMbR2xvYmFsU2lnbiBFQ0MgUm9vdCBD\nQSAtIFI1MRMwEQYDVQQKEwpHbG9iYWxTaWduMRMwEQYDVQQDEwpHbG9iYWxTaWdu\nMHYwEAYHKoZIzj0CAQYFK4EEACIDYgAER0UOlvt9Xb/pOdEh+J8LttV7HpI6SFkc\n8GIxLcB6KP4ap1yztsyX50XUWPrRd21DosCHZTQKH3rd6zwzocWdTaRvQZU4f8ke\nhOvRnkmSh5SHDDqFSmafnVmTTZdhBoZKo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYD\nVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUPeYpSJvqB8ohREom3m7e0oPQn1kwCgYI\nKoZIzj0EAwMDaAAwZQIxAOVpEslu28YxuglB4Zf4+/2a4n0Sye18ZNPLBSWLVtmg\n515dTguDnFt2KaAJJiFqYgIwcdK1j1zqO+F4CYWodZI7yFz9SO8NdCKoCOJuxUnO\nxwy8p2Fp8fc74SrL+SvzZpA3\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            60:59:49:e0:26:2e:bb:55:f9:0a:77:8a:71:f9:4a:d8:6c\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: OU=GlobalSign ECC Root CA - R5, O=GlobalSign, CN=GlobalSign\n        Validity\n            Not Before: Nov 13 00:00:00 2012 GMT\n            Not After : Jan 19 03:14:07 2038 GMT\n        Subject: OU=GlobalSign ECC Root CA - R5, O=GlobalSign, CN=GlobalSign\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:47:45:0e:96:fb:7d:5d:bf:e9:39:d1:21:f8:9f:\n                    0b:b6:d5:7b:1e:92:3a:48:59:1c:f0:62:31:2d:c0:\n                    7a:28:fe:1a:a7:5c:b3:b6:cc:97:e7:45:d4:58:fa:\n                    d1:77:6d:43:a2:c0:87:65:34:0a:1f:7a:dd:eb:3c:\n                    33:a1:c5:9d:4d:a4:6f:41:95:38:7f:c9:1e:84:eb:\n                    d1:9e:49:92:87:94:87:0c:3a:85:4a:66:9f:9d:59:\n                    93:4d:97:61:06:86:4a\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                3D:E6:29:48:9B:EA:07:CA:21:44:4A:26:DE:6E:DE:D2:83:D0:9F:59\n    Signature Algorithm: ecdsa-with-SHA384\n         30:65:02:31:00:e5:69:12:c9:6e:db:c6:31:ba:09:41:e1:97:\n         f8:fb:fd:9a:e2:7d:12:c9:ed:7c:64:d3:cb:05:25:8b:56:d9:\n         a0:e7:5e:5d:4e:0b:83:9c:5b:76:29:a0:09:26:21:6a:62:02:\n         30:71:d2:b5:8f:5c:ea:3b:e1:78:09:85:a8:75:92:3b:c8:5c:\n         fd:48:ef:0d:74:22:a8:08:e2:6e:c5:49:ce:c7:0c:bc:a7:61:\n         69:f1:f7:3b:e1:2a:cb:f9:2b:f3:66:90:37\nSHA1 Fingerprint=1F:24:C6:30:CD:A4:18:EF:20:69:FF:AD:4F:DD:5F:46:3A:1B:69:AA\n",
    "4232b616fa04fdfe5d4b7ac3fdf74c401d5a43af": "-----BEGIN CERTIFICATE-----\nMIIDuDCCAqCgAwIBAgIQDPCOXAgWpa1Cf/DrJxhZ0DANBgkqhkiG9w0BAQUFADBI\nMQswCQYDVQQGEwJVUzEgMB4GA1UEChMXU2VjdXJlVHJ1c3QgQ29ycG9yYXRpb24x\nFzAVBgNVBAMTDlNlY3VyZVRydXN0IENBMB4XDTA2MTEwNzE5MzExOFoXDTI5MTIz\nMTE5NDA1NVowSDELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1NlY3VyZVRydXN0IENv\ncnBvcmF0aW9uMRcwFQYDVQQDEw5TZWN1cmVUcnVzdCBDQTCCASIwDQYJKoZIhvcN\nAQEBBQADggEPADCCAQoCggEBAKukgeWVzfX2FI7CT8rU4niVWJxB4Q2ZQCQXOZEz\nZum+4YOvYlyJ0fwkW2Gz4BERQRwdbvC4u/jep4G6pkjGnx29vo6pQT64lO0pGtSO\n0gMdA+9tDWccV9cGrcrI9f4Or2YlSASWC12juhbDCE/RRvgUXPLIXgGZbf2IzIao\nwW8xQmxSPmjL8xk037uHGFaAJsTQ3MBv396gwpEWoGQRS0S8Hvbn+mPeZqx2pHGj\n7DaUaHp3pLHnDi+BeuK1cobvomuL8A/b01k/unK8RCSc43Oz969XL0Imnal0ugBS\n8kvNU3xHCzaFDmapCJcWNFfBZveA4+1wVMeT4C4oFVmHursCAwEAAaOBnTCBmjAT\nBgkrBgEEAYI3FAIEBh4EAEMAQTALBgNVHQ8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB\n/zAdBgNVHQ4EFgQUQjK2FvoE/f5dS3rD/fdMQB1aQ68wNAYDVR0fBC0wKzApoCeg\nJYYjaHR0cDovL2NybC5zZWN1cmV0cnVzdC5jb20vU1RDQS5jcmwwEAYJKwYBBAGC\nNxUBBAMCAQAwDQYJKoZIhvcNAQEFBQADggEBADDtT0rhWDpSclu1pqNlGKa7UTt3\n6Z3q059c4EVlew3KW+JwULKUBRSuSceNQQcSc5R+DCMh/bwQf2AQWnL1mA6s7Ll/\n3XpvXdMc9P+IBWlCqQVxyLesJugutIxq/3HcuLHfmbx8IVQr5Fiiu1cprp6poxkm\nD5kuCLDv/WnPmRoJjeOnnyvJNjR7JLN4TJUXpAYmHrZkUjZfYGfZnMUFdAvnZyPS\nCPyI6a6Lf+Ew9Dd+/cYy2i2eRDAwbO4H3tI0/NL/QPZL9GZGBlSm8jIKYyYwa5vR\n3ItHuuG51WLQoqD0ZwV4KWMabwTW+MZMo5qxN7SN5ShLHZ4swrhovO0C7jE=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            0c:f0:8e:5c:08:16:a5:ad:42:7f:f0:eb:27:18:59:d0\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=US, O=SecureTrust Corporation, CN=SecureTrust CA\n        Validity\n            Not Before: Nov  7 19:31:18 2006 GMT\n            Not After : Dec 31 19:40:55 2029 GMT\n        Subject: C=US, O=SecureTrust Corporation, CN=SecureTrust CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:ab:a4:81:e5:95:cd:f5:f6:14:8e:c2:4f:ca:d4:\n                    e2:78:95:58:9c:41:e1:0d:99:40:24:17:39:91:33:\n                    66:e9:be:e1:83:af:62:5c:89:d1:fc:24:5b:61:b3:\n                    e0:11:11:41:1c:1d:6e:f0:b8:bb:f8:de:a7:81:ba:\n                    a6:48:c6:9f:1d:bd:be:8e:a9:41:3e:b8:94:ed:29:\n                    1a:d4:8e:d2:03:1d:03:ef:6d:0d:67:1c:57:d7:06:\n                    ad:ca:c8:f5:fe:0e:af:66:25:48:04:96:0b:5d:a3:\n                    ba:16:c3:08:4f:d1:46:f8:14:5c:f2:c8:5e:01:99:\n                    6d:fd:88:cc:86:a8:c1:6f:31:42:6c:52:3e:68:cb:\n                    f3:19:34:df:bb:87:18:56:80:26:c4:d0:dc:c0:6f:\n                    df:de:a0:c2:91:16:a0:64:11:4b:44:bc:1e:f6:e7:\n                    fa:63:de:66:ac:76:a4:71:a3:ec:36:94:68:7a:77:\n                    a4:b1:e7:0e:2f:81:7a:e2:b5:72:86:ef:a2:6b:8b:\n                    f0:0f:db:d3:59:3f:ba:72:bc:44:24:9c:e3:73:b3:\n                    f7:af:57:2f:42:26:9d:a9:74:ba:00:52:f2:4b:cd:\n                    53:7c:47:0b:36:85:0e:66:a9:08:97:16:34:57:c1:\n                    66:f7:80:e3:ed:70:54:c7:93:e0:2e:28:15:59:87:\n                    ba:bb\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            1.3.6.1.4.1.311.20.2: \n                ...C.A\n            X509v3 Key Usage: \n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                42:32:B6:16:FA:04:FD:FE:5D:4B:7A:C3:FD:F7:4C:40:1D:5A:43:AF\n            X509v3 CRL Distribution Points: \n\n                Full Name:\n                  URI:http://crl.securetrust.com/STCA.crl\n\n            1.3.6.1.4.1.311.21.1: \n                ...\n    Signature Algorithm: sha1WithRSAEncryption\n         30:ed:4f:4a:e1:58:3a:52:72:5b:b5:a6:a3:65:18:a6:bb:51:\n         3b:77:e9:9d:ea:d3:9f:5c:e0:45:65:7b:0d:ca:5b:e2:70:50:\n         b2:94:05:14:ae:49:c7:8d:41:07:12:73:94:7e:0c:23:21:fd:\n         bc:10:7f:60:10:5a:72:f5:98:0e:ac:ec:b9:7f:dd:7a:6f:5d:\n         d3:1c:f4:ff:88:05:69:42:a9:05:71:c8:b7:ac:26:e8:2e:b4:\n         8c:6a:ff:71:dc:b8:b1:df:99:bc:7c:21:54:2b:e4:58:a2:bb:\n         57:29:ae:9e:a9:a3:19:26:0f:99:2e:08:b0:ef:fd:69:cf:99:\n         1a:09:8d:e3:a7:9f:2b:c9:36:34:7b:24:b3:78:4c:95:17:a4:\n         06:26:1e:b6:64:52:36:5f:60:67:d9:9c:c5:05:74:0b:e7:67:\n         23:d2:08:fc:88:e9:ae:8b:7f:e1:30:f4:37:7e:fd:c6:32:da:\n         2d:9e:44:30:30:6c:ee:07:de:d2:34:fc:d2:ff:40:f6:4b:f4:\n         66:46:06:54:a6:f2:32:0a:63:26:30:6b:9b:d1:dc:8b:47:ba:\n         e1:b9:d5:62:d0:a2:a0:f4:67:05:78:29:63:1a:6f:04:d6:f8:\n         c6:4c:a3:9a:b1:37:b4:8d:e5:28:4b:1d:9e:2c:c2:b8:68:bc:\n         ed:02:ee:31\nSHA1 Fingerprint=87:82:C6:C3:04:35:3B:CF:D2:96:92:D2:59:3E:7D:44:D9:34:FF:11\n",
    "449e48f5cc6d48d4a04b7ffe59242f8397999a86": "-----BEGIN CERTIFICATE-----\nMIIEIDCCAwigAwIBAgIJAISCLF8cYtBAMA0GCSqGSIb3DQEBCwUAMIGcMQswCQYD\nVQQGEwJQQTEPMA0GA1UECAwGUGFuYW1hMRQwEgYDVQQHDAtQYW5hbWEgQ2l0eTEk\nMCIGA1UECgwbVHJ1c3RDb3IgU3lzdGVtcyBTLiBkZSBSLkwuMScwJQYDVQQLDB5U\ncnVzdENvciBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxFzAVBgNVBAMMDlRydXN0Q29y\nIEVDQS0xMB4XDTE2MDIwNDEyMzIzM1oXDTI5MTIzMTE3MjgwN1owgZwxCzAJBgNV\nBAYTAlBBMQ8wDQYDVQQIDAZQYW5hbWExFDASBgNVBAcMC1BhbmFtYSBDaXR5MSQw\nIgYDVQQKDBtUcnVzdENvciBTeXN0ZW1zIFMuIGRlIFIuTC4xJzAlBgNVBAsMHlRy\ndXN0Q29yIENlcnRpZmljYXRlIEF1dGhvcml0eTEXMBUGA1UEAwwOVHJ1c3RDb3Ig\nRUNBLTEwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDPj+ARtZ+odnbb\n3w9U73NjKYKtR8aja+3+XzP4Q1HpGjORMRegdMTUpwHmspI+ap3tDvl0mEDTPwOA\nBoJA6LHip1GnHYMma6ve+heRK9jGrB6xnhkB1Zem6g23xFUfJ3zSCNV2HykVh0A5\n3ThFEXXQmqc04L/NyFIduUd+Dbi7xgz2c1cWWn5DkR9VOsZtRASqnKmcp0yJF4Ou\nowReUoCLHhIlERnXDH19MURB6tuvsBzvgdAsxZohmz3tQjtQJvLsznFhBmIhVE5/\nwZ0+fyCMgMsq2JdiyIMzkX2woloPV+g7zPIlstR8L+xNxqE6FXrntl019fZISjZF\nZtS6mFjBAgMBAAGjYzBhMB0GA1UdDgQWBBREnkj1zG1I1KBLf/5ZJC+Dl5mahjAf\nBgNVHSMEGDAWgBREnkj1zG1I1KBLf/5ZJC+Dl5mahjAPBgNVHRMBAf8EBTADAQH/\nMA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOCAQEABT41XBVwm8nHc2Fv\ncivUwo/yQ10CzsSUuZQRg2dd4mdsdXa/uwyqNsatR5Nj3B5+1t4u/ukZMjgDfxT2\nAHMsWbEhBuH7rBiVDKP/mZb3Kyeb1STMHd3BOuCYRLDE5D53sXOpZCz2HAF8P11F\nhcCF5yWPldwX8zyfGm6wyuMdKulMY/okYWLW2n62HGz1Ah3UKt1VkOsqEUc8Ll50\nsoIipX1TH0XsJ5F95yIW6MBoNtjG8U+ARDL54dHRHareqKucBK+tIA5kmE2la8BI\nWJZpTdwHjFGTot+fDz2LYLSCjaoITmJF4PkL0uDgPFveXHEnJcLmA4GLEFPjx1Wi\ntJ/X5g==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            84:82:2c:5f:1c:62:d0:40\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor ECA-1\n        Validity\n            Not Before: Feb  4 12:32:33 2016 GMT\n            Not After : Dec 31 17:28:07 2029 GMT\n        Subject: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor ECA-1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:cf:8f:e0:11:b5:9f:a8:76:76:db:df:0f:54:ef:\n                    73:63:29:82:ad:47:c6:a3:6b:ed:fe:5f:33:f8:43:\n                    51:e9:1a:33:91:31:17:a0:74:c4:d4:a7:01:e6:b2:\n                    92:3e:6a:9d:ed:0e:f9:74:98:40:d3:3f:03:80:06:\n                    82:40:e8:b1:e2:a7:51:a7:1d:83:26:6b:ab:de:fa:\n                    17:91:2b:d8:c6:ac:1e:b1:9e:19:01:d5:97:a6:ea:\n                    0d:b7:c4:55:1f:27:7c:d2:08:d5:76:1f:29:15:87:\n                    40:39:dd:38:45:11:75:d0:9a:a7:34:e0:bf:cd:c8:\n                    52:1d:b9:47:7e:0d:b8:bb:c6:0c:f6:73:57:16:5a:\n                    7e:43:91:1f:55:3a:c6:6d:44:04:aa:9c:a9:9c:a7:\n                    4c:89:17:83:ae:a3:04:5e:52:80:8b:1e:12:25:11:\n                    19:d7:0c:7d:7d:31:44:41:ea:db:af:b0:1c:ef:81:\n                    d0:2c:c5:9a:21:9b:3d:ed:42:3b:50:26:f2:ec:ce:\n                    71:61:06:62:21:54:4e:7f:c1:9d:3e:7f:20:8c:80:\n                    cb:2a:d8:97:62:c8:83:33:91:7d:b0:a2:5a:0f:57:\n                    e8:3b:cc:f2:25:b2:d4:7c:2f:ec:4d:c6:a1:3a:15:\n                    7a:e7:b6:5d:35:f5:f6:48:4a:36:45:66:d4:ba:98:\n                    58:c1\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                44:9E:48:F5:CC:6D:48:D4:A0:4B:7F:FE:59:24:2F:83:97:99:9A:86\n            X509v3 Authority Key Identifier: \n                keyid:44:9E:48:F5:CC:6D:48:D4:A0:4B:7F:FE:59:24:2F:83:97:99:9A:86\n\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         05:3e:35:5c:15:70:9b:c9:c7:73:61:6f:72:2b:d4:c2:8f:f2:\n         43:5d:02:ce:c4:94:b9:94:11:83:67:5d:e2:67:6c:75:76:bf:\n         bb:0c:aa:36:c6:ad:47:93:63:dc:1e:7e:d6:de:2e:fe:e9:19:\n         32:38:03:7f:14:f6:00:73:2c:59:b1:21:06:e1:fb:ac:18:95:\n         0c:a3:ff:99:96:f7:2b:27:9b:d5:24:cc:1d:dd:c1:3a:e0:98:\n         44:b0:c4:e4:3e:77:b1:73:a9:64:2c:f6:1c:01:7c:3f:5d:45:\n         85:c0:85:e7:25:8f:95:dc:17:f3:3c:9f:1a:6e:b0:ca:e3:1d:\n         2a:e9:4c:63:fa:24:61:62:d6:da:7e:b6:1c:6c:f5:02:1d:d4:\n         2a:dd:55:90:eb:2a:11:47:3c:2e:5e:74:b2:82:22:a5:7d:53:\n         1f:45:ec:27:91:7d:e7:22:16:e8:c0:68:36:d8:c6:f1:4f:80:\n         44:32:f9:e1:d1:d1:1d:aa:de:a8:ab:9c:04:af:ad:20:0e:64:\n         98:4d:a5:6b:c0:48:58:96:69:4d:dc:07:8c:51:93:a2:df:9f:\n         0f:3d:8b:60:b4:82:8d:aa:08:4e:62:45:e0:f9:0b:d2:e0:e0:\n         3c:5b:de:5c:71:27:25:c2:e6:03:81:8b:10:53:e3:c7:55:a2:\n         b4:9f:d7:e6\nSHA1 Fingerprint=58:D1:DF:95:95:67:6B:63:C0:F0:5B:1C:17:4D:8B:84:0B:C8:78:BD\n",
    "45eba2aff492cb82312d518ba7a7219df36dc80f": "-----BEGIN CERTIFICATE-----\nMIIDtzCCAp+gAwIBAgIQDOfg5RfYRv6P5WD8G/AwOTANBgkqhkiG9w0BAQUFADBl\nMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3\nd3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv\nb3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMzExMTEwMDAwMDAwWjBlMQswCQYDVQQG\nEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl\ncnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0EwggEi\nMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCtDhXO5EOAXLGH87dg+XESpa7c\nJpSIqvTO9SA5KFhgDPiA2qkVlTJhPLWxKISKityfCgyDF3qPkKyK53lTXDGEKvYP\nmDI2dsze3Tyoou9q+yHyUmHfnyDXH+Kx2f4YZNISW1/5WBg1vEfNoTb5a3/UsDg+\nwRvDjDPZ2C8Y/igPs6eD1sNuRMBhNZYW/lmci3Zt1/GiSw0r/wty2p5g0I6QNcZ4\nVYcgoc/lbQrISXwxmDNsIumH0DJaoroTghHtORedmTpyoeb6pNnVFzF1roV9Iq4/\nAUaG9ih5yLHa5FcXxH4cDrC0kqZWs72yl+2qp/C3xag/lRbQ/6GW6whfGHdPAgMB\nAAGjYzBhMA4GA1UdDwEB/wQEAwIBhjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQW\nBBRF66Kv9JLLgjEtUYunpyGd823IDzAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYun\npyGd823IDzANBgkqhkiG9w0BAQUFAAOCAQEAog683+Lt8ONyc3pklL/3cmbYMuRC\ndWKuh+vy1dneVrOfzM4UKLkNl2BcEkxY5NM9g0lFWJc1aRqoR+pWxnmrEthngYTf\nfwk8lOa4JiwgvT2zKIn3X/8i4peEH+ll74fg38FnSbNd67IJKusm7Xi+fT8r87cm\nNW1fiQG2SVufAQWbqz0lwcy2f8Lxb4bG+mRo64EtlOtCt/qMHt1i8b5QZ7dsvfPx\nH2sMNgcWfzd8qVttevESRmCD1ycEvkvOl77DZypoEd+A5wwzZr8TDRRu838fYxAe\n+o0bJW1sj6W3YQGx0qMmoRBxna3iw/nDmVG3KwcIzi7mULKn+gpFL6Lw8g==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            0c:e7:e0:e5:17:d8:46:fe:8f:e5:60:fc:1b:f0:30:39\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root CA\n        Validity\n            Not Before: Nov 10 00:00:00 2006 GMT\n            Not After : Nov 10 00:00:00 2031 GMT\n        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:ad:0e:15:ce:e4:43:80:5c:b1:87:f3:b7:60:f9:\n                    71:12:a5:ae:dc:26:94:88:aa:f4:ce:f5:20:39:28:\n                    58:60:0c:f8:80:da:a9:15:95:32:61:3c:b5:b1:28:\n                    84:8a:8a:dc:9f:0a:0c:83:17:7a:8f:90:ac:8a:e7:\n                    79:53:5c:31:84:2a:f6:0f:98:32:36:76:cc:de:dd:\n                    3c:a8:a2:ef:6a:fb:21:f2:52:61:df:9f:20:d7:1f:\n                    e2:b1:d9:fe:18:64:d2:12:5b:5f:f9:58:18:35:bc:\n                    47:cd:a1:36:f9:6b:7f:d4:b0:38:3e:c1:1b:c3:8c:\n                    33:d9:d8:2f:18:fe:28:0f:b3:a7:83:d6:c3:6e:44:\n                    c0:61:35:96:16:fe:59:9c:8b:76:6d:d7:f1:a2:4b:\n                    0d:2b:ff:0b:72:da:9e:60:d0:8e:90:35:c6:78:55:\n                    87:20:a1:cf:e5:6d:0a:c8:49:7c:31:98:33:6c:22:\n                    e9:87:d0:32:5a:a2:ba:13:82:11:ed:39:17:9d:99:\n                    3a:72:a1:e6:fa:a4:d9:d5:17:31:75:ae:85:7d:22:\n                    ae:3f:01:46:86:f6:28:79:c8:b1:da:e4:57:17:c4:\n                    7e:1c:0e:b0:b4:92:a6:56:b3:bd:b2:97:ed:aa:a7:\n                    f0:b7:c5:a8:3f:95:16:d0:ff:a1:96:eb:08:5f:18:\n                    77:4f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                45:EB:A2:AF:F4:92:CB:82:31:2D:51:8B:A7:A7:21:9D:F3:6D:C8:0F\n            X509v3 Authority Key Identifier: \n                keyid:45:EB:A2:AF:F4:92:CB:82:31:2D:51:8B:A7:A7:21:9D:F3:6D:C8:0F\n\n    Signature Algorithm: sha1WithRSAEncryption\n         a2:0e:bc:df:e2:ed:f0:e3:72:73:7a:64:94:bf:f7:72:66:d8:\n         32:e4:42:75:62:ae:87:eb:f2:d5:d9:de:56:b3:9f:cc:ce:14:\n         28:b9:0d:97:60:5c:12:4c:58:e4:d3:3d:83:49:45:58:97:35:\n         69:1a:a8:47:ea:56:c6:79:ab:12:d8:67:81:84:df:7f:09:3c:\n         94:e6:b8:26:2c:20:bd:3d:b3:28:89:f7:5f:ff:22:e2:97:84:\n         1f:e9:65:ef:87:e0:df:c1:67:49:b3:5d:eb:b2:09:2a:eb:26:\n         ed:78:be:7d:3f:2b:f3:b7:26:35:6d:5f:89:01:b6:49:5b:9f:\n         01:05:9b:ab:3d:25:c1:cc:b6:7f:c2:f1:6f:86:c6:fa:64:68:\n         eb:81:2d:94:eb:42:b7:fa:8c:1e:dd:62:f1:be:50:67:b7:6c:\n         bd:f3:f1:1f:6b:0c:36:07:16:7f:37:7c:a9:5b:6d:7a:f1:12:\n         46:60:83:d7:27:04:be:4b:ce:97:be:c3:67:2a:68:11:df:80:\n         e7:0c:33:66:bf:13:0d:14:6e:f3:7f:1f:63:10:1e:fa:8d:1b:\n         25:6d:6c:8f:a5:b7:61:01:b1:d2:a3:26:a1:10:71:9d:ad:e2:\n         c3:f9:c3:99:51:b7:2b:07:08:ce:2e:e6:50:b2:a7:fa:0a:45:\n         2f:a2:f0:f2\nSHA1 Fingerprint=05:63:B8:63:0D:62:D7:5A:BB:C8:AB:1E:4B:DF:B5:A8:99:B2:4D:43\n",
    "47b8cdffe56feef8b2ec2f4e0ef925b08e3c6bc3": "-----BEGIN CERTIFICATE-----\nMIIFWTCCA0GgAwIBAgIBAjANBgkqhkiG9w0BAQsFADBOMQswCQYDVQQGEwJOTzEd\nMBsGA1UECgwUQnV5cGFzcyBBUy05ODMxNjMzMjcxIDAeBgNVBAMMF0J1eXBhc3Mg\nQ2xhc3MgMyBSb290IENBMB4XDTEwMTAyNjA4Mjg1OFoXDTQwMTAyNjA4Mjg1OFow\nTjELMAkGA1UEBhMCTk8xHTAbBgNVBAoMFEJ1eXBhc3MgQVMtOTgzMTYzMzI3MSAw\nHgYDVQQDDBdCdXlwYXNzIENsYXNzIDMgUm9vdCBDQTCCAiIwDQYJKoZIhvcNAQEB\nBQADggIPADCCAgoCggIBAKXaCpUWUOOV8l6ddjEGMnqb8RB2uACatVI2zSRHsJ8Y\nZLya9vrVediQYkwiL944PdbgqOkcLNt4EemOaFEVcsfzM4fkoF0LXOBXByow9c3E\nN3coTRiR5r/VUv1xLXA+58bEiuPwKAv0dpihi4dVsjoT/Lc+JzeOIuOoTyrvYLs9\ntznDDgFHmV0ST9tD+leh7fmdvhFHJlsTmKtdFoqwNxxXnUX/iJY2v7vKB3tvh2PX\n0DJq1l1sDPGzbjniazEuOQAnFN44wOwZZoYS6J1yFhNkUsepNxz9gjDthBgd9K5c\n/3ATAOux9TN6S9ZV+AWNS2mw9bMoNlwUxFFzTWsL8TQH2xc519woe2v1n/MuwU8X\nKhDzzMro6/1rqy6any2CbgTUUgGTLT2G/H783+9CHaZr77kgxve9oKeV/afmiSTY\nzIw0bOIjL9kSGiG5VZFvC5F5GQytQIgLcOJ60g7YaEi7ghM5EFjp2CoHxhLbWNvS\nO1UQRwUVZ2J+GGOmRj8JDlQyXr8NYnon74Do29lLBlo3WiXQCBJ31G8JUJc9yB3D\n34xFMFbG02SrZvPAXpacw8Tvw3xrizp5f7NJzz3iiZ+gMEuFuZyUJHmPfWupRWgP\nK9Dx2hzLabjKSWJtyNBjYt1gD1iqj6G8BaVmos8bdrKEZLFMOVLAMLrwjEsCsLa3\nAgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFEe4zf/lb+74suwv\nTg75JbCOPGvDMA4GA1UdDwEB/wQEAwIBBjANBgkqhkiG9w0BAQsFAAOCAgEAACAj\nQTUEkMJAYmDv4jVM1z+s4jSQuKFvdvoWFqRINyzpkMLyPPgKn9iB5btb2iUspKdV\ncSQy9sgL8rxq+JOssgfCX5/bzMiKqr5qb+FJEMwx14C7u8jYog5kV+qi9cKpMRXS\nIGrs/CIBKM+GuIAeqcwRpTzyFrNHnfzSgCHEy9BHcEGhyoMZCCxt8l13nIoUE9Q2\nHJLw5QY33KbmkJs4j1xrG0aGQ0JfPgEHU1RdZX33inOhmlRaHylDFCfChQ+1iHsa\nO5S3HWCntZznKWlXWpuTekMwGwPXYshApqr8ZORK15FTAaggiG6cX0S5y2CBNOxv\n033aSF/rtJC8LakcC6wc1aJoIIAE1vyxjy+7SjENSoYc6+I2KSb12tjE8nVhz36u\ndmNKekBlk4f4HoCMhuWG1o8O/FMsYOgWYRqiPkN7zTlgVGr18okmAWiDSKIz6MkE\nkbIRNBE+6tBDGR8Dk5AM/1E9V/RBbuHLoL7ryWPNbczk+DaqaJ3tvV2XcEQNtg41\n3OEMXbugUZTLfhbrES+jkkXITHHZvMmZUldGL1DPvTVp9D0VzgalLA8+9oG6lLvD\nu79leNKGef9JOxqDDPDeeOzI8k1MGt6CKfjBWtrt7uYnXuhF0J0cUahoq0Tj0Itq\n4/g7u9xN12TyUb7mqqta6THuBrxzvxNiCp/HuZc=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 2 (0x2)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=NO, O=Buypass AS-983163327, CN=Buypass Class 3 Root CA\n        Validity\n            Not Before: Oct 26 08:28:58 2010 GMT\n            Not After : Oct 26 08:28:58 2040 GMT\n        Subject: C=NO, O=Buypass AS-983163327, CN=Buypass Class 3 Root CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:a5:da:0a:95:16:50:e3:95:f2:5e:9d:76:31:06:\n                    32:7a:9b:f1:10:76:b8:00:9a:b5:52:36:cd:24:47:\n                    b0:9f:18:64:bc:9a:f6:fa:d5:79:d8:90:62:4c:22:\n                    2f:de:38:3d:d6:e0:a8:e9:1c:2c:db:78:11:e9:8e:\n                    68:51:15:72:c7:f3:33:87:e4:a0:5d:0b:5c:e0:57:\n                    07:2a:30:f5:cd:c4:37:77:28:4d:18:91:e6:bf:d5:\n                    52:fd:71:2d:70:3e:e7:c6:c4:8a:e3:f0:28:0b:f4:\n                    76:98:a1:8b:87:55:b2:3a:13:fc:b7:3e:27:37:8e:\n                    22:e3:a8:4f:2a:ef:60:bb:3d:b7:39:c3:0e:01:47:\n                    99:5d:12:4f:db:43:fa:57:a1:ed:f9:9d:be:11:47:\n                    26:5b:13:98:ab:5d:16:8a:b0:37:1c:57:9d:45:ff:\n                    88:96:36:bf:bb:ca:07:7b:6f:87:63:d7:d0:32:6a:\n                    d6:5d:6c:0c:f1:b3:6e:39:e2:6b:31:2e:39:00:27:\n                    14:de:38:c0:ec:19:66:86:12:e8:9d:72:16:13:64:\n                    52:c7:a9:37:1c:fd:82:30:ed:84:18:1d:f4:ae:5c:\n                    ff:70:13:00:eb:b1:f5:33:7a:4b:d6:55:f8:05:8d:\n                    4b:69:b0:f5:b3:28:36:5c:14:c4:51:73:4d:6b:0b:\n                    f1:34:07:db:17:39:d7:dc:28:7b:6b:f5:9f:f3:2e:\n                    c1:4f:17:2a:10:f3:cc:ca:e8:eb:fd:6b:ab:2e:9a:\n                    9f:2d:82:6e:04:d4:52:01:93:2d:3d:86:fc:7e:fc:\n                    df:ef:42:1d:a6:6b:ef:b9:20:c6:f7:bd:a0:a7:95:\n                    fd:a7:e6:89:24:d8:cc:8c:34:6c:e2:23:2f:d9:12:\n                    1a:21:b9:55:91:6f:0b:91:79:19:0c:ad:40:88:0b:\n                    70:e2:7a:d2:0e:d8:68:48:bb:82:13:39:10:58:e9:\n                    d8:2a:07:c6:12:db:58:db:d2:3b:55:10:47:05:15:\n                    67:62:7e:18:63:a6:46:3f:09:0e:54:32:5e:bf:0d:\n                    62:7a:27:ef:80:e8:db:d9:4b:06:5a:37:5a:25:d0:\n                    08:12:77:d4:6f:09:50:97:3d:c8:1d:c3:df:8c:45:\n                    30:56:c6:d3:64:ab:66:f3:c0:5e:96:9c:c3:c4:ef:\n                    c3:7c:6b:8b:3a:79:7f:b3:49:cf:3d:e2:89:9f:a0:\n                    30:4b:85:b9:9c:94:24:79:8f:7d:6b:a9:45:68:0f:\n                    2b:d0:f1:da:1c:cb:69:b8:ca:49:62:6d:c8:d0:63:\n                    62:dd:60:0f:58:aa:8f:a1:bc:05:a5:66:a2:cf:1b:\n                    76:b2:84:64:b1:4c:39:52:c0:30:ba:f0:8c:4b:02:\n                    b0:b6:b7\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                47:B8:CD:FF:E5:6F:EE:F8:B2:EC:2F:4E:0E:F9:25:B0:8E:3C:6B:C3\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         00:20:23:41:35:04:90:c2:40:62:60:ef:e2:35:4c:d7:3f:ac:\n         e2:34:90:b8:a1:6f:76:fa:16:16:a4:48:37:2c:e9:90:c2:f2:\n         3c:f8:0a:9f:d8:81:e5:bb:5b:da:25:2c:a4:a7:55:71:24:32:\n         f6:c8:0b:f2:bc:6a:f8:93:ac:b2:07:c2:5f:9f:db:cc:c8:8a:\n         aa:be:6a:6f:e1:49:10:cc:31:d7:80:bb:bb:c8:d8:a2:0e:64:\n         57:ea:a2:f5:c2:a9:31:15:d2:20:6a:ec:fc:22:01:28:cf:86:\n         b8:80:1e:a9:cc:11:a5:3c:f2:16:b3:47:9d:fc:d2:80:21:c4:\n         cb:d0:47:70:41:a1:ca:83:19:08:2c:6d:f2:5d:77:9c:8a:14:\n         13:d4:36:1c:92:f0:e5:06:37:dc:a6:e6:90:9b:38:8f:5c:6b:\n         1b:46:86:43:42:5f:3e:01:07:53:54:5d:65:7d:f7:8a:73:a1:\n         9a:54:5a:1f:29:43:14:27:c2:85:0f:b5:88:7b:1a:3b:94:b7:\n         1d:60:a7:b5:9c:e7:29:69:57:5a:9b:93:7a:43:30:1b:03:d7:\n         62:c8:40:a6:aa:fc:64:e4:4a:d7:91:53:01:a8:20:88:6e:9c:\n         5f:44:b9:cb:60:81:34:ec:6f:d3:7d:da:48:5f:eb:b4:90:bc:\n         2d:a9:1c:0b:ac:1c:d5:a2:68:20:80:04:d6:fc:b1:8f:2f:bb:\n         4a:31:0d:4a:86:1c:eb:e2:36:29:26:f5:da:d8:c4:f2:75:61:\n         cf:7e:ae:76:63:4a:7a:40:65:93:87:f8:1e:80:8c:86:e5:86:\n         d6:8f:0e:fc:53:2c:60:e8:16:61:1a:a2:3e:43:7b:cd:39:60:\n         54:6a:f5:f2:89:26:01:68:83:48:a2:33:e8:c9:04:91:b2:11:\n         34:11:3e:ea:d0:43:19:1f:03:93:90:0c:ff:51:3d:57:f4:41:\n         6e:e1:cb:a0:be:eb:c9:63:cd:6d:cc:e4:f8:36:aa:68:9d:ed:\n         bd:5d:97:70:44:0d:b6:0e:35:dc:e1:0c:5d:bb:a0:51:94:cb:\n         7e:16:eb:11:2f:a3:92:45:c8:4c:71:d9:bc:c9:99:52:57:46:\n         2f:50:cf:bd:35:69:f4:3d:15:ce:06:a5:2c:0f:3e:f6:81:ba:\n         94:bb:c3:bb:bf:65:78:d2:86:79:ff:49:3b:1a:83:0c:f0:de:\n         78:ec:c8:f2:4d:4c:1a:de:82:29:f8:c1:5a:da:ed:ee:e6:27:\n         5e:e8:45:d0:9d:1c:51:a8:68:ab:44:e3:d0:8b:6a:e3:f8:3b:\n         bb:dc:4d:d7:64:f2:51:be:e6:aa:ab:5a:e9:31:ee:06:bc:73:\n         bf:13:62:0a:9f:c7:b9:97\nSHA1 Fingerprint=DA:FA:F7:FA:66:84:EC:06:8F:14:50:BD:C7:C2:81:A5:BC:A9:64:57\n",
    "488714ace3c39e90603ad7ca89eed3ad8cb45066": "-----BEGIN CERTIFICATE-----\nMIICaTCCAe+gAwIBAgIQISpWDK7aDKtARb8roi066jAKBggqhkjOPQQDAzBtMQsw\nCQYDVQQGEwJDSDEQMA4GA1UEChMHV0lTZUtleTEiMCAGA1UECxMZT0lTVEUgRm91\nbmRhdGlvbiBFbmRvcnNlZDEoMCYGA1UEAxMfT0lTVEUgV0lTZUtleSBHbG9iYWwg\nUm9vdCBHQyBDQTAeFw0xNzA1MDkwOTQ4MzRaFw00MjA1MDkwOTU4MzNaMG0xCzAJ\nBgNVBAYTAkNIMRAwDgYDVQQKEwdXSVNlS2V5MSIwIAYDVQQLExlPSVNURSBGb3Vu\nZGF0aW9uIEVuZG9yc2VkMSgwJgYDVQQDEx9PSVNURSBXSVNlS2V5IEdsb2JhbCBS\nb290IEdDIENBMHYwEAYHKoZIzj0CAQYFK4EEACIDYgAETOlQwMYPchi82PG6s4ni\neUqjFqdrVCTbUf/q9Akkwwsin8tqJ4KBDdLArzHkdIJuyiXZjHWd8dvQmqJLIX4W\np2OQ0jnUsYd4XxiWD1AbNTcPasbc2RNNpI6QN+a9WzGRo1QwUjAOBgNVHQ8BAf8E\nBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUSIcUrOPDnpBgOtfKie7T\nrYy0UGYwEAYJKwYBBAGCNxUBBAMCAQAwCgYIKoZIzj0EAwMDaAAwZQIwJsdpW9zV\n57LnyAyMjMPdeYwbY9XJUpROTYJKcx6ygISpJcBMWm1JKWB4E+J+SOtkAjEA2zQg\nMgj/mkkCtojeFK9dbJlxjRo/i9fgojaGHAeCOnZT/cKi7e97sIBPWA9LUzm9\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            21:2a:56:0c:ae:da:0c:ab:40:45:bf:2b:a2:2d:3a:ea\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=CH, O=WISeKey, OU=OISTE Foundation Endorsed, CN=OISTE WISeKey Global Root GC CA\n        Validity\n            Not Before: May  9 09:48:34 2017 GMT\n            Not After : May  9 09:58:33 2042 GMT\n        Subject: C=CH, O=WISeKey, OU=OISTE Foundation Endorsed, CN=OISTE WISeKey Global Root GC CA\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:4c:e9:50:c0:c6:0f:72:18:bc:d8:f1:ba:b3:89:\n                    e2:79:4a:a3:16:a7:6b:54:24:db:51:ff:ea:f4:09:\n                    24:c3:0b:22:9f:cb:6a:27:82:81:0d:d2:c0:af:31:\n                    e4:74:82:6e:ca:25:d9:8c:75:9d:f1:db:d0:9a:a2:\n                    4b:21:7e:16:a7:63:90:d2:39:d4:b1:87:78:5f:18:\n                    96:0f:50:1b:35:37:0f:6a:c6:dc:d9:13:4d:a4:8e:\n                    90:37:e6:bd:5b:31:91\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                48:87:14:AC:E3:C3:9E:90:60:3A:D7:CA:89:EE:D3:AD:8C:B4:50:66\n            1.3.6.1.4.1.311.21.1: \n                ...\n    Signature Algorithm: ecdsa-with-SHA384\n         30:65:02:30:26:c7:69:5b:dc:d5:e7:b2:e7:c8:0c:8c:8c:c3:\n         dd:79:8c:1b:63:d5:c9:52:94:4e:4d:82:4a:73:1e:b2:80:84:\n         a9:25:c0:4c:5a:6d:49:29:60:78:13:e2:7e:48:eb:64:02:31:\n         00:db:34:20:32:08:ff:9a:49:02:b6:88:de:14:af:5d:6c:99:\n         71:8d:1a:3f:8b:d7:e0:a2:36:86:1c:07:82:3a:76:53:fd:c2:\n         a2:ed:ef:7b:b0:80:4f:58:0f:4b:53:39:bd\nSHA1 Fingerprint=E0:11:84:5E:34:DE:BE:88:81:B9:9C:F6:16:26:D1:96:1F:C3:B9:31\n",
    "4aa0aa5884d35e3c": "-----BEGIN CERTIFICATE-----\nMIIDIDCCAgigAwIBAgIBHTANBgkqhkiG9w0BAQUFADA5MQswCQYDVQQGEwJGSTEP\nMA0GA1UEChMGU29uZXJhMRkwFwYDVQQDExBTb25lcmEgQ2xhc3MyIENBMB4XDTAx\nMDQwNjA3Mjk0MFoXDTIxMDQwNjA3Mjk0MFowOTELMAkGA1UEBhMCRkkxDzANBgNV\nBAoTBlNvbmVyYTEZMBcGA1UEAxMQU29uZXJhIENsYXNzMiBDQTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAJAXSjWdyvANlsdE+hY3/Ei9vX+ALTU74W+o\nZ6m/AxxNjG8yR9VBaKQTBME1DJqEQ/xcHf+Js+gXGM2RX/uJ4+q/Tl18GybTdXnt\n5oTjV+WtKcT0OijnpXuENmmz/V52vaMtmdOQTiMofRhj8VQ7Jp12W5dCsv+u8E7s\n3TmVToMGf+dJQMjFAbJUWmYdPfz56TwKnoG4cPABi+QjVHzIrviQHgCWctRUz2Ej\nvOr7nQKV0ba5cTppCD8PtOFCx4j1P5iop7oc4HFx71hXgVB6XGt0Rg6DA5jDjqhu\n8nYybieDwnPz3BjotJPqdURrBGAgcVeHnfO+oJAjPYok4doh28MCAwEAAaMzMDEw\nDwYDVR0TAQH/BAUwAwEB/zARBgNVHQ4ECgQISqCqWITTXjwwCwYDVR0PBAQDAgEG\nMA0GCSqGSIb3DQEBBQUAA4IBAQBazof5FnIVV0sd2ZvnoiYw7JNn39Yt0jSv9zil\nzqsWuasvfDXLrNAPtEwr/IDva4yRXzZ299uzGxnq9LIR/WFxRL8oszodv7ND6J+/\n3DEIcbCdjdY0RzKQxmUk96BKfARzjzlvF4xytb1LyHr4e4PDKE6cCepnP7JnBBvD\nFNr450kkkdAdavphOe9r5yF1BgfYErQhIHBCcYHaPJo2vqZbDWpsmh+Re/n570K6\nTk6ezAyNlNzZRZxe7EJQY670XcSxEtzKO6gunRRaBXW37Ndj4ro1tgQIkejanZz2\nZrUYrAqmVCY0M9IbwdR/GjqOC6oybtv8TyWf2TLHllpwrN9M\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 29 (0x1d)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=FI, O=Sonera, CN=Sonera Class2 CA\n        Validity\n            Not Before: Apr  6 07:29:40 2001 GMT\n            Not After : Apr  6 07:29:40 2021 GMT\n        Subject: C=FI, O=Sonera, CN=Sonera Class2 CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:90:17:4a:35:9d:ca:f0:0d:96:c7:44:fa:16:37:\n                    fc:48:bd:bd:7f:80:2d:35:3b:e1:6f:a8:67:a9:bf:\n                    03:1c:4d:8c:6f:32:47:d5:41:68:a4:13:04:c1:35:\n                    0c:9a:84:43:fc:5c:1d:ff:89:b3:e8:17:18:cd:91:\n                    5f:fb:89:e3:ea:bf:4e:5d:7c:1b:26:d3:75:79:ed:\n                    e6:84:e3:57:e5:ad:29:c4:f4:3a:28:e7:a5:7b:84:\n                    36:69:b3:fd:5e:76:bd:a3:2d:99:d3:90:4e:23:28:\n                    7d:18:63:f1:54:3b:26:9d:76:5b:97:42:b2:ff:ae:\n                    f0:4e:ec:dd:39:95:4e:83:06:7f:e7:49:40:c8:c5:\n                    01:b2:54:5a:66:1d:3d:fc:f9:e9:3c:0a:9e:81:b8:\n                    70:f0:01:8b:e4:23:54:7c:c8:ae:f8:90:1e:00:96:\n                    72:d4:54:cf:61:23:bc:ea:fb:9d:02:95:d1:b6:b9:\n                    71:3a:69:08:3f:0f:b4:e1:42:c7:88:f5:3f:98:a8:\n                    a7:ba:1c:e0:71:71:ef:58:57:81:50:7a:5c:6b:74:\n                    46:0e:83:03:98:c3:8e:a8:6e:f2:76:32:6e:27:83:\n                    c2:73:f3:dc:18:e8:b4:93:ea:75:44:6b:04:60:20:\n                    71:57:87:9d:f3:be:a0:90:23:3d:8a:24:e1:da:21:\n                    db:c3\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                4A:A0:AA:58:84:D3:5E:3C\n            X509v3 Key Usage: \n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha1WithRSAEncryption\n         5a:ce:87:f9:16:72:15:57:4b:1d:d9:9b:e7:a2:26:30:ec:93:\n         67:df:d6:2d:d2:34:af:f7:38:a5:ce:ab:16:b9:ab:2f:7c:35:\n         cb:ac:d0:0f:b4:4c:2b:fc:80:ef:6b:8c:91:5f:36:76:f7:db:\n         b3:1b:19:ea:f4:b2:11:fd:61:71:44:bf:28:b3:3a:1d:bf:b3:\n         43:e8:9f:bf:dc:31:08:71:b0:9d:8d:d6:34:47:32:90:c6:65:\n         24:f7:a0:4a:7c:04:73:8f:39:6f:17:8c:72:b5:bd:4b:c8:7a:\n         f8:7b:83:c3:28:4e:9c:09:ea:67:3f:b2:67:04:1b:c3:14:da:\n         f8:e7:49:24:91:d0:1d:6a:fa:61:39:ef:6b:e7:21:75:06:07:\n         d8:12:b4:21:20:70:42:71:81:da:3c:9a:36:be:a6:5b:0d:6a:\n         6c:9a:1f:91:7b:f9:f9:ef:42:ba:4e:4e:9e:cc:0c:8d:94:dc:\n         d9:45:9c:5e:ec:42:50:63:ae:f4:5d:c4:b1:12:dc:ca:3b:a8:\n         2e:9d:14:5a:05:75:b7:ec:d7:63:e2:ba:35:b6:04:08:91:e8:\n         da:9d:9c:f6:66:b5:18:ac:0a:a6:54:26:34:33:d2:1b:c1:d4:\n         7f:1a:3a:8e:0b:aa:32:6e:db:fc:4f:25:9f:d9:32:c7:96:5a:\n         70:ac:df:4c\nSHA1 Fingerprint=37:F7:6D:E6:07:7C:90:C5:B1:3E:93:1A:B7:41:10:B4:F2:E4:9A:27\n",
    "4e2254201895e6e36ee60ffafab912ed06178f39": "-----BEGIN CERTIFICATE-----\nMIIDjjCCAnagAwIBAgIQAzrx5qcRqaC7KGSxHQn65TANBgkqhkiG9w0BAQsFADBh\nMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3\nd3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBH\nMjAeFw0xMzA4MDExMjAwMDBaFw0zODAxMTUxMjAwMDBaMGExCzAJBgNVBAYTAlVT\nMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j\nb20xIDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IEcyMIIBIjANBgkqhkiG\n9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuzfNNNx7a8myaJCtSnX/RrohCgiN9RlUyfuI\n2/Ou8jqJkTx65qsGGmvPrC3oXgkkRLpimn7Wo6h+4FR1IAWsULecYxpsMNzaHxmx\n1x7e/dfgy5SDN67sH0NO3Xss0r0upS/kqbitOtSZpLYl6ZtrAGCSYP9PIUkY92eQ\nq2EGnI/yuum06ZIya7XzV+hdG82MHauVBJVJ8zUtluNJbd134/tJS7SsVQepj5Wz\ntCO7TG1F8PapspUwtP1MVYwnSlcUfIKdzXOS0xZKBgyMUNGPHgm+F6HmIcr9g+UQ\nvIOlCsRnKPZzFBQ9RnbDhxSJITRNrw9FDKZJobq7nMWxM4MphQIDAQABo0IwQDAP\nBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjAdBgNVHQ4EFgQUTiJUIBiV\n5uNu5g/6+rkS7QYXjzkwDQYJKoZIhvcNAQELBQADggEBAGBnKJRvDkhj6zHd6mcY\n1Yl9PMWLSn/pvtsrF9+wX3N3KjITOYFnQoQj8kVnNeyIv/iPsGEMNKSuIEyExtv4\nNeF22d+mQrvHRAiGfzZ0JFrabA0UWTW98kndth/Jsw1HKj2ZL7tcu7XUIOGZX1NG\nFdtom/DzMNU+MeKNhJ7jitralj41E6Vf8PlwUHBHQRFXGU7Aj64GxJUTFy8bJZ91\n8rGOmaFvE7FBcf6IKshPECBV1/MUReXgRPTqh5Uykw7+U0b6LJ3/iyK5S9kJRaTe\npLiaWN0bfVKfjllDiIGknibVb63dDcY3fe0Dkhvld1927jyNxF1WW6LZZm6zNTfl\nMrY=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            03:3a:f1:e6:a7:11:a9:a0:bb:28:64:b1:1d:09:fa:e5\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root G2\n        Validity\n            Not Before: Aug  1 12:00:00 2013 GMT\n            Not After : Jan 15 12:00:00 2038 GMT\n        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root G2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:bb:37:cd:34:dc:7b:6b:c9:b2:68:90:ad:4a:75:\n                    ff:46:ba:21:0a:08:8d:f5:19:54:c9:fb:88:db:f3:\n                    ae:f2:3a:89:91:3c:7a:e6:ab:06:1a:6b:cf:ac:2d:\n                    e8:5e:09:24:44:ba:62:9a:7e:d6:a3:a8:7e:e0:54:\n                    75:20:05:ac:50:b7:9c:63:1a:6c:30:dc:da:1f:19:\n                    b1:d7:1e:de:fd:d7:e0:cb:94:83:37:ae:ec:1f:43:\n                    4e:dd:7b:2c:d2:bd:2e:a5:2f:e4:a9:b8:ad:3a:d4:\n                    99:a4:b6:25:e9:9b:6b:00:60:92:60:ff:4f:21:49:\n                    18:f7:67:90:ab:61:06:9c:8f:f2:ba:e9:b4:e9:92:\n                    32:6b:b5:f3:57:e8:5d:1b:cd:8c:1d:ab:95:04:95:\n                    49:f3:35:2d:96:e3:49:6d:dd:77:e3:fb:49:4b:b4:\n                    ac:55:07:a9:8f:95:b3:b4:23:bb:4c:6d:45:f0:f6:\n                    a9:b2:95:30:b4:fd:4c:55:8c:27:4a:57:14:7c:82:\n                    9d:cd:73:92:d3:16:4a:06:0c:8c:50:d1:8f:1e:09:\n                    be:17:a1:e6:21:ca:fd:83:e5:10:bc:83:a5:0a:c4:\n                    67:28:f6:73:14:14:3d:46:76:c3:87:14:89:21:34:\n                    4d:af:0f:45:0c:a6:49:a1:ba:bb:9c:c5:b1:33:83:\n                    29:85\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                4E:22:54:20:18:95:E6:E3:6E:E6:0F:FA:FA:B9:12:ED:06:17:8F:39\n    Signature Algorithm: sha256WithRSAEncryption\n         60:67:28:94:6f:0e:48:63:eb:31:dd:ea:67:18:d5:89:7d:3c:\n         c5:8b:4a:7f:e9:be:db:2b:17:df:b0:5f:73:77:2a:32:13:39:\n         81:67:42:84:23:f2:45:67:35:ec:88:bf:f8:8f:b0:61:0c:34:\n         a4:ae:20:4c:84:c6:db:f8:35:e1:76:d9:df:a6:42:bb:c7:44:\n         08:86:7f:36:74:24:5a:da:6c:0d:14:59:35:bd:f2:49:dd:b6:\n         1f:c9:b3:0d:47:2a:3d:99:2f:bb:5c:bb:b5:d4:20:e1:99:5f:\n         53:46:15:db:68:9b:f0:f3:30:d5:3e:31:e2:8d:84:9e:e3:8a:\n         da:da:96:3e:35:13:a5:5f:f0:f9:70:50:70:47:41:11:57:19:\n         4e:c0:8f:ae:06:c4:95:13:17:2f:1b:25:9f:75:f2:b1:8e:99:\n         a1:6f:13:b1:41:71:fe:88:2a:c8:4f:10:20:55:d7:f3:14:45:\n         e5:e0:44:f4:ea:87:95:32:93:0e:fe:53:46:fa:2c:9d:ff:8b:\n         22:b9:4b:d9:09:45:a4:de:a4:b8:9a:58:dd:1b:7d:52:9f:8e:\n         59:43:88:81:a4:9e:26:d5:6f:ad:dd:0d:c6:37:7d:ed:03:92:\n         1b:e5:77:5f:76:ee:3c:8d:c4:5d:56:5b:a2:d9:66:6e:b3:35:\n         37:e5:32:b6\nSHA1 Fingerprint=DF:3C:24:F9:BF:D6:66:76:1B:26:80:73:FE:06:D1:CC:8D:4F:82:A4\n",
    "52d8883ac89f7866ed89f37b387094c9020236d0": "-----BEGIN CERTIFICATE-----\nMIIFuzCCA6OgAwIBAgIIVwoRl0LE48wwDQYJKoZIhvcNAQELBQAwazELMAkGA1UE\nBhMCSVQxDjAMBgNVBAcMBU1pbGFuMSMwIQYDVQQKDBpBY3RhbGlzIFMucC5BLi8w\nMzM1ODUyMDk2NzEnMCUGA1UEAwweQWN0YWxpcyBBdXRoZW50aWNhdGlvbiBSb290\nIENBMB4XDTExMDkyMjExMjIwMloXDTMwMDkyMjExMjIwMlowazELMAkGA1UEBhMC\nSVQxDjAMBgNVBAcMBU1pbGFuMSMwIQYDVQQKDBpBY3RhbGlzIFMucC5BLi8wMzM1\nODUyMDk2NzEnMCUGA1UEAwweQWN0YWxpcyBBdXRoZW50aWNhdGlvbiBSb290IENB\nMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAp8bEpSmkLO/lGMWwUKNv\nUTufClrJwkg4CsIcoBh/kbWHuUA/3R1oHwiD1S0eiKD4j1aPbZkCkpAW1V8IbInX\n4ay8IMKx4INRimlNAJZaby/ARH6jDuSRzVju3PvHHkVH3Se5CAGfpiEd9UEtL0z9\nKK3giq0itFZljoZUj5NDKd45RnijMCO6zfB9E1fAXdKDa0hMxKufgFpbOr3JpyI/\ngCczWw63igxdBzcIy2zSekciRDXFzMwujt0q7bd9Zg1fYVEiVRvjRuPjPdA1Yprb\nrxTIW6HMiRvhMCb8oJsfgadHHwTrozmSBp+Z07/T6k9QnBn+locePGX2oxgkg4YQ\n51Q+qDp2JE+BIcXjDwL4k5RHILv+1A7TaLndxHqEguNTVHnd25zS8gebLra8Pu2F\nbe8lEfKXGkJh90qX6IuxEAf6ZYGyojnP9zz/GPvG8VqLWeICrHuS0E4UT1lF9gxe\nKF+w6D9Fz8+vm2/7hNN3WpVvrJSEnu68wEqPSpP4RCHiMUVhUE4Q2OM1fEwZtN4F\nv6MGn8i1zeQf1xcGDXqVdFUNaBr8EBtiZJ1t4JWgw5QHVw0U5r0F+7if5t+L4sbn\nfpb2U8WANFAoWPASUHEXMLrmeGO89LKtmyuy/uE5jF66CyCU3nuDuP/jVo23Eek7\njPKxwV2dpAtMK9myGPW1n0sCAwEAAaNjMGEwHQYDVR0OBBYEFFLYiDrIn3hm7Ynz\nezhwlMkCAjbQMA8GA1UdEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAUUtiIOsifeGbt\nifN7OHCUyQICNtAwDgYDVR0PAQH/BAQDAgEGMA0GCSqGSIb3DQEBCwUAA4ICAQAL\ne3KHwGCmSUyIWOYdiPcUZEim2FgKDk8TNd81HdTtBjHIgT5q1d07GjLukD0R0i70\njsNjLiNmsGe+b7bAEzlgqqI0JZN1Ut6nna0Oh4lScWoWPBkdg/iaKWW+9D+a2fDz\nWochcYBNy+A4mz+7+uAwTc+G02UQGRjRlwKxK3JCaKygvU5a2hi/a5iB0P2avl4V\nSM0RFbnAKVy06Ij3Pjaut2L9HmLecHgQHEhb2rykOLpn7VU+Xlff1ANATIGk0k9j\npwlCCRT8AKnCgHNPLsBA2RF7SOp6AsDT6ygBJlh0wcBzIm2Tlf05fbsq4/aC4yyX\nX04fkZT6/iyj2HYauE2yOE+b+h1IYHkm4vP9qdCa6HCPSXrW5b0KDtst842/6+Ok\nfcvHlXHo2qN8xcL4dJIEG4aspCJTQLas/kx2z/uUMsA1n3Y/buWQbqCmJqK4LL7R\nK4X9p2jIugErsWx0Hbhzlefut8cl8ABMALJ+tguLHPPAUJ4lueAI3jZm/zel0btU\nZCzJJ7VLkn5l/9Mt4blOvH+kQSGQQXemOR/qnuOf0GZvBeyqdn6/axag67XH/JJU\nLysRJyU3eExRarDzzFhdFPFqSBX/wge2sY0PjlxQRrM9vwGYT7JZVEc+NHt4bVaT\nLnPqZih4zR0Uv6CPLy64Lo7yFIrM6bV8+2ydDKXhlg==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 6271844772424770508 (0x570a119742c4e3cc)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=IT, L=Milan, O=Actalis S.p.A./03358520967, CN=Actalis Authentication Root CA\n        Validity\n            Not Before: Sep 22 11:22:02 2011 GMT\n            Not After : Sep 22 11:22:02 2030 GMT\n        Subject: C=IT, L=Milan, O=Actalis S.p.A./03358520967, CN=Actalis Authentication Root CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:a7:c6:c4:a5:29:a4:2c:ef:e5:18:c5:b0:50:a3:\n                    6f:51:3b:9f:0a:5a:c9:c2:48:38:0a:c2:1c:a0:18:\n                    7f:91:b5:87:b9:40:3f:dd:1d:68:1f:08:83:d5:2d:\n                    1e:88:a0:f8:8f:56:8f:6d:99:02:92:90:16:d5:5f:\n                    08:6c:89:d7:e1:ac:bc:20:c2:b1:e0:83:51:8a:69:\n                    4d:00:96:5a:6f:2f:c0:44:7e:a3:0e:e4:91:cd:58:\n                    ee:dc:fb:c7:1e:45:47:dd:27:b9:08:01:9f:a6:21:\n                    1d:f5:41:2d:2f:4c:fd:28:ad:e0:8a:ad:22:b4:56:\n                    65:8e:86:54:8f:93:43:29:de:39:46:78:a3:30:23:\n                    ba:cd:f0:7d:13:57:c0:5d:d2:83:6b:48:4c:c4:ab:\n                    9f:80:5a:5b:3a:bd:c9:a7:22:3f:80:27:33:5b:0e:\n                    b7:8a:0c:5d:07:37:08:cb:6c:d2:7a:47:22:44:35:\n                    c5:cc:cc:2e:8e:dd:2a:ed:b7:7d:66:0d:5f:61:51:\n                    22:55:1b:e3:46:e3:e3:3d:d0:35:62:9a:db:af:14:\n                    c8:5b:a1:cc:89:1b:e1:30:26:fc:a0:9b:1f:81:a7:\n                    47:1f:04:eb:a3:39:92:06:9f:99:d3:bf:d3:ea:4f:\n                    50:9c:19:fe:96:87:1e:3c:65:f6:a3:18:24:83:86:\n                    10:e7:54:3e:a8:3a:76:24:4f:81:21:c5:e3:0f:02:\n                    f8:93:94:47:20:bb:fe:d4:0e:d3:68:b9:dd:c4:7a:\n                    84:82:e3:53:54:79:dd:db:9c:d2:f2:07:9b:2e:b6:\n                    bc:3e:ed:85:6d:ef:25:11:f2:97:1a:42:61:f7:4a:\n                    97:e8:8b:b1:10:07:fa:65:81:b2:a2:39:cf:f7:3c:\n                    ff:18:fb:c6:f1:5a:8b:59:e2:02:ac:7b:92:d0:4e:\n                    14:4f:59:45:f6:0c:5e:28:5f:b0:e8:3f:45:cf:cf:\n                    af:9b:6f:fb:84:d3:77:5a:95:6f:ac:94:84:9e:ee:\n                    bc:c0:4a:8f:4a:93:f8:44:21:e2:31:45:61:50:4e:\n                    10:d8:e3:35:7c:4c:19:b4:de:05:bf:a3:06:9f:c8:\n                    b5:cd:e4:1f:d7:17:06:0d:7a:95:74:55:0d:68:1a:\n                    fc:10:1b:62:64:9d:6d:e0:95:a0:c3:94:07:57:0d:\n                    14:e6:bd:05:fb:b8:9f:e6:df:8b:e2:c6:e7:7e:96:\n                    f6:53:c5:80:34:50:28:58:f0:12:50:71:17:30:ba:\n                    e6:78:63:bc:f4:b2:ad:9b:2b:b2:fe:e1:39:8c:5e:\n                    ba:0b:20:94:de:7b:83:b8:ff:e3:56:8d:b7:11:e9:\n                    3b:8c:f2:b1:c1:5d:9d:a4:0b:4c:2b:d9:b2:18:f5:\n                    b5:9f:4b\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                52:D8:88:3A:C8:9F:78:66:ED:89:F3:7B:38:70:94:C9:02:02:36:D0\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Authority Key Identifier: \n                keyid:52:D8:88:3A:C8:9F:78:66:ED:89:F3:7B:38:70:94:C9:02:02:36:D0\n\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         0b:7b:72:87:c0:60:a6:49:4c:88:58:e6:1d:88:f7:14:64:48:\n         a6:d8:58:0a:0e:4f:13:35:df:35:1d:d4:ed:06:31:c8:81:3e:\n         6a:d5:dd:3b:1a:32:ee:90:3d:11:d2:2e:f4:8e:c3:63:2e:23:\n         66:b0:67:be:6f:b6:c0:13:39:60:aa:a2:34:25:93:75:52:de:\n         a7:9d:ad:0e:87:89:52:71:6a:16:3c:19:1d:83:f8:9a:29:65:\n         be:f4:3f:9a:d9:f0:f3:5a:87:21:71:80:4d:cb:e0:38:9b:3f:\n         bb:fa:e0:30:4d:cf:86:d3:65:10:19:18:d1:97:02:b1:2b:72:\n         42:68:ac:a0:bd:4e:5a:da:18:bf:6b:98:81:d0:fd:9a:be:5e:\n         15:48:cd:11:15:b9:c0:29:5c:b4:e8:88:f7:3e:36:ae:b7:62:\n         fd:1e:62:de:70:78:10:1c:48:5b:da:bc:a4:38:ba:67:ed:55:\n         3e:5e:57:df:d4:03:40:4c:81:a4:d2:4f:63:a7:09:42:09:14:\n         fc:00:a9:c2:80:73:4f:2e:c0:40:d9:11:7b:48:ea:7a:02:c0:\n         d3:eb:28:01:26:58:74:c1:c0:73:22:6d:93:95:fd:39:7d:bb:\n         2a:e3:f6:82:e3:2c:97:5f:4e:1f:91:94:fa:fe:2c:a3:d8:76:\n         1a:b8:4d:b2:38:4f:9b:fa:1d:48:60:79:26:e2:f3:fd:a9:d0:\n         9a:e8:70:8f:49:7a:d6:e5:bd:0a:0e:db:2d:f3:8d:bf:eb:e3:\n         a4:7d:cb:c7:95:71:e8:da:a3:7c:c5:c2:f8:74:92:04:1b:86:\n         ac:a4:22:53:40:b6:ac:fe:4c:76:cf:fb:94:32:c0:35:9f:76:\n         3f:6e:e5:90:6e:a0:a6:26:a2:b8:2c:be:d1:2b:85:fd:a7:68:\n         c8:ba:01:2b:b1:6c:74:1d:b8:73:95:e7:ee:b7:c7:25:f0:00:\n         4c:00:b2:7e:b6:0b:8b:1c:f3:c0:50:9e:25:b9:e0:08:de:36:\n         66:ff:37:a5:d1:bb:54:64:2c:c9:27:b5:4b:92:7e:65:ff:d3:\n         2d:e1:b9:4e:bc:7f:a4:41:21:90:41:77:a6:39:1f:ea:9e:e3:\n         9f:d0:66:6f:05:ec:aa:76:7e:bf:6b:16:a0:eb:b5:c7:fc:92:\n         54:2f:2b:11:27:25:37:78:4c:51:6a:b0:f3:cc:58:5d:14:f1:\n         6a:48:15:ff:c2:07:b6:b1:8d:0f:8e:5c:50:46:b3:3d:bf:01:\n         98:4f:b2:59:54:47:3e:34:7b:78:6d:56:93:2e:73:ea:66:28:\n         78:cd:1d:14:bf:a0:8f:2f:2e:b8:2e:8e:f2:14:8a:cc:e9:b5:\n         7c:fb:6c:9d:0c:a5:e1:96\nSHA1 Fingerprint=F3:73:B3:87:06:5A:28:84:8A:F2:F3:4A:CE:19:2B:DD:C7:8E:9C:AC\n",
    "5379bf5aaa2b4acf5480e1d89bc09df2b20366cb": "-----BEGIN CERTIFICATE-----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\njjxDah2nGN59PRbxYvnKkKj9\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            01:fd:6d:30:fc:a3:ca:51:a8:1b:bc:64:0e:35:03:2d\n        Signature Algorithm: sha384WithRSAEncryption\n        Issuer: C=US, ST=New Jersey, L=Jersey City, O=The USERTRUST Network, CN=USERTrust RSA Certification Authority\n        Validity\n            Not Before: Feb  1 00:00:00 2010 GMT\n            Not After : Jan 18 23:59:59 2038 GMT\n        Subject: C=US, ST=New Jersey, L=Jersey City, O=The USERTRUST Network, CN=USERTrust RSA Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:80:12:65:17:36:0e:c3:db:08:b3:d0:ac:57:0d:\n                    76:ed:cd:27:d3:4c:ad:50:83:61:e2:aa:20:4d:09:\n                    2d:64:09:dc:ce:89:9f:cc:3d:a9:ec:f6:cf:c1:dc:\n                    f1:d3:b1:d6:7b:37:28:11:2b:47:da:39:c6:bc:3a:\n                    19:b4:5f:a6:bd:7d:9d:a3:63:42:b6:76:f2:a9:3b:\n                    2b:91:f8:e2:6f:d0:ec:16:20:90:09:3e:e2:e8:74:\n                    c9:18:b4:91:d4:62:64:db:7f:a3:06:f1:88:18:6a:\n                    90:22:3c:bc:fe:13:f0:87:14:7b:f6:e4:1f:8e:d4:\n                    e4:51:c6:11:67:46:08:51:cb:86:14:54:3f:bc:33:\n                    fe:7e:6c:9c:ff:16:9d:18:bd:51:8e:35:a6:a7:66:\n                    c8:72:67:db:21:66:b1:d4:9b:78:03:c0:50:3a:e8:\n                    cc:f0:dc:bc:9e:4c:fe:af:05:96:35:1f:57:5a:b7:\n                    ff:ce:f9:3d:b7:2c:b6:f6:54:dd:c8:e7:12:3a:4d:\n                    ae:4c:8a:b7:5c:9a:b4:b7:20:3d:ca:7f:22:34:ae:\n                    7e:3b:68:66:01:44:e7:01:4e:46:53:9b:33:60:f7:\n                    94:be:53:37:90:73:43:f3:32:c3:53:ef:db:aa:fe:\n                    74:4e:69:c7:6b:8c:60:93:de:c4:c7:0c:df:e1:32:\n                    ae:cc:93:3b:51:78:95:67:8b:ee:3d:56:fe:0c:d0:\n                    69:0f:1b:0f:f3:25:26:6b:33:6d:f7:6e:47:fa:73:\n                    43:e5:7e:0e:a5:66:b1:29:7c:32:84:63:55:89:c4:\n                    0d:c1:93:54:30:19:13:ac:d3:7d:37:a7:eb:5d:3a:\n                    6c:35:5c:db:41:d7:12:da:a9:49:0b:df:d8:80:8a:\n                    09:93:62:8e:b5:66:cf:25:88:cd:84:b8:b1:3f:a4:\n                    39:0f:d9:02:9e:eb:12:4c:95:7c:f3:6b:05:a9:5e:\n                    16:83:cc:b8:67:e2:e8:13:9d:cc:5b:82:d3:4c:b3:\n                    ed:5b:ff:de:e5:73:ac:23:3b:2d:00:bf:35:55:74:\n                    09:49:d8:49:58:1a:7f:92:36:e6:51:92:0e:f3:26:\n                    7d:1c:4d:17:bc:c9:ec:43:26:d0:bf:41:5f:40:a9:\n                    44:44:f4:99:e7:57:87:9e:50:1f:57:54:a8:3e:fd:\n                    74:63:2f:b1:50:65:09:e6:58:42:2e:43:1a:4c:b4:\n                    f0:25:47:59:fa:04:1e:93:d4:26:46:4a:50:81:b2:\n                    de:be:78:b7:fc:67:15:e1:c9:57:84:1e:0f:63:d6:\n                    e9:62:ba:d6:5f:55:2e:ea:5c:c6:28:08:04:25:39:\n                    b8:0e:2b:a9:f2:4c:97:1c:07:3f:0d:52:f5:ed:ef:\n                    2f:82:0f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                53:79:BF:5A:AA:2B:4A:CF:54:80:E1:D8:9B:C0:9D:F2:B2:03:66:CB\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: sha384WithRSAEncryption\n         5c:d4:7c:0d:cf:f7:01:7d:41:99:65:0c:73:c5:52:9f:cb:f8:\n         cf:99:06:7f:1b:da:43:15:9f:9e:02:55:57:96:14:f1:52:3c:\n         27:87:94:28:ed:1f:3a:01:37:a2:76:fc:53:50:c0:84:9b:c6:\n         6b:4e:ba:8c:21:4f:a2:8e:55:62:91:f3:69:15:d8:bc:88:e3:\n         c4:aa:0b:fd:ef:a8:e9:4b:55:2a:06:20:6d:55:78:29:19:ee:\n         5f:30:5c:4b:24:11:55:ff:24:9a:6e:5e:2a:2b:ee:0b:4d:9f:\n         7f:f7:01:38:94:14:95:43:07:09:fb:60:a9:ee:1c:ab:12:8c:\n         a0:9a:5e:a7:98:6a:59:6d:8b:3f:08:fb:c8:d1:45:af:18:15:\n         64:90:12:0f:73:28:2e:c5:e2:24:4e:fc:58:ec:f0:f4:45:fe:\n         22:b3:eb:2f:8e:d2:d9:45:61:05:c1:97:6f:a8:76:72:8f:8b:\n         8c:36:af:bf:0d:05:ce:71:8d:e6:a6:6f:1f:6c:a6:71:62:c5:\n         d8:d0:83:72:0c:f1:67:11:89:0c:9c:13:4c:72:34:df:bc:d5:\n         71:df:aa:71:dd:e1:b9:6c:8c:3c:12:5d:65:da:bd:57:12:b6:\n         43:6b:ff:e5:de:4d:66:11:51:cf:99:ae:ec:17:b6:e8:71:91:\n         8c:de:49:fe:dd:35:71:a2:15:27:94:1c:cf:61:e3:26:bb:6f:\n         a3:67:25:21:5d:e6:dd:1d:0b:2e:68:1b:3b:82:af:ec:83:67:\n         85:d4:98:51:74:b1:b9:99:80:89:ff:7f:78:19:5c:79:4a:60:\n         2e:92:40:ae:4c:37:2a:2c:c9:c7:62:c8:0e:5d:f7:36:5b:ca:\n         e0:25:25:01:b4:dd:1a:07:9c:77:00:3f:d0:dc:d5:ec:3d:d4:\n         fa:bb:3f:cc:85:d6:6f:7f:a9:2d:df:b9:02:f7:f5:97:9a:b5:\n         35:da:c3:67:b0:87:4a:a9:28:9e:23:8e:ff:5c:27:6b:e1:b0:\n         4f:f3:07:ee:00:2e:d4:59:87:cb:52:41:95:ea:f4:47:d7:ee:\n         64:41:55:7c:8d:59:02:95:dd:62:9d:c2:b9:ee:5a:28:74:84:\n         a5:9b:b7:90:c7:0c:07:df:f5:89:36:74:32:d6:28:c1:b0:b0:\n         0b:e0:9c:4c:c3:1c:d6:fc:e3:69:b5:47:46:81:2f:a2:82:ab:\n         d3:63:44:70:c4:8d:ff:2d:33:ba:ad:8f:7b:b5:70:88:ae:3e:\n         19:cf:40:28:d8:fc:c8:90:bb:5d:99:22:f5:52:e6:58:c5:1f:\n         88:31:43:ee:88:1d:d7:c6:8e:3c:43:6a:1d:a7:18:de:7d:3d:\n         16:f1:62:f9:ca:90:a8:fd\nSHA1 Fingerprint=2B:8F:1B:57:33:0D:BB:A2:D0:7A:6C:51:F7:0E:E9:0D:DA:B9:AD:8E\n",
    "54adfac79257aeca359c2e12fbe4ba5d20dc9457": "-----BEGIN CERTIFICATE-----\nMIIFdDCCA1ygAwIBAgIEAJiiOTANBgkqhkiG9w0BAQsFADBaMQswCQYDVQQGEwJO\nTDEeMBwGA1UECgwVU3RhYXQgZGVyIE5lZGVybGFuZGVuMSswKQYDVQQDDCJTdGFh\ndCBkZXIgTmVkZXJsYW5kZW4gUm9vdCBDQSAtIEczMB4XDTEzMTExNDExMjg0MloX\nDTI4MTExMzIzMDAwMFowWjELMAkGA1UEBhMCTkwxHjAcBgNVBAoMFVN0YWF0IGRl\nciBOZWRlcmxhbmRlbjErMCkGA1UEAwwiU3RhYXQgZGVyIE5lZGVybGFuZGVuIFJv\nb3QgQ0EgLSBHMzCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAL4yolQP\ncPssXFnrbMSkUeiFKrPMSjTysF/zDsccPVMeiAho2G89rcKezIJnByeHaHE6n3WW\nIkYFsO2tx1ueKt6c/DrGlaf1F2cY5y9JCAxcz+bMNO14+1Cx3Gsy8KL+tjzk7FqX\nxz8ecAgwoNzFs21v0IJyEavSgWhZghe3eJJg+szeP4TrjTgzkApyI/o1zCZxMdFy\nKJLZWyNtZrVtB0LrpjPOktvA9mxjeM3KTj215VKb8b475lRgsGYeCasH/lSJEULR\n9yS6YHgamPfJEf0WwTUaVHXvQ9Plrk7O53vDxk5hUUurmkVLoR9BvUhTFXFkC4az\n5S6+zqQbwSmEorXLCCN2QyIkHxcE1G6cxvx/K2Ya7Irl1s9N9WMJtxU51nus6+N8\n6U78dULI7ViVDAZCopz35HCz33JvWjdAidiFpNfxC95DGdRKWCyMijmev4SH8RY7\nNgzp07TKbBlBUgmhHbBqv4LvcFEhMtwFdozL92TkA1CvjJFnq8Xy7ljY3r735zHP\nbMk7ccHViLVlvMDoFxcHErVc0qsgk7TmgoNwNsXNo42ti+yjwUOH5kPiNL6VizXt\nBznaqB16nzaeErAMZRKQFWDZJkBE41ZgpRDUajz9QdwOWke275dhdU/Z/seyHdTt\nXUmzqWrLZoQT1Vyg3N9udwbRcXXIV2+vD3dbAgMBAAGjQjBAMA8GA1UdEwEB/wQF\nMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBRUrfrHkleuyjWcLhL75Lpd\nINyUVzANBgkqhkiG9w0BAQsFAAOCAgEAMJmdBTLIXg47mAE6iqTnB/d6+Oea31BD\nU5cqPco8R5gu4RV78ZLzYdqQJRZlwJ9UXQ4DO1t3ApyEtg2YXzTdO2PCwyiBwpwp\nLiniyMMB8jPqKqrMCQj3ZWfGzd/TtiunvczRDnBfuCPRy5FOCvTIeuXZYzbB1N/8\nIpf3YF3qKS9Ysr1YvY2WTxB1v0h7PVGHoTx0IsL8B3+A3MSs/mrBcDCw6Y5p4ixp\ngZQJut3+TcCDjJRYwEYgr5wfAvg1VUkvRtTA8KCWAg8zxXHzniN9lLf9OtMJgwYh\n/WA9rjLA0u6NpvDntIJ8CsxwyXmA+P5M9zWEGYox+wrZ13+b8KKaa8MFSu1BYBQw\n0aoRQm7TIwIEC8Zl3d1Sd9qBa7Ko+gE4uZbqKmxnl4mUnrzhVNXkanjvSr0rmj1A\nfsbAddJu+2gw7OyLnflJNZoaLNmzlTnVHpL3prllL+U9bTpITAjc5CgSKL59NVzq\n4BZ+Extq1z7XnvwtdbLBFNUjA9tbbws+eC8N3jONFrdI54OagQ97wUNNVQQXOEpR\n1VmiiXTTn74eS9fGbbeIJG9gkaSChVtWQbzQRKtqE77RLFi3EjNYsjdj3BP1lB0/\nQFH1T/U67cjF68IeHRaVesd+QnGTbksVtzDfqu1XhUisHWrdOWnk4Xl4vs4Fv6EM\n94B7IWcnMFk=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 10003001 (0x98a239)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=NL, O=Staat der Nederlanden, CN=Staat der Nederlanden Root CA - G3\n        Validity\n            Not Before: Nov 14 11:28:42 2013 GMT\n            Not After : Nov 13 23:00:00 2028 GMT\n        Subject: C=NL, O=Staat der Nederlanden, CN=Staat der Nederlanden Root CA - G3\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:be:32:a2:54:0f:70:fb:2c:5c:59:eb:6c:c4:a4:\n                    51:e8:85:2a:b3:cc:4a:34:f2:b0:5f:f3:0e:c7:1c:\n                    3d:53:1e:88:08:68:d8:6f:3d:ad:c2:9e:cc:82:67:\n                    07:27:87:68:71:3a:9f:75:96:22:46:05:b0:ed:ad:\n                    c7:5b:9e:2a:de:9c:fc:3a:c6:95:a7:f5:17:67:18:\n                    e7:2f:49:08:0c:5c:cf:e6:cc:34:ed:78:fb:50:b1:\n                    dc:6b:32:f0:a2:fe:b6:3c:e4:ec:5a:97:c7:3f:1e:\n                    70:08:30:a0:dc:c5:b3:6d:6f:d0:82:72:11:ab:d2:\n                    81:68:59:82:17:b7:78:92:60:fa:cc:de:3f:84:eb:\n                    8d:38:33:90:0a:72:23:fa:35:cc:26:71:31:d1:72:\n                    28:92:d9:5b:23:6d:66:b5:6d:07:42:eb:a6:33:ce:\n                    92:db:c0:f6:6c:63:78:cd:ca:4e:3d:b5:e5:52:9b:\n                    f1:be:3b:e6:54:60:b0:66:1e:09:ab:07:fe:54:89:\n                    11:42:d1:f7:24:ba:60:78:1a:98:f7:c9:11:fd:16:\n                    c1:35:1a:54:75:ef:43:d3:e5:ae:4e:ce:e7:7b:c3:\n                    c6:4e:61:51:4b:ab:9a:45:4b:a1:1f:41:bd:48:53:\n                    15:71:64:0b:86:b3:e5:2e:be:ce:a4:1b:c1:29:84:\n                    a2:b5:cb:08:23:76:43:22:24:1f:17:04:d4:6e:9c:\n                    c6:fc:7f:2b:66:1a:ec:8a:e5:d6:cf:4d:f5:63:09:\n                    b7:15:39:d6:7b:ac:eb:e3:7c:e9:4e:fc:75:42:c8:\n                    ed:58:95:0c:06:42:a2:9c:f7:e4:70:b3:df:72:6f:\n                    5a:37:40:89:d8:85:a4:d7:f1:0b:de:43:19:d4:4a:\n                    58:2c:8c:8a:39:9e:bf:84:87:f1:16:3b:36:0c:e9:\n                    d3:b4:ca:6c:19:41:52:09:a1:1d:b0:6a:bf:82:ef:\n                    70:51:21:32:dc:05:76:8c:cb:f7:64:e4:03:50:af:\n                    8c:91:67:ab:c5:f2:ee:58:d8:de:be:f7:e7:31:cf:\n                    6c:c9:3b:71:c1:d5:88:b5:65:bc:c0:e8:17:17:07:\n                    12:b5:5c:d2:ab:20:93:b4:e6:82:83:70:36:c5:cd:\n                    a3:8d:ad:8b:ec:a3:c1:43:87:e6:43:e2:34:be:95:\n                    8b:35:ed:07:39:da:a8:1d:7a:9f:36:9e:12:b0:0c:\n                    65:12:90:15:60:d9:26:40:44:e3:56:60:a5:10:d4:\n                    6a:3c:fd:41:dc:0e:5a:47:b6:ef:97:61:75:4f:d9:\n                    fe:c7:b2:1d:d4:ed:5d:49:b3:a9:6a:cb:66:84:13:\n                    d5:5c:a0:dc:df:6e:77:06:d1:71:75:c8:57:6f:af:\n                    0f:77:5b\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                54:AD:FA:C7:92:57:AE:CA:35:9C:2E:12:FB:E4:BA:5D:20:DC:94:57\n    Signature Algorithm: sha256WithRSAEncryption\n         30:99:9d:05:32:c8:5e:0e:3b:98:01:3a:8a:a4:e7:07:f7:7a:\n         f8:e7:9a:df:50:43:53:97:2a:3d:ca:3c:47:98:2e:e1:15:7b:\n         f1:92:f3:61:da:90:25:16:65:c0:9f:54:5d:0e:03:3b:5b:77:\n         02:9c:84:b6:0d:98:5f:34:dd:3b:63:c2:c3:28:81:c2:9c:29:\n         2e:29:e2:c8:c3:01:f2:33:ea:2a:aa:cc:09:08:f7:65:67:c6:\n         cd:df:d3:b6:2b:a7:bd:cc:d1:0e:70:5f:b8:23:d1:cb:91:4e:\n         0a:f4:c8:7a:e5:d9:63:36:c1:d4:df:fc:22:97:f7:60:5d:ea:\n         29:2f:58:b2:bd:58:bd:8d:96:4f:10:75:bf:48:7b:3d:51:87:\n         a1:3c:74:22:c2:fc:07:7f:80:dc:c4:ac:fe:6a:c1:70:30:b0:\n         e9:8e:69:e2:2c:69:81:94:09:ba:dd:fe:4d:c0:83:8c:94:58:\n         c0:46:20:af:9c:1f:02:f8:35:55:49:2f:46:d4:c0:f0:a0:96:\n         02:0f:33:c5:71:f3:9e:23:7d:94:b7:fd:3a:d3:09:83:06:21:\n         fd:60:3d:ae:32:c0:d2:ee:8d:a6:f0:e7:b4:82:7c:0a:cc:70:\n         c9:79:80:f8:fe:4c:f7:35:84:19:8a:31:fb:0a:d9:d7:7f:9b:\n         f0:a2:9a:6b:c3:05:4a:ed:41:60:14:30:d1:aa:11:42:6e:d3:\n         23:02:04:0b:c6:65:dd:dd:52:77:da:81:6b:b2:a8:fa:01:38:\n         b9:96:ea:2a:6c:67:97:89:94:9e:bc:e1:54:d5:e4:6a:78:ef:\n         4a:bd:2b:9a:3d:40:7e:c6:c0:75:d2:6e:fb:68:30:ec:ec:8b:\n         9d:f9:49:35:9a:1a:2c:d9:b3:95:39:d5:1e:92:f7:a6:b9:65:\n         2f:e5:3d:6d:3a:48:4c:08:dc:e4:28:12:28:be:7d:35:5c:ea:\n         e0:16:7e:13:1b:6a:d7:3e:d7:9e:fc:2d:75:b2:c1:14:d5:23:\n         03:db:5b:6f:0b:3e:78:2f:0d:de:33:8d:16:b7:48:e7:83:9a:\n         81:0f:7b:c1:43:4d:55:04:17:38:4a:51:d5:59:a2:89:74:d3:\n         9f:be:1e:4b:d7:c6:6d:b7:88:24:6f:60:91:a4:82:85:5b:56:\n         41:bc:d0:44:ab:6a:13:be:d1:2c:58:b7:12:33:58:b2:37:63:\n         dc:13:f5:94:1d:3f:40:51:f5:4f:f5:3a:ed:c8:c5:eb:c2:1e:\n         1d:16:95:7a:c7:7e:42:71:93:6e:4b:15:b7:30:df:aa:ed:57:\n         85:48:ac:1d:6a:dd:39:69:e4:e1:79:78:be:ce:05:bf:a1:0c:\n         f7:80:7b:21:67:27:30:59\nSHA1 Fingerprint=D8:EB:6B:41:51:92:59:E0:F3:E7:85:00:C0:3D:B6:88:97:C9:EE:FC\n",
    "54b07bad45b8e2407ffb0a6efbbe33c93ca384d5": "-----BEGIN CERTIFICATE-----\nMIIB4TCCAYegAwIBAgIRKjikHJYKBN5CsiilC+g0mAIwCgYIKoZIzj0EAwIwUDEk\nMCIGA1UECxMbR2xvYmFsU2lnbiBFQ0MgUm9vdCBDQSAtIFI0MRMwEQYDVQQKEwpH\nbG9iYWxTaWduMRMwEQYDVQQDEwpHbG9iYWxTaWduMB4XDTEyMTExMzAwMDAwMFoX\nDTM4MDExOTAzMTQwN1owUDEkMCIGA1UECxMbR2xvYmFsU2lnbiBFQ0MgUm9vdCBD\nQSAtIFI0MRMwEQYDVQQKEwpHbG9iYWxTaWduMRMwEQYDVQQDEwpHbG9iYWxTaWdu\nMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEuMZ5049sJQ6fLjkZHAOkrprlOQcJ\nFspjsbmG+IpXwVfOQvpzofdlQv8ewQCybnMO/8ch5RikqtlxP6jUuc6MHaNCMEAw\nDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFFSwe61F\nuOJAf/sKbvu+M8k8o4TVMAoGCCqGSM49BAMCA0gAMEUCIQDckqGgE6bPA7DmxCGX\nkPoUVy0D7O48027KqGx2vKLeuwIgJ6iFJzWbVsaj8kfSt24bAgAXqmemFZHe+pTs\newv4n4Q=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            2a:38:a4:1c:96:0a:04:de:42:b2:28:a5:0b:e8:34:98:02\n        Signature Algorithm: ecdsa-with-SHA256\n        Issuer: OU=GlobalSign ECC Root CA - R4, O=GlobalSign, CN=GlobalSign\n        Validity\n            Not Before: Nov 13 00:00:00 2012 GMT\n            Not After : Jan 19 03:14:07 2038 GMT\n        Subject: OU=GlobalSign ECC Root CA - R4, O=GlobalSign, CN=GlobalSign\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (256 bit)\n                pub:\n                    04:b8:c6:79:d3:8f:6c:25:0e:9f:2e:39:19:1c:03:\n                    a4:ae:9a:e5:39:07:09:16:ca:63:b1:b9:86:f8:8a:\n                    57:c1:57:ce:42:fa:73:a1:f7:65:42:ff:1e:c1:00:\n                    b2:6e:73:0e:ff:c7:21:e5:18:a4:aa:d9:71:3f:a8:\n                    d4:b9:ce:8c:1d\n                ASN1 OID: prime256v1\n                NIST CURVE: P-256\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                54:B0:7B:AD:45:B8:E2:40:7F:FB:0A:6E:FB:BE:33:C9:3C:A3:84:D5\n    Signature Algorithm: ecdsa-with-SHA256\n         30:45:02:21:00:dc:92:a1:a0:13:a6:cf:03:b0:e6:c4:21:97:\n         90:fa:14:57:2d:03:ec:ee:3c:d3:6e:ca:a8:6c:76:bc:a2:de:\n         bb:02:20:27:a8:85:27:35:9b:56:c6:a3:f2:47:d2:b7:6e:1b:\n         02:00:17:aa:67:a6:15:91:de:fa:94:ec:7b:0b:f8:9f:84\nSHA1 Fingerprint=69:69:56:2E:40:80:F4:24:A1:E7:19:9F:14:BA:F3:EE:58:AB:6A:BB\n",
    "55a98489d2c132bd18cb6ca6074ec8e79dbe8290": "-----BEGIN CERTIFICATE-----\nMIICnTCCAiSgAwIBAgIMCL2Fl2yZJ6SAaEc7MAoGCCqGSM49BAMDMIGRMQswCQYD\nVQQGEwJVUzERMA8GA1UECBMISWxsaW5vaXMxEDAOBgNVBAcTB0NoaWNhZ28xITAf\nBgNVBAoTGFRydXN0d2F2ZSBIb2xkaW5ncywgSW5jLjE6MDgGA1UEAxMxVHJ1c3R3\nYXZlIEdsb2JhbCBFQ0MgUDM4NCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0x\nNzA4MjMxOTM2NDNaFw00MjA4MjMxOTM2NDNaMIGRMQswCQYDVQQGEwJVUzERMA8G\nA1UECBMISWxsaW5vaXMxEDAOBgNVBAcTB0NoaWNhZ28xITAfBgNVBAoTGFRydXN0\nd2F2ZSBIb2xkaW5ncywgSW5jLjE6MDgGA1UEAxMxVHJ1c3R3YXZlIEdsb2JhbCBF\nQ0MgUDM4NCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTB2MBAGByqGSM49AgEGBSuB\nBAAiA2IABGvaDXU1CDFHBa5FmVXxERMuSvgQMSOjfoPTfygIOiYaOs+Xgh+AtycJ\nj9GOMMQKmw6sWASr9zZ9lCOkmwqKi6vr/TklZvFe/oyujUF5nQlgziip04pt89ZF\n1PKYhDhloKNDMEEwDwYDVR0TAQH/BAUwAwEB/zAPBgNVHQ8BAf8EBQMDBwYAMB0G\nA1UdDgQWBBRVqYSJ0sEyvRjLbKYHTsjnnb6CkDAKBggqhkjOPQQDAwNnADBkAjA3\nAZKXRRJ+oPM+rRk6ct30UJMDEr5E0k9BpIycnR+j9sKS50gU/k6bpZFXrsY3crsC\nMGclCrEMXu6pY5Jv5ZAL/mYiykf9ijH3g/56vxC+GCsej/YpHpRZ744hN8tRmKVu\nSw==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            08:bd:85:97:6c:99:27:a4:80:68:47:3b\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global ECC P384 Certification Authority\n        Validity\n            Not Before: Aug 23 19:36:43 2017 GMT\n            Not After : Aug 23 19:36:43 2042 GMT\n        Subject: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global ECC P384 Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:6b:da:0d:75:35:08:31:47:05:ae:45:99:55:f1:\n                    11:13:2e:4a:f8:10:31:23:a3:7e:83:d3:7f:28:08:\n                    3a:26:1a:3a:cf:97:82:1f:80:b7:27:09:8f:d1:8e:\n                    30:c4:0a:9b:0e:ac:58:04:ab:f7:36:7d:94:23:a4:\n                    9b:0a:8a:8b:ab:eb:fd:39:25:66:f1:5e:fe:8c:ae:\n                    8d:41:79:9d:09:60:ce:28:a9:d3:8a:6d:f3:d6:45:\n                    d4:f2:98:84:38:65:a0\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                55:A9:84:89:D2:C1:32:BD:18:CB:6C:A6:07:4E:C8:E7:9D:BE:82:90\n    Signature Algorithm: ecdsa-with-SHA384\n         30:64:02:30:37:01:92:97:45:12:7e:a0:f3:3e:ad:19:3a:72:\n         dd:f4:50:93:03:12:be:44:d2:4f:41:a4:8c:9c:9d:1f:a3:f6:\n         c2:92:e7:48:14:fe:4e:9b:a5:91:57:ae:c6:37:72:bb:02:30:\n         67:25:0a:b1:0c:5e:ee:a9:63:92:6f:e5:90:0b:fe:66:22:ca:\n         47:fd:8a:31:f7:83:fe:7a:bf:10:be:18:2b:1e:8f:f6:29:1e:\n         94:59:ef:8e:21:37:cb:51:98:a5:6e:4b\nSHA1 Fingerprint=E7:F3:A3:C8:CF:6F:C3:04:2E:6D:0E:67:32:C5:9E:68:95:0D:5E:D2\n",
    "55e481d11180bed889b908a331f9a1240916b970": "-----BEGIN CERTIFICATE-----\nMIIEKjCCAxKgAwIBAgIEOGPe+DANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChML\nRW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBp\nbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5\nIEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRp\nZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0yOTA3\nMjQxNDE1MTJaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3\nLmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxp\nYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEG\nA1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgp\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQq\nK0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQe\nsYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuX\nMlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVT\nXTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/\nHoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH\n4QIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNV\nHQ4EFgQUVeSB0RGAvtiJuQijMfmhJAkWuXAwDQYJKoZIhvcNAQEFBQADggEBADub\nj1abMOdTmXx6eadNl9cZlZD7Bh/KM3xGY4+WZiT6QBshJ8rmcnPyT/4xmf3IDExo\nU8aAghOY+rat2l098c5u9hURlIIM7j+VrxGrD9cv3h8Dj1csHsm7mhpElesYT6Yf\nzX1XEC+bBAlahLVu2B064dae0Wx5XnkcFMXj0EyTO2U87d89vqbllRrDtRnDvV5b\nu/8j72gZyxKTJ1wDLW8w0B62GqzeWvfRqqgnpv55gcR5mTNXuhKwqeBCbJPKVt7+\nbYQLCIt+jerXmCHG8+c8eS9enNFMFY3h7CI3zJpDC5fcgJCNs2ebb0gIFVbPv/Er\nfF6adulZkMV8gzURZVE=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 946069240 (0x3863def8)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: O=Entrust.net, OU=www.entrust.net/CPS_2048 incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Certification Authority (2048)\n        Validity\n            Not Before: Dec 24 17:50:51 1999 GMT\n            Not After : Jul 24 14:15:12 2029 GMT\n        Subject: O=Entrust.net, OU=www.entrust.net/CPS_2048 incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Certification Authority (2048)\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:ad:4d:4b:a9:12:86:b2:ea:a3:20:07:15:16:64:\n                    2a:2b:4b:d1:bf:0b:4a:4d:8e:ed:80:76:a5:67:b7:\n                    78:40:c0:73:42:c8:68:c0:db:53:2b:dd:5e:b8:76:\n                    98:35:93:8b:1a:9d:7c:13:3a:0e:1f:5b:b7:1e:cf:\n                    e5:24:14:1e:b1:81:a9:8d:7d:b8:cc:6b:4b:03:f1:\n                    02:0c:dc:ab:a5:40:24:00:7f:74:94:a1:9d:08:29:\n                    b3:88:0b:f5:87:77:9d:55:cd:e4:c3:7e:d7:6a:64:\n                    ab:85:14:86:95:5b:97:32:50:6f:3d:c8:ba:66:0c:\n                    e3:fc:bd:b8:49:c1:76:89:49:19:fd:c0:a8:bd:89:\n                    a3:67:2f:c6:9f:bc:71:19:60:b8:2d:e9:2c:c9:90:\n                    76:66:7b:94:e2:af:78:d6:65:53:5d:3c:d6:9c:b2:\n                    cf:29:03:f9:2f:a4:50:b2:d4:48:ce:05:32:55:8a:\n                    fd:b2:64:4c:0e:e4:98:07:75:db:7f:df:b9:08:55:\n                    60:85:30:29:f9:7b:48:a4:69:86:e3:35:3f:1e:86:\n                    5d:7a:7a:15:bd:ef:00:8e:15:22:54:17:00:90:26:\n                    93:bc:0e:49:68:91:bf:f8:47:d3:9d:95:42:c1:0e:\n                    4d:df:6f:26:cf:c3:18:21:62:66:43:70:d6:d5:c0:\n                    07:e1\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                55:E4:81:D1:11:80:BE:D8:89:B9:08:A3:31:F9:A1:24:09:16:B9:70\n    Signature Algorithm: sha1WithRSAEncryption\n         3b:9b:8f:56:9b:30:e7:53:99:7c:7a:79:a7:4d:97:d7:19:95:\n         90:fb:06:1f:ca:33:7c:46:63:8f:96:66:24:fa:40:1b:21:27:\n         ca:e6:72:73:f2:4f:fe:31:99:fd:c8:0c:4c:68:53:c6:80:82:\n         13:98:fa:b6:ad:da:5d:3d:f1:ce:6e:f6:15:11:94:82:0c:ee:\n         3f:95:af:11:ab:0f:d7:2f:de:1f:03:8f:57:2c:1e:c9:bb:9a:\n         1a:44:95:eb:18:4f:a6:1f:cd:7d:57:10:2f:9b:04:09:5a:84:\n         b5:6e:d8:1d:3a:e1:d6:9e:d1:6c:79:5e:79:1c:14:c5:e3:d0:\n         4c:93:3b:65:3c:ed:df:3d:be:a6:e5:95:1a:c3:b5:19:c3:bd:\n         5e:5b:bb:ff:23:ef:68:19:cb:12:93:27:5c:03:2d:6f:30:d0:\n         1e:b6:1a:ac:de:5a:f7:d1:aa:a8:27:a6:fe:79:81:c4:79:99:\n         33:57:ba:12:b0:a9:e0:42:6c:93:ca:56:de:fe:6d:84:0b:08:\n         8b:7e:8d:ea:d7:98:21:c6:f3:e7:3c:79:2f:5e:9c:d1:4c:15:\n         8d:e1:ec:22:37:cc:9a:43:0b:97:dc:80:90:8d:b3:67:9b:6f:\n         48:08:15:56:cf:bf:f1:2b:7c:5e:9a:76:e9:59:90:c5:7c:83:\n         35:11:65:51\nSHA1 Fingerprint=50:30:06:09:1D:97:D4:F5:AE:39:F7:CB:E7:92:7D:7D:65:2D:34:31\n",
    "5b257b96a465517eb839f3c078665ee83ae7f0ee": "-----BEGIN CERTIFICATE-----\nMIIFujCCA6KgAwIBAgIJALtAHEP1Xk+wMA0GCSqGSIb3DQEBBQUAMEUxCzAJBgNV\nBAYTAkNIMRUwEwYDVQQKEwxTd2lzc1NpZ24gQUcxHzAdBgNVBAMTFlN3aXNzU2ln\nbiBHb2xkIENBIC0gRzIwHhcNMDYxMDI1MDgzMDM1WhcNMzYxMDI1MDgzMDM1WjBF\nMQswCQYDVQQGEwJDSDEVMBMGA1UEChMMU3dpc3NTaWduIEFHMR8wHQYDVQQDExZT\nd2lzc1NpZ24gR29sZCBDQSAtIEcyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIIC\nCgKCAgEAr+TufoskDhJuqVAtFkQ7kpJcyrhdhJJCEyq8ZVeCQD5XJM1QiyUqt2/8\n76LQwB8CJEoTlo8jE+YoWACjR8cGp4QjK7u9lit/VcyLwVcfDmJlD909Vopz2q5+\nbbqBHH5CjCA12UNNhPqE21Is8w4ndwtrvxEvcnifLtg+5hg3Wipy+dpikJKVyh+c\n6bM8K8vzARO/Ws/BtQpgvd21mWRTuKCWs2/iJneRjOBiEAKfNA+k1ZIzUd6+jbqE\nemA8atufK+ze3gE/bk3lUIbLtK/tREDFylqM2tIrfKjuvqblCqoOpd8FUrdVxyJd\nMmqXl2MT28nbeTZ7hTpKxVKJ+STnnXepgv9VHKVxaSvRAiTysybUa9oEVeXBCsdt\nMDeQKuSeFDNeFhdVxVu1yzSJkvGdJo+hB9TGsnhQ2wwMC3wLjEHXuendjIj3o02y\nMszYF9rNt85mndT9Xv+9lz4pded+p2JYryU0pUHHPbwNUMoDAw8IWh+Vc3hiv69y\nFGkOpeUDDniOJihC8AcLYiAQZzlG+qkDzAQ4embvIIO1jEpWjpEA/I5cgt6IoMPi\naG59je883WX0XaxR7ySArqpWl2/5rX3aYT+YdzylkbYcjCbaZaIJbcHiVOO5ykxM\ngI93e2CaHt+28kgeDrpOVG2Y4OGiGqJ3UM/EY5LsRxmd6+ZrzsECAwEAAaOBrDCB\nqTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUWyV7\nlqRlUX64OfPAeGZe6Drn8O4wHwYDVR0jBBgwFoAUWyV7lqRlUX64OfPAeGZe6Drn\n8O4wRgYDVR0gBD8wPTA7BglghXQBWQECAQEwLjAsBggrBgEFBQcCARYgaHR0cDov\nL3JlcG9zaXRvcnkuc3dpc3NzaWduLmNvbS8wDQYJKoZIhvcNAQEFBQADggIBACe6\n45R88a7A3hfm5djV9VSwg/S7zV4Fe0+fdWavPOhWfvxyeDgD2StiGwC5+OlgzczO\nUYrHUDFu4Up+GC9pWbY9ZIEr44OE5iKHjn3g7gKZYbge9LgriBIWhMIxkziWMaa5\nO1M/wySTVltpkuzFwbs4AOPsF6m43Md8AYOfMke6UiI0HTJ6CVanfCU2qT1L2sCC\nbwq7EsiHSycR+R4tx5M/nttfJmtS2S6K8RTGRI0Vqbe/vd6mGu6uLftIdxf+u+yv\nGPUqUfA5hJeVbG4bwyvEdGB5JbAKJ9/fXtI5z0V9QkvfsywexcZdylU6oJxpmo/a\n77KwPJ+HbBIrZXAVUjEaJM9vMSNQH4xPjyPDdEFjHFWoFN0+4FFQz/EbMFYOkrCC\nhdiDyyJkvC24JdVUorgG6q2SpCSgwYa1ShNqR88uC1aVVMvOmttqtKay20EIhid3\n92qgQmwLOM7XdVAyksLfKzAiSNDVQTglXaTpXZ/GlHXQRf0wl0OPkKsKx4ZzYEpp\nLd6leNcG2mqeSz53OiATIgHQv2ieY2BrNU0LbbqhPcCT4H8js1WtciVORvnSFu+w\nZMEBnunKoGqYDs/YYPIvSbjkQuE4NRb0yG5P94FW6LqjviOvrv1vA+ACOzB2+htt\nQc8Bsem4yWb02ybzOqR08kkkW8mw0FfB+j564ZfJ\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            bb:40:1c:43:f5:5e:4f:b0\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=CH, O=SwissSign AG, CN=SwissSign Gold CA - G2\n        Validity\n            Not Before: Oct 25 08:30:35 2006 GMT\n            Not After : Oct 25 08:30:35 2036 GMT\n        Subject: C=CH, O=SwissSign AG, CN=SwissSign Gold CA - G2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:af:e4:ee:7e:8b:24:0e:12:6e:a9:50:2d:16:44:\n                    3b:92:92:5c:ca:b8:5d:84:92:42:13:2a:bc:65:57:\n                    82:40:3e:57:24:cd:50:8b:25:2a:b7:6f:fc:ef:a2:\n                    d0:c0:1f:02:24:4a:13:96:8f:23:13:e6:28:58:00:\n                    a3:47:c7:06:a7:84:23:2b:bb:bd:96:2b:7f:55:cc:\n                    8b:c1:57:1f:0e:62:65:0f:dd:3d:56:8a:73:da:ae:\n                    7e:6d:ba:81:1c:7e:42:8c:20:35:d9:43:4d:84:fa:\n                    84:db:52:2c:f3:0e:27:77:0b:6b:bf:11:2f:72:78:\n                    9f:2e:d8:3e:e6:18:37:5a:2a:72:f9:da:62:90:92:\n                    95:ca:1f:9c:e9:b3:3c:2b:cb:f3:01:13:bf:5a:cf:\n                    c1:b5:0a:60:bd:dd:b5:99:64:53:b8:a0:96:b3:6f:\n                    e2:26:77:91:8c:e0:62:10:02:9f:34:0f:a4:d5:92:\n                    33:51:de:be:8d:ba:84:7a:60:3c:6a:db:9f:2b:ec:\n                    de:de:01:3f:6e:4d:e5:50:86:cb:b4:af:ed:44:40:\n                    c5:ca:5a:8c:da:d2:2b:7c:a8:ee:be:a6:e5:0a:aa:\n                    0e:a5:df:05:52:b7:55:c7:22:5d:32:6a:97:97:63:\n                    13:db:c9:db:79:36:7b:85:3a:4a:c5:52:89:f9:24:\n                    e7:9d:77:a9:82:ff:55:1c:a5:71:69:2b:d1:02:24:\n                    f2:b3:26:d4:6b:da:04:55:e5:c1:0a:c7:6d:30:37:\n                    90:2a:e4:9e:14:33:5e:16:17:55:c5:5b:b5:cb:34:\n                    89:92:f1:9d:26:8f:a1:07:d4:c6:b2:78:50:db:0c:\n                    0c:0b:7c:0b:8c:41:d7:b9:e9:dd:8c:88:f7:a3:4d:\n                    b2:32:cc:d8:17:da:cd:b7:ce:66:9d:d4:fd:5e:ff:\n                    bd:97:3e:29:75:e7:7e:a7:62:58:af:25:34:a5:41:\n                    c7:3d:bc:0d:50:ca:03:03:0f:08:5a:1f:95:73:78:\n                    62:bf:af:72:14:69:0e:a5:e5:03:0e:78:8e:26:28:\n                    42:f0:07:0b:62:20:10:67:39:46:fa:a9:03:cc:04:\n                    38:7a:66:ef:20:83:b5:8c:4a:56:8e:91:00:fc:8e:\n                    5c:82:de:88:a0:c3:e2:68:6e:7d:8d:ef:3c:dd:65:\n                    f4:5d:ac:51:ef:24:80:ae:aa:56:97:6f:f9:ad:7d:\n                    da:61:3f:98:77:3c:a5:91:b6:1c:8c:26:da:65:a2:\n                    09:6d:c1:e2:54:e3:b9:ca:4c:4c:80:8f:77:7b:60:\n                    9a:1e:df:b6:f2:48:1e:0e:ba:4e:54:6d:98:e0:e1:\n                    a2:1a:a2:77:50:cf:c4:63:92:ec:47:19:9d:eb:e6:\n                    6b:ce:c1\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                5B:25:7B:96:A4:65:51:7E:B8:39:F3:C0:78:66:5E:E8:3A:E7:F0:EE\n            X509v3 Authority Key Identifier: \n                keyid:5B:25:7B:96:A4:65:51:7E:B8:39:F3:C0:78:66:5E:E8:3A:E7:F0:EE\n\n            X509v3 Certificate Policies: \n                Policy: 2.16.756.1.89.1.2.1.1\n                  CPS: http://repository.swisssign.com/\n\n    Signature Algorithm: sha1WithRSAEncryption\n         27:ba:e3:94:7c:f1:ae:c0:de:17:e6:e5:d8:d5:f5:54:b0:83:\n         f4:bb:cd:5e:05:7b:4f:9f:75:66:af:3c:e8:56:7e:fc:72:78:\n         38:03:d9:2b:62:1b:00:b9:f8:e9:60:cd:cc:ce:51:8a:c7:50:\n         31:6e:e1:4a:7e:18:2f:69:59:b6:3d:64:81:2b:e3:83:84:e6:\n         22:87:8e:7d:e0:ee:02:99:61:b8:1e:f4:b8:2b:88:12:16:84:\n         c2:31:93:38:96:31:a6:b9:3b:53:3f:c3:24:93:56:5b:69:92:\n         ec:c5:c1:bb:38:00:e3:ec:17:a9:b8:dc:c7:7c:01:83:9f:32:\n         47:ba:52:22:34:1d:32:7a:09:56:a7:7c:25:36:a9:3d:4b:da:\n         c0:82:6f:0a:bb:12:c8:87:4b:27:11:f9:1e:2d:c7:93:3f:9e:\n         db:5f:26:6b:52:d9:2e:8a:f1:14:c6:44:8d:15:a9:b7:bf:bd:\n         de:a6:1a:ee:ae:2d:fb:48:77:17:fe:bb:ec:af:18:f5:2a:51:\n         f0:39:84:97:95:6c:6e:1b:c3:2b:c4:74:60:79:25:b0:0a:27:\n         df:df:5e:d2:39:cf:45:7d:42:4b:df:b3:2c:1e:c5:c6:5d:ca:\n         55:3a:a0:9c:69:9a:8f:da:ef:b2:b0:3c:9f:87:6c:12:2b:65:\n         70:15:52:31:1a:24:cf:6f:31:23:50:1f:8c:4f:8f:23:c3:74:\n         41:63:1c:55:a8:14:dd:3e:e0:51:50:cf:f1:1b:30:56:0e:92:\n         b0:82:85:d8:83:cb:22:64:bc:2d:b8:25:d5:54:a2:b8:06:ea:\n         ad:92:a4:24:a0:c1:86:b5:4a:13:6a:47:cf:2e:0b:56:95:54:\n         cb:ce:9a:db:6a:b4:a6:b2:db:41:08:86:27:77:f7:6a:a0:42:\n         6c:0b:38:ce:d7:75:50:32:92:c2:df:2b:30:22:48:d0:d5:41:\n         38:25:5d:a4:e9:5d:9f:c6:94:75:d0:45:fd:30:97:43:8f:90:\n         ab:0a:c7:86:73:60:4a:69:2d:de:a5:78:d7:06:da:6a:9e:4b:\n         3e:77:3a:20:13:22:01:d0:bf:68:9e:63:60:6b:35:4d:0b:6d:\n         ba:a1:3d:c0:93:e0:7f:23:b3:55:ad:72:25:4e:46:f9:d2:16:\n         ef:b0:64:c1:01:9e:e9:ca:a0:6a:98:0e:cf:d8:60:f2:2f:49:\n         b8:e4:42:e1:38:35:16:f4:c8:6e:4f:f7:81:56:e8:ba:a3:be:\n         23:af:ae:fd:6f:03:e0:02:3b:30:76:fa:1b:6d:41:cf:01:b1:\n         e9:b8:c9:66:f4:db:26:f3:3a:a4:74:f2:49:24:5b:c9:b0:d0:\n         57:c1:fa:3e:7a:e1:97:c9\nSHA1 Fingerprint=D8:C5:38:8A:B7:30:1B:1B:6E:D4:7A:E6:45:25:3A:6F:9F:1A:27:61\n",
    "5bca5ee5ded281aacda82d6451b6d9729b97e64f": "-----BEGIN CERTIFICATE-----\nMIIClDCCAhqgAwIBAgIILCmcWxbtBZUwCgYIKoZIzj0EAwIwfzELMAkGA1UEBhMC\nVVMxDjAMBgNVBAgMBVRleGFzMRAwDgYDVQQHDAdIb3VzdG9uMRgwFgYDVQQKDA9T\nU0wgQ29ycG9yYXRpb24xNDAyBgNVBAMMK1NTTC5jb20gRVYgUm9vdCBDZXJ0aWZp\nY2F0aW9uIEF1dGhvcml0eSBFQ0MwHhcNMTYwMjEyMTgxNTIzWhcNNDEwMjEyMTgx\nNTIzWjB/MQswCQYDVQQGEwJVUzEOMAwGA1UECAwFVGV4YXMxEDAOBgNVBAcMB0hv\ndXN0b24xGDAWBgNVBAoMD1NTTCBDb3Jwb3JhdGlvbjE0MDIGA1UEAwwrU1NMLmNv\nbSBFViBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IEVDQzB2MBAGByqGSM49\nAgEGBSuBBAAiA2IABKoSR5CYG/vvw0AHgyBO8TCCogbR8pKGYfL2IWjKAMTH6kMA\nVIbc/R/fALhBYlzccBYy3h+Z1MzFB8gIH2EWB1E9fVwHU+M1OIzfzZ/ZLg1Kthku\nWnBaBu2+8KGwytAJKaNjMGEwHQYDVR0OBBYEFFvKXuXe0oGqzagtZFG22XKbl+ZP\nMA8GA1UdEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAUW8pe5d7SgarNqC1kUbbZcpuX\n5k8wDgYDVR0PAQH/BAQDAgGGMAoGCCqGSM49BAMCA2gAMGUCMQCK5kCJN+vp1RPZ\nytRrJPOwPYdGWBrssd9v+1a6cGvHOMzosYxPD/fxZ3YOg9AeUY8CMD32IygmTMZg\nh5Mmm7I1HrrW9zzRHM76JTymGoEVW/MSD2zuZYrJh6j5B+BimoxcSg==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 3182246526754555285 (0x2c299c5b16ed0595)\n        Signature Algorithm: ecdsa-with-SHA256\n        Issuer: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com EV Root Certification Authority ECC\n        Validity\n            Not Before: Feb 12 18:15:23 2016 GMT\n            Not After : Feb 12 18:15:23 2041 GMT\n        Subject: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com EV Root Certification Authority ECC\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:aa:12:47:90:98:1b:fb:ef:c3:40:07:83:20:4e:\n                    f1:30:82:a2:06:d1:f2:92:86:61:f2:f6:21:68:ca:\n                    00:c4:c7:ea:43:00:54:86:dc:fd:1f:df:00:b8:41:\n                    62:5c:dc:70:16:32:de:1f:99:d4:cc:c5:07:c8:08:\n                    1f:61:16:07:51:3d:7d:5c:07:53:e3:35:38:8c:df:\n                    cd:9f:d9:2e:0d:4a:b6:19:2e:5a:70:5a:06:ed:be:\n                    f0:a1:b0:ca:d0:09:29\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                5B:CA:5E:E5:DE:D2:81:AA:CD:A8:2D:64:51:B6:D9:72:9B:97:E6:4F\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Authority Key Identifier: \n                keyid:5B:CA:5E:E5:DE:D2:81:AA:CD:A8:2D:64:51:B6:D9:72:9B:97:E6:4F\n\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n    Signature Algorithm: ecdsa-with-SHA256\n         30:65:02:31:00:8a:e6:40:89:37:eb:e9:d5:13:d9:ca:d4:6b:\n         24:f3:b0:3d:87:46:58:1a:ec:b1:df:6f:fb:56:ba:70:6b:c7:\n         38:cc:e8:b1:8c:4f:0f:f7:f1:67:76:0e:83:d0:1e:51:8f:02:\n         30:3d:f6:23:28:26:4c:c6:60:87:93:26:9b:b2:35:1e:ba:d6:\n         f7:3c:d1:1c:ce:fa:25:3c:a6:1a:81:15:5b:f3:12:0f:6c:ee:\n         65:8a:c9:87:a8:f9:07:e0:62:9a:8c:5c:4a\nSHA1 Fingerprint=4C:DD:51:A3:D1:F5:20:32:14:B0:C6:C5:32:23:03:91:C7:46:42:6D\n",
    "5bf84d4fb2a586d43ad2f1639aa0be09f657b7de": "-----BEGIN CERTIFICATE-----\nMIIDbTCCAlWgAwIBAgIBATANBgkqhkiG9w0BAQUFADBYMQswCQYDVQQGEwJKUDEr\nMCkGA1UEChMiSmFwYW4gQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcywgSW5jLjEcMBoG\nA1UEAxMTU2VjdXJlU2lnbiBSb290Q0ExMTAeFw0wOTA0MDgwNDU2NDdaFw0yOTA0\nMDgwNDU2NDdaMFgxCzAJBgNVBAYTAkpQMSswKQYDVQQKEyJKYXBhbiBDZXJ0aWZp\nY2F0aW9uIFNlcnZpY2VzLCBJbmMuMRwwGgYDVQQDExNTZWN1cmVTaWduIFJvb3RD\nQTExMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA/XeqpRyQBTvLTJsz\ni1oURaTnkBbR31fSIRCkF/3frNYfp+TbfPfs37gD2pRY/V1yfIw/XwFndBWW4wI8\nh9uuywGOwvNmxoVF9ALGOrVisq/6nL+k5tSAMJjzDbaTj6nU2DbysPyKyiyhFTOV\nMdrAG/LuYpmGYz+/3ZMqg6h2uRMft85OQoWPIucuGvKVCbIFtUROd6EgvanyTgp9\nUK31BQ1FT0Zx/Sg+U/sE2C3XZR1KG/rPO7AxmjVuyIsG0wCR8pQIZUyxNAYAeoni\n8McDWc/V1uinMrPmmECGxc0nEovMe863ETxiYAcjPitAbpSACW22s293bzUIUPsC\nh8U+iQIDAQABo0IwQDAdBgNVHQ4EFgQUW/hNT7KlhtQ60vFjmqC+CfZXt94wDgYD\nVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEB\nAKChOBZmLqdWHyGcBvod7bkixTgm2E5P7KN/ed5GIaGHd48HCJqypMWvDzKYC3xm\nKbabfSVSSUOrTC4rbnpwrxYO4wJs+0LmGJ1F2FXI6Dvd5+H0LgscNFxsWEr7jIhQ\nX5Ucv+2rIrVls4W6ng+4reV6G4pQOh29Dbx7VFALuUKvVaAYga1lme++5Jy/xIWr\nQbJUb9wlze144o4MjQlJ3WN7WmmWAiGovVJZ6X01y8hSyn+B/tlr0/cR7SXf+Of5\npPpyl4RTDaXQMhhRdlkUbA/r7F+AjHVDg8OFmP9Mni0N5HeDk061lgeLKBObjBmN\nQSdJQO7e5iNEOdyhIta6A/I=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 1 (0x1)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=JP, O=Japan Certification Services, Inc., CN=SecureSign RootCA11\n        Validity\n            Not Before: Apr  8 04:56:47 2009 GMT\n            Not After : Apr  8 04:56:47 2029 GMT\n        Subject: C=JP, O=Japan Certification Services, Inc., CN=SecureSign RootCA11\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:fd:77:aa:a5:1c:90:05:3b:cb:4c:9b:33:8b:5a:\n                    14:45:a4:e7:90:16:d1:df:57:d2:21:10:a4:17:fd:\n                    df:ac:d6:1f:a7:e4:db:7c:f7:ec:df:b8:03:da:94:\n                    58:fd:5d:72:7c:8c:3f:5f:01:67:74:15:96:e3:02:\n                    3c:87:db:ae:cb:01:8e:c2:f3:66:c6:85:45:f4:02:\n                    c6:3a:b5:62:b2:af:fa:9c:bf:a4:e6:d4:80:30:98:\n                    f3:0d:b6:93:8f:a9:d4:d8:36:f2:b0:fc:8a:ca:2c:\n                    a1:15:33:95:31:da:c0:1b:f2:ee:62:99:86:63:3f:\n                    bf:dd:93:2a:83:a8:76:b9:13:1f:b7:ce:4e:42:85:\n                    8f:22:e7:2e:1a:f2:95:09:b2:05:b5:44:4e:77:a1:\n                    20:bd:a9:f2:4e:0a:7d:50:ad:f5:05:0d:45:4f:46:\n                    71:fd:28:3e:53:fb:04:d8:2d:d7:65:1d:4a:1b:fa:\n                    cf:3b:b0:31:9a:35:6e:c8:8b:06:d3:00:91:f2:94:\n                    08:65:4c:b1:34:06:00:7a:89:e2:f0:c7:03:59:cf:\n                    d5:d6:e8:a7:32:b3:e6:98:40:86:c5:cd:27:12:8b:\n                    cc:7b:ce:b7:11:3c:62:60:07:23:3e:2b:40:6e:94:\n                    80:09:6d:b6:b3:6f:77:6f:35:08:50:fb:02:87:c5:\n                    3e:89\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                5B:F8:4D:4F:B2:A5:86:D4:3A:D2:F1:63:9A:A0:BE:09:F6:57:B7:DE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: sha1WithRSAEncryption\n         a0:a1:38:16:66:2e:a7:56:1f:21:9c:06:fa:1d:ed:b9:22:c5:\n         38:26:d8:4e:4f:ec:a3:7f:79:de:46:21:a1:87:77:8f:07:08:\n         9a:b2:a4:c5:af:0f:32:98:0b:7c:66:29:b6:9b:7d:25:52:49:\n         43:ab:4c:2e:2b:6e:7a:70:af:16:0e:e3:02:6c:fb:42:e6:18:\n         9d:45:d8:55:c8:e8:3b:dd:e7:e1:f4:2e:0b:1c:34:5c:6c:58:\n         4a:fb:8c:88:50:5f:95:1c:bf:ed:ab:22:b5:65:b3:85:ba:9e:\n         0f:b8:ad:e5:7a:1b:8a:50:3a:1d:bd:0d:bc:7b:54:50:0b:b9:\n         42:af:55:a0:18:81:ad:65:99:ef:be:e4:9c:bf:c4:85:ab:41:\n         b2:54:6f:dc:25:cd:ed:78:e2:8e:0c:8d:09:49:dd:63:7b:5a:\n         69:96:02:21:a8:bd:52:59:e9:7d:35:cb:c8:52:ca:7f:81:fe:\n         d9:6b:d3:f7:11:ed:25:df:f8:e7:f9:a4:fa:72:97:84:53:0d:\n         a5:d0:32:18:51:76:59:14:6c:0f:eb:ec:5f:80:8c:75:43:83:\n         c3:85:98:ff:4c:9e:2d:0d:e4:77:83:93:4e:b5:96:07:8b:28:\n         13:9b:8c:19:8d:41:27:49:40:ee:de:e6:23:44:39:dc:a1:22:\n         d6:ba:03:f2\nSHA1 Fingerprint=3B:C4:9F:48:F8:F3:73:A0:9C:1E:BD:F8:5B:B1:C3:65:C7:D8:11:B3\n",
    "607b661a450d97ca89502f7d04cd34a8fffcfd4b": "-----BEGIN CERTIFICATE-----\nMIIDdTCCAl2gAwIBAgILBAAAAAABFUtaw5QwDQYJKoZIhvcNAQEFBQAwVzELMAkG\nA1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv\nb3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MDExMjAw\nMDBaFw0yODAxMjgxMjAwMDBaMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i\nYWxTaWduIG52LXNhMRAwDgYDVQQLEwdSb290IENBMRswGQYDVQQDExJHbG9iYWxT\naWduIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDaDuaZ\njc6j40+Kfvvxi4Mla+pIH/EqsLmVEQS98GPR4mdmzxzdzxtIK+6NiY6arymAZavp\nxy0Sy6scTHAHoT0KMM0VjU/43dSMUBUc71DuxC73/OlS8pF94G3VNTCOXkNz8kHp\n1Wrjsok6Vjk4bwY8iGlbKk3Fp1S4bInMm/k8yuX9ifUSPJJ4ltbcdG6TRGHRjcdG\nsnUOhugZitVtbNV4FpWi6cgKOOvyJBNPc1STE4U6G7weNLWLBYy5d4ux2x8gkasJ\nU26Qzns3dLlwR5EiUWMWea6xrkEmCMgZK9FGqkjWZCrXgzT/LCrBbBlDSgeF59N8\n9iFo7+ryUp9/k5DPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8E\nBTADAQH/MB0GA1UdDgQWBBRge2YaRQ2XyolQL30EzTSo//z9SzANBgkqhkiG9w0B\nAQUFAAOCAQEA1nPnfE920I2/7LqivjTFKDK1fPxsnCwrvQmeU79rXqoRSLblCKOz\nyj1hTdNGCbM+w6DjY1Ub8rrvrTnhQ7k4o+YviiY776BQVvnGCv04zcQLcFGUl5gE\n38NflNUVyRRBnMRddWQVDf9VMOyGj/8N7yy5Y0b2qvzfvGn9LhJIZJrglfCm7ymP\nAbEVtQwdpf5pLGkkeB6zpxxxYu7KyJesF12KwvhHhm4qxFYxldBniYUr+WymXUad\nDKqC5JlR3XC321Y9YeRq4VzW9v493kHMB65jUr9TU/Qr6cf9tveCX4XSQRjbgbME\nHMUfpIBvFSDJ3gyICh3WZlXi/EjJKSZp4A==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            04:00:00:00:00:01:15:4b:5a:c3:94\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA\n        Validity\n            Not Before: Sep  1 12:00:00 1998 GMT\n            Not After : Jan 28 12:00:00 2028 GMT\n        Subject: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:da:0e:e6:99:8d:ce:a3:e3:4f:8a:7e:fb:f1:8b:\n                    83:25:6b:ea:48:1f:f1:2a:b0:b9:95:11:04:bd:f0:\n                    63:d1:e2:67:66:cf:1c:dd:cf:1b:48:2b:ee:8d:89:\n                    8e:9a:af:29:80:65:ab:e9:c7:2d:12:cb:ab:1c:4c:\n                    70:07:a1:3d:0a:30:cd:15:8d:4f:f8:dd:d4:8c:50:\n                    15:1c:ef:50:ee:c4:2e:f7:fc:e9:52:f2:91:7d:e0:\n                    6d:d5:35:30:8e:5e:43:73:f2:41:e9:d5:6a:e3:b2:\n                    89:3a:56:39:38:6f:06:3c:88:69:5b:2a:4d:c5:a7:\n                    54:b8:6c:89:cc:9b:f9:3c:ca:e5:fd:89:f5:12:3c:\n                    92:78:96:d6:dc:74:6e:93:44:61:d1:8d:c7:46:b2:\n                    75:0e:86:e8:19:8a:d5:6d:6c:d5:78:16:95:a2:e9:\n                    c8:0a:38:eb:f2:24:13:4f:73:54:93:13:85:3a:1b:\n                    bc:1e:34:b5:8b:05:8c:b9:77:8b:b1:db:1f:20:91:\n                    ab:09:53:6e:90:ce:7b:37:74:b9:70:47:91:22:51:\n                    63:16:79:ae:b1:ae:41:26:08:c8:19:2b:d1:46:aa:\n                    48:d6:64:2a:d7:83:34:ff:2c:2a:c1:6c:19:43:4a:\n                    07:85:e7:d3:7c:f6:21:68:ef:ea:f2:52:9f:7f:93:\n                    90:cf\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B\n    Signature Algorithm: sha1WithRSAEncryption\n         d6:73:e7:7c:4f:76:d0:8d:bf:ec:ba:a2:be:34:c5:28:32:b5:\n         7c:fc:6c:9c:2c:2b:bd:09:9e:53:bf:6b:5e:aa:11:48:b6:e5:\n         08:a3:b3:ca:3d:61:4d:d3:46:09:b3:3e:c3:a0:e3:63:55:1b:\n         f2:ba:ef:ad:39:e1:43:b9:38:a3:e6:2f:8a:26:3b:ef:a0:50:\n         56:f9:c6:0a:fd:38:cd:c4:0b:70:51:94:97:98:04:df:c3:5f:\n         94:d5:15:c9:14:41:9c:c4:5d:75:64:15:0d:ff:55:30:ec:86:\n         8f:ff:0d:ef:2c:b9:63:46:f6:aa:fc:df:bc:69:fd:2e:12:48:\n         64:9a:e0:95:f0:a6:ef:29:8f:01:b1:15:b5:0c:1d:a5:fe:69:\n         2c:69:24:78:1e:b3:a7:1c:71:62:ee:ca:c8:97:ac:17:5d:8a:\n         c2:f8:47:86:6e:2a:c4:56:31:95:d0:67:89:85:2b:f9:6c:a6:\n         5d:46:9d:0c:aa:82:e4:99:51:dd:70:b7:db:56:3d:61:e4:6a:\n         e1:5c:d6:f6:fe:3d:de:41:cc:07:ae:63:52:bf:53:53:f4:2b:\n         e9:c7:fd:b6:f7:82:5f:85:d2:41:18:db:81:b3:04:1c:c5:1f:\n         a4:80:6f:15:20:c9:de:0c:88:0a:1d:d6:66:55:e2:fc:48:c9:\n         29:26:69:e0\nSHA1 Fingerprint=B1:BC:96:8B:D4:F4:9D:62:2A:A8:9A:81:F2:15:01:52:A4:1D:82:9C\n",
    "653fc78a86c63cdd3c545c35f83aed520c4757c8": "-----BEGIN CERTIFICATE-----\nMIIEYzCCA0ugAwIBAgIBATANBgkqhkiG9w0BAQsFADCB0jELMAkGA1UEBhMCVFIx\nGDAWBgNVBAcTD0dlYnplIC0gS29jYWVsaTFCMEAGA1UEChM5VHVya2l5ZSBCaWxp\nbXNlbCB2ZSBUZWtub2xvamlrIEFyYXN0aXJtYSBLdXJ1bXUgLSBUVUJJVEFLMS0w\nKwYDVQQLEyRLYW11IFNlcnRpZmlrYXN5b24gTWVya2V6aSAtIEthbXUgU00xNjA0\nBgNVBAMTLVRVQklUQUsgS2FtdSBTTSBTU0wgS29rIFNlcnRpZmlrYXNpIC0gU3Vy\ndW0gMTAeFw0xMzExMjUwODI1NTVaFw00MzEwMjUwODI1NTVaMIHSMQswCQYDVQQG\nEwJUUjEYMBYGA1UEBxMPR2ViemUgLSBLb2NhZWxpMUIwQAYDVQQKEzlUdXJraXll\nIEJpbGltc2VsIHZlIFRla25vbG9qaWsgQXJhc3Rpcm1hIEt1cnVtdSAtIFRVQklU\nQUsxLTArBgNVBAsTJEthbXUgU2VydGlmaWthc3lvbiBNZXJrZXppIC0gS2FtdSBT\nTTE2MDQGA1UEAxMtVFVCSVRBSyBLYW11IFNNIFNTTCBLb2sgU2VydGlmaWthc2kg\nLSBTdXJ1bSAxMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAr3UwM6q7\na9OZLBI3hNmNe5eA027n/5tQlT6QlVZC1xl8JoSNkvoBHToP4mQ4t4y86Ij5iySr\nLqP1N+RAjhgleYN1Hzv/bKjFxlb4tO2KRKOrbEz8HdDc72i9z+SqzvBV96I01INr\nN3wcwv61A+xXzry0tcXtAA9TNypN9E8Mg/uGz8v+jE69h/mniyFXnHrfA2eJLJ2X\nYacQuFWQfw4tJzh03+f92k4S400VIgLI4OD8D62K18lUUMw7D8oWgITQUVbDjlZ/\niSIzL+aFCr2lqBs23tPcLG07xxO9WSMs5uWk99gL7eqQQESolbuT1dCANLZGeA4f\nAJNG4e7p+exPFwIDAQABo0IwQDAdBgNVHQ4EFgQUZT/HiobGPN08VFw1+DrtUgxH\nV8gwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEL\nBQADggEBACo/4fEyjq7hmFxLXs9rHmoJ0iKpEsdeV31zVmSAhHqT5Am5EM2fKifh\nAHe+SMg1qIGf5LgsyX8OsNJLN13qudULXjS99HMpw+0mFZx+CFOKWI3QSyjfwbPf\nIPP54+M638yclNhOT8NrF7f3cuitZjO1JVOr4PhMqZ398g26rrnZqsZr+ZO7rqu4\nlzwDGrpDxpa5RXI4s6ehlj2Re37AIVNMh+3yC1SVUZPVIqUNivGTDj5UDrDYyU7c\n8jEyVupk+eq1nRZmQnLzf9OxMUP8pI4X8W0jq5Rm+K37DwhuJi1/FwcJsoz7UMCf\nlo3Ptv0AnVoUmr8CRPXBwp8iXqIPoeM=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 1 (0x1)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=TR, L=Gebze - Kocaeli, O=Turkiye Bilimsel ve Teknolojik Arastirma Kurumu - TUBITAK, OU=Kamu Sertifikasyon Merkezi - Kamu SM, CN=TUBITAK Kamu SM SSL Kok Sertifikasi - Surum 1\n        Validity\n            Not Before: Nov 25 08:25:55 2013 GMT\n            Not After : Oct 25 08:25:55 2043 GMT\n        Subject: C=TR, L=Gebze - Kocaeli, O=Turkiye Bilimsel ve Teknolojik Arastirma Kurumu - TUBITAK, OU=Kamu Sertifikasyon Merkezi - Kamu SM, CN=TUBITAK Kamu SM SSL Kok Sertifikasi - Surum 1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:af:75:30:33:aa:bb:6b:d3:99:2c:12:37:84:d9:\n                    8d:7b:97:80:d3:6e:e7:ff:9b:50:95:3e:90:95:56:\n                    42:d7:19:7c:26:84:8d:92:fa:01:1d:3a:0f:e2:64:\n                    38:b7:8c:bc:e8:88:f9:8b:24:ab:2e:a3:f5:37:e4:\n                    40:8e:18:25:79:83:75:1f:3b:ff:6c:a8:c5:c6:56:\n                    f8:b4:ed:8a:44:a3:ab:6c:4c:fc:1d:d0:dc:ef:68:\n                    bd:cf:e4:aa:ce:f0:55:f7:a2:34:d4:83:6b:37:7c:\n                    1c:c2:fe:b5:03:ec:57:ce:bc:b4:b5:c5:ed:00:0f:\n                    53:37:2a:4d:f4:4f:0c:83:fb:86:cf:cb:fe:8c:4e:\n                    bd:87:f9:a7:8b:21:57:9c:7a:df:03:67:89:2c:9d:\n                    97:61:a7:10:b8:55:90:7f:0e:2d:27:38:74:df:e7:\n                    fd:da:4e:12:e3:4d:15:22:02:c8:e0:e0:fc:0f:ad:\n                    8a:d7:c9:54:50:cc:3b:0f:ca:16:80:84:d0:51:56:\n                    c3:8e:56:7f:89:22:33:2f:e6:85:0a:bd:a5:a8:1b:\n                    36:de:d3:dc:2c:6d:3b:c7:13:bd:59:23:2c:e6:e5:\n                    a4:f7:d8:0b:ed:ea:90:40:44:a8:95:bb:93:d5:d0:\n                    80:34:b6:46:78:0e:1f:00:93:46:e1:ee:e9:f9:ec:\n                    4f:17\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                65:3F:C7:8A:86:C6:3C:DD:3C:54:5C:35:F8:3A:ED:52:0C:47:57:C8\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: sha256WithRSAEncryption\n         2a:3f:e1:f1:32:8e:ae:e1:98:5c:4b:5e:cf:6b:1e:6a:09:d2:\n         22:a9:12:c7:5e:57:7d:73:56:64:80:84:7a:93:e4:09:b9:10:\n         cd:9f:2a:27:e1:00:77:be:48:c8:35:a8:81:9f:e4:b8:2c:c9:\n         7f:0e:b0:d2:4b:37:5d:ea:b9:d5:0b:5e:34:bd:f4:73:29:c3:\n         ed:26:15:9c:7e:08:53:8a:58:8d:d0:4b:28:df:c1:b3:df:20:\n         f3:f9:e3:e3:3a:df:cc:9c:94:d8:4e:4f:c3:6b:17:b7:f7:72:\n         e8:ad:66:33:b5:25:53:ab:e0:f8:4c:a9:9d:fd:f2:0d:ba:ae:\n         b9:d9:aa:c6:6b:f9:93:bb:ae:ab:b8:97:3c:03:1a:ba:43:c6:\n         96:b9:45:72:38:b3:a7:a1:96:3d:91:7b:7e:c0:21:53:4c:87:\n         ed:f2:0b:54:95:51:93:d5:22:a5:0d:8a:f1:93:0e:3e:54:0e:\n         b0:d8:c9:4e:dc:f2:31:32:56:ea:64:f9:ea:b5:9d:16:66:42:\n         72:f3:7f:d3:b1:31:43:fc:a4:8e:17:f1:6d:23:ab:94:66:f8:\n         ad:fb:0f:08:6e:26:2d:7f:17:07:09:b2:8c:fb:50:c0:9f:96:\n         8d:cf:b6:fd:00:9d:5a:14:9a:bf:02:44:f5:c1:c2:9f:22:5e:\n         a2:0f:a1:e3\nSHA1 Fingerprint=31:43:64:9B:EC:CE:27:EC:ED:3A:3F:0B:8F:0D:E4:E8:91:DD:EE:CA\n",
    "6890e467a4a65380c78666a4f1f74b43fb84bd6d": "-----BEGIN CERTIFICATE-----\nMIIEkTCCA3mgAwIBAgIERWtQVDANBgkqhkiG9w0BAQUFADCBsDELMAkGA1UEBhMC\nVVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xOTA3BgNVBAsTMHd3dy5lbnRydXN0\nLm5ldC9DUFMgaXMgaW5jb3Jwb3JhdGVkIGJ5IHJlZmVyZW5jZTEfMB0GA1UECxMW\nKGMpIDIwMDYgRW50cnVzdCwgSW5jLjEtMCsGA1UEAxMkRW50cnVzdCBSb290IENl\ncnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA2MTEyNzIwMjM0MloXDTI2MTEyNzIw\nNTM0MlowgbAxCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1FbnRydXN0LCBJbmMuMTkw\nNwYDVQQLEzB3d3cuZW50cnVzdC5uZXQvQ1BTIGlzIGluY29ycG9yYXRlZCBieSBy\nZWZlcmVuY2UxHzAdBgNVBAsTFihjKSAyMDA2IEVudHJ1c3QsIEluYy4xLTArBgNV\nBAMTJEVudHJ1c3QgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBALaVtkNC+sZtKm9I35RMOVcF7sN5EUFo\nNu3s/poBj6E4KPz3EEZmLk0eGrEaTsbRwJWIsMn/MYszA9u3g3s+IIRe7bJWKKf4\n4LlAcTfFy0cOlypowCKVYhXbR9n10Cv/gkvJrT7eTNuQgFA/CYqEAOwwCj0Yzfv9\nKlmaI5UXLEWeH25DeW0MXJj+SKfFI0dcXv1u5x609mhF0YaDW6KKjbHjKYD+JXGI\nrb68j6xSlkuqUY3kEzEZ6E5Nn9uss2rVvDlUccp6en+Q3X0dgNmBu1kmwhH+5pPi\n94DkZfs0Nw4pgHBNrziGLp5/V6+eF67rHMsoIV+2HNjnogQi+dPa2MsCAwEAAaOB\nsDCBrTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zArBgNVHRAEJDAi\ngA8yMDA2MTEyNzIwMjM0MlqBDzIwMjYxMTI3MjA1MzQyWjAfBgNVHSMEGDAWgBRo\nkORnpKZTgMeGZqTx90tD+4S9bTAdBgNVHQ4EFgQUaJDkZ6SmU4DHhmak8fdLQ/uE\nvW0wHQYJKoZIhvZ9B0EABBAwDhsIVjcuMTo0LjADAgSQMA0GCSqGSIb3DQEBBQUA\nA4IBAQCT1DCw1wMgKtD5Y+iRDAUgqV8ZyntyTtSx29CW+1RaGSwMCPeyvIWonX9t\nO1KzKtvn1ISMY/YPyyYBkVBs9F8U4pN0wBOeMDpQ47RgxRzwIkSNcUesyBrJ6Zua\nAGAT/3B+XxFNSRuzFVJ7yVTav52Vr2ua2J7p8eRDjeIRRDq/r72DQnNSi6q7pynP\n9WQcCk3RvKqsnyrQ/39/2n3qse0wJcGE2jTSW3iDVuycNsMm4hH2Z0kdkquM++v/\neu6FSqdQgPCnXEqULl8FmTxSQeDNtGPPAUO6nIPcj2A781q0tHuu2guQOHXvgR1m\n0vdXcDazv/wor3ElhVsT/h5/WrQ8\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 1164660820 (0x456b5054)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=US, O=Entrust, Inc., OU=www.entrust.net/CPS is incorporated by reference, OU=(c) 2006 Entrust, Inc., CN=Entrust Root Certification Authority\n        Validity\n            Not Before: Nov 27 20:23:42 2006 GMT\n            Not After : Nov 27 20:53:42 2026 GMT\n        Subject: C=US, O=Entrust, Inc., OU=www.entrust.net/CPS is incorporated by reference, OU=(c) 2006 Entrust, Inc., CN=Entrust Root Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:b6:95:b6:43:42:fa:c6:6d:2a:6f:48:df:94:4c:\n                    39:57:05:ee:c3:79:11:41:68:36:ed:ec:fe:9a:01:\n                    8f:a1:38:28:fc:f7:10:46:66:2e:4d:1e:1a:b1:1a:\n                    4e:c6:d1:c0:95:88:b0:c9:ff:31:8b:33:03:db:b7:\n                    83:7b:3e:20:84:5e:ed:b2:56:28:a7:f8:e0:b9:40:\n                    71:37:c5:cb:47:0e:97:2a:68:c0:22:95:62:15:db:\n                    47:d9:f5:d0:2b:ff:82:4b:c9:ad:3e:de:4c:db:90:\n                    80:50:3f:09:8a:84:00:ec:30:0a:3d:18:cd:fb:fd:\n                    2a:59:9a:23:95:17:2c:45:9e:1f:6e:43:79:6d:0c:\n                    5c:98:fe:48:a7:c5:23:47:5c:5e:fd:6e:e7:1e:b4:\n                    f6:68:45:d1:86:83:5b:a2:8a:8d:b1:e3:29:80:fe:\n                    25:71:88:ad:be:bc:8f:ac:52:96:4b:aa:51:8d:e4:\n                    13:31:19:e8:4e:4d:9f:db:ac:b3:6a:d5:bc:39:54:\n                    71:ca:7a:7a:7f:90:dd:7d:1d:80:d9:81:bb:59:26:\n                    c2:11:fe:e6:93:e2:f7:80:e4:65:fb:34:37:0e:29:\n                    80:70:4d:af:38:86:2e:9e:7f:57:af:9e:17:ae:eb:\n                    1c:cb:28:21:5f:b6:1c:d8:e7:a2:04:22:f9:d3:da:\n                    d8:cb\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Private Key Usage Period: \n                Not Before: Nov 27 20:23:42 2006 GMT, Not After: Nov 27 20:53:42 2026 GMT\n            X509v3 Authority Key Identifier: \n                keyid:68:90:E4:67:A4:A6:53:80:C7:86:66:A4:F1:F7:4B:43:FB:84:BD:6D\n\n            X509v3 Subject Key Identifier: \n                68:90:E4:67:A4:A6:53:80:C7:86:66:A4:F1:F7:4B:43:FB:84:BD:6D\n            1.2.840.113533.7.65.0: \n                0...V7.1:4.0....\n    Signature Algorithm: sha1WithRSAEncryption\n         93:d4:30:b0:d7:03:20:2a:d0:f9:63:e8:91:0c:05:20:a9:5f:\n         19:ca:7b:72:4e:d4:b1:db:d0:96:fb:54:5a:19:2c:0c:08:f7:\n         b2:bc:85:a8:9d:7f:6d:3b:52:b3:2a:db:e7:d4:84:8c:63:f6:\n         0f:cb:26:01:91:50:6c:f4:5f:14:e2:93:74:c0:13:9e:30:3a:\n         50:e3:b4:60:c5:1c:f0:22:44:8d:71:47:ac:c8:1a:c9:e9:9b:\n         9a:00:60:13:ff:70:7e:5f:11:4d:49:1b:b3:15:52:7b:c9:54:\n         da:bf:9d:95:af:6b:9a:d8:9e:e9:f1:e4:43:8d:e2:11:44:3a:\n         bf:af:bd:83:42:73:52:8b:aa:bb:a7:29:cf:f5:64:1c:0a:4d:\n         d1:bc:aa:ac:9f:2a:d0:ff:7f:7f:da:7d:ea:b1:ed:30:25:c1:\n         84:da:34:d2:5b:78:83:56:ec:9c:36:c3:26:e2:11:f6:67:49:\n         1d:92:ab:8c:fb:eb:ff:7a:ee:85:4a:a7:50:80:f0:a7:5c:4a:\n         94:2e:5f:05:99:3c:52:41:e0:cd:b4:63:cf:01:43:ba:9c:83:\n         dc:8f:60:3b:f3:5a:b4:b4:7b:ae:da:0b:90:38:75:ef:81:1d:\n         66:d2:f7:57:70:36:b3:bf:fc:28:af:71:25:85:5b:13:fe:1e:\n         7f:5a:b4:3c\nSHA1 Fingerprint=B3:1E:B1:B7:40:E3:6C:84:02:DA:DC:37:D4:4D:F5:D4:67:49:52:F9\n",
    "6a385b268dde8b5af24f7a54831918e30835a6ba": "-----BEGIN CERTIFICATE-----\nMIIDezCCAmOgAwIBAgIBATANBgkqhkiG9w0BAQUFADBfMQswCQYDVQQGEwJUVzES\nMBAGA1UECgwJVEFJV0FOLUNBMRAwDgYDVQQLDAdSb290IENBMSowKAYDVQQDDCFU\nV0NBIFJvb3QgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMDgwODI4MDcyNDMz\nWhcNMzAxMjMxMTU1OTU5WjBfMQswCQYDVQQGEwJUVzESMBAGA1UECgwJVEFJV0FO\nLUNBMRAwDgYDVQQLDAdSb290IENBMSowKAYDVQQDDCFUV0NBIFJvb3QgQ2VydGlm\naWNhdGlvbiBBdXRob3JpdHkwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB\nAQCwfnK4pAOU5qfeCTiRShFAh6d8WWQUe7UREN3+v9XAu1bihSX0NXIP+FPQQeFE\nAcK0HMMxQhZHhTMidrIKbw/lJVBPhYa+v5guEGcevhEFhgWQxFnQfHgQsIBct+HH\nK3XLfJ+utdGdIzdjp9xCoi2SBBtQwXu4PhvJVgSLL1KbralW6cH/ralYhzC2gfeX\nRfwZVzsrb+RH9JlF/h3x+JejiB03HFyP4HYlmlD4oFT/RJB2I9IyxsOrBr/8+7/z\nrX2SYgJbKdM1o5OaQ2RgXbL6Mv87BK9NQGr5x+PvI/1ry+UPizgN7gr8/g+YnzAx\n3WxSZfmLgb4i4RxYA7qRG4kHAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNV\nHRMBAf8EBTADAQH/MB0GA1UdDgQWBBRqOFsmjd6LWvJPelSDGRjjCDWmujANBgkq\nhkiG9w0BAQUFAAOCAQEAPNV3PdrfibqHDAhUaiBQkr6wQT25JmSDCi/oQMCXKCeC\nMErJk/9q56YAf4lCmtYR5VPOL8zy2gXE/uJQxDqGfczafhAJO5I1KlOy/usrBdls\nXebQ79NqZp4VKIV66IIArB6nCWlWQtNoURi+VJq/REG6Sb4gumlc7rh3zc5sH62D\nlhh9DrUUOYTxKOkto557HnpyWoOzeW/vtPzQCqVYT0bf+215WfKEIlKuD8z7fDvn\naspHYcN6+NOSBB+4IIThNlQWx0DeO4pz3N/GCUzf7Nr/1FNCocnyYh0igzyXxfkZ\nYiesZSLX0zzG5Y6yU8xJzrww/nsOM5D77dIUkR8Hrw==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 1 (0x1)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=TW, O=TAIWAN-CA, OU=Root CA, CN=TWCA Root Certification Authority\n        Validity\n            Not Before: Aug 28 07:24:33 2008 GMT\n            Not After : Dec 31 15:59:59 2030 GMT\n        Subject: C=TW, O=TAIWAN-CA, OU=Root CA, CN=TWCA Root Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:b0:7e:72:b8:a4:03:94:e6:a7:de:09:38:91:4a:\n                    11:40:87:a7:7c:59:64:14:7b:b5:11:10:dd:fe:bf:\n                    d5:c0:bb:56:e2:85:25:f4:35:72:0f:f8:53:d0:41:\n                    e1:44:01:c2:b4:1c:c3:31:42:16:47:85:33:22:76:\n                    b2:0a:6f:0f:e5:25:50:4f:85:86:be:bf:98:2e:10:\n                    67:1e:be:11:05:86:05:90:c4:59:d0:7c:78:10:b0:\n                    80:5c:b7:e1:c7:2b:75:cb:7c:9f:ae:b5:d1:9d:23:\n                    37:63:a7:dc:42:a2:2d:92:04:1b:50:c1:7b:b8:3e:\n                    1b:c9:56:04:8b:2f:52:9b:ad:a9:56:e9:c1:ff:ad:\n                    a9:58:87:30:b6:81:f7:97:45:fc:19:57:3b:2b:6f:\n                    e4:47:f4:99:45:fe:1d:f1:f8:97:a3:88:1d:37:1c:\n                    5c:8f:e0:76:25:9a:50:f8:a0:54:ff:44:90:76:23:\n                    d2:32:c6:c3:ab:06:bf:fc:fb:bf:f3:ad:7d:92:62:\n                    02:5b:29:d3:35:a3:93:9a:43:64:60:5d:b2:fa:32:\n                    ff:3b:04:af:4d:40:6a:f9:c7:e3:ef:23:fd:6b:cb:\n                    e5:0f:8b:38:0d:ee:0a:fc:fe:0f:98:9f:30:31:dd:\n                    6c:52:65:f9:8b:81:be:22:e1:1c:58:03:ba:91:1b:\n                    89:07\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                6A:38:5B:26:8D:DE:8B:5A:F2:4F:7A:54:83:19:18:E3:08:35:A6:BA\n    Signature Algorithm: sha1WithRSAEncryption\n         3c:d5:77:3d:da:df:89:ba:87:0c:08:54:6a:20:50:92:be:b0:\n         41:3d:b9:26:64:83:0a:2f:e8:40:c0:97:28:27:82:30:4a:c9:\n         93:ff:6a:e7:a6:00:7f:89:42:9a:d6:11:e5:53:ce:2f:cc:f2:\n         da:05:c4:fe:e2:50:c4:3a:86:7d:cc:da:7e:10:09:3b:92:35:\n         2a:53:b2:fe:eb:2b:05:d9:6c:5d:e6:d0:ef:d3:6a:66:9e:15:\n         28:85:7a:e8:82:00:ac:1e:a7:09:69:56:42:d3:68:51:18:be:\n         54:9a:bf:44:41:ba:49:be:20:ba:69:5c:ee:b8:77:cd:ce:6c:\n         1f:ad:83:96:18:7d:0e:b5:14:39:84:f1:28:e9:2d:a3:9e:7b:\n         1e:7a:72:5a:83:b3:79:6f:ef:b4:fc:d0:0a:a5:58:4f:46:df:\n         fb:6d:79:59:f2:84:22:52:ae:0f:cc:fb:7c:3b:e7:6a:ca:47:\n         61:c3:7a:f8:d3:92:04:1f:b8:20:84:e1:36:54:16:c7:40:de:\n         3b:8a:73:dc:df:c6:09:4c:df:ec:da:ff:d4:53:42:a1:c9:f2:\n         62:1d:22:83:3c:97:c5:f9:19:62:27:ac:65:22:d7:d3:3c:c6:\n         e5:8e:b2:53:cc:49:ce:bc:30:fe:7b:0e:33:90:fb:ed:d2:14:\n         91:1f:07:af\nSHA1 Fingerprint=CF:9E:87:6D:D3:EB:FC:42:26:97:A3:B5:A3:7A:A0:76:A9:06:23:48\n",
    "6a72267ad01eef7de73b6951d46c8d9f901266ab": "-----BEGIN CERTIFICATE-----\nMIIEPjCCAyagAwIBAgIESlOMKDANBgkqhkiG9w0BAQsFADCBvjELMAkGA1UEBhMC\nVVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50\ncnVzdC5uZXQvbGVnYWwtdGVybXMxOTA3BgNVBAsTMChjKSAyMDA5IEVudHJ1c3Qs\nIEluYy4gLSBmb3IgYXV0aG9yaXplZCB1c2Ugb25seTEyMDAGA1UEAxMpRW50cnVz\ndCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzIwHhcNMDkwNzA3MTcy\nNTU0WhcNMzAxMjA3MTc1NTU0WjCBvjELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVu\ndHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50cnVzdC5uZXQvbGVnYWwt\ndGVybXMxOTA3BgNVBAsTMChjKSAyMDA5IEVudHJ1c3QsIEluYy4gLSBmb3IgYXV0\naG9yaXplZCB1c2Ugb25seTEyMDAGA1UEAxMpRW50cnVzdCBSb290IENlcnRpZmlj\nYXRpb24gQXV0aG9yaXR5IC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK\nAoIBAQC6hLZy254Ma+KZ6TABp3bqMriVQRrJ2mFOWHLP/vaCeb9zYQYKpSfYs1/T\nRU4cctZOMvJyig/3gxnQaoCAAEUesMfnmr8SVycco2gvCoe9amsOXmXzHHfV1IWN\ncCG0szLni6LVhjkCsbjSR87kyUnEO6fe+1R9V77w6G7CebI6C1XiUJgWMhNcL3hW\nwcKUs/Ja5CeanyTXxuzQmyWC48zCxEXFjJd6BmsqEZ+pCm5IO2/b1BEZQvePB7/1\nU1+cPvQXLOZprE4yTGJ36rfo5bs0vBmLrpxR57d+tVOxMyLlbc9wPBr64ptntoP0\njaWvYkxN4FisZDQSA/i2jZRjJKRxAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAP\nBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBRqciZ60B7vfec7aVHUbI2fkBJmqzAN\nBgkqhkiG9w0BAQsFAAOCAQEAeZ8dlsa2eT8ijYfThwMEYGprmi5ZiXMRrEPR9RP/\njTkrwPK9T3CMqS/qF8QLVJ7UG5aYMzyorWKiAHarWWluBh1+xLlEjZivEtRh2woZ\nRkfz6/djwUAFQKXSt/S1mja/qYh2iARVBCuch38aNzx+LaUa2NSJXsq9rD1s2G2v\n1fN2D807iDginWyTmsQ9v4IbZT+mD12q/OWyFcq1rca8PdCE6OoGcrBNOTJ4vz4R\nnAuknZoh8/CbCzB428Hch0P+vGOaysXCHMnHjf87ElgI5rY97HosTvuDls4MPGmH\nVHOkc8KT/1EQrBVUAdj8BbGJoX90g5pJ19xOe4pIb4tF9g==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 1246989352 (0x4a538c28)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2009 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - G2\n        Validity\n            Not Before: Jul  7 17:25:54 2009 GMT\n            Not After : Dec  7 17:55:54 2030 GMT\n        Subject: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2009 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - G2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:ba:84:b6:72:db:9e:0c:6b:e2:99:e9:30:01:a7:\n                    76:ea:32:b8:95:41:1a:c9:da:61:4e:58:72:cf:fe:\n                    f6:82:79:bf:73:61:06:0a:a5:27:d8:b3:5f:d3:45:\n                    4e:1c:72:d6:4e:32:f2:72:8a:0f:f7:83:19:d0:6a:\n                    80:80:00:45:1e:b0:c7:e7:9a:bf:12:57:27:1c:a3:\n                    68:2f:0a:87:bd:6a:6b:0e:5e:65:f3:1c:77:d5:d4:\n                    85:8d:70:21:b4:b3:32:e7:8b:a2:d5:86:39:02:b1:\n                    b8:d2:47:ce:e4:c9:49:c4:3b:a7:de:fb:54:7d:57:\n                    be:f0:e8:6e:c2:79:b2:3a:0b:55:e2:50:98:16:32:\n                    13:5c:2f:78:56:c1:c2:94:b3:f2:5a:e4:27:9a:9f:\n                    24:d7:c6:ec:d0:9b:25:82:e3:cc:c2:c4:45:c5:8c:\n                    97:7a:06:6b:2a:11:9f:a9:0a:6e:48:3b:6f:db:d4:\n                    11:19:42:f7:8f:07:bf:f5:53:5f:9c:3e:f4:17:2c:\n                    e6:69:ac:4e:32:4c:62:77:ea:b7:e8:e5:bb:34:bc:\n                    19:8b:ae:9c:51:e7:b7:7e:b5:53:b1:33:22:e5:6d:\n                    cf:70:3c:1a:fa:e2:9b:67:b6:83:f4:8d:a5:af:62:\n                    4c:4d:e0:58:ac:64:34:12:03:f8:b6:8d:94:63:24:\n                    a4:71\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                6A:72:26:7A:D0:1E:EF:7D:E7:3B:69:51:D4:6C:8D:9F:90:12:66:AB\n    Signature Algorithm: sha256WithRSAEncryption\n         79:9f:1d:96:c6:b6:79:3f:22:8d:87:d3:87:03:04:60:6a:6b:\n         9a:2e:59:89:73:11:ac:43:d1:f5:13:ff:8d:39:2b:c0:f2:bd:\n         4f:70:8c:a9:2f:ea:17:c4:0b:54:9e:d4:1b:96:98:33:3c:a8:\n         ad:62:a2:00:76:ab:59:69:6e:06:1d:7e:c4:b9:44:8d:98:af:\n         12:d4:61:db:0a:19:46:47:f3:eb:f7:63:c1:40:05:40:a5:d2:\n         b7:f4:b5:9a:36:bf:a9:88:76:88:04:55:04:2b:9c:87:7f:1a:\n         37:3c:7e:2d:a5:1a:d8:d4:89:5e:ca:bd:ac:3d:6c:d8:6d:af:\n         d5:f3:76:0f:cd:3b:88:38:22:9d:6c:93:9a:c4:3d:bf:82:1b:\n         65:3f:a6:0f:5d:aa:fc:e5:b2:15:ca:b5:ad:c6:bc:3d:d0:84:\n         e8:ea:06:72:b0:4d:39:32:78:bf:3e:11:9c:0b:a4:9d:9a:21:\n         f3:f0:9b:0b:30:78:db:c1:dc:87:43:fe:bc:63:9a:ca:c5:c2:\n         1c:c9:c7:8d:ff:3b:12:58:08:e6:b6:3d:ec:7a:2c:4e:fb:83:\n         96:ce:0c:3c:69:87:54:73:a4:73:c2:93:ff:51:10:ac:15:54:\n         01:d8:fc:05:b1:89:a1:7f:74:83:9a:49:d7:dc:4e:7b:8a:48:\n         6f:8b:45:f6\nSHA1 Fingerprint=8C:F4:27:FD:79:0C:3A:D1:66:06:8D:E8:1E:57:EF:BB:93:22:72:D4\n",
    "711567c8c8c9bd755d72d038186a9df37124540b": "-----BEGIN CERTIFICATE-----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\nvm9qp/UsQu0yrbYhnr68\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 0 (0x0)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=GR, L=Athens, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions RootCA 2015\n        Validity\n            Not Before: Jul  7 10:11:21 2015 GMT\n            Not After : Jun 30 10:11:21 2040 GMT\n        Subject: C=GR, L=Athens, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions RootCA 2015\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:c2:f8:a9:3f:1b:89:fc:3c:3c:04:5d:3d:90:36:\n                    b0:91:3a:79:3c:66:5a:ef:6d:39:01:49:1a:b4:b7:\n                    cf:7f:4d:23:53:b7:90:00:e3:13:2a:28:a6:31:f1:\n                    91:00:e3:28:ec:ae:21:41:ce:1f:da:fd:7d:12:5b:\n                    01:83:0f:b9:b0:5f:99:e1:f2:12:83:80:4d:06:3e:\n                    df:ac:af:e7:a1:88:6b:31:af:f0:8b:d0:18:33:b8:\n                    db:45:6a:34:f4:02:80:24:28:0a:02:15:95:5e:76:\n                    2a:0d:99:3a:14:5b:f6:cb:cb:53:bc:13:4d:01:88:\n                    37:94:25:1b:42:bc:22:d8:8e:a3:96:5e:3a:d9:32:\n                    db:3e:e8:f0:10:65:ed:74:e1:2f:a7:7c:af:27:34:\n                    bb:29:7d:9b:b6:cf:09:c8:e5:d3:0a:fc:88:65:65:\n                    74:0a:dc:73:1c:5c:cd:40:b1:1c:d4:b6:84:8c:4c:\n                    50:cf:68:8e:a8:59:ae:c2:27:4e:82:a2:35:dd:14:\n                    f4:1f:ff:b2:77:d5:87:2f:aa:6e:7d:24:27:e7:c6:\n                    cb:26:e6:e5:fe:67:07:63:d8:45:0d:dd:3a:59:65:\n                    39:58:7a:92:99:72:3d:9c:84:5e:88:21:b8:d5:f4:\n                    2c:fc:d9:70:52:4f:78:b8:bd:3c:2b:8b:95:98:f5:\n                    b3:d1:68:cf:20:14:7e:4c:5c:5f:e7:8b:e5:f5:35:\n                    81:19:37:d7:11:08:b7:66:be:d3:4a:ce:83:57:00:\n                    3a:c3:81:f8:17:cb:92:36:5d:d1:a3:d8:75:1b:e1:\n                    8b:27:ea:7a:48:41:fd:45:19:06:ad:27:99:4e:c1:\n                    70:47:dd:b5:9f:81:53:12:e5:b1:8c:48:5d:31:43:\n                    17:e3:8c:c6:7a:63:96:4b:29:30:4e:84:4e:62:19:\n                    5e:3c:ce:97:90:a5:7f:01:eb:9d:e0:f8:8b:89:dd:\n                    25:98:3d:92:b6:7e:ef:d9:f1:51:51:7d:2d:26:c8:\n                    69:59:61:e0:ac:6a:b8:2a:36:11:04:7a:50:bd:32:\n                    84:be:2f:dc:72:d5:d7:1d:16:47:e4:47:66:20:3f:\n                    f4:96:c5:af:8e:01:7a:a5:0f:7a:64:f5:0d:18:87:\n                    d9:ae:88:d5:fa:84:c1:3a:c0:69:28:2d:f2:0d:68:\n                    51:aa:e3:a5:77:c6:a4:90:0e:a1:37:8b:31:23:47:\n                    c1:09:08:eb:6e:f7:78:9b:d7:82:fc:84:20:99:49:\n                    19:b6:12:46:b1:fb:45:55:16:a9:a3:65:ac:9c:07:\n                    0f:ea:6b:dc:1f:2e:06:72:ec:86:88:12:e4:2d:db:\n                    5f:05:2f:e4:f0:03:d3:26:33:e7:80:c2:cd:42:a1:\n                    17:34:0b\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                71:15:67:C8:C8:C9:BD:75:5D:72:D0:38:18:6A:9D:F3:71:24:54:0B\n    Signature Algorithm: sha256WithRSAEncryption\n         75:bb:6d:54:4b:aa:10:58:46:34:f2:62:d7:16:36:5d:08:5e:\n         d5:6c:c8:87:bd:b4:2e:46:f2:31:f8:7c:ea:42:b5:93:16:55:\n         dc:a1:0c:12:a0:da:61:7e:0f:58:58:73:64:72:c7:e8:45:8e:\n         dc:a9:f2:26:3f:c6:79:8c:b1:53:08:33:81:b0:56:13:be:e6:\n         51:5c:d8:9b:0a:4f:4b:9c:56:53:02:e9:4f:f6:0d:60:ea:4d:\n         42:55:e8:7c:1b:21:21:d3:1b:3a:cc:77:f2:b8:90:f1:68:c7:\n         f9:5a:fe:fa:2d:f4:bf:c9:f5:45:1b:ce:38:10:2a:37:8a:79:\n         a3:b4:e3:09:6c:85:86:93:ff:89:96:27:78:81:8f:67:e3:46:\n         74:54:8e:d9:0d:69:e2:4a:f4:4d:74:03:ff:b2:77:ed:95:67:\n         97:e4:b1:c5:ab:bf:6a:23:e8:d4:94:e2:44:28:62:c4:4b:e2:\n         f0:d8:e2:29:6b:1a:70:7e:24:61:93:7b:4f:03:32:25:0d:45:\n         24:2b:96:b4:46:6a:bf:4a:0b:f7:9a:8f:c1:ac:1a:c5:67:f3:\n         6f:34:d2:fa:73:63:8c:ef:16:b0:a8:a4:46:2a:f8:eb:12:ec:\n         72:b4:ef:f8:2b:7e:8c:52:c0:8b:84:54:f9:2f:3e:e3:55:a8:\n         dc:66:b1:d9:e1:5f:d8:b3:8c:59:34:59:a4:ab:4f:6c:bb:1f:\n         18:db:75:ab:d8:cb:92:cd:94:38:61:0e:07:06:1f:4b:46:10:\n         f1:15:be:8d:85:5c:3b:4a:2b:81:79:0f:b4:69:9f:49:50:97:\n         4d:f7:0e:56:5d:c0:95:6a:c2:36:c3:1b:68:c9:f5:2a:dc:47:\n         9a:be:b2:ce:c5:25:e8:fa:03:b9:da:f9:16:6e:91:84:f5:1c:\n         28:c8:fc:26:cc:d7:1c:90:56:a7:5f:6f:3a:04:bc:cd:78:89:\n         0b:8e:0f:2f:a3:aa:4f:a2:1b:12:3d:16:08:40:0f:f1:46:4c:\n         d7:aa:7b:08:c1:0a:f5:6d:27:de:02:8f:ca:c3:b5:2b:ca:e9:\n         eb:c8:21:53:38:a5:cc:3b:d8:77:37:30:a2:4f:d9:6f:d1:f2:\n         40:ad:41:7a:17:c5:d6:4a:35:89:b7:41:d5:7c:86:7f:55:4d:\n         83:4a:a5:73:20:c0:3a:af:90:f1:9a:24:8e:d9:8e:71:ca:7b:\n         b8:86:da:b2:8f:99:3e:1d:13:0d:12:11:ee:d4:ab:f0:e9:15:\n         76:02:e4:e0:df:aa:20:1e:5b:61:85:64:40:a9:90:97:0d:ad:\n         53:d2:5a:1d:87:6a:00:97:65:62:b4:be:6f:6a:a7:f5:2c:42:\n         ed:32:ad:b6:21:9e:be:bc\nSHA1 Fingerprint=01:0C:06:95:A6:98:19:14:FF:BF:5F:C6:B0:B6:95:EA:29:E9:12:A6\n",
    "7571a7194819bc9d9dea4147df94c4487799d379": "-----BEGIN CERTIFICATE-----\nMIICiTCCAg+gAwIBAgIQH0evqmIAcFBUTAGem2OZKjAKBggqhkjOPQQDAzCBhTEL\nMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UE\nBxMHU2FsZm9yZDEaMBgGA1UEChMRQ09NT0RPIENBIExpbWl0ZWQxKzApBgNVBAMT\nIkNPTU9ETyBFQ0MgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMDgwMzA2MDAw\nMDAwWhcNMzgwMTE4MjM1OTU5WjCBhTELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdy\nZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBxMHU2FsZm9yZDEaMBgGA1UEChMRQ09N\nT0RPIENBIExpbWl0ZWQxKzApBgNVBAMTIkNPTU9ETyBFQ0MgQ2VydGlmaWNhdGlv\nbiBBdXRob3JpdHkwdjAQBgcqhkjOPQIBBgUrgQQAIgNiAAQDR3svdcmCFYX7deSR\nFtSrYpn1PlILBs5BAH+X4QokPB0BBO490o0JlwzgdeT6+3eKKvUDYEs2ixYjFq0J\ncfRK9ChQtP6IHG4/bC8vCVlbpVsLM5niwz2J+Wos77LTBumjQjBAMB0GA1UdDgQW\nBBR1cacZSBm8nZ3qQUfflMRId5nTeTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/\nBAUwAwEB/zAKBggqhkjOPQQDAwNoADBlAjEA7wNbeqy3eApyt4jf/7VGFAkK+qDm\nfQjGGoe9GKhzvSbKYAydzpmfz1wPMOG+FDHqAjAU9JM8SaczepBGR7NjfRObTrdv\nGDeAU/7dIOA1mjbRxwG55tzd8/8dLDoWV9mSOdY=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            1f:47:af:aa:62:00:70:50:54:4c:01:9e:9b:63:99:2a\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO ECC Certification Authority\n        Validity\n            Not Before: Mar  6 00:00:00 2008 GMT\n            Not After : Jan 18 23:59:59 2038 GMT\n        Subject: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO ECC Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:03:47:7b:2f:75:c9:82:15:85:fb:75:e4:91:16:\n                    d4:ab:62:99:f5:3e:52:0b:06:ce:41:00:7f:97:e1:\n                    0a:24:3c:1d:01:04:ee:3d:d2:8d:09:97:0c:e0:75:\n                    e4:fa:fb:77:8a:2a:f5:03:60:4b:36:8b:16:23:16:\n                    ad:09:71:f4:4a:f4:28:50:b4:fe:88:1c:6e:3f:6c:\n                    2f:2f:09:59:5b:a5:5b:0b:33:99:e2:c3:3d:89:f9:\n                    6a:2c:ef:b2:d3:06:e9\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                75:71:A7:19:48:19:BC:9D:9D:EA:41:47:DF:94:C4:48:77:99:D3:79\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: ecdsa-with-SHA384\n         30:65:02:31:00:ef:03:5b:7a:ac:b7:78:0a:72:b7:88:df:ff:\n         b5:46:14:09:0a:fa:a0:e6:7d:08:c6:1a:87:bd:18:a8:73:bd:\n         26:ca:60:0c:9d:ce:99:9f:cf:5c:0f:30:e1:be:14:31:ea:02:\n         30:14:f4:93:3c:49:a7:33:7a:90:46:47:b3:63:7d:13:9b:4e:\n         b7:6f:18:37:80:53:fe:dd:20:e0:35:9a:36:d1:c7:01:b9:e6:\n         dc:dd:f3:ff:1d:2c:3a:16:57:d9:92:39:d6\nSHA1 Fingerprint=9F:74:4E:9F:2B:4D:BA:EC:0F:31:2C:50:B6:56:3B:8E:2D:93:C3:11\n",
    "79b459e67bb6e5e40173800888c81a58f6e99b6e": "-----BEGIN CERTIFICATE-----\nMIIFazCCA1OgAwIBAgIRAIIQz7DSQONZRGPgu2OCiwAwDQYJKoZIhvcNAQELBQAw\nTzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybmV0IFNlY3VyaXR5IFJlc2Vh\ncmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMTUwNjA0MTEwNDM4\nWhcNMzUwNjA0MTEwNDM4WjBPMQswCQYDVQQGEwJVUzEpMCcGA1UEChMgSW50ZXJu\nZXQgU2VjdXJpdHkgUmVzZWFyY2ggR3JvdXAxFTATBgNVBAMTDElTUkcgUm9vdCBY\nMTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAK3oJHP0FDfzm54rVygc\nh77ct984kIxuPOZXoHj3dcKi/vVqbvYATyjb3miGbESTtrFj/RQSa78f0uoxmyF+\n0TM8ukj13Xnfs7j/EvEhmkvBioZxaUpmZmyPfjxwv60pIgbz5MDmgK7iS4+3mX6U\nA5/TR5d8mUgjU+g4rk8Kb4Mu0UlXjIB0ttov0DiNewNwIRt18jA8+o+u3dpjq+sW\nT8KOEUt+zwvo/7V3LvSye0rgTBIlDHCNAymg4VMk7BPZ7hm/ELNKjD+Jo2FR3qyH\nB5T0Y3HsLuJvW5iB4YlcNHlsdu87kGJ55tukmi8mxdAQ4Q7e2RCOFvu396j3x+UC\nB5iPNgiV5+I3lg02dZ77DnKxHZu8A/lJBdiB3QW0KtZB6awBdpUKD9jf1b0SHzUv\nKBds0pjBqAlkd25HN7rOrFleaJ1/ctaJxQZBKT5ZPt0m9STJEadao0xAH0ahmbWn\nOlFuhjuefXKnEgV4We0+UXgVCwOPjdAvBbI+e0ocS3MFEvzG6uBQE3xDk3SzynTn\njh8BCNAw1FtxNrQHusEwMFxIt4I7mKZ9YIqioymCzLq9gwQbooMDQaHWBfEbwrbw\nqHyGO0aoSCqI3Haadr8faqU9GY/rOPNk3sgrDQoo//fb4hVC1CLQJ13hef4Y53CI\nrU7m2Ys6xt0nUW7/vGT1M0NPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNV\nHRMBAf8EBTADAQH/MB0GA1UdDgQWBBR5tFnme7bl5AFzgAiIyBpY9umbbjANBgkq\nhkiG9w0BAQsFAAOCAgEAVR9YqbyyqFDQDLHYGmkgJykIrGF1XIpu+ILlaS/V9lZL\nubhzEFnTIZd+50xx+7LSYK05qAvqFyFWhfFQDlnrzuBZ6brJFe+GnY+EgPbk6ZGQ\n3BebYhtF8GaV0nxvwuo77x/Py9auJ/GpsMiu/X1+mvoiBOv/2X/qkSsisRcOj/KK\nNFtY2PwByVS5uCbMiogziUwthDyC3+6WVwW6LLv3xLfHTjuCvjHIInNzktHCgKQ5\nORAzI4JMPJ+GslWYHb4phowim57iaztXOoJwTdwJx4nLCgdNbOhdjsnvzqvHu7Ur\nTkXWStAmzOVyyghqpZXjFaH3pO3JLF+l+/+sKAIuvtd7u+Nxe5AW0wdeRlN8NwdC\njNPElpzVmbUq4JUagEiuTDkHzsxHpFKVK7q4+63SM1N95R1NbdWhscdCb+ZAJzVc\noyi3B43njTOQ5yOf+1CceWxG1bQVs5ZufpsMljq4Ui0/1lvh+wjChP4kqKOJ2qxq\n4RgqsahDYVvTH9w7jXbyLeiNdd8XM2w9U/t7y0Ff/9yi0GE44Za4rF2LN9d11TPA\nmRGunUHBcnWEvgJBQl9nJEiU0Zsnvgc/ubhPgXRR4Xq37Z0j4r7g1SgEEzwxA57d\nemyPxgcYxn/eR44/KJ4EBs+lVDR3veyJm+kXQ99b21/+jh5Xos1AnX5iItreGCc=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            82:10:cf:b0:d2:40:e3:59:44:63:e0:bb:63:82:8b:00\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, O=Internet Security Research Group, CN=ISRG Root X1\n        Validity\n            Not Before: Jun  4 11:04:38 2015 GMT\n            Not After : Jun  4 11:04:38 2035 GMT\n        Subject: C=US, O=Internet Security Research Group, CN=ISRG Root X1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:ad:e8:24:73:f4:14:37:f3:9b:9e:2b:57:28:1c:\n                    87:be:dc:b7:df:38:90:8c:6e:3c:e6:57:a0:78:f7:\n                    75:c2:a2:fe:f5:6a:6e:f6:00:4f:28:db:de:68:86:\n                    6c:44:93:b6:b1:63:fd:14:12:6b:bf:1f:d2:ea:31:\n                    9b:21:7e:d1:33:3c:ba:48:f5:dd:79:df:b3:b8:ff:\n                    12:f1:21:9a:4b:c1:8a:86:71:69:4a:66:66:6c:8f:\n                    7e:3c:70:bf:ad:29:22:06:f3:e4:c0:e6:80:ae:e2:\n                    4b:8f:b7:99:7e:94:03:9f:d3:47:97:7c:99:48:23:\n                    53:e8:38:ae:4f:0a:6f:83:2e:d1:49:57:8c:80:74:\n                    b6:da:2f:d0:38:8d:7b:03:70:21:1b:75:f2:30:3c:\n                    fa:8f:ae:dd:da:63:ab:eb:16:4f:c2:8e:11:4b:7e:\n                    cf:0b:e8:ff:b5:77:2e:f4:b2:7b:4a:e0:4c:12:25:\n                    0c:70:8d:03:29:a0:e1:53:24:ec:13:d9:ee:19:bf:\n                    10:b3:4a:8c:3f:89:a3:61:51:de:ac:87:07:94:f4:\n                    63:71:ec:2e:e2:6f:5b:98:81:e1:89:5c:34:79:6c:\n                    76:ef:3b:90:62:79:e6:db:a4:9a:2f:26:c5:d0:10:\n                    e1:0e:de:d9:10:8e:16:fb:b7:f7:a8:f7:c7:e5:02:\n                    07:98:8f:36:08:95:e7:e2:37:96:0d:36:75:9e:fb:\n                    0e:72:b1:1d:9b:bc:03:f9:49:05:d8:81:dd:05:b4:\n                    2a:d6:41:e9:ac:01:76:95:0a:0f:d8:df:d5:bd:12:\n                    1f:35:2f:28:17:6c:d2:98:c1:a8:09:64:77:6e:47:\n                    37:ba:ce:ac:59:5e:68:9d:7f:72:d6:89:c5:06:41:\n                    29:3e:59:3e:dd:26:f5:24:c9:11:a7:5a:a3:4c:40:\n                    1f:46:a1:99:b5:a7:3a:51:6e:86:3b:9e:7d:72:a7:\n                    12:05:78:59:ed:3e:51:78:15:0b:03:8f:8d:d0:2f:\n                    05:b2:3e:7b:4a:1c:4b:73:05:12:fc:c6:ea:e0:50:\n                    13:7c:43:93:74:b3:ca:74:e7:8e:1f:01:08:d0:30:\n                    d4:5b:71:36:b4:07:ba:c1:30:30:5c:48:b7:82:3b:\n                    98:a6:7d:60:8a:a2:a3:29:82:cc:ba:bd:83:04:1b:\n                    a2:83:03:41:a1:d6:05:f1:1b:c2:b6:f0:a8:7c:86:\n                    3b:46:a8:48:2a:88:dc:76:9a:76:bf:1f:6a:a5:3d:\n                    19:8f:eb:38:f3:64:de:c8:2b:0d:0a:28:ff:f7:db:\n                    e2:15:42:d4:22:d0:27:5d:e1:79:fe:18:e7:70:88:\n                    ad:4e:e6:d9:8b:3a:c6:dd:27:51:6e:ff:bc:64:f5:\n                    33:43:4f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                79:B4:59:E6:7B:B6:E5:E4:01:73:80:08:88:C8:1A:58:F6:E9:9B:6E\n    Signature Algorithm: sha256WithRSAEncryption\n         55:1f:58:a9:bc:b2:a8:50:d0:0c:b1:d8:1a:69:20:27:29:08:\n         ac:61:75:5c:8a:6e:f8:82:e5:69:2f:d5:f6:56:4b:b9:b8:73:\n         10:59:d3:21:97:7e:e7:4c:71:fb:b2:d2:60:ad:39:a8:0b:ea:\n         17:21:56:85:f1:50:0e:59:eb:ce:e0:59:e9:ba:c9:15:ef:86:\n         9d:8f:84:80:f6:e4:e9:91:90:dc:17:9b:62:1b:45:f0:66:95:\n         d2:7c:6f:c2:ea:3b:ef:1f:cf:cb:d6:ae:27:f1:a9:b0:c8:ae:\n         fd:7d:7e:9a:fa:22:04:eb:ff:d9:7f:ea:91:2b:22:b1:17:0e:\n         8f:f2:8a:34:5b:58:d8:fc:01:c9:54:b9:b8:26:cc:8a:88:33:\n         89:4c:2d:84:3c:82:df:ee:96:57:05:ba:2c:bb:f7:c4:b7:c7:\n         4e:3b:82:be:31:c8:22:73:73:92:d1:c2:80:a4:39:39:10:33:\n         23:82:4c:3c:9f:86:b2:55:98:1d:be:29:86:8c:22:9b:9e:e2:\n         6b:3b:57:3a:82:70:4d:dc:09:c7:89:cb:0a:07:4d:6c:e8:5d:\n         8e:c9:ef:ce:ab:c7:bb:b5:2b:4e:45:d6:4a:d0:26:cc:e5:72:\n         ca:08:6a:a5:95:e3:15:a1:f7:a4:ed:c9:2c:5f:a5:fb:ff:ac:\n         28:02:2e:be:d7:7b:bb:e3:71:7b:90:16:d3:07:5e:46:53:7c:\n         37:07:42:8c:d3:c4:96:9c:d5:99:b5:2a:e0:95:1a:80:48:ae:\n         4c:39:07:ce:cc:47:a4:52:95:2b:ba:b8:fb:ad:d2:33:53:7d:\n         e5:1d:4d:6d:d5:a1:b1:c7:42:6f:e6:40:27:35:5c:a3:28:b7:\n         07:8d:e7:8d:33:90:e7:23:9f:fb:50:9c:79:6c:46:d5:b4:15:\n         b3:96:6e:7e:9b:0c:96:3a:b8:52:2d:3f:d6:5b:e1:fb:08:c2:\n         84:fe:24:a8:a3:89:da:ac:6a:e1:18:2a:b1:a8:43:61:5b:d3:\n         1f:dc:3b:8d:76:f2:2d:e8:8d:75:df:17:33:6c:3d:53:fb:7b:\n         cb:41:5f:ff:dc:a2:d0:61:38:e1:96:b8:ac:5d:8b:37:d7:75:\n         d5:33:c0:99:11:ae:9d:41:c1:72:75:84:be:02:41:42:5f:67:\n         24:48:94:d1:9b:27:be:07:3f:b9:b8:4f:81:74:51:e1:7a:b7:\n         ed:9d:23:e2:be:e0:d5:28:04:13:3c:31:03:9e:dd:7a:6c:8f:\n         c6:07:18:c6:7f:de:47:8e:3f:28:9e:04:06:cf:a5:54:34:77:\n         bd:ec:89:9b:e9:17:43:df:5b:db:5f:fe:8e:1e:57:a2:cd:40:\n         9d:7e:62:22:da:de:18:27\nSHA1 Fingerprint=CA:BD:2A:79:A1:07:6A:31:F2:1D:25:36:35:CB:03:9D:43:29:A5:E8\n",
    "7c0c321fa7d9307fc47d68a362a8a1ceab075b27": "-----BEGIN CERTIFICATE-----\nMIID3TCCAsWgAwIBAgIBADANBgkqhkiG9w0BAQsFADCBjzELMAkGA1UEBhMCVVMx\nEDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxJTAjBgNVBAoT\nHFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xMjAwBgNVBAMTKVN0YXJmaWVs\nZCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTA5MDkwMTAwMDAw\nMFoXDTM3MTIzMTIzNTk1OVowgY8xCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6\nb25hMRMwEQYDVQQHEwpTY290dHNkYWxlMSUwIwYDVQQKExxTdGFyZmllbGQgVGVj\naG5vbG9naWVzLCBJbmMuMTIwMAYDVQQDEylTdGFyZmllbGQgUm9vdCBDZXJ0aWZp\nY2F0ZSBBdXRob3JpdHkgLSBHMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\nggEBAL3twQP89o/8ArFvW59I2Z154qK3A2FWGMNHttfKPTUuiUP3oWmb3ooa/RMg\nnLRJdzIpVv257IzdIvpy3Cdhl+72WoTsbhm5iSzchFvVdPtrX8WJpRBSiUZV9Lh1\nHOZ/5FSuS/hVclcCGfgXcVnrHigHdMWdSL5stPSksPNkN3mSwOxGXn/hbVNMYq/N\nHwtjuzqd+/x5AJhhdM8mgkBj87JyahkNmcrUDnXMN/uLicFZ8WJ/X7NfZTD4p7dN\ndloedl40wOiWVpmKs/B/pM293DIxfJHP4F8R+GuqSVzRmZTRouNjWwl2tVZi4Ut0\nHZbUJtQIBFnQmA4O5t78w+wfkPECAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAO\nBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFHwMMh+n2TB/xH1oo2Kooc6rB1snMA0G\nCSqGSIb3DQEBCwUAA4IBAQARWfolTwNvlJk7mh+ChTnUdgWUXuEok21iXQnCoKjU\nsHU48TRqneSfioYmUeYs0cYtbpUgSpIB7LiKZ3sx4mcujJUDJi5DnUox9g61DLu3\n4jd/IroAow57UvtruzvE03lRTs2Q9GcHGcg8RnoNAX3FWOdt5oUwF5okxBDgBPfg\n8n/Uqgr/Qh037ZTlZFkSIHc40zI+OIF1lnP6aI+xy84fxez6nH7PfrHxBy22/L/K\npL/QlwVKvOoYKAKQvVR4CSFx09F9HdkWsKlhPdAKACL8x3vLCWRFCztAgfd9fDL1\nmMpYjn0q7pBZc2T5NnReJaH1ZgUufzkVqSr7UIuOhWn0\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 0 (0x0)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Root Certificate Authority - G2\n        Validity\n            Not Before: Sep  1 00:00:00 2009 GMT\n            Not After : Dec 31 23:59:59 2037 GMT\n        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Root Certificate Authority - G2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:bd:ed:c1:03:fc:f6:8f:fc:02:b1:6f:5b:9f:48:\n                    d9:9d:79:e2:a2:b7:03:61:56:18:c3:47:b6:d7:ca:\n                    3d:35:2e:89:43:f7:a1:69:9b:de:8a:1a:fd:13:20:\n                    9c:b4:49:77:32:29:56:fd:b9:ec:8c:dd:22:fa:72:\n                    dc:27:61:97:ee:f6:5a:84:ec:6e:19:b9:89:2c:dc:\n                    84:5b:d5:74:fb:6b:5f:c5:89:a5:10:52:89:46:55:\n                    f4:b8:75:1c:e6:7f:e4:54:ae:4b:f8:55:72:57:02:\n                    19:f8:17:71:59:eb:1e:28:07:74:c5:9d:48:be:6c:\n                    b4:f4:a4:b0:f3:64:37:79:92:c0:ec:46:5e:7f:e1:\n                    6d:53:4c:62:af:cd:1f:0b:63:bb:3a:9d:fb:fc:79:\n                    00:98:61:74:cf:26:82:40:63:f3:b2:72:6a:19:0d:\n                    99:ca:d4:0e:75:cc:37:fb:8b:89:c1:59:f1:62:7f:\n                    5f:b3:5f:65:30:f8:a7:b7:4d:76:5a:1e:76:5e:34:\n                    c0:e8:96:56:99:8a:b3:f0:7f:a4:cd:bd:dc:32:31:\n                    7c:91:cf:e0:5f:11:f8:6b:aa:49:5c:d1:99:94:d1:\n                    a2:e3:63:5b:09:76:b5:56:62:e1:4b:74:1d:96:d4:\n                    26:d4:08:04:59:d0:98:0e:0e:e6:de:fc:c3:ec:1f:\n                    90:f1\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                7C:0C:32:1F:A7:D9:30:7F:C4:7D:68:A3:62:A8:A1:CE:AB:07:5B:27\n    Signature Algorithm: sha256WithRSAEncryption\n         11:59:fa:25:4f:03:6f:94:99:3b:9a:1f:82:85:39:d4:76:05:\n         94:5e:e1:28:93:6d:62:5d:09:c2:a0:a8:d4:b0:75:38:f1:34:\n         6a:9d:e4:9f:8a:86:26:51:e6:2c:d1:c6:2d:6e:95:20:4a:92:\n         01:ec:b8:8a:67:7b:31:e2:67:2e:8c:95:03:26:2e:43:9d:4a:\n         31:f6:0e:b5:0c:bb:b7:e2:37:7f:22:ba:00:a3:0e:7b:52:fb:\n         6b:bb:3b:c4:d3:79:51:4e:cd:90:f4:67:07:19:c8:3c:46:7a:\n         0d:01:7d:c5:58:e7:6d:e6:85:30:17:9a:24:c4:10:e0:04:f7:\n         e0:f2:7f:d4:aa:0a:ff:42:1d:37:ed:94:e5:64:59:12:20:77:\n         38:d3:32:3e:38:81:75:96:73:fa:68:8f:b1:cb:ce:1f:c5:ec:\n         fa:9c:7e:cf:7e:b1:f1:07:2d:b6:fc:bf:ca:a4:bf:d0:97:05:\n         4a:bc:ea:18:28:02:90:bd:54:78:09:21:71:d3:d1:7d:1d:d9:\n         16:b0:a9:61:3d:d0:0a:00:22:fc:c7:7b:cb:09:64:45:0b:3b:\n         40:81:f7:7d:7c:32:f5:98:ca:58:8e:7d:2a:ee:90:59:73:64:\n         f9:36:74:5e:25:a1:f5:66:05:2e:7f:39:15:a9:2a:fb:50:8b:\n         8e:85:69:f4\nSHA1 Fingerprint=B5:1C:06:7C:EE:2B:0C:3D:F8:55:AB:2D:92:F4:FE:39:D4:E7:0F:0E\n",
    "7c5d028413d4cc8a9b81ce171c2e291e9c486342": "-----BEGIN CERTIFICATE-----\nMIICTjCCAdOgAwIBAgIKPPYHqWhwDtqLhDAKBggqhkjOPQQDAzBrMQswCQYDVQQG\nEwJJTjETMBEGA1UECxMKZW1TaWduIFBLSTElMCMGA1UEChMcZU11ZGhyYSBUZWNo\nbm9sb2dpZXMgTGltaXRlZDEgMB4GA1UEAxMXZW1TaWduIEVDQyBSb290IENBIC0g\nRzMwHhcNMTgwMjE4MTgzMDAwWhcNNDMwMjE4MTgzMDAwWjBrMQswCQYDVQQGEwJJ\nTjETMBEGA1UECxMKZW1TaWduIFBLSTElMCMGA1UEChMcZU11ZGhyYSBUZWNobm9s\nb2dpZXMgTGltaXRlZDEgMB4GA1UEAxMXZW1TaWduIEVDQyBSb290IENBIC0gRzMw\ndjAQBgcqhkjOPQIBBgUrgQQAIgNiAAQjpQy4LRL1KPOxst3iAhKAnjlfSU2fySU0\nWXTsuwYc58Byr+iuL+FBVIcUqEqy6HyC5ltqtdyzdc6LBtCGI79G1Y4PPwT01xyS\nfvalY8L1X44uT6EYGQIrMgqCZH0Wk9GjQjBAMB0GA1UdDgQWBBR8XQKEE9TMipuB\nzhccLikenEhjQjAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAKBggq\nhkjOPQQDAwNpADBmAjEAvvNhzwIQHWSVB7gYboiFBS+DCBeQyh+KTOgNG3qxrdWB\nCUfvO6wIBHxcmbHtRwfSAjEAnbpV/KlK6O3t5nYBQnvI+GDZjVGLVTv7jHvrZQnD\n+JbNR6iC8hZVdyR+EhCVBCyj\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            3c:f6:07:a9:68:70:0e:da:8b:84\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=IN, OU=emSign PKI, O=eMudhra Technologies Limited, CN=emSign ECC Root CA - G3\n        Validity\n            Not Before: Feb 18 18:30:00 2018 GMT\n            Not After : Feb 18 18:30:00 2043 GMT\n        Subject: C=IN, OU=emSign PKI, O=eMudhra Technologies Limited, CN=emSign ECC Root CA - G3\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:23:a5:0c:b8:2d:12:f5:28:f3:b1:b2:dd:e2:02:\n                    12:80:9e:39:5f:49:4d:9f:c9:25:34:59:74:ec:bb:\n                    06:1c:e7:c0:72:af:e8:ae:2f:e1:41:54:87:14:a8:\n                    4a:b2:e8:7c:82:e6:5b:6a:b5:dc:b3:75:ce:8b:06:\n                    d0:86:23:bf:46:d5:8e:0f:3f:04:f4:d7:1c:92:7e:\n                    f6:a5:63:c2:f5:5f:8e:2e:4f:a1:18:19:02:2b:32:\n                    0a:82:64:7d:16:93:d1\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                7C:5D:02:84:13:D4:CC:8A:9B:81:CE:17:1C:2E:29:1E:9C:48:63:42\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: ecdsa-with-SHA384\n         30:66:02:31:00:be:f3:61:cf:02:10:1d:64:95:07:b8:18:6e:\n         88:85:05:2f:83:08:17:90:ca:1f:8a:4c:e8:0d:1b:7a:b1:ad:\n         d5:81:09:47:ef:3b:ac:08:04:7c:5c:99:b1:ed:47:07:d2:02:\n         31:00:9d:ba:55:fc:a9:4a:e8:ed:ed:e6:76:01:42:7b:c8:f8:\n         60:d9:8d:51:8b:55:3b:fb:8c:7b:eb:65:09:c3:f8:96:cd:47:\n         a8:82:f2:16:55:77:24:7e:12:10:95:04:2c:a3\nSHA1 Fingerprint=30:43:FA:4F:F2:57:DC:A0:C3:80:EE:2E:58:EA:78:B2:3F:E6:BB:C1\n",
    "804cd6eb74ff4936a3d5d8fcb53ec56af0941d8c": "-----BEGIN CERTIFICATE-----\nMIICCjCCAZGgAwIBAgIQbkepyIuUtui7OyrYorLBmTAKBggqhkjOPQQDAzBHMQsw\nCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZpY2VzIExMQzEU\nMBIGA1UEAxMLR1RTIFJvb3QgUjQwHhcNMTYwNjIyMDAwMDAwWhcNMzYwNjIyMDAw\nMDAwWjBHMQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZp\nY2VzIExMQzEUMBIGA1UEAxMLR1RTIFJvb3QgUjQwdjAQBgcqhkjOPQIBBgUrgQQA\nIgNiAATzdHOnaItgrkO4NcWBMHtLSZ37wWHO5t5GvWvVYRg1rkDdc/eJkTBa6zzu\nhXyiQHY7qca4R9gq55KRanPpsXI5nymfopjTX15YhmUPoYRlBtHci8nHc8iMai/l\nxKvRHYqjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1Ud\nDgQWBBSATNbrdP9JNqPV2Py1PsVq8JQdjDAKBggqhkjOPQQDAwNnADBkAjBqUFJ0\nCMRw3J5QdCHojXohw0+WbhXRIjVhLfoIN+4Zba3bssx9BzT1YBkstTTZbyACMANx\nsbqjYAuG7ZoIapVon+Kz4ZNkfF6Tpt95LY2F45TPI11xzPKwTdb+mciUqXWi4w==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            6e:47:a9:c8:8b:94:b6:e8:bb:3b:2a:d8:a2:b2:c1:99\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, O=Google Trust Services LLC, CN=GTS Root R4\n        Validity\n            Not Before: Jun 22 00:00:00 2016 GMT\n            Not After : Jun 22 00:00:00 2036 GMT\n        Subject: C=US, O=Google Trust Services LLC, CN=GTS Root R4\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:f3:74:73:a7:68:8b:60:ae:43:b8:35:c5:81:30:\n                    7b:4b:49:9d:fb:c1:61:ce:e6:de:46:bd:6b:d5:61:\n                    18:35:ae:40:dd:73:f7:89:91:30:5a:eb:3c:ee:85:\n                    7c:a2:40:76:3b:a9:c6:b8:47:d8:2a:e7:92:91:6a:\n                    73:e9:b1:72:39:9f:29:9f:a2:98:d3:5f:5e:58:86:\n                    65:0f:a1:84:65:06:d1:dc:8b:c9:c7:73:c8:8c:6a:\n                    2f:e5:c4:ab:d1:1d:8a\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                80:4C:D6:EB:74:FF:49:36:A3:D5:D8:FC:B5:3E:C5:6A:F0:94:1D:8C\n    Signature Algorithm: ecdsa-with-SHA384\n         30:64:02:30:6a:50:52:74:08:c4:70:dc:9e:50:74:21:e8:8d:\n         7a:21:c3:4f:96:6e:15:d1:22:35:61:2d:fa:08:37:ee:19:6d:\n         ad:db:b2:cc:7d:07:34:f5:60:19:2c:b5:34:d9:6f:20:02:30:\n         03:71:b1:ba:a3:60:0b:86:ed:9a:08:6a:95:68:9f:e2:b3:e1:\n         93:64:7c:5e:93:a6:df:79:2d:8d:85:e3:94:cf:23:5d:71:cc:\n         f2:b0:4d:d6:fe:99:c8:94:a9:75:a2:e3\nSHA1 Fingerprint=2A:1D:60:27:D9:4A:B1:0A:1C:4D:91:5C:CD:33:A0:CB:3E:2D:54:CB\n",
    "81c48cccf5e430ffa50c085f8c1567217401dfdf": "-----BEGIN CERTIFICATE-----\nMIIFRjCCAy6gAwIBAgIQXd+x2lqj7V2+WmUgZQOQ7zANBgkqhkiG9w0BAQsFADA9\nMQswCQYDVQQGEwJDTjERMA8GA1UECgwIVW5pVHJ1c3QxGzAZBgNVBAMMElVDQSBH\nbG9iYWwgRzIgUm9vdDAeFw0xNjAzMTEwMDAwMDBaFw00MDEyMzEwMDAwMDBaMD0x\nCzAJBgNVBAYTAkNOMREwDwYDVQQKDAhVbmlUcnVzdDEbMBkGA1UEAwwSVUNBIEds\nb2JhbCBHMiBSb290MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxeYr\nb3zvJgUno4Ek2m/LAfmZmqkywiKHYUGRO8vDaBsGxUypK8FnFyIdK+35KYmToni9\nkmugow2ifsqTs6bRjDXVdfkX9s9FxeV67HeToI8jrg4aA3++1NDtLnurRiNb/yzm\nVHqUwCoV8MmNsHo7JOHXaOIxPAYzRrZUEaalLyJUKlgNAQLx+hVRZ2zA+te2G3/R\nVogvGjqNO7uCEeBHANBSh6v7hn4PJGtAnTRnvI3HLYZveT6OqTwXS3+wmeOwcWDc\nC/Vkw85DvG1xudLeJ1uK6NjGruFZfc8oLTW4lVYa8bJYS7cSN8h8s+1LgOGN+jIj\ntm+3SJUIsUROhYw6AlQgL9+/V087OpAh18EmNVQg7Mc/R+zvWr9LesGtOxdQXGLY\nD0tK3Cv6brxzks3sx1DoQZbXqX5t2Okdj4q1uViSukqSKwxW/YDrCPBeKW4bHAyv\nj5OJrdu9o54hyokZ7N+1wxrrFv54NkzWbtA+FxyQF2smuvt6L78RHBgOLXMDj6Dl\nNaBa4kx1HXHhOThTeEDMg5PXCp6dW4+K5OXgSORIskfNTip1KnvyIvbJvgmRlld6\niIis7nCs+dwp4wwcOxJORNanTrAmyPPZGpeRaOrvjUYG0lZFWJo8DA+DuAUlwznP\nO6Q0ibd5Ei9Hxeepl2n8pndntd978XplFeRhVmUCAwEAAaNCMEAwDgYDVR0PAQH/\nBAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFIHEjMz15DD/pQwIX4wV\nZyF0Ad/fMA0GCSqGSIb3DQEBCwUAA4ICAQATZSL1jiutROTL/7lo5sOASD0Ee/oj\nL3rtNtqyzm325p7lX1iPyzcyochltq44PTUbPrw7tgTQvPlJ9Zv3hcU2tsu8+Mg5\n1eRfB70VVJd0ysrtT7q6ZHafgbiERUlMjW+i67HM0cOU2kTC5uLqGOiiHycFutfl\n1qnN3e92mI0ADs0b+gO3joBYDic/UvuUospeZcnWhNq5NXHzJsBPd+aBJ9J3O5oU\nb3n09tDh05S60FdRvScFDcH9yBIw7m+NESsIndTUv4BFFJqIRNow6rSn4+7vW4LV\nPtateJLbXDzz2K36uGt/xDYotgIVilQsnLAXc47QN6MUPJiVAAwpBVueSUmxX8fj\ny88nZY41F7dXyDDZQVu5FLbowg+UMaeUmMxq67XhJ/UQqAHojhJi6IjMtX9Gl8Cb\nEGY4GjZGXyJoPd/JxhMnq1MGrKI8hgZlb7F+sSlEmqO6SWkoaY/X5V+tBIZkbxqg\nDMUIYs6Ao9Dz7GjevjPHF1t/gMRMTLGmhIrDO7gJzRSBuhjjVFc2/tsvfEehOjPI\n+Vg7RE+xygKJBJYoaMVLuCaJu9YzL1DV/pqJuhgyklTGW+Cd+V7lDSKb9triyCGy\nYiGqhkCyLmTTX8jjfhFnRR8F/uOi77Oos/N9j/gMHyIfLXC0uAE0djAA5SN4p1bX\nUB+K+wb1whnw0A==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            5d:df:b1:da:5a:a3:ed:5d:be:5a:65:20:65:03:90:ef\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=CN, O=UniTrust, CN=UCA Global G2 Root\n        Validity\n            Not Before: Mar 11 00:00:00 2016 GMT\n            Not After : Dec 31 00:00:00 2040 GMT\n        Subject: C=CN, O=UniTrust, CN=UCA Global G2 Root\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:c5:e6:2b:6f:7c:ef:26:05:27:a3:81:24:da:6f:\n                    cb:01:f9:99:9a:a9:32:c2:22:87:61:41:91:3b:cb:\n                    c3:68:1b:06:c5:4c:a9:2b:c1:67:17:22:1d:2b:ed:\n                    f9:29:89:93:a2:78:bd:92:6b:a0:a3:0d:a2:7e:ca:\n                    93:b3:a6:d1:8c:35:d5:75:f9:17:f6:cf:45:c5:e5:\n                    7a:ec:77:93:a0:8f:23:ae:0e:1a:03:7f:be:d4:d0:\n                    ed:2e:7b:ab:46:23:5b:ff:2c:e6:54:7a:94:c0:2a:\n                    15:f0:c9:8d:b0:7a:3b:24:e1:d7:68:e2:31:3c:06:\n                    33:46:b6:54:11:a6:a5:2f:22:54:2a:58:0d:01:02:\n                    f1:fa:15:51:67:6c:c0:fa:d7:b6:1b:7f:d1:56:88:\n                    2f:1a:3a:8d:3b:bb:82:11:e0:47:00:d0:52:87:ab:\n                    fb:86:7e:0f:24:6b:40:9d:34:67:bc:8d:c7:2d:86:\n                    6f:79:3e:8e:a9:3c:17:4b:7f:b0:99:e3:b0:71:60:\n                    dc:0b:f5:64:c3:ce:43:bc:6d:71:b9:d2:de:27:5b:\n                    8a:e8:d8:c6:ae:e1:59:7d:cf:28:2d:35:b8:95:56:\n                    1a:f1:b2:58:4b:b7:12:37:c8:7c:b3:ed:4b:80:e1:\n                    8d:fa:32:23:b6:6f:b7:48:95:08:b1:44:4e:85:8c:\n                    3a:02:54:20:2f:df:bf:57:4f:3b:3a:90:21:d7:c1:\n                    26:35:54:20:ec:c7:3f:47:ec:ef:5a:bf:4b:7a:c1:\n                    ad:3b:17:50:5c:62:d8:0f:4b:4a:dc:2b:fa:6e:bc:\n                    73:92:cd:ec:c7:50:e8:41:96:d7:a9:7e:6d:d8:e9:\n                    1d:8f:8a:b5:b9:58:92:ba:4a:92:2b:0c:56:fd:80:\n                    eb:08:f0:5e:29:6e:1b:1c:0c:af:8f:93:89:ad:db:\n                    bd:a3:9e:21:ca:89:19:ec:df:b5:c3:1a:eb:16:fe:\n                    78:36:4c:d6:6e:d0:3e:17:1c:90:17:6b:26:ba:fb:\n                    7a:2f:bf:11:1c:18:0e:2d:73:03:8f:a0:e5:35:a0:\n                    5a:e2:4c:75:1d:71:e1:39:38:53:78:40:cc:83:93:\n                    d7:0a:9e:9d:5b:8f:8a:e4:e5:e0:48:e4:48:b2:47:\n                    cd:4e:2a:75:2a:7b:f2:22:f6:c9:be:09:91:96:57:\n                    7a:88:88:ac:ee:70:ac:f9:dc:29:e3:0c:1c:3b:12:\n                    4e:44:d6:a7:4e:b0:26:c8:f3:d9:1a:97:91:68:ea:\n                    ef:8d:46:06:d2:56:45:58:9a:3c:0c:0f:83:b8:05:\n                    25:c3:39:cf:3b:a4:34:89:b7:79:12:2f:47:c5:e7:\n                    a9:97:69:fc:a6:77:67:b5:df:7b:f1:7a:65:15:e4:\n                    61:56:65\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                81:C4:8C:CC:F5:E4:30:FF:A5:0C:08:5F:8C:15:67:21:74:01:DF:DF\n    Signature Algorithm: sha256WithRSAEncryption\n         13:65:22:f5:8e:2b:ad:44:e4:cb:ff:b9:68:e6:c3:80:48:3d:\n         04:7b:fa:23:2f:7a:ed:36:da:b2:ce:6d:f6:e6:9e:e5:5f:58:\n         8f:cb:37:32:a1:c8:65:b6:ae:38:3d:35:1b:3e:bc:3b:b6:04:\n         d0:bc:f9:49:f5:9b:f7:85:c5:36:b6:cb:bc:f8:c8:39:d5:e4:\n         5f:07:bd:15:54:97:74:ca:ca:ed:4f:ba:ba:64:76:9f:81:b8:\n         84:45:49:4c:8d:6f:a2:eb:b1:cc:d1:c3:94:da:44:c2:e6:e2:\n         ea:18:e8:a2:1f:27:05:ba:d7:e5:d6:a9:cd:dd:ef:76:98:8d:\n         00:0e:cd:1b:fa:03:b7:8e:80:58:0e:27:3f:52:fb:94:a2:ca:\n         5e:65:c9:d6:84:da:b9:35:71:f3:26:c0:4f:77:e6:81:27:d2:\n         77:3b:9a:14:6f:79:f4:f6:d0:e1:d3:94:ba:d0:57:51:bd:27:\n         05:0d:c1:fd:c8:12:30:ee:6f:8d:11:2b:08:9d:d4:d4:bf:80:\n         45:14:9a:88:44:da:30:ea:b4:a7:e3:ee:ef:5b:82:d5:3e:d6:\n         ad:78:92:db:5c:3c:f3:d8:ad:fa:b8:6b:7f:c4:36:28:b6:02:\n         15:8a:54:2c:9c:b0:17:73:8e:d0:37:a3:14:3c:98:95:00:0c:\n         29:05:5b:9e:49:49:b1:5f:c7:e3:cb:cf:27:65:8e:35:17:b7:\n         57:c8:30:d9:41:5b:b9:14:b6:e8:c2:0f:94:31:a7:94:98:cc:\n         6a:eb:b5:e1:27:f5:10:a8:01:e8:8e:12:62:e8:88:cc:b5:7f:\n         46:97:c0:9b:10:66:38:1a:36:46:5f:22:68:3d:df:c9:c6:13:\n         27:ab:53:06:ac:a2:3c:86:06:65:6f:b1:7e:b1:29:44:9a:a3:\n         ba:49:69:28:69:8f:d7:e5:5f:ad:04:86:64:6f:1a:a0:0c:c5:\n         08:62:ce:80:a3:d0:f3:ec:68:de:be:33:c7:17:5b:7f:80:c4:\n         4c:4c:b1:a6:84:8a:c3:3b:b8:09:cd:14:81:ba:18:e3:54:57:\n         36:fe:db:2f:7c:47:a1:3a:33:c8:f9:58:3b:44:4f:b1:ca:02:\n         89:04:96:28:68:c5:4b:b8:26:89:bb:d6:33:2f:50:d5:fe:9a:\n         89:ba:18:32:92:54:c6:5b:e0:9d:f9:5e:e5:0d:22:9b:f6:da:\n         e2:c8:21:b2:62:21:aa:86:40:b2:2e:64:d3:5f:c8:e3:7e:11:\n         67:45:1f:05:fe:e3:a2:ef:b3:a8:b3:f3:7d:8f:f8:0c:1f:22:\n         1f:2d:70:b4:b8:01:34:76:30:00:e5:23:78:a7:56:d7:50:1f:\n         8a:fb:06:f5:c2:19:f0:d0\nSHA1 Fingerprint=28:F9:78:16:19:7A:FF:18:25:18:AA:44:FE:C1:A0:CE:5C:B6:4C:8A\n",
    "82212d66c6d7a0e015ebce4c0977c4609e546e03": "-----BEGIN CERTIFICATE-----\nMIIFRzCCAy+gAwIBAgIJEQA0tk7GNi02MA0GCSqGSIb3DQEBCwUAMEExCzAJBgNV\nBAYTAlJPMRQwEgYDVQQKEwtDRVJUU0lHTiBTQTEcMBoGA1UECxMTY2VydFNJR04g\nUk9PVCBDQSBHMjAeFw0xNzAyMDYwOTI3MzVaFw00MjAyMDYwOTI3MzVaMEExCzAJ\nBgNVBAYTAlJPMRQwEgYDVQQKEwtDRVJUU0lHTiBTQTEcMBoGA1UECxMTY2VydFNJ\nR04gUk9PVCBDQSBHMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMDF\ndRmRfUR0dIf+DjuW3NgBFszuY5HnC2/OOwppGnzC46+CjobXXo9X69MhWf05N0Iw\nvlDqtg+piNguLWkh59E3GE59kdUWX2tbAMI5Qw02hVK5U2UPHULlj88F0+7cDBrZ\nuIt4ImfkabBoxTzkbFpG583H+u/E7Eu9aqSs/cwoUe+StCmrqzWaTOTECMYmzPhp\nn+Sc8CnTXPnGFiWeI8MgwT0PPzhAsP6CRDiqWhqKa2NYOLQV07YRaXseVO6MGiKs\ncpc/I1mbySKEwQdPzH/iV8oScLumZfNpdWO9lfsbl83kqK/20U6o2YpxJM02PbyW\nxPFsqa7lzw1uKA2wDrXKUXt4FMMgL3/7FFXhEZn91QqhngLjYl/rNUssuHLoPj1P\nrCy7Lobio3aP5ZMqz6WryFyNSwb/EkaseMsUBzXgqd+L6a8VTxaJW732jcZZroiF\nDsGJ6x9nxUWO/203Nit4ZoORUSs9/1F3dmKh7Gc+PoGD4FapUB8fepmrY7+EF3fx\nDTvf95xhszWYijqy7DwaNz9+j5LP2RIUZNoQAhVB/0/E6xyjyfqZ90bp4RjZsbgy\nLcsUDFDYg2WD7rlcz8sFWkz6GZdr1l0T08JcVLwyc6B49fFtHsufpaafItzRUZ6C\neWRgKRM+o/1Pcmqr4tTluCRVLERLiohEnMqE0yo7AgMBAAGjQjBAMA8GA1UdEwEB\n/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBSCIS1mxteg4BXrzkwJ\nd8RgnlRuAzANBgkqhkiG9w0BAQsFAAOCAgEAYN4auOfyYILVAzOBywaK8SJJ6ejq\nkX/GM15oGQOGO0MBzwdw5AgeZYWR5hEit/UCI46uuR59H35s5r0l1ZUa8gWmr4UC\nb6741jH/JclKyMeKqdmfS0mbEVeZkkMR3rYzpMzXjWR91M08KCy0mpbqTfXERMQl\nqiCA2ClV9+BB/AYm/7k29UMUA2Z44RGx2iBfRgB4ACGlHgAoYXhvqAEBj500mv/0\nOJD7uNGzcgbJceaBxXntC6Z58hMLnPddDnskk7RI24Zf3lCGeOdA5jGokHZwYa+c\nNywRtYK3qq4kNFtyDGkNzVmf9nGvnAvRCjj5BiKDUyUM/FHE5r7iOZULJK2v0ZXk\nltd0ZGtxTgI8qoXzIKNDOXZbbFD+mpwUHmUUihW9o4JFWklWatKcsWMy5WHgUyIO\npwpJ6st+H6jiYoD2EEVSmAYY3qXNL3+q1Ok+CHLsIwMCPKaq2LxndD0UF/tUSxfj\n03k9bWtJySgOLnRQvwzZRjoQhsmnP+mg7H/rpXdYaXHmgwo38oZJar55CJD2AhZk\nPuXaTH4MNMn5X7azKFGnpyuqSfqNZSlO42sTp5SjLVFteAxEy9/eCG/Oo2Sr05WE\n1LlSVHJ7liXMvGnjSG4N0MedJ5qq+BOS3R7fY581qRY27Iy4g/Q9iY/NtBde17MX\nQRBdJ3NghVdJIgc=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            11:00:34:b6:4e:c6:36:2d:36\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=RO, O=CERTSIGN SA, OU=certSIGN ROOT CA G2\n        Validity\n            Not Before: Feb  6 09:27:35 2017 GMT\n            Not After : Feb  6 09:27:35 2042 GMT\n        Subject: C=RO, O=CERTSIGN SA, OU=certSIGN ROOT CA G2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:c0:c5:75:19:91:7d:44:74:74:87:fe:0e:3b:96:\n                    dc:d8:01:16:cc:ee:63:91:e7:0b:6f:ce:3b:0a:69:\n                    1a:7c:c2:e3:af:82:8e:86:d7:5e:8f:57:eb:d3:21:\n                    59:fd:39:37:42:30:be:50:ea:b6:0f:a9:88:d8:2e:\n                    2d:69:21:e7:d1:37:18:4e:7d:91:d5:16:5f:6b:5b:\n                    00:c2:39:43:0d:36:85:52:b9:53:65:0f:1d:42:e5:\n                    8f:cf:05:d3:ee:dc:0c:1a:d9:b8:8b:78:22:67:e4:\n                    69:b0:68:c5:3c:e4:6c:5a:46:e7:cd:c7:fa:ef:c4:\n                    ec:4b:bd:6a:a4:ac:fd:cc:28:51:ef:92:b4:29:ab:\n                    ab:35:9a:4c:e4:c4:08:c6:26:cc:f8:69:9f:e4:9c:\n                    f0:29:d3:5c:f9:c6:16:25:9e:23:c3:20:c1:3d:0f:\n                    3f:38:40:b0:fe:82:44:38:aa:5a:1a:8a:6b:63:58:\n                    38:b4:15:d3:b6:11:69:7b:1e:54:ee:8c:1a:22:ac:\n                    72:97:3f:23:59:9b:c9:22:84:c1:07:4f:cc:7f:e2:\n                    57:ca:12:70:bb:a6:65:f3:69:75:63:bd:95:fb:1b:\n                    97:cd:e4:a8:af:f6:d1:4e:a8:d9:8a:71:24:cd:36:\n                    3d:bc:96:c4:f1:6c:a9:ae:e5:cf:0d:6e:28:0d:b0:\n                    0e:b5:ca:51:7b:78:14:c3:20:2f:7f:fb:14:55:e1:\n                    11:99:fd:d5:0a:a1:9e:02:e3:62:5f:eb:35:4b:2c:\n                    b8:72:e8:3e:3d:4f:ac:2c:bb:2e:86:e2:a3:76:8f:\n                    e5:93:2a:cf:a5:ab:c8:5c:8d:4b:06:ff:12:46:ac:\n                    78:cb:14:07:35:e0:a9:df:8b:e9:af:15:4f:16:89:\n                    5b:bd:f6:8d:c6:59:ae:88:85:0e:c1:89:eb:1f:67:\n                    c5:45:8e:ff:6d:37:36:2b:78:66:83:91:51:2b:3d:\n                    ff:51:77:76:62:a1:ec:67:3e:3e:81:83:e0:56:a9:\n                    50:1f:1f:7a:99:ab:63:bf:84:17:77:f1:0d:3b:df:\n                    f7:9c:61:b3:35:98:8a:3a:b2:ec:3c:1a:37:3f:7e:\n                    8f:92:cf:d9:12:14:64:da:10:02:15:41:ff:4f:c4:\n                    eb:1c:a3:c9:fa:99:f7:46:e9:e1:18:d9:b1:b8:32:\n                    2d:cb:14:0c:50:d8:83:65:83:ee:b9:5c:cf:cb:05:\n                    5a:4c:fa:19:97:6b:d6:5d:13:d3:c2:5c:54:bc:32:\n                    73:a0:78:f5:f1:6d:1e:cb:9f:a5:a6:9f:22:dc:d1:\n                    51:9e:82:79:64:60:29:13:3e:a3:fd:4f:72:6a:ab:\n                    e2:d4:e5:b8:24:55:2c:44:4b:8a:88:44:9c:ca:84:\n                    d3:2a:3b\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                82:21:2D:66:C6:D7:A0:E0:15:EB:CE:4C:09:77:C4:60:9E:54:6E:03\n    Signature Algorithm: sha256WithRSAEncryption\n         60:de:1a:b8:e7:f2:60:82:d5:03:33:81:cb:06:8a:f1:22:49:\n         e9:e8:ea:91:7f:c6:33:5e:68:19:03:86:3b:43:01:cf:07:70:\n         e4:08:1e:65:85:91:e6:11:22:b7:f5:02:23:8e:ae:b9:1e:7d:\n         1f:7e:6c:e6:bd:25:d5:95:1a:f2:05:a6:af:85:02:6f:ae:f8:\n         d6:31:ff:25:c9:4a:c8:c7:8a:a9:d9:9f:4b:49:9b:11:57:99:\n         92:43:11:de:b6:33:a4:cc:d7:8d:64:7d:d4:cd:3c:28:2c:b4:\n         9a:96:ea:4d:f5:c4:44:c4:25:aa:20:80:d8:29:55:f7:e0:41:\n         fc:06:26:ff:b9:36:f5:43:14:03:66:78:e1:11:b1:da:20:5f:\n         46:00:78:00:21:a5:1e:00:28:61:78:6f:a8:01:01:8f:9d:34:\n         9a:ff:f4:38:90:fb:b8:d1:b3:72:06:c9:71:e6:81:c5:79:ed:\n         0b:a6:79:f2:13:0b:9c:f7:5d:0e:7b:24:93:b4:48:db:86:5f:\n         de:50:86:78:e7:40:e6:31:a8:90:76:70:61:af:9c:37:2c:11:\n         b5:82:b7:aa:ae:24:34:5b:72:0c:69:0d:cd:59:9f:f6:71:af:\n         9c:0b:d1:0a:38:f9:06:22:83:53:25:0c:fc:51:c4:e6:be:e2:\n         39:95:0b:24:ad:af:d1:95:e4:96:d7:74:64:6b:71:4e:02:3c:\n         aa:85:f3:20:a3:43:39:76:5b:6c:50:fe:9a:9c:14:1e:65:14:\n         8a:15:bd:a3:82:45:5a:49:56:6a:d2:9c:b1:63:32:e5:61:e0:\n         53:22:0e:a7:0a:49:ea:cb:7e:1f:a8:e2:62:80:f6:10:45:52:\n         98:06:18:de:a5:cd:2f:7f:aa:d4:e9:3e:08:72:ec:23:03:02:\n         3c:a6:aa:d8:bc:67:74:3d:14:17:fb:54:4b:17:e3:d3:79:3d:\n         6d:6b:49:c9:28:0e:2e:74:50:bf:0c:d9:46:3a:10:86:c9:a7:\n         3f:e9:a0:ec:7f:eb:a5:77:58:69:71:e6:83:0a:37:f2:86:49:\n         6a:be:79:08:90:f6:02:16:64:3e:e5:da:4c:7e:0c:34:c9:f9:\n         5f:b6:b3:28:51:a7:a7:2b:aa:49:fa:8d:65:29:4e:e3:6b:13:\n         a7:94:a3:2d:51:6d:78:0c:44:cb:df:de:08:6f:ce:a3:64:ab:\n         d3:95:84:d4:b9:52:54:72:7b:96:25:cc:bc:69:e3:48:6e:0d:\n         d0:c7:9d:27:9a:aa:f8:13:92:dd:1e:df:63:9f:35:a9:16:36:\n         ec:8c:b8:83:f4:3d:89:8f:cd:b4:17:5e:d7:b3:17:41:10:5d:\n         27:73:60:85:57:49:22:07\nSHA1 Fingerprint=26:F9:93:B4:ED:3D:28:27:B0:B9:4B:A7:E9:15:1D:A3:8D:92:E5:32\n",
    "82d1857330e73504d38e0292fbe5a4d1c421e8cd": "-----BEGIN CERTIFICATE-----\nMIICjTCCAhSgAwIBAgIIdebfy8FoW6gwCgYIKoZIzj0EAwIwfDELMAkGA1UEBhMC\nVVMxDjAMBgNVBAgMBVRleGFzMRAwDgYDVQQHDAdIb3VzdG9uMRgwFgYDVQQKDA9T\nU0wgQ29ycG9yYXRpb24xMTAvBgNVBAMMKFNTTC5jb20gUm9vdCBDZXJ0aWZpY2F0\naW9uIEF1dGhvcml0eSBFQ0MwHhcNMTYwMjEyMTgxNDAzWhcNNDEwMjEyMTgxNDAz\nWjB8MQswCQYDVQQGEwJVUzEOMAwGA1UECAwFVGV4YXMxEDAOBgNVBAcMB0hvdXN0\nb24xGDAWBgNVBAoMD1NTTCBDb3Jwb3JhdGlvbjExMC8GA1UEAwwoU1NMLmNvbSBS\nb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IEVDQzB2MBAGByqGSM49AgEGBSuB\nBAAiA2IABEVuqVDEpiM2nl8ojRfLliJkP9x6jh3MCLOicSS6jkm5BBtHllirLZXI\n7Z4INcgn64mMU1jrYor+8FsPazFSY0E7ic3s7LaNGdM0B9y7xgZ/wkWV7Mt/qCPg\nCemB+vNH06NjMGEwHQYDVR0OBBYEFILRhXMw5zUE044CkvvlpNHEIejNMA8GA1Ud\nEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAUgtGFczDnNQTTjgKS++Wk0cQh6M0wDgYD\nVR0PAQH/BAQDAgGGMAoGCCqGSM49BAMCA2cAMGQCMG/n61kRpGDPYbCWe+0F+S8T\nkdzt5fxQaxFGRrMcIQBiu77D5+jNB5n5DQtdcj7EqgIwH7y6C+IwJPt8bYBVCpk+\ngA0z5Wajs6O7pdWLjwkspl1+4vAHCGht0nxpbl/f5Wpl\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 8495723813297216424 (0x75e6dfcbc1685ba8)\n        Signature Algorithm: ecdsa-with-SHA256\n        Issuer: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com Root Certification Authority ECC\n        Validity\n            Not Before: Feb 12 18:14:03 2016 GMT\n            Not After : Feb 12 18:14:03 2041 GMT\n        Subject: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com Root Certification Authority ECC\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:45:6e:a9:50:c4:a6:23:36:9e:5f:28:8d:17:cb:\n                    96:22:64:3f:dc:7a:8e:1d:cc:08:b3:a2:71:24:ba:\n                    8e:49:b9:04:1b:47:96:58:ab:2d:95:c8:ed:9e:08:\n                    35:c8:27:eb:89:8c:53:58:eb:62:8a:fe:f0:5b:0f:\n                    6b:31:52:63:41:3b:89:cd:ec:ec:b6:8d:19:d3:34:\n                    07:dc:bb:c6:06:7f:c2:45:95:ec:cb:7f:a8:23:e0:\n                    09:e9:81:fa:f3:47:d3\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                82:D1:85:73:30:E7:35:04:D3:8E:02:92:FB:E5:A4:D1:C4:21:E8:CD\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Authority Key Identifier: \n                keyid:82:D1:85:73:30:E7:35:04:D3:8E:02:92:FB:E5:A4:D1:C4:21:E8:CD\n\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n    Signature Algorithm: ecdsa-with-SHA256\n         30:64:02:30:6f:e7:eb:59:11:a4:60:cf:61:b0:96:7b:ed:05:\n         f9:2f:13:91:dc:ed:e5:fc:50:6b:11:46:46:b3:1c:21:00:62:\n         bb:be:c3:e7:e8:cd:07:99:f9:0d:0b:5d:72:3e:c4:aa:02:30:\n         1f:bc:ba:0b:e2:30:24:fb:7c:6d:80:55:0a:99:3e:80:0d:33:\n         e5:66:a3:b3:a3:bb:a5:d5:8b:8f:09:2c:a6:5d:7e:e2:f0:07:\n         08:68:6d:d2:7c:69:6e:5f:df:e5:6a:65\nSHA1 Fingerprint=C3:19:7C:39:24:E6:54:AF:1B:C4:AB:20:95:7A:E2:C3:0E:13:02:6A\n",
    "8418cc8534ecbc0c94942e08599cc7b2104e0a08": "-----BEGIN CERTIFICATE-----\nMIIDQTCCAimgAwIBAgITBmyfz5m/jAo54vB4ikPmljZbyjANBgkqhkiG9w0BAQsF\nADA5MQswCQYDVQQGEwJVUzEPMA0GA1UEChMGQW1hem9uMRkwFwYDVQQDExBBbWF6\nb24gUm9vdCBDQSAxMB4XDTE1MDUyNjAwMDAwMFoXDTM4MDExNzAwMDAwMFowOTEL\nMAkGA1UEBhMCVVMxDzANBgNVBAoTBkFtYXpvbjEZMBcGA1UEAxMQQW1hem9uIFJv\nb3QgQ0EgMTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALJ4gHHKeNXj\nca9HgFB0fW7Y14h29Jlo91ghYPl0hAEvrAIthtOgQ3pOsqTQNroBvo3bSMgHFzZM\n9O6II8c+6zf1tRn4SWiw3te5djgdYZ6k/oI2peVKVuRF4fn9tBb6dNqcmzU5L/qw\nIFAGbHrQgLKm+a/sRxmPUDgH3KKHOVj4utWp+UhnMJbulHheb4mjUcAwhmahRWa6\nVOujw5H5SNz/0egwLX0tdHA114gk957EWW67c4cX8jJGKLhD+rcdqsq08p8kDi1L\n93FcXmn/6pUCyziKrlA4b9v7LWIbxcceVOF34GfID5yHI9Y/QCB/IIDEgEw+OyQm\njgSubJrIqg0CAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMC\nAYYwHQYDVR0OBBYEFIQYzIU07LwMlJQuCFmcx7IQTgoIMA0GCSqGSIb3DQEBCwUA\nA4IBAQCY8jdaQZChGsV2USggNiMOruYou6r4lK5IpDB/G/wkjUu0yKGX9rbxenDI\nU5PMCCjjmCXPI6T53iHTfIUJrU6adTrCC2qJeHZERxhlbI1Bjjt/msv0tadQ1wUs\nN+gDS63pYaACbvXy8MWy7Vu33PqUXHeeE6V/Uq2V8viTO96LXFvKWlJbYK8U90vv\no/ufQJVtMVT8QtPHRh8jrdkPSHCa2XV4cdFyQzR1bldZwgJcJmApzyMZFo6IQ6XU\n5MsI+yMRQ+hDKXJioaldXgjUkK642M4UwtBV8ob2xJNDd2ZhwLnoQdeXeGADbkpy\nrqXRfboQnoZsG4q5WTP468SQvvG5\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            06:6c:9f:cf:99:bf:8c:0a:39:e2:f0:78:8a:43:e6:96:36:5b:ca\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, O=Amazon, CN=Amazon Root CA 1\n        Validity\n            Not Before: May 26 00:00:00 2015 GMT\n            Not After : Jan 17 00:00:00 2038 GMT\n        Subject: C=US, O=Amazon, CN=Amazon Root CA 1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:b2:78:80:71:ca:78:d5:e3:71:af:47:80:50:74:\n                    7d:6e:d8:d7:88:76:f4:99:68:f7:58:21:60:f9:74:\n                    84:01:2f:ac:02:2d:86:d3:a0:43:7a:4e:b2:a4:d0:\n                    36:ba:01:be:8d:db:48:c8:07:17:36:4c:f4:ee:88:\n                    23:c7:3e:eb:37:f5:b5:19:f8:49:68:b0:de:d7:b9:\n                    76:38:1d:61:9e:a4:fe:82:36:a5:e5:4a:56:e4:45:\n                    e1:f9:fd:b4:16:fa:74:da:9c:9b:35:39:2f:fa:b0:\n                    20:50:06:6c:7a:d0:80:b2:a6:f9:af:ec:47:19:8f:\n                    50:38:07:dc:a2:87:39:58:f8:ba:d5:a9:f9:48:67:\n                    30:96:ee:94:78:5e:6f:89:a3:51:c0:30:86:66:a1:\n                    45:66:ba:54:eb:a3:c3:91:f9:48:dc:ff:d1:e8:30:\n                    2d:7d:2d:74:70:35:d7:88:24:f7:9e:c4:59:6e:bb:\n                    73:87:17:f2:32:46:28:b8:43:fa:b7:1d:aa:ca:b4:\n                    f2:9f:24:0e:2d:4b:f7:71:5c:5e:69:ff:ea:95:02:\n                    cb:38:8a:ae:50:38:6f:db:fb:2d:62:1b:c5:c7:1e:\n                    54:e1:77:e0:67:c8:0f:9c:87:23:d6:3f:40:20:7f:\n                    20:80:c4:80:4c:3e:3b:24:26:8e:04:ae:6c:9a:c8:\n                    aa:0d\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                84:18:CC:85:34:EC:BC:0C:94:94:2E:08:59:9C:C7:B2:10:4E:0A:08\n    Signature Algorithm: sha256WithRSAEncryption\n         98:f2:37:5a:41:90:a1:1a:c5:76:51:28:20:36:23:0e:ae:e6:\n         28:bb:aa:f8:94:ae:48:a4:30:7f:1b:fc:24:8d:4b:b4:c8:a1:\n         97:f6:b6:f1:7a:70:c8:53:93:cc:08:28:e3:98:25:cf:23:a4:\n         f9:de:21:d3:7c:85:09:ad:4e:9a:75:3a:c2:0b:6a:89:78:76:\n         44:47:18:65:6c:8d:41:8e:3b:7f:9a:cb:f4:b5:a7:50:d7:05:\n         2c:37:e8:03:4b:ad:e9:61:a0:02:6e:f5:f2:f0:c5:b2:ed:5b:\n         b7:dc:fa:94:5c:77:9e:13:a5:7f:52:ad:95:f2:f8:93:3b:de:\n         8b:5c:5b:ca:5a:52:5b:60:af:14:f7:4b:ef:a3:fb:9f:40:95:\n         6d:31:54:fc:42:d3:c7:46:1f:23:ad:d9:0f:48:70:9a:d9:75:\n         78:71:d1:72:43:34:75:6e:57:59:c2:02:5c:26:60:29:cf:23:\n         19:16:8e:88:43:a5:d4:e4:cb:08:fb:23:11:43:e8:43:29:72:\n         62:a1:a9:5d:5e:08:d4:90:ae:b8:d8:ce:14:c2:d0:55:f2:86:\n         f6:c4:93:43:77:66:61:c0:b9:e8:41:d7:97:78:60:03:6e:4a:\n         72:ae:a5:d1:7d:ba:10:9e:86:6c:1b:8a:b9:59:33:f8:eb:c4:\n         90:be:f1:b9\nSHA1 Fingerprint=8D:A7:F9:65:EC:5E:FC:37:91:0F:1C:6E:59:FD:C1:CC:6A:6E:DE:16\n",
    "87111508d1aac1780cb1afcec6c990efbf3004c0": "-----BEGIN CERTIFICATE-----\nMIICQDCCAeWgAwIBAgIMAVRI7yH9l1kN9QQKMAoGCCqGSM49BAMCMHExCzAJBgNV\nBAYTAkhVMREwDwYDVQQHDAhCdWRhcGVzdDEWMBQGA1UECgwNTWljcm9zZWMgTHRk\nLjEXMBUGA1UEYQwOVkFUSFUtMjM1ODQ0OTcxHjAcBgNVBAMMFWUtU3ppZ25vIFJv\nb3QgQ0EgMjAxNzAeFw0xNzA4MjIxMjA3MDZaFw00MjA4MjIxMjA3MDZaMHExCzAJ\nBgNVBAYTAkhVMREwDwYDVQQHDAhCdWRhcGVzdDEWMBQGA1UECgwNTWljcm9zZWMg\nTHRkLjEXMBUGA1UEYQwOVkFUSFUtMjM1ODQ0OTcxHjAcBgNVBAMMFWUtU3ppZ25v\nIFJvb3QgQ0EgMjAxNzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABJbcPYrYsHtv\nxie+RJCxs1YVe45DJH0ahFnuY2iyxl6H0BVIHqiQrb1TotreOpCmYF9oMrWGQd+H\nWyx7xf58etqjYzBhMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0G\nA1UdDgQWBBSHERUI0arBeAyxr87GyZDvvzAEwDAfBgNVHSMEGDAWgBSHERUI0arB\neAyxr87GyZDvvzAEwDAKBggqhkjOPQQDAgNJADBGAiEAtVfd14pVCzbhhkT61Nlo\njbjcI4qKDdQvfepz7L9NbKgCIQDLpbQS+ue16M9+k/zzNY9vTlp8tLxOsvxyqltZ\n+efcMQ==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            01:54:48:ef:21:fd:97:59:0d:f5:04:0a\n        Signature Algorithm: ecdsa-with-SHA256\n        Issuer: C=HU, L=Budapest, O=Microsec Ltd./organizationIdentifier=VATHU-23584497, CN=e-Szigno Root CA 2017\n        Validity\n            Not Before: Aug 22 12:07:06 2017 GMT\n            Not After : Aug 22 12:07:06 2042 GMT\n        Subject: C=HU, L=Budapest, O=Microsec Ltd./organizationIdentifier=VATHU-23584497, CN=e-Szigno Root CA 2017\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (256 bit)\n                pub:\n                    04:96:dc:3d:8a:d8:b0:7b:6f:c6:27:be:44:90:b1:\n                    b3:56:15:7b:8e:43:24:7d:1a:84:59:ee:63:68:b2:\n                    c6:5e:87:d0:15:48:1e:a8:90:ad:bd:53:a2:da:de:\n                    3a:90:a6:60:5f:68:32:b5:86:41:df:87:5b:2c:7b:\n                    c5:fe:7c:7a:da\n                ASN1 OID: prime256v1\n                NIST CURVE: P-256\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                87:11:15:08:D1:AA:C1:78:0C:B1:AF:CE:C6:C9:90:EF:BF:30:04:C0\n            X509v3 Authority Key Identifier: \n                keyid:87:11:15:08:D1:AA:C1:78:0C:B1:AF:CE:C6:C9:90:EF:BF:30:04:C0\n\n    Signature Algorithm: ecdsa-with-SHA256\n         30:46:02:21:00:b5:57:dd:d7:8a:55:0b:36:e1:86:44:fa:d4:\n         d9:68:8d:b8:dc:23:8a:8a:0d:d4:2f:7d:ea:73:ec:bf:4d:6c:\n         a8:02:21:00:cb:a5:b4:12:fa:e7:b5:e8:cf:7e:93:fc:f3:35:\n         8f:6f:4e:5a:7c:b4:bc:4e:b2:fc:72:aa:5b:59:f9:e7:dc:31\nSHA1 Fingerprint=89:D4:83:03:4F:9E:9A:48:80:5F:72:37:D4:A9:A6:EF:CB:7C:1F:D1\n",
    "8b4b6dedd329b90619ec3939a9f097846acbefdf": "-----BEGIN CERTIFICATE-----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\nSnQ2+Q==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 985026699 (0x3ab6508b)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=BM, O=QuoVadis Limited, OU=Root Certification Authority, CN=QuoVadis Root Certification Authority\n        Validity\n            Not Before: Mar 19 18:33:33 2001 GMT\n            Not After : Mar 17 18:33:33 2021 GMT\n        Subject: C=BM, O=QuoVadis Limited, OU=Root Certification Authority, CN=QuoVadis Root Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:bf:61:b5:95:53:ba:57:fc:fa:f2:67:0b:3a:1a:\n                    df:11:80:64:95:b4:d1:bc:cd:7a:cf:f6:29:96:2e:\n                    24:54:40:24:38:f7:1a:85:dc:58:4c:cb:a4:27:42:\n                    97:d0:9f:83:8a:c3:e4:06:03:5b:00:a5:51:1e:70:\n                    04:74:e2:c1:d4:3a:ab:d7:ad:3b:07:18:05:8e:fd:\n                    83:ac:ea:66:d9:18:1b:68:8a:f5:57:1a:98:ba:f5:\n                    ed:76:3d:7c:d9:de:94:6a:3b:4b:17:c1:d5:8f:bd:\n                    65:38:3a:95:d0:3d:55:36:4e:df:79:57:31:2a:1e:\n                    d8:59:65:49:58:20:98:7e:ab:5f:7e:9f:e9:d6:4d:\n                    ec:83:74:a9:c7:6c:d8:ee:29:4a:85:2a:06:14:f9:\n                    54:e6:d3:da:65:07:8b:63:37:12:d7:d0:ec:c3:7b:\n                    20:41:44:a3:ed:cb:a0:17:e1:71:65:ce:1d:66:31:\n                    f7:76:01:19:c8:7d:03:58:b6:95:49:1d:a6:12:26:\n                    e8:c6:0c:76:e0:e3:66:cb:ea:5d:a6:26:ee:e5:cc:\n                    5f:bd:67:a7:01:27:0e:a2:ca:54:c5:b1:7a:95:1d:\n                    71:1e:4a:29:8a:03:dc:6a:45:c1:a4:19:5e:6f:36:\n                    cd:c3:a2:b0:b7:fe:5c:38:e2:52:bc:f8:44:43:e6:\n                    90:bb\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            Authority Information Access: \n                OCSP - URI:https://ocsp.quovadisoffshore.com\n\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Certificate Policies: \n                Policy: 1.3.6.1.4.1.8024.0.1\n                  User Notice:\n                    Explicit Text: Reliance on the QuoVadis Root Certificate by any party assumes acceptance of the then applicable standard terms and conditions of use, certification practices, and the QuoVadis Certificate Policy.\n                  CPS: http://www.quovadis.bm\n\n            X509v3 Subject Key Identifier: \n                8B:4B:6D:ED:D3:29:B9:06:19:EC:39:39:A9:F0:97:84:6A:CB:EF:DF\n            X509v3 Authority Key Identifier: \n                keyid:8B:4B:6D:ED:D3:29:B9:06:19:EC:39:39:A9:F0:97:84:6A:CB:EF:DF\n                DirName:/C=BM/O=QuoVadis Limited/OU=Root Certification Authority/CN=QuoVadis Root Certification Authority\n                serial:3A:B6:50:8B\n\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha1WithRSAEncryption\n         8a:d4:14:b5:fe:f4:9a:92:a7:19:d4:a4:7e:72:18:8f:d9:68:\n         7c:52:24:dd:67:6f:39:7a:c4:aa:5e:3d:e2:58:b0:4d:70:98:\n         84:61:e8:1b:e3:69:18:0e:ce:fb:47:50:a0:4e:ff:f0:24:1f:\n         bd:b2:ce:f5:27:fc:ec:2f:53:aa:73:7b:03:3d:74:6e:e6:16:\n         9e:eb:a5:2e:c4:bf:56:27:50:2b:62:ba:be:4b:1c:3c:55:5c:\n         41:1d:24:be:82:20:47:5d:d5:44:7e:7a:16:68:df:7d:4d:51:\n         70:78:57:1d:33:1e:fd:02:99:9c:0c:cd:0a:05:4f:c7:bb:8e:\n         a4:75:fa:4a:6d:b1:80:8e:09:56:b9:9c:1a:60:fe:5d:c1:d7:\n         7a:dc:11:78:d0:d6:5d:c1:b7:d5:ad:32:99:03:3a:8a:cc:54:\n         25:39:31:81:7b:13:22:51:ba:46:6c:a1:bb:9e:fa:04:6c:49:\n         26:74:8f:d2:73:eb:cc:30:a2:e6:ea:59:22:87:f8:97:f5:0e:\n         fd:ea:cc:92:a4:16:c4:52:18:ea:21:ce:b1:f1:e6:84:81:e5:\n         ba:a9:86:28:f2:43:5a:5d:12:9d:ac:1e:d9:a8:e5:0a:6a:a7:\n         7f:a0:87:29:cf:f2:89:4d:d4:ec:c5:e2:e6:7a:d0:36:23:8a:\n         4a:74:36:f9\nSHA1 Fingerprint=DE:3F:40:BD:50:93:D3:9B:6C:60:F6:DA:BC:07:62:01:00:89:76:C9\n",
    "8ff04b7fa82e4524ae4d50fa639a8bdee2dd1bbc": "-----BEGIN CERTIFICATE-----\nMIIDXzCCAkegAwIBAgILBAAAAAABIVhTCKIwDQYJKoZIhvcNAQELBQAwTDEgMB4G\nA1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjMxEzARBgNVBAoTCkdsb2JhbFNp\nZ24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMDkwMzE4MTAwMDAwWhcNMjkwMzE4\nMTAwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEG\nA1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAMwldpB5BngiFvXAg7aEyiie/QV2EcWtiHL8\nRgJDx7KKnQRfJMsuS+FggkbhUqsMgUdwbN1k0ev1LKMPgj0MK66X17YUhhB5uzsT\ngHeMCOFJ0mpiLx9e+pZo34knlTifBtc+ycsmWQ1z3rDI6SYOgxXG71uL0gRgykmm\nKPZpO/bLyCiR5Z2KYVc3rHQU3HTgOu5yLy6c+9C7v/U9AOEGM+iCK65TpjoWc4zd\nQQ4gOsC0p6Hpsk+QLjJg6VfLuQSSaGjlOCZgdbKfd/+RFO+uIEn8rUAVSNECMWEZ\nXriX7613t2Saer9fwRPvm2L7DWzgVGkWqQPabumDk3F2xmmFghcCAwEAAaNCMEAw\nDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFI/wS3+o\nLkUkrk1Q+mOai97i3Ru8MA0GCSqGSIb3DQEBCwUAA4IBAQBLQNvAUKr+yAzv95ZU\nRUm7lgAJQayzE4aGKAczymvmdLm6AC2upArT9fHxD4q/c2dKg8dEe3jgr25sbwMp\njjM5RcOO5LlXbKr8EpbsU8Yt5CRsuZRj+9xTaGdWPoO4zzUhw8lo/s7awlOqzJCK\n6fBdRoyV3XpYKBovHd7NADdBj+1EbddTKJd+82cEHhXXipa0095MJ6RMG3NzdvQX\nmcIfeg7jLQitChws/zyrVQ4PkX4268NXSb7hLi18YIvDQVETI53O9zJrlAGomecs\nMx86OyXShkDOOyyGeMlhLxS67ttVb9+E7gUJTb0o2HLO02JQZR7rkpeDMdmztcpH\nWD9f\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            04:00:00:00:00:01:21:58:53:08:a2\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: OU=GlobalSign Root CA - R3, O=GlobalSign, CN=GlobalSign\n        Validity\n            Not Before: Mar 18 10:00:00 2009 GMT\n            Not After : Mar 18 10:00:00 2029 GMT\n        Subject: OU=GlobalSign Root CA - R3, O=GlobalSign, CN=GlobalSign\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:cc:25:76:90:79:06:78:22:16:f5:c0:83:b6:84:\n                    ca:28:9e:fd:05:76:11:c5:ad:88:72:fc:46:02:43:\n                    c7:b2:8a:9d:04:5f:24:cb:2e:4b:e1:60:82:46:e1:\n                    52:ab:0c:81:47:70:6c:dd:64:d1:eb:f5:2c:a3:0f:\n                    82:3d:0c:2b:ae:97:d7:b6:14:86:10:79:bb:3b:13:\n                    80:77:8c:08:e1:49:d2:6a:62:2f:1f:5e:fa:96:68:\n                    df:89:27:95:38:9f:06:d7:3e:c9:cb:26:59:0d:73:\n                    de:b0:c8:e9:26:0e:83:15:c6:ef:5b:8b:d2:04:60:\n                    ca:49:a6:28:f6:69:3b:f6:cb:c8:28:91:e5:9d:8a:\n                    61:57:37:ac:74:14:dc:74:e0:3a:ee:72:2f:2e:9c:\n                    fb:d0:bb:bf:f5:3d:00:e1:06:33:e8:82:2b:ae:53:\n                    a6:3a:16:73:8c:dd:41:0e:20:3a:c0:b4:a7:a1:e9:\n                    b2:4f:90:2e:32:60:e9:57:cb:b9:04:92:68:68:e5:\n                    38:26:60:75:b2:9f:77:ff:91:14:ef:ae:20:49:fc:\n                    ad:40:15:48:d1:02:31:61:19:5e:b8:97:ef:ad:77:\n                    b7:64:9a:7a:bf:5f:c1:13:ef:9b:62:fb:0d:6c:e0:\n                    54:69:16:a9:03:da:6e:e9:83:93:71:76:c6:69:85:\n                    82:17\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                8F:F0:4B:7F:A8:2E:45:24:AE:4D:50:FA:63:9A:8B:DE:E2:DD:1B:BC\n    Signature Algorithm: sha256WithRSAEncryption\n         4b:40:db:c0:50:aa:fe:c8:0c:ef:f7:96:54:45:49:bb:96:00:\n         09:41:ac:b3:13:86:86:28:07:33:ca:6b:e6:74:b9:ba:00:2d:\n         ae:a4:0a:d3:f5:f1:f1:0f:8a:bf:73:67:4a:83:c7:44:7b:78:\n         e0:af:6e:6c:6f:03:29:8e:33:39:45:c3:8e:e4:b9:57:6c:aa:\n         fc:12:96:ec:53:c6:2d:e4:24:6c:b9:94:63:fb:dc:53:68:67:\n         56:3e:83:b8:cf:35:21:c3:c9:68:fe:ce:da:c2:53:aa:cc:90:\n         8a:e9:f0:5d:46:8c:95:dd:7a:58:28:1a:2f:1d:de:cd:00:37:\n         41:8f:ed:44:6d:d7:53:28:97:7e:f3:67:04:1e:15:d7:8a:96:\n         b4:d3:de:4c:27:a4:4c:1b:73:73:76:f4:17:99:c2:1f:7a:0e:\n         e3:2d:08:ad:0a:1c:2c:ff:3c:ab:55:0e:0f:91:7e:36:eb:c3:\n         57:49:be:e1:2e:2d:7c:60:8b:c3:41:51:13:23:9d:ce:f7:32:\n         6b:94:01:a8:99:e7:2c:33:1f:3a:3b:25:d2:86:40:ce:3b:2c:\n         86:78:c9:61:2f:14:ba:ee:db:55:6f:df:84:ee:05:09:4d:bd:\n         28:d8:72:ce:d3:62:50:65:1e:eb:92:97:83:31:d9:b3:b5:ca:\n         47:58:3f:5f\nSHA1 Fingerprint=D6:9B:56:11:48:F0:1C:77:C5:45:78:C1:09:26:DF:5B:85:69:76:AD\n",
    "99e019670d62db76b3da3db85be8fd42d2310e87": "-----BEGIN CERTIFICATE-----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\nyeC2nOnOcXHebD8WpHk=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            05:f7:0e:86:da:49:f3:46:35:2e:ba:b2\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global Certification Authority\n        Validity\n            Not Before: Aug 23 19:34:12 2017 GMT\n            Not After : Aug 23 19:34:12 2042 GMT\n        Subject: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:b9:5d:51:28:4b:3c:37:92:d1:82:ce:bd:1d:bd:\n                    cd:dd:b8:ab:cf:0a:3e:e1:5d:e5:dc:aa:09:b9:57:\n                    02:3e:e6:63:61:df:f2:0f:82:63:ae:a3:f7:ac:73:\n                    d1:7c:e7:b3:0b:af:08:00:09:59:7f:cd:29:2a:88:\n                    93:87:17:18:80:ed:88:b2:b4:b6:10:1f:2d:d6:5f:\n                    55:a2:13:5d:d1:c6:eb:06:56:89:88:fe:ac:32:9d:\n                    fd:5c:c3:05:c7:6e:ee:86:89:ba:88:03:9d:72:21:\n                    86:90:ae:8f:03:a5:dc:9f:88:28:cb:a3:92:49:0f:\n                    ec:d0:0f:e2:6d:44:4f:80:6a:b2:d4:e7:a0:0a:53:\n                    01:ba:8e:97:91:76:6e:bc:fc:d5:6b:36:e6:40:88:\n                    d6:7b:2f:5f:05:e8:2c:6d:11:f3:e7:b2:be:92:44:\n                    4c:d2:97:a4:fe:d2:72:81:43:07:9c:e9:11:3e:f5:\n                    8b:1a:59:7d:1f:68:58:dd:04:00:2c:96:f3:43:b3:\n                    7e:98:19:74:d9:9c:73:d9:18:be:41:c7:34:79:d9:\n                    f4:62:c2:43:b9:b3:27:b0:22:cb:f9:3d:52:c7:30:\n                    47:b3:c9:3e:b8:6a:e2:e7:e8:81:70:5e:42:8b:4f:\n                    26:a5:fe:3a:c2:20:6e:bb:f8:16:8e:cd:0c:a9:b4:\n                    1b:6c:76:10:e1:58:79:46:3e:54:ce:80:a8:57:09:\n                    37:29:1b:99:13:8f:0c:c8:d6:2c:1c:fb:05:e8:08:\n                    95:3d:65:46:dc:ee:cd:69:e2:4d:8f:87:28:4e:34:\n                    0b:3e:cf:14:d9:bb:dd:b6:50:9a:ad:77:d4:19:d6:\n                    da:1a:88:c8:4e:1b:27:75:d8:b2:08:f1:ae:83:30:\n                    b9:11:0e:cd:87:f0:84:8d:15:72:7c:a1:ef:cc:f2:\n                    88:61:ba:f4:69:bb:0c:8c:0b:75:57:04:b8:4e:2a:\n                    14:2e:3d:0f:1c:1e:32:a6:62:36:ee:66:e2:22:b8:\n                    05:40:63:10:22:f3:33:1d:74:72:8a:2c:f5:39:29:\n                    a0:d3:e7:1b:80:84:2d:c5:3d:e3:4d:b1:fd:1a:6f:\n                    ba:65:07:3b:58:ec:42:45:26:fb:d8:da:25:72:c4:\n                    f6:00:b1:22:79:bd:e3:7c:59:62:4a:9c:05:6f:3d:\n                    ce:e6:d6:47:63:99:c6:24:6f:72:12:c8:ac:7f:90:\n                    b4:0b:91:70:e8:b7:e6:16:10:71:17:ce:de:06:4f:\n                    48:41:7d:35:4a:a3:89:f2:c9:4b:7b:41:11:6d:67:\n                    b7:08:98:4c:e5:11:19:ae:42:80:dc:fb:90:05:d4:\n                    f8:50:ca:be:e4:ad:c7:c2:94:d7:16:9d:e6:17:8f:\n                    af:36:fb\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                99:E0:19:67:0D:62:DB:76:B3:DA:3D:B8:5B:E8:FD:42:D2:31:0E:87\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         98:73:70:e2:b0:d3:ed:39:ec:4c:60:d9:a9:12:86:17:1e:96:\n         d0:e8:54:28:3b:64:2d:21:a6:f8:9d:56:13:6a:48:3d:4f:c7:\n         3e:29:db:6d:58:83:54:3d:87:7d:23:05:d4:e4:1c:dc:e8:38:\n         65:86:c5:75:a7:5a:db:35:05:bd:77:de:bb:29:37:40:05:07:\n         c3:94:52:9f:ca:64:dd:f1:1b:2b:dc:46:0a:10:02:31:fd:4a:\n         68:0d:07:64:90:e6:1e:f5:2a:a1:a8:bb:3c:5d:f9:a3:08:0b:\n         11:0c:f1:3f:2d:10:94:6f:fe:e2:34:87:83:d6:cf:e5:1b:35:\n         6d:d2:03:e1:b0:0d:a8:a0:aa:46:27:82:36:a7:15:b6:08:a6:\n         42:54:57:b6:99:5a:e2:0b:79:90:d7:57:12:51:35:19:88:41:\n         68:25:d4:37:17:84:15:fb:01:72:dc:95:de:52:26:20:98:26:\n         e2:76:f5:27:6f:fa:00:3b:4a:61:d9:0d:cb:51:93:2a:fd:16:\n         06:96:a7:23:9a:23:48:fe:51:bd:b6:c4:b0:b1:54:ce:de:6c:\n         41:ad:16:67:7e:db:fd:38:cd:b9:38:4e:b2:c1:60:cb:9d:17:\n         df:58:9e:7a:62:b2:26:8f:74:95:9b:e4:5b:1d:d2:0f:dd:98:\n         1c:9b:59:b9:23:d3:31:a0:a6:ff:38:dd:cf:20:4f:e9:58:56:\n         3a:67:c3:d1:f6:99:99:9d:ba:36:b6:80:2f:88:47:4f:86:bf:\n         44:3a:80:e4:37:1c:a6:ba:ea:97:98:11:d0:84:62:47:64:1e:\n         aa:ee:40:bf:34:b1:9c:8f:4e:e1:f2:92:4f:1f:8e:f3:9e:97:\n         de:f3:a6:79:6a:89:71:4f:4b:27:17:48:fe:ec:f4:50:0f:4f:\n         49:7d:cc:45:e3:bd:7a:40:c5:41:dc:61:56:27:06:69:e5:72:\n         41:81:d3:b6:01:89:a0:2f:3a:72:79:fe:3a:30:bf:41:ec:c7:\n         62:3e:91:4b:c7:d9:31:76:42:f9:f7:3c:63:ec:26:8c:73:0c:\n         7d:1a:1d:ea:a8:7c:87:a8:c2:27:7c:e1:33:41:0f:cf:cf:fc:\n         00:a0:22:80:9e:4a:a7:6f:00:b0:41:45:b7:22:ca:68:48:c5:\n         42:a2:ae:dd:1d:f2:e0:6e:4e:05:58:b1:c0:90:16:2a:a4:3d:\n         10:40:be:8f:62:63:83:a9:9c:82:7d:2d:02:e9:83:30:7c:cb:\n         27:c9:fd:1e:66:00:b0:2e:d3:21:2f:8e:33:16:6c:98:ed:10:\n         a8:07:d6:cc:93:cf:db:d1:69:1c:e4:ca:c9:e0:b6:9c:e9:ce:\n         71:71:de:6c:3f:16:a4:79\nSHA1 Fingerprint=2F:8F:36:4F:E1:58:97:44:21:59:87:A5:2A:9A:D0:69:95:26:7F:B5\n",
    "9aaf297ac011353526513000c36afe40d5aed63c": "-----BEGIN CERTIFICATE-----\nMIIB/jCCAYWgAwIBAgIIdJclisc/elQwCgYIKoZIzj0EAwMwRTELMAkGA1UEBhMC\nVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MSAwHgYDVQQDDBdBZmZpcm1UcnVzdCBQ\ncmVtaXVtIEVDQzAeFw0xMDAxMjkxNDIwMjRaFw00MDEyMzExNDIwMjRaMEUxCzAJ\nBgNVBAYTAlVTMRQwEgYDVQQKDAtBZmZpcm1UcnVzdDEgMB4GA1UEAwwXQWZmaXJt\nVHJ1c3QgUHJlbWl1bSBFQ0MwdjAQBgcqhkjOPQIBBgUrgQQAIgNiAAQNMF4bFZ0D\n0KF5Nbc6PJJ6yhUczWLznCZcBz3lVPqj1swS6vQUX+iOGasvLkjmrBhDeKzQN8O9\nss0s5kfiGuZjuD0uL3jET9v0D6RoTFVya5UdThhClXjMNzyR4ptlKymjQjBAMB0G\nA1UdDgQWBBSaryl6wBE1NSZRMADDav5A1a7WPDAPBgNVHRMBAf8EBTADAQH/MA4G\nA1UdDwEB/wQEAwIBBjAKBggqhkjOPQQDAwNnADBkAjAXCfOHiFBar8jAQr9HX/Vs\naobgxCd05DhT1wV/GzTjxi+zygk8N53X57hG8f2h4nECMEJZh0PUUd+60wkyWs6I\nflc9nF9Ca/UHLbXwgpP5WW+uZPpY5Yse42O+tYHNbwKMeQ==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 8401224907861490260 (0x7497258ac73f7a54)\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, O=AffirmTrust, CN=AffirmTrust Premium ECC\n        Validity\n            Not Before: Jan 29 14:20:24 2010 GMT\n            Not After : Dec 31 14:20:24 2040 GMT\n        Subject: C=US, O=AffirmTrust, CN=AffirmTrust Premium ECC\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:0d:30:5e:1b:15:9d:03:d0:a1:79:35:b7:3a:3c:\n                    92:7a:ca:15:1c:cd:62:f3:9c:26:5c:07:3d:e5:54:\n                    fa:a3:d6:cc:12:ea:f4:14:5f:e8:8e:19:ab:2f:2e:\n                    48:e6:ac:18:43:78:ac:d0:37:c3:bd:b2:cd:2c:e6:\n                    47:e2:1a:e6:63:b8:3d:2e:2f:78:c4:4f:db:f4:0f:\n                    a4:68:4c:55:72:6b:95:1d:4e:18:42:95:78:cc:37:\n                    3c:91:e2:9b:65:2b:29\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                9A:AF:29:7A:C0:11:35:35:26:51:30:00:C3:6A:FE:40:D5:AE:D6:3C\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: ecdsa-with-SHA384\n         30:64:02:30:17:09:f3:87:88:50:5a:af:c8:c0:42:bf:47:5f:\n         f5:6c:6a:86:e0:c4:27:74:e4:38:53:d7:05:7f:1b:34:e3:c6:\n         2f:b3:ca:09:3c:37:9d:d7:e7:b8:46:f1:fd:a1:e2:71:02:30:\n         42:59:87:43:d4:51:df:ba:d3:09:32:5a:ce:88:7e:57:3d:9c:\n         5f:42:6b:f5:07:2d:b5:f0:82:93:f9:59:6f:ae:64:fa:58:e5:\n         8b:1e:e3:63:be:b5:81:cd:6f:02:8c:79\nSHA1 Fingerprint=B8:23:6B:00:2F:1D:16:86:53:01:55:6C:11:A4:37:CA:EB:FF:C3:BB\n",
    "9be20757671c1ec06a06de59b49a2ddfdc19862e": "-----BEGIN CERTIFICATE-----\nMIIDujCCAqKgAwIBAgILBAAAAAABD4Ym5g0wDQYJKoZIhvcNAQEFBQAwTDEgMB4G\nA1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjIxEzARBgNVBAoTCkdsb2JhbFNp\nZ24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMDYxMjE1MDgwMDAwWhcNMjExMjE1\nMDgwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMjETMBEG\nA1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAKbPJA6+Lm8omUVCxKs+IVSbC9N/hHD6ErPL\nv4dfxn+G07IwXNb9rfF73OX4YJYJkhD10FPe+3t+c4isUoh7SqbKSaZeqKeMWhG8\neoLrvozps6yWJQeXSpkqBy+0Hne/ig+1AnwblrjFuTosvNYSuetZfeLQBoZfXklq\ntTleiDTsvHgMCJiEbKjNS7SgfQx5TfC4LcshytVsW33hoCmEofnTlEnLJGKRILzd\nC9XZzPnqJworc5HGnRusyMvo4KD0L5CLTfuwNhv2GXqF4G3yYROIXJ/gkwpRl4pa\nzq+r1feqCapgvdzZX99yqWATXgAByUr6P6TqBwMhAo6CygPCm48CAwEAAaOBnDCB\nmTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUm+IH\nV2ccHsBqBt5ZtJot39wZhi4wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n\nbG9iYWxzaWduLm5ldC9yb290LXIyLmNybDAfBgNVHSMEGDAWgBSb4gdXZxwewGoG\n3lm0mi3f3BmGLjANBgkqhkiG9w0BAQUFAAOCAQEAmYFThxxol4aR7OBKuEQLq4Gs\nJ0/WwbgcQ3izDJr86iw8bmEbTUsp9Z8FHSbBuOmDAGJFtqkIk7mpM0sYmsL4h4hO\n291xNBrBVNpGP+DTKqttVCL1OmLNIG+6KYnX3ZHu01yiPqFbQfXf5WRDLenVOavS\not+3i9DAgBkcRcAtjOj4LaR0VknFBbVPFd5uRHg5h6h+u/N5GJG79G+dwfCMNYxd\nAfvDbbnvRG15RjF+Cv6pgsH/76tuIMRQyV+dTZsXjAzlAcmgQWpzU/qlULRuJQ/7\nTBj0/VLZjmmx6BEP3ojY+x1J96relc8geMJgEtslQIxq/H5COEBkEveegeGTLg==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            04:00:00:00:00:01:0f:86:26:e6:0d\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: OU=GlobalSign Root CA - R2, O=GlobalSign, CN=GlobalSign\n        Validity\n            Not Before: Dec 15 08:00:00 2006 GMT\n            Not After : Dec 15 08:00:00 2021 GMT\n        Subject: OU=GlobalSign Root CA - R2, O=GlobalSign, CN=GlobalSign\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:a6:cf:24:0e:be:2e:6f:28:99:45:42:c4:ab:3e:\n                    21:54:9b:0b:d3:7f:84:70:fa:12:b3:cb:bf:87:5f:\n                    c6:7f:86:d3:b2:30:5c:d6:fd:ad:f1:7b:dc:e5:f8:\n                    60:96:09:92:10:f5:d0:53:de:fb:7b:7e:73:88:ac:\n                    52:88:7b:4a:a6:ca:49:a6:5e:a8:a7:8c:5a:11:bc:\n                    7a:82:eb:be:8c:e9:b3:ac:96:25:07:97:4a:99:2a:\n                    07:2f:b4:1e:77:bf:8a:0f:b5:02:7c:1b:96:b8:c5:\n                    b9:3a:2c:bc:d6:12:b9:eb:59:7d:e2:d0:06:86:5f:\n                    5e:49:6a:b5:39:5e:88:34:ec:bc:78:0c:08:98:84:\n                    6c:a8:cd:4b:b4:a0:7d:0c:79:4d:f0:b8:2d:cb:21:\n                    ca:d5:6c:5b:7d:e1:a0:29:84:a1:f9:d3:94:49:cb:\n                    24:62:91:20:bc:dd:0b:d5:d9:cc:f9:ea:27:0a:2b:\n                    73:91:c6:9d:1b:ac:c8:cb:e8:e0:a0:f4:2f:90:8b:\n                    4d:fb:b0:36:1b:f6:19:7a:85:e0:6d:f2:61:13:88:\n                    5c:9f:e0:93:0a:51:97:8a:5a:ce:af:ab:d5:f7:aa:\n                    09:aa:60:bd:dc:d9:5f:df:72:a9:60:13:5e:00:01:\n                    c9:4a:fa:3f:a4:ea:07:03:21:02:8e:82:ca:03:c2:\n                    9b:8f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                9B:E2:07:57:67:1C:1E:C0:6A:06:DE:59:B4:9A:2D:DF:DC:19:86:2E\n            X509v3 CRL Distribution Points: \n\n                Full Name:\n                  URI:http://crl.globalsign.net/root-r2.crl\n\n            X509v3 Authority Key Identifier: \n                keyid:9B:E2:07:57:67:1C:1E:C0:6A:06:DE:59:B4:9A:2D:DF:DC:19:86:2E\n\n    Signature Algorithm: sha1WithRSAEncryption\n         99:81:53:87:1c:68:97:86:91:ec:e0:4a:b8:44:0b:ab:81:ac:\n         27:4f:d6:c1:b8:1c:43:78:b3:0c:9a:fc:ea:2c:3c:6e:61:1b:\n         4d:4b:29:f5:9f:05:1d:26:c1:b8:e9:83:00:62:45:b6:a9:08:\n         93:b9:a9:33:4b:18:9a:c2:f8:87:88:4e:db:dd:71:34:1a:c1:\n         54:da:46:3f:e0:d3:2a:ab:6d:54:22:f5:3a:62:cd:20:6f:ba:\n         29:89:d7:dd:91:ee:d3:5c:a2:3e:a1:5b:41:f5:df:e5:64:43:\n         2d:e9:d5:39:ab:d2:a2:df:b7:8b:d0:c0:80:19:1c:45:c0:2d:\n         8c:e8:f8:2d:a4:74:56:49:c5:05:b5:4f:15:de:6e:44:78:39:\n         87:a8:7e:bb:f3:79:18:91:bb:f4:6f:9d:c1:f0:8c:35:8c:5d:\n         01:fb:c3:6d:b9:ef:44:6d:79:46:31:7e:0a:fe:a9:82:c1:ff:\n         ef:ab:6e:20:c4:50:c9:5f:9d:4d:9b:17:8c:0c:e5:01:c9:a0:\n         41:6a:73:53:fa:a5:50:b4:6e:25:0f:fb:4c:18:f4:fd:52:d9:\n         8e:69:b1:e8:11:0f:de:88:d8:fb:1d:49:f7:aa:de:95:cf:20:\n         78:c2:60:12:db:25:40:8c:6a:fc:7e:42:38:40:64:12:f7:9e:\n         81:e1:93:2e\nSHA1 Fingerprint=75:E0:AB:B6:13:85:12:27:1C:04:F8:5F:DD:DE:38:E4:B7:24:2E:FE\n",
    "9c5f00dfaa01d7302b3888a2b86d4a9cf2119183": "-----BEGIN CERTIFICATE-----\nMIID7zCCAtegAwIBAgIBADANBgkqhkiG9w0BAQsFADCBmDELMAkGA1UEBhMCVVMx\nEDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxJTAjBgNVBAoT\nHFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xOzA5BgNVBAMTMlN0YXJmaWVs\nZCBTZXJ2aWNlcyBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTA5\nMDkwMTAwMDAwMFoXDTM3MTIzMTIzNTk1OVowgZgxCzAJBgNVBAYTAlVTMRAwDgYD\nVQQIEwdBcml6b25hMRMwEQYDVQQHEwpTY290dHNkYWxlMSUwIwYDVQQKExxTdGFy\nZmllbGQgVGVjaG5vbG9naWVzLCBJbmMuMTswOQYDVQQDEzJTdGFyZmllbGQgU2Vy\ndmljZXMgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgLSBHMjCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBANUMOsQq+U7i9b4Zl1+OiFOxHz/Lz58gE20p\nOsgPfTz3a3Y4Y9k2YKibXlwAgLIvWX/2h/klQ4bnaRtSmpDhcePYLQ1Ob/bISdm2\n8xpWriu2dBTrz/sm4xq6HZYuajtYlIlHVv8loJNwU4PahHQUw2eeBGg6345AWh1K\nTs9DkTvnVtYAcMtS7nt9rjrnvDH5RfbCYM8TWQIrgMw0R9+53pBlbQLPLJGmpufe\nhRhJfGZOozptqbXuNC66DQO4M99H67FrjSXZm86B0UVGMpZwh94CDklDhbZsc7tk\n6mFBrMnUVN+HL8cisibMn1lUaJ/8viovxFUcdUBgF4UCVTmLfwUCAwEAAaNCMEAw\nDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFJxfAN+q\nAdcwKziIorhtSpzyEZGDMA0GCSqGSIb3DQEBCwUAA4IBAQBLNqaEd2ndOxmfZyMI\nbw5hyf2E3F/YNoHN2BtBLZ9g3ccaaNnRbobhiCPPE95Dz+I0swSdHynVv/heyNXB\nve6SbzJ08pGCL72CQnqtKrcgfU28elUSwhXqvfdqlS5sdJ/PHLTyxQGjhdByPq1z\nqwubdQxtRbeOlKyWN7Wg0I8VRw7j6IPdj/3vQQF3zCepYoUz8jcI73HPdwbeyBkd\niEDPfUYd/x7H4c7/I9vG+o1VTqkC50cRRj70/b17KSa7qWFiNyi2LSr2EIZkyXCn\n0q23KXB56jzaYyWf/Wi3MOxw+3WKt21gZ7IeyLnp2KhvAotnDU0mV3HaIPzBSlCN\nsSi6\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 0 (0x0)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Services Root Certificate Authority - G2\n        Validity\n            Not Before: Sep  1 00:00:00 2009 GMT\n            Not After : Dec 31 23:59:59 2037 GMT\n        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Services Root Certificate Authority - G2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:d5:0c:3a:c4:2a:f9:4e:e2:f5:be:19:97:5f:8e:\n                    88:53:b1:1f:3f:cb:cf:9f:20:13:6d:29:3a:c8:0f:\n                    7d:3c:f7:6b:76:38:63:d9:36:60:a8:9b:5e:5c:00:\n                    80:b2:2f:59:7f:f6:87:f9:25:43:86:e7:69:1b:52:\n                    9a:90:e1:71:e3:d8:2d:0d:4e:6f:f6:c8:49:d9:b6:\n                    f3:1a:56:ae:2b:b6:74:14:eb:cf:fb:26:e3:1a:ba:\n                    1d:96:2e:6a:3b:58:94:89:47:56:ff:25:a0:93:70:\n                    53:83:da:84:74:14:c3:67:9e:04:68:3a:df:8e:40:\n                    5a:1d:4a:4e:cf:43:91:3b:e7:56:d6:00:70:cb:52:\n                    ee:7b:7d:ae:3a:e7:bc:31:f9:45:f6:c2:60:cf:13:\n                    59:02:2b:80:cc:34:47:df:b9:de:90:65:6d:02:cf:\n                    2c:91:a6:a6:e7:de:85:18:49:7c:66:4e:a3:3a:6d:\n                    a9:b5:ee:34:2e:ba:0d:03:b8:33:df:47:eb:b1:6b:\n                    8d:25:d9:9b:ce:81:d1:45:46:32:96:70:87:de:02:\n                    0e:49:43:85:b6:6c:73:bb:64:ea:61:41:ac:c9:d4:\n                    54:df:87:2f:c7:22:b2:26:cc:9f:59:54:68:9f:fc:\n                    be:2a:2f:c4:55:1c:75:40:60:17:85:02:55:39:8b:\n                    7f:05\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                9C:5F:00:DF:AA:01:D7:30:2B:38:88:A2:B8:6D:4A:9C:F2:11:91:83\n    Signature Algorithm: sha256WithRSAEncryption\n         4b:36:a6:84:77:69:dd:3b:19:9f:67:23:08:6f:0e:61:c9:fd:\n         84:dc:5f:d8:36:81:cd:d8:1b:41:2d:9f:60:dd:c7:1a:68:d9:\n         d1:6e:86:e1:88:23:cf:13:de:43:cf:e2:34:b3:04:9d:1f:29:\n         d5:bf:f8:5e:c8:d5:c1:bd:ee:92:6f:32:74:f2:91:82:2f:bd:\n         82:42:7a:ad:2a:b7:20:7d:4d:bc:7a:55:12:c2:15:ea:bd:f7:\n         6a:95:2e:6c:74:9f:cf:1c:b4:f2:c5:01:a3:85:d0:72:3e:ad:\n         73:ab:0b:9b:75:0c:6d:45:b7:8e:94:ac:96:37:b5:a0:d0:8f:\n         15:47:0e:e3:e8:83:dd:8f:fd:ef:41:01:77:cc:27:a9:62:85:\n         33:f2:37:08:ef:71:cf:77:06:de:c8:19:1d:88:40:cf:7d:46:\n         1d:ff:1e:c7:e1:ce:ff:23:db:c6:fa:8d:55:4e:a9:02:e7:47:\n         11:46:3e:f4:fd:bd:7b:29:26:bb:a9:61:62:37:28:b6:2d:2a:\n         f6:10:86:64:c9:70:a7:d2:ad:b7:29:70:79:ea:3c:da:63:25:\n         9f:fd:68:b7:30:ec:70:fb:75:8a:b7:6d:60:67:b2:1e:c8:b9:\n         e9:d8:a8:6f:02:8b:67:0d:4d:26:57:71:da:20:fc:c1:4a:50:\n         8d:b1:28:ba\nSHA1 Fingerprint=92:5A:8F:8D:2C:6D:04:E0:66:5F:59:6A:FF:22:D8:63:E8:25:6F:3F\n",
    "9d93c6538b5ecaaf3f9f1e0fe59995bc24f6948f": "-----BEGIN CERTIFICATE-----\nMIIDTDCCAjSgAwIBAgIId3cGJyapsXwwDQYJKoZIhvcNAQELBQAwRDELMAkGA1UE\nBhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MR8wHQYDVQQDDBZBZmZpcm1UcnVz\ndCBDb21tZXJjaWFsMB4XDTEwMDEyOTE0MDYwNloXDTMwMTIzMTE0MDYwNlowRDEL\nMAkGA1UEBhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MR8wHQYDVQQDDBZBZmZp\ncm1UcnVzdCBDb21tZXJjaWFsMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC\nAQEA9htPZwcroRX1BiLLHwGy43NFBkRJLLtJJRTWzsO3qyxPxkEylFf6EqdbDuKP\nHx6GGaeqtS25Xw2Kwq+FNXkyLbscYjfysVtKPcrNcV/pQr6U6Mje+SJIZMblq8Yr\nba0F8PrVC8+a5fBQpIs7R6UjW3p6+DM/uO+Zl+MgwdYoic+U+7lF7eNAFxHUdPAL\nMeIrJmqbTFeurCA+ukV6BfO9m2kVrn1OIGPENXY6BwLJN/3HR+7o8XYdcxXyl6S1\nyHp52UKqK39c/s4mT6NmgTWvRLpUHhwwMmWd5jyTXlBOeuM61G7MGvv50jeuJCqr\nVwMiKA1JdX+3KNp1v47j3A55MQIDAQABo0IwQDAdBgNVHQ4EFgQUnZPGU4teyq8/\nnx4P5ZmVvCT2lI8wDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwDQYJ\nKoZIhvcNAQELBQADggEBAFis9AQOzcAN/wr91LoWXym9e2iZWEnStB03TX8nfUYG\nXUPGhi4+c7ImfU+TqbbEKpqrIZcUsd6M06uJFdhrJNTxFq7YpFzUf1GO7RgBsZNj\nvbz4YYCanrHOQnDiqX0GJX0nof5v7LMeJNrjS1UaADs1tDvZ110w/YETifLCBivt\nZ8SOyUOyXGsViQK8YvxO8rUzqrJv0wqiUOP2O+guRMLbZjipM1ZI8W0bM40NjD9g\nN53Tym1+NH4Nn3J2ixufcv1SNUFFApYvHLKac0khsUlHRUe072o0EclNmsxZt9YC\nnlpOZbWUrhvfKbAW8b8Angc6F2S1BLUjIZkKlTuXfO8=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 8608355977964138876 (0x7777062726a9b17c)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, O=AffirmTrust, CN=AffirmTrust Commercial\n        Validity\n            Not Before: Jan 29 14:06:06 2010 GMT\n            Not After : Dec 31 14:06:06 2030 GMT\n        Subject: C=US, O=AffirmTrust, CN=AffirmTrust Commercial\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:f6:1b:4f:67:07:2b:a1:15:f5:06:22:cb:1f:01:\n                    b2:e3:73:45:06:44:49:2c:bb:49:25:14:d6:ce:c3:\n                    b7:ab:2c:4f:c6:41:32:94:57:fa:12:a7:5b:0e:e2:\n                    8f:1f:1e:86:19:a7:aa:b5:2d:b9:5f:0d:8a:c2:af:\n                    85:35:79:32:2d:bb:1c:62:37:f2:b1:5b:4a:3d:ca:\n                    cd:71:5f:e9:42:be:94:e8:c8:de:f9:22:48:64:c6:\n                    e5:ab:c6:2b:6d:ad:05:f0:fa:d5:0b:cf:9a:e5:f0:\n                    50:a4:8b:3b:47:a5:23:5b:7a:7a:f8:33:3f:b8:ef:\n                    99:97:e3:20:c1:d6:28:89:cf:94:fb:b9:45:ed:e3:\n                    40:17:11:d4:74:f0:0b:31:e2:2b:26:6a:9b:4c:57:\n                    ae:ac:20:3e:ba:45:7a:05:f3:bd:9b:69:15:ae:7d:\n                    4e:20:63:c4:35:76:3a:07:02:c9:37:fd:c7:47:ee:\n                    e8:f1:76:1d:73:15:f2:97:a4:b5:c8:7a:79:d9:42:\n                    aa:2b:7f:5c:fe:ce:26:4f:a3:66:81:35:af:44:ba:\n                    54:1e:1c:30:32:65:9d:e6:3c:93:5e:50:4e:7a:e3:\n                    3a:d4:6e:cc:1a:fb:f9:d2:37:ae:24:2a:ab:57:03:\n                    22:28:0d:49:75:7f:b7:28:da:75:bf:8e:e3:dc:0e:\n                    79:31\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                9D:93:C6:53:8B:5E:CA:AF:3F:9F:1E:0F:E5:99:95:BC:24:F6:94:8F\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         58:ac:f4:04:0e:cd:c0:0d:ff:0a:fd:d4:ba:16:5f:29:bd:7b:\n         68:99:58:49:d2:b4:1d:37:4d:7f:27:7d:46:06:5d:43:c6:86:\n         2e:3e:73:b2:26:7d:4f:93:a9:b6:c4:2a:9a:ab:21:97:14:b1:\n         de:8c:d3:ab:89:15:d8:6b:24:d4:f1:16:ae:d8:a4:5c:d4:7f:\n         51:8e:ed:18:01:b1:93:63:bd:bc:f8:61:80:9a:9e:b1:ce:42:\n         70:e2:a9:7d:06:25:7d:27:a1:fe:6f:ec:b3:1e:24:da:e3:4b:\n         55:1a:00:3b:35:b4:3b:d9:d7:5d:30:fd:81:13:89:f2:c2:06:\n         2b:ed:67:c4:8e:c9:43:b2:5c:6b:15:89:02:bc:62:fc:4e:f2:\n         b5:33:aa:b2:6f:d3:0a:a2:50:e3:f6:3b:e8:2e:44:c2:db:66:\n         38:a9:33:56:48:f1:6d:1b:33:8d:0d:8c:3f:60:37:9d:d3:ca:\n         6d:7e:34:7e:0d:9f:72:76:8b:1b:9f:72:fd:52:35:41:45:02:\n         96:2f:1c:b2:9a:73:49:21:b1:49:47:45:47:b4:ef:6a:34:11:\n         c9:4d:9a:cc:59:b7:d6:02:9e:5a:4e:65:b5:94:ae:1b:df:29:\n         b0:16:f1:bf:00:9e:07:3a:17:64:b5:04:b5:23:21:99:0a:95:\n         3b:97:7c:ef\nSHA1 Fingerprint=F9:B5:B6:32:45:5F:9C:BE:EC:57:5F:80:DC:E9:6E:2C:C7:B2:78:B7\n",
    "9dc067a60c22d926f545aba665521127d845ac63": "-----BEGIN CERTIFICATE-----\nMIIFRjCCAy6gAwIBAgIIbYwURrGmCu4wDQYJKoZIhvcNAQEMBQAwQTELMAkGA1UE\nBhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MRwwGgYDVQQDDBNBZmZpcm1UcnVz\ndCBQcmVtaXVtMB4XDTEwMDEyOTE0MTAzNloXDTQwMTIzMTE0MTAzNlowQTELMAkG\nA1UEBhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MRwwGgYDVQQDDBNBZmZpcm1U\ncnVzdCBQcmVtaXVtMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxBLf\nqV/+Qd3d9Z+K4/as4Tx4mrzY8H96oDMq3I0gW64tb+eT2TZwamjPjlGjhVtnBKAQ\nJG9dKILBl1fYSCkTtuG+kU3fhQxTGJoeJKJPj/CihQvL9Cl/0qRY7iZNyaqoe5rZ\n+jjeRFcV5fiMyNlI4g0WJx0eyIOFJbe6qlVBzAMiSy2RjYvmia9mx+n/K+k8rNrS\ns8PhaJyJ+HoAVt70VZVs+7pk3WKL3wt3MutizCaam7uqYoNMtAZ6MMgpv+0GTZe5\nHMQxK9VfvFMSF5yZVylmd2EhMQcuJUmdGPLu8ytxjLW6OQdJd/zvLpKQBY0tL3d7\n70O/Nbua2Plzpyzy0FfuKE4mX4+QaAkvuPjcBukumj5Rp9EixAqnOEhss/n/fauG\nV+O61oV4d7pD6kh/9ti+I20ev9E2bFhc8e6kGVQa9QPSdubhjL08s9NIS+LI+H+S\nqHZGnEJlPqQewQcDWkYtuJfzt9WyVSHvutxMAJf7FJUnM7/oQ0dG0giZFmA7mn7S\n5u046uwBHjxIVkkJx0w3AJ6IDsBz4W9m6XJHMD4Q5QsDyZpCAGzFlH5hxIrff4Ia\nC1nEWTJ3s7xgaVY5/bQGeyzWZDbZvUjthB9+pSKPKrhC9IK31FOQeE4tGv2Bb0TX\nOwF0lkLgAOIua+rF7nKsu7/+6qqo+Nz2snmKtmcCAwEAAaNCMEAwHQYDVR0OBBYE\nFJ3AZ6YMItkm9UWrpmVSESfYRaxjMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/\nBAQDAgEGMA0GCSqGSIb3DQEBDAUAA4ICAQCzV00QYk465KzquByvMiPIs0laUZx2\nKI15qldGF9X1Uva3ROgIRL8YhNILgM3FEv0AVQVhh0HctSSePMTYyPtwni94loMg\nNt58D2kTiKV1NpgIpsbfrM7jWNa3Pt668+s0QNiigfV4Py/VpfzZotReBA4Xrf5B\n8OWycvpEgjNC6C1Y91aMYj+6QrCcDFx+LmUmXFNPALJ4fqENmS2NuB2OosSw/WDQ\nMKSOyARiqcTtNd56l+0OOF6SL5Nwpamcb6d9Ex1+xghIsV5n61EIJenmJWtSKZGc\n0jlzCFfemQa0W50QBuHCAKi4HEoCChTQwUHK+4w1IX2COPKpVJEZNZOUbWo6xbLQ\nu4mGk+ibyQ86p3q4ofB4Rvr8Ny/lioTz3/4E2aFooC8k4gmVBtWVyuEklut89pMF\nu+1z6S3RdTnX5yTb2E5fQ4+e0BQ5v1VwSJlXMbSc7kqYA5YwH2AG7hsj/oFgIxpH\nYoWlzBk0gG+zrBrjn/B7SK3VAdlntqlyk+otZrWyuOQ9PLLvTIzq6we/qzWaVYa8\nGKa1qF60g2xraUDTn9zxw2lrueFtCfTxqlB2Cnp9ehehVZZCmTEJ3WARjQUwfuaO\nRtGdFNrHF+QFlozEJLUbzxQHskD4o55BhrwE0GuWyCqANP2/7waj3VjFhT0+j/6e\nKeC2uAloGRwYQw==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 7893706540734352110 (0x6d8c1446b1a60aee)\n        Signature Algorithm: sha384WithRSAEncryption\n        Issuer: C=US, O=AffirmTrust, CN=AffirmTrust Premium\n        Validity\n            Not Before: Jan 29 14:10:36 2010 GMT\n            Not After : Dec 31 14:10:36 2040 GMT\n        Subject: C=US, O=AffirmTrust, CN=AffirmTrust Premium\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:c4:12:df:a9:5f:fe:41:dd:dd:f5:9f:8a:e3:f6:\n                    ac:e1:3c:78:9a:bc:d8:f0:7f:7a:a0:33:2a:dc:8d:\n                    20:5b:ae:2d:6f:e7:93:d9:36:70:6a:68:cf:8e:51:\n                    a3:85:5b:67:04:a0:10:24:6f:5d:28:82:c1:97:57:\n                    d8:48:29:13:b6:e1:be:91:4d:df:85:0c:53:18:9a:\n                    1e:24:a2:4f:8f:f0:a2:85:0b:cb:f4:29:7f:d2:a4:\n                    58:ee:26:4d:c9:aa:a8:7b:9a:d9:fa:38:de:44:57:\n                    15:e5:f8:8c:c8:d9:48:e2:0d:16:27:1d:1e:c8:83:\n                    85:25:b7:ba:aa:55:41:cc:03:22:4b:2d:91:8d:8b:\n                    e6:89:af:66:c7:e9:ff:2b:e9:3c:ac:da:d2:b3:c3:\n                    e1:68:9c:89:f8:7a:00:56:de:f4:55:95:6c:fb:ba:\n                    64:dd:62:8b:df:0b:77:32:eb:62:cc:26:9a:9b:bb:\n                    aa:62:83:4c:b4:06:7a:30:c8:29:bf:ed:06:4d:97:\n                    b9:1c:c4:31:2b:d5:5f:bc:53:12:17:9c:99:57:29:\n                    66:77:61:21:31:07:2e:25:49:9d:18:f2:ee:f3:2b:\n                    71:8c:b5:ba:39:07:49:77:fc:ef:2e:92:90:05:8d:\n                    2d:2f:77:7b:ef:43:bf:35:bb:9a:d8:f9:73:a7:2c:\n                    f2:d0:57:ee:28:4e:26:5f:8f:90:68:09:2f:b8:f8:\n                    dc:06:e9:2e:9a:3e:51:a7:d1:22:c4:0a:a7:38:48:\n                    6c:b3:f9:ff:7d:ab:86:57:e3:ba:d6:85:78:77:ba:\n                    43:ea:48:7f:f6:d8:be:23:6d:1e:bf:d1:36:6c:58:\n                    5c:f1:ee:a4:19:54:1a:f5:03:d2:76:e6:e1:8c:bd:\n                    3c:b3:d3:48:4b:e2:c8:f8:7f:92:a8:76:46:9c:42:\n                    65:3e:a4:1e:c1:07:03:5a:46:2d:b8:97:f3:b7:d5:\n                    b2:55:21:ef:ba:dc:4c:00:97:fb:14:95:27:33:bf:\n                    e8:43:47:46:d2:08:99:16:60:3b:9a:7e:d2:e6:ed:\n                    38:ea:ec:01:1e:3c:48:56:49:09:c7:4c:37:00:9e:\n                    88:0e:c0:73:e1:6f:66:e9:72:47:30:3e:10:e5:0b:\n                    03:c9:9a:42:00:6c:c5:94:7e:61:c4:8a:df:7f:82:\n                    1a:0b:59:c4:59:32:77:b3:bc:60:69:56:39:fd:b4:\n                    06:7b:2c:d6:64:36:d9:bd:48:ed:84:1f:7e:a5:22:\n                    8f:2a:b8:42:f4:82:b7:d4:53:90:78:4e:2d:1a:fd:\n                    81:6f:44:d7:3b:01:74:96:42:e0:00:e2:2e:6b:ea:\n                    c5:ee:72:ac:bb:bf:fe:ea:aa:a8:f8:dc:f6:b2:79:\n                    8a:b6:67\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                9D:C0:67:A6:0C:22:D9:26:F5:45:AB:A6:65:52:11:27:D8:45:AC:63\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha384WithRSAEncryption\n         b3:57:4d:10:62:4e:3a:e4:ac:ea:b8:1c:af:32:23:c8:b3:49:\n         5a:51:9c:76:28:8d:79:aa:57:46:17:d5:f5:52:f6:b7:44:e8:\n         08:44:bf:18:84:d2:0b:80:cd:c5:12:fd:00:55:05:61:87:41:\n         dc:b5:24:9e:3c:c4:d8:c8:fb:70:9e:2f:78:96:83:20:36:de:\n         7c:0f:69:13:88:a5:75:36:98:08:a6:c6:df:ac:ce:e3:58:d6:\n         b7:3e:de:ba:f3:eb:34:40:d8:a2:81:f5:78:3f:2f:d5:a5:fc:\n         d9:a2:d4:5e:04:0e:17:ad:fe:41:f0:e5:b2:72:fa:44:82:33:\n         42:e8:2d:58:f7:56:8c:62:3f:ba:42:b0:9c:0c:5c:7e:2e:65:\n         26:5c:53:4f:00:b2:78:7e:a1:0d:99:2d:8d:b8:1d:8e:a2:c4:\n         b0:fd:60:d0:30:a4:8e:c8:04:62:a9:c4:ed:35:de:7a:97:ed:\n         0e:38:5e:92:2f:93:70:a5:a9:9c:6f:a7:7d:13:1d:7e:c6:08:\n         48:b1:5e:67:eb:51:08:25:e9:e6:25:6b:52:29:91:9c:d2:39:\n         73:08:57:de:99:06:b4:5b:9d:10:06:e1:c2:00:a8:b8:1c:4a:\n         02:0a:14:d0:c1:41:ca:fb:8c:35:21:7d:82:38:f2:a9:54:91:\n         19:35:93:94:6d:6a:3a:c5:b2:d0:bb:89:86:93:e8:9b:c9:0f:\n         3a:a7:7a:b8:a1:f0:78:46:fa:fc:37:2f:e5:8a:84:f3:df:fe:\n         04:d9:a1:68:a0:2f:24:e2:09:95:06:d5:95:ca:e1:24:96:eb:\n         7c:f6:93:05:bb:ed:73:e9:2d:d1:75:39:d7:e7:24:db:d8:4e:\n         5f:43:8f:9e:d0:14:39:bf:55:70:48:99:57:31:b4:9c:ee:4a:\n         98:03:96:30:1f:60:06:ee:1b:23:fe:81:60:23:1a:47:62:85:\n         a5:cc:19:34:80:6f:b3:ac:1a:e3:9f:f0:7b:48:ad:d5:01:d9:\n         67:b6:a9:72:93:ea:2d:66:b5:b2:b8:e4:3d:3c:b2:ef:4c:8c:\n         ea:eb:07:bf:ab:35:9a:55:86:bc:18:a6:b5:a8:5e:b4:83:6c:\n         6b:69:40:d3:9f:dc:f1:c3:69:6b:b9:e1:6d:09:f4:f1:aa:50:\n         76:0a:7a:7d:7a:17:a1:55:96:42:99:31:09:dd:60:11:8d:05:\n         30:7e:e6:8e:46:d1:9d:14:da:c7:17:e4:05:96:8c:c4:24:b5:\n         1b:cf:14:07:b2:40:f8:a3:9e:41:86:bc:04:d0:6b:96:c8:2a:\n         80:34:fd:bf:ef:06:a3:dd:58:c5:85:3d:3e:8f:fe:9e:29:e0:\n         b6:b8:09:68:19:1c:18:43\nSHA1 Fingerprint=D8:A6:33:2C:E0:03:6F:B1:85:F6:63:4F:7D:6A:06:65:26:32:28:27\n",
    "9f38c45623c339e8a0716ce8544ce4e83ab1bf67": "-----BEGIN CERTIFICATE-----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\nn/PIjhs4ViFqUZPTkcpG2om3PVODLAgfi49T3f+sHw==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            d9:b5:43:7f:af:a9:39:0f:00:00:00:00:55:65:ad:58\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2015 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - G4\n        Validity\n            Not Before: May 27 11:11:16 2015 GMT\n            Not After : Dec 27 11:41:16 2037 GMT\n        Subject: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2015 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - G4\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:b1:ec:2c:42:ee:e2:d1:30:ff:a5:92:47:e2:2d:\n                    c3:ba:64:97:6d:ca:f7:0d:b5:59:c1:b3:cb:a8:68:\n                    19:d8:af:84:6d:30:70:5d:7e:f3:2e:d2:53:99:e1:\n                    fe:1f:5e:d9:48:af:5d:13:8d:db:ff:63:33:4d:d3:\n                    00:02:bc:c4:f8:d1:06:08:94:79:58:8a:15:de:29:\n                    b3:fd:fd:c4:4f:e8:aa:e2:a0:3b:79:cd:bf:6b:43:\n                    32:dd:d9:74:10:b9:f7:f4:68:d4:bb:d0:87:d5:aa:\n                    4b:8a:2a:6f:2a:04:b5:b2:a6:c7:a0:7a:e6:48:ab:\n                    d2:d1:59:cc:d6:7e:23:e6:97:6c:f0:42:e5:dc:51:\n                    4b:15:41:ed:49:4a:c9:de:10:97:d6:76:c1:ef:a5:\n                    b5:36:14:97:35:d8:78:22:35:52:ef:43:bd:db:27:\n                    db:61:56:82:34:dc:cb:88:60:0c:0b:5a:e5:2c:01:\n                    c6:54:af:d7:aa:c1:10:7b:d2:05:5a:b8:40:9e:86:\n                    a7:c3:90:86:02:56:52:09:7a:9c:d2:27:82:53:4a:\n                    65:52:6a:f5:3c:e7:a8:f2:9c:af:8b:bd:d3:0e:d4:\n                    d4:5e:6e:87:9e:6a:3d:45:1d:d1:5d:1b:f4:e9:0a:\n                    ac:60:99:fb:89:b4:ff:98:2c:cf:7c:1d:e9:02:aa:\n                    04:9a:1e:b8:dc:88:6e:25:b3:6c:66:f7:3c:90:f3:\n                    57:c1:b3:2f:f5:6d:f2:fb:ca:a1:f8:29:9d:46:8b:\n                    b3:6a:f6:e6:67:07:be:2c:67:0a:2a:1f:5a:b2:3e:\n                    57:c4:d3:21:21:63:65:52:91:1b:b1:99:8e:79:7e:\n                    e6:eb:8d:00:d9:5a:aa:ea:73:e8:a4:82:02:47:96:\n                    fe:5b:8e:54:61:a3:eb:2f:4b:30:b0:8b:23:75:72:\n                    7c:21:3c:c8:f6:f1:74:d4:1c:7b:a3:05:55:ee:bb:\n                    4d:3b:32:be:9a:77:66:9e:ac:69:90:22:07:1f:61:\n                    3a:96:be:e5:9a:4f:cc:05:3c:28:59:d3:c1:0c:54:\n                    a8:59:61:bd:c8:72:4c:e8:dc:9f:87:7f:bd:9c:48:\n                    36:5e:95:a3:0e:b9:38:24:55:fc:75:66:eb:02:e3:\n                    08:34:29:4a:c6:e3:2b:2f:33:a0:da:a3:86:a5:12:\n                    97:fd:80:2b:da:14:42:e3:92:bd:3e:f2:5d:5e:67:\n                    74:2e:1c:88:47:29:34:5f:e2:32:a8:9c:25:37:8c:\n                    ba:98:00:97:8b:49:96:1e:fd:25:8a:ac:dc:da:d8:\n                    5d:74:6e:66:b0:ff:44:df:a1:18:c6:be:48:2f:37:\n                    94:78:f8:95:4a:3f:7f:13:5e:5d:59:fd:74:86:43:\n                    63:73:49\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                9F:38:C4:56:23:C3:39:E8:A0:71:6C:E8:54:4C:E4:E8:3A:B1:BF:67\n    Signature Algorithm: sha256WithRSAEncryption\n         12:e5:42:a6:7b:8b:0f:0c:e4:46:a5:b6:60:40:87:8c:25:7e:\n         ad:b8:68:2e:5b:c6:40:76:3c:03:f8:c9:59:f4:f3:ab:62:ce:\n         10:8d:b4:5a:64:8c:68:c0:b0:72:43:34:d2:1b:0b:f6:2c:53:\n         d2:ca:90:4b:86:66:fc:aa:83:22:f4:8b:1a:6f:26:48:ac:76:\n         77:08:bf:c5:98:5c:f4:26:89:9e:7b:c3:b9:64:32:01:7f:d3:\n         c3:dd:58:6d:ec:b1:ab:84:55:74:77:84:04:27:52:6b:86:4c:\n         ce:dd:b9:65:ff:d6:c6:5e:9f:9a:10:99:4b:75:6a:fe:6a:e9:\n         97:20:e4:e4:76:7a:c6:d0:24:aa:90:cd:20:90:ba:47:64:fb:\n         7f:07:b3:53:78:b5:0a:62:f2:73:43:ce:41:2b:81:6a:2e:85:\n         16:94:53:d4:6b:5f:72:22:ab:51:2d:42:d5:00:9c:99:bf:de:\n         bb:94:3b:57:fd:9a:f5:86:cb:56:3b:5b:88:01:e5:7c:28:4b:\n         03:f9:49:83:7c:b2:7f:7c:e3:ed:8e:a1:7f:60:53:8e:55:9d:\n         50:34:12:0f:b7:97:7b:6c:87:4a:44:e7:f5:6d:ec:80:37:f0:\n         58:19:6e:4a:68:76:f0:1f:92:e4:ea:b5:92:d3:61:51:10:0b:\n         ad:a7:d9:5f:c7:5f:dc:1f:a3:5c:8c:a1:7e:9b:b7:9e:d3:56:\n         6f:66:5e:07:96:20:ed:0b:74:fb:66:4e:8b:11:15:e9:81:49:\n         7e:6f:b0:d4:50:7f:22:d7:5f:65:02:0d:a6:f4:85:1e:d8:ae:\n         06:4b:4a:a7:d2:31:66:c2:f8:ce:e5:08:a6:a4:02:96:44:68:\n         57:c4:d5:33:cf:19:2f:14:c4:94:1c:7b:a4:d9:f0:9f:0e:b1:\n         80:e2:d1:9e:11:64:a9:88:11:3a:76:82:e5:62:c2:80:d8:a4:\n         83:ed:93:ef:7c:2f:90:b0:32:4c:96:15:68:48:52:d4:99:08:\n         c0:24:e8:1c:e3:b3:a5:21:0e:92:c0:90:1f:cf:20:5f:ca:3b:\n         38:c7:b7:6d:3a:f3:e6:44:b8:0e:31:6b:88:8e:70:eb:9c:17:\n         52:a8:41:94:2e:87:b6:e7:a6:12:c5:75:df:5b:c0:0a:6e:7b:\n         a4:e4:5e:86:f9:36:94:df:77:c3:e9:0d:c0:39:f1:79:bb:46:\n         8e:ab:43:59:27:b7:20:bb:23:e9:56:40:21:ec:31:3d:65:aa:\n         43:f2:3d:df:70:44:e1:ba:4d:26:10:3b:98:9f:f3:c8:8e:1b:\n         38:56:21:6a:51:93:d3:91:ca:46:da:89:b7:3d:53:83:2c:08:\n         1f:8b:8f:53:dd:ff:ac:1f\nSHA1 Fingerprint=14:88:4E:86:26:37:B0:26:AF:59:62:5C:40:77:EC:35:29:BA:96:01\n",
    "a0110a233e96f107ece2af29ef82a57fd030a4b4": "-----BEGIN CERTIFICATE-----\nMIIEMjCCAxqgAwIBAgIBATANBgkqhkiG9w0BAQUFADB7MQswCQYDVQQGEwJHQjEb\nMBkGA1UECAwSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHDAdTYWxmb3JkMRow\nGAYDVQQKDBFDb21vZG8gQ0EgTGltaXRlZDEhMB8GA1UEAwwYQUFBIENlcnRpZmlj\nYXRlIFNlcnZpY2VzMB4XDTA0MDEwMTAwMDAwMFoXDTI4MTIzMTIzNTk1OVowezEL\nMAkGA1UEBhMCR0IxGzAZBgNVBAgMEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UE\nBwwHU2FsZm9yZDEaMBgGA1UECgwRQ29tb2RvIENBIExpbWl0ZWQxITAfBgNVBAMM\nGEFBQSBDZXJ0aWZpY2F0ZSBTZXJ2aWNlczCCASIwDQYJKoZIhvcNAQEBBQADggEP\nADCCAQoCggEBAL5AnfRu4ep2hxxNRUSOvkbIgwadwSr+GB+O5AL686tdUIoWMQua\nBtDFcCLNSS1UY8y2bmhGC1Pqy0wkwLxyTurxFa70VJoSCsN6sjNg4tqJVfMiWPPe\n3M/vg4aijJRPn2jymJBGhCfHdr/jzDUsi14HZGWCwEiwqJH5YZ92IFCokcdmtet4\nYgNW8IoaE+oxox6gmf049vYnMlhvB/VruPsUK6+3qszWY19zjNoFmag4qMsXeDZR\nrOme9Hg6jc8P2ULimAyrL58OAd7vn5lJ8S3frHRNG5i1R8XlKdH5kBjHYpy+g8cm\nez6KJcfA3Z3mNWgQIJ2P2N7Sw4ScDV7oL8kCAwEAAaOBwDCBvTAdBgNVHQ4EFgQU\noBEKIz6W8Qfs4q8p74Klf9AwpLQwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQF\nMAMBAf8wewYDVR0fBHQwcjA4oDagNIYyaHR0cDovL2NybC5jb21vZG9jYS5jb20v\nQUFBQ2VydGlmaWNhdGVTZXJ2aWNlcy5jcmwwNqA0oDKGMGh0dHA6Ly9jcmwuY29t\nb2RvLm5ldC9BQUFDZXJ0aWZpY2F0ZVNlcnZpY2VzLmNybDANBgkqhkiG9w0BAQUF\nAAOCAQEACFb8AvCb6P+k+tZ7xkSAzk/ExfYAWMymtrwUSWgEdujm7l3sAg9g1o1Q\nGE8mTgHj5rCl7r+8dFRBv/38ErjHT1r0iWAFf2C3BUrz9vHCv8S5dIa2LX1rzNLz\nRt0vxuBqw8M0Ayx9lt1awg6nCpnBBYurDC/zXDrPbDdVCYfeU0BsWO/8tqtlbgT2\nG9w84FoVxp7Z8VlIMCFlA2zs6SFz7JsDoeA3raAVGI/6ugLOpyypEBMs1OUIJqsi\nl2D4kF501KKaU73yqWjgom7C12yxow+ev+to51byrvLjKzg6CYG1a4XXvi3tPxq3\nsmPi9WIsgtRqAEFQ8TmDn5XpNpaYbg==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 1 (0x1)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=Comodo CA Limited, CN=AAA Certificate Services\n        Validity\n            Not Before: Jan  1 00:00:00 2004 GMT\n            Not After : Dec 31 23:59:59 2028 GMT\n        Subject: C=GB, ST=Greater Manchester, L=Salford, O=Comodo CA Limited, CN=AAA Certificate Services\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:be:40:9d:f4:6e:e1:ea:76:87:1c:4d:45:44:8e:\n                    be:46:c8:83:06:9d:c1:2a:fe:18:1f:8e:e4:02:fa:\n                    f3:ab:5d:50:8a:16:31:0b:9a:06:d0:c5:70:22:cd:\n                    49:2d:54:63:cc:b6:6e:68:46:0b:53:ea:cb:4c:24:\n                    c0:bc:72:4e:ea:f1:15:ae:f4:54:9a:12:0a:c3:7a:\n                    b2:33:60:e2:da:89:55:f3:22:58:f3:de:dc:cf:ef:\n                    83:86:a2:8c:94:4f:9f:68:f2:98:90:46:84:27:c7:\n                    76:bf:e3:cc:35:2c:8b:5e:07:64:65:82:c0:48:b0:\n                    a8:91:f9:61:9f:76:20:50:a8:91:c7:66:b5:eb:78:\n                    62:03:56:f0:8a:1a:13:ea:31:a3:1e:a0:99:fd:38:\n                    f6:f6:27:32:58:6f:07:f5:6b:b8:fb:14:2b:af:b7:\n                    aa:cc:d6:63:5f:73:8c:da:05:99:a8:38:a8:cb:17:\n                    78:36:51:ac:e9:9e:f4:78:3a:8d:cf:0f:d9:42:e2:\n                    98:0c:ab:2f:9f:0e:01:de:ef:9f:99:49:f1:2d:df:\n                    ac:74:4d:1b:98:b5:47:c5:e5:29:d1:f9:90:18:c7:\n                    62:9c:be:83:c7:26:7b:3e:8a:25:c7:c0:dd:9d:e6:\n                    35:68:10:20:9d:8f:d8:de:d2:c3:84:9c:0d:5e:e8:\n                    2f:c9\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                A0:11:0A:23:3E:96:F1:07:EC:E2:AF:29:EF:82:A5:7F:D0:30:A4:B4\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 CRL Distribution Points: \n\n                Full Name:\n                  URI:http://crl.comodoca.com/AAACertificateServices.crl\n\n                Full Name:\n                  URI:http://crl.comodo.net/AAACertificateServices.crl\n\n    Signature Algorithm: sha1WithRSAEncryption\n         08:56:fc:02:f0:9b:e8:ff:a4:fa:d6:7b:c6:44:80:ce:4f:c4:\n         c5:f6:00:58:cc:a6:b6:bc:14:49:68:04:76:e8:e6:ee:5d:ec:\n         02:0f:60:d6:8d:50:18:4f:26:4e:01:e3:e6:b0:a5:ee:bf:bc:\n         74:54:41:bf:fd:fc:12:b8:c7:4f:5a:f4:89:60:05:7f:60:b7:\n         05:4a:f3:f6:f1:c2:bf:c4:b9:74:86:b6:2d:7d:6b:cc:d2:f3:\n         46:dd:2f:c6:e0:6a:c3:c3:34:03:2c:7d:96:dd:5a:c2:0e:a7:\n         0a:99:c1:05:8b:ab:0c:2f:f3:5c:3a:cf:6c:37:55:09:87:de:\n         53:40:6c:58:ef:fc:b6:ab:65:6e:04:f6:1b:dc:3c:e0:5a:15:\n         c6:9e:d9:f1:59:48:30:21:65:03:6c:ec:e9:21:73:ec:9b:03:\n         a1:e0:37:ad:a0:15:18:8f:fa:ba:02:ce:a7:2c:a9:10:13:2c:\n         d4:e5:08:26:ab:22:97:60:f8:90:5e:74:d4:a2:9a:53:bd:f2:\n         a9:68:e0:a2:6e:c2:d7:6c:b1:a3:0f:9e:bf:eb:68:e7:56:f2:\n         ae:f2:e3:2b:38:3a:09:81:b5:6b:85:d7:be:2d:ed:3f:1a:b7:\n         b2:63:e2:f5:62:2c:82:d4:6a:00:41:50:f1:39:83:9f:95:e9:\n         36:96:98:6e\nSHA1 Fingerprint=D1:EB:23:A4:6D:17:D6:8F:D9:25:64:C2:F1:F1:60:17:64:D8:E3:49\n",
    "a073499968dc855b65e39b282f579fbd33bc0748": "-----BEGIN CERTIFICATE-----\nMIIDWjCCAkKgAwIBAgIBADANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJKUDEY\nMBYGA1UEChMPU0VDT00gVHJ1c3QubmV0MScwJQYDVQQLEx5TZWN1cml0eSBDb21t\ndW5pY2F0aW9uIFJvb3RDQTEwHhcNMDMwOTMwMDQyMDQ5WhcNMjMwOTMwMDQyMDQ5\nWjBQMQswCQYDVQQGEwJKUDEYMBYGA1UEChMPU0VDT00gVHJ1c3QubmV0MScwJQYD\nVQQLEx5TZWN1cml0eSBDb21tdW5pY2F0aW9uIFJvb3RDQTEwggEiMA0GCSqGSIb3\nDQEBAQUAA4IBDwAwggEKAoIBAQCzs/5/022x7xZ8V6UMbXaKL0u/ZPtM7orw8yl8\n9f/uKuDp6bpbZCKamm8sOiZpUQWZJtzVHGpxxpp9Hp3dfGzGjGdnSj74cbAZJ6kJ\nDKaVv0uMDPpVmDvY6CKhS3E4eayXkmmziX7qIWgGmBSWh9JhNrxtJ1aeV+7AwFb9\nMs+k2Y7CI9eNqPPYJayX5HA49LY6tJ07lyZDo6G8SVlyTCMwhwFY9k6+HGhWZq/N\nQV3Is00qVUarH9oe4kA92819uZKAnDfdDJZkndwi92SL32HeFZRSFaB9UslLqCHJ\nxrHty8OVYNEP8Ktw+N/LTX7s1vqr2b1/VPKl6Xn62dZ2JChzAgMBAAGjPzA9MB0G\nA1UdDgQWBBSgc0mZaNyFW2XjmygvV5+9M7wHSDALBgNVHQ8EBAMCAQYwDwYDVR0T\nAQH/BAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAaECpqLvkT115swW1F7NgE+vG\nkl3g0dNq/vu+m22/xwVtWSDEHPC32oRYAmP6SBbvT6UL90qY8j+eG61Ha2POCEfr\nUj94nK9NrvjVT8+amCoQQTlSxN3Zmw7vkwGusi7KaEIkQmywszo+zenaSMQVy+n5\nBw+SUEmK3TGXX8npN6o7WWWXlDLJs58+OmJYxUmtYg5xpTKqL8aJdkNAExNnPaJU\nJRDL8Try2frbSVa7pv6nQTXD4IhhyYjH3zYQIphZ6rBK+1YWc26sTfcioU+tHXot\nRSflMMFe8toTyyVCUZVHA4xsIcx0Qu1T/zOLjw9XARYvz6buyXAiFL39vmwLAw==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 0 (0x0)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=JP, O=SECOM Trust.net, OU=Security Communication RootCA1\n        Validity\n            Not Before: Sep 30 04:20:49 2003 GMT\n            Not After : Sep 30 04:20:49 2023 GMT\n        Subject: C=JP, O=SECOM Trust.net, OU=Security Communication RootCA1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:b3:b3:fe:7f:d3:6d:b1:ef:16:7c:57:a5:0c:6d:\n                    76:8a:2f:4b:bf:64:fb:4c:ee:8a:f0:f3:29:7c:f5:\n                    ff:ee:2a:e0:e9:e9:ba:5b:64:22:9a:9a:6f:2c:3a:\n                    26:69:51:05:99:26:dc:d5:1c:6a:71:c6:9a:7d:1e:\n                    9d:dd:7c:6c:c6:8c:67:67:4a:3e:f8:71:b0:19:27:\n                    a9:09:0c:a6:95:bf:4b:8c:0c:fa:55:98:3b:d8:e8:\n                    22:a1:4b:71:38:79:ac:97:92:69:b3:89:7e:ea:21:\n                    68:06:98:14:96:87:d2:61:36:bc:6d:27:56:9e:57:\n                    ee:c0:c0:56:fd:32:cf:a4:d9:8e:c2:23:d7:8d:a8:\n                    f3:d8:25:ac:97:e4:70:38:f4:b6:3a:b4:9d:3b:97:\n                    26:43:a3:a1:bc:49:59:72:4c:23:30:87:01:58:f6:\n                    4e:be:1c:68:56:66:af:cd:41:5d:c8:b3:4d:2a:55:\n                    46:ab:1f:da:1e:e2:40:3d:db:cd:7d:b9:92:80:9c:\n                    37:dd:0c:96:64:9d:dc:22:f7:64:8b:df:61:de:15:\n                    94:52:15:a0:7d:52:c9:4b:a8:21:c9:c6:b1:ed:cb:\n                    c3:95:60:d1:0f:f0:ab:70:f8:df:cb:4d:7e:ec:d6:\n                    fa:ab:d9:bd:7f:54:f2:a5:e9:79:fa:d9:d6:76:24:\n                    28:73\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                A0:73:49:99:68:DC:85:5B:65:E3:9B:28:2F:57:9F:BD:33:BC:07:48\n            X509v3 Key Usage: \n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: sha1WithRSAEncryption\n         68:40:a9:a8:bb:e4:4f:5d:79:b3:05:b5:17:b3:60:13:eb:c6:\n         92:5d:e0:d1:d3:6a:fe:fb:be:9b:6d:bf:c7:05:6d:59:20:c4:\n         1c:f0:b7:da:84:58:02:63:fa:48:16:ef:4f:a5:0b:f7:4a:98:\n         f2:3f:9e:1b:ad:47:6b:63:ce:08:47:eb:52:3f:78:9c:af:4d:\n         ae:f8:d5:4f:cf:9a:98:2a:10:41:39:52:c4:dd:d9:9b:0e:ef:\n         93:01:ae:b2:2e:ca:68:42:24:42:6c:b0:b3:3a:3e:cd:e9:da:\n         48:c4:15:cb:e9:f9:07:0f:92:50:49:8a:dd:31:97:5f:c9:e9:\n         37:aa:3b:59:65:97:94:32:c9:b3:9f:3e:3a:62:58:c5:49:ad:\n         62:0e:71:a5:32:aa:2f:c6:89:76:43:40:13:13:67:3d:a2:54:\n         25:10:cb:f1:3a:f2:d9:fa:db:49:56:bb:a6:fe:a7:41:35:c3:\n         e0:88:61:c9:88:c7:df:36:10:22:98:59:ea:b0:4a:fb:56:16:\n         73:6e:ac:4d:f7:22:a1:4f:ad:1d:7a:2d:45:27:e5:30:c1:5e:\n         f2:da:13:cb:25:42:51:95:47:03:8c:6c:21:cc:74:42:ed:53:\n         ff:33:8b:8f:0f:57:01:16:2f:cf:a6:ee:c9:70:22:14:bd:fd:\n         be:6c:0b:03\nSHA1 Fingerprint=36:B1:2B:49:F9:81:9E:D7:4C:9E:BC:38:0F:C6:56:8F:5D:AC:B2:F7\n",
    "a34106ac906dd14aeb75a54a1099b3b1a18b4af7": "-----BEGIN CERTIFICATE-----\nMIICYDCCAgegAwIBAgIMDWpfCD8oXD5Rld9dMAoGCCqGSM49BAMCMIGRMQswCQYD\nVQQGEwJVUzERMA8GA1UECBMISWxsaW5vaXMxEDAOBgNVBAcTB0NoaWNhZ28xITAf\nBgNVBAoTGFRydXN0d2F2ZSBIb2xkaW5ncywgSW5jLjE6MDgGA1UEAxMxVHJ1c3R3\nYXZlIEdsb2JhbCBFQ0MgUDI1NiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0x\nNzA4MjMxOTM1MTBaFw00MjA4MjMxOTM1MTBaMIGRMQswCQYDVQQGEwJVUzERMA8G\nA1UECBMISWxsaW5vaXMxEDAOBgNVBAcTB0NoaWNhZ28xITAfBgNVBAoTGFRydXN0\nd2F2ZSBIb2xkaW5ncywgSW5jLjE6MDgGA1UEAxMxVHJ1c3R3YXZlIEdsb2JhbCBF\nQ0MgUDI1NiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTBZMBMGByqGSM49AgEGCCqG\nSM49AwEHA0IABH77bOYj43MyCMpg5lOcunSNGLB4kFKA3TjASh3RqMyTpJcGOMoN\nFWLGjgEqZZ2q3zSRLoHB5DOSMcT9CTqmP62jQzBBMA8GA1UdEwEB/wQFMAMBAf8w\nDwYDVR0PAQH/BAUDAwcGADAdBgNVHQ4EFgQUo0EGrJBt0UrrdaVKEJmzsaGLSvcw\nCgYIKoZIzj0EAwIDRwAwRAIgB+ZU2g6gWrKuEZ+Hxbb/ad4lvvigtwjzRM4q3wgh\nDDcCIC0mA6AFvWvR9lz4ZcyGbbOcNEhjhAnFjXca4syc4XR7\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            0d:6a:5f:08:3f:28:5c:3e:51:95:df:5d\n        Signature Algorithm: ecdsa-with-SHA256\n        Issuer: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global ECC P256 Certification Authority\n        Validity\n            Not Before: Aug 23 19:35:10 2017 GMT\n            Not After : Aug 23 19:35:10 2042 GMT\n        Subject: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global ECC P256 Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (256 bit)\n                pub:\n                    04:7e:fb:6c:e6:23:e3:73:32:08:ca:60:e6:53:9c:\n                    ba:74:8d:18:b0:78:90:52:80:dd:38:c0:4a:1d:d1:\n                    a8:cc:93:a4:97:06:38:ca:0d:15:62:c6:8e:01:2a:\n                    65:9d:aa:df:34:91:2e:81:c1:e4:33:92:31:c4:fd:\n                    09:3a:a6:3f:ad\n                ASN1 OID: prime256v1\n                NIST CURVE: P-256\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                A3:41:06:AC:90:6D:D1:4A:EB:75:A5:4A:10:99:B3:B1:A1:8B:4A:F7\n    Signature Algorithm: ecdsa-with-SHA256\n         30:44:02:20:07:e6:54:da:0e:a0:5a:b2:ae:11:9f:87:c5:b6:\n         ff:69:de:25:be:f8:a0:b7:08:f3:44:ce:2a:df:08:21:0c:37:\n         02:20:2d:26:03:a0:05:bd:6b:d1:f6:5c:f8:65:cc:86:6d:b3:\n         9c:34:48:63:84:09:c5:8d:77:1a:e2:cc:9c:e1:74:7b\nSHA1 Fingerprint=B4:90:82:DD:45:0C:BE:8B:5B:B1:66:D3:E2:A4:08:26:CD:ED:42:CF\n",
    "a397d6f35ea210e1ab459f3c17643cee01709ccc": "-----BEGIN CERTIFICATE-----\nMIIFYDCCA0igAwIBAgIUeFhfLq0sGUvjNwc1NBMotZbUZZMwDQYJKoZIhvcNAQEL\nBQAwSDELMAkGA1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxHjAc\nBgNVBAMTFVF1b1ZhZGlzIFJvb3QgQ0EgMSBHMzAeFw0xMjAxMTIxNzI3NDRaFw00\nMjAxMTIxNzI3NDRaMEgxCzAJBgNVBAYTAkJNMRkwFwYDVQQKExBRdW9WYWRpcyBM\naW1pdGVkMR4wHAYDVQQDExVRdW9WYWRpcyBSb290IENBIDEgRzMwggIiMA0GCSqG\nSIb3DQEBAQUAA4ICDwAwggIKAoICAQCgvlAQjunybEC0BJyFuTHK3C3kEakEPBtV\nwedYMB0ktMPvhd6MLOHBPd+C5k+tR4ds7FtJwUrVu4/sh6x/gpqG7D0DmVIB0jWe\nrNrwU8lmPNSsAgHaJNM7qAJGr6Qc4/hzWHa39g6QDbXwz8z6+cZM5cOGMAqNF341\n68Xfuw6cwI2H44g4hWf6Pser4BOcBRiYz5P1sZK0/CPTz9XEJ0ngnjybCKOLXSoh\n4Pw5qlPafX7PGglTvF0FBM+hSo+LdoINofjSxxR3W5A2B4GbPgb6Ul5jxaYA/qXp\nUhtStZI5cgMJYr2wYBZupt0lwgNm3fME0UDiTouG9G/lg6AnhF4EwfWQvTA9xO+o\nabw4m6SkltFi2mnAAZauy8RRNOoMqv8hjlmPSlzkYZqn0ukqeI1RPToV7qJZjqlc\n3sX5kCLliEVx3ZGZbHqfPT2YfF72vhZooF6uCyP8Wg+qInYtyaEQHeTTRCOQiJ/G\nKubX9ZqzWB4vMIkIG1SitZgj7Ah3HJVdYdHLiZxfokqRmu8hqkkWCKi9YSgxyXSt\nhfbZxbGL0eUQMk1fiyA6PEkfM4VZDdvLCXVDaXP7a3F98N/ETH3Goy7IlXnLc6KO\nTk0k+17kBL5yG6YnLUlamXrXXAkgt3+UuU/xDRxeiEIbEbfnkduebPRq34wGmAOt\nzCjvpUfzUwIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIB\nBjAdBgNVHQ4EFgQUo5fW816iEOGrRZ88F2Q87gFwnMwwDQYJKoZIhvcNAQELBQAD\nggIBABj6W3X8PnrHX3fHyt/PX8MSxEBd1DKquGrX1RUVRpgjpeaQWxiZTOOtQqOC\nMTaIzen7xASWSIsBx40Bz1szBpZGZnQdT+3Btrm0DWHMY37XLneMlhwqI2hrhVd2\ncDMT/uFPpiN3GPoajOi9ZcnPP/TJF9zrx7zABC4tRi9pZsMbj/7sPtPKlL92CiUN\nqXsCHKnQO18LwIE6PWThv6ctTr1NxNgpxiIY0MWscgKCP6o6ojoilzHdCGPDdRS5\nYCgtW2jgFqlmgiNR9etT2DGbe+m3nUvriBbP+V04ikkwj+3x6xn0dxoxGE1nVGwv\nb2X52z3sIexe9PSLymBlVNFxZPT5pqOBMzYzcfCkeF9OrYMh3jRJjehZrJ3ydlo2\n8hP0r+AJx2EqbPfgna67hkooby7utHnNkDPDs3b69fBsnQGQ+p6Q9pxyz0fawx/k\nNSBT8lTR32GDpgLiJTjehTItXnOQUl1CxM49S+H5GYQd1aJQzEH7QRTDvdbJWqNj\nZgKAvQU6O0ec7AAmTPWIUb+oI38YB7AL7YsmoWTTYUrrXJ/es69nA7Mf3W1daWhp\nq1467HxpvMc7hU6eFbm0FU/DlXpY18ls6Wy58yljXrQs8C097Vpl4KlbQMJImYFt\nnh8GKjwStIsPm6Ik8KaN1nrgS7ZklmOVhMJKzRwuJIczYOXD\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            78:58:5f:2e:ad:2c:19:4b:e3:37:07:35:34:13:28:b5:96:d4:65:93\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 1 G3\n        Validity\n            Not Before: Jan 12 17:27:44 2012 GMT\n            Not After : Jan 12 17:27:44 2042 GMT\n        Subject: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 1 G3\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:a0:be:50:10:8e:e9:f2:6c:40:b4:04:9c:85:b9:\n                    31:ca:dc:2d:e4:11:a9:04:3c:1b:55:c1:e7:58:30:\n                    1d:24:b4:c3:ef:85:de:8c:2c:e1:c1:3d:df:82:e6:\n                    4f:ad:47:87:6c:ec:5b:49:c1:4a:d5:bb:8f:ec:87:\n                    ac:7f:82:9a:86:ec:3d:03:99:52:01:d2:35:9e:ac:\n                    da:f0:53:c9:66:3c:d4:ac:02:01:da:24:d3:3b:a8:\n                    02:46:af:a4:1c:e3:f8:73:58:76:b7:f6:0e:90:0d:\n                    b5:f0:cf:cc:fa:f9:c6:4c:e5:c3:86:30:0a:8d:17:\n                    7e:35:eb:c5:df:bb:0e:9c:c0:8d:87:e3:88:38:85:\n                    67:fa:3e:c7:ab:e0:13:9c:05:18:98:cf:93:f5:b1:\n                    92:b4:fc:23:d3:cf:d5:c4:27:49:e0:9e:3c:9b:08:\n                    a3:8b:5d:2a:21:e0:fc:39:aa:53:da:7d:7e:cf:1a:\n                    09:53:bc:5d:05:04:cf:a1:4a:8f:8b:76:82:0d:a1:\n                    f8:d2:c7:14:77:5b:90:36:07:81:9b:3e:06:fa:52:\n                    5e:63:c5:a6:00:fe:a5:e9:52:1b:52:b5:92:39:72:\n                    03:09:62:bd:b0:60:16:6e:a6:dd:25:c2:03:66:dd:\n                    f3:04:d1:40:e2:4e:8b:86:f4:6f:e5:83:a0:27:84:\n                    5e:04:c1:f5:90:bd:30:3d:c4:ef:a8:69:bc:38:9b:\n                    a4:a4:96:d1:62:da:69:c0:01:96:ae:cb:c4:51:34:\n                    ea:0c:aa:ff:21:8e:59:8f:4a:5c:e4:61:9a:a7:d2:\n                    e9:2a:78:8d:51:3d:3a:15:ee:a2:59:8e:a9:5c:de:\n                    c5:f9:90:22:e5:88:45:71:dd:91:99:6c:7a:9f:3d:\n                    3d:98:7c:5e:f6:be:16:68:a0:5e:ae:0b:23:fc:5a:\n                    0f:aa:22:76:2d:c9:a1:10:1d:e4:d3:44:23:90:88:\n                    9f:c6:2a:e6:d7:f5:9a:b3:58:1e:2f:30:89:08:1b:\n                    54:a2:b5:98:23:ec:08:77:1c:95:5d:61:d1:cb:89:\n                    9c:5f:a2:4a:91:9a:ef:21:aa:49:16:08:a8:bd:61:\n                    28:31:c9:74:ad:85:f6:d9:c5:b1:8b:d1:e5:10:32:\n                    4d:5f:8b:20:3a:3c:49:1f:33:85:59:0d:db:cb:09:\n                    75:43:69:73:fb:6b:71:7d:f0:df:c4:4c:7d:c6:a3:\n                    2e:c8:95:79:cb:73:a2:8e:4e:4d:24:fb:5e:e4:04:\n                    be:72:1b:a6:27:2d:49:5a:99:7a:d7:5c:09:20:b7:\n                    7f:94:b9:4f:f1:0d:1c:5e:88:42:1b:11:b7:e7:91:\n                    db:9e:6c:f4:6a:df:8c:06:98:03:ad:cc:28:ef:a5:\n                    47:f3:53\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                A3:97:D6:F3:5E:A2:10:E1:AB:45:9F:3C:17:64:3C:EE:01:70:9C:CC\n    Signature Algorithm: sha256WithRSAEncryption\n         18:fa:5b:75:fc:3e:7a:c7:5f:77:c7:ca:df:cf:5f:c3:12:c4:\n         40:5d:d4:32:aa:b8:6a:d7:d5:15:15:46:98:23:a5:e6:90:5b:\n         18:99:4c:e3:ad:42:a3:82:31:36:88:cd:e9:fb:c4:04:96:48:\n         8b:01:c7:8d:01:cf:5b:33:06:96:46:66:74:1d:4f:ed:c1:b6:\n         b9:b4:0d:61:cc:63:7e:d7:2e:77:8c:96:1c:2a:23:68:6b:85:\n         57:76:70:33:13:fe:e1:4f:a6:23:77:18:fa:1a:8c:e8:bd:65:\n         c9:cf:3f:f4:c9:17:dc:eb:c7:bc:c0:04:2e:2d:46:2f:69:66:\n         c3:1b:8f:fe:ec:3e:d3:ca:94:bf:76:0a:25:0d:a9:7b:02:1c:\n         a9:d0:3b:5f:0b:c0:81:3a:3d:64:e1:bf:a7:2d:4e:bd:4d:c4:\n         d8:29:c6:22:18:d0:c5:ac:72:02:82:3f:aa:3a:a2:3a:22:97:\n         31:dd:08:63:c3:75:14:b9:60:28:2d:5b:68:e0:16:a9:66:82:\n         23:51:f5:eb:53:d8:31:9b:7b:e9:b7:9d:4b:eb:88:16:cf:f9:\n         5d:38:8a:49:30:8f:ed:f1:eb:19:f4:77:1a:31:18:4d:67:54:\n         6c:2f:6f:65:f9:db:3d:ec:21:ec:5e:f4:f4:8b:ca:60:65:54:\n         d1:71:64:f4:f9:a6:a3:81:33:36:33:71:f0:a4:78:5f:4e:ad:\n         83:21:de:34:49:8d:e8:59:ac:9d:f2:76:5a:36:f2:13:f4:af:\n         e0:09:c7:61:2a:6c:f7:e0:9d:ae:bb:86:4a:28:6f:2e:ee:b4:\n         79:cd:90:33:c3:b3:76:fa:f5:f0:6c:9d:01:90:fa:9e:90:f6:\n         9c:72:cf:47:da:c3:1f:e4:35:20:53:f2:54:d1:df:61:83:a6:\n         02:e2:25:38:de:85:32:2d:5e:73:90:52:5d:42:c4:ce:3d:4b:\n         e1:f9:19:84:1d:d5:a2:50:cc:41:fb:41:14:c3:bd:d6:c9:5a:\n         a3:63:66:02:80:bd:05:3a:3b:47:9c:ec:00:26:4c:f5:88:51:\n         bf:a8:23:7f:18:07:b0:0b:ed:8b:26:a1:64:d3:61:4a:eb:5c:\n         9f:de:b3:af:67:03:b3:1f:dd:6d:5d:69:68:69:ab:5e:3a:ec:\n         7c:69:bc:c7:3b:85:4e:9e:15:b9:b4:15:4f:c3:95:7a:58:d7:\n         c9:6c:e9:6c:b9:f3:29:63:5e:b4:2c:f0:2d:3d:ed:5a:65:e0:\n         a9:5b:40:c2:48:99:81:6d:9e:1f:06:2a:3c:12:b4:8b:0f:9b:\n         a2:24:f0:a6:8d:d6:7a:e0:4b:b6:64:96:63:95:84:c2:4a:cd:\n         1c:2e:24:87:33:60:e5:c3\nSHA1 Fingerprint=1B:8E:EA:57:96:29:1A:C9:39:EA:B8:0A:81:1A:73:73:C0:93:79:67\n",
    "a69142fd13614a239e08a429e5d8130423ee4125": "-----BEGIN CERTIFICATE-----\nMIIEMTCCAxmgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBlTELMAkGA1UEBhMCR1Ix\nRDBCBgNVBAoTO0hlbGxlbmljIEFjYWRlbWljIGFuZCBSZXNlYXJjaCBJbnN0aXR1\ndGlvbnMgQ2VydC4gQXV0aG9yaXR5MUAwPgYDVQQDEzdIZWxsZW5pYyBBY2FkZW1p\nYyBhbmQgUmVzZWFyY2ggSW5zdGl0dXRpb25zIFJvb3RDQSAyMDExMB4XDTExMTIw\nNjEzNDk1MloXDTMxMTIwMTEzNDk1MlowgZUxCzAJBgNVBAYTAkdSMUQwQgYDVQQK\nEztIZWxsZW5pYyBBY2FkZW1pYyBhbmQgUmVzZWFyY2ggSW5zdGl0dXRpb25zIENl\ncnQuIEF1dGhvcml0eTFAMD4GA1UEAxM3SGVsbGVuaWMgQWNhZGVtaWMgYW5kIFJl\nc2VhcmNoIEluc3RpdHV0aW9ucyBSb290Q0EgMjAxMTCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBAKlTAOMupvaO+mDYLZU++CwqVE7NuYRhlFhPjz2L5EPz\ndYmNUeTDN9KKiE15HrcS3UN4SoqS5tdI1Q+kOilENbgH9mgdVc04UfCMJDGFr4PJ\nfel3r+0ae50X+bOdOFAPplp5kYCvN66m0zH7tSYJnTxa71HFK9+WXesyHgLacEns\nbgzImjeN9/E2YEsmLIKe0HjzDQ9jpFEw4fkrJxIH2Oq9GGKYsFk3fb7u8yBRQlqD\n75O6aRXxYp2fmTmCobd0LovUxQt7L/DICto9eQqakxylKHJzkUOap9FNhYS5qXSP\nFEDH3N6sQWRstBmbAmNtJGSPRLIl6s5ddAxjMlyNh+UCAwEAAaOBiTCBhjAPBgNV\nHRMBAf8EBTADAQH/MAsGA1UdDwQEAwIBBjAdBgNVHQ4EFgQUppFC/RNhSiOeCKQp\n5dgTBCPuQSUwRwYDVR0eBEAwPqA8MAWCAy5ncjAFggMuZXUwBoIELmVkdTAGggQu\nb3JnMAWBAy5ncjAFgQMuZXUwBoEELmVkdTAGgQQub3JnMA0GCSqGSIb3DQEBBQUA\nA4IBAQAf73lB4XtuP7KMhjdCSk4cNx6NZrokgclPEg8hwAOXhiVtXdMiKahsog2p\n6z0GW5k6x8zDmjR/qw7IThzh+uTczQ2+vyT+bOdrwg3IBp5OjWEopmr95fZi6hg8\nTqBTnbI6nOulnJEWtk2C4AwFSKls9cz4y51JtPACpf1wA+2KIaWuE4ZJwzNzvoc7\ndIsXRSZMFpGD/md9zU1jZ/rzAxKWeAaNsWftjj++n08C9bMJL/NMh98qy5V8Acys\nNnq/onN694/BtZqhFLKPM58N7yLcZnuEvUUXBj08yrl3NI/K6s8/MT7jiOOASSXI\nl7WdmplNsDz4SgCbZN2fOUvRJ9e4\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 0 (0x0)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=GR, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions RootCA 2011\n        Validity\n            Not Before: Dec  6 13:49:52 2011 GMT\n            Not After : Dec  1 13:49:52 2031 GMT\n        Subject: C=GR, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions RootCA 2011\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:a9:53:00:e3:2e:a6:f6:8e:fa:60:d8:2d:95:3e:\n                    f8:2c:2a:54:4e:cd:b9:84:61:94:58:4f:8f:3d:8b:\n                    e4:43:f3:75:89:8d:51:e4:c3:37:d2:8a:88:4d:79:\n                    1e:b7:12:dd:43:78:4a:8a:92:e6:d7:48:d5:0f:a4:\n                    3a:29:44:35:b8:07:f6:68:1d:55:cd:38:51:f0:8c:\n                    24:31:85:af:83:c9:7d:e9:77:af:ed:1a:7b:9d:17:\n                    f9:b3:9d:38:50:0f:a6:5a:79:91:80:af:37:ae:a6:\n                    d3:31:fb:b5:26:09:9d:3c:5a:ef:51:c5:2b:df:96:\n                    5d:eb:32:1e:02:da:70:49:ec:6e:0c:c8:9a:37:8d:\n                    f7:f1:36:60:4b:26:2c:82:9e:d0:78:f3:0d:0f:63:\n                    a4:51:30:e1:f9:2b:27:12:07:d8:ea:bd:18:62:98:\n                    b0:59:37:7d:be:ee:f3:20:51:42:5a:83:ef:93:ba:\n                    69:15:f1:62:9d:9f:99:39:82:a1:b7:74:2e:8b:d4:\n                    c5:0b:7b:2f:f0:c8:0a:da:3d:79:0a:9a:93:1c:a5:\n                    28:72:73:91:43:9a:a7:d1:4d:85:84:b9:a9:74:8f:\n                    14:40:c7:dc:de:ac:41:64:6c:b4:19:9b:02:63:6d:\n                    24:64:8f:44:b2:25:ea:ce:5d:74:0c:63:32:5c:8d:\n                    87:e5\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: \n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                A6:91:42:FD:13:61:4A:23:9E:08:A4:29:E5:D8:13:04:23:EE:41:25\n            X509v3 Name Constraints: \n                Permitted:\n                  DNS:.gr\n                  DNS:.eu\n                  DNS:.edu\n                  DNS:.org\n                  email:.gr\n                  email:.eu\n                  email:.edu\n                  email:.org\n\n    Signature Algorithm: sha1WithRSAEncryption\n         1f:ef:79:41:e1:7b:6e:3f:b2:8c:86:37:42:4a:4e:1c:37:1e:\n         8d:66:ba:24:81:c9:4f:12:0f:21:c0:03:97:86:25:6d:5d:d3:\n         22:29:a8:6c:a2:0d:a9:eb:3d:06:5b:99:3a:c7:cc:c3:9a:34:\n         7f:ab:0e:c8:4e:1c:e1:fa:e4:dc:cd:0d:be:bf:24:fe:6c:e7:\n         6b:c2:0d:c8:06:9e:4e:8d:61:28:a6:6a:fd:e5:f6:62:ea:18:\n         3c:4e:a0:53:9d:b2:3a:9c:eb:a5:9c:91:16:b6:4d:82:e0:0c:\n         05:48:a9:6c:f5:cc:f8:cb:9d:49:b4:f0:02:a5:fd:70:03:ed:\n         8a:21:a5:ae:13:86:49:c3:33:73:be:87:3b:74:8b:17:45:26:\n         4c:16:91:83:fe:67:7d:cd:4d:63:67:fa:f3:03:12:96:78:06:\n         8d:b1:67:ed:8e:3f:be:9f:4f:02:f5:b3:09:2f:f3:4c:87:df:\n         2a:cb:95:7c:01:cc:ac:36:7a:bf:a2:73:7a:f7:8f:c1:b5:9a:\n         a1:14:b2:8f:33:9f:0d:ef:22:dc:66:7b:84:bd:45:17:06:3d:\n         3c:ca:b9:77:34:8f:ca:ea:cf:3f:31:3e:e3:88:e3:80:49:25:\n         c8:97:b5:9d:9a:99:4d:b0:3c:f8:4a:00:9b:64:dd:9f:39:4b:\n         d1:27:d7:b8\nSHA1 Fingerprint=FE:45:65:9B:79:03:5B:98:A1:61:B5:51:2E:AC:DA:58:09:48:22:4D\n",
    "a7a506b12ca60960eed197e970aebc3b196cdb21": "-----BEGIN CERTIFICATE-----\nMIIDdzCCAl+gAwIBAgIIXDPLYixfszIwDQYJKoZIhvcNAQELBQAwPDEeMBwGA1UE\nAwwVQXRvcyBUcnVzdGVkUm9vdCAyMDExMQ0wCwYDVQQKDARBdG9zMQswCQYDVQQG\nEwJERTAeFw0xMTA3MDcxNDU4MzBaFw0zMDEyMzEyMzU5NTlaMDwxHjAcBgNVBAMM\nFUF0b3MgVHJ1c3RlZFJvb3QgMjAxMTENMAsGA1UECgwEQXRvczELMAkGA1UEBhMC\nREUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCVhTuXbyo7LjvPpvMp\nNb7PGKw+qtn4TaA+Gke5vJrf8v7MPkfoepbCJI419KkM/IL9bcFyYie96mvr54rM\nVD6QUM+A1JX76LWC1BTFtqlVJVfbsVD2sGBkWXppzwO3bw2+yj5vdHLqqjAqc2K+\nSZFhyBH+DgMq92og3AIVDV4VavzjgsG1xZ1kCWyjWZgHJ8cblithdHFsQ/H3NYkQ\n4J7sVaE3IqKHBAUsR320HLliKWYoyrfhk/WklAOZuXCFteZI6o1Q/NnezG8HDt0L\ncp2AMBYHlT8oDv3FdU9T1nSatCQujgKRz3bFmx5VdJx4IbHwLfELn8LVlhgf8FQi\neowHAgMBAAGjfTB7MB0GA1UdDgQWBBSnpQaxLKYJYO7Rl+lwrrw7GWzbITAPBgNV\nHRMBAf8EBTADAQH/MB8GA1UdIwQYMBaAFKelBrEspglg7tGX6XCuvDsZbNshMBgG\nA1UdIAQRMA8wDQYLKwYBBAGwLQMEAQEwDgYDVR0PAQH/BAQDAgGGMA0GCSqGSIb3\nDQEBCwUAA4IBAQAmdzTblEiGKkGdLD4GkGDEjKwLVLgfuXvTBznk+j57sj1O7Z8j\nvZfza1zv7v1Apt+hk6EKhqzvINB5Ab149xnYJDE0BAGmuhWawyfc2E8PzBhj/5kP\nDpFrdRbhIfzYJsdHt6bPWHJxfrrhTZVHO8mvbaG0weyJ9rQPOLXiZNwlz6bb65pc\nmaHFCN795trV1lpFDMS3wrUU77QR/w4VtfX128a961qn8FYiqTxlVMYVqL2Gns2D\nlmh6cYGJ4Qvh6hEbaAjMaZ7snkGeRDImeuKHCnE96+RapNLbxc3G3mB/ufNPRJLv\nKrcYPqcZ2Qt9sTdBQrC6YB3y/gkRsPCHe6ed\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 6643877497813316402 (0x5c33cb622c5fb332)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: CN=Atos TrustedRoot 2011, O=Atos, C=DE\n        Validity\n            Not Before: Jul  7 14:58:30 2011 GMT\n            Not After : Dec 31 23:59:59 2030 GMT\n        Subject: CN=Atos TrustedRoot 2011, O=Atos, C=DE\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:95:85:3b:97:6f:2a:3b:2e:3b:cf:a6:f3:29:35:\n                    be:cf:18:ac:3e:aa:d9:f8:4d:a0:3e:1a:47:b9:bc:\n                    9a:df:f2:fe:cc:3e:47:e8:7a:96:c2:24:8e:35:f4:\n                    a9:0c:fc:82:fd:6d:c1:72:62:27:bd:ea:6b:eb:e7:\n                    8a:cc:54:3e:90:50:cf:80:d4:95:fb:e8:b5:82:d4:\n                    14:c5:b6:a9:55:25:57:db:b1:50:f6:b0:60:64:59:\n                    7a:69:cf:03:b7:6f:0d:be:ca:3e:6f:74:72:ea:aa:\n                    30:2a:73:62:be:49:91:61:c8:11:fe:0e:03:2a:f7:\n                    6a:20:dc:02:15:0d:5e:15:6a:fc:e3:82:c1:b5:c5:\n                    9d:64:09:6c:a3:59:98:07:27:c7:1b:96:2b:61:74:\n                    71:6c:43:f1:f7:35:89:10:e0:9e:ec:55:a1:37:22:\n                    a2:87:04:05:2c:47:7d:b4:1c:b9:62:29:66:28:ca:\n                    b7:e1:93:f5:a4:94:03:99:b9:70:85:b5:e6:48:ea:\n                    8d:50:fc:d9:de:cc:6f:07:0e:dd:0b:72:9d:80:30:\n                    16:07:95:3f:28:0e:fd:c5:75:4f:53:d6:74:9a:b4:\n                    24:2e:8e:02:91:cf:76:c5:9b:1e:55:74:9c:78:21:\n                    b1:f0:2d:f1:0b:9f:c2:d5:96:18:1f:f0:54:22:7a:\n                    8c:07\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                A7:A5:06:B1:2C:A6:09:60:EE:D1:97:E9:70:AE:BC:3B:19:6C:DB:21\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Authority Key Identifier: \n                keyid:A7:A5:06:B1:2C:A6:09:60:EE:D1:97:E9:70:AE:BC:3B:19:6C:DB:21\n\n            X509v3 Certificate Policies: \n                Policy: 1.3.6.1.4.1.6189.3.4.1.1\n\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         26:77:34:db:94:48:86:2a:41:9d:2c:3e:06:90:60:c4:8c:ac:\n         0b:54:b8:1f:b9:7b:d3:07:39:e4:fa:3e:7b:b2:3d:4e:ed:9f:\n         23:bd:97:f3:6b:5c:ef:ee:fd:40:a6:df:a1:93:a1:0a:86:ac:\n         ef:20:d0:79:01:bd:78:f7:19:d8:24:31:34:04:01:a6:ba:15:\n         9a:c3:27:dc:d8:4f:0f:cc:18:63:ff:99:0f:0e:91:6b:75:16:\n         e1:21:fc:d8:26:c7:47:b7:a6:cf:58:72:71:7e:ba:e1:4d:95:\n         47:3b:c9:af:6d:a1:b4:c1:ec:89:f6:b4:0f:38:b5:e2:64:dc:\n         25:cf:a6:db:eb:9a:5c:99:a1:c5:08:de:fd:e6:da:d5:d6:5a:\n         45:0c:c4:b7:c2:b5:14:ef:b4:11:ff:0e:15:b5:f5:f5:db:c6:\n         bd:eb:5a:a7:f0:56:22:a9:3c:65:54:c6:15:a8:bd:86:9e:cd:\n         83:96:68:7a:71:81:89:e1:0b:e1:ea:11:1b:68:08:cc:69:9e:\n         ec:9e:41:9e:44:32:26:7a:e2:87:0a:71:3d:eb:e4:5a:a4:d2:\n         db:c5:cd:c6:de:60:7f:b9:f3:4f:44:92:ef:2a:b7:18:3e:a7:\n         19:d9:0b:7d:b1:37:41:42:b0:ba:60:1d:f2:fe:09:11:b0:f0:\n         87:7b:a7:9d\nSHA1 Fingerprint=2B:B1:F5:3E:55:0C:1D:C5:F1:D4:E6:B7:6A:46:4B:55:06:02:AC:21\n",
    "abb6dbd7069e37ac3086079170c79cc419b178c0": "-----BEGIN CERTIFICATE-----\nMIIBtjCCAVugAwIBAgITBmyf1XSXNmY/Owua2eiedgPySjAKBggqhkjOPQQDAjA5\nMQswCQYDVQQGEwJVUzEPMA0GA1UEChMGQW1hem9uMRkwFwYDVQQDExBBbWF6b24g\nUm9vdCBDQSAzMB4XDTE1MDUyNjAwMDAwMFoXDTQwMDUyNjAwMDAwMFowOTELMAkG\nA1UEBhMCVVMxDzANBgNVBAoTBkFtYXpvbjEZMBcGA1UEAxMQQW1hem9uIFJvb3Qg\nQ0EgMzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABCmXp8ZBf8ANm+gBG1bG8lKl\nui2yEujSLtf6ycXYqm0fc4E7O5hrOXwzpcVOho6AF2hiRVd9RFgdszflZwjrZt6j\nQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgGGMB0GA1UdDgQWBBSr\nttvXBp43rDCGB5Fwx5zEGbF4wDAKBggqhkjOPQQDAgNJADBGAiEA4IWSoxe3jfkr\nBqWTrBqYaGFy+uGh0PsceGCmQ5nFuMQCIQCcAu/xlJyzlvnrxir4tiz+OpAUFteM\nYyRIHN8wfdVoOw==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            06:6c:9f:d5:74:97:36:66:3f:3b:0b:9a:d9:e8:9e:76:03:f2:4a\n        Signature Algorithm: ecdsa-with-SHA256\n        Issuer: C=US, O=Amazon, CN=Amazon Root CA 3\n        Validity\n            Not Before: May 26 00:00:00 2015 GMT\n            Not After : May 26 00:00:00 2040 GMT\n        Subject: C=US, O=Amazon, CN=Amazon Root CA 3\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (256 bit)\n                pub:\n                    04:29:97:a7:c6:41:7f:c0:0d:9b:e8:01:1b:56:c6:\n                    f2:52:a5:ba:2d:b2:12:e8:d2:2e:d7:fa:c9:c5:d8:\n                    aa:6d:1f:73:81:3b:3b:98:6b:39:7c:33:a5:c5:4e:\n                    86:8e:80:17:68:62:45:57:7d:44:58:1d:b3:37:e5:\n                    67:08:eb:66:de\n                ASN1 OID: prime256v1\n                NIST CURVE: P-256\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                AB:B6:DB:D7:06:9E:37:AC:30:86:07:91:70:C7:9C:C4:19:B1:78:C0\n    Signature Algorithm: ecdsa-with-SHA256\n         30:46:02:21:00:e0:85:92:a3:17:b7:8d:f9:2b:06:a5:93:ac:\n         1a:98:68:61:72:fa:e1:a1:d0:fb:1c:78:60:a6:43:99:c5:b8:\n         c4:02:21:00:9c:02:ef:f1:94:9c:b3:96:f9:eb:c6:2a:f8:b6:\n         2c:fe:3a:90:14:16:d7:8c:63:24:48:1c:df:30:7d:d5:68:3b\nSHA1 Fingerprint=0D:44:DD:8C:3C:8C:1A:1A:58:75:64:81:E9:0F:2E:2A:FF:B3:D2:6E\n",
    "ae6c05a39313e2a2e7e2d71cd6c7f07fc86753a0": "-----BEGIN CERTIFICATE-----\nMIIFgzCCA2ugAwIBAgIORea7A4Mzw4VlSOb/RVEwDQYJKoZIhvcNAQEMBQAwTDEg\nMB4GA1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjYxEzARBgNVBAoTCkdsb2Jh\nbFNpZ24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMTQxMjEwMDAwMDAwWhcNMzQx\nMjEwMDAwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSNjET\nMBEGA1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCAiIwDQYJ\nKoZIhvcNAQEBBQADggIPADCCAgoCggIBAJUH6HPKZvnsFMp7PPcNCPG0RQssgrRI\nxutbPK6DuEGSMxSkb3/pKszGsIhrxbaJ0cay/xTOURQh7ErdG1rG1ofuTToVBu1k\nZguSgMpE3nOUTvOniX9PeGMIyBJQbUJmL025eShNUhqKGoC3GYEOfsSKvGRMIRxD\naNc9PIrFsmbVkJq3MQbFvuJtMgamHvm566qjuL++gmNQ0PAYid/kD3n16qIfKtJw\nLnvnvJO7bVPiSHyMEAc4/2ayd2F+4OqMPKq0pPbzlUoSB239jLKJz9CgYXfIWHSw\n1CM69106yqLbnQneXUQtkPGBzVeS+n68UARjNN9rkxi+azayOeSsJDa38O+2HBNX\nk7besvjihbdzorg1qkXy4J02oW9UivFyVm4uiMVRQkQVlO6jxTiWm05OWgtH8wY2\nSXcwvHE35absIQh1/OZhFj931dmRl4QKbNQCTXTAFO39OfuD8l4UoQSwC+n+7o/h\nbguyCLNhZglqsQY6ZZZZwPA1/cnaKI0aEYdwgQqomnUdnjqGBQCe24DWJfncBZ4n\nWUx2OVvq+aWh2IMP0f/fMBH5hc8zSPXKbWQULHpYT9NLCEnFlWQaYw55PfWzjMpY\nrZxCRXluDocZXFSxZba/jJvcE+kNb7gu3GduyYsRtYQUigAZcIN5kZeR1Bonvzce\nMgfYFGM8KEyvAgMBAAGjYzBhMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTAD\nAQH/MB0GA1UdDgQWBBSubAWjkxPioufi1xzWx/B/yGdToDAfBgNVHSMEGDAWgBSu\nbAWjkxPioufi1xzWx/B/yGdToDANBgkqhkiG9w0BAQwFAAOCAgEAgyXt6NH9lVLN\nnsAEoJFp5lzQhN7craJP6Ed41mWYqVuoPId8AorRbrcWc+ZfwFSY1XS+wc3iEZGt\nIxg93eFyRJa0lV7Ae46ZeBZDE1ZXs6KzO7V33EByrKPrmzU+sQghoefEQzd5Mr61\n55wsTLxDKZmOMNOsIeDjHfrYBzN2VAAiKrlNIC5waNrlU/yDXNOd8v9EDERm8tLj\nvUYAGm0CuiVdjaExUd1URhxN25mW7xocBFymFe944Hn+Xds+qkxV/ZoVqW/hpvvf\ncDDpw+5CRu3CkwWJ+n1jez/QcYF8AOiYrg54NMMl+68KnyBr3TsTjxKM4kEaSHpz\noHdpx7Zcf4LIHv5YGygrqGytXm3ABdJ7t+uA/iU3/gKbaKxCXcPu9czc8FB10jZp\nnOZ7BN9uBmm23goJSFmH63sUYHpkqmlD75HHTOwY3WzvUy2MmeFe8nI+z1TIvWfs\npA9MRf/TuTAjB0yPEL+GltmZWrSZVxykzLsViVO6LAUP5MSeGbEYNNVMnbrt9x+v\nJJUEeKgDu+6B5dpffItKoZB0JaezPkvILFa9x8jvOOJckvB595yEunQtYQEgfn7R\n8k8HWV+LLUNS60YMlOH1Zkd5d9VUWx+tJDfLRVpOoERIyNiwmcUVhAn21klJwGW4\n5hpxbqCo8YLoRT5s1gLXCmeDBVrJpBA=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            45:e6:bb:03:83:33:c3:85:65:48:e6:ff:45:51\n        Signature Algorithm: sha384WithRSAEncryption\n        Issuer: OU=GlobalSign Root CA - R6, O=GlobalSign, CN=GlobalSign\n        Validity\n            Not Before: Dec 10 00:00:00 2014 GMT\n            Not After : Dec 10 00:00:00 2034 GMT\n        Subject: OU=GlobalSign Root CA - R6, O=GlobalSign, CN=GlobalSign\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:95:07:e8:73:ca:66:f9:ec:14:ca:7b:3c:f7:0d:\n                    08:f1:b4:45:0b:2c:82:b4:48:c6:eb:5b:3c:ae:83:\n                    b8:41:92:33:14:a4:6f:7f:e9:2a:cc:c6:b0:88:6b:\n                    c5:b6:89:d1:c6:b2:ff:14:ce:51:14:21:ec:4a:dd:\n                    1b:5a:c6:d6:87:ee:4d:3a:15:06:ed:64:66:0b:92:\n                    80:ca:44:de:73:94:4e:f3:a7:89:7f:4f:78:63:08:\n                    c8:12:50:6d:42:66:2f:4d:b9:79:28:4d:52:1a:8a:\n                    1a:80:b7:19:81:0e:7e:c4:8a:bc:64:4c:21:1c:43:\n                    68:d7:3d:3c:8a:c5:b2:66:d5:90:9a:b7:31:06:c5:\n                    be:e2:6d:32:06:a6:1e:f9:b9:eb:aa:a3:b8:bf:be:\n                    82:63:50:d0:f0:18:89:df:e4:0f:79:f5:ea:a2:1f:\n                    2a:d2:70:2e:7b:e7:bc:93:bb:6d:53:e2:48:7c:8c:\n                    10:07:38:ff:66:b2:77:61:7e:e0:ea:8c:3c:aa:b4:\n                    a4:f6:f3:95:4a:12:07:6d:fd:8c:b2:89:cf:d0:a0:\n                    61:77:c8:58:74:b0:d4:23:3a:f7:5d:3a:ca:a2:db:\n                    9d:09:de:5d:44:2d:90:f1:81:cd:57:92:fa:7e:bc:\n                    50:04:63:34:df:6b:93:18:be:6b:36:b2:39:e4:ac:\n                    24:36:b7:f0:ef:b6:1c:13:57:93:b6:de:b2:f8:e2:\n                    85:b7:73:a2:b8:35:aa:45:f2:e0:9d:36:a1:6f:54:\n                    8a:f1:72:56:6e:2e:88:c5:51:42:44:15:94:ee:a3:\n                    c5:38:96:9b:4e:4e:5a:0b:47:f3:06:36:49:77:30:\n                    bc:71:37:e5:a6:ec:21:08:75:fc:e6:61:16:3f:77:\n                    d5:d9:91:97:84:0a:6c:d4:02:4d:74:c0:14:ed:fd:\n                    39:fb:83:f2:5e:14:a1:04:b0:0b:e9:fe:ee:8f:e1:\n                    6e:0b:b2:08:b3:61:66:09:6a:b1:06:3a:65:96:59:\n                    c0:f0:35:fd:c9:da:28:8d:1a:11:87:70:81:0a:a8:\n                    9a:75:1d:9e:3a:86:05:00:9e:db:80:d6:25:f9:dc:\n                    05:9e:27:59:4c:76:39:5b:ea:f9:a5:a1:d8:83:0f:\n                    d1:ff:df:30:11:f9:85:cf:33:48:f5:ca:6d:64:14:\n                    2c:7a:58:4f:d3:4b:08:49:c5:95:64:1a:63:0e:79:\n                    3d:f5:b3:8c:ca:58:ad:9c:42:45:79:6e:0e:87:19:\n                    5c:54:b1:65:b6:bf:8c:9b:dc:13:e9:0d:6f:b8:2e:\n                    dc:67:6e:c9:8b:11:b5:84:14:8a:00:19:70:83:79:\n                    91:97:91:d4:1a:27:bf:37:1e:32:07:d8:14:63:3c:\n                    28:4c:af\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                AE:6C:05:A3:93:13:E2:A2:E7:E2:D7:1C:D6:C7:F0:7F:C8:67:53:A0\n            X509v3 Authority Key Identifier: \n                keyid:AE:6C:05:A3:93:13:E2:A2:E7:E2:D7:1C:D6:C7:F0:7F:C8:67:53:A0\n\n    Signature Algorithm: sha384WithRSAEncryption\n         83:25:ed:e8:d1:fd:95:52:cd:9e:c0:04:a0:91:69:e6:5c:d0:\n         84:de:dc:ad:a2:4f:e8:47:78:d6:65:98:a9:5b:a8:3c:87:7c:\n         02:8a:d1:6e:b7:16:73:e6:5f:c0:54:98:d5:74:be:c1:cd:e2:\n         11:91:ad:23:18:3d:dd:e1:72:44:96:b4:95:5e:c0:7b:8e:99:\n         78:16:43:13:56:57:b3:a2:b3:3b:b5:77:dc:40:72:ac:a3:eb:\n         9b:35:3e:b1:08:21:a1:e7:c4:43:37:79:32:be:b5:e7:9c:2c:\n         4c:bc:43:29:99:8e:30:d3:ac:21:e0:e3:1d:fa:d8:07:33:76:\n         54:00:22:2a:b9:4d:20:2e:70:68:da:e5:53:fc:83:5c:d3:9d:\n         f2:ff:44:0c:44:66:f2:d2:e3:bd:46:00:1a:6d:02:ba:25:5d:\n         8d:a1:31:51:dd:54:46:1c:4d:db:99:96:ef:1a:1c:04:5c:a6:\n         15:ef:78:e0:79:fe:5d:db:3e:aa:4c:55:fd:9a:15:a9:6f:e1:\n         a6:fb:df:70:30:e9:c3:ee:42:46:ed:c2:93:05:89:fa:7d:63:\n         7b:3f:d0:71:81:7c:00:e8:98:ae:0e:78:34:c3:25:fb:af:0a:\n         9f:20:6b:dd:3b:13:8f:12:8c:e2:41:1a:48:7a:73:a0:77:69:\n         c7:b6:5c:7f:82:c8:1e:fe:58:1b:28:2b:a8:6c:ad:5e:6d:c0:\n         05:d2:7b:b7:eb:80:fe:25:37:fe:02:9b:68:ac:42:5d:c3:ee:\n         f5:cc:dc:f0:50:75:d2:36:69:9c:e6:7b:04:df:6e:06:69:b6:\n         de:0a:09:48:59:87:eb:7b:14:60:7a:64:aa:69:43:ef:91:c7:\n         4c:ec:18:dd:6c:ef:53:2d:8c:99:e1:5e:f2:72:3e:cf:54:c8:\n         bd:67:ec:a4:0f:4c:45:ff:d3:b9:30:23:07:4c:8f:10:bf:86:\n         96:d9:99:5a:b4:99:57:1c:a4:cc:bb:15:89:53:ba:2c:05:0f:\n         e4:c4:9e:19:b1:18:34:d5:4c:9d:ba:ed:f7:1f:af:24:95:04:\n         78:a8:03:bb:ee:81:e5:da:5f:7c:8b:4a:a1:90:74:25:a7:b3:\n         3e:4b:c8:2c:56:bd:c7:c8:ef:38:e2:5c:92:f0:79:f7:9c:84:\n         ba:74:2d:61:01:20:7e:7e:d1:f2:4f:07:59:5f:8b:2d:43:52:\n         eb:46:0c:94:e1:f5:66:47:79:77:d5:54:5b:1f:ad:24:37:cb:\n         45:5a:4e:a0:44:48:c8:d8:b0:99:c5:15:84:09:f6:d6:49:49:\n         c0:65:b8:e6:1a:71:6e:a0:a8:f1:82:e8:45:3e:6c:d6:02:d7:\n         0a:67:83:05:5a:c9:a4:10\nSHA1 Fingerprint=80:94:64:0E:B5:A7:A1:CA:11:9C:1F:DD:D5:9F:81:02:63:A7:FB:D1\n",
    "af4404c2417e4883db4e3902ecec847ae6cec9a4": "-----BEGIN CERTIFICATE-----\nMIIDvDCCAqSgAwIBAgIQB1YipOjUiolN9BPI8PjqpTANBgkqhkiG9w0BAQUFADBK\nMQswCQYDVQQGEwJVUzEgMB4GA1UEChMXU2VjdXJlVHJ1c3QgQ29ycG9yYXRpb24x\nGTAXBgNVBAMTEFNlY3VyZSBHbG9iYWwgQ0EwHhcNMDYxMTA3MTk0MjI4WhcNMjkx\nMjMxMTk1MjA2WjBKMQswCQYDVQQGEwJVUzEgMB4GA1UEChMXU2VjdXJlVHJ1c3Qg\nQ29ycG9yYXRpb24xGTAXBgNVBAMTEFNlY3VyZSBHbG9iYWwgQ0EwggEiMA0GCSqG\nSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCvNS7YrGxVaQZx5RNoJLNP2MwhR/jxYDiJ\niQPpvepeRlMJ3Fz1Wuj3RSoC6zFh1ykzTM7HfAo3fg+6MpjhHZevj8fcyTiW89sa\n/FHtaMbQbqR8JNGuQsiWUGMu4P51/pinX0kuleM5M2SOHqRfkNJnPLLZ/kG5VacJ\njnIFHovdRIWCQtBJwB1g8NEXLJXr9qXBkqPFwqcIYA1gBBCWeZ4WNOaptvolRTnI\nHmX5k/Wq8VLcmZg9pYYaDDUz+kulBAYVHDGA76oYa8J719rO+TMg1fW9ajMtgQT7\nsFzUnKPiXB3jqUJ1XnvUd+85VLrJChgbEplJL4hL/VBi0XPnj3pDAgMBAAGjgZ0w\ngZowEwYJKwYBBAGCNxQCBAYeBABDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQF\nMAMBAf8wHQYDVR0OBBYEFK9EBMJBfkiD2045AuzshHrmzsmkMDQGA1UdHwQtMCsw\nKaAnoCWGI2h0dHA6Ly9jcmwuc2VjdXJldHJ1c3QuY29tL1NHQ0EuY3JsMBAGCSsG\nAQQBgjcVAQQDAgEAMA0GCSqGSIb3DQEBBQUAA4IBAQBjGghAfaReUw132HquHw0L\nURYD7xh8yOOvaliTFGCRsoTciE6+OYo68+aCiV0BN7OrJKQVDpI1WkpEXk5X+nXO\nH0jOZvQ8QCaSmGwb7iRGDBezUqXbpZGRzzfTb+cnCDpOGR86p1hcF895P4vkp9Mm\nI50mD1hp/Ed+stCNi5O/KU9DaXR2Z0vPB4zmAve14bRDtUstFJ/53CYNv6ZHdAbY\niNE6KTCEztI5gGIbqMdXSbxqVVFnFUq+NQfk1XWYN3kwFNspnWzFacxHVaIw98xc\nf8LDmBxrThaA63p4ZUWiABqvDA1VZDRIuJK58bRQKfJPIx/abKwfROHdI3hRW8cW\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            07:56:22:a4:e8:d4:8a:89:4d:f4:13:c8:f0:f8:ea:a5\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=US, O=SecureTrust Corporation, CN=Secure Global CA\n        Validity\n            Not Before: Nov  7 19:42:28 2006 GMT\n            Not After : Dec 31 19:52:06 2029 GMT\n        Subject: C=US, O=SecureTrust Corporation, CN=Secure Global CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:af:35:2e:d8:ac:6c:55:69:06:71:e5:13:68:24:\n                    b3:4f:d8:cc:21:47:f8:f1:60:38:89:89:03:e9:bd:\n                    ea:5e:46:53:09:dc:5c:f5:5a:e8:f7:45:2a:02:eb:\n                    31:61:d7:29:33:4c:ce:c7:7c:0a:37:7e:0f:ba:32:\n                    98:e1:1d:97:af:8f:c7:dc:c9:38:96:f3:db:1a:fc:\n                    51:ed:68:c6:d0:6e:a4:7c:24:d1:ae:42:c8:96:50:\n                    63:2e:e0:fe:75:fe:98:a7:5f:49:2e:95:e3:39:33:\n                    64:8e:1e:a4:5f:90:d2:67:3c:b2:d9:fe:41:b9:55:\n                    a7:09:8e:72:05:1e:8b:dd:44:85:82:42:d0:49:c0:\n                    1d:60:f0:d1:17:2c:95:eb:f6:a5:c1:92:a3:c5:c2:\n                    a7:08:60:0d:60:04:10:96:79:9e:16:34:e6:a9:b6:\n                    fa:25:45:39:c8:1e:65:f9:93:f5:aa:f1:52:dc:99:\n                    98:3d:a5:86:1a:0c:35:33:fa:4b:a5:04:06:15:1c:\n                    31:80:ef:aa:18:6b:c2:7b:d7:da:ce:f9:33:20:d5:\n                    f5:bd:6a:33:2d:81:04:fb:b0:5c:d4:9c:a3:e2:5c:\n                    1d:e3:a9:42:75:5e:7b:d4:77:ef:39:54:ba:c9:0a:\n                    18:1b:12:99:49:2f:88:4b:fd:50:62:d1:73:e7:8f:\n                    7a:43\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            1.3.6.1.4.1.311.20.2: \n                ...C.A\n            X509v3 Key Usage: \n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                AF:44:04:C2:41:7E:48:83:DB:4E:39:02:EC:EC:84:7A:E6:CE:C9:A4\n            X509v3 CRL Distribution Points: \n\n                Full Name:\n                  URI:http://crl.securetrust.com/SGCA.crl\n\n            1.3.6.1.4.1.311.21.1: \n                ...\n    Signature Algorithm: sha1WithRSAEncryption\n         63:1a:08:40:7d:a4:5e:53:0d:77:d8:7a:ae:1f:0d:0b:51:16:\n         03:ef:18:7c:c8:e3:af:6a:58:93:14:60:91:b2:84:dc:88:4e:\n         be:39:8a:3a:f3:e6:82:89:5d:01:37:b3:ab:24:a4:15:0e:92:\n         35:5a:4a:44:5e:4e:57:fa:75:ce:1f:48:ce:66:f4:3c:40:26:\n         92:98:6c:1b:ee:24:46:0c:17:b3:52:a5:db:a5:91:91:cf:37:\n         d3:6f:e7:27:08:3a:4e:19:1f:3a:a7:58:5c:17:cf:79:3f:8b:\n         e4:a7:d3:26:23:9d:26:0f:58:69:fc:47:7e:b2:d0:8d:8b:93:\n         bf:29:4f:43:69:74:76:67:4b:cf:07:8c:e6:02:f7:b5:e1:b4:\n         43:b5:4b:2d:14:9f:f9:dc:26:0d:bf:a6:47:74:06:d8:88:d1:\n         3a:29:30:84:ce:d2:39:80:62:1b:a8:c7:57:49:bc:6a:55:51:\n         67:15:4a:be:35:07:e4:d5:75:98:37:79:30:14:db:29:9d:6c:\n         c5:69:cc:47:55:a2:30:f7:cc:5c:7f:c2:c3:98:1c:6b:4e:16:\n         80:eb:7a:78:65:45:a2:00:1a:af:0c:0d:55:64:34:48:b8:92:\n         b9:f1:b4:50:29:f2:4f:23:1f:da:6c:ac:1f:44:e1:dd:23:78:\n         51:5b:c7:16\nSHA1 Fingerprint=3A:44:73:5A:E5:81:90:1F:24:86:61:46:1E:3B:9C:C4:5F:F5:3A:1B\n",
    "b00cf04c30f405580248fd33e552af4b84e36652": "-----BEGIN CERTIFICATE-----\nMIIFQTCCAymgAwIBAgITBmyf0pY1hp8KD+WGePhbJruKNzANBgkqhkiG9w0BAQwF\nADA5MQswCQYDVQQGEwJVUzEPMA0GA1UEChMGQW1hem9uMRkwFwYDVQQDExBBbWF6\nb24gUm9vdCBDQSAyMB4XDTE1MDUyNjAwMDAwMFoXDTQwMDUyNjAwMDAwMFowOTEL\nMAkGA1UEBhMCVVMxDzANBgNVBAoTBkFtYXpvbjEZMBcGA1UEAxMQQW1hem9uIFJv\nb3QgQ0EgMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAK2Wny2cSkxK\ngXlRmeyKy2tgURO8TW0G/LAIjd0ZEGrHJgw12MBvIITplLGbhQPDW9tK6Mj4kHbZ\nW0/jTOgGNk3Mmqw9DJArktQGGWCsN0R5hYGCrVo34A3MnaZMUnbqQ523BNFQ9lXg\n1dKmSYXpN+nKfq5clU1Imj+uIFptiJXZNLhSGkOQsL9sBbm2eLfq0OQ6PBJTYv9K\n8nu+NQWpEjTj82R0Yiw9AElaKP4yRLuH3WUnAnE72kr3H9rN9yFVkE8P7K6C4Z9r\n2UXTu/Bfh+08LDmG2j/e7HJV63mjrdvdfLC6HM783k81ds8P+HgfajZRRidhW+me\nz/CiVX18JYpvL7TFz4QuK/0NURBs+18bvBt+xa47mAExkv8LV/SasrlX6avvDXbR\n8O70zoan4G7ptGmh32n2M8ZpLpcTnqWHsFcQgTfJU7O7f/aS0ZzQGPSSbtqDT6Zj\nmUyl+17vIWR6IF9sZIUVyzfpYgwLKhbcAS4y2j5L9Z469hdAlO+ekQiG+r5jqFoz\n7Mt0Q5X5bGlSNscpb/xVA1wf+5+9R+vnSUeVC06JIglJ4PVhHvG/LopyboBZ/1c6\n+XUyo05f7O0oYtlNc/LMgRdg7c3r3NunysV+Ar3yVAhU/bQtCSwXVEqY0VThUWcI\n0u1ufm8/0i2BWSlmy5A5lREedCf+3euvAgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMB\nAf8wDgYDVR0PAQH/BAQDAgGGMB0GA1UdDgQWBBSwDPBMMPQFWAJI/TPlUq9LhONm\nUjANBgkqhkiG9w0BAQwFAAOCAgEAqqiAjw54o+Ci1M3m9Zh6O+oAA7CXDpO8Wqj2\nLIxyh6mx/H9z/WNxeKWHWc8w4Q0QshNabYL1auaAn6AFC2jkR2vHat+2/XcycuUY\n+gn0oJMsXdKMdYV2ZZAMA3m3MSNjrXiDCYZohMr/+c8mmpJ5581LxedhpxfL86kS\nk5Nrp+gvU5LEYFiwzAJRGFuFjWJZY7attN6a+yb3ACfAXVU3dJnJUH/jWS5E4ywl\n7uxMMne0nxrpS10gxdr9HIcWxkPo1LsmmkVwXqkLN1PiRnsn/eBG8om3zEK2yygm\nbtmlyTrIQRNg91CMFa6ybRoVGld45pIq2WWQgj9sAq+uEjonljYE1x2igGOpm/Hl\nurR8FLBOybEfdF849lHqm/osohHUqS0nGkWxr7JOcQ3AWEbWaQbLU8uz/mtBzUF+\nfUwPfHJ5elnNXkoOrJupmHN5fLT0zLm4BwyydFy4x2+IoZCn9Kr5v2c69BoVYh63\nn749sSmvZ6ES8lgQGVMDMBu4Gon2nL2XA46jCfMdiyHxtN/kHNGfZQIG6lzWE7OE\n76KlXIx3KadowGuuQNKotOrN8I1LOJwZmhsoVLiJkO/KdYE+HvJkJMcYr07/R54H\n9jVlpNMKVv/1F2Rs76giJUmTtt8AF9pYfl3uxRuw0dFfIRDH+fO6AgonB8Xx1sfT\n4PsJYGw=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            06:6c:9f:d2:96:35:86:9f:0a:0f:e5:86:78:f8:5b:26:bb:8a:37\n        Signature Algorithm: sha384WithRSAEncryption\n        Issuer: C=US, O=Amazon, CN=Amazon Root CA 2\n        Validity\n            Not Before: May 26 00:00:00 2015 GMT\n            Not After : May 26 00:00:00 2040 GMT\n        Subject: C=US, O=Amazon, CN=Amazon Root CA 2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:ad:96:9f:2d:9c:4a:4c:4a:81:79:51:99:ec:8a:\n                    cb:6b:60:51:13:bc:4d:6d:06:fc:b0:08:8d:dd:19:\n                    10:6a:c7:26:0c:35:d8:c0:6f:20:84:e9:94:b1:9b:\n                    85:03:c3:5b:db:4a:e8:c8:f8:90:76:d9:5b:4f:e3:\n                    4c:e8:06:36:4d:cc:9a:ac:3d:0c:90:2b:92:d4:06:\n                    19:60:ac:37:44:79:85:81:82:ad:5a:37:e0:0d:cc:\n                    9d:a6:4c:52:76:ea:43:9d:b7:04:d1:50:f6:55:e0:\n                    d5:d2:a6:49:85:e9:37:e9:ca:7e:ae:5c:95:4d:48:\n                    9a:3f:ae:20:5a:6d:88:95:d9:34:b8:52:1a:43:90:\n                    b0:bf:6c:05:b9:b6:78:b7:ea:d0:e4:3a:3c:12:53:\n                    62:ff:4a:f2:7b:be:35:05:a9:12:34:e3:f3:64:74:\n                    62:2c:3d:00:49:5a:28:fe:32:44:bb:87:dd:65:27:\n                    02:71:3b:da:4a:f7:1f:da:cd:f7:21:55:90:4f:0f:\n                    ec:ae:82:e1:9f:6b:d9:45:d3:bb:f0:5f:87:ed:3c:\n                    2c:39:86:da:3f:de:ec:72:55:eb:79:a3:ad:db:dd:\n                    7c:b0:ba:1c:ce:fc:de:4f:35:76:cf:0f:f8:78:1f:\n                    6a:36:51:46:27:61:5b:e9:9e:cf:f0:a2:55:7d:7c:\n                    25:8a:6f:2f:b4:c5:cf:84:2e:2b:fd:0d:51:10:6c:\n                    fb:5f:1b:bc:1b:7e:c5:ae:3b:98:01:31:92:ff:0b:\n                    57:f4:9a:b2:b9:57:e9:ab:ef:0d:76:d1:f0:ee:f4:\n                    ce:86:a7:e0:6e:e9:b4:69:a1:df:69:f6:33:c6:69:\n                    2e:97:13:9e:a5:87:b0:57:10:81:37:c9:53:b3:bb:\n                    7f:f6:92:d1:9c:d0:18:f4:92:6e:da:83:4f:a6:63:\n                    99:4c:a5:fb:5e:ef:21:64:7a:20:5f:6c:64:85:15:\n                    cb:37:e9:62:0c:0b:2a:16:dc:01:2e:32:da:3e:4b:\n                    f5:9e:3a:f6:17:40:94:ef:9e:91:08:86:fa:be:63:\n                    a8:5a:33:ec:cb:74:43:95:f9:6c:69:52:36:c7:29:\n                    6f:fc:55:03:5c:1f:fb:9f:bd:47:eb:e7:49:47:95:\n                    0b:4e:89:22:09:49:e0:f5:61:1e:f1:bf:2e:8a:72:\n                    6e:80:59:ff:57:3a:f9:75:32:a3:4e:5f:ec:ed:28:\n                    62:d9:4d:73:f2:cc:81:17:60:ed:cd:eb:dc:db:a7:\n                    ca:c5:7e:02:bd:f2:54:08:54:fd:b4:2d:09:2c:17:\n                    54:4a:98:d1:54:e1:51:67:08:d2:ed:6e:7e:6f:3f:\n                    d2:2d:81:59:29:66:cb:90:39:95:11:1e:74:27:fe:\n                    dd:eb:af\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                B0:0C:F0:4C:30:F4:05:58:02:48:FD:33:E5:52:AF:4B:84:E3:66:52\n    Signature Algorithm: sha384WithRSAEncryption\n         aa:a8:80:8f:0e:78:a3:e0:a2:d4:cd:e6:f5:98:7a:3b:ea:00:\n         03:b0:97:0e:93:bc:5a:a8:f6:2c:8c:72:87:a9:b1:fc:7f:73:\n         fd:63:71:78:a5:87:59:cf:30:e1:0d:10:b2:13:5a:6d:82:f5:\n         6a:e6:80:9f:a0:05:0b:68:e4:47:6b:c7:6a:df:b6:fd:77:32:\n         72:e5:18:fa:09:f4:a0:93:2c:5d:d2:8c:75:85:76:65:90:0c:\n         03:79:b7:31:23:63:ad:78:83:09:86:68:84:ca:ff:f9:cf:26:\n         9a:92:79:e7:cd:4b:c5:e7:61:a7:17:cb:f3:a9:12:93:93:6b:\n         a7:e8:2f:53:92:c4:60:58:b0:cc:02:51:18:5b:85:8d:62:59:\n         63:b6:ad:b4:de:9a:fb:26:f7:00:27:c0:5d:55:37:74:99:c9:\n         50:7f:e3:59:2e:44:e3:2c:25:ee:ec:4c:32:77:b4:9f:1a:e9:\n         4b:5d:20:c5:da:fd:1c:87:16:c6:43:e8:d4:bb:26:9a:45:70:\n         5e:a9:0b:37:53:e2:46:7b:27:fd:e0:46:f2:89:b7:cc:42:b6:\n         cb:28:26:6e:d9:a5:c9:3a:c8:41:13:60:f7:50:8c:15:ae:b2:\n         6d:1a:15:1a:57:78:e6:92:2a:d9:65:90:82:3f:6c:02:af:ae:\n         12:3a:27:96:36:04:d7:1d:a2:80:63:a9:9b:f1:e5:ba:b4:7c:\n         14:b0:4e:c9:b1:1f:74:5f:38:f6:51:ea:9b:fa:2c:a2:11:d4:\n         a9:2d:27:1a:45:b1:af:b2:4e:71:0d:c0:58:46:d6:69:06:cb:\n         53:cb:b3:fe:6b:41:cd:41:7e:7d:4c:0f:7c:72:79:7a:59:cd:\n         5e:4a:0e:ac:9b:a9:98:73:79:7c:b4:f4:cc:b9:b8:07:0c:b2:\n         74:5c:b8:c7:6f:88:a1:90:a7:f4:aa:f9:bf:67:3a:f4:1a:15:\n         62:1e:b7:9f:be:3d:b1:29:af:67:a1:12:f2:58:10:19:53:03:\n         30:1b:b8:1a:89:f6:9c:bd:97:03:8e:a3:09:f3:1d:8b:21:f1:\n         b4:df:e4:1c:d1:9f:65:02:06:ea:5c:d6:13:b3:84:ef:a2:a5:\n         5c:8c:77:29:a7:68:c0:6b:ae:40:d2:a8:b4:ea:cd:f0:8d:4b:\n         38:9c:19:9a:1b:28:54:b8:89:90:ef:ca:75:81:3e:1e:f2:64:\n         24:c7:18:af:4e:ff:47:9e:07:f6:35:65:a4:d3:0a:56:ff:f5:\n         17:64:6c:ef:a8:22:25:49:93:b6:df:00:17:da:58:7e:5d:ee:\n         c5:1b:b0:d1:d1:5f:21:10:c7:f9:f3:ba:02:0a:27:07:c5:f1:\n         d6:c7:d3:e0:fb:09:60:6c\nSHA1 Fingerprint=5A:8C:EF:45:D7:A6:98:59:76:7A:8C:8B:44:96:B5:78:CF:47:4B:1A\n",
    "b13ec36903f8bf4701d498261a0802ef63642bc3": "-----BEGIN CERTIFICATE-----\nMIIDxTCCAq2gAwIBAgIQAqxcJmoLQJuPC3nyrkYldzANBgkqhkiG9w0BAQUFADBs\nMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3\nd3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2VydCBIaWdoIEFzc3VyYW5j\nZSBFViBSb290IENBMB4XDTA2MTExMDAwMDAwMFoXDTMxMTExMDAwMDAwMFowbDEL\nMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3\nLmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMiRGlnaUNlcnQgSGlnaCBBc3N1cmFuY2Ug\nRVYgUm9vdCBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMbM5XPm\n+9S75S0tMqbf5YE/yc0lSbZxKsPVlDRnogocsF9ppkCxxLeyj9CYpKlBWTrT3JTW\nPNt0OKRKzE0lgvdKpVMSOO7zSW1xkX5jtqumX8OkhPhPYlG++MXs2ziS4wblCJEM\nxChBVfvLWokVfnHoNb9Ncgk9vjo4UFt3MRuNs8ckRZqnrG0AFFoEt7oT61EKmEFB\nIk5lYYeBQVCmeVyJ3hlKV9Uu5l0cUyx+mM0aBhakaHPQNAQTXKFx01p8VdteZOE3\nhzBWBOURtCmAEvF5OYiiAhF8J2a3iLd48soKqDirCmTCv2ZdlYTBoSUeh10aUAsg\nEsxBu24LUTi4S8sCAwEAAaNjMGEwDgYDVR0PAQH/BAQDAgGGMA8GA1UdEwEB/wQF\nMAMBAf8wHQYDVR0OBBYEFLE+w2kD+L9HAdSYJhoIAu9jZCvDMB8GA1UdIwQYMBaA\nFLE+w2kD+L9HAdSYJhoIAu9jZCvDMA0GCSqGSIb3DQEBBQUAA4IBAQAcGgaX3Nec\nnzyIZgYIVyHbIUf4KmeqvxgydkAQV8GK83rZEWWONfqe/EW1ntlMMUu4kehDLI6z\neM7b41N5cdblIZQB2lWHmiRk9opmzN6cN82oNLFpmyPInngiK3BD41VHMWEZ71jF\nhS9OMPagMRYjyOfiZRYzy78aG6A9+MpeizGLYAiJLQwGXFK3xPkKmNEVX58Svnw2\nYzi9RKR/5CYrCsSXaQ3pjOLAEFe4yHYSkVXySGnYvCoCWw9E1CAx2/S6cCZdkGCe\nvEsXCS+0yx5DaMkHJ8HSXPfqIbloEpw8nL+e/IBcm2PN7EeqJSdnoDfzAIJ9VNep\n+OkuE6N36B9K\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            02:ac:5c:26:6a:0b:40:9b:8f:0b:79:f2:ae:46:25:77\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert High Assurance EV Root CA\n        Validity\n            Not Before: Nov 10 00:00:00 2006 GMT\n            Not After : Nov 10 00:00:00 2031 GMT\n        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert High Assurance EV Root CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:c6:cc:e5:73:e6:fb:d4:bb:e5:2d:2d:32:a6:df:\n                    e5:81:3f:c9:cd:25:49:b6:71:2a:c3:d5:94:34:67:\n                    a2:0a:1c:b0:5f:69:a6:40:b1:c4:b7:b2:8f:d0:98:\n                    a4:a9:41:59:3a:d3:dc:94:d6:3c:db:74:38:a4:4a:\n                    cc:4d:25:82:f7:4a:a5:53:12:38:ee:f3:49:6d:71:\n                    91:7e:63:b6:ab:a6:5f:c3:a4:84:f8:4f:62:51:be:\n                    f8:c5:ec:db:38:92:e3:06:e5:08:91:0c:c4:28:41:\n                    55:fb:cb:5a:89:15:7e:71:e8:35:bf:4d:72:09:3d:\n                    be:3a:38:50:5b:77:31:1b:8d:b3:c7:24:45:9a:a7:\n                    ac:6d:00:14:5a:04:b7:ba:13:eb:51:0a:98:41:41:\n                    22:4e:65:61:87:81:41:50:a6:79:5c:89:de:19:4a:\n                    57:d5:2e:e6:5d:1c:53:2c:7e:98:cd:1a:06:16:a4:\n                    68:73:d0:34:04:13:5c:a1:71:d3:5a:7c:55:db:5e:\n                    64:e1:37:87:30:56:04:e5:11:b4:29:80:12:f1:79:\n                    39:88:a2:02:11:7c:27:66:b7:88:b7:78:f2:ca:0a:\n                    a8:38:ab:0a:64:c2:bf:66:5d:95:84:c1:a1:25:1e:\n                    87:5d:1a:50:0b:20:12:cc:41:bb:6e:0b:51:38:b8:\n                    4b:cb\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                B1:3E:C3:69:03:F8:BF:47:01:D4:98:26:1A:08:02:EF:63:64:2B:C3\n            X509v3 Authority Key Identifier: \n                keyid:B1:3E:C3:69:03:F8:BF:47:01:D4:98:26:1A:08:02:EF:63:64:2B:C3\n\n    Signature Algorithm: sha1WithRSAEncryption\n         1c:1a:06:97:dc:d7:9c:9f:3c:88:66:06:08:57:21:db:21:47:\n         f8:2a:67:aa:bf:18:32:76:40:10:57:c1:8a:f3:7a:d9:11:65:\n         8e:35:fa:9e:fc:45:b5:9e:d9:4c:31:4b:b8:91:e8:43:2c:8e:\n         b3:78:ce:db:e3:53:79:71:d6:e5:21:94:01:da:55:87:9a:24:\n         64:f6:8a:66:cc:de:9c:37:cd:a8:34:b1:69:9b:23:c8:9e:78:\n         22:2b:70:43:e3:55:47:31:61:19:ef:58:c5:85:2f:4e:30:f6:\n         a0:31:16:23:c8:e7:e2:65:16:33:cb:bf:1a:1b:a0:3d:f8:ca:\n         5e:8b:31:8b:60:08:89:2d:0c:06:5c:52:b7:c4:f9:0a:98:d1:\n         15:5f:9f:12:be:7c:36:63:38:bd:44:a4:7f:e4:26:2b:0a:c4:\n         97:69:0d:e9:8c:e2:c0:10:57:b8:c8:76:12:91:55:f2:48:69:\n         d8:bc:2a:02:5b:0f:44:d4:20:31:db:f4:ba:70:26:5d:90:60:\n         9e:bc:4b:17:09:2f:b4:cb:1e:43:68:c9:07:27:c1:d2:5c:f7:\n         ea:21:b9:68:12:9c:3c:9c:bf:9e:fc:80:5c:9b:63:cd:ec:47:\n         aa:25:27:67:a0:37:f3:00:82:7d:54:d7:a9:f8:e9:2e:13:a3:\n         77:e8:1f:4a\nSHA1 Fingerprint=5F:B7:EE:06:33:E2:59:DB:AD:0C:4C:9A:E6:D3:8F:1A:61:C7:DC:25\n",
    "b3db48a4f9a1c5d8ae3641cc1163696229bc4bc6": "-----BEGIN CERTIFICATE-----\nMIICPzCCAcWgAwIBAgIQBVVWvPJepDU1w6QP1atFcjAKBggqhkjOPQQDAzBhMQsw\nCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu\nZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBHMzAe\nFw0xMzA4MDExMjAwMDBaFw0zODAxMTUxMjAwMDBaMGExCzAJBgNVBAYTAlVTMRUw\nEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x\nIDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IEczMHYwEAYHKoZIzj0CAQYF\nK4EEACIDYgAE3afZu4q4C/sLfyHS8L6+c/MzXRq8NOrexpu80JX28MzQC7phW1FG\nfp4tn+6OYwwX7Adw9c+ELkCDnOg/QW07rdOkFFk2eJ0DQ+4QE2xy3q6Ip6FrtUPO\nZ9wj/wMco+I+o0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjAd\nBgNVHQ4EFgQUs9tIpPmhxdiuNkHMEWNpYim8S8YwCgYIKoZIzj0EAwMDaAAwZQIx\nAK288mw/EkrRLTnDCgmXc/SINoyIJ7vmiI1Qhadj+Z4y3maTD/HMsQmP3Wyr+mt/\noAIwOWZbwmSNuJ5Q3KjVSaLtx9zRSX8XAbjIho9OjIgrqJqpisXRAL34VOKa5Vt8\nsycX\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            05:55:56:bc:f2:5e:a4:35:35:c3:a4:0f:d5:ab:45:72\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root G3\n        Validity\n            Not Before: Aug  1 12:00:00 2013 GMT\n            Not After : Jan 15 12:00:00 2038 GMT\n        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root G3\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:dd:a7:d9:bb:8a:b8:0b:fb:0b:7f:21:d2:f0:be:\n                    be:73:f3:33:5d:1a:bc:34:ea:de:c6:9b:bc:d0:95:\n                    f6:f0:cc:d0:0b:ba:61:5b:51:46:7e:9e:2d:9f:ee:\n                    8e:63:0c:17:ec:07:70:f5:cf:84:2e:40:83:9c:e8:\n                    3f:41:6d:3b:ad:d3:a4:14:59:36:78:9d:03:43:ee:\n                    10:13:6c:72:de:ae:88:a7:a1:6b:b5:43:ce:67:dc:\n                    23:ff:03:1c:a3:e2:3e\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                B3:DB:48:A4:F9:A1:C5:D8:AE:36:41:CC:11:63:69:62:29:BC:4B:C6\n    Signature Algorithm: ecdsa-with-SHA384\n         30:65:02:31:00:ad:bc:f2:6c:3f:12:4a:d1:2d:39:c3:0a:09:\n         97:73:f4:88:36:8c:88:27:bb:e6:88:8d:50:85:a7:63:f9:9e:\n         32:de:66:93:0f:f1:cc:b1:09:8f:dd:6c:ab:fa:6b:7f:a0:02:\n         30:39:66:5b:c2:64:8d:b8:9e:50:dc:a8:d5:49:a2:ed:c7:dc:\n         d1:49:7f:17:01:b8:c8:86:8f:4e:8c:88:2b:a8:9a:a9:8a:c5:\n         d1:00:bd:f8:54:e2:9a:e5:5b:7c:b3:27:17\nSHA1 Fingerprint=7E:04:DE:89:6A:3E:66:6D:00:E6:87:D3:3F:FA:D9:3B:E8:3D:34:9E\n",
    "b4220b829924010e9cbbe40efdbffb972093992a": "-----BEGIN CERTIFICATE-----\nMIICwzCCAkqgAwIBAgIBADAKBggqhkjOPQQDAjCBqjELMAkGA1UEBhMCR1IxDzAN\nBgNVBAcTBkF0aGVuczFEMEIGA1UEChM7SGVsbGVuaWMgQWNhZGVtaWMgYW5kIFJl\nc2VhcmNoIEluc3RpdHV0aW9ucyBDZXJ0LiBBdXRob3JpdHkxRDBCBgNVBAMTO0hl\nbGxlbmljIEFjYWRlbWljIGFuZCBSZXNlYXJjaCBJbnN0aXR1dGlvbnMgRUNDIFJv\nb3RDQSAyMDE1MB4XDTE1MDcwNzEwMzcxMloXDTQwMDYzMDEwMzcxMlowgaoxCzAJ\nBgNVBAYTAkdSMQ8wDQYDVQQHEwZBdGhlbnMxRDBCBgNVBAoTO0hlbGxlbmljIEFj\nYWRlbWljIGFuZCBSZXNlYXJjaCBJbnN0aXR1dGlvbnMgQ2VydC4gQXV0aG9yaXR5\nMUQwQgYDVQQDEztIZWxsZW5pYyBBY2FkZW1pYyBhbmQgUmVzZWFyY2ggSW5zdGl0\ndXRpb25zIEVDQyBSb290Q0EgMjAxNTB2MBAGByqGSM49AgEGBSuBBAAiA2IABJKg\nQehLgoRc4vgxEZmGZE4JJS+dQS8KrjVPdJWyUWRrjWvmP3CV8AVER6ZyOFB2lQJa\njq4onvktTpnvLEhvTCUp6NFxW98dwXU3tNf6e3pCnGoKVlp8aQuqgAkkbH7BRqNC\nMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFLQi\nC4KZJAEOnLvkDv2/+5cgk5kqMAoGCCqGSM49BAMCA2cAMGQCMGfOFmI4oqxiRaep\nlSTAGiecMjvAwNW6qef4BENThe5SId6d9SWDPp5YSy/XZxMOIQIwBeF1Ad5o7Sof\nTUwJCA3sS61kFyjndc5FZXIhF8siQQ6ME5g4mlRtm8rifOoCWCKR\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 0 (0x0)\n        Signature Algorithm: ecdsa-with-SHA256\n        Issuer: C=GR, L=Athens, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions ECC RootCA 2015\n        Validity\n            Not Before: Jul  7 10:37:12 2015 GMT\n            Not After : Jun 30 10:37:12 2040 GMT\n        Subject: C=GR, L=Athens, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions ECC RootCA 2015\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:92:a0:41:e8:4b:82:84:5c:e2:f8:31:11:99:86:\n                    64:4e:09:25:2f:9d:41:2f:0a:ae:35:4f:74:95:b2:\n                    51:64:6b:8d:6b:e6:3f:70:95:f0:05:44:47:a6:72:\n                    38:50:76:95:02:5a:8e:ae:28:9e:f9:2d:4e:99:ef:\n                    2c:48:6f:4c:25:29:e8:d1:71:5b:df:1d:c1:75:37:\n                    b4:d7:fa:7b:7a:42:9c:6a:0a:56:5a:7c:69:0b:aa:\n                    80:09:24:6c:7e:c1:46\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                B4:22:0B:82:99:24:01:0E:9C:BB:E4:0E:FD:BF:FB:97:20:93:99:2A\n    Signature Algorithm: ecdsa-with-SHA256\n         30:64:02:30:67:ce:16:62:38:a2:ac:62:45:a7:a9:95:24:c0:\n         1a:27:9c:32:3b:c0:c0:d5:ba:a9:e7:f8:04:43:53:85:ee:52:\n         21:de:9d:f5:25:83:3e:9e:58:4b:2f:d7:67:13:0e:21:02:30:\n         05:e1:75:01:de:68:ed:2a:1f:4d:4c:09:08:0d:ec:4b:ad:64:\n         17:28:e7:75:ce:45:65:72:21:17:cb:22:41:0e:8c:13:98:38:\n         9a:54:6d:9b:ca:e2:7c:ea:02:58:22:91\nSHA1 Fingerprint=9F:F1:71:8D:92:D5:9A:F3:7D:74:97:B4:BC:6F:84:68:0B:BA:B6:66\n",
    "b503f7763b61826a12aa1853eb032194bffececa": "-----BEGIN CERTIFICATE-----\nMIIDwzCCAqugAwIBAgIBATANBgkqhkiG9w0BAQsFADCBgjELMAkGA1UEBhMCREUx\nKzApBgNVBAoMIlQtU3lzdGVtcyBFbnRlcnByaXNlIFNlcnZpY2VzIEdtYkgxHzAd\nBgNVBAsMFlQtU3lzdGVtcyBUcnVzdCBDZW50ZXIxJTAjBgNVBAMMHFQtVGVsZVNl\nYyBHbG9iYWxSb290IENsYXNzIDMwHhcNMDgxMDAxMTAyOTU2WhcNMzMxMDAxMjM1\nOTU5WjCBgjELMAkGA1UEBhMCREUxKzApBgNVBAoMIlQtU3lzdGVtcyBFbnRlcnBy\naXNlIFNlcnZpY2VzIEdtYkgxHzAdBgNVBAsMFlQtU3lzdGVtcyBUcnVzdCBDZW50\nZXIxJTAjBgNVBAMMHFQtVGVsZVNlYyBHbG9iYWxSb290IENsYXNzIDMwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC9dZPwYiJvJK7genasfb3ZJNW4t/zN\n8ELg63iIVl6bmlQdTQyK9tPPcPRStdiTBONGhnFBSivwKixVA9ZIw+A5OO3yXDw/\nRLyTPWGrTs0NvvAgJ1gORH8EGoel15YUNpDQSXuhdfsaa3Ox+M6pCSzyU9XDFES4\nhqX2iys52qMzVNn6chr3IhUciJFrf2blw2qAsCTz34ZFiP0Zf3WHHx+xGwpzJFu5\nZeAsVMhg02YXP+HMVDNzkQI6pn97djmiH5a2OK61yJN0HZ65tOVgnS9W0eDrXltM\nEnAMbEQgqxHY9Bn20pxSN+f6tsIxO0rUFJmtxxr1XV/6B7h8DR/Wgx6zAgMBAAGj\nQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBS1\nA/d2O2GCahKqGFPrAyGUv/7OyjANBgkqhkiG9w0BAQsFAAOCAQEAVj3vlNW92nOy\nWL6ukK2YJ5f+AbGwUgC4TeQbIXQbfsDuXmkqJa9c1h3a0nnJ85cp4IaH3gRZD/FZ\n1GSFS5mvJQQeyUapl96Cshtwn5z2r3Ex3XsFpSzTucpH9sry9uetuUg/vBa3wW30\n6gmv7PO15wWeph6KU1HWk4HMdJP2udqmJQV0eVp+QD6CSyYRMG7hP0HHRwA11fXT\n91Q+gT3aSWqas+8QPebrb9HIIkfLzM8BMZLZGOMivgkeGj5asuRrDFR6fUNOuIml\ne9eiPZaGzPImNC1qkp2aGtAw4l1OBLBfiyB+d8E9lYLRRpo7PHi4b6HQDWSieB4p\nTpPDpFQUWw==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 1 (0x1)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=DE, O=T-Systems Enterprise Services GmbH, OU=T-Systems Trust Center, CN=T-TeleSec GlobalRoot Class 3\n        Validity\n            Not Before: Oct  1 10:29:56 2008 GMT\n            Not After : Oct  1 23:59:59 2033 GMT\n        Subject: C=DE, O=T-Systems Enterprise Services GmbH, OU=T-Systems Trust Center, CN=T-TeleSec GlobalRoot Class 3\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:bd:75:93:f0:62:22:6f:24:ae:e0:7a:76:ac:7d:\n                    bd:d9:24:d5:b8:b7:fc:cd:f0:42:e0:eb:78:88:56:\n                    5e:9b:9a:54:1d:4d:0c:8a:f6:d3:cf:70:f4:52:b5:\n                    d8:93:04:e3:46:86:71:41:4a:2b:f0:2a:2c:55:03:\n                    d6:48:c3:e0:39:38:ed:f2:5c:3c:3f:44:bc:93:3d:\n                    61:ab:4e:cd:0d:be:f0:20:27:58:0e:44:7f:04:1a:\n                    87:a5:d7:96:14:36:90:d0:49:7b:a1:75:fb:1a:6b:\n                    73:b1:f8:ce:a9:09:2c:f2:53:d5:c3:14:44:b8:86:\n                    a5:f6:8b:2b:39:da:a3:33:54:d9:fa:72:1a:f7:22:\n                    15:1c:88:91:6b:7f:66:e5:c3:6a:80:b0:24:f3:df:\n                    86:45:88:fd:19:7f:75:87:1f:1f:b1:1b:0a:73:24:\n                    5b:b9:65:e0:2c:54:c8:60:d3:66:17:3f:e1:cc:54:\n                    33:73:91:02:3a:a6:7f:7b:76:39:a2:1f:96:b6:38:\n                    ae:b5:c8:93:74:1d:9e:b9:b4:e5:60:9d:2f:56:d1:\n                    e0:eb:5e:5b:4c:12:70:0c:6c:44:20:ab:11:d8:f4:\n                    19:f6:d2:9c:52:37:e7:fa:b6:c2:31:3b:4a:d4:14:\n                    99:ad:c7:1a:f5:5d:5f:fa:07:b8:7c:0d:1f:d6:83:\n                    1e:b3\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                B5:03:F7:76:3B:61:82:6A:12:AA:18:53:EB:03:21:94:BF:FE:CE:CA\n    Signature Algorithm: sha256WithRSAEncryption\n         56:3d:ef:94:d5:bd:da:73:b2:58:be:ae:90:ad:98:27:97:fe:\n         01:b1:b0:52:00:b8:4d:e4:1b:21:74:1b:7e:c0:ee:5e:69:2a:\n         25:af:5c:d6:1d:da:d2:79:c9:f3:97:29:e0:86:87:de:04:59:\n         0f:f1:59:d4:64:85:4b:99:af:25:04:1e:c9:46:a9:97:de:82:\n         b2:1b:70:9f:9c:f6:af:71:31:dd:7b:05:a5:2c:d3:b9:ca:47:\n         f6:ca:f2:f6:e7:ad:b9:48:3f:bc:16:b7:c1:6d:f4:ea:09:af:\n         ec:f3:b5:e7:05:9e:a6:1e:8a:53:51:d6:93:81:cc:74:93:f6:\n         b9:da:a6:25:05:74:79:5a:7e:40:3e:82:4b:26:11:30:6e:e1:\n         3f:41:c7:47:00:35:d5:f5:d3:f7:54:3e:81:3d:da:49:6a:9a:\n         b3:ef:10:3d:e6:eb:6f:d1:c8:22:47:cb:cc:cf:01:31:92:d9:\n         18:e3:22:be:09:1e:1a:3e:5a:b2:e4:6b:0c:54:7a:7d:43:4e:\n         b8:89:a5:7b:d7:a2:3d:96:86:cc:f2:26:34:2d:6a:92:9d:9a:\n         1a:d0:30:e2:5d:4e:04:b0:5f:8b:20:7e:77:c1:3d:95:82:d1:\n         46:9a:3b:3c:78:b8:6f:a1:d0:0d:64:a2:78:1e:29:4e:93:c3:\n         a4:54:14:5b\nSHA1 Fingerprint=55:A6:72:3E:CB:F2:EC:CD:C3:23:74:70:19:9D:2A:BE:11:E3:81:D1\n",
    "b599f8afb094f5e320d60aadce4e56a42e6e42ed": "-----BEGIN CERTIFICATE-----\nMIIFaTCCA1GgAwIBAgIJAJK4iNuwisFjMA0GCSqGSIb3DQEBCwUAMFIxCzAJBgNV\nBAYTAlNLMRMwEQYDVQQHEwpCcmF0aXNsYXZhMRMwEQYDVQQKEwpEaXNpZyBhLnMu\nMRkwFwYDVQQDExBDQSBEaXNpZyBSb290IFIyMB4XDTEyMDcxOTA5MTUzMFoXDTQy\nMDcxOTA5MTUzMFowUjELMAkGA1UEBhMCU0sxEzARBgNVBAcTCkJyYXRpc2xhdmEx\nEzARBgNVBAoTCkRpc2lnIGEucy4xGTAXBgNVBAMTEENBIERpc2lnIFJvb3QgUjIw\nggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCio8QACdaFXS1tFPbCw3Oe\nNcJxVX6B+6tGUODBfEl45qt5WDza/3wcn9iXAng+a0EE6UG9vgMsRfYvZNSrXaNH\nPWSb6WiaxswbP7q+sos0Ai6YVRn8jG+qX9pMzk0DIaPY0jSTVpbLTAwAFjxfGs3I\nx2ymrdMxp7zo5eFm1tL7A7RBZckQrg4FY8aAamkw/dLukO8NJ9+flXP04SXabBbe\nQTg06ov80egEFGEtQX6sx3dOy1FU+16SGBsEWmjGycT6txOgmLcRK7fWV8x8nhfR\nyyX+hk4kLlYMeE2eARKmK6cBZW58Yh2EhN/qwGu1pSqVg8NTEQxzHQuyRpDRQjrO\nQG6Vrf/GlK1ul4SOfW+eioANSW1z4nuSHsPzwfPrLgVv2RvPN3YEyLRa5Beny912\nH9AZdugsBbPWnDTYltxhh5EF5EQIM8HauQhl1K6yNg3ruji6DOWbnuuNZt2Zz9aJ\nQfYEkoopKW1rOhzndX0CcQ7zwOe9yxndnWCywmZgtrEE7snmhrmaZkCo5xHtgUUD\ni/ZnWejBBhG93c+AAk9lQHhcR1DIm+YfgXvkRKhbhZri3lrVx/k6RGZL5DJUfORs\nnLMOPReisjQS1n6yqEm70XooQL6iFh/f5DcfEXP7kAplQ6INfPgGAVUzfbANuPT1\nrqVCV3w2EYx7XsQDnYx5nQIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1Ud\nDwEB/wQEAwIBBjAdBgNVHQ4EFgQUtZn4r7CU9eMg1gqtzk5WpC5uQu0wDQYJKoZI\nhvcNAQELBQADggIBACYGXnDnZTPIgm7ZnBc6G3pmsgH2eDtpXi/q/075KMOYKmFM\ntCQSin1tERT3nLXK5ryeJ45MGcipvXrA1zYObYVybqjGom32+nNjf7xueQgcnYqf\nGopTpti72TVVsRHFqQOzVju5hJMiXn7B9hJSi+osZ7z+Nkz1uM/Rs0mSO9MpDpkb\nlvdhuDvEK7Z4bLQjb/D907JedR+Zlais9trhxTF7+9FGs9K8Z7RiVLoJ92Owk6Ka\n+elSLotgEqv89WBW7xBci8QaQtyDW2QOy7W81k/BfDxujRNt+3vrMNDcTa/F1bal\nTFtxyegxvug4BkihGuLq0t4SOVga/4AOgnXmt8kHbA7v/zjxmHHEt38OFdAlab0i\nnSvtBfZGR6ztwPDUO+Ls7pZbkBNOHlY667DvlruWIxG68kOGdGSVyCh13x01utI3\ngzhTODY7z2zp+WsO0PsE6E9312UBeIYMej4hYvF/Y3EMyZ9E26gnonW+boE+18Dr\nG5gPcFw0sorMwIUY6256s/daoQe/qUKS82Ail+QUoQebTnbAjn39pCXHR+3/H3Os\nzMOl6W8KjptlwlCFtaOgUxLMVYdh84GuEEZhvUQhuMI9dM9+JDX6HAcOmz0iyu8x\nL4ysEr3vQCj8KWefshNPZiTEUxnpHikV7+ZtsH8tZ/3zbBt1RqPlShfppNcL\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            92:b8:88:db:b0:8a:c1:63\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=SK, L=Bratislava, O=Disig a.s., CN=CA Disig Root R2\n        Validity\n            Not Before: Jul 19 09:15:30 2012 GMT\n            Not After : Jul 19 09:15:30 2042 GMT\n        Subject: C=SK, L=Bratislava, O=Disig a.s., CN=CA Disig Root R2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:a2:a3:c4:00:09:d6:85:5d:2d:6d:14:f6:c2:c3:\n                    73:9e:35:c2:71:55:7e:81:fb:ab:46:50:e0:c1:7c:\n                    49:78:e6:ab:79:58:3c:da:ff:7c:1c:9f:d8:97:02:\n                    78:3e:6b:41:04:e9:41:bd:be:03:2c:45:f6:2f:64:\n                    d4:ab:5d:a3:47:3d:64:9b:e9:68:9a:c6:cc:1b:3f:\n                    ba:be:b2:8b:34:02:2e:98:55:19:fc:8c:6f:aa:5f:\n                    da:4c:ce:4d:03:21:a3:d8:d2:34:93:56:96:cb:4c:\n                    0c:00:16:3c:5f:1a:cd:c8:c7:6c:a6:ad:d3:31:a7:\n                    bc:e8:e5:e1:66:d6:d2:fb:03:b4:41:65:c9:10:ae:\n                    0e:05:63:c6:80:6a:69:30:fd:d2:ee:90:ef:0d:27:\n                    df:9f:95:73:f4:e1:25:da:6c:16:de:41:38:34:ea:\n                    8b:fc:d1:e8:04:14:61:2d:41:7e:ac:c7:77:4e:cb:\n                    51:54:fb:5e:92:18:1b:04:5a:68:c6:c9:c4:fa:b7:\n                    13:a0:98:b7:11:2b:b7:d6:57:cc:7c:9e:17:d1:cb:\n                    25:fe:86:4e:24:2e:56:0c:78:4d:9e:01:12:a6:2b:\n                    a7:01:65:6e:7c:62:1d:84:84:df:ea:c0:6b:b5:a5:\n                    2a:95:83:c3:53:11:0c:73:1d:0b:b2:46:90:d1:42:\n                    3a:ce:40:6e:95:ad:ff:c6:94:ad:6e:97:84:8e:7d:\n                    6f:9e:8a:80:0d:49:6d:73:e2:7b:92:1e:c3:f3:c1:\n                    f3:eb:2e:05:6f:d9:1b:cf:37:76:04:c8:b4:5a:e4:\n                    17:a7:cb:dd:76:1f:d0:19:76:e8:2c:05:b3:d6:9c:\n                    34:d8:96:dc:61:87:91:05:e4:44:08:33:c1:da:b9:\n                    08:65:d4:ae:b2:36:0d:eb:ba:38:ba:0c:e5:9b:9e:\n                    eb:8d:66:dd:99:cf:d6:89:41:f6:04:92:8a:29:29:\n                    6d:6b:3a:1c:e7:75:7d:02:71:0e:f3:c0:e7:bd:cb:\n                    19:dd:9d:60:b2:c2:66:60:b6:b1:04:ee:c9:e6:86:\n                    b9:9a:66:40:a8:e7:11:ed:81:45:03:8b:f6:67:59:\n                    e8:c1:06:11:bd:dd:cf:80:02:4f:65:40:78:5c:47:\n                    50:c8:9b:e6:1f:81:7b:e4:44:a8:5b:85:9a:e2:de:\n                    5a:d5:c7:f9:3a:44:66:4b:e4:32:54:7c:e4:6c:9c:\n                    b3:0e:3d:17:a2:b2:34:12:d6:7e:b2:a8:49:bb:d1:\n                    7a:28:40:be:a2:16:1f:df:e4:37:1f:11:73:fb:90:\n                    0a:65:43:a2:0d:7c:f8:06:01:55:33:7d:b0:0d:b8:\n                    f4:f5:ae:a5:42:57:7c:36:11:8c:7b:5e:c4:03:9d:\n                    8c:79:9d\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                B5:99:F8:AF:B0:94:F5:E3:20:D6:0A:AD:CE:4E:56:A4:2E:6E:42:ED\n    Signature Algorithm: sha256WithRSAEncryption\n         26:06:5e:70:e7:65:33:c8:82:6e:d9:9c:17:3a:1b:7a:66:b2:\n         01:f6:78:3b:69:5e:2f:ea:ff:4e:f9:28:c3:98:2a:61:4c:b4:\n         24:12:8a:7d:6d:11:14:f7:9c:b5:ca:e6:bc:9e:27:8e:4c:19:\n         c8:a9:bd:7a:c0:d7:36:0e:6d:85:72:6e:a8:c6:a2:6d:f6:fa:\n         73:63:7f:bc:6e:79:08:1c:9d:8a:9f:1a:8a:53:a6:d8:bb:d9:\n         35:55:b1:11:c5:a9:03:b3:56:3b:b9:84:93:22:5e:7e:c1:f6:\n         12:52:8b:ea:2c:67:bc:fe:36:4c:f5:b8:cf:d1:b3:49:92:3b:\n         d3:29:0e:99:1b:96:f7:61:b8:3b:c4:2b:b6:78:6c:b4:23:6f:\n         f0:fd:d3:b2:5e:75:1f:99:95:a8:ac:f6:da:e1:c5:31:7b:fb:\n         d1:46:b3:d2:bc:67:b4:62:54:ba:09:f7:63:b0:93:a2:9a:f9:\n         e9:52:2e:8b:60:12:ab:fc:f5:60:56:ef:10:5c:8b:c4:1a:42:\n         dc:83:5b:64:0e:cb:b5:bc:d6:4f:c1:7c:3c:6e:8d:13:6d:fb:\n         7b:eb:30:d0:dc:4d:af:c5:d5:b6:a5:4c:5b:71:c9:e8:31:be:\n         e8:38:06:48:a1:1a:e2:ea:d2:de:12:39:58:1a:ff:80:0e:82:\n         75:e6:b7:c9:07:6c:0e:ef:ff:38:f1:98:71:c4:b7:7f:0e:15:\n         d0:25:69:bd:22:9d:2b:ed:05:f6:46:47:ac:ed:c0:f0:d4:3b:\n         e2:ec:ee:96:5b:90:13:4e:1e:56:3a:eb:b0:ef:96:bb:96:23:\n         11:ba:f2:43:86:74:64:95:c8:28:75:df:1d:35:ba:d2:37:83:\n         38:53:38:36:3b:cf:6c:e9:f9:6b:0e:d0:fb:04:e8:4f:77:d7:\n         65:01:78:86:0c:7a:3e:21:62:f1:7f:63:71:0c:c9:9f:44:db:\n         a8:27:a2:75:be:6e:81:3e:d7:c0:eb:1b:98:0f:70:5c:34:b2:\n         8a:cc:c0:85:18:eb:6e:7a:b3:f7:5a:a1:07:bf:a9:42:92:f3:\n         60:22:97:e4:14:a1:07:9b:4e:76:c0:8e:7d:fd:a4:25:c7:47:\n         ed:ff:1f:73:ac:cc:c3:a5:e9:6f:0a:8e:9b:65:c2:50:85:b5:\n         a3:a0:53:12:cc:55:87:61:f3:81:ae:10:46:61:bd:44:21:b8:\n         c2:3d:74:cf:7e:24:35:fa:1c:07:0e:9b:3d:22:ca:ef:31:2f:\n         8c:ac:12:bd:ef:40:28:fc:29:67:9f:b2:13:4f:66:24:c4:53:\n         19:e9:1e:29:15:ef:e6:6d:b0:7f:2d:67:fd:f3:6c:1b:75:46:\n         a3:e5:4a:17:e9:a4:d7:0b\nSHA1 Fingerprint=B5:61:EB:EA:A4:DE:E4:25:4B:69:1A:98:A5:57:47:C2:34:C7:D9:71\n",
    "b6087b0d7accac204c8656325ecfab6e852d7057": "-----BEGIN CERTIFICATE-----\nMIIDoTCCAomgAwIBAgILBAAAAAABD4WqLUgwDQYJKoZIhvcNAQEFBQAwOzEYMBYG\nA1UEChMPQ3liZXJ0cnVzdCwgSW5jMR8wHQYDVQQDExZDeWJlcnRydXN0IEdsb2Jh\nbCBSb290MB4XDTA2MTIxNTA4MDAwMFoXDTIxMTIxNTA4MDAwMFowOzEYMBYGA1UE\nChMPQ3liZXJ0cnVzdCwgSW5jMR8wHQYDVQQDExZDeWJlcnRydXN0IEdsb2JhbCBS\nb290MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA+Mi8vRRQZhP/8NN5\n7CPytxrHjoXxEnOmGaoQ25yiZXRadz5RfVb23CO21O1fWLE3TdVJDm71aofW0ozS\nJ8bi/zafmGWgE07GKmSb1ZASzxQG9Dvj1Ci+6A74q05IlG2OlTEQXO2iLb3VOm2y\nHLtgwEZLAfVJrn5GitB0jaEMAs7u/OePuGtm839EAL9mJRQr3RAwHQeWP032a7iP\nt3sMpTjr3kfb1V05/Iin89cqdPHoWqI7n1C6poxFNcJQZZXcY4Lv3b93TZxiyWNz\nFtApD0mpSPCzqrdsxacwOUBdrsTiXSZT8M4cIwhhqJQZugRiQOwfOHB3EgZxpzAY\nXSUnpQIDAQABo4GlMIGiMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/\nMB0GA1UdDgQWBBS2CHsNesysIEyGVjJez6tuhS1wVzA/BgNVHR8EODA2MDSgMqAw\nhi5odHRwOi8vd3d3Mi5wdWJsaWMtdHJ1c3QuY29tL2NybC9jdC9jdHJvb3QuY3Js\nMB8GA1UdIwQYMBaAFLYIew16zKwgTIZWMl7Pq26FLXBXMA0GCSqGSIb3DQEBBQUA\nA4IBAQBW7wojoFROlZfJ+InaRcHUowAl9B8Tq7ejhVhpwjCt2BWKLePJzYFa+HMj\nWqd8BfP9IjsO0QbE2zZMcwSO5bAi5MXzLqXZI+O4Tkogp24CJJ8iYGd7ix1yCcUx\nXOl5n4BHPa2hCwcUPUf/A2kaDAtE52Mlp3+yybh2hO0j9n0Hq0V+09+zv+mKts2o\nomcrUtW3ZfA5TGOgkXmTUg9U3YO7n9GPp1Nzw8v/MOx8BLjYRB+TX3EJIrduPuoc\nA06dGiBh+4E37F78CkWr1+cXVdCg6mCbpvbjjFspwgZgFJ0tl0ypkxWdYcQBX0jW\nWL1WMRJOEcgh4LMRkWXbtKaIOM5V\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            04:00:00:00:00:01:0f:85:aa:2d:48\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: O=Cybertrust, Inc, CN=Cybertrust Global Root\n        Validity\n            Not Before: Dec 15 08:00:00 2006 GMT\n            Not After : Dec 15 08:00:00 2021 GMT\n        Subject: O=Cybertrust, Inc, CN=Cybertrust Global Root\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:f8:c8:bc:bd:14:50:66:13:ff:f0:d3:79:ec:23:\n                    f2:b7:1a:c7:8e:85:f1:12:73:a6:19:aa:10:db:9c:\n                    a2:65:74:5a:77:3e:51:7d:56:f6:dc:23:b6:d4:ed:\n                    5f:58:b1:37:4d:d5:49:0e:6e:f5:6a:87:d6:d2:8c:\n                    d2:27:c6:e2:ff:36:9f:98:65:a0:13:4e:c6:2a:64:\n                    9b:d5:90:12:cf:14:06:f4:3b:e3:d4:28:be:e8:0e:\n                    f8:ab:4e:48:94:6d:8e:95:31:10:5c:ed:a2:2d:bd:\n                    d5:3a:6d:b2:1c:bb:60:c0:46:4b:01:f5:49:ae:7e:\n                    46:8a:d0:74:8d:a1:0c:02:ce:ee:fc:e7:8f:b8:6b:\n                    66:f3:7f:44:00:bf:66:25:14:2b:dd:10:30:1d:07:\n                    96:3f:4d:f6:6b:b8:8f:b7:7b:0c:a5:38:eb:de:47:\n                    db:d5:5d:39:fc:88:a7:f3:d7:2a:74:f1:e8:5a:a2:\n                    3b:9f:50:ba:a6:8c:45:35:c2:50:65:95:dc:63:82:\n                    ef:dd:bf:77:4d:9c:62:c9:63:73:16:d0:29:0f:49:\n                    a9:48:f0:b3:aa:b7:6c:c5:a7:30:39:40:5d:ae:c4:\n                    e2:5d:26:53:f0:ce:1c:23:08:61:a8:94:19:ba:04:\n                    62:40:ec:1f:38:70:77:12:06:71:a7:30:18:5d:25:\n                    27:a5\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                B6:08:7B:0D:7A:CC:AC:20:4C:86:56:32:5E:CF:AB:6E:85:2D:70:57\n            X509v3 CRL Distribution Points: \n\n                Full Name:\n                  URI:http://www2.public-trust.com/crl/ct/ctroot.crl\n\n            X509v3 Authority Key Identifier: \n                keyid:B6:08:7B:0D:7A:CC:AC:20:4C:86:56:32:5E:CF:AB:6E:85:2D:70:57\n\n    Signature Algorithm: sha1WithRSAEncryption\n         56:ef:0a:23:a0:54:4e:95:97:c9:f8:89:da:45:c1:d4:a3:00:\n         25:f4:1f:13:ab:b7:a3:85:58:69:c2:30:ad:d8:15:8a:2d:e3:\n         c9:cd:81:5a:f8:73:23:5a:a7:7c:05:f3:fd:22:3b:0e:d1:06:\n         c4:db:36:4c:73:04:8e:e5:b0:22:e4:c5:f3:2e:a5:d9:23:e3:\n         b8:4e:4a:20:a7:6e:02:24:9f:22:60:67:7b:8b:1d:72:09:c5:\n         31:5c:e9:79:9f:80:47:3d:ad:a1:0b:07:14:3d:47:ff:03:69:\n         1a:0c:0b:44:e7:63:25:a7:7f:b2:c9:b8:76:84:ed:23:f6:7d:\n         07:ab:45:7e:d3:df:b3:bf:e9:8a:b6:cd:a8:a2:67:2b:52:d5:\n         b7:65:f0:39:4c:63:a0:91:79:93:52:0f:54:dd:83:bb:9f:d1:\n         8f:a7:53:73:c3:cb:ff:30:ec:7c:04:b8:d8:44:1f:93:5f:71:\n         09:22:b7:6e:3e:ea:1c:03:4e:9d:1a:20:61:fb:81:37:ec:5e:\n         fc:0a:45:ab:d7:e7:17:55:d0:a0:ea:60:9b:a6:f6:e3:8c:5b:\n         29:c2:06:60:14:9d:2d:97:4c:a9:93:15:9d:61:c4:01:5f:48:\n         d6:58:bd:56:31:12:4e:11:c8:21:e0:b3:11:91:65:db:b4:a6:\n         88:38:ce:55\nSHA1 Fingerprint=5F:43:E5:B1:BF:F8:78:8C:AC:1C:C7:CA:4A:9A:C6:22:2B:CC:34:C6\n",
    "b677fa6948479f5312d5c2ea07327607d1970719": "-----BEGIN CERTIFICATE-----\nMIIEuTCCA6GgAwIBAgIQQBrEZCGzEyEDDrvkEhrFHTANBgkqhkiG9w0BAQsFADCB\nvTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\nExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwOCBWZXJp\nU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQDEy9W\nZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAe\nFw0wODA0MDIwMDAwMDBaFw0zNzEyMDEyMzU5NTlaMIG9MQswCQYDVQQGEwJVUzEX\nMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0\nIE5ldHdvcmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWduLCBJbmMuIC0gRm9y\nIGF1dGhvcml6ZWQgdXNlIG9ubHkxODA2BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNh\nbCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIIBIjANBgkqhkiG9w0BAQEF\nAAOCAQ8AMIIBCgKCAQEAx2E3XrEBNNti1xWb/1hajCMj1mCOkdeQmIN65lgZOIzF\n9uVkhbSicfvtvbnazU0AtMgtc6XHaXGVHzk8skQHnOgO+k1KxCHfKWGPMiJhgsWH\nH26MfF8WIFFE0XBPV+rjHOPMee5Y2A7Cs0WTwCznmhcrewA3ekEzeOEz4vMQGn+H\nLL729fdC4uW/h2KJXwBL38Xd5HVEMkE6HnFuacsLdUYI0crSK5XQz/u5QGtkjFdN\n/BMReYTtXlT2NJ8IAfMQJQYXStrxHXpma5hgZqTZ79IugvHw7wnqRMkVauIDbjPT\nrJ9VAMf2CGqUuV/c4DPxhGD5WycRtPwW8rtWaoAljQIDAQABo4GyMIGvMA8GA1Ud\nEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMG0GCCsGAQUFBwEMBGEwX6FdoFsw\nWTBXMFUWCWltYWdlL2dpZjAhMB8wBwYFKw4DAhoEFI/l0xqGrI2Oa8PPgGrUSBgs\nexkuMCUWI2h0dHA6Ly9sb2dvLnZlcmlzaWduLmNvbS92c2xvZ28uZ2lmMB0GA1Ud\nDgQWBBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG9w0BAQsFAAOCAQEASvj4\nsAPmLGd75JR3Y8xuTPl9Dg3cyLk1uXBPY/ok+myDjEedO2Pzmvl2MpWRsXe8rJq+\nseQxIcaBlVZaDrHC1LGmWazxY8u4TB1ZkErvkBYoH1quEPuBUDgMbMzxPcP1Y+Oz\n4yHJJDnp/RVmRvQbEdBNc6N9Rvk97ahfYtTxP/jgdFcrGJ2BtMQo2pSXpXDrrB2+\nBxHw1dvd5Yzw1TKwg+ZX4o+/vqGqvz0dtdQ46tewXDpPaj+PwGZsY6rp2aQW9IHR\nlRQOfc2VNNnSj3BzgXucfr2YYdhFh5iQxeuGMMY1v/D/w1WIg0vvBZIGcfK4mJO3\n7M2CYfE45k+XmCpajQ==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            40:1a:c4:64:21:b3:13:21:03:0e:bb:e4:12:1a:c5:1d\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 2008 VeriSign, Inc. - For authorized use only, CN=VeriSign Universal Root Certification Authority\n        Validity\n            Not Before: Apr  2 00:00:00 2008 GMT\n            Not After : Dec  1 23:59:59 2037 GMT\n        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 2008 VeriSign, Inc. - For authorized use only, CN=VeriSign Universal Root Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:c7:61:37:5e:b1:01:34:db:62:d7:15:9b:ff:58:\n                    5a:8c:23:23:d6:60:8e:91:d7:90:98:83:7a:e6:58:\n                    19:38:8c:c5:f6:e5:64:85:b4:a2:71:fb:ed:bd:b9:\n                    da:cd:4d:00:b4:c8:2d:73:a5:c7:69:71:95:1f:39:\n                    3c:b2:44:07:9c:e8:0e:fa:4d:4a:c4:21:df:29:61:\n                    8f:32:22:61:82:c5:87:1f:6e:8c:7c:5f:16:20:51:\n                    44:d1:70:4f:57:ea:e3:1c:e3:cc:79:ee:58:d8:0e:\n                    c2:b3:45:93:c0:2c:e7:9a:17:2b:7b:00:37:7a:41:\n                    33:78:e1:33:e2:f3:10:1a:7f:87:2c:be:f6:f5:f7:\n                    42:e2:e5:bf:87:62:89:5f:00:4b:df:c5:dd:e4:75:\n                    44:32:41:3a:1e:71:6e:69:cb:0b:75:46:08:d1:ca:\n                    d2:2b:95:d0:cf:fb:b9:40:6b:64:8c:57:4d:fc:13:\n                    11:79:84:ed:5e:54:f6:34:9f:08:01:f3:10:25:06:\n                    17:4a:da:f1:1d:7a:66:6b:98:60:66:a4:d9:ef:d2:\n                    2e:82:f1:f0:ef:09:ea:44:c9:15:6a:e2:03:6e:33:\n                    d3:ac:9f:55:00:c7:f6:08:6a:94:b9:5f:dc:e0:33:\n                    f1:84:60:f9:5b:27:11:b4:fc:16:f2:bb:56:6a:80:\n                    25:8d\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            1.3.6.1.5.5.7.1.12: \n                0_.].[0Y0W0U..image/gif0!0.0...+..............k...j.H.,{..0%.#http://logo.verisign.com/vslogo.gif\n            X509v3 Subject Key Identifier: \n                B6:77:FA:69:48:47:9F:53:12:D5:C2:EA:07:32:76:07:D1:97:07:19\n    Signature Algorithm: sha256WithRSAEncryption\n         4a:f8:f8:b0:03:e6:2c:67:7b:e4:94:77:63:cc:6e:4c:f9:7d:\n         0e:0d:dc:c8:b9:35:b9:70:4f:63:fa:24:fa:6c:83:8c:47:9d:\n         3b:63:f3:9a:f9:76:32:95:91:b1:77:bc:ac:9a:be:b1:e4:31:\n         21:c6:81:95:56:5a:0e:b1:c2:d4:b1:a6:59:ac:f1:63:cb:b8:\n         4c:1d:59:90:4a:ef:90:16:28:1f:5a:ae:10:fb:81:50:38:0c:\n         6c:cc:f1:3d:c3:f5:63:e3:b3:e3:21:c9:24:39:e9:fd:15:66:\n         46:f4:1b:11:d0:4d:73:a3:7d:46:f9:3d:ed:a8:5f:62:d4:f1:\n         3f:f8:e0:74:57:2b:18:9d:81:b4:c4:28:da:94:97:a5:70:eb:\n         ac:1d:be:07:11:f0:d5:db:dd:e5:8c:f0:d5:32:b0:83:e6:57:\n         e2:8f:bf:be:a1:aa:bf:3d:1d:b5:d4:38:ea:d7:b0:5c:3a:4f:\n         6a:3f:8f:c0:66:6c:63:aa:e9:d9:a4:16:f4:81:d1:95:14:0e:\n         7d:cd:95:34:d9:d2:8f:70:73:81:7b:9c:7e:bd:98:61:d8:45:\n         87:98:90:c5:eb:86:30:c6:35:bf:f0:ff:c3:55:88:83:4b:ef:\n         05:92:06:71:f2:b8:98:93:b7:ec:cd:82:61:f1:38:e6:4f:97:\n         98:2a:5a:8d\nSHA1 Fingerprint=36:79:CA:35:66:87:72:30:4D:30:A5:FB:87:3B:0F:A7:7B:B7:0D:54\n",
    "b6a1543902c3a03f8e8abcfad4f81ca6d13a0efd": "-----BEGIN CERTIFICATE-----\nMIIF0jCCA7qgAwIBAgIQIdbQSk8lD8kyN/yqXhKN6TANBgkqhkiG9w0BAQ0FADCB\ngDELMAkGA1UEBhMCUEwxIjAgBgNVBAoTGVVuaXpldG8gVGVjaG5vbG9naWVzIFMu\nQS4xJzAlBgNVBAsTHkNlcnR1bSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEkMCIG\nA1UEAxMbQ2VydHVtIFRydXN0ZWQgTmV0d29yayBDQSAyMCIYDzIwMTExMDA2MDgz\nOTU2WhgPMjA0NjEwMDYwODM5NTZaMIGAMQswCQYDVQQGEwJQTDEiMCAGA1UEChMZ\nVW5pemV0byBUZWNobm9sb2dpZXMgUy5BLjEnMCUGA1UECxMeQ2VydHVtIENlcnRp\nZmljYXRpb24gQXV0aG9yaXR5MSQwIgYDVQQDExtDZXJ0dW0gVHJ1c3RlZCBOZXR3\nb3JrIENBIDIwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQC9+Xj45tWA\nDGSdhhuWZGc/IjoedQF97/tcZ4zJzFxrqZHmuULlIEub2pt7uZld2ZuAS9eEQCsn\n0+i6MLs+CRqnSZXvK0AkwpfHp+6bJe+oCgCXhVqqndwpyeI1B+twTUrWwbNWuKFB\nOJvR+zF/j+Bf4bE/D44WSWDXBo0Y+aomEKsq09DRZ40bRr5HMNUuctHFY9rnY3lE\nfktjJImGLjQ/KUxSiyqnwOKRKIm5wFv5HdnnJ63/mgKXwcZQkpsCLL2puTRZCr+E\nSv/f/rOf69me4Jgj7KZrdxYq28ytOxykh9xGc14ZYmhFV+SQgkK7QtbwYeDBoz1m\no130GO6IyY0XRSmZMnUCMe4pJshrAua1YkV/NxVaI2iJ1D7eTiew8EAMvE0Xy02i\nsx7QBlrd9pPPV3WZ9fqGGmd4s7+W/jTcvedSVuWz5XV710GRBdxdaeOVDUO5/IOW\nOZV7bIBaTxNyxtd9KXpEulKkKtVBRgkg/iKgtlswjbyJDNXXcPiHUv3a76xRLgez\nTv7QCdpw75j6VuZt27VXS9zlLCUVyJ4ueE742pyehizKV/Ma5ciSixqClnrDvFAS\nadgOWkaLOusm+iPJtrCBvkIApPjW/jAux9JG9uWOdf3yzLnQh1vMBhBgu4M1t15n\n3kfsmUjxpKEV/q2MYo45VU85FrmxY53/twIDAQABo0IwQDAPBgNVHRMBAf8EBTAD\nAQH/MB0GA1UdDgQWBBS2oVQ5AsOgP46KvPrU+Bym0ToO/TAOBgNVHQ8BAf8EBAMC\nAQYwDQYJKoZIhvcNAQENBQADggIBAHGlDs7k6b8/ONWJWsQCYftMxRQXLYtPU2sQ\nF/xlhMcQSZDe28cmk4gmb3DWAl45oPePq5a1pRNcgRRtDoGCERuKTsZPpd1iHkTf\nCVn0W3cLN+mLIMb4Ck4uWBzrM9DPhmDJ2vuAL55MYIR4PSFk1vtBHxgP58l1cb29\nXN40hz5BsA72udY/CROWFC/emh1auVbONTqwX3BNXuMp8SMoclm2q8KMZiYcdywm\ndjWLKKdpoPk79SPdhRB0yZADVpHnr7pH1BKXESLjokmUbOe3lEu6LaTaM4tMpkT/\nWjzGHWTYtTHkpjx6qFcL2+1hGsvxznN3Y6SHb0xRONbkX8eftoEq5IVIeVheO/jb\nAoJnwTnbw3RLPTYe+SmTiGhbqEQZIfCn6IENLOiTNrQ3ssqwGyZ6miUfmpqAnksq\nP/ujmv5zMnHCnsZy4YpoJ/HkD7TETKVhk/iXEAcqMCWpuchxuO9ozC1+9eB+D4Ko\nb7a6bINDd82Kkhehnlt4Fj1F4jNy3eFmypnTycUm/Q1oBEauttmbjL4ZvrHG8hnj\nXALKLNhvSgfZyTXaQHXyxKcZb55CEJh15pWLYLztxRLXis7VmFxWlgPF7ncGNf/P\n5O4/E2Hu29othfDNrp2yGAlFw5Khchf8R7agCyzxxN5DaAhqXzvwdmP7zAYspsbi\nDrW5viSP\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            21:d6:d0:4a:4f:25:0f:c9:32:37:fc:aa:5e:12:8d:e9\n        Signature Algorithm: sha512WithRSAEncryption\n        Issuer: C=PL, O=Unizeto Technologies S.A., OU=Certum Certification Authority, CN=Certum Trusted Network CA 2\n        Validity\n            Not Before: Oct  6 08:39:56 2011 GMT\n            Not After : Oct  6 08:39:56 2046 GMT\n        Subject: C=PL, O=Unizeto Technologies S.A., OU=Certum Certification Authority, CN=Certum Trusted Network CA 2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:bd:f9:78:f8:e6:d5:80:0c:64:9d:86:1b:96:64:\n                    67:3f:22:3a:1e:75:01:7d:ef:fb:5c:67:8c:c9:cc:\n                    5c:6b:a9:91:e6:b9:42:e5:20:4b:9b:da:9b:7b:b9:\n                    99:5d:d9:9b:80:4b:d7:84:40:2b:27:d3:e8:ba:30:\n                    bb:3e:09:1a:a7:49:95:ef:2b:40:24:c2:97:c7:a7:\n                    ee:9b:25:ef:a8:0a:00:97:85:5a:aa:9d:dc:29:c9:\n                    e2:35:07:eb:70:4d:4a:d6:c1:b3:56:b8:a1:41:38:\n                    9b:d1:fb:31:7f:8f:e0:5f:e1:b1:3f:0f:8e:16:49:\n                    60:d7:06:8d:18:f9:aa:26:10:ab:2a:d3:d0:d1:67:\n                    8d:1b:46:be:47:30:d5:2e:72:d1:c5:63:da:e7:63:\n                    79:44:7e:4b:63:24:89:86:2e:34:3f:29:4c:52:8b:\n                    2a:a7:c0:e2:91:28:89:b9:c0:5b:f9:1d:d9:e7:27:\n                    ad:ff:9a:02:97:c1:c6:50:92:9b:02:2c:bd:a9:b9:\n                    34:59:0a:bf:84:4a:ff:df:fe:b3:9f:eb:d9:9e:e0:\n                    98:23:ec:a6:6b:77:16:2a:db:cc:ad:3b:1c:a4:87:\n                    dc:46:73:5e:19:62:68:45:57:e4:90:82:42:bb:42:\n                    d6:f0:61:e0:c1:a3:3d:66:a3:5d:f4:18:ee:88:c9:\n                    8d:17:45:29:99:32:75:02:31:ee:29:26:c8:6b:02:\n                    e6:b5:62:45:7f:37:15:5a:23:68:89:d4:3e:de:4e:\n                    27:b0:f0:40:0c:bc:4d:17:cb:4d:a2:b3:1e:d0:06:\n                    5a:dd:f6:93:cf:57:75:99:f5:fa:86:1a:67:78:b3:\n                    bf:96:fe:34:dc:bd:e7:52:56:e5:b3:e5:75:7b:d7:\n                    41:91:05:dc:5d:69:e3:95:0d:43:b9:fc:83:96:39:\n                    95:7b:6c:80:5a:4f:13:72:c6:d7:7d:29:7a:44:ba:\n                    52:a4:2a:d5:41:46:09:20:fe:22:a0:b6:5b:30:8d:\n                    bc:89:0c:d5:d7:70:f8:87:52:fd:da:ef:ac:51:2e:\n                    07:b3:4e:fe:d0:09:da:70:ef:98:fa:56:e6:6d:db:\n                    b5:57:4b:dc:e5:2c:25:15:c8:9e:2e:78:4e:f8:da:\n                    9c:9e:86:2c:ca:57:f3:1a:e5:c8:92:8b:1a:82:96:\n                    7a:c3:bc:50:12:69:d8:0e:5a:46:8b:3a:eb:26:fa:\n                    23:c9:b6:b0:81:be:42:00:a4:f8:d6:fe:30:2e:c7:\n                    d2:46:f6:e5:8e:75:fd:f2:cc:b9:d0:87:5b:cc:06:\n                    10:60:bb:83:35:b7:5e:67:de:47:ec:99:48:f1:a4:\n                    a1:15:fe:ad:8c:62:8e:39:55:4f:39:16:b9:b1:63:\n                    9d:ff:b7\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                B6:A1:54:39:02:C3:A0:3F:8E:8A:BC:FA:D4:F8:1C:A6:D1:3A:0E:FD\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha512WithRSAEncryption\n         71:a5:0e:ce:e4:e9:bf:3f:38:d5:89:5a:c4:02:61:fb:4c:c5:\n         14:17:2d:8b:4f:53:6b:10:17:fc:65:84:c7:10:49:90:de:db:\n         c7:26:93:88:26:6f:70:d6:02:5e:39:a0:f7:8f:ab:96:b5:a5:\n         13:5c:81:14:6d:0e:81:82:11:1b:8a:4e:c6:4f:a5:dd:62:1e:\n         44:df:09:59:f4:5b:77:0b:37:e9:8b:20:c6:f8:0a:4e:2e:58:\n         1c:eb:33:d0:cf:86:60:c9:da:fb:80:2f:9e:4c:60:84:78:3d:\n         21:64:d6:fb:41:1f:18:0f:e7:c9:75:71:bd:bd:5c:de:34:87:\n         3e:41:b0:0e:f6:b9:d6:3f:09:13:96:14:2f:de:9a:1d:5a:b9:\n         56:ce:35:3a:b0:5f:70:4d:5e:e3:29:f1:23:28:72:59:b6:ab:\n         c2:8c:66:26:1c:77:2c:26:76:35:8b:28:a7:69:a0:f9:3b:f5:\n         23:dd:85:10:74:c9:90:03:56:91:e7:af:ba:47:d4:12:97:11:\n         22:e3:a2:49:94:6c:e7:b7:94:4b:ba:2d:a4:da:33:8b:4c:a6:\n         44:ff:5a:3c:c6:1d:64:d8:b5:31:e4:a6:3c:7a:a8:57:0b:db:\n         ed:61:1a:cb:f1:ce:73:77:63:a4:87:6f:4c:51:38:d6:e4:5f:\n         c7:9f:b6:81:2a:e4:85:48:79:58:5e:3b:f8:db:02:82:67:c1:\n         39:db:c3:74:4b:3d:36:1e:f9:29:93:88:68:5b:a8:44:19:21:\n         f0:a7:e8:81:0d:2c:e8:93:36:b4:37:b2:ca:b0:1b:26:7a:9a:\n         25:1f:9a:9a:80:9e:4b:2a:3f:fb:a3:9a:fe:73:32:71:c2:9e:\n         c6:72:e1:8a:68:27:f1:e4:0f:b4:c4:4c:a5:61:93:f8:97:10:\n         07:2a:30:25:a9:b9:c8:71:b8:ef:68:cc:2d:7e:f5:e0:7e:0f:\n         82:a8:6f:b6:ba:6c:83:43:77:cd:8a:92:17:a1:9e:5b:78:16:\n         3d:45:e2:33:72:dd:e1:66:ca:99:d3:c9:c5:26:fd:0d:68:04:\n         46:ae:b6:d9:9b:8c:be:19:be:b1:c6:f2:19:e3:5c:02:ca:2c:\n         d8:6f:4a:07:d9:c9:35:da:40:75:f2:c4:a7:19:6f:9e:42:10:\n         98:75:e6:95:8b:60:bc:ed:c5:12:d7:8a:ce:d5:98:5c:56:96:\n         03:c5:ee:77:06:35:ff:cf:e4:ee:3f:13:61:ee:db:da:2d:85:\n         f0:cd:ae:9d:b2:18:09:45:c3:92:a1:72:17:fc:47:b6:a0:0b:\n         2c:f1:c4:de:43:68:08:6a:5f:3b:f0:76:63:fb:cc:06:2c:a6:\n         c6:e2:0e:b5:b9:be:24:8f\nSHA1 Fingerprint=D3:DD:48:3E:2B:BF:4C:05:E8:AF:10:F5:FA:76:26:CF:D3:DC:30:92\n",
    "b763e71add8de908a65583a4e06a504165114249": "-----BEGIN CERTIFICATE-----\nMIIC+TCCAoCgAwIBAgINAKaLeSkAAAAAUNCR+TAKBggqhkjOPQQDAzCBvzELMAkG\nA1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3\nd3cuZW50cnVzdC5uZXQvbGVnYWwtdGVybXMxOTA3BgNVBAsTMChjKSAyMDEyIEVu\ndHJ1c3QsIEluYy4gLSBmb3IgYXV0aG9yaXplZCB1c2Ugb25seTEzMDEGA1UEAxMq\nRW50cnVzdCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRUMxMB4XDTEy\nMTIxODE1MjUzNloXDTM3MTIxODE1NTUzNlowgb8xCzAJBgNVBAYTAlVTMRYwFAYD\nVQQKEw1FbnRydXN0LCBJbmMuMSgwJgYDVQQLEx9TZWUgd3d3LmVudHJ1c3QubmV0\nL2xlZ2FsLXRlcm1zMTkwNwYDVQQLEzAoYykgMjAxMiBFbnRydXN0LCBJbmMuIC0g\nZm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxMzAxBgNVBAMTKkVudHJ1c3QgUm9vdCBD\nZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEVDMTB2MBAGByqGSM49AgEGBSuBBAAi\nA2IABIQTydC6bUF74mzQ61VfZgIaJPRbiWlH47jCffHyAsWfoPZb1YsGGYZPUxBt\nByQnoaD41UcZYUx9ypMn6nQM72+WCf5j7HBdNq1nd67JnXxVRDqiY1Ef9eNi1KlH\nBz7MIKNCMEAwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0O\nBBYEFLdj5xrdjekIplWDpOBqUEFlEUJJMAoGCCqGSM49BAMDA2cAMGQCMGF52OVC\nR98crlOZF7ZvHH3hvxGU0QOIdeSNiaSKd0bebWHvAvX7td/M/k7//qnmpwIwW5nX\nhTcGtXsI/esni0qU+eH6p44mCOh8kmhtc9hvJqwhAriZtyZBWyVgrtBIGu4G\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            a6:8b:79:29:00:00:00:00:50:d0:91:f9\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2012 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - EC1\n        Validity\n            Not Before: Dec 18 15:25:36 2012 GMT\n            Not After : Dec 18 15:55:36 2037 GMT\n        Subject: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2012 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - EC1\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:84:13:c9:d0:ba:6d:41:7b:e2:6c:d0:eb:55:5f:\n                    66:02:1a:24:f4:5b:89:69:47:e3:b8:c2:7d:f1:f2:\n                    02:c5:9f:a0:f6:5b:d5:8b:06:19:86:4f:53:10:6d:\n                    07:24:27:a1:a0:f8:d5:47:19:61:4c:7d:ca:93:27:\n                    ea:74:0c:ef:6f:96:09:fe:63:ec:70:5d:36:ad:67:\n                    77:ae:c9:9d:7c:55:44:3a:a2:63:51:1f:f5:e3:62:\n                    d4:a9:47:07:3e:cc:20\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                B7:63:E7:1A:DD:8D:E9:08:A6:55:83:A4:E0:6A:50:41:65:11:42:49\n    Signature Algorithm: ecdsa-with-SHA384\n         30:64:02:30:61:79:d8:e5:42:47:df:1c:ae:53:99:17:b6:6f:\n         1c:7d:e1:bf:11:94:d1:03:88:75:e4:8d:89:a4:8a:77:46:de:\n         6d:61:ef:02:f5:fb:b5:df:cc:fe:4e:ff:fe:a9:e6:a7:02:30:\n         5b:99:d7:85:37:06:b5:7b:08:fd:eb:27:8b:4a:94:f9:e1:fa:\n         a7:8e:26:08:e8:7c:92:68:6d:73:d8:6f:26:ac:21:02:b8:99:\n         b7:26:41:5b:25:60:ae:d0:48:1a:ee:06\nSHA1 Fingerprint=20:D8:06:40:DF:9B:25:F5:12:25:3A:11:EA:F7:59:8A:EB:14:B5:47\n",
    "b909ca9c1edbd36c3a6baeed54f15b9306352e5e": "-----BEGIN CERTIFICATE-----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\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            c9:cd:d3:e9:d5:7d:23:ce\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=EU, L=Madrid (see current address at www.camerfirma.com/address)/serialNumber=A82743287, O=AC Camerfirma S.A., CN=Global Chambersign Root - 2008\n        Validity\n            Not Before: Aug  1 12:31:40 2008 GMT\n            Not After : Jul 31 12:31:40 2038 GMT\n        Subject: C=EU, L=Madrid (see current address at www.camerfirma.com/address)/serialNumber=A82743287, O=AC Camerfirma S.A., CN=Global Chambersign Root - 2008\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:c0:df:56:d3:e4:3a:9b:76:45:b4:13:db:ff:c1:\n                    b6:19:8b:37:41:18:95:52:47:eb:17:9d:29:88:8e:\n                    35:6c:06:32:2e:47:62:f3:49:04:bf:7d:44:36:b1:\n                    71:cc:bd:5a:09:73:d5:d9:85:44:ff:91:57:25:df:\n                    5e:36:8e:70:d1:5c:71:43:1d:d9:da:ef:5c:d2:fb:\n                    1b:bd:3a:b5:cb:ad:a3:cc:44:a7:0d:ae:21:15:3f:\n                    b9:7a:5b:92:75:d8:a4:12:38:89:19:8a:b7:80:d2:\n                    e2:32:6f:56:9c:91:d6:88:10:0b:b3:74:64:92:74:\n                    60:f3:f6:cf:18:4f:60:b2:23:d0:c7:3b:ce:61:4b:\n                    99:8f:c2:0c:d0:40:b2:98:dc:0d:a8:4e:a3:b9:0a:\n                    ae:60:a0:ad:45:52:63:ba:66:bd:68:e0:f9:be:1a:\n                    a8:81:bb:1e:41:78:75:d3:c1:fe:00:55:b0:87:54:\n                    e8:27:90:35:1d:4c:33:ad:97:fc:97:2e:98:84:bf:\n                    2c:c9:a3:bf:d1:98:11:14:ed:63:f8:ca:98:88:58:\n                    17:99:ed:45:03:97:7e:3c:86:1e:88:8c:be:f2:91:\n                    84:8f:65:34:d8:00:4c:7d:b7:31:17:5a:29:7a:0a:\n                    18:24:30:a3:37:b5:7a:a9:01:7d:26:d6:f9:0e:8e:\n                    59:f1:fd:1b:33:b5:29:3b:17:3b:41:b6:21:dd:d4:\n                    c0:3d:a5:9f:9f:1f:43:50:c9:bb:bc:6c:7a:97:98:\n                    ee:cd:8c:1f:fb:9c:51:ae:8b:70:bd:27:9f:71:c0:\n                    6b:ac:7d:90:66:e8:d7:5d:3a:0d:b0:d5:c2:8d:d5:\n                    c8:9d:9d:c1:6d:d0:d0:bf:51:e4:e3:f8:c3:38:36:\n                    ae:d6:a7:75:e6:af:84:43:5d:93:92:0c:6a:07:de:\n                    3b:1d:98:22:d6:ac:c1:35:db:a3:a0:25:ff:72:b5:\n                    76:1d:de:6d:e9:2c:66:2c:52:84:d0:45:92:ce:1c:\n                    e5:e5:33:1d:dc:07:53:54:a3:aa:82:3b:9a:37:2f:\n                    dc:dd:a0:64:e9:e6:dd:bd:ae:fc:64:85:1d:3c:a7:\n                    c9:06:de:84:ff:6b:e8:6b:1a:3c:c5:a2:b3:42:fb:\n                    8b:09:3e:5f:08:52:c7:62:c4:d4:05:71:bf:c4:64:\n                    e4:f8:a1:83:e8:3e:12:9b:a8:1e:d4:36:4d:2f:71:\n                    f6:8d:28:f6:83:a9:13:d2:61:c1:91:bb:48:c0:34:\n                    8f:41:8c:4b:4c:db:69:12:ff:50:94:9c:20:83:59:\n                    73:ed:7c:a1:f2:f1:fd:dd:f7:49:d3:43:58:a0:56:\n                    63:ca:3d:3d:e5:35:56:59:e9:0e:ca:20:cc:2b:4b:\n                    93:29:0f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE, pathlen:12\n            X509v3 Subject Key Identifier: \n                B9:09:CA:9C:1E:DB:D3:6C:3A:6B:AE:ED:54:F1:5B:93:06:35:2E:5E\n            X509v3 Authority Key Identifier: \n                keyid:B9:09:CA:9C:1E:DB:D3:6C:3A:6B:AE:ED:54:F1:5B:93:06:35:2E:5E\n                DirName:/C=EU/L=Madrid (see current address at www.camerfirma.com/address)/serialNumber=A82743287/O=AC Camerfirma S.A./CN=Global Chambersign Root - 2008\n                serial:C9:CD:D3:E9:D5:7D:23:CE\n\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Certificate Policies: \n                Policy: X509v3 Any Policy\n                  CPS: http://policy.camerfirma.com\n\n    Signature Algorithm: sha1WithRSAEncryption\n         80:88:7f:70:de:92:28:d9:05:94:46:ff:90:57:a9:f1:2f:df:\n         1a:0d:6b:fa:7c:0e:1c:49:24:79:27:d8:46:aa:6f:29:59:52:\n         88:70:12:ea:dd:3d:f5:9b:53:54:6f:e1:60:a2:a8:09:b9:ec:\n         eb:59:7c:c6:35:f1:dc:18:e9:f1:67:e5:af:ba:45:e0:09:de:\n         ca:44:0f:c2:17:0e:77:91:45:7a:33:5f:5f:96:2c:68:8b:c1:\n         47:8f:98:9b:3d:c0:ec:cb:f5:d5:82:92:84:35:d1:be:36:38:\n         56:72:31:5b:47:2d:aa:17:a4:63:51:eb:0a:01:ad:7f:ec:75:\n         9e:cb:a1:1f:f1:7f:12:b1:b9:e4:64:7f:67:d6:23:2a:f4:b8:\n         39:5d:98:e8:21:a7:e1:bd:3d:42:1a:74:9a:70:af:68:6c:50:\n         5d:49:cf:ff:fb:0e:5d:e6:2c:47:d7:81:3a:59:00:b5:73:6b:\n         63:20:f6:31:45:08:39:0e:f4:70:7e:40:70:5a:3f:d0:6b:42:\n         a9:74:3d:28:2f:02:6d:75:72:95:09:8d:48:63:c6:c6:23:57:\n         92:93:5e:35:c1:8d:f9:0a:f7:2c:9d:62:1c:f6:ad:7c:dd:a6:\n         31:1e:b6:b1:c7:7e:85:26:fa:a4:6a:b5:da:63:30:d1:ef:93:\n         37:b2:66:2f:7d:05:f7:e7:b7:4b:98:94:35:c0:d9:3a:29:c1:\n         9d:b2:50:33:1d:4a:a9:5a:a6:c9:03:ef:ed:f4:e7:a8:6e:8a:\n         b4:57:84:eb:a4:3f:d0:ee:aa:aa:87:5b:63:e8:93:e2:6b:a8:\n         d4:b8:72:78:6b:1b:ed:39:e4:5d:cb:9b:aa:87:d5:4f:4e:00:\n         fe:d9:6a:9f:3c:31:0f:28:02:01:7d:98:e8:a7:b0:a2:64:9e:\n         79:f8:48:f2:15:a9:cc:e6:c8:44:eb:3f:78:99:f2:7b:71:3e:\n         3c:f1:98:a7:c5:18:12:3f:e6:bb:28:33:42:e9:45:0a:7c:6d:\n         f2:86:79:2f:c5:82:19:7d:09:89:7c:b2:54:76:88:ae:de:c1:\n         f3:cc:e1:6e:db:31:d6:93:ae:99:a0:ef:25:6a:73:98:89:5b:\n         3a:2e:13:88:1e:bf:c0:92:94:34:1b:e3:27:b7:8b:1e:6f:42:\n         ff:e7:e9:37:9b:50:1d:2d:a2:f9:02:ee:cb:58:58:3a:71:bc:\n         68:e3:aa:c1:af:1c:28:1f:a2:dc:23:65:3f:81:ea:ae:99:d3:\n         d8:30:cf:13:0d:4f:15:c9:84:bc:a7:48:2d:f8:30:23:77:d8:\n         46:4b:79:6d:f6:8c:ed:3a:7f:60:11:78:f4:e9:9b:ae:d5:54:\n         c0:74:80:d1:0b:42:9f:c1\nSHA1 Fingerprint=4A:BD:EE:EC:95:0D:35:9C:89:AE:C7:52:A1:2C:5B:29:F6:D6:AA:0C\n",
    "bafa7125798b57412521860b71ebb2640e8b2167": "-----BEGIN CERTIFICATE-----\nMIIDZzCCAk+gAwIBAgIQGx+ttiD5JNM2a/fH8YygWTANBgkqhkiG9w0BAQUFADBF\nMQswCQYDVQQGEwJHQjEYMBYGA1UEChMPVHJ1c3RpcyBMaW1pdGVkMRwwGgYDVQQL\nExNUcnVzdGlzIEZQUyBSb290IENBMB4XDTAzMTIyMzEyMTQwNloXDTI0MDEyMTEx\nMzY1NFowRTELMAkGA1UEBhMCR0IxGDAWBgNVBAoTD1RydXN0aXMgTGltaXRlZDEc\nMBoGA1UECxMTVHJ1c3RpcyBGUFMgUm9vdCBDQTCCASIwDQYJKoZIhvcNAQEBBQAD\nggEPADCCAQoCggEBAMVQe547NdDfxIzNjpvto8A2mfRC6qc+gIMPpqdZh8mQRUN+\nAOqGeSoDvT03mYlmt+WKVoaTnGhLaASMk5MCPjDSNzoiYYkchU59j9WvezX2fihH\niTHcDnlkH5nSW7r+f2C/revnPDgpai/lkQtV/+xvWNUtyd5MZnGPDNcE2gfmHhjj\nvSkCqPoc4Vu5g6hBSLwacY3nYuUtsuvffM/bq1rKMfFMIvMFE/eC+XN5DL7XSxzA\n0RU8k0Fk0ea+IxciAIleH2ulrG6nS4zto3Lmr2NNL4XSFDWaLk6M6jKYKIahkQlB\nOrTh4/L68MkKokHdqeMDx4gVOxzUGpTXn2RZEm0CAwEAAaNTMFEwDwYDVR0TAQH/\nBAUwAwEB/zAfBgNVHSMEGDAWgBS6+nEleYtXQSUhhgtx67JkDoshZzAdBgNVHQ4E\nFgQUuvpxJXmLV0ElIYYLceuyZA6LIWcwDQYJKoZIhvcNAQEFBQADggEBAH5Y//01\nGX2cGE+esCu8jowU/yyg2kdbw++BLa8F6nRIW/M+TgfHbcWzk88iNVy2P3UnXwmW\nzaD+vkAMXBJV+JOCyinpXj9WV4s4NvdFGkwozZ5BuO1WTISkQMi4sKUraXAEasP4\n1BIy+Q7DsdwyhEQsb8tGD+pmQQ9P8Vilpg0ND2HepZ5dfWWhPBfnqFVO76DH7cZE\nf1T1o+CP8HxVIo8ptoGj4W1OLBuAZ+ytIJ8MYmHVl/9D7S3B2l0pKoU/rGXuhg8F\njZBf3+6f9L/uHfuY5H+QK4R4EA5sSVPvFVtlRkpdr7r7OnIdzfYliB6XzCGcKQEN\nZetX2fNXlrtIzYE=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            1b:1f:ad:b6:20:f9:24:d3:36:6b:f7:c7:f1:8c:a0:59\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=GB, O=Trustis Limited, OU=Trustis FPS Root CA\n        Validity\n            Not Before: Dec 23 12:14:06 2003 GMT\n            Not After : Jan 21 11:36:54 2024 GMT\n        Subject: C=GB, O=Trustis Limited, OU=Trustis FPS Root CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:c5:50:7b:9e:3b:35:d0:df:c4:8c:cd:8e:9b:ed:\n                    a3:c0:36:99:f4:42:ea:a7:3e:80:83:0f:a6:a7:59:\n                    87:c9:90:45:43:7e:00:ea:86:79:2a:03:bd:3d:37:\n                    99:89:66:b7:e5:8a:56:86:93:9c:68:4b:68:04:8c:\n                    93:93:02:3e:30:d2:37:3a:22:61:89:1c:85:4e:7d:\n                    8f:d5:af:7b:35:f6:7e:28:47:89:31:dc:0e:79:64:\n                    1f:99:d2:5b:ba:fe:7f:60:bf:ad:eb:e7:3c:38:29:\n                    6a:2f:e5:91:0b:55:ff:ec:6f:58:d5:2d:c9:de:4c:\n                    66:71:8f:0c:d7:04:da:07:e6:1e:18:e3:bd:29:02:\n                    a8:fa:1c:e1:5b:b9:83:a8:41:48:bc:1a:71:8d:e7:\n                    62:e5:2d:b2:eb:df:7c:cf:db:ab:5a:ca:31:f1:4c:\n                    22:f3:05:13:f7:82:f9:73:79:0c:be:d7:4b:1c:c0:\n                    d1:15:3c:93:41:64:d1:e6:be:23:17:22:00:89:5e:\n                    1f:6b:a5:ac:6e:a7:4b:8c:ed:a3:72:e6:af:63:4d:\n                    2f:85:d2:14:35:9a:2e:4e:8c:ea:32:98:28:86:a1:\n                    91:09:41:3a:b4:e1:e3:f2:fa:f0:c9:0a:a2:41:dd:\n                    a9:e3:03:c7:88:15:3b:1c:d4:1a:94:d7:9f:64:59:\n                    12:6d\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Authority Key Identifier: \n                keyid:BA:FA:71:25:79:8B:57:41:25:21:86:0B:71:EB:B2:64:0E:8B:21:67\n\n            X509v3 Subject Key Identifier: \n                BA:FA:71:25:79:8B:57:41:25:21:86:0B:71:EB:B2:64:0E:8B:21:67\n    Signature Algorithm: sha1WithRSAEncryption\n         7e:58:ff:fd:35:19:7d:9c:18:4f:9e:b0:2b:bc:8e:8c:14:ff:\n         2c:a0:da:47:5b:c3:ef:81:2d:af:05:ea:74:48:5b:f3:3e:4e:\n         07:c7:6d:c5:b3:93:cf:22:35:5c:b6:3f:75:27:5f:09:96:cd:\n         a0:fe:be:40:0c:5c:12:55:f8:93:82:ca:29:e9:5e:3f:56:57:\n         8b:38:36:f7:45:1a:4c:28:cd:9e:41:b8:ed:56:4c:84:a4:40:\n         c8:b8:b0:a5:2b:69:70:04:6a:c3:f8:d4:12:32:f9:0e:c3:b1:\n         dc:32:84:44:2c:6f:cb:46:0f:ea:66:41:0f:4f:f1:58:a5:a6:\n         0d:0d:0f:61:de:a5:9e:5d:7d:65:a1:3c:17:e7:a8:55:4e:ef:\n         a0:c7:ed:c6:44:7f:54:f5:a3:e0:8f:f0:7c:55:22:8f:29:b6:\n         81:a3:e1:6d:4e:2c:1b:80:67:ec:ad:20:9f:0c:62:61:d5:97:\n         ff:43:ed:2d:c1:da:5d:29:2a:85:3f:ac:65:ee:86:0f:05:8d:\n         90:5f:df:ee:9f:f4:bf:ee:1d:fb:98:e4:7f:90:2b:84:78:10:\n         0e:6c:49:53:ef:15:5b:65:46:4a:5d:af:ba:fb:3a:72:1d:cd:\n         f6:25:88:1e:97:cc:21:9c:29:01:0d:65:eb:57:d9:f3:57:96:\n         bb:48:cd:81\nSHA1 Fingerprint=3B:C0:38:0B:33:C3:F6:A6:0C:86:15:22:93:D9:DF:F5:4B:81:C0:04\n",
    "bbaf7e023dfaa6f13c848eadee3898ecd93232d4": "-----BEGIN CERTIFICATE-----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\nNVOFBkpdn627G190\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            4c:aa:f9:ca:db:63:6f:e0:1f:f7:4e:d8:5b:03:86:9d\n        Signature Algorithm: sha384WithRSAEncryption\n        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO RSA Certification Authority\n        Validity\n            Not Before: Jan 19 00:00:00 2010 GMT\n            Not After : Jan 18 23:59:59 2038 GMT\n        Subject: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO RSA Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:91:e8:54:92:d2:0a:56:b1:ac:0d:24:dd:c5:cf:\n                    44:67:74:99:2b:37:a3:7d:23:70:00:71:bc:53:df:\n                    c4:fa:2a:12:8f:4b:7f:10:56:bd:9f:70:72:b7:61:\n                    7f:c9:4b:0f:17:a7:3d:e3:b0:04:61:ee:ff:11:97:\n                    c7:f4:86:3e:0a:fa:3e:5c:f9:93:e6:34:7a:d9:14:\n                    6b:e7:9c:b3:85:a0:82:7a:76:af:71:90:d7:ec:fd:\n                    0d:fa:9c:6c:fa:df:b0:82:f4:14:7e:f9:be:c4:a6:\n                    2f:4f:7f:99:7f:b5:fc:67:43:72:bd:0c:00:d6:89:\n                    eb:6b:2c:d3:ed:8f:98:1c:14:ab:7e:e5:e3:6e:fc:\n                    d8:a8:e4:92:24:da:43:6b:62:b8:55:fd:ea:c1:bc:\n                    6c:b6:8b:f3:0e:8d:9a:e4:9b:6c:69:99:f8:78:48:\n                    30:45:d5:ad:e1:0d:3c:45:60:fc:32:96:51:27:bc:\n                    67:c3:ca:2e:b6:6b:ea:46:c7:c7:20:a0:b1:1f:65:\n                    de:48:08:ba:a4:4e:a9:f2:83:46:37:84:eb:e8:cc:\n                    81:48:43:67:4e:72:2a:9b:5c:bd:4c:1b:28:8a:5c:\n                    22:7b:b4:ab:98:d9:ee:e0:51:83:c3:09:46:4e:6d:\n                    3e:99:fa:95:17:da:7c:33:57:41:3c:8d:51:ed:0b:\n                    b6:5c:af:2c:63:1a:df:57:c8:3f:bc:e9:5d:c4:9b:\n                    af:45:99:e2:a3:5a:24:b4:ba:a9:56:3d:cf:6f:aa:\n                    ff:49:58:be:f0:a8:ff:f4:b8:ad:e9:37:fb:ba:b8:\n                    f4:0b:3a:f9:e8:43:42:1e:89:d8:84:cb:13:f1:d9:\n                    bb:e1:89:60:b8:8c:28:56:ac:14:1d:9c:0a:e7:71:\n                    eb:cf:0e:dd:3d:a9:96:a1:48:bd:3c:f7:af:b5:0d:\n                    22:4c:c0:11:81:ec:56:3b:f6:d3:a2:e2:5b:b7:b2:\n                    04:22:52:95:80:93:69:e8:8e:4c:65:f1:91:03:2d:\n                    70:74:02:ea:8b:67:15:29:69:52:02:bb:d7:df:50:\n                    6a:55:46:bf:a0:a3:28:61:7f:70:d0:c3:a2:aa:2c:\n                    21:aa:47:ce:28:9c:06:45:76:bf:82:18:27:b4:d5:\n                    ae:b4:cb:50:e6:6b:f4:4c:86:71:30:e9:a6:df:16:\n                    86:e0:d8:ff:40:dd:fb:d0:42:88:7f:a3:33:3a:2e:\n                    5c:1e:41:11:81:63:ce:18:71:6b:2b:ec:a6:8a:b7:\n                    31:5c:3a:6a:47:e0:c3:79:59:d6:20:1a:af:f2:6a:\n                    98:aa:72:bc:57:4a:d2:4b:9d:bb:10:fc:b0:4c:41:\n                    e5:ed:1d:3d:5e:28:9d:9c:cc:bf:b3:51:da:a7:47:\n                    e5:84:53\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                BB:AF:7E:02:3D:FA:A6:F1:3C:84:8E:AD:EE:38:98:EC:D9:32:32:D4\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: sha384WithRSAEncryption\n         0a:f1:d5:46:84:b7:ae:51:bb:6c:b2:4d:41:14:00:93:4c:9c:\n         cb:e5:c0:54:cf:a0:25:8e:02:f9:fd:b0:a2:0d:f5:20:98:3c:\n         13:2d:ac:56:a2:b0:d6:7e:11:92:e9:2e:ba:9e:2e:9a:72:b1:\n         bd:19:44:6c:61:35:a2:9a:b4:16:12:69:5a:8c:e1:d7:3e:a4:\n         1a:e8:2f:03:f4:ae:61:1d:10:1b:2a:a4:8b:7a:c5:fe:05:a6:\n         e1:c0:d6:c8:fe:9e:ae:8f:2b:ba:3d:99:f8:d8:73:09:58:46:\n         6e:a6:9c:f4:d7:27:d3:95:da:37:83:72:1c:d3:73:e0:a2:47:\n         99:03:38:5d:d5:49:79:00:29:1c:c7:ec:9b:20:1c:07:24:69:\n         57:78:b2:39:fc:3a:84:a0:b5:9c:7c:8d:bf:2e:93:62:27:b7:\n         39:da:17:18:ae:bd:3c:09:68:ff:84:9b:3c:d5:d6:0b:03:e3:\n         57:9e:14:f7:d1:eb:4f:c8:bd:87:23:b7:b6:49:43:79:85:5c:\n         ba:eb:92:0b:a1:c6:e8:68:a8:4c:16:b1:1a:99:0a:e8:53:2c:\n         92:bb:a1:09:18:75:0c:65:a8:7b:cb:23:b7:1a:c2:28:85:c3:\n         1b:ff:d0:2b:62:ef:a4:7b:09:91:98:67:8c:14:01:cd:68:06:\n         6a:63:21:75:03:80:88:8a:6e:81:c6:85:f2:a9:a4:2d:e7:f4:\n         a5:24:10:47:83:ca:cd:f4:8d:79:58:b1:06:9b:e7:1a:2a:d9:\n         9d:01:d7:94:7d:ed:03:4a:ca:f0:db:e8:a9:01:3e:f5:56:99:\n         c9:1e:8e:49:3d:bb:e5:09:b9:e0:4f:49:92:3d:16:82:40:cc:\n         cc:59:c6:e6:3a:ed:12:2e:69:3c:6c:95:b1:fd:aa:1d:7b:7f:\n         86:be:1e:0e:32:46:fb:fb:13:8f:75:7f:4c:8b:4b:46:63:fe:\n         00:34:40:70:c1:c3:b9:a1:dd:a6:70:e2:04:b3:41:bc:e9:80:\n         91:ea:64:9c:7a:e1:22:03:a9:9c:6e:6f:0e:65:4f:6c:87:87:\n         5e:f3:6e:a0:f9:75:a5:9b:40:e8:53:b2:27:9d:4a:b9:c0:77:\n         21:8d:ff:87:f2:de:bc:8c:ef:17:df:b7:49:0b:d1:f2:6e:30:\n         0b:1a:0e:4e:76:ed:11:fc:f5:e9:56:b2:7d:bf:c7:6d:0a:93:\n         8c:a5:d0:c0:b6:1d:be:3a:4e:94:a2:d7:6e:6c:0b:c2:8a:7c:\n         fa:20:f3:c4:e4:e5:cd:0d:a8:cb:91:92:b1:7c:85:ec:b5:14:\n         69:66:0e:82:e7:cd:ce:c8:2d:a6:51:7f:21:c1:35:53:85:06:\n         4a:5d:9f:ad:bb:1b:5f:74\nSHA1 Fingerprint=AF:E5:D2:44:A8:D1:19:42:30:FF:47:9F:E2:F8:97:BB:CD:7A:8C:B4\n",
    "bbffca8e239f4f99cadbe268a6a51527171ed90e": "-----BEGIN CERTIFICATE-----\nMIIFWjCCA0KgAwIBAgIQbkepxlqz5yDFMJo/aFLybzANBgkqhkiG9w0BAQwFADBH\nMQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZpY2VzIExM\nQzEUMBIGA1UEAxMLR1RTIFJvb3QgUjIwHhcNMTYwNjIyMDAwMDAwWhcNMzYwNjIy\nMDAwMDAwWjBHMQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNl\ncnZpY2VzIExMQzEUMBIGA1UEAxMLR1RTIFJvb3QgUjIwggIiMA0GCSqGSIb3DQEB\nAQUAA4ICDwAwggIKAoICAQDO3v2m++zsFDQ8BwZabFn3GTXd98GdVarTzTukk3Lv\nCvptnfbwhYBboUhSnznFt+4orO/LdmgUud+tAWyZH8QiHZ/+cnfgLFuv5AS/T3Kg\nGjSY6Dlo7JUle3ah5mm5hRm9iYz+re026nO8/4Piy33B0s5Ks40FnotJk9/BW9Bu\nXvAuMC6C/Pq8tBcKSOWIm8Wba96wyrQD8Nr0kLhlZPdcTK3ofmZemde4wj7I0BOd\nre7kRXuJVfeKH2JShBKzwkCX44ofR5GmdFrS+LFjKBC4swm4VndAoiaYecb+3yXu\nPuWgf9RhD1FLPD+M2uFwdNjCaKH5wQzpoeJ/u1U8dgbuak7MkogwTZq9TwtImoS1\nmKPV+3PBV2HdKFZ1E66HjucMUQkQdYhMvI35ezzUIkgfKtzra7tEscszcTJGr61K\n8YzodDqs5xoic4DSMPclQsciOzsSrZYuxsN2B6ogtzVJV+mSSeh2FnIxZyuWfoqj\nx5RWIr9qS34BIbIjMt/kmkRtWVtd9QCgHJvGeJeNkP+byKq0rxFROV7Z+2et1VsR\nnTKaG73VululycslaVNVJ1zgyjbLiGH7HrfQy+4W+9OmTN6SpdTi3/UGVN4unUu0\nkzCqgc7dGtxRcw1PcOnlthYhGXmy5okLdWTK1au8CcEYof/UVKGFPP0UJAOyh9Ok\ntwIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNV\nHQ4EFgQUu//KjiOfT5nK2+JopqUVJxce2Q4wDQYJKoZIhvcNAQEMBQADggIBALZp\n8KZ3/p7uC4Gt4cCpx/k1HUCCq+YEtN/L9x0Pg/B+E02NjO7jMyLDOfxA325BS0JT\nvhaI8dI4XsRomRyYUpOM52jtG2pzegVATX9lO9ZY8c6DR2Dj/5epnGB3GFW1fgiT\nz9D2PGcDFWEJ+YF59exTpJ/JjwGLc8R3dtyDovUMSRqodt6Sm2T4syzFJ9MHwAiA\npJiS4wGWAqoC7o87xdFtCjMwc3i5T1QWvwsHoaRc5svJXISPD+AVdyx+Jn7axEvb\npxZ3B7DNdehyQtaVhJ2Gg/LkkM0JR9SLA3DaWsYDQvTtN6LwG1BUSw7YhN4ZKJmB\nR64JGz9I0cNv4rBgF/XuIwKl2gBbbZCr7qLpGzvpx0QnRY5rn/WkhLx3+WuXrD5R\nRaIRpsyF7gpo8j5QOHokYh4XIDdtak23CZvJ/KRY9bb7nE4Yu5UC56GtmwfuNmsk\n0jmGwZODUNKBRqhfYlcsu2xkiAhu7xNUX90txGdj08+JN7+dIPT7eoOboB6BAFDC\n5AwiWVIQ7UNWhwD4FFKnHYuTjKJNRn8nxnGbJN7k2oaLDX5rIMHAnuFl2GqjpuiF\nizoHCBy69Y9Vmhh1fuXsgWbRIXOhNUQLgD1bnF5vKheW0YMjiGZt5obicDIvUiLn\nyOd/xCxgXS/Dr55FBcOEArf9LAhST4Ldo/DUhgkC\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            6e:47:a9:c6:5a:b3:e7:20:c5:30:9a:3f:68:52:f2:6f\n        Signature Algorithm: sha384WithRSAEncryption\n        Issuer: C=US, O=Google Trust Services LLC, CN=GTS Root R2\n        Validity\n            Not Before: Jun 22 00:00:00 2016 GMT\n            Not After : Jun 22 00:00:00 2036 GMT\n        Subject: C=US, O=Google Trust Services LLC, CN=GTS Root R2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:ce:de:fd:a6:fb:ec:ec:14:34:3c:07:06:5a:6c:\n                    59:f7:19:35:dd:f7:c1:9d:55:aa:d3:cd:3b:a4:93:\n                    72:ef:0a:fa:6d:9d:f6:f0:85:80:5b:a1:48:52:9f:\n                    39:c5:b7:ee:28:ac:ef:cb:76:68:14:b9:df:ad:01:\n                    6c:99:1f:c4:22:1d:9f:fe:72:77:e0:2c:5b:af:e4:\n                    04:bf:4f:72:a0:1a:34:98:e8:39:68:ec:95:25:7b:\n                    76:a1:e6:69:b9:85:19:bd:89:8c:fe:ad:ed:36:ea:\n                    73:bc:ff:83:e2:cb:7d:c1:d2:ce:4a:b3:8d:05:9e:\n                    8b:49:93:df:c1:5b:d0:6e:5e:f0:2e:30:2e:82:fc:\n                    fa:bc:b4:17:0a:48:e5:88:9b:c5:9b:6b:de:b0:ca:\n                    b4:03:f0:da:f4:90:b8:65:64:f7:5c:4c:ad:e8:7e:\n                    66:5e:99:d7:b8:c2:3e:c8:d0:13:9d:ad:ee:e4:45:\n                    7b:89:55:f7:8a:1f:62:52:84:12:b3:c2:40:97:e3:\n                    8a:1f:47:91:a6:74:5a:d2:f8:b1:63:28:10:b8:b3:\n                    09:b8:56:77:40:a2:26:98:79:c6:fe:df:25:ee:3e:\n                    e5:a0:7f:d4:61:0f:51:4b:3c:3f:8c:da:e1:70:74:\n                    d8:c2:68:a1:f9:c1:0c:e9:a1:e2:7f:bb:55:3c:76:\n                    06:ee:6a:4e:cc:92:88:30:4d:9a:bd:4f:0b:48:9a:\n                    84:b5:98:a3:d5:fb:73:c1:57:61:dd:28:56:75:13:\n                    ae:87:8e:e7:0c:51:09:10:75:88:4c:bc:8d:f9:7b:\n                    3c:d4:22:48:1f:2a:dc:eb:6b:bb:44:b1:cb:33:71:\n                    32:46:af:ad:4a:f1:8c:e8:74:3a:ac:e7:1a:22:73:\n                    80:d2:30:f7:25:42:c7:22:3b:3b:12:ad:96:2e:c6:\n                    c3:76:07:aa:20:b7:35:49:57:e9:92:49:e8:76:16:\n                    72:31:67:2b:96:7e:8a:a3:c7:94:56:22:bf:6a:4b:\n                    7e:01:21:b2:23:32:df:e4:9a:44:6d:59:5b:5d:f5:\n                    00:a0:1c:9b:c6:78:97:8d:90:ff:9b:c8:aa:b4:af:\n                    11:51:39:5e:d9:fb:67:ad:d5:5b:11:9d:32:9a:1b:\n                    bd:d5:ba:5b:a5:c9:cb:25:69:53:55:27:5c:e0:ca:\n                    36:cb:88:61:fb:1e:b7:d0:cb:ee:16:fb:d3:a6:4c:\n                    de:92:a5:d4:e2:df:f5:06:54:de:2e:9d:4b:b4:93:\n                    30:aa:81:ce:dd:1a:dc:51:73:0d:4f:70:e9:e5:b6:\n                    16:21:19:79:b2:e6:89:0b:75:64:ca:d5:ab:bc:09:\n                    c1:18:a1:ff:d4:54:a1:85:3c:fd:14:24:03:b2:87:\n                    d3:a4:b7\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                BB:FF:CA:8E:23:9F:4F:99:CA:DB:E2:68:A6:A5:15:27:17:1E:D9:0E\n    Signature Algorithm: sha384WithRSAEncryption\n         b6:69:f0:a6:77:fe:9e:ee:0b:81:ad:e1:c0:a9:c7:f9:35:1d:\n         40:82:ab:e6:04:b4:df:cb:f7:1d:0f:83:f0:7e:13:4d:8d:8c:\n         ee:e3:33:22:c3:39:fc:40:df:6e:41:4b:42:53:be:16:88:f1:\n         d2:38:5e:c4:68:99:1c:98:52:93:8c:e7:68:ed:1b:6a:73:7a:\n         05:40:4d:7f:65:3b:d6:58:f1:ce:83:47:60:e3:ff:97:a9:9c:\n         60:77:18:55:b5:7e:08:93:cf:d0:f6:3c:67:03:15:61:09:f9:\n         81:79:f5:ec:53:a4:9f:c9:8f:01:8b:73:c4:77:76:dc:83:a2:\n         f5:0c:49:1a:a8:76:de:92:9b:64:f8:b3:2c:c5:27:d3:07:c0:\n         08:80:a4:98:92:e3:01:96:02:aa:02:ee:8f:3b:c5:d1:6d:0a:\n         33:30:73:78:b9:4f:54:16:bf:0b:07:a1:a4:5c:e6:cb:c9:5c:\n         84:8f:0f:e0:15:77:2c:7e:26:7e:da:c4:4b:db:a7:16:77:07:\n         b0:cd:75:e8:72:42:d6:95:84:9d:86:83:f2:e4:90:cd:09:47:\n         d4:8b:03:70:da:5a:c6:03:42:f4:ed:37:a2:f0:1b:50:54:4b:\n         0e:d8:84:de:19:28:99:81:47:ae:09:1b:3f:48:d1:c3:6f:e2:\n         b0:60:17:f5:ee:23:02:a5:da:00:5b:6d:90:ab:ee:a2:e9:1b:\n         3b:e9:c7:44:27:45:8e:6b:9f:f5:a4:84:bc:77:f9:6b:97:ac:\n         3e:51:45:a2:11:a6:cc:85:ee:0a:68:f2:3e:50:38:7a:24:62:\n         1e:17:20:37:6d:6a:4d:b7:09:9b:c9:fc:a4:58:f5:b6:fb:9c:\n         4e:18:bb:95:02:e7:a1:ad:9b:07:ee:36:6b:24:d2:39:86:c1:\n         93:83:50:d2:81:46:a8:5f:62:57:2c:bb:6c:64:88:08:6e:ef:\n         13:54:5f:dd:2d:c4:67:63:d3:cf:89:37:bf:9d:20:f4:fb:7a:\n         83:9b:a0:1e:81:00:50:c2:e4:0c:22:59:52:10:ed:43:56:87:\n         00:f8:14:52:a7:1d:8b:93:8c:a2:4d:46:7f:27:c6:71:9b:24:\n         de:e4:da:86:8b:0d:7e:6b:20:c1:c0:9e:e1:65:d8:6a:a3:a6:\n         e8:85:8b:3a:07:08:1c:ba:f5:8f:55:9a:18:75:7e:e5:ec:81:\n         66:d1:21:73:a1:35:44:0b:80:3d:5b:9c:5e:6f:2a:17:96:d1:\n         83:23:88:66:6d:e6:86:e2:70:32:2f:52:22:e7:c8:e7:7f:c4:\n         2c:60:5d:2f:c3:af:9e:45:05:c3:84:02:b7:fd:2c:08:52:4f:\n         82:dd:a3:f0:d4:86:09:02\nSHA1 Fingerprint=D2:73:96:2A:2A:5E:39:9F:73:3F:E1:C7:1E:64:3F:03:38:34:FC:4D\n",
    "bf5920360079a0a0226b8cd5f261d2b82ccb824a": "-----BEGIN CERTIFICATE-----\nMIIDwzCCAqugAwIBAgIBATANBgkqhkiG9w0BAQsFADCBgjELMAkGA1UEBhMCREUx\nKzApBgNVBAoMIlQtU3lzdGVtcyBFbnRlcnByaXNlIFNlcnZpY2VzIEdtYkgxHzAd\nBgNVBAsMFlQtU3lzdGVtcyBUcnVzdCBDZW50ZXIxJTAjBgNVBAMMHFQtVGVsZVNl\nYyBHbG9iYWxSb290IENsYXNzIDIwHhcNMDgxMDAxMTA0MDE0WhcNMzMxMDAxMjM1\nOTU5WjCBgjELMAkGA1UEBhMCREUxKzApBgNVBAoMIlQtU3lzdGVtcyBFbnRlcnBy\naXNlIFNlcnZpY2VzIEdtYkgxHzAdBgNVBAsMFlQtU3lzdGVtcyBUcnVzdCBDZW50\nZXIxJTAjBgNVBAMMHFQtVGVsZVNlYyBHbG9iYWxSb290IENsYXNzIDIwggEiMA0G\nCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCqX9obX+hzkeXaXPSi5kfl82hVYAUd\nAqSzm1nzHoqvNK38DcLZSBnuaY/JIPwhqgcZ7bBcrGXHX+0CfHt8LRvWurmAwhiC\nFoT6ZrAIxlQjgeTNuUk/9k9uN0goOA/FvudocP05l03Sx5iRUKrERLMjfTlH6VJi\n1hKTXrcxlkIF+3anHqP1wvzpesVsqXFP6st4vGCvx9702cu+fjOlbpSD8DT6Iavq\njnKgP6TeMFvvhk1qlVtDRKgQFRzlAVfFmPHmBiiRqiDFt1MmUUOyCxGVWOHAD3bZ\nwI18gfNycJ5v/hqO2V81xrJvNHy+SE/iWjnX2J14np+GPgNeGYtEotXHAgMBAAGj\nQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBS/\nWSA2AHmgoCJrjNXyYdK4LMuCSjANBgkqhkiG9w0BAQsFAAOCAQEAMQOiYQsfdOhy\nNsZt+U2e+iKo4YFWz827n+qrkRk4r6p8FU3ztqONpfSO9kSpp+ghla0+AGIWiPAC\nuvxhI+YzmzB6azZie60EI4RYZeLbK4rnJVM3YlNfvNoBYimipidx5joifsFvHZVw\nIEoHNN/q/xWA5brXethbdXwFeilHfkCoMRN3zUA7tFFHei4R40cR3p1m0IvVVGb6\ng1XqfMIpiRvpb7PO4gWEyS8+eIVibslfwXhjdFjASBgMmTnrpMwatXlajRWc2BQN\n9noHV8cigwUtPJslJj0Ys6lDfMjIq2SPDqO/nBudMNva0Bkuqjzx+zOAduTNrRlP\nBSeOE6Fuwg==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 1 (0x1)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=DE, O=T-Systems Enterprise Services GmbH, OU=T-Systems Trust Center, CN=T-TeleSec GlobalRoot Class 2\n        Validity\n            Not Before: Oct  1 10:40:14 2008 GMT\n            Not After : Oct  1 23:59:59 2033 GMT\n        Subject: C=DE, O=T-Systems Enterprise Services GmbH, OU=T-Systems Trust Center, CN=T-TeleSec GlobalRoot Class 2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:aa:5f:da:1b:5f:e8:73:91:e5:da:5c:f4:a2:e6:\n                    47:e5:f3:68:55:60:05:1d:02:a4:b3:9b:59:f3:1e:\n                    8a:af:34:ad:fc:0d:c2:d9:48:19:ee:69:8f:c9:20:\n                    fc:21:aa:07:19:ed:b0:5c:ac:65:c7:5f:ed:02:7c:\n                    7b:7c:2d:1b:d6:ba:b9:80:c2:18:82:16:84:fa:66:\n                    b0:08:c6:54:23:81:e4:cd:b9:49:3f:f6:4f:6e:37:\n                    48:28:38:0f:c5:be:e7:68:70:fd:39:97:4d:d2:c7:\n                    98:91:50:aa:c4:44:b3:23:7d:39:47:e9:52:62:d6:\n                    12:93:5e:b7:31:96:42:05:fb:76:a7:1e:a3:f5:c2:\n                    fc:e9:7a:c5:6c:a9:71:4f:ea:cb:78:bc:60:af:c7:\n                    de:f4:d9:cb:be:7e:33:a5:6e:94:83:f0:34:fa:21:\n                    ab:ea:8e:72:a0:3f:a4:de:30:5b:ef:86:4d:6a:95:\n                    5b:43:44:a8:10:15:1c:e5:01:57:c5:98:f1:e6:06:\n                    28:91:aa:20:c5:b7:53:26:51:43:b2:0b:11:95:58:\n                    e1:c0:0f:76:d9:c0:8d:7c:81:f3:72:70:9e:6f:fe:\n                    1a:8e:d9:5f:35:c6:b2:6f:34:7c:be:48:4f:e2:5a:\n                    39:d7:d8:9d:78:9e:9f:86:3e:03:5e:19:8b:44:a2:\n                    d5:c7\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                BF:59:20:36:00:79:A0:A0:22:6B:8C:D5:F2:61:D2:B8:2C:CB:82:4A\n    Signature Algorithm: sha256WithRSAEncryption\n         31:03:a2:61:0b:1f:74:e8:72:36:c6:6d:f9:4d:9e:fa:22:a8:\n         e1:81:56:cf:cd:bb:9f:ea:ab:91:19:38:af:aa:7c:15:4d:f3:\n         b6:a3:8d:a5:f4:8e:f6:44:a9:a7:e8:21:95:ad:3e:00:62:16:\n         88:f0:02:ba:fc:61:23:e6:33:9b:30:7a:6b:36:62:7b:ad:04:\n         23:84:58:65:e2:db:2b:8a:e7:25:53:37:62:53:5f:bc:da:01:\n         62:29:a2:a6:27:71:e6:3a:22:7e:c1:6f:1d:95:70:20:4a:07:\n         34:df:ea:ff:15:80:e5:ba:d7:7a:d8:5b:75:7c:05:7a:29:47:\n         7e:40:a8:31:13:77:cd:40:3b:b4:51:47:7a:2e:11:e3:47:11:\n         de:9d:66:d0:8b:d5:54:66:fa:83:55:ea:7c:c2:29:89:1b:e9:\n         6f:b3:ce:e2:05:84:c9:2f:3e:78:85:62:6e:c9:5f:c1:78:63:\n         74:58:c0:48:18:0c:99:39:eb:a4:cc:1a:b5:79:5a:8d:15:9c:\n         d8:14:0d:f6:7a:07:57:c7:22:83:05:2d:3c:9b:25:26:3d:18:\n         b3:a9:43:7c:c8:c8:ab:64:8f:0e:a3:bf:9c:1b:9d:30:db:da:\n         d0:19:2e:aa:3c:f1:fb:33:80:76:e4:cd:ad:19:4f:05:27:8e:\n         13:a1:6e:c2\nSHA1 Fingerprint=59:0D:2D:7D:88:4F:40:2E:61:7E:A5:62:32:17:65:CF:17:D8:94:E9\n",
    "bf5fb7d1cedd1f86f45b55acdcd710c20ea988e7": "-----BEGIN CERTIFICATE-----\nMIIEDzCCAvegAwIBAgIBADANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQGEwJVUzEl\nMCMGA1UEChMcU3RhcmZpZWxkIFRlY2hub2xvZ2llcywgSW5jLjEyMDAGA1UECxMp\nU3RhcmZpZWxkIENsYXNzIDIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMDQw\nNjI5MTczOTE2WhcNMzQwNjI5MTczOTE2WjBoMQswCQYDVQQGEwJVUzElMCMGA1UE\nChMcU3RhcmZpZWxkIFRlY2hub2xvZ2llcywgSW5jLjEyMDAGA1UECxMpU3RhcmZp\nZWxkIENsYXNzIDIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwggEgMA0GCSqGSIb3\nDQEBAQUAA4IBDQAwggEIAoIBAQC3Msj+6XGmBIWtDBFk385N78gDGIc/oav7PKaf\n8MOh2tTYbitTkPskpD6E8J7oX+zlJ0T1KKY/e97gKvDIr1MvnsoFAZMej2YcOadN\n+lq2cwQlZut3f+dZxkqZJRRU6ybH838Z1TBwj6+wRir/resp7defqgSHo9T5iaU0\nX9tDkYI22WY8sbi5gv2cOj4QyDvvBmVmepsZGD3/cVE8MC5fvj13c7JdBmzDI1aa\nK4UmkhynArPkPw2vCHmCuDY96pzTNbO8acr1zJ3o/WSNF4Azbl5KXZnJHoe0nRrA\n1W4TNSNe35tfPe/W93bC6j67eA0cQmdrBNj41tpvi/JEoAGrAgEDo4HFMIHCMB0G\nA1UdDgQWBBS/X7fRzt0fhvRbVazc1xDCDqmI5zCBkgYDVR0jBIGKMIGHgBS/X7fR\nzt0fhvRbVazc1xDCDqmI56FspGowaDELMAkGA1UEBhMCVVMxJTAjBgNVBAoTHFN0\nYXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xMjAwBgNVBAsTKVN0YXJmaWVsZCBD\nbGFzcyAyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMAwGA1UdEwQFMAMBAf8w\nDQYJKoZIhvcNAQEFBQADggEBAAWdP4id0ckaVaGsafPzWdqbAYcaT1epoXkJKtv3\nL7IezMdeatiDh6GX70k1PncGQVhiv45YuApnP+yz3SFmH8lU+nLMPUxA2IGvd56D\neruix/U0F47ZEUD0/CwqTRV/p2JdLiXTAAsgGh1o+Re49L2L7ShZ3U0WixeDyLJl\nxy16paq8U4Zt3VekyvggQQto8PT7dL5WXXp59fkdheMtlb71cZBDzI0fmgAKhynp\nVSJYACPq4xJDKVtHCN2MQWplBqjlIapBtJUhlbl90TSrE9atvNziPTnNvT51cKEY\nWQPJIrSPnNVeKtelttQKbfi3QBFGmh95DmK/D5fs4C8fF5Q=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 0 (0x0)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=US, O=Starfield Technologies, Inc., OU=Starfield Class 2 Certification Authority\n        Validity\n            Not Before: Jun 29 17:39:16 2004 GMT\n            Not After : Jun 29 17:39:16 2034 GMT\n        Subject: C=US, O=Starfield Technologies, Inc., OU=Starfield Class 2 Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:b7:32:c8:fe:e9:71:a6:04:85:ad:0c:11:64:df:\n                    ce:4d:ef:c8:03:18:87:3f:a1:ab:fb:3c:a6:9f:f0:\n                    c3:a1:da:d4:d8:6e:2b:53:90:fb:24:a4:3e:84:f0:\n                    9e:e8:5f:ec:e5:27:44:f5:28:a6:3f:7b:de:e0:2a:\n                    f0:c8:af:53:2f:9e:ca:05:01:93:1e:8f:66:1c:39:\n                    a7:4d:fa:5a:b6:73:04:25:66:eb:77:7f:e7:59:c6:\n                    4a:99:25:14:54:eb:26:c7:f3:7f:19:d5:30:70:8f:\n                    af:b0:46:2a:ff:ad:eb:29:ed:d7:9f:aa:04:87:a3:\n                    d4:f9:89:a5:34:5f:db:43:91:82:36:d9:66:3c:b1:\n                    b8:b9:82:fd:9c:3a:3e:10:c8:3b:ef:06:65:66:7a:\n                    9b:19:18:3d:ff:71:51:3c:30:2e:5f:be:3d:77:73:\n                    b2:5d:06:6c:c3:23:56:9a:2b:85:26:92:1c:a7:02:\n                    b3:e4:3f:0d:af:08:79:82:b8:36:3d:ea:9c:d3:35:\n                    b3:bc:69:ca:f5:cc:9d:e8:fd:64:8d:17:80:33:6e:\n                    5e:4a:5d:99:c9:1e:87:b4:9d:1a:c0:d5:6e:13:35:\n                    23:5e:df:9b:5f:3d:ef:d6:f7:76:c2:ea:3e:bb:78:\n                    0d:1c:42:67:6b:04:d8:f8:d6:da:6f:8b:f2:44:a0:\n                    01:ab\n                Exponent: 3 (0x3)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                BF:5F:B7:D1:CE:DD:1F:86:F4:5B:55:AC:DC:D7:10:C2:0E:A9:88:E7\n            X509v3 Authority Key Identifier: \n                keyid:BF:5F:B7:D1:CE:DD:1F:86:F4:5B:55:AC:DC:D7:10:C2:0E:A9:88:E7\n                DirName:/C=US/O=Starfield Technologies, Inc./OU=Starfield Class 2 Certification Authority\n                serial:00\n\n            X509v3 Basic Constraints: \n                CA:TRUE\n    Signature Algorithm: sha1WithRSAEncryption\n         05:9d:3f:88:9d:d1:c9:1a:55:a1:ac:69:f3:f3:59:da:9b:01:\n         87:1a:4f:57:a9:a1:79:09:2a:db:f7:2f:b2:1e:cc:c7:5e:6a:\n         d8:83:87:a1:97:ef:49:35:3e:77:06:41:58:62:bf:8e:58:b8:\n         0a:67:3f:ec:b3:dd:21:66:1f:c9:54:fa:72:cc:3d:4c:40:d8:\n         81:af:77:9e:83:7a:bb:a2:c7:f5:34:17:8e:d9:11:40:f4:fc:\n         2c:2a:4d:15:7f:a7:62:5d:2e:25:d3:00:0b:20:1a:1d:68:f9:\n         17:b8:f4:bd:8b:ed:28:59:dd:4d:16:8b:17:83:c8:b2:65:c7:\n         2d:7a:a5:aa:bc:53:86:6d:dd:57:a4:ca:f8:20:41:0b:68:f0:\n         f4:fb:74:be:56:5d:7a:79:f5:f9:1d:85:e3:2d:95:be:f5:71:\n         90:43:cc:8d:1f:9a:00:0a:87:29:e9:55:22:58:00:23:ea:e3:\n         12:43:29:5b:47:08:dd:8c:41:6a:65:06:a8:e5:21:aa:41:b4:\n         95:21:95:b9:7d:d1:34:ab:13:d6:ad:bc:dc:e2:3d:39:cd:bd:\n         3e:75:70:a1:18:59:03:c9:22:b4:8f:9c:d5:5e:2a:d7:a5:b6:\n         d4:0a:6d:f8:b7:40:11:46:9a:1f:79:0e:62:bf:0f:97:ec:e0:\n         2f:1f:17:94\nSHA1 Fingerprint=AD:7E:1C:28:B0:64:EF:8F:60:03:40:20:14:C3:D0:E3:37:0E:B5:8A\n",
    "c1f126baa02dae8581cfd3f12a12bdb80a67fdbc": "-----BEGIN CERTIFICATE-----\nMIICDDCCAZGgAwIBAgIQbkepx2ypcyRAiQ8DVd2NHTAKBggqhkjOPQQDAzBHMQsw\nCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZpY2VzIExMQzEU\nMBIGA1UEAxMLR1RTIFJvb3QgUjMwHhcNMTYwNjIyMDAwMDAwWhcNMzYwNjIyMDAw\nMDAwWjBHMQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZp\nY2VzIExMQzEUMBIGA1UEAxMLR1RTIFJvb3QgUjMwdjAQBgcqhkjOPQIBBgUrgQQA\nIgNiAAQfTzOHMymKoYTey8chWEGJ6ladK0uFxh1MJ7x/JlFyb+Kf1qPKzEUURout\n736GjOyxfi//qXGdGIRFBEFVbivqJn+7kAHjSxm65FSWRQmx1WyRRK2EE46ajA2A\nDDL24CejQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1Ud\nDgQWBBTB8Sa6oC2uhYHP0/EqEr24Cmf9vDAKBggqhkjOPQQDAwNpADBmAjEAgFuk\nfCPAlaUs3L6JbyO5o91lAFJekazInXJ0glMLfalAvWhgxeG4VDvBNhcl2MG9AjEA\nnjWSdIUlUfUk7GRSJFClH9voy8l27OyCbvWFGFPouOOaKaqW04MjyaR7YbPMAuhd\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            6e:47:a9:c7:6c:a9:73:24:40:89:0f:03:55:dd:8d:1d\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, O=Google Trust Services LLC, CN=GTS Root R3\n        Validity\n            Not Before: Jun 22 00:00:00 2016 GMT\n            Not After : Jun 22 00:00:00 2036 GMT\n        Subject: C=US, O=Google Trust Services LLC, CN=GTS Root R3\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:1f:4f:33:87:33:29:8a:a1:84:de:cb:c7:21:58:\n                    41:89:ea:56:9d:2b:4b:85:c6:1d:4c:27:bc:7f:26:\n                    51:72:6f:e2:9f:d6:a3:ca:cc:45:14:46:8b:ad:ef:\n                    7e:86:8c:ec:b1:7e:2f:ff:a9:71:9d:18:84:45:04:\n                    41:55:6e:2b:ea:26:7f:bb:90:01:e3:4b:19:ba:e4:\n                    54:96:45:09:b1:d5:6c:91:44:ad:84:13:8e:9a:8c:\n                    0d:80:0c:32:f6:e0:27\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                C1:F1:26:BA:A0:2D:AE:85:81:CF:D3:F1:2A:12:BD:B8:0A:67:FD:BC\n    Signature Algorithm: ecdsa-with-SHA384\n         30:66:02:31:00:80:5b:a4:7c:23:c0:95:a5:2c:dc:be:89:6f:\n         23:b9:a3:dd:65:00:52:5e:91:ac:c8:9d:72:74:82:53:0b:7d:\n         a9:40:bd:68:60:c5:e1:b8:54:3b:c1:36:17:25:d8:c1:bd:02:\n         31:00:9e:35:92:74:85:25:51:f5:24:ec:64:52:24:50:a5:1f:\n         db:e8:cb:c9:76:ec:ec:82:6e:f5:85:18:53:e8:b8:e3:9a:29:\n         aa:96:d3:83:23:c9:a4:7b:61:b3:cc:02:e8:5d\nSHA1 Fingerprint=30:D4:24:6F:07:FF:DB:91:89:8A:0B:E9:49:66:11:EB:8C:5E:46:E5\n",
    "c4a7b1a47b2c71fadbe14b9075ffc41560858910": "-----BEGIN CERTIFICATE-----\nMIIDSjCCAjKgAwIBAgIQRK+wgNajJ7qJMDmGLvhAazANBgkqhkiG9w0BAQUFADA/\nMSQwIgYDVQQKExtEaWdpdGFsIFNpZ25hdHVyZSBUcnVzdCBDby4xFzAVBgNVBAMT\nDkRTVCBSb290IENBIFgzMB4XDTAwMDkzMDIxMTIxOVoXDTIxMDkzMDE0MDExNVow\nPzEkMCIGA1UEChMbRGlnaXRhbCBTaWduYXR1cmUgVHJ1c3QgQ28uMRcwFQYDVQQD\nEw5EU1QgUm9vdCBDQSBYMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB\nAN+v6ZdQCINXtMxiZfaQguzH0yxrMMpb7NnDfcdAwRgUi+DoM3ZJKuM/IUmTrE4O\nrz5Iy2Xu/NMhD2XSKtkyj4zl93ewEnu1lcCJo6m67XMuegwGMoOifooUMM0RoOEq\nOLl5CjH9UL2AZd+3UWODyOKIYepLYYHsUmu5ouJLGiifSKOeDNoJjj4XLh7dIN9b\nxiqKqy69cK3FCxolkHRyxXtqqzTWMIn/5WgTe1QLyNau7Fqckh49ZLOMxt+/yUFw\n7BZy1SbsOFU5Q9D8/RhcQPGX69Wam40dutolucbY38EVAjqr2m7xPi71XAicPNaD\naeQQmxkqtilX4+U9m5/wAl0CAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNV\nHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFMSnsaR7LHH62+FLkHX/xBVghYkQMA0GCSqG\nSIb3DQEBBQUAA4IBAQCjGiybFwBcqR7uKGY3Or+Dxz9LwwmglSBd49lZRNI+DT69\nikugdB/OEIKcdBodfpga3csTS7MgROSR6cz8faXbauX+5v3gTt23ADq1cEmv8uXr\nAvHRAosZy5Q6XkjEGB5YGV8eAlrwDPGxrancWYaLbumR9YbK+rlmM6pZW87ipxZz\nR8srzJmwN0jP41ZL9c8PDHIyh8bwRLtTcm1D9SZImlJnt1ir/md2cXjbDaJWFBM5\nJDGFoqgCWjBH4d1QB7wCCZAA62RjYJsWvIjJEubSfZGL+T0yjWW06XyxV3bqxbYo\nOb8VZRzI9neWagqNdwvYkQsEjgfbKbYK7p2CNTUQ\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            44:af:b0:80:d6:a3:27:ba:89:30:39:86:2e:f8:40:6b\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: O=Digital Signature Trust Co., CN=DST Root CA X3\n        Validity\n            Not Before: Sep 30 21:12:19 2000 GMT\n            Not After : Sep 30 14:01:15 2021 GMT\n        Subject: O=Digital Signature Trust Co., CN=DST Root CA X3\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:df:af:e9:97:50:08:83:57:b4:cc:62:65:f6:90:\n                    82:ec:c7:d3:2c:6b:30:ca:5b:ec:d9:c3:7d:c7:40:\n                    c1:18:14:8b:e0:e8:33:76:49:2a:e3:3f:21:49:93:\n                    ac:4e:0e:af:3e:48:cb:65:ee:fc:d3:21:0f:65:d2:\n                    2a:d9:32:8f:8c:e5:f7:77:b0:12:7b:b5:95:c0:89:\n                    a3:a9:ba:ed:73:2e:7a:0c:06:32:83:a2:7e:8a:14:\n                    30:cd:11:a0:e1:2a:38:b9:79:0a:31:fd:50:bd:80:\n                    65:df:b7:51:63:83:c8:e2:88:61:ea:4b:61:81:ec:\n                    52:6b:b9:a2:e2:4b:1a:28:9f:48:a3:9e:0c:da:09:\n                    8e:3e:17:2e:1e:dd:20:df:5b:c6:2a:8a:ab:2e:bd:\n                    70:ad:c5:0b:1a:25:90:74:72:c5:7b:6a:ab:34:d6:\n                    30:89:ff:e5:68:13:7b:54:0b:c8:d6:ae:ec:5a:9c:\n                    92:1e:3d:64:b3:8c:c6:df:bf:c9:41:70:ec:16:72:\n                    d5:26:ec:38:55:39:43:d0:fc:fd:18:5c:40:f1:97:\n                    eb:d5:9a:9b:8d:1d:ba:da:25:b9:c6:d8:df:c1:15:\n                    02:3a:ab:da:6e:f1:3e:2e:f5:5c:08:9c:3c:d6:83:\n                    69:e4:10:9b:19:2a:b6:29:57:e3:e5:3d:9b:9f:f0:\n                    02:5d\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                C4:A7:B1:A4:7B:2C:71:FA:DB:E1:4B:90:75:FF:C4:15:60:85:89:10\n    Signature Algorithm: sha1WithRSAEncryption\n         a3:1a:2c:9b:17:00:5c:a9:1e:ee:28:66:37:3a:bf:83:c7:3f:\n         4b:c3:09:a0:95:20:5d:e3:d9:59:44:d2:3e:0d:3e:bd:8a:4b:\n         a0:74:1f:ce:10:82:9c:74:1a:1d:7e:98:1a:dd:cb:13:4b:b3:\n         20:44:e4:91:e9:cc:fc:7d:a5:db:6a:e5:fe:e6:fd:e0:4e:dd:\n         b7:00:3a:b5:70:49:af:f2:e5:eb:02:f1:d1:02:8b:19:cb:94:\n         3a:5e:48:c4:18:1e:58:19:5f:1e:02:5a:f0:0c:f1:b1:ad:a9:\n         dc:59:86:8b:6e:e9:91:f5:86:ca:fa:b9:66:33:aa:59:5b:ce:\n         e2:a7:16:73:47:cb:2b:cc:99:b0:37:48:cf:e3:56:4b:f5:cf:\n         0f:0c:72:32:87:c6:f0:44:bb:53:72:6d:43:f5:26:48:9a:52:\n         67:b7:58:ab:fe:67:76:71:78:db:0d:a2:56:14:13:39:24:31:\n         85:a2:a8:02:5a:30:47:e1:dd:50:07:bc:02:09:90:00:eb:64:\n         63:60:9b:16:bc:88:c9:12:e6:d2:7d:91:8b:f9:3d:32:8d:65:\n         b4:e9:7c:b1:57:76:ea:c5:b6:28:39:bf:15:65:1c:c8:f6:77:\n         96:6a:0a:8d:77:0b:d8:91:0b:04:8e:07:db:29:b6:0a:ee:9d:\n         82:35:35:10\nSHA1 Fingerprint=DA:C9:02:4F:54:D8:F6:DF:94:93:5F:B1:73:26:38:CA:6A:D7:7C:13\n",
    "c617d0bca8ea0243f21b06995d2b9020b9d79ce4": "-----BEGIN CERTIFICATE-----\nMIIFYDCCA0igAwIBAgIULvWbAiin23r/1aOp7r0DoM8Sah0wDQYJKoZIhvcNAQEL\nBQAwSDELMAkGA1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxHjAc\nBgNVBAMTFVF1b1ZhZGlzIFJvb3QgQ0EgMyBHMzAeFw0xMjAxMTIyMDI2MzJaFw00\nMjAxMTIyMDI2MzJaMEgxCzAJBgNVBAYTAkJNMRkwFwYDVQQKExBRdW9WYWRpcyBM\naW1pdGVkMR4wHAYDVQQDExVRdW9WYWRpcyBSb290IENBIDMgRzMwggIiMA0GCSqG\nSIb3DQEBAQUAA4ICDwAwggIKAoICAQCzyw4QZ47qFJenMioKVjZ/aEzHs286IxSR\n/xl/pcqs7rN2nXrpixurazHb+gtTTK/FpRp5PIpM/6zfJd5O2YIyC0TeytuMrKNu\nFoM7pmRLMon7FhY4futD4tN0SsJiCnMK3UmzV9KwCoWdcTzeo8vAMvMBOSBDGzXR\nU7Ox7sWTaYI+FrUoRqHe6okJ7UO4BUaKhvVZR74bbwEhELn9qdIoyhA5CcoTNs+c\nra1AdHkrAj80//ogaX3T7mH1urPnMNA3I4ZyYUUpSFlob3emLoG+B01vr87ERROR\nFHAGjx+f+IdpsQ7vw4kZ6+ocYfx6bIrc1gMLnia6Et3UVDmrJqMz6nWB2i3ND0/k\nA9HvFZcba5DFApCTZgIhsUfei5pKgLlVj7WiL8DWM2fafsSntARE60f75li59wzw\neyuxwHApw0BiLTtIadwjPEjrewl5qW3aqDCYz4ByA4imW0aucnl8CAMhZa634Ryl\nsSqiMd5mBPfAdOhx3v89WcyWJhKLhZVXGqtrdQtEPREoPHtht+KPZ0/l7DxMYIBp\nVzgeAVuNVejH38DMdyM0SXV89pgR6y3e7UEuFAUCf+D+IOs15xGsIs5XPd7JMG0Q\nA4XN8f+MFrXBsj6IbGB/kE+V9/YtrQE5BwT6dYB9v0lQ7e/JxHwc64B+27bQ3RP+\nydOc17KXqQIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIB\nBjAdBgNVHQ4EFgQUxhfQvKjqAkPyGwaZXSuQILnXnOQwDQYJKoZIhvcNAQELBQAD\nggIBADRh2Va1EodVTd2jNTFGu6QHcrxfYWLopfsLN7E8trP6KZ1/AvWkyaiTt3px\nKGmPc+FSkNrVvjrlt3ZqVoAh313m6Tqe5T72omnHKgqwGEfcIHB9UqM+WXzBusnI\nFUBhynLWcKzSt/Ac5IYp8M7vaGPQtSCKFWGafoaYtMnCdvvMujAWzKNhxnQT5Wvv\noxXqA/4Ti2Tk08HS6IT7SdEQTXlm66r99I0xHnAUrdzeZxNMgRVhvLfZkXdxGYFg\nu/BYpbWcC/ePIlUnwEsBbTuZDdQdm2NnL9DuDcpmvJRPpq3t/O5jrFc/ZSXPsoaP\n0Aj/uHYUbt7lJ+yreLVTubY/6CD50qi+YUbKh4yE8/nxoGibIh6BJpsQBJFxwAYf\n3KDTuVan45gtf4Od34wrnDKOMpTwATwiKp9Dwi7DmDkHOHv8XgBCH/MyJnmDhPbl\n8MFREsALHgQjDFSlTC9JxUrRtm5gDWv8a4uFJGS3iQ6rJUdbPM9+Sb3H6QrG2vd+\nDhcI00iX0HGS8A85PjRqHH3Y8iKuu2n0M7SmSFXRDw4m6Oy2Cy2nhTXN/VnIn9HN\nPlopNLk9hM6xZdRZkZFWdSHBd575euFgndOtBBj0fOtek49TSiIp+EgrPk2GrFt/\nywaZWWDYWGWVjUTR939+J399roD1B0y2PpxxVJkES/1Y+Zj0\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            2e:f5:9b:02:28:a7:db:7a:ff:d5:a3:a9:ee:bd:03:a0:cf:12:6a:1d\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 3 G3\n        Validity\n            Not Before: Jan 12 20:26:32 2012 GMT\n            Not After : Jan 12 20:26:32 2042 GMT\n        Subject: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 3 G3\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:b3:cb:0e:10:67:8e:ea:14:97:a7:32:2a:0a:56:\n                    36:7f:68:4c:c7:b3:6f:3a:23:14:91:ff:19:7f:a5:\n                    ca:ac:ee:b3:76:9d:7a:e9:8b:1b:ab:6b:31:db:fa:\n                    0b:53:4c:af:c5:a5:1a:79:3c:8a:4c:ff:ac:df:25:\n                    de:4e:d9:82:32:0b:44:de:ca:db:8c:ac:a3:6e:16:\n                    83:3b:a6:64:4b:32:89:fb:16:16:38:7e:eb:43:e2:\n                    d3:74:4a:c2:62:0a:73:0a:dd:49:b3:57:d2:b0:0a:\n                    85:9d:71:3c:de:a3:cb:c0:32:f3:01:39:20:43:1b:\n                    35:d1:53:b3:b1:ee:c5:93:69:82:3e:16:b5:28:46:\n                    a1:de:ea:89:09:ed:43:b8:05:46:8a:86:f5:59:47:\n                    be:1b:6f:01:21:10:b9:fd:a9:d2:28:ca:10:39:09:\n                    ca:13:36:cf:9c:ad:ad:40:74:79:2b:02:3f:34:ff:\n                    fa:20:69:7d:d3:ee:61:f5:ba:b3:e7:30:d0:37:23:\n                    86:72:61:45:29:48:59:68:6f:77:a6:2e:81:be:07:\n                    4d:6f:af:ce:c4:45:13:91:14:70:06:8f:1f:9f:f8:\n                    87:69:b1:0e:ef:c3:89:19:eb:ea:1c:61:fc:7a:6c:\n                    8a:dc:d6:03:0b:9e:26:ba:12:dd:d4:54:39:ab:26:\n                    a3:33:ea:75:81:da:2d:cd:0f:4f:e4:03:d1:ef:15:\n                    97:1b:6b:90:c5:02:90:93:66:02:21:b1:47:de:8b:\n                    9a:4a:80:b9:55:8f:b5:a2:2f:c0:d6:33:67:da:7e:\n                    c4:a7:b4:04:44:eb:47:fb:e6:58:b9:f7:0c:f0:7b:\n                    2b:b1:c0:70:29:c3:40:62:2d:3b:48:69:dc:23:3c:\n                    48:eb:7b:09:79:a9:6d:da:a8:30:98:cf:80:72:03:\n                    88:a6:5b:46:ae:72:79:7c:08:03:21:65:ae:b7:e1:\n                    1c:a5:b1:2a:a2:31:de:66:04:f7:c0:74:e8:71:de:\n                    ff:3d:59:cc:96:26:12:8b:85:95:57:1a:ab:6b:75:\n                    0b:44:3d:11:28:3c:7b:61:b7:e2:8f:67:4f:e5:ec:\n                    3c:4c:60:80:69:57:38:1e:01:5b:8d:55:e8:c7:df:\n                    c0:cc:77:23:34:49:75:7c:f6:98:11:eb:2d:de:ed:\n                    41:2e:14:05:02:7f:e0:fe:20:eb:35:e7:11:ac:22:\n                    ce:57:3d:de:c9:30:6d:10:03:85:cd:f1:ff:8c:16:\n                    b5:c1:b2:3e:88:6c:60:7f:90:4f:95:f7:f6:2d:ad:\n                    01:39:07:04:fa:75:80:7d:bf:49:50:ed:ef:c9:c4:\n                    7c:1c:eb:80:7e:db:b6:d0:dd:13:fe:c9:d3:9c:d7:\n                    b2:97:a9\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                C6:17:D0:BC:A8:EA:02:43:F2:1B:06:99:5D:2B:90:20:B9:D7:9C:E4\n    Signature Algorithm: sha256WithRSAEncryption\n         34:61:d9:56:b5:12:87:55:4d:dd:a3:35:31:46:bb:a4:07:72:\n         bc:5f:61:62:e8:a5:fb:0b:37:b1:3c:b6:b3:fa:29:9d:7f:02:\n         f5:a4:c9:a8:93:b7:7a:71:28:69:8f:73:e1:52:90:da:d5:be:\n         3a:e5:b7:76:6a:56:80:21:df:5d:e6:e9:3a:9e:e5:3e:f6:a2:\n         69:c7:2a:0a:b0:18:47:dc:20:70:7d:52:a3:3e:59:7c:c1:ba:\n         c9:c8:15:40:61:ca:72:d6:70:ac:d2:b7:f0:1c:e4:86:29:f0:\n         ce:ef:68:63:d0:b5:20:8a:15:61:9a:7e:86:98:b4:c9:c2:76:\n         fb:cc:ba:30:16:cc:a3:61:c6:74:13:e5:6b:ef:a3:15:ea:03:\n         fe:13:8b:64:e4:d3:c1:d2:e8:84:fb:49:d1:10:4d:79:66:eb:\n         aa:fd:f4:8d:31:1e:70:14:ad:dc:de:67:13:4c:81:15:61:bc:\n         b7:d9:91:77:71:19:81:60:bb:f0:58:a5:b5:9c:0b:f7:8f:22:\n         55:27:c0:4b:01:6d:3b:99:0d:d4:1d:9b:63:67:2f:d0:ee:0d:\n         ca:66:bc:94:4f:a6:ad:ed:fc:ee:63:ac:57:3f:65:25:cf:b2:\n         86:8f:d0:08:ff:b8:76:14:6e:de:e5:27:ec:ab:78:b5:53:b9:\n         b6:3f:e8:20:f9:d2:a8:be:61:46:ca:87:8c:84:f3:f9:f1:a0:\n         68:9b:22:1e:81:26:9b:10:04:91:71:c0:06:1f:dc:a0:d3:b9:\n         56:a7:e3:98:2d:7f:83:9d:df:8c:2b:9c:32:8e:32:94:f0:01:\n         3c:22:2a:9f:43:c2:2e:c3:98:39:07:38:7b:fc:5e:00:42:1f:\n         f3:32:26:79:83:84:f6:e5:f0:c1:51:12:c0:0b:1e:04:23:0c:\n         54:a5:4c:2f:49:c5:4a:d1:b6:6e:60:0d:6b:fc:6b:8b:85:24:\n         64:b7:89:0e:ab:25:47:5b:3c:cf:7e:49:bd:c7:e9:0a:c6:da:\n         f7:7e:0e:17:08:d3:48:97:d0:71:92:f0:0f:39:3e:34:6a:1c:\n         7d:d8:f2:22:ae:bb:69:f4:33:b4:a6:48:55:d1:0f:0e:26:e8:\n         ec:b6:0b:2d:a7:85:35:cd:fd:59:c8:9f:d1:cd:3e:5a:29:34:\n         b9:3d:84:ce:b1:65:d4:59:91:91:56:75:21:c1:77:9e:f9:7a:\n         e1:60:9d:d3:ad:04:18:f4:7c:eb:5e:93:8f:53:4a:22:29:f8:\n         48:2b:3e:4d:86:ac:5b:7f:cb:06:99:59:60:d8:58:65:95:8d:\n         44:d1:f7:7f:7e:27:7f:7d:ae:80:f5:07:4c:b6:3e:9c:71:54:\n         99:04:4b:fd:58:f9:98:f4\nSHA1 Fingerprint=48:12:BD:92:3C:A8:C4:39:06:E7:30:6D:27:96:E6:A4:CF:22:2E:7D\n",
    "c64fa23d066384099cce62e404ac8d5cb5e9b61b": "-----BEGIN CERTIFICATE-----\nMIIEMDCCAxigAwIBAgIQUJRs7Bjq1ZxN1ZfvdY+grTANBgkqhkiG9w0BAQUFADCB\ngjELMAkGA1UEBhMCVVMxHjAcBgNVBAsTFXd3dy54cmFtcHNlY3VyaXR5LmNvbTEk\nMCIGA1UEChMbWFJhbXAgU2VjdXJpdHkgU2VydmljZXMgSW5jMS0wKwYDVQQDEyRY\nUmFtcCBHbG9iYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMDQxMTAxMTcx\nNDA0WhcNMzUwMTAxMDUzNzE5WjCBgjELMAkGA1UEBhMCVVMxHjAcBgNVBAsTFXd3\ndy54cmFtcHNlY3VyaXR5LmNvbTEkMCIGA1UEChMbWFJhbXAgU2VjdXJpdHkgU2Vy\ndmljZXMgSW5jMS0wKwYDVQQDEyRYUmFtcCBHbG9iYWwgQ2VydGlmaWNhdGlvbiBB\ndXRob3JpdHkwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCYJB69FbS6\n38eMpSe2OAtp87ZOqCwuIR1cRN8hXX4jdP5efrRKt6atH67gBhbim1vZZ3RrXYCP\nKZ2GG9mcDZhtdhAoWORlsH9KmHmf4MMxfoArtYzAQDsRhtDLooY2YKTVMIJt2W7Q\nDxIEM5dfT2Fa8OT5kavnHTu86M/0ay00fOJIYRyO82FEzG+gSqmUsE3a56k0enI4\nqEHMPJQRfevIpoy3hsvKMzvZPTeL+3o+hiznc9cKV6xkmxnr9A8ECIqsAxcZZPRa\nJSKNNCyy9mgdEm3Tih4U2sSPpuIjhdV6Db1q4Ons7Be7QhtnqiXtRYMh/MHJfNVi\nPvryxS3T/dRlAgMBAAGjgZ8wgZwwEwYJKwYBBAGCNxQCBAYeBABDAEEwCwYDVR0P\nBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFMZPoj0GY4QJnM5i5ASs\njVy16bYbMDYGA1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9jcmwueHJhbXBzZWN1cml0\neS5jb20vWEdDQS5jcmwwEAYJKwYBBAGCNxUBBAMCAQEwDQYJKoZIhvcNAQEFBQAD\nggEBAJEVOQMBG2f7Shz5CmBbodpNl2L5JFMn14JkTpAuw0kbK5rc/Kh4ZzXxHfAR\nvbdI4xD2Dd8/0sm2qlWkSLoC295ZLhVbO50WfUfXN+pfTXYSNrsf16GBBEYgoyxt\nqZ4Bfj8pzgCT3/3JknOJiWSe5yvkHJEs0rnOfc5vMZnT5r7SHpDwCRR5XCOrTdLa\nIR9NmXmd4c8nnxCbHIgNsIpkQTG4DmyQJKSbXHGPurt+HBvbaoAPIbzp26a3QPSy\ni6mx5O+aGtA9aZnuqCij4Tyz8LIRnM98QObd50N9otg6tamN8jSZxNQQ4Qb9CYQQ\nO+7ETPTsJ3xCwnR8gooJybQDJbw=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            50:94:6c:ec:18:ea:d5:9c:4d:d5:97:ef:75:8f:a0:ad\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=US, OU=www.xrampsecurity.com, O=XRamp Security Services Inc, CN=XRamp Global Certification Authority\n        Validity\n            Not Before: Nov  1 17:14:04 2004 GMT\n            Not After : Jan  1 05:37:19 2035 GMT\n        Subject: C=US, OU=www.xrampsecurity.com, O=XRamp Security Services Inc, CN=XRamp Global Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:98:24:1e:bd:15:b4:ba:df:c7:8c:a5:27:b6:38:\n                    0b:69:f3:b6:4e:a8:2c:2e:21:1d:5c:44:df:21:5d:\n                    7e:23:74:fe:5e:7e:b4:4a:b7:a6:ad:1f:ae:e0:06:\n                    16:e2:9b:5b:d9:67:74:6b:5d:80:8f:29:9d:86:1b:\n                    d9:9c:0d:98:6d:76:10:28:58:e4:65:b0:7f:4a:98:\n                    79:9f:e0:c3:31:7e:80:2b:b5:8c:c0:40:3b:11:86:\n                    d0:cb:a2:86:36:60:a4:d5:30:82:6d:d9:6e:d0:0f:\n                    12:04:33:97:5f:4f:61:5a:f0:e4:f9:91:ab:e7:1d:\n                    3b:bc:e8:cf:f4:6b:2d:34:7c:e2:48:61:1c:8e:f3:\n                    61:44:cc:6f:a0:4a:a9:94:b0:4d:da:e7:a9:34:7a:\n                    72:38:a8:41:cc:3c:94:11:7d:eb:c8:a6:8c:b7:86:\n                    cb:ca:33:3b:d9:3d:37:8b:fb:7a:3e:86:2c:e7:73:\n                    d7:0a:57:ac:64:9b:19:eb:f4:0f:04:08:8a:ac:03:\n                    17:19:64:f4:5a:25:22:8d:34:2c:b2:f6:68:1d:12:\n                    6d:d3:8a:1e:14:da:c4:8f:a6:e2:23:85:d5:7a:0d:\n                    bd:6a:e0:e9:ec:ec:17:bb:42:1b:67:aa:25:ed:45:\n                    83:21:fc:c1:c9:7c:d5:62:3e:fa:f2:c5:2d:d3:fd:\n                    d4:65\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            1.3.6.1.4.1.311.20.2: \n                ...C.A\n            X509v3 Key Usage: \n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                C6:4F:A2:3D:06:63:84:09:9C:CE:62:E4:04:AC:8D:5C:B5:E9:B6:1B\n            X509v3 CRL Distribution Points: \n\n                Full Name:\n                  URI:http://crl.xrampsecurity.com/XGCA.crl\n\n            1.3.6.1.4.1.311.21.1: \n                ...\n    Signature Algorithm: sha1WithRSAEncryption\n         91:15:39:03:01:1b:67:fb:4a:1c:f9:0a:60:5b:a1:da:4d:97:\n         62:f9:24:53:27:d7:82:64:4e:90:2e:c3:49:1b:2b:9a:dc:fc:\n         a8:78:67:35:f1:1d:f0:11:bd:b7:48:e3:10:f6:0d:df:3f:d2:\n         c9:b6:aa:55:a4:48:ba:02:db:de:59:2e:15:5b:3b:9d:16:7d:\n         47:d7:37:ea:5f:4d:76:12:36:bb:1f:d7:a1:81:04:46:20:a3:\n         2c:6d:a9:9e:01:7e:3f:29:ce:00:93:df:fd:c9:92:73:89:89:\n         64:9e:e7:2b:e4:1c:91:2c:d2:b9:ce:7d:ce:6f:31:99:d3:e6:\n         be:d2:1e:90:f0:09:14:79:5c:23:ab:4d:d2:da:21:1f:4d:99:\n         79:9d:e1:cf:27:9f:10:9b:1c:88:0d:b0:8a:64:41:31:b8:0e:\n         6c:90:24:a4:9b:5c:71:8f:ba:bb:7e:1c:1b:db:6a:80:0f:21:\n         bc:e9:db:a6:b7:40:f4:b2:8b:a9:b1:e4:ef:9a:1a:d0:3d:69:\n         99:ee:a8:28:a3:e1:3c:b3:f0:b2:11:9c:cf:7c:40:e6:dd:e7:\n         43:7d:a2:d8:3a:b5:a9:8d:f2:34:99:c4:d4:10:e1:06:fd:09:\n         84:10:3b:ee:c4:4c:f4:ec:27:7c:42:c2:74:7c:82:8a:09:c9:\n         b4:03:25:bc\nSHA1 Fingerprint=B8:01:86:D1:EB:9C:86:A5:41:04:CF:30:54:F3:4C:52:B7:E5:58:C6\n",
    "c8cb997270520cf8e6beb20457292acf4210ed35": "-----BEGIN CERTIFICATE-----\nMIICWTCCAd+gAwIBAgIQZvI9r4fei7FK6gxXMQHC7DAKBggqhkjOPQQDAzBlMQsw\nCQYDVQQGEwJVUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTYwNAYD\nVQQDEy1NaWNyb3NvZnQgRUNDIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IDIw\nMTcwHhcNMTkxMjE4MjMwNjQ1WhcNNDIwNzE4MjMxNjA0WjBlMQswCQYDVQQGEwJV\nUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTYwNAYDVQQDEy1NaWNy\nb3NvZnQgRUNDIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTcwdjAQBgcq\nhkjOPQIBBgUrgQQAIgNiAATUvD0CQnVBEyPNgASGAlEvaqiBYgtlzPbKnR5vSmZR\nogPZnZH6thaxjG7efM3beaYvzrvOcS/lpaso7GMEZpn4+vKTEAXhgShC48Zo9OYb\nhGBKia/teQ87zvH2RPUBeMCjVDBSMA4GA1UdDwEB/wQEAwIBhjAPBgNVHRMBAf8E\nBTADAQH/MB0GA1UdDgQWBBTIy5lycFIM+Oa+sgRXKSrPQhDtNTAQBgkrBgEEAYI3\nFQEEAwIBADAKBggqhkjOPQQDAwNoADBlAjBY8k3qDPlfXu5gKcs68tvWMoQZP3zV\nL8KxzJOuULsJMsbG7X7JNpQS5GiFBqIb0C8CMQCZ6Ra0DvpWSNSkMBaReNtUjGUB\niudQZsIxtzm6uBoiB078a1QWIP8rtedMDE2mT3M=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            66:f2:3d:af:87:de:8b:b1:4a:ea:0c:57:31:01:c2:ec\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, O=Microsoft Corporation, CN=Microsoft ECC Root Certificate Authority 2017\n        Validity\n            Not Before: Dec 18 23:06:45 2019 GMT\n            Not After : Jul 18 23:16:04 2042 GMT\n        Subject: C=US, O=Microsoft Corporation, CN=Microsoft ECC Root Certificate Authority 2017\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:d4:bc:3d:02:42:75:41:13:23:cd:80:04:86:02:\n                    51:2f:6a:a8:81:62:0b:65:cc:f6:ca:9d:1e:6f:4a:\n                    66:51:a2:03:d9:9d:91:fa:b6:16:b1:8c:6e:de:7c:\n                    cd:db:79:a6:2f:ce:bb:ce:71:2f:e5:a5:ab:28:ec:\n                    63:04:66:99:f8:fa:f2:93:10:05:e1:81:28:42:e3:\n                    c6:68:f4:e6:1b:84:60:4a:89:af:ed:79:0f:3b:ce:\n                    f1:f6:44:f5:01:78:c0\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                C8:CB:99:72:70:52:0C:F8:E6:BE:B2:04:57:29:2A:CF:42:10:ED:35\n            1.3.6.1.4.1.311.21.1: \n                ...\n    Signature Algorithm: ecdsa-with-SHA384\n         30:65:02:30:58:f2:4d:ea:0c:f9:5f:5e:ee:60:29:cb:3a:f2:\n         db:d6:32:84:19:3f:7c:d5:2f:c2:b1:cc:93:ae:50:bb:09:32:\n         c6:c6:ed:7e:c9:36:94:12:e4:68:85:06:a2:1b:d0:2f:02:31:\n         00:99:e9:16:b4:0e:fa:56:48:d4:a4:30:16:91:78:db:54:8c:\n         65:01:8a:e7:50:66:c2:31:b7:39:ba:b8:1a:22:07:4e:fc:6b:\n         54:16:20:ff:2b:b5:e7:4c:0c:4d:a6:4f:73\nSHA1 Fingerprint=99:9A:64:C3:7F:F4:7D:9F:AB:95:F1:47:69:89:14:60:EE:C4:C3:C5\n",
    "c98077e0629282f5469cf3baf74cc3deb8a3ad39": "-----BEGIN CERTIFICATE-----\nMIIFWTCCA0GgAwIBAgIBAjANBgkqhkiG9w0BAQsFADBOMQswCQYDVQQGEwJOTzEd\nMBsGA1UECgwUQnV5cGFzcyBBUy05ODMxNjMzMjcxIDAeBgNVBAMMF0J1eXBhc3Mg\nQ2xhc3MgMiBSb290IENBMB4XDTEwMTAyNjA4MzgwM1oXDTQwMTAyNjA4MzgwM1ow\nTjELMAkGA1UEBhMCTk8xHTAbBgNVBAoMFEJ1eXBhc3MgQVMtOTgzMTYzMzI3MSAw\nHgYDVQQDDBdCdXlwYXNzIENsYXNzIDIgUm9vdCBDQTCCAiIwDQYJKoZIhvcNAQEB\nBQADggIPADCCAgoCggIBANfHXvfBB9R3+0Mh9PT1aeTuMgHbo4Yf5FkNuud1g1Lr\n6hxhFUi7HQfKjK6w3Jad6sNgkoaCKHOcVgb/S2TwDCo3SbXlzwx87vFKu3MwZfPV\nL4O2fuPn9Z6rYPnT8Z2SdIrkHJasW4DptfQxh6NR/Md+oW+OU3fUl8FVM5I+GC91\n1K2GScuVr1QGbNgGE41b/+EmGVnAJLqBcXmQRFBoJJRfuLMR8SlBYaNByyM21cHx\nMlAQTn/0hpPshNOOvEu/XAFOBz3cFIqUCqTqc/sLUegTBxj6DvEr0VQVfTzh97QZ\nQmdiXnfgolXsttlpF9U6r0TtSsWe5HonfOV116rLJeffawrbD02TTqigzXsu8lkB\narcNuAeBfos4GzjmCleZPe4h6KP1DBbdi+w0jpwqHAAVF41og9JwnxgIzRFo1clr\nUs3ERo/ctfPYV3Me6ZQ5BL/T3jjetFPsaRyifsSP5BtwrfKi+fv3FmRmaZ9JUaLi\nFRhnBkp/1Wy1TbMz4GHrXb7pmA8y1x1LPC5aAVKRCfLf6o3YBkBjqhHk/sM3nhRS\nP/TizPJhk9H9Z2vXUq6/aKtAQ6BXNVN48FP4YUIHZMbXb5tMOA1jrGKvNouicwoN\n9SG9dKpN6nIDSdvHXx1iY8f93ZHsM+71bbRuMGjeyNYmsHVee7QHIJihdjK4TWxP\nAgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFMmAd+BikoL1Rpzz\nuvdMw964o605MA4GA1UdDwEB/wQEAwIBBjANBgkqhkiG9w0BAQsFAAOCAgEAU18h\n9bqwOlI5LJKwbADJ784g7wbylp7ppHR/ehb8t/W2+xUbP6umwHJdELFx7rxP462s\nA20ucS6vxOOto70MEae0/0qyexAQH6dXQbLArvQsWdZHEIjzIVEpMMpghq9Gqx3t\nOluwlN5E40EIosHsHdb9T7bWR9AUC8rmyrV7d35BH16Dx7aMOZawP5aBQW9gkOLo\n+fsicdl9sz1Gv7SEr5AcD48Saq/v7h56rgJKihcrdv6sVIkkLE8/trKnToyokZf7\nKcZ7XC25y2a2t6hbElGFtQl+Ynhw/qlqYLYdDnkM/crqJIByw5c/8nerQyIKx+u2\nDISCLIBrQYoIwOula9+ZEsuK1V6ADJHgJgg2SMX6OBE1/yWDLfJ6v9r9jv6ly0Us\nH8SIU653DtmadsWOLB2jutXsMq7Aqqz30XpN69QH4kj3Io6wpJ9qzo6ysmD0oyLQ\nI+uUWnpp3Q+/QFesa1lQ2aOZ4W7+jQF5JyMV3pKdewlNWudLSDBaGOYKbeaP4NK7\n5t98biGCwWg5TbSYWGZizEqQXsP6JwSxeRV0mcy+rSDeJmAc61ZRpqPq5KM/p/9h\n3PFaTWwyI0PurKju7koSCTxdccK+efrCh2gdC/1cacwG0Jp9VJkqyTkaGa9LKkPz\nY11aWOIv4x3kqdbQCtCev9eBCfHJxyYNrJgWVqA=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 2 (0x2)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=NO, O=Buypass AS-983163327, CN=Buypass Class 2 Root CA\n        Validity\n            Not Before: Oct 26 08:38:03 2010 GMT\n            Not After : Oct 26 08:38:03 2040 GMT\n        Subject: C=NO, O=Buypass AS-983163327, CN=Buypass Class 2 Root CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:d7:c7:5e:f7:c1:07:d4:77:fb:43:21:f4:f4:f5:\n                    69:e4:ee:32:01:db:a3:86:1f:e4:59:0d:ba:e7:75:\n                    83:52:eb:ea:1c:61:15:48:bb:1d:07:ca:8c:ae:b0:\n                    dc:96:9d:ea:c3:60:92:86:82:28:73:9c:56:06:ff:\n                    4b:64:f0:0c:2a:37:49:b5:e5:cf:0c:7c:ee:f1:4a:\n                    bb:73:30:65:f3:d5:2f:83:b6:7e:e3:e7:f5:9e:ab:\n                    60:f9:d3:f1:9d:92:74:8a:e4:1c:96:ac:5b:80:e9:\n                    b5:f4:31:87:a3:51:fc:c7:7e:a1:6f:8e:53:77:d4:\n                    97:c1:55:33:92:3e:18:2f:75:d4:ad:86:49:cb:95:\n                    af:54:06:6c:d8:06:13:8d:5b:ff:e1:26:19:59:c0:\n                    24:ba:81:71:79:90:44:50:68:24:94:5f:b8:b3:11:\n                    f1:29:41:61:a3:41:cb:23:36:d5:c1:f1:32:50:10:\n                    4e:7f:f4:86:93:ec:84:d3:8e:bc:4b:bf:5c:01:4e:\n                    07:3d:dc:14:8a:94:0a:a4:ea:73:fb:0b:51:e8:13:\n                    07:18:fa:0e:f1:2b:d1:54:15:7d:3c:e1:f7:b4:19:\n                    42:67:62:5e:77:e0:a2:55:ec:b6:d9:69:17:d5:3a:\n                    af:44:ed:4a:c5:9e:e4:7a:27:7c:e5:75:d7:aa:cb:\n                    25:e7:df:6b:0a:db:0f:4d:93:4e:a8:a0:cd:7b:2e:\n                    f2:59:01:6a:b7:0d:b8:07:81:7e:8b:38:1b:38:e6:\n                    0a:57:99:3d:ee:21:e8:a3:f5:0c:16:dd:8b:ec:34:\n                    8e:9c:2a:1c:00:15:17:8d:68:83:d2:70:9f:18:08:\n                    cd:11:68:d5:c9:6b:52:cd:c4:46:8f:dc:b5:f3:d8:\n                    57:73:1e:e9:94:39:04:bf:d3:de:38:de:b4:53:ec:\n                    69:1c:a2:7e:c4:8f:e4:1b:70:ad:f2:a2:f9:fb:f7:\n                    16:64:66:69:9f:49:51:a2:e2:15:18:67:06:4a:7f:\n                    d5:6c:b5:4d:b3:33:e0:61:eb:5d:be:e9:98:0f:32:\n                    d7:1d:4b:3c:2e:5a:01:52:91:09:f2:df:ea:8d:d8:\n                    06:40:63:aa:11:e4:fe:c3:37:9e:14:52:3f:f4:e2:\n                    cc:f2:61:93:d1:fd:67:6b:d7:52:ae:bf:68:ab:40:\n                    43:a0:57:35:53:78:f0:53:f8:61:42:07:64:c6:d7:\n                    6f:9b:4c:38:0d:63:ac:62:af:36:8b:a2:73:0a:0d:\n                    f5:21:bd:74:aa:4d:ea:72:03:49:db:c7:5f:1d:62:\n                    63:c7:fd:dd:91:ec:33:ee:f5:6d:b4:6e:30:68:de:\n                    c8:d6:26:b0:75:5e:7b:b4:07:20:98:a1:76:32:b8:\n                    4d:6c:4f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                C9:80:77:E0:62:92:82:F5:46:9C:F3:BA:F7:4C:C3:DE:B8:A3:AD:39\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         53:5f:21:f5:ba:b0:3a:52:39:2c:92:b0:6c:00:c9:ef:ce:20:\n         ef:06:f2:96:9e:e9:a4:74:7f:7a:16:fc:b7:f5:b6:fb:15:1b:\n         3f:ab:a6:c0:72:5d:10:b1:71:ee:bc:4f:e3:ad:ac:03:6d:2e:\n         71:2e:af:c4:e3:ad:a3:bd:0c:11:a7:b4:ff:4a:b2:7b:10:10:\n         1f:a7:57:41:b2:c0:ae:f4:2c:59:d6:47:10:88:f3:21:51:29:\n         30:ca:60:86:af:46:ab:1d:ed:3a:5b:b0:94:de:44:e3:41:08:\n         a2:c1:ec:1d:d6:fd:4f:b6:d6:47:d0:14:0b:ca:e6:ca:b5:7b:\n         77:7e:41:1f:5e:83:c7:b6:8c:39:96:b0:3f:96:81:41:6f:60:\n         90:e2:e8:f9:fb:22:71:d9:7d:b3:3d:46:bf:b4:84:af:90:1c:\n         0f:8f:12:6a:af:ef:ee:1e:7a:ae:02:4a:8a:17:2b:76:fe:ac:\n         54:89:24:2c:4f:3f:b6:b2:a7:4e:8c:a8:91:97:fb:29:c6:7b:\n         5c:2d:b9:cb:66:b6:b7:a8:5b:12:51:85:b5:09:7e:62:78:70:\n         fe:a9:6a:60:b6:1d:0e:79:0c:fd:ca:ea:24:80:72:c3:97:3f:\n         f2:77:ab:43:22:0a:c7:eb:b6:0c:84:82:2c:80:6b:41:8a:08:\n         c0:eb:a5:6b:df:99:12:cb:8a:d5:5e:80:0c:91:e0:26:08:36:\n         48:c5:fa:38:11:35:ff:25:83:2d:f2:7a:bf:da:fd:8e:fe:a5:\n         cb:45:2c:1f:c4:88:53:ae:77:0e:d9:9a:76:c5:8e:2c:1d:a3:\n         ba:d5:ec:32:ae:c0:aa:ac:f7:d1:7a:4d:eb:d4:07:e2:48:f7:\n         22:8e:b0:a4:9f:6a:ce:8e:b2:b2:60:f4:a3:22:d0:23:eb:94:\n         5a:7a:69:dd:0f:bf:40:57:ac:6b:59:50:d9:a3:99:e1:6e:fe:\n         8d:01:79:27:23:15:de:92:9d:7b:09:4d:5a:e7:4b:48:30:5a:\n         18:e6:0a:6d:e6:8f:e0:d2:bb:e6:df:7c:6e:21:82:c1:68:39:\n         4d:b4:98:58:66:62:cc:4a:90:5e:c3:fa:27:04:b1:79:15:74:\n         99:cc:be:ad:20:de:26:60:1c:eb:56:51:a6:a3:ea:e4:a3:3f:\n         a7:ff:61:dc:f1:5a:4d:6c:32:23:43:ee:ac:a8:ee:ee:4a:12:\n         09:3c:5d:71:c2:be:79:fa:c2:87:68:1d:0b:fd:5c:69:cc:06:\n         d0:9a:7d:54:99:2a:c9:39:1a:19:af:4b:2a:43:f3:63:5d:5a:\n         58:e2:2f:e3:1d:e4:a9:d6:d0:0a:d0:9e:bf:d7:81:09:f1:c9:\n         c7:26:0d:ac:98:16:56:a0\nSHA1 Fingerprint=49:0A:75:74:DE:87:0A:47:FE:58:EE:F6:C7:6B:EB:C6:0B:12:40:99\n",
    "cb0fc6df4243cc3dcbb54823a11a7aa62abb3468": "-----BEGIN CERTIFICATE-----\nMIIECjCCAvKgAwIBAgIJAMJ+QwRORz8ZMA0GCSqGSIb3DQEBCwUAMIGCMQswCQYD\nVQQGEwJIVTERMA8GA1UEBwwIQnVkYXBlc3QxFjAUBgNVBAoMDU1pY3Jvc2VjIEx0\nZC4xJzAlBgNVBAMMHk1pY3Jvc2VjIGUtU3ppZ25vIFJvb3QgQ0EgMjAwOTEfMB0G\nCSqGSIb3DQEJARYQaW5mb0BlLXN6aWduby5odTAeFw0wOTA2MTYxMTMwMThaFw0y\nOTEyMzAxMTMwMThaMIGCMQswCQYDVQQGEwJIVTERMA8GA1UEBwwIQnVkYXBlc3Qx\nFjAUBgNVBAoMDU1pY3Jvc2VjIEx0ZC4xJzAlBgNVBAMMHk1pY3Jvc2VjIGUtU3pp\nZ25vIFJvb3QgQ0EgMjAwOTEfMB0GCSqGSIb3DQEJARYQaW5mb0BlLXN6aWduby5o\ndTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOn4j/NjrdqG2KfgQvvP\nkd6mJviZpWNwrZuuyjNAfW2WbqEORO7hE52UQlKavXWFdCyoDh2Tthi3jCyoz/tc\ncbna7P7ofo/kLx2yqHWH2Leh5TvPmUpG0IMZfcChEhyVbUr02MelTTMuhTlAdX4U\nfIASmFDHQWe4oIBhVKZsTh/gnQ4H6cm6M+f+wFUoLAKApxn1ntxVUwOXewdI/5n7\nN4okxFnMUBBjjqqpGrCEGob5X7uxUG6k0QrM1XF+H6cbfPVTbiJfyyvm1HxdrtbC\nxkzlBQHZ7Vf8wSN5/PrIJIOV87VqUQHQd9bpEqH5GoP7ghu5sJf0dgYzQ0mg/wu1\n+rUCAwEAAaOBgDB+MA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0G\nA1UdDgQWBBTLD8bfQkPMPcu1SCOhGnqmKrs0aDAfBgNVHSMEGDAWgBTLD8bfQkPM\nPcu1SCOhGnqmKrs0aDAbBgNVHREEFDASgRBpbmZvQGUtc3ppZ25vLmh1MA0GCSqG\nSIb3DQEBCwUAA4IBAQDJ0Q5eLtXMs3w+y/w9/w0olZMEyL/azXm4Q5DwpL7v8u8h\nmLzU1F0G9u5C7DBsoKqpyvGvivo/C3NqPuouQH4frlRheesuCDfXI/OMn74dseGk\nddug4lQUsbocKaQY9hK6ohQU4zE1yED/t+AFdlfBHFny+L/k7SViXITwfn4fs775\ntyERzAMBVnCnEJIeGzSBHq2cGsMEPO0CYdYeBvNfOofyK/FFh+U9rNHHV4S9a67c\n2Pm2G2JwCz02yULyMtd6YebS2z3PyKnJm9zbWETXbzivf3jTo60adbocwTZ8jx5t\nHMN1Rq41Bab2XD0h7lbwyYIiLXpUq3DDfSJlgnCW\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            c2:7e:43:04:4e:47:3f:19\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=HU, L=Budapest, O=Microsec Ltd., CN=Microsec e-Szigno Root CA 2009/emailAddress=info@e-szigno.hu\n        Validity\n            Not Before: Jun 16 11:30:18 2009 GMT\n            Not After : Dec 30 11:30:18 2029 GMT\n        Subject: C=HU, L=Budapest, O=Microsec Ltd., CN=Microsec e-Szigno Root CA 2009/emailAddress=info@e-szigno.hu\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:e9:f8:8f:f3:63:ad:da:86:d8:a7:e0:42:fb:cf:\n                    91:de:a6:26:f8:99:a5:63:70:ad:9b:ae:ca:33:40:\n                    7d:6d:96:6e:a1:0e:44:ee:e1:13:9d:94:42:52:9a:\n                    bd:75:85:74:2c:a8:0e:1d:93:b6:18:b7:8c:2c:a8:\n                    cf:fb:5c:71:b9:da:ec:fe:e8:7e:8f:e4:2f:1d:b2:\n                    a8:75:87:d8:b7:a1:e5:3b:cf:99:4a:46:d0:83:19:\n                    7d:c0:a1:12:1c:95:6d:4a:f4:d8:c7:a5:4d:33:2e:\n                    85:39:40:75:7e:14:7c:80:12:98:50:c7:41:67:b8:\n                    a0:80:61:54:a6:6c:4e:1f:e0:9d:0e:07:e9:c9:ba:\n                    33:e7:fe:c0:55:28:2c:02:80:a7:19:f5:9e:dc:55:\n                    53:03:97:7b:07:48:ff:99:fb:37:8a:24:c4:59:cc:\n                    50:10:63:8e:aa:a9:1a:b0:84:1a:86:f9:5f:bb:b1:\n                    50:6e:a4:d1:0a:cc:d5:71:7e:1f:a7:1b:7c:f5:53:\n                    6e:22:5f:cb:2b:e6:d4:7c:5d:ae:d6:c2:c6:4c:e5:\n                    05:01:d9:ed:57:fc:c1:23:79:fc:fa:c8:24:83:95:\n                    f3:b5:6a:51:01:d0:77:d6:e9:12:a1:f9:1a:83:fb:\n                    82:1b:b9:b0:97:f4:76:06:33:43:49:a0:ff:0b:b5:\n                    fa:b5\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                CB:0F:C6:DF:42:43:CC:3D:CB:B5:48:23:A1:1A:7A:A6:2A:BB:34:68\n            X509v3 Authority Key Identifier: \n                keyid:CB:0F:C6:DF:42:43:CC:3D:CB:B5:48:23:A1:1A:7A:A6:2A:BB:34:68\n\n            X509v3 Subject Alternative Name: \n                email:info@e-szigno.hu\n    Signature Algorithm: sha256WithRSAEncryption\n         c9:d1:0e:5e:2e:d5:cc:b3:7c:3e:cb:fc:3d:ff:0d:28:95:93:\n         04:c8:bf:da:cd:79:b8:43:90:f0:a4:be:ef:f2:ef:21:98:bc:\n         d4:d4:5d:06:f6:ee:42:ec:30:6c:a0:aa:a9:ca:f1:af:8a:fa:\n         3f:0b:73:6a:3e:ea:2e:40:7e:1f:ae:54:61:79:eb:2e:08:37:\n         d7:23:f3:8c:9f:be:1d:b1:e1:a4:75:db:a0:e2:54:14:b1:ba:\n         1c:29:a4:18:f6:12:ba:a2:14:14:e3:31:35:c8:40:ff:b7:e0:\n         05:76:57:c1:1c:59:f2:f8:bf:e4:ed:25:62:5c:84:f0:7e:7e:\n         1f:b3:be:f9:b7:21:11:cc:03:01:56:70:a7:10:92:1e:1b:34:\n         81:1e:ad:9c:1a:c3:04:3c:ed:02:61:d6:1e:06:f3:5f:3a:87:\n         f2:2b:f1:45:87:e5:3d:ac:d1:c7:57:84:bd:6b:ae:dc:d8:f9:\n         b6:1b:62:70:0b:3d:36:c9:42:f2:32:d7:7a:61:e6:d2:db:3d:\n         cf:c8:a9:c9:9b:dc:db:58:44:d7:6f:38:af:7f:78:d3:a3:ad:\n         1a:75:ba:1c:c1:36:7c:8f:1e:6d:1c:c3:75:46:ae:35:05:a6:\n         f6:5c:3d:21:ee:56:f0:c9:82:22:2d:7a:54:ab:70:c3:7d:22:\n         65:82:70:96\nSHA1 Fingerprint=89:DF:74:FE:5C:F4:0F:4A:80:F9:E3:37:7D:54:DA:91:E1:01:31:8E\n",
    "cbd0bda9e1980551a14d37a28379ce8d1d2ae484": "-----BEGIN CERTIFICATE-----\nMIICRjCCAc2gAwIBAgIQC6Fa+h3foLVJRK/NJKBs7DAKBggqhkjOPQQDAzBlMQsw\nCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu\nZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3Qg\nRzMwHhcNMTMwODAxMTIwMDAwWhcNMzgwMTE1MTIwMDAwWjBlMQswCQYDVQQGEwJV\nUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQu\nY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgRzMwdjAQBgcq\nhkjOPQIBBgUrgQQAIgNiAAQZ57ysRGXtzbg/WPuNsVepRC0FFfLvC/8QdJ+1YlJf\nZn4f5dwbRXkLzMZTCp2NXQLZqVneAlr2lSoOjThKiknGvMYDOAdfVdp+CW7if17Q\nRSAPWXYQ1qAk8C3eNvJsKTmjQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/\nBAQDAgGGMB0GA1UdDgQWBBTL0L2p4ZgFUaFNN6KDec6NHSrkhDAKBggqhkjOPQQD\nAwNnADBkAjAlpIFFAmsSS3V0T8gj43DydXLefInwz5FyYZ5eEJJZVrmDxxDnOOlY\nJjZ91eQ0hjkCMHw2U/Aw5WJjOpnitqM7mzT6HtoQknFekROn3aRukswy1vUhZscv\n6pZjamVFkpUBtA==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            0b:a1:5a:fa:1d:df:a0:b5:49:44:af:cd:24:a0:6c:ec\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root G3\n        Validity\n            Not Before: Aug  1 12:00:00 2013 GMT\n            Not After : Jan 15 12:00:00 2038 GMT\n        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root G3\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:19:e7:bc:ac:44:65:ed:cd:b8:3f:58:fb:8d:b1:\n                    57:a9:44:2d:05:15:f2:ef:0b:ff:10:74:9f:b5:62:\n                    52:5f:66:7e:1f:e5:dc:1b:45:79:0b:cc:c6:53:0a:\n                    9d:8d:5d:02:d9:a9:59:de:02:5a:f6:95:2a:0e:8d:\n                    38:4a:8a:49:c6:bc:c6:03:38:07:5f:55:da:7e:09:\n                    6e:e2:7f:5e:d0:45:20:0f:59:76:10:d6:a0:24:f0:\n                    2d:de:36:f2:6c:29:39\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                CB:D0:BD:A9:E1:98:05:51:A1:4D:37:A2:83:79:CE:8D:1D:2A:E4:84\n    Signature Algorithm: ecdsa-with-SHA384\n         30:64:02:30:25:a4:81:45:02:6b:12:4b:75:74:4f:c8:23:e3:\n         70:f2:75:72:de:7c:89:f0:cf:91:72:61:9e:5e:10:92:59:56:\n         b9:83:c7:10:e7:38:e9:58:26:36:7d:d5:e4:34:86:39:02:30:\n         7c:36:53:f0:30:e5:62:63:3a:99:e2:b6:a3:3b:9b:34:fa:1e:\n         da:10:92:71:5e:91:13:a7:dd:a4:6e:92:cc:32:d6:f5:21:66:\n         c7:2f:ea:96:63:6a:65:45:92:95:01:b4\nSHA1 Fingerprint=F5:17:A2:4F:9A:48:C6:C9:F8:A2:00:26:9F:DC:0F:48:2C:AB:30:89\n",
    "ccfa6793f0b6b8d0a5c01ef353fd8c53df83d796": "-----BEGIN CERTIFICATE-----\nMIIEFTCCAv2gAwIBAgIGSUEs5AAQMA0GCSqGSIb3DQEBCwUAMIGnMQswCQYDVQQG\nEwJIVTERMA8GA1UEBwwIQnVkYXBlc3QxFTATBgNVBAoMDE5ldExvY2sgS2Z0LjE3\nMDUGA1UECwwuVGFuw7pzw610dsOhbnlraWFkw7NrIChDZXJ0aWZpY2F0aW9uIFNl\ncnZpY2VzKTE1MDMGA1UEAwwsTmV0TG9jayBBcmFueSAoQ2xhc3MgR29sZCkgRsWR\ndGFuw7pzw610dsOhbnkwHhcNMDgxMjExMTUwODIxWhcNMjgxMjA2MTUwODIxWjCB\npzELMAkGA1UEBhMCSFUxETAPBgNVBAcMCEJ1ZGFwZXN0MRUwEwYDVQQKDAxOZXRM\nb2NrIEtmdC4xNzA1BgNVBAsMLlRhbsO6c8OtdHbDoW55a2lhZMOzayAoQ2VydGlm\naWNhdGlvbiBTZXJ2aWNlcykxNTAzBgNVBAMMLE5ldExvY2sgQXJhbnkgKENsYXNz\nIEdvbGQpIEbFkXRhbsO6c8OtdHbDoW55MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A\nMIIBCgKCAQEAxCRec75LbRTDofTjl5Bu0jBFHjzuZ9lk4BqKf8owyoPjIMHj9DrT\nlF8afFttvzBPhCf2nx9JvMaZCpDyD/V/Q4Q3Y1GLeqVw/HpYzY6b7cNGbIRwXdrz\nAZAj/E4wqX7hJ2Pn7WQ8oLjJM2P+FpD/sLj916jAwJRDC7bVWaaeVtAkH3B5r9s5\nVA1lddkVQZQBr17s9o3x/61k/iCa11zr/qYfCGSji3ZVrR47KGAuhyXoqq8fxmRG\nILdwfzzeSNuWU7c5d+Qa4scWhHaXWy+7GRWF+GmF9ZmnqfI0p6m2pgP8b4Y9VHx2\nBJtr+UBdADTHLpl1neWIA6pN+APSQnbAGwIDAKiLo0UwQzASBgNVHRMBAf8ECDAG\nAQH/AgEEMA4GA1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUzPpnk/C2uNClwB7zU/2M\nU9+D15YwDQYJKoZIhvcNAQELBQADggEBAKt/7hwWqZw8UQCgwBEIBaeZ5m8BiFRh\nbvG5GK1Krf6BQCOUL/t1fC8oS2IkgYIL9WHxHG64YTjrgfpioTtaYtOUZcTh5m2C\n+C8lcLIhJsFyUR+MLMOEkMNaj7rP9KdlpeuY0fsFskZ1FSNqb4VjMIDw1Z4fKRzC\nbLBQWV2QWzuoDTDPv31/zvGdg73JRm4gpvlhUbohL3u+pRVjodSVh/GeufOJ8z2F\nuLjbvrW5KfnaNwUASZQDhETnv0Mxz3WLJdH0pmT1kvarBes96aULNmLazAZfNou2\nXjG4Kvte9nHfRCaexOYNkbQudZWAUWpLMKawYqGT8ZvYzsRjdT9ZR7E=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 80544274841616 (0x49412ce40010)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=HU, L=Budapest, O=NetLock Kft., OU=Tan\\xC3\\xBAs\\xC3\\xADtv\\xC3\\xA1nykiad\\xC3\\xB3k (Certification Services), CN=NetLock Arany (Class Gold) F\\xC5\\x91tan\\xC3\\xBAs\\xC3\\xADtv\\xC3\\xA1ny\n        Validity\n            Not Before: Dec 11 15:08:21 2008 GMT\n            Not After : Dec  6 15:08:21 2028 GMT\n        Subject: C=HU, L=Budapest, O=NetLock Kft., OU=Tan\\xC3\\xBAs\\xC3\\xADtv\\xC3\\xA1nykiad\\xC3\\xB3k (Certification Services), CN=NetLock Arany (Class Gold) F\\xC5\\x91tan\\xC3\\xBAs\\xC3\\xADtv\\xC3\\xA1ny\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:c4:24:5e:73:be:4b:6d:14:c3:a1:f4:e3:97:90:\n                    6e:d2:30:45:1e:3c:ee:67:d9:64:e0:1a:8a:7f:ca:\n                    30:ca:83:e3:20:c1:e3:f4:3a:d3:94:5f:1a:7c:5b:\n                    6d:bf:30:4f:84:27:f6:9f:1f:49:bc:c6:99:0a:90:\n                    f2:0f:f5:7f:43:84:37:63:51:8b:7a:a5:70:fc:7a:\n                    58:cd:8e:9b:ed:c3:46:6c:84:70:5d:da:f3:01:90:\n                    23:fc:4e:30:a9:7e:e1:27:63:e7:ed:64:3c:a0:b8:\n                    c9:33:63:fe:16:90:ff:b0:b8:fd:d7:a8:c0:c0:94:\n                    43:0b:b6:d5:59:a6:9e:56:d0:24:1f:70:79:af:db:\n                    39:54:0d:65:75:d9:15:41:94:01:af:5e:ec:f6:8d:\n                    f1:ff:ad:64:fe:20:9a:d7:5c:eb:fe:a6:1f:08:64:\n                    a3:8b:76:55:ad:1e:3b:28:60:2e:87:25:e8:aa:af:\n                    1f:c6:64:46:20:b7:70:7f:3c:de:48:db:96:53:b7:\n                    39:77:e4:1a:e2:c7:16:84:76:97:5b:2f:bb:19:15:\n                    85:f8:69:85:f5:99:a7:a9:f2:34:a7:a9:b6:a6:03:\n                    fc:6f:86:3d:54:7c:76:04:9b:6b:f9:40:5d:00:34:\n                    c7:2e:99:75:9d:e5:88:03:aa:4d:f8:03:d2:42:76:\n                    c0:1b\n                Exponent: 43147 (0xa88b)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE, pathlen:4\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                CC:FA:67:93:F0:B6:B8:D0:A5:C0:1E:F3:53:FD:8C:53:DF:83:D7:96\n    Signature Algorithm: sha256WithRSAEncryption\n         ab:7f:ee:1c:16:a9:9c:3c:51:00:a0:c0:11:08:05:a7:99:e6:\n         6f:01:88:54:61:6e:f1:b9:18:ad:4a:ad:fe:81:40:23:94:2f:\n         fb:75:7c:2f:28:4b:62:24:81:82:0b:f5:61:f1:1c:6e:b8:61:\n         38:eb:81:fa:62:a1:3b:5a:62:d3:94:65:c4:e1:e6:6d:82:f8:\n         2f:25:70:b2:21:26:c1:72:51:1f:8c:2c:c3:84:90:c3:5a:8f:\n         ba:cf:f4:a7:65:a5:eb:98:d1:fb:05:b2:46:75:15:23:6a:6f:\n         85:63:30:80:f0:d5:9e:1f:29:1c:c2:6c:b0:50:59:5d:90:5b:\n         3b:a8:0d:30:cf:bf:7d:7f:ce:f1:9d:83:bd:c9:46:6e:20:a6:\n         f9:61:51:ba:21:2f:7b:be:a5:15:63:a1:d4:95:87:f1:9e:b9:\n         f3:89:f3:3d:85:b8:b8:db:be:b5:b9:29:f9:da:37:05:00:49:\n         94:03:84:44:e7:bf:43:31:cf:75:8b:25:d1:f4:a6:64:f5:92:\n         f6:ab:05:eb:3d:e9:a5:0b:36:62:da:cc:06:5f:36:8b:b6:5e:\n         31:b8:2a:fb:5e:f6:71:df:44:26:9e:c4:e6:0d:91:b4:2e:75:\n         95:80:51:6a:4b:30:a6:b0:62:a1:93:f1:9b:d8:ce:c4:63:75:\n         3f:59:47:b1\nSHA1 Fingerprint=06:08:3F:59:3F:15:A1:04:A0:69:A4:6B:A9:03:D0:06:B7:97:09:91\n",
    "cec34ab99955f2b8db60bfa97ebd56b59736a7d6": "-----BEGIN CERTIFICATE-----\nMIIDljCCAn6gAwIBAgIQC5McOtY5Z+pnI7/Dr5r0SzANBgkqhkiG9w0BAQsFADBl\nMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3\nd3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv\nb3QgRzIwHhcNMTMwODAxMTIwMDAwWhcNMzgwMTE1MTIwMDAwWjBlMQswCQYDVQQG\nEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl\ncnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgRzIwggEi\nMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDZ5ygvUj82ckmIkzTz+GoeMVSA\nn61UQbVH35ao1K+ALbkKz3X9iaV9JPrjIgwrvJUXCzO/GU1BBpAAvQxNEP4Htecc\nbiJVMWWXvdMX0h5i89vqbFCMP4QMls+3ywPgym2hFEwbid3tALBSfK+RbLE4E9Hp\nEgjAALAcKxHad3A2m67OeYfcgnDmCXRwVWmvo2ifv922ebPynXApVfSr/5Vh88lA\nbx3RvpO704gqu52/clpWcTs/1PPRCv4o76Pu2ZmvA9OPYLfykqGxvYmJHzDNw6Yu\nYjOuFgJ3RFrngQo8p0Quebg/BLxcoIfhG69Rjs3sLPr4/m3wOnyqi+RnlTGNAgMB\nAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgGGMB0GA1UdDgQW\nBBTOw0q5mVXyuNtgv6l+vVa1lzan1jANBgkqhkiG9w0BAQsFAAOCAQEAyqVVjOPI\nQW5pJ6d1Ee88hjZv0p3GeDgdaZaikmkuOGybfQTUiaWxMTeKySHMq2zNixya1r9I\n0jJmwYrA8y8678Dj1JGG0VDjA9tzd29KOVPt3ibHtX2vK0LRdWLjSisCx1BL4Gni\nlmwORGYQRI+tBev4eaymG+g3NJ1TyWGqolKvSnAWhsI6yLETcDbYz+70CjTVW0z9\nB5yiutkBclzzTcHdDrEcDcRjvq30FPuJ7KJBDkzMyFdA0G4Dqs0MjomZmWzwPDCv\nON9vvKO+KSAnq3T/EyJ43pdSVR6DtVQgA+6uwE9W3jfMw3+qBCe703e4YtsXfJwo\nIhNzbM8m9Yop5w==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            0b:93:1c:3a:d6:39:67:ea:67:23:bf:c3:af:9a:f4:4b\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root G2\n        Validity\n            Not Before: Aug  1 12:00:00 2013 GMT\n            Not After : Jan 15 12:00:00 2038 GMT\n        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root G2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:d9:e7:28:2f:52:3f:36:72:49:88:93:34:f3:f8:\n                    6a:1e:31:54:80:9f:ad:54:41:b5:47:df:96:a8:d4:\n                    af:80:2d:b9:0a:cf:75:fd:89:a5:7d:24:fa:e3:22:\n                    0c:2b:bc:95:17:0b:33:bf:19:4d:41:06:90:00:bd:\n                    0c:4d:10:fe:07:b5:e7:1c:6e:22:55:31:65:97:bd:\n                    d3:17:d2:1e:62:f3:db:ea:6c:50:8c:3f:84:0c:96:\n                    cf:b7:cb:03:e0:ca:6d:a1:14:4c:1b:89:dd:ed:00:\n                    b0:52:7c:af:91:6c:b1:38:13:d1:e9:12:08:c0:00:\n                    b0:1c:2b:11:da:77:70:36:9b:ae:ce:79:87:dc:82:\n                    70:e6:09:74:70:55:69:af:a3:68:9f:bf:dd:b6:79:\n                    b3:f2:9d:70:29:55:f4:ab:ff:95:61:f3:c9:40:6f:\n                    1d:d1:be:93:bb:d3:88:2a:bb:9d:bf:72:5a:56:71:\n                    3b:3f:d4:f3:d1:0a:fe:28:ef:a3:ee:d9:99:af:03:\n                    d3:8f:60:b7:f2:92:a1:b1:bd:89:89:1f:30:cd:c3:\n                    a6:2e:62:33:ae:16:02:77:44:5a:e7:81:0a:3c:a7:\n                    44:2e:79:b8:3f:04:bc:5c:a0:87:e1:1b:af:51:8e:\n                    cd:ec:2c:fa:f8:fe:6d:f0:3a:7c:aa:8b:e4:67:95:\n                    31:8d\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                CE:C3:4A:B9:99:55:F2:B8:DB:60:BF:A9:7E:BD:56:B5:97:36:A7:D6\n    Signature Algorithm: sha256WithRSAEncryption\n         ca:a5:55:8c:e3:c8:41:6e:69:27:a7:75:11:ef:3c:86:36:6f:\n         d2:9d:c6:78:38:1d:69:96:a2:92:69:2e:38:6c:9b:7d:04:d4:\n         89:a5:b1:31:37:8a:c9:21:cc:ab:6c:cd:8b:1c:9a:d6:bf:48:\n         d2:32:66:c1:8a:c0:f3:2f:3a:ef:c0:e3:d4:91:86:d1:50:e3:\n         03:db:73:77:6f:4a:39:53:ed:de:26:c7:b5:7d:af:2b:42:d1:\n         75:62:e3:4a:2b:02:c7:50:4b:e0:69:e2:96:6c:0e:44:66:10:\n         44:8f:ad:05:eb:f8:79:ac:a6:1b:e8:37:34:9d:53:c9:61:aa:\n         a2:52:af:4a:70:16:86:c2:3a:c8:b1:13:70:36:d8:cf:ee:f4:\n         0a:34:d5:5b:4c:fd:07:9c:a2:ba:d9:01:72:5c:f3:4d:c1:dd:\n         0e:b1:1c:0d:c4:63:be:ad:f4:14:fb:89:ec:a2:41:0e:4c:cc:\n         c8:57:40:d0:6e:03:aa:cd:0c:8e:89:99:99:6c:f0:3c:30:af:\n         38:df:6f:bc:a3:be:29:20:27:ab:74:ff:13:22:78:de:97:52:\n         55:1e:83:b5:54:20:03:ee:ae:c0:4f:56:de:37:cc:c3:7f:aa:\n         04:27:bb:d3:77:b8:62:db:17:7c:9c:28:22:13:73:6c:cf:26:\n         f5:8a:29:e7\nSHA1 Fingerprint=A1:4B:48:D9:43:EE:0A:0E:40:90:4F:3C:E0:A4:C0:91:93:51:5D:3F\n",
    "d29f88dfa1cd2cbdecf53b0101933327b2eb604b": "-----BEGIN CERTIFICATE-----\nMIIFojCCA4qgAwIBAgIUAZQwHqIL3fXFMyqxQ0Rx+NZQTQ0wDQYJKoZIhvcNAQEM\nBQAwaTELMAkGA1UEBhMCS1IxJjAkBgNVBAoMHU5BVkVSIEJVU0lORVNTIFBMQVRG\nT1JNIENvcnAuMTIwMAYDVQQDDClOQVZFUiBHbG9iYWwgUm9vdCBDZXJ0aWZpY2F0\naW9uIEF1dGhvcml0eTAeFw0xNzA4MTgwODU4NDJaFw0zNzA4MTgyMzU5NTlaMGkx\nCzAJBgNVBAYTAktSMSYwJAYDVQQKDB1OQVZFUiBCVVNJTkVTUyBQTEFURk9STSBD\nb3JwLjEyMDAGA1UEAwwpTkFWRVIgR2xvYmFsIFJvb3QgQ2VydGlmaWNhdGlvbiBB\ndXRob3JpdHkwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQC21PGTXLVA\niQqrDZBbUGOukJR0F0Vy1ntlWilLp1agS7gvQnXp2XskWjFlqxcX0TM62RHcQDaH\n38dq6SZeWYp34+hInDEW+j6RscrJo+KfziFTowI2MMtSAuXaMl3Dxeb57hHHi8lE\nHoSTGEq0n+USZGnQJoViAbbJAh2+g1G7XNr4rRVqmfeSVPc0W+m/6imBEtRTkZaz\nkVrd/pBzKPswRrXKCAfHcXLJZtM0l/aM9BhK4dA9WkW2aacp+yPOiNgSnABIqKYP\nszuSjXEOdMWLyEz59JuOuDxp7W87UC9Y7cSw0BwbagzivESq2M0UXZR4Yb8Obtoq\nvC8MC3GmsxY/nOb5zJ9TNeIDoKAYv7vxvvTWjIcNQvcGufFt7QSUqP620wbGQGHf\nnZ3zVHbOUzoBppJB7ASjjw2i1QnK1sua8e9DXcCrpUHPXFNwcMmIpi3Ua2FzUCaG\nYQ5fG8Ir4ozVu53BA0K6lNpfqbDKzE0K70dpAy8i+/Eozr9dUGWokG2zdLAIx6yo\n0es+nPxdGoMuK8u180SdOqcXYZaicdNwlhVNt0xz7hlcxVs+Qf6sdWA7G2POAN3a\nCJBitOUt7kinaxeZVL6HSuOpXgRM6xBtVNbv8ejyYhbLgGvtPe31HzClrkvJE+2K\nAQHJuFFYwGY6sWZLxNUxAmLpdIQM201GLQIDAQABo0IwQDAdBgNVHQ4EFgQU0p+I\n36HNLL3s9TsBAZMzJ7LrYEswDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMB\nAf8wDQYJKoZIhvcNAQEMBQADggIBADLKgLOdPVQG3dLSLvCkASELZ0jKbY7gyKoN\nqo0hV4/GPnrK21HUUrPUloSlWGB/5QuOH/XcChWB5Tu2tyIvCZwTFrFsDDUIbatj\ncu3cvuzHV+YwIHHW1xDBE1UBjCpD5EHxzzp6U5LOogMFDTjfArsQLtk70pt6wKGm\n+LUx5vR1yblTmXVHIloUFcd4G7ad6Qz4G3bxhYTeodoS76TiEJd6eN4MUZeoIUCL\nhr0N8F5OSza7OyAfikJW4Qsav3vQIkMsRIz75Sq0bBwcupTgE34h5prCy8VCZLQe\nlHsIJchxzIdFV4XTnyliIoNRlwAYl3dqmJLJfGBs32x9SuRwTMKeuB330DTHD8z7\np/8Dvq1wkNoL3chtl1+afwkyQf3NosxabUzyqkn+Zvjp2DXrDige7kgvOtB5CTh8\npiKCk5XQA76+AqAF3SAi428diDRgxuYKuQl1C/AH6GmWNcf7I4GOODm4RStDeKLR\nLBT/DShycpWbXgnbiUSYqqFJu3FS8r/2/yehNq+4tneI3TqkbZs0kNwUXTC/t+sX\n5Ie3cdCh13cV1ELX8vMxmV2b3RZtP+oGI/hGoiLtk/bdmuYqh7GYVPEi92tF4+KO\ndh2ajcQGjTa3FPOdVGm3jjzVpG2Tgbet9r1ke8LJaDmgkpzNNIaRkPpkUZ3+/uul\n9XXeifdy\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            01:94:30:1e:a2:0b:dd:f5:c5:33:2a:b1:43:44:71:f8:d6:50:4d:0d\n        Signature Algorithm: sha384WithRSAEncryption\n        Issuer: C=KR, O=NAVER BUSINESS PLATFORM Corp., CN=NAVER Global Root Certification Authority\n        Validity\n            Not Before: Aug 18 08:58:42 2017 GMT\n            Not After : Aug 18 23:59:59 2037 GMT\n        Subject: C=KR, O=NAVER BUSINESS PLATFORM Corp., CN=NAVER Global Root Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:b6:d4:f1:93:5c:b5:40:89:0a:ab:0d:90:5b:50:\n                    63:ae:90:94:74:17:45:72:d6:7b:65:5a:29:4b:a7:\n                    56:a0:4b:b8:2f:42:75:e9:d9:7b:24:5a:31:65:ab:\n                    17:17:d1:33:3a:d9:11:dc:40:36:87:df:c7:6a:e9:\n                    26:5e:59:8a:77:e3:e8:48:9c:31:16:fa:3e:91:b1:\n                    ca:c9:a3:e2:9f:ce:21:53:a3:02:36:30:cb:52:02:\n                    e5:da:32:5d:c3:c5:e6:f9:ee:11:c7:8b:c9:44:1e:\n                    84:93:18:4a:b4:9f:e5:12:64:69:d0:26:85:62:01:\n                    b6:c9:02:1d:be:83:51:bb:5c:da:f8:ad:15:6a:99:\n                    f7:92:54:f7:34:5b:e9:bf:ea:29:81:12:d4:53:91:\n                    96:b3:91:5a:dd:fe:90:73:28:fb:30:46:b5:ca:08:\n                    07:c7:71:72:c9:66:d3:34:97:f6:8c:f4:18:4a:e1:\n                    d0:3d:5a:45:b6:69:a7:29:fb:23:ce:88:d8:12:9c:\n                    00:48:a8:a6:0f:b3:3b:92:8d:71:0e:74:c5:8b:c8:\n                    4c:f9:f4:9b:8e:b8:3c:69:ed:6f:3b:50:2f:58:ed:\n                    c4:b0:d0:1c:1b:6a:0c:e2:bc:44:aa:d8:cd:14:5d:\n                    94:78:61:bf:0e:6e:da:2a:bc:2f:0c:0b:71:a6:b3:\n                    16:3f:9c:e6:f9:cc:9f:53:35:e2:03:a0:a0:18:bf:\n                    bb:f1:be:f4:d6:8c:87:0d:42:f7:06:b9:f1:6d:ed:\n                    04:94:a8:fe:b6:d3:06:c6:40:61:df:9d:9d:f3:54:\n                    76:ce:53:3a:01:a6:92:41:ec:04:a3:8f:0d:a2:d5:\n                    09:ca:d6:cb:9a:f1:ef:43:5d:c0:ab:a5:41:cf:5c:\n                    53:70:70:c9:88:a6:2d:d4:6b:61:73:50:26:86:61:\n                    0e:5f:1b:c2:2b:e2:8c:d5:bb:9d:c1:03:42:ba:94:\n                    da:5f:a9:b0:ca:cc:4d:0a:ef:47:69:03:2f:22:fb:\n                    f1:28:ce:bf:5d:50:65:a8:90:6d:b3:74:b0:08:c7:\n                    ac:a8:d1:eb:3e:9c:fc:5d:1a:83:2e:2b:cb:b5:f3:\n                    44:9d:3a:a7:17:61:96:a2:71:d3:70:96:15:4d:b7:\n                    4c:73:ee:19:5c:c5:5b:3e:41:fe:ac:75:60:3b:1b:\n                    63:ce:00:dd:da:08:90:62:b4:e5:2d:ee:48:a7:6b:\n                    17:99:54:be:87:4a:e3:a9:5e:04:4c:eb:10:6d:54:\n                    d6:ef:f1:e8:f2:62:16:cb:80:6b:ed:3d:ed:f5:1f:\n                    30:a5:ae:4b:c9:13:ed:8a:01:01:c9:b8:51:58:c0:\n                    66:3a:b1:66:4b:c4:d5:31:02:62:e9:74:84:0c:db:\n                    4d:46:2d\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                D2:9F:88:DF:A1:CD:2C:BD:EC:F5:3B:01:01:93:33:27:B2:EB:60:4B\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: sha384WithRSAEncryption\n         32:ca:80:b3:9d:3d:54:06:dd:d2:d2:2e:f0:a4:01:21:0b:67:\n         48:ca:6d:8e:e0:c8:aa:0d:aa:8d:21:57:8f:c6:3e:7a:ca:db:\n         51:d4:52:b3:d4:96:84:a5:58:60:7f:e5:0b:8e:1f:f5:dc:0a:\n         15:81:e5:3b:b6:b7:22:2f:09:9c:13:16:b1:6c:0c:35:08:6d:\n         ab:63:72:ed:dc:be:ec:c7:57:e6:30:20:71:d6:d7:10:c1:13:\n         55:01:8c:2a:43:e4:41:f1:cf:3a:7a:53:92:ce:a2:03:05:0d:\n         38:df:02:bb:10:2e:d9:3b:d2:9b:7a:c0:a1:a6:f8:b5:31:e6:\n         f4:75:c9:b9:53:99:75:47:22:5a:14:15:c7:78:1b:b6:9d:e9:\n         0c:f8:1b:76:f1:85:84:de:a1:da:12:ef:a4:e2:10:97:7a:78:\n         de:0c:51:97:a8:21:40:8b:86:bd:0d:f0:5e:4e:4b:36:bb:3b:\n         20:1f:8a:42:56:e1:0b:1a:bf:7b:d0:22:43:2c:44:8c:fb:e5:\n         2a:b4:6c:1c:1c:ba:94:e0:13:7e:21:e6:9a:c2:cb:c5:42:64:\n         b4:1e:94:7b:08:25:c8:71:cc:87:45:57:85:d3:9f:29:62:22:\n         83:51:97:00:18:97:77:6a:98:92:c9:7c:60:6c:df:6c:7d:4a:\n         e4:70:4c:c2:9e:b8:1d:f7:d0:34:c7:0f:cc:fb:a7:ff:03:be:\n         ad:70:90:da:0b:dd:c8:6d:97:5f:9a:7f:09:32:41:fd:cd:a2:\n         cc:5a:6d:4c:f2:aa:49:fe:66:f8:e9:d8:35:eb:0e:28:1e:ee:\n         48:2f:3a:d0:79:09:38:7c:a6:22:82:93:95:d0:03:be:be:02:\n         a0:05:dd:20:22:e3:6f:1d:88:34:60:c6:e6:0a:b9:09:75:0b:\n         f0:07:e8:69:96:35:c7:fb:23:81:8e:38:39:b8:45:2b:43:78:\n         a2:d1:2c:14:ff:0d:28:72:72:95:9b:5e:09:db:89:44:98:aa:\n         a1:49:bb:71:52:f2:bf:f6:ff:27:a1:36:af:b8:b6:77:88:dd:\n         3a:a4:6d:9b:34:90:dc:14:5d:30:bf:b7:eb:17:e4:87:b7:71:\n         d0:a1:d7:77:15:d4:42:d7:f2:f3:31:99:5d:9b:dd:16:6d:3f:\n         ea:06:23:f8:46:a2:22:ed:93:f6:dd:9a:e6:2a:87:b1:98:54:\n         f1:22:f7:6b:45:e3:e2:8e:76:1d:9a:8d:c4:06:8d:36:b7:14:\n         f3:9d:54:69:b7:8e:3c:d5:a4:6d:93:81:b7:ad:f6:bd:64:7b:\n         c2:c9:68:39:a0:92:9c:cd:34:86:91:90:fa:64:51:9d:fe:fe:\n         eb:a5:f5:75:de:89:f7:72\nSHA1 Fingerprint=8F:6B:F2:A9:27:4A:DA:14:A0:C4:F4:8E:61:27:F9:C0:1E:78:5D:D1\n",
    "d2c4b0d291d44c1171b361cb3da1fedda86ad4e3": "-----BEGIN CERTIFICATE-----\nMIIEADCCAuigAwIBAgIBADANBgkqhkiG9w0BAQUFADBjMQswCQYDVQQGEwJVUzEh\nMB8GA1UEChMYVGhlIEdvIERhZGR5IEdyb3VwLCBJbmMuMTEwLwYDVQQLEyhHbyBE\nYWRkeSBDbGFzcyAyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA0MDYyOTE3\nMDYyMFoXDTM0MDYyOTE3MDYyMFowYzELMAkGA1UEBhMCVVMxITAfBgNVBAoTGFRo\nZSBHbyBEYWRkeSBHcm91cCwgSW5jLjExMC8GA1UECxMoR28gRGFkZHkgQ2xhc3Mg\nMiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCCASAwDQYJKoZIhvcNAQEBBQADggEN\nADCCAQgCggEBAN6d1+pXGEmhW+vXX0iG6r7d/+TvZxz0ZWizV3GgXne77ZtJ6XCA\nPVYYYwhv2vLM0D9/AlQiVBDYsoHUwHU9S3/Hd8M+eKsaA7Ugay9qK7HFiH7Eux6w\nwdhFJ2+qN1j3hybX2C32qRe3H3I2TqYXP2WYktsqbl2i/ojgC95/5Y0V4evLOtXi\nEqITLdiOr18SPaAIBQi2XKVlOARFmR6jYGB0xUGlcmIbYsUfb18aQr4CUWWoriMY\navx4A6lNf4DD+qta/KFApMoZFv6yyO9ecw3ud72a9nmYvLEHZ6IVDd2gWMZEewo+\nYihfukEHU1jPEX44dMX4/7VpkI+EdOqXG68CAQOjgcAwgb0wHQYDVR0OBBYEFNLE\nsNKR1EwRcbNhyz2h/t2oatTjMIGNBgNVHSMEgYUwgYKAFNLEsNKR1EwRcbNhyz2h\n/t2oatTjoWekZTBjMQswCQYDVQQGEwJVUzEhMB8GA1UEChMYVGhlIEdvIERhZGR5\nIEdyb3VwLCBJbmMuMTEwLwYDVQQLEyhHbyBEYWRkeSBDbGFzcyAyIENlcnRpZmlj\nYXRpb24gQXV0aG9yaXR5ggEAMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQAD\nggEBADJL87LKPpH8EsahB4yOd6AzBhRckB4Y9wimPQoZ+YeAEW5p5JYXMP80kWNy\nOO7MHAGjHZQopDH2esRU1/blMVgDoszOYtuURXO1v0XJJLXVggKtI3lpjbi2Tc7P\nTMozI+gciKqdi0FuFskg5YmezTvacPd+mSYgFFQlq25zheabIZ0KbIIOqPjCDPoQ\nHmyW74cNxA9hi63ugyuV+I6ShHI56yDqg+2DzZduCLzrTia2cyvk0/ZM/iZx4mER\ndEr/VxqHD3VILs9RaRegAhJhldXRQLIQTO7ErBBDpqWeCtWVYpoNz4iCxTIM5Cuf\nReYNnyicsbkqWletNw+vHX/bvZ8=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 0 (0x0)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=US, O=The Go Daddy Group, Inc., OU=Go Daddy Class 2 Certification Authority\n        Validity\n            Not Before: Jun 29 17:06:20 2004 GMT\n            Not After : Jun 29 17:06:20 2034 GMT\n        Subject: C=US, O=The Go Daddy Group, Inc., OU=Go Daddy Class 2 Certification Authority\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:de:9d:d7:ea:57:18:49:a1:5b:eb:d7:5f:48:86:\n                    ea:be:dd:ff:e4:ef:67:1c:f4:65:68:b3:57:71:a0:\n                    5e:77:bb:ed:9b:49:e9:70:80:3d:56:18:63:08:6f:\n                    da:f2:cc:d0:3f:7f:02:54:22:54:10:d8:b2:81:d4:\n                    c0:75:3d:4b:7f:c7:77:c3:3e:78:ab:1a:03:b5:20:\n                    6b:2f:6a:2b:b1:c5:88:7e:c4:bb:1e:b0:c1:d8:45:\n                    27:6f:aa:37:58:f7:87:26:d7:d8:2d:f6:a9:17:b7:\n                    1f:72:36:4e:a6:17:3f:65:98:92:db:2a:6e:5d:a2:\n                    fe:88:e0:0b:de:7f:e5:8d:15:e1:eb:cb:3a:d5:e2:\n                    12:a2:13:2d:d8:8e:af:5f:12:3d:a0:08:05:08:b6:\n                    5c:a5:65:38:04:45:99:1e:a3:60:60:74:c5:41:a5:\n                    72:62:1b:62:c5:1f:6f:5f:1a:42:be:02:51:65:a8:\n                    ae:23:18:6a:fc:78:03:a9:4d:7f:80:c3:fa:ab:5a:\n                    fc:a1:40:a4:ca:19:16:fe:b2:c8:ef:5e:73:0d:ee:\n                    77:bd:9a:f6:79:98:bc:b1:07:67:a2:15:0d:dd:a0:\n                    58:c6:44:7b:0a:3e:62:28:5f:ba:41:07:53:58:cf:\n                    11:7e:38:74:c5:f8:ff:b5:69:90:8f:84:74:ea:97:\n                    1b:af\n                Exponent: 3 (0x3)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                D2:C4:B0:D2:91:D4:4C:11:71:B3:61:CB:3D:A1:FE:DD:A8:6A:D4:E3\n            X509v3 Authority Key Identifier: \n                keyid:D2:C4:B0:D2:91:D4:4C:11:71:B3:61:CB:3D:A1:FE:DD:A8:6A:D4:E3\n                DirName:/C=US/O=The Go Daddy Group, Inc./OU=Go Daddy Class 2 Certification Authority\n                serial:00\n\n            X509v3 Basic Constraints: \n                CA:TRUE\n    Signature Algorithm: sha1WithRSAEncryption\n         32:4b:f3:b2:ca:3e:91:fc:12:c6:a1:07:8c:8e:77:a0:33:06:\n         14:5c:90:1e:18:f7:08:a6:3d:0a:19:f9:87:80:11:6e:69:e4:\n         96:17:30:ff:34:91:63:72:38:ee:cc:1c:01:a3:1d:94:28:a4:\n         31:f6:7a:c4:54:d7:f6:e5:31:58:03:a2:cc:ce:62:db:94:45:\n         73:b5:bf:45:c9:24:b5:d5:82:02:ad:23:79:69:8d:b8:b6:4d:\n         ce:cf:4c:ca:33:23:e8:1c:88:aa:9d:8b:41:6e:16:c9:20:e5:\n         89:9e:cd:3b:da:70:f7:7e:99:26:20:14:54:25:ab:6e:73:85:\n         e6:9b:21:9d:0a:6c:82:0e:a8:f8:c2:0c:fa:10:1e:6c:96:ef:\n         87:0d:c4:0f:61:8b:ad:ee:83:2b:95:f8:8e:92:84:72:39:eb:\n         20:ea:83:ed:83:cd:97:6e:08:bc:eb:4e:26:b6:73:2b:e4:d3:\n         f6:4c:fe:26:71:e2:61:11:74:4a:ff:57:1a:87:0f:75:48:2e:\n         cf:51:69:17:a0:02:12:61:95:d5:d1:40:b2:10:4c:ee:c4:ac:\n         10:43:a6:a5:9e:0a:d5:95:62:9a:0d:cf:88:82:c5:32:0c:e4:\n         2b:9f:45:e6:0d:9f:28:9c:b1:b9:2a:5a:57:ad:37:0f:af:1d:\n         7f:db:bd:9f\nSHA1 Fingerprint=27:96:BA:E6:3F:18:01:E2:77:26:1B:A0:D7:77:70:02:8F:20:EE:E4\n",
    "d3948a4c62132a192eccaf728a7d36d79a1cdc67": "-----BEGIN CERTIFICATE-----\nMIIEQzCCAyugAwIBAgIDCYP0MA0GCSqGSIb3DQEBCwUAMFAxCzAJBgNVBAYTAkRF\nMRUwEwYDVQQKDAxELVRydXN0IEdtYkgxKjAoBgNVBAMMIUQtVFJVU1QgUm9vdCBD\nbGFzcyAzIENBIDIgRVYgMjAwOTAeFw0wOTExMDUwODUwNDZaFw0yOTExMDUwODUw\nNDZaMFAxCzAJBgNVBAYTAkRFMRUwEwYDVQQKDAxELVRydXN0IEdtYkgxKjAoBgNV\nBAMMIUQtVFJVU1QgUm9vdCBDbGFzcyAzIENBIDIgRVYgMjAwOTCCASIwDQYJKoZI\nhvcNAQEBBQADggEPADCCAQoCggEBAJnxhDRwui+3MKCOvXwEz75ivJn9gpfSegpn\nljgJ9hBOlSJzmY3aFS3nBfwZcyK3jpgAvDw9rKFs+9Z5JUut8Mxk2og+KbgPCdM0\n3TP1YtHhzRnp7hhPTFiu4h7WDFsVWtg6uMQYZB7jM7K1iXdODL/ZlGsTl28So/6Z\nqQTMFexgaDbtCHu39b+T7WYxg4zGcTSHThfqr4uRjRxWQa4iN1438h3Z0S0NL2lR\np75mpoo6Kr3HGrHhFPC+Oh25z1uxav60sUYgovseO3Dvk5h9jHOW8sXvhXCtKSb8\nHgQ+HKDYD8tSg2J87otTlZCpV6LqYQXY+U3EJ/pure3511H3a6UCAwEAAaOCASQw\nggEgMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFNOUikxiEyoZLsyvcop9Ntea\nHNxnMA4GA1UdDwEB/wQEAwIBBjCB3QYDVR0fBIHVMIHSMIGHoIGEoIGBhn9sZGFw\nOi8vZGlyZWN0b3J5LmQtdHJ1c3QubmV0L0NOPUQtVFJVU1QlMjBSb290JTIwQ2xh\nc3MlMjAzJTIwQ0ElMjAyJTIwRVYlMjAyMDA5LE89RC1UcnVzdCUyMEdtYkgsQz1E\nRT9jZXJ0aWZpY2F0ZXJldm9jYXRpb25saXN0MEagRKBChkBodHRwOi8vd3d3LmQt\ndHJ1c3QubmV0L2NybC9kLXRydXN0X3Jvb3RfY2xhc3NfM19jYV8yX2V2XzIwMDku\nY3JsMA0GCSqGSIb3DQEBCwUAA4IBAQA07XtaPKSUiO8aEXUHL7P+PPoeUSbrh/Yp\n3uDx1MYkCenBz1UbtDDZzhr+BlGmFaQt77JLvyAoJUnRpjZ3NOhk31KxEcdzes05\nnsKtjHEh8lprr988TlWvsoRlFIm5d8sqMb7Po23Pb0iUMkZv53GMoKaEGTcH8gNF\nCSuGdXzfX2lXANtu2KZyIktQ1HWYVt+3GP9DQ1CuekR78HlR10M9p9OB0/DJT7na\nxpeG0ILD5EJt/rDiZE4OJudANCa1CInXCGNjOCd1HjPqbqjdn5lPdE2BiYBL3ZqX\nKVwvvoFBuYz/6n1gBp7N1z3TLqMVvKjmJuVvw9y4AyHqnxbxLFS1\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 623604 (0x983f4)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=DE, O=D-Trust GmbH, CN=D-TRUST Root Class 3 CA 2 EV 2009\n        Validity\n            Not Before: Nov  5 08:50:46 2009 GMT\n            Not After : Nov  5 08:50:46 2029 GMT\n        Subject: C=DE, O=D-Trust GmbH, CN=D-TRUST Root Class 3 CA 2 EV 2009\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:99:f1:84:34:70:ba:2f:b7:30:a0:8e:bd:7c:04:\n                    cf:be:62:bc:99:fd:82:97:d2:7a:0a:67:96:38:09:\n                    f6:10:4e:95:22:73:99:8d:da:15:2d:e7:05:fc:19:\n                    73:22:b7:8e:98:00:bc:3c:3d:ac:a1:6c:fb:d6:79:\n                    25:4b:ad:f0:cc:64:da:88:3e:29:b8:0f:09:d3:34:\n                    dd:33:f5:62:d1:e1:cd:19:e9:ee:18:4f:4c:58:ae:\n                    e2:1e:d6:0c:5b:15:5a:d8:3a:b8:c4:18:64:1e:e3:\n                    33:b2:b5:89:77:4e:0c:bf:d9:94:6b:13:97:6f:12:\n                    a3:fe:99:a9:04:cc:15:ec:60:68:36:ed:08:7b:b7:\n                    f5:bf:93:ed:66:31:83:8c:c6:71:34:87:4e:17:ea:\n                    af:8b:91:8d:1c:56:41:ae:22:37:5e:37:f2:1d:d9:\n                    d1:2d:0d:2f:69:51:a7:be:66:a6:8a:3a:2a:bd:c7:\n                    1a:b1:e1:14:f0:be:3a:1d:b9:cf:5b:b1:6a:fe:b4:\n                    b1:46:20:a2:fb:1e:3b:70:ef:93:98:7d:8c:73:96:\n                    f2:c5:ef:85:70:ad:29:26:fc:1e:04:3e:1c:a0:d8:\n                    0f:cb:52:83:62:7c:ee:8b:53:95:90:a9:57:a2:ea:\n                    61:05:d8:f9:4d:c4:27:fa:6e:ad:ed:f9:d7:51:f7:\n                    6b:a5\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                D3:94:8A:4C:62:13:2A:19:2E:CC:AF:72:8A:7D:36:D7:9A:1C:DC:67\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 CRL Distribution Points: \n\n                Full Name:\n                  URI:ldap://directory.d-trust.net/CN=D-TRUST%20Root%20Class%203%20CA%202%20EV%202009,O=D-Trust%20GmbH,C=DE?certificaterevocationlist\n\n                Full Name:\n                  URI:http://www.d-trust.net/crl/d-trust_root_class_3_ca_2_ev_2009.crl\n\n    Signature Algorithm: sha256WithRSAEncryption\n         34:ed:7b:5a:3c:a4:94:88:ef:1a:11:75:07:2f:b3:fe:3c:fa:\n         1e:51:26:eb:87:f6:29:de:e0:f1:d4:c6:24:09:e9:c1:cf:55:\n         1b:b4:30:d9:ce:1a:fe:06:51:a6:15:a4:2d:ef:b2:4b:bf:20:\n         28:25:49:d1:a6:36:77:34:e8:64:df:52:b1:11:c7:73:7a:cd:\n         39:9e:c2:ad:8c:71:21:f2:5a:6b:af:df:3c:4e:55:af:b2:84:\n         65:14:89:b9:77:cb:2a:31:be:cf:a3:6d:cf:6f:48:94:32:46:\n         6f:e7:71:8c:a0:a6:84:19:37:07:f2:03:45:09:2b:86:75:7c:\n         df:5f:69:57:00:db:6e:d8:a6:72:22:4b:50:d4:75:98:56:df:\n         b7:18:ff:43:43:50:ae:7a:44:7b:f0:79:51:d7:43:3d:a7:d3:\n         81:d3:f0:c9:4f:b9:da:c6:97:86:d0:82:c3:e4:42:6d:fe:b0:\n         e2:64:4e:0e:26:e7:40:34:26:b5:08:89:d7:08:63:63:38:27:\n         75:1e:33:ea:6e:a8:dd:9f:99:4f:74:4d:81:89:80:4b:dd:9a:\n         97:29:5c:2f:be:81:41:b9:8c:ff:ea:7d:60:06:9e:cd:d7:3d:\n         d3:2e:a3:15:bc:a8:e6:26:e5:6f:c3:dc:b8:03:21:ea:9f:16:\n         f1:2c:54:b5\nSHA1 Fingerprint=96:C9:1B:0B:95:B4:10:98:42:FA:D0:D8:22:79:FE:60:FA:B9:16:83\n",
    "d3ecc73a656ecce1da769a56fb9cf3866d57e581": "-----BEGIN CERTIFICATE-----\nMIIB8jCCAXigAwIBAgITBmyf18G7EEwpQ+Vxe3ssyBrBDjAKBggqhkjOPQQDAzA5\nMQswCQYDVQQGEwJVUzEPMA0GA1UEChMGQW1hem9uMRkwFwYDVQQDExBBbWF6b24g\nUm9vdCBDQSA0MB4XDTE1MDUyNjAwMDAwMFoXDTQwMDUyNjAwMDAwMFowOTELMAkG\nA1UEBhMCVVMxDzANBgNVBAoTBkFtYXpvbjEZMBcGA1UEAxMQQW1hem9uIFJvb3Qg\nQ0EgNDB2MBAGByqGSM49AgEGBSuBBAAiA2IABNKrijdPo1MN/sGKe0uoe0ZLY7Bi\n9i0b2whxIdIA6GO9mif78DluXeo9pcmBqqNbIJhFXRbb/egQbeOc4OO9X4Ri83Bk\nM6DLJC9wuoihKqB1+IGuYgbEgds5bimwHvouXKNCMEAwDwYDVR0TAQH/BAUwAwEB\n/zAOBgNVHQ8BAf8EBAMCAYYwHQYDVR0OBBYEFNPsxzplbszh2naaVvuc84ZtV+WB\nMAoGCCqGSM49BAMDA2gAMGUCMDqLIfG9fhGt0O9Yli/W651+kI0rz2ZVwyzjKKlw\nCkcO8DdZEv8tmZQoTipPNU0zWgIxAOp1AE47xDqUEpHJWEadIRNyp4iciuRMStuW\n1KyLa2tJElMzrdfkviT8tQp21KW8EA==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            06:6c:9f:d7:c1:bb:10:4c:29:43:e5:71:7b:7b:2c:c8:1a:c1:0e\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, O=Amazon, CN=Amazon Root CA 4\n        Validity\n            Not Before: May 26 00:00:00 2015 GMT\n            Not After : May 26 00:00:00 2040 GMT\n        Subject: C=US, O=Amazon, CN=Amazon Root CA 4\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:d2:ab:8a:37:4f:a3:53:0d:fe:c1:8a:7b:4b:a8:\n                    7b:46:4b:63:b0:62:f6:2d:1b:db:08:71:21:d2:00:\n                    e8:63:bd:9a:27:fb:f0:39:6e:5d:ea:3d:a5:c9:81:\n                    aa:a3:5b:20:98:45:5d:16:db:fd:e8:10:6d:e3:9c:\n                    e0:e3:bd:5f:84:62:f3:70:64:33:a0:cb:24:2f:70:\n                    ba:88:a1:2a:a0:75:f8:81:ae:62:06:c4:81:db:39:\n                    6e:29:b0:1e:fa:2e:5c\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                D3:EC:C7:3A:65:6E:CC:E1:DA:76:9A:56:FB:9C:F3:86:6D:57:E5:81\n    Signature Algorithm: ecdsa-with-SHA384\n         30:65:02:30:3a:8b:21:f1:bd:7e:11:ad:d0:ef:58:96:2f:d6:\n         eb:9d:7e:90:8d:2b:cf:66:55:c3:2c:e3:28:a9:70:0a:47:0e:\n         f0:37:59:12:ff:2d:99:94:28:4e:2a:4f:35:4d:33:5a:02:31:\n         00:ea:75:00:4e:3b:c4:3a:94:12:91:c9:58:46:9d:21:13:72:\n         a7:88:9c:8a:e4:4c:4a:db:96:d4:ac:8b:6b:6b:49:12:53:33:\n         ad:d7:e4:be:24:fc:b5:0a:76:d4:a5:bc:10\nSHA1 Fingerprint=F6:10:84:07:D6:F8:BB:67:98:0C:C2:E2:44:C2:EB:AE:1C:EF:63:BE\n",
    "d9743ae4303d0df712dc7e5a059f1e349af7e114": "-----BEGIN CERTIFICATE-----\nMIIFWjCCA0KgAwIBAgIQT9Irj/VkyDOeTzRYZiNwYDANBgkqhkiG9w0BAQsFADBH\nMQswCQYDVQQGEwJDTjERMA8GA1UECgwIVW5pVHJ1c3QxJTAjBgNVBAMMHFVDQSBF\neHRlbmRlZCBWYWxpZGF0aW9uIFJvb3QwHhcNMTUwMzEzMDAwMDAwWhcNMzgxMjMx\nMDAwMDAwWjBHMQswCQYDVQQGEwJDTjERMA8GA1UECgwIVW5pVHJ1c3QxJTAjBgNV\nBAMMHFVDQSBFeHRlbmRlZCBWYWxpZGF0aW9uIFJvb3QwggIiMA0GCSqGSIb3DQEB\nAQUAA4ICDwAwggIKAoICAQCpCQcoEwKwmeBkqh5DFnpzsZGgdT6o+uM4AHrsiWog\nD4vFsJszA1qGxliG1cGFu0/GnEBNyr7uaZa4rYEwmnySBesFK5pI0Lh2PpbIILvS\nsPGP2KxFRv+qZ2C0d35qHzwaUnoEPQc8hQ2E0B92CvdqFN9y4zR8V05WAT558aop\nO2z6+I9tTcg1367r3CTueUWnhbYFiN6IXSV8l2RnCdm/WhUFhvMJHuxYMjMR83dk\nsHYf5BA1FxvyDrFspCqjc/wJHx4yGVMR59mzLC52LqGj3n5qiAno8geK+LLNEOfi\nc0CTuwjRP+H8C5SzJe98ptfRr5//lpr1kXuYC3fUfugH0mK1lTnj8/FtDw5lhIpj\nVMWAtuCeS31HJqcBCF3RiJ7XwzJE+oJKCmhUfzhTA8ykADNkUVkLo4KRel7sFsLz\nKuZi2irbWWIQJUoqgQtHB0MGcIfS+pMRKXpITeuUx3BNr2fVUbGAIAEBtHoIppB/\nTuDvB0GHr2qlXov7z1CymlSvw4m6WC31MJixNnI5fkkE/SmnTHnkBVfblLkWU41G\nsx2VYVdWf6/wFlthWG82UBEL2KwrlRYaDh8IzTY0ZRBiZtWAXxQgXy0MoHgKaNYs\n1+lvK9JKBZP8nm9rZ/+I8U6laUpSNwXqxhaN0sSZ0YIrO7o1dfdRUVjzyAfd5LQD\nfwIDAQABo0IwQDAdBgNVHQ4EFgQU2XQ65DA9DfcS3H5aBZ8eNJr34RQwDwYDVR0T\nAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcNAQELBQADggIBADaN\nl8xCFWQpN5smLNb7rhVpLGsaGvdftvkHTFnq88nIua7Mui563MD1sC3AO6+fcAUR\nap8lTwEpcOPlDOHqWnzcSbvBHiqB9RZLcpHIojG5qtr8nR/zXUACE/xOHAbKsxSQ\nVBcZEhrxH9cMaVr2cXj0lH2RC47skFSOvG+hTKv8dGT9cZr4QQehzZHkPJrgmzI5\nc6sq1WnIeJEmMX3ixzDx/BR4dxIOE/TdFpS/S2d7cFOFyrC78zhNLJA5wA3CXWvp\n4uXViI3WLL+rG761KIcSF3Ru/H38j9CHJrAb+7lsq+KePRXBOy5nAliRn+/4Qh8s\nt2j1da3Ptfb/EX3C8CSlrdP6oDyp+l3cpaDvRKS+1ujl5BOWF3sGPjLtx7dCvHaj\n2GU4Kzg1USEODm8uNBNA4StnDG1KQTAYI1oyVZnJF+A83vbsea0rWBmirSwiGpWO\nvpaQXUJXxPkUAzUrHC1RVwinOt4/5Mi0A3PCwSaAuwtCH60NryZy2sy+s6ODWA2C\nxR9GUeOcGMyNm43sSet1UNWMKFnKdDTajAshqx7qG+XH/RU+wBeq+yNuJkbL+vmx\ncmtpzyKEC2IPrNkZAJSidjzULZrtBJ4tBmIQN1IchXIbJ+XMxjHsN+xjWZsLHXbM\nfjKaiJUINlK73nZfdklJrX+9ZSCyycErdhh2n1ax\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            4f:d2:2b:8f:f5:64:c8:33:9e:4f:34:58:66:23:70:60\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=CN, O=UniTrust, CN=UCA Extended Validation Root\n        Validity\n            Not Before: Mar 13 00:00:00 2015 GMT\n            Not After : Dec 31 00:00:00 2038 GMT\n        Subject: C=CN, O=UniTrust, CN=UCA Extended Validation Root\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:a9:09:07:28:13:02:b0:99:e0:64:aa:1e:43:16:\n                    7a:73:b1:91:a0:75:3e:a8:fa:e3:38:00:7a:ec:89:\n                    6a:20:0f:8b:c5:b0:9b:33:03:5a:86:c6:58:86:d5:\n                    c1:85:bb:4f:c6:9c:40:4d:ca:be:ee:69:96:b8:ad:\n                    81:30:9a:7c:92:05:eb:05:2b:9a:48:d0:b8:76:3e:\n                    96:c8:20:bb:d2:b0:f1:8f:d8:ac:45:46:ff:aa:67:\n                    60:b4:77:7e:6a:1f:3c:1a:52:7a:04:3d:07:3c:85:\n                    0d:84:d0:1f:76:0a:f7:6a:14:df:72:e3:34:7c:57:\n                    4e:56:01:3e:79:f1:aa:29:3b:6c:fa:f8:8f:6d:4d:\n                    c8:35:df:ae:eb:dc:24:ee:79:45:a7:85:b6:05:88:\n                    de:88:5d:25:7c:97:64:67:09:d9:bf:5a:15:05:86:\n                    f3:09:1e:ec:58:32:33:11:f3:77:64:b0:76:1f:e4:\n                    10:35:17:1b:f2:0e:b1:6c:a4:2a:a3:73:fc:09:1f:\n                    1e:32:19:53:11:e7:d9:b3:2c:2e:76:2e:a1:a3:de:\n                    7e:6a:88:09:e8:f2:07:8a:f8:b2:cd:10:e7:e2:73:\n                    40:93:bb:08:d1:3f:e1:fc:0b:94:b3:25:ef:7c:a6:\n                    d7:d1:af:9f:ff:96:9a:f5:91:7b:98:0b:77:d4:7e:\n                    e8:07:d2:62:b5:95:39:e3:f3:f1:6d:0f:0e:65:84:\n                    8a:63:54:c5:80:b6:e0:9e:4b:7d:47:26:a7:01:08:\n                    5d:d1:88:9e:d7:c3:32:44:fa:82:4a:0a:68:54:7f:\n                    38:53:03:cc:a4:00:33:64:51:59:0b:a3:82:91:7a:\n                    5e:ec:16:c2:f3:2a:e6:62:da:2a:db:59:62:10:25:\n                    4a:2a:81:0b:47:07:43:06:70:87:d2:fa:93:11:29:\n                    7a:48:4d:eb:94:c7:70:4d:af:67:d5:51:b1:80:20:\n                    01:01:b4:7a:08:a6:90:7f:4e:e0:ef:07:41:87:af:\n                    6a:a5:5e:8b:fb:cf:50:b2:9a:54:af:c3:89:ba:58:\n                    2d:f5:30:98:b1:36:72:39:7e:49:04:fd:29:a7:4c:\n                    79:e4:05:57:db:94:b9:16:53:8d:46:b3:1d:95:61:\n                    57:56:7f:af:f0:16:5b:61:58:6f:36:50:11:0b:d8:\n                    ac:2b:95:16:1a:0e:1f:08:cd:36:34:65:10:62:66:\n                    d5:80:5f:14:20:5f:2d:0c:a0:78:0a:68:d6:2c:d7:\n                    e9:6f:2b:d2:4a:05:93:fc:9e:6f:6b:67:ff:88:f1:\n                    4e:a5:69:4a:52:37:05:ea:c6:16:8d:d2:c4:99:d1:\n                    82:2b:3b:ba:35:75:f7:51:51:58:f3:c8:07:dd:e4:\n                    b4:03:7f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                D9:74:3A:E4:30:3D:0D:F7:12:DC:7E:5A:05:9F:1E:34:9A:F7:E1:14\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         36:8d:97:cc:42:15:64:29:37:9b:26:2c:d6:fb:ae:15:69:2c:\n         6b:1a:1a:f7:5f:b6:f9:07:4c:59:ea:f3:c9:c8:b9:ae:cc:ba:\n         2e:7a:dc:c0:f5:b0:2d:c0:3b:af:9f:70:05:11:6a:9f:25:4f:\n         01:29:70:e3:e5:0c:e1:ea:5a:7c:dc:49:bb:c1:1e:2a:81:f5:\n         16:4b:72:91:c8:a2:31:b9:aa:da:fc:9d:1f:f3:5d:40:02:13:\n         fc:4e:1c:06:ca:b3:14:90:54:17:19:12:1a:f1:1f:d7:0c:69:\n         5a:f6:71:78:f4:94:7d:91:0b:8e:ec:90:54:8e:bc:6f:a1:4c:\n         ab:fc:74:64:fd:71:9a:f8:41:07:a1:cd:91:e4:3c:9a:e0:9b:\n         32:39:73:ab:2a:d5:69:c8:78:91:26:31:7d:e2:c7:30:f1:fc:\n         14:78:77:12:0e:13:f4:dd:16:94:bf:4b:67:7b:70:53:85:ca:\n         b0:bb:f3:38:4d:2c:90:39:c0:0d:c2:5d:6b:e9:e2:e5:d5:88:\n         8d:d6:2c:bf:ab:1b:be:b5:28:87:12:17:74:6e:fc:7d:fc:8f:\n         d0:87:26:b0:1b:fb:b9:6c:ab:e2:9e:3d:15:c1:3b:2e:67:02:\n         58:91:9f:ef:f8:42:1f:2c:b7:68:f5:75:ad:cf:b5:f6:ff:11:\n         7d:c2:f0:24:a5:ad:d3:fa:a0:3c:a9:fa:5d:dc:a5:a0:ef:44:\n         a4:be:d6:e8:e5:e4:13:96:17:7b:06:3e:32:ed:c7:b7:42:bc:\n         76:a3:d8:65:38:2b:38:35:51:21:0e:0e:6f:2e:34:13:40:e1:\n         2b:67:0c:6d:4a:41:30:18:23:5a:32:55:99:c9:17:e0:3c:de:\n         f6:ec:79:ad:2b:58:19:a2:ad:2c:22:1a:95:8e:be:96:90:5d:\n         42:57:c4:f9:14:03:35:2b:1c:2d:51:57:08:a7:3a:de:3f:e4:\n         c8:b4:03:73:c2:c1:26:80:bb:0b:42:1f:ad:0d:af:26:72:da:\n         cc:be:b3:a3:83:58:0d:82:c5:1f:46:51:e3:9c:18:cc:8d:9b:\n         8d:ec:49:eb:75:50:d5:8c:28:59:ca:74:34:da:8c:0b:21:ab:\n         1e:ea:1b:e5:c7:fd:15:3e:c0:17:aa:fb:23:6e:26:46:cb:fa:\n         f9:b1:72:6b:69:cf:22:84:0b:62:0f:ac:d9:19:00:94:a2:76:\n         3c:d4:2d:9a:ed:04:9e:2d:06:62:10:37:52:1c:85:72:1b:27:\n         e5:cc:c6:31:ec:37:ec:63:59:9b:0b:1d:76:cc:7e:32:9a:88:\n         95:08:36:52:bb:de:76:5f:76:49:49:ad:7f:bd:65:20:b2:c9:\n         c1:2b:76:18:76:9f:56:b1\nSHA1 Fingerprint=A3:A1:B0:6F:24:61:23:4A:E3:36:A5:C2:37:FC:A6:FF:DD:F0:D7:3A\n",
    "d9fe21406e949ebc9b3d9c7d982019e58c3062b2": "-----BEGIN CERTIFICATE-----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\n1uwJ\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 2711694510199101698 (0x25a1dfca33cb5902)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor RootCert CA-2\n        Validity\n            Not Before: Feb  4 12:32:23 2016 GMT\n            Not After : Dec 31 17:26:39 2034 GMT\n        Subject: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor RootCert CA-2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:a7:20:6e:c2:2a:a2:62:24:95:90:76:c8:38:7e:\n                    80:d2:ab:c1:9b:65:05:94:f4:c1:0a:10:d5:02:ac:\n                    ed:9f:93:c7:87:c8:b0:27:2b:42:0c:3d:0a:3e:41:\n                    5a:9e:75:dd:8d:ca:e0:9b:ec:68:32:a4:69:92:68:\n                    8c:0b:81:0e:56:a0:3e:1a:dd:2c:25:14:82:2f:97:\n                    d3:64:46:f4:54:a9:dc:3a:54:2d:31:2b:99:82:f2:\n                    d9:2a:d7:ef:71:00:b8:31:a4:be:7a:24:07:c3:42:\n                    20:f2:8a:d4:92:04:1b:65:56:4c:6c:d4:fb:b6:61:\n                    5a:47:23:b4:d8:69:b4:b7:3a:d0:74:3c:0c:75:a1:\n                    8c:4e:76:a1:e9:db:2a:a5:3b:fa:ce:b0:ff:7e:6a:\n                    28:fd:27:1c:c8:b1:e9:29:f1:57:6e:64:b4:d0:c1:\n                    15:6d:0e:be:2e:0e:46:c8:5e:f4:51:fe:ef:0e:63:\n                    3a:3b:71:ba:cf:6f:59:ca:0c:e3:9b:5d:49:b8:4c:\n                    e2:57:b1:98:8a:42:57:9c:76:ef:ef:bd:d1:68:a8:\n                    d2:f4:09:bb:77:35:be:25:82:08:c4:16:2c:44:20:\n                    56:a9:44:11:77:ef:5d:b4:1d:aa:5e:6b:3e:8b:32:\n                    f6:07:2f:57:04:92:ca:f5:fe:9d:c2:e9:e8:b3:8e:\n                    4c:4b:02:31:d9:e4:3c:48:82:27:f7:18:82:76:48:\n                    3a:71:b1:13:a1:39:d5:2e:c5:34:c2:1d:62:85:df:\n                    03:fe:4d:f4:af:3d:df:5c:5b:8d:fa:70:e1:a5:7e:\n                    27:c7:86:2e:6a:8f:12:c6:84:5e:43:51:50:9c:19:\n                    9b:78:e6:fc:f6:ed:47:7e:7b:3d:66:ef:13:13:88:\n                    5f:3c:a1:63:fb:f9:ac:87:35:9f:f3:82:9e:a4:3f:\n                    0a:9c:31:69:8b:99:a4:88:4a:8e:6e:66:4d:ef:16:\n                    c4:0f:79:28:21:60:0d:85:16:7d:d7:54:38:f1:92:\n                    56:fd:b5:33:4c:83:dc:d7:10:9f:4b:fd:c6:f8:42:\n                    bd:ba:7c:73:02:e0:ff:7d:cd:5b:e1:d4:ac:61:7b:\n                    57:d5:4a:7b:5b:d4:85:58:27:5d:bf:f8:2b:60:ac:\n                    a0:26:ae:14:21:27:c6:77:9a:33:80:3c:5e:46:3f:\n                    f7:c3:b1:a3:86:33:c6:e8:5e:0d:b9:35:2c:aa:46:\n                    c1:85:02:75:80:a0:eb:24:fb:15:aa:e4:67:7f:6e:\n                    77:3f:f4:04:8a:2f:7c:7b:e3:17:61:f0:dd:09:a9:\n                    20:c8:be:09:a4:d0:7e:44:c3:b2:30:4a:38:aa:a9:\n                    ec:18:9a:07:82:2b:db:b8:9c:18:ad:da:e0:46:17:\n                    ac:cf:5d\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                D9:FE:21:40:6E:94:9E:BC:9B:3D:9C:7D:98:20:19:E5:8C:30:62:B2\n            X509v3 Authority Key Identifier: \n                keyid:D9:FE:21:40:6E:94:9E:BC:9B:3D:9C:7D:98:20:19:E5:8C:30:62:B2\n\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         9e:45:9e:0c:3b:b6:ef:e1:3a:c8:7c:d1:00:3d:cf:e2:ea:06:\n         b5:b2:3a:bb:06:4b:68:7a:d0:23:97:74:a7:2c:f0:08:d8:79:\n         5a:d7:5a:84:8a:d8:12:9a:1b:d9:7d:5c:4d:70:c5:a5:f9:ab:\n         e5:a3:89:89:dd:01:fa:ec:dd:f9:e9:92:97:db:b0:46:42:f3:\n         d3:62:aa:95:fe:31:67:14:69:58:90:0a:aa:0b:ee:37:23:c7:\n         50:51:b4:f5:7e:9e:e3:7b:f7:e4:cc:42:32:2d:49:0c:cb:ff:\n         49:0c:9b:1e:34:fd:6e:6e:96:8a:79:03:b6:6f:db:09:cb:fd:\n         5f:65:14:37:e1:38:f5:f3:61:16:58:e4:b5:6d:0d:0b:04:1b:\n         3f:50:2d:7f:b3:c7:7a:1a:16:80:60:f8:8a:1f:e9:1b:2a:c6:\n         f9:ba:01:1a:69:bf:d2:58:c7:54:57:08:8f:e1:39:60:77:4b:\n         ac:59:84:1a:88:f1:dd:cb:4f:78:d7:e7:e1:33:2d:fc:ee:41:\n         fa:20:b0:be:cb:f7:38:94:c0:e1:d0:85:0f:bb:ed:2c:73:ab:\n         ed:fe:92:76:1a:64:7f:5b:0d:33:09:07:33:7b:06:3f:11:a4:\n         5c:70:3c:85:c0:cf:e3:90:a8:83:77:fa:db:e6:c5:8c:68:67:\n         10:67:a5:52:2d:f0:c4:99:8f:7f:bf:d1:6b:e2:b5:47:d6:d9:\n         d0:85:99:4d:94:9b:0f:4b:8d:ee:00:5a:47:1d:11:03:ac:41:\n         18:af:87:b7:6f:0c:3a:8f:ca:cf:dc:03:c1:a2:09:c8:e5:fd:\n         80:5e:c8:60:42:01:1b:1a:53:5a:bb:37:a6:b7:bc:ba:84:e9:\n         1e:6c:1a:d4:64:da:d4:43:fe:93:8b:4b:f2:2c:79:16:10:d4:\n         93:0b:88:8f:a1:d8:86:14:46:91:47:9b:28:24:ef:57:52:4e:\n         5c:42:9c:aa:f7:49:ec:27:e8:40:1e:b3:a6:89:22:72:9c:f5:\n         0d:33:b4:58:a3:30:3b:dd:d4:6a:54:93:be:1a:4d:f3:93:94:\n         f7:fc:84:0b:3f:84:20:5c:34:03:44:c5:da:ad:bc:0a:c1:02:\n         cf:1e:e5:94:d9:f3:8e:5b:d8:4c:f0:9d:ec:61:17:bb:14:32:\n         54:0c:02:29:93:1e:92:86:f6:7f:ef:e7:92:05:0e:59:dd:99:\n         08:2e:2e:fa:9c:00:52:d3:c5:66:29:e4:a7:97:44:a4:0e:28:\n         81:13:35:c5:f6:6f:64:e6:41:c4:d5:2f:cc:34:45:25:cf:41:\n         00:96:3d:4a:2e:c2:96:98:4f:4e:4a:9c:97:b7:db:1f:92:32:\n         c8:ff:0f:51:6e:d6:ec:09\nSHA1 Fingerprint=B8:BE:6D:CB:56:F1:55:B9:63:D4:12:CA:4E:06:34:C7:94:B2:1C:C0\n",
    "dd040907a2f57a7d5253129295ee3880250da659": "-----BEGIN CERTIFICATE-----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\nIc2wBlX7Jz9TkHCpBB5XJ7k=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 8875640296558310041 (0x7b2c9bd316803299)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com Root Certification Authority RSA\n        Validity\n            Not Before: Feb 12 17:39:39 2016 GMT\n            Not After : Feb 12 17:39:39 2041 GMT\n        Subject: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com Root Certification Authority RSA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:f9:0f:dd:a3:2b:7d:cb:d0:2a:fe:ec:67:85:a6:\n                    e7:2e:1b:ba:77:e1:e3:f5:af:a4:ec:fa:4a:5d:91:\n                    c4:57:47:6b:18:77:6b:76:f2:fd:93:e4:3d:0f:c2:\n                    16:9e:0b:66:c3:56:94:9e:17:83:85:ce:56:ef:f2:\n                    16:fd:00:62:f5:22:09:54:e8:65:17:4e:41:b9:e0:\n                    4f:46:97:aa:1b:c8:b8:6e:62:5e:69:b1:5f:db:2a:\n                    02:7e:fc:6c:ca:f3:41:d8:ed:d0:e8:fc:3f:61:48:\n                    ed:b0:03:14:1d:10:0e:4b:19:e0:bb:4e:ec:86:65:\n                    ff:36:f3:5e:67:02:0b:9d:86:55:61:fd:7a:38:ed:\n                    fe:e2:19:00:b7:6f:a1:50:62:75:74:3c:a0:fa:c8:\n                    25:92:b4:6e:7a:22:c7:f8:1e:a1:e3:b2:dd:91:31:\n                    ab:2b:1d:04:ff:a5:4a:04:37:e9:85:a4:33:2b:fd:\n                    e2:d6:55:34:7c:19:a4:4a:68:c7:b2:a8:d3:b7:ca:\n                    a1:93:88:eb:c1:97:bc:8c:f9:1d:d9:22:84:24:74:\n                    c7:04:3d:6a:a9:29:93:cc:eb:b8:5b:e1:fe:5f:25:\n                    aa:34:58:c8:c1:23:54:9d:1b:98:11:c3:38:9c:7e:\n                    3d:86:6c:a5:0f:40:86:7c:02:f4:5c:02:4f:28:cb:\n                    ae:71:9f:0f:3a:c8:33:fe:11:25:35:ea:fc:ba:c5:\n                    60:3d:d9:7c:18:d5:b2:a9:d3:75:78:03:72:22:ca:\n                    3a:c3:1f:ef:2c:e5:2e:a9:fa:9e:2c:b6:51:46:fd:\n                    af:03:d6:ea:60:68:ea:85:16:36:6b:85:e9:1e:c0:\n                    b3:dd:c4:24:dc:80:2a:81:41:6d:94:3e:c8:e0:c9:\n                    81:41:00:9e:5e:bf:7f:c5:08:98:a2:18:2c:42:40:\n                    b3:f9:6f:38:27:4b:4e:80:f4:3d:81:47:e0:88:7c:\n                    ea:1c:ce:b5:75:5c:51:2e:1c:2b:7f:1a:72:28:e7:\n                    00:b5:d1:74:c6:d7:e4:9f:ad:07:93:b6:53:35:35:\n                    fc:37:e4:c3:f6:5d:16:be:21:73:de:92:0a:f8:a0:\n                    63:6a:bc:96:92:6a:3e:f8:bc:65:55:9b:de:f5:0d:\n                    89:26:04:fc:25:1a:a6:25:69:cb:c2:6d:ca:7c:e2:\n                    59:5f:97:ac:eb:ef:2e:c8:bc:d7:1b:59:3c:2b:cc:\n                    f2:19:c8:93:6b:27:63:19:cf:fc:e9:26:f8:ca:71:\n                    9b:7f:93:fe:34:67:84:4e:99:eb:fc:b3:78:09:33:\n                    70:ba:66:a6:76:ed:1b:73:eb:1a:a5:0d:c4:22:13:\n                    20:94:56:0a:4e:2c:6c:4e:b1:fd:cf:9c:09:ba:a2:\n                    33:ed:87\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                DD:04:09:07:A2:F5:7A:7D:52:53:12:92:95:EE:38:80:25:0D:A6:59\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Authority Key Identifier: \n                keyid:DD:04:09:07:A2:F5:7A:7D:52:53:12:92:95:EE:38:80:25:0D:A6:59\n\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         20:18:11:94:29:fb:26:9d:1c:1e:1e:70:61:f1:95:72:93:71:\n         24:ad:68:93:58:8e:32:af:1b:b3:70:03:fc:25:2b:74:85:90:\n         3d:78:6a:f4:b9:8b:a5:97:3b:b5:18:91:bb:1e:a7:f9:40:5b:\n         91:f9:55:99:af:1e:11:d0:5c:1d:a7:66:e3:b1:94:07:0c:32:\n         39:a6:ea:1b:b0:79:d8:1d:9c:70:44:e3:8a:dd:c4:f9:95:1f:\n         8a:38:43:3f:01:85:a5:47:a7:3d:46:b2:bc:e5:22:68:f7:7b:\n         9c:d8:2c:3e:0a:21:c8:2d:33:ac:bf:c5:81:99:31:74:c1:75:\n         71:c5:be:b1:f0:23:45:f4:9d:6b:fc:19:63:9d:a3:bc:04:c6:\n         18:0b:25:bb:53:89:0f:b3:80:50:de:45:ee:44:7f:ab:94:78:\n         64:98:d3:f6:28:dd:87:d8:70:65:74:fb:0e:b9:13:eb:a7:0f:\n         61:a9:32:96:cc:de:bb:ed:63:4c:18:bb:a9:40:f7:a0:54:6e:\n         20:88:71:75:18:ea:7a:b4:34:72:e0:23:27:77:5c:b6:90:ea:\n         86:25:40:ab:ef:33:0f:cb:9f:82:be:a2:20:fb:f6:b5:2d:1a:\n         e6:c2:85:b1:74:0f:fb:c8:65:02:a4:52:01:47:dd:49:22:c1:\n         bf:d8:eb:6b:ac:7e:de:ec:63:33:15:b7:23:08:8f:c6:0f:8d:\n         41:5a:dd:8e:c5:b9:8f:e5:45:3f:78:db:ba:d2:1b:40:b1:fe:\n         71:4d:3f:e0:81:a2:ba:5e:b4:ec:15:e0:93:dd:08:1f:7e:e1:\n         55:99:0b:21:de:93:9e:0a:fb:e6:a3:49:bd:36:30:fe:e7:77:\n         b2:a0:75:97:b5:2d:81:88:17:65:20:f7:da:90:00:9f:c9:52:\n         cc:32:ca:35:7c:f5:3d:0f:d8:2b:d7:f5:26:6c:c9:06:34:96:\n         16:ea:70:59:1a:32:79:79:0b:b6:88:7f:0f:52:48:3d:bf:6c:\n         d8:a2:44:2e:d1:4e:b7:72:58:d3:89:13:95:fe:44:ab:f8:d7:\n         8b:1b:6e:9c:bc:2c:a0:5b:d5:6a:00:af:5f:37:e1:d5:fa:10:\n         0b:98:9c:86:e7:26:8f:ce:f0:ec:6e:8a:57:0b:80:e3:4e:b2:\n         c0:a0:63:61:90:ba:55:68:37:74:6a:b6:92:db:9f:a1:86:22:\n         b6:65:27:0e:ec:b6:9f:42:60:e4:67:c2:b5:da:41:0b:c4:d3:\n         8b:61:1b:bc:fa:1f:91:2b:d7:44:07:5e:ba:29:ac:d9:c5:e9:\n         ef:53:48:5a:eb:80:f1:28:58:21:cd:b0:06:55:fb:27:3f:53:\n         90:70:a9:04:1e:57:27:b9\nSHA1 Fingerprint=B7:AB:33:08:D1:EA:44:77:BA:14:80:12:5A:6F:BD:A9:36:49:0C:BB\n",
    "e08c9bdb2549b3f17c86d6b242870bd06ba0d9e4": "-----BEGIN CERTIFICATE-----\nMIIDODCCAiCgAwIBAgIGIAYFFnACMA0GCSqGSIb3DQEBBQUAMDsxCzAJBgNVBAYT\nAlJPMREwDwYDVQQKEwhjZXJ0U0lHTjEZMBcGA1UECxMQY2VydFNJR04gUk9PVCBD\nQTAeFw0wNjA3MDQxNzIwMDRaFw0zMTA3MDQxNzIwMDRaMDsxCzAJBgNVBAYTAlJP\nMREwDwYDVQQKEwhjZXJ0U0lHTjEZMBcGA1UECxMQY2VydFNJR04gUk9PVCBDQTCC\nASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALczuX7IJUqOtdu0KBuqV5Do\n0SLTZLrTk+jUrIZhQGpgV2hUhE28alQCBf/fm5oqrl0Hj0rDKH/v+yv6efHHrfAQ\nUySQi2bJqIirr1qjAOm+ukbuW3N7LBeCgV5iLKECZbO9xSsAfsT8AzNXDe3i+s5d\nRdY4zTW2ssHQnIFKquSyAVwdj1+ZxLGt24gh65AIgoDzMKND5pCCrlUoSe1b16kQ\nOA7+j0xbm0bqQfWwCHTD0IgztnzXdN/chNFDDnU5oSVAKOp4yw4sLjmdjItuFhwv\nJoIQ4uNllAoEwF73XVv4EOLQunpL+943AAAaWyjj0pxzPjKHmKHJUS/X3qwzs08C\nAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAcYwHQYDVR0O\nBBYEFOCMm9slSbPxfIbWskKHC9BroNnkMA0GCSqGSIb3DQEBBQUAA4IBAQA+0hyJ\nLjX8+HXd5n9liPRyTMks1zJO890ZeUe9jjtbkw9QSSQTaxQGcu8J06Gh40CEyecY\nMnQ8SG4Pn0vU9x7Tk4ZkVJdjclDVVc/6IJMCopvDI5NOFlV2oHB5bc0hH88vLbwZ\n44gx+FkagQnIl6Z0x2DEW8xXjrJ1/RsCCdtZb3KTafcxQdaIOL+Hsr0Wefmq5L6I\nJd1hJyMctTEHBDa0GpC9oHRxUIltvBTjD4au8as+x6AJzKNI0eDbZOeStc+vckNw\ni/nDhDwTqn6Sm1dTk/pwwpEOMfmbZ13pljheX7NzTogVZ96edhBiIL5VaZVDADlN\n9u6wWk5JRFRYX0KD\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 35210227249154 (0x200605167002)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=RO, O=certSIGN, OU=certSIGN ROOT CA\n        Validity\n            Not Before: Jul  4 17:20:04 2006 GMT\n            Not After : Jul  4 17:20:04 2031 GMT\n        Subject: C=RO, O=certSIGN, OU=certSIGN ROOT CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:b7:33:b9:7e:c8:25:4a:8e:b5:db:b4:28:1b:aa:\n                    57:90:e8:d1:22:d3:64:ba:d3:93:e8:d4:ac:86:61:\n                    40:6a:60:57:68:54:84:4d:bc:6a:54:02:05:ff:df:\n                    9b:9a:2a:ae:5d:07:8f:4a:c3:28:7f:ef:fb:2b:fa:\n                    79:f1:c7:ad:f0:10:53:24:90:8b:66:c9:a8:88:ab:\n                    af:5a:a3:00:e9:be:ba:46:ee:5b:73:7b:2c:17:82:\n                    81:5e:62:2c:a1:02:65:b3:bd:c5:2b:00:7e:c4:fc:\n                    03:33:57:0d:ed:e2:fa:ce:5d:45:d6:38:cd:35:b6:\n                    b2:c1:d0:9c:81:4a:aa:e4:b2:01:5c:1d:8f:5f:99:\n                    c4:b1:ad:db:88:21:eb:90:08:82:80:f3:30:a3:43:\n                    e6:90:82:ae:55:28:49:ed:5b:d7:a9:10:38:0e:fe:\n                    8f:4c:5b:9b:46:ea:41:f5:b0:08:74:c3:d0:88:33:\n                    b6:7c:d7:74:df:dc:84:d1:43:0e:75:39:a1:25:40:\n                    28:ea:78:cb:0e:2c:2e:39:9d:8c:8b:6e:16:1c:2f:\n                    26:82:10:e2:e3:65:94:0a:04:c0:5e:f7:5d:5b:f8:\n                    10:e2:d0:ba:7a:4b:fb:de:37:00:00:1a:5b:28:e3:\n                    d2:9c:73:3e:32:87:98:a1:c9:51:2f:d7:de:ac:33:\n                    b3:4f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Non Repudiation, Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                E0:8C:9B:DB:25:49:B3:F1:7C:86:D6:B2:42:87:0B:D0:6B:A0:D9:E4\n    Signature Algorithm: sha1WithRSAEncryption\n         3e:d2:1c:89:2e:35:fc:f8:75:dd:e6:7f:65:88:f4:72:4c:c9:\n         2c:d7:32:4e:f3:dd:19:79:47:bd:8e:3b:5b:93:0f:50:49:24:\n         13:6b:14:06:72:ef:09:d3:a1:a1:e3:40:84:c9:e7:18:32:74:\n         3c:48:6e:0f:9f:4b:d4:f7:1e:d3:93:86:64:54:97:63:72:50:\n         d5:55:cf:fa:20:93:02:a2:9b:c3:23:93:4e:16:55:76:a0:70:\n         79:6d:cd:21:1f:cf:2f:2d:bc:19:e3:88:31:f8:59:1a:81:09:\n         c8:97:a6:74:c7:60:c4:5b:cc:57:8e:b2:75:fd:1b:02:09:db:\n         59:6f:72:93:69:f7:31:41:d6:88:38:bf:87:b2:bd:16:79:f9:\n         aa:e4:be:88:25:dd:61:27:23:1c:b5:31:07:04:36:b4:1a:90:\n         bd:a0:74:71:50:89:6d:bc:14:e3:0f:86:ae:f1:ab:3e:c7:a0:\n         09:cc:a3:48:d1:e0:db:64:e7:92:b5:cf:af:72:43:70:8b:f9:\n         c3:84:3c:13:aa:7e:92:9b:57:53:93:fa:70:c2:91:0e:31:f9:\n         9b:67:5d:e9:96:38:5e:5f:b3:73:4e:88:15:67:de:9e:76:10:\n         62:20:be:55:69:95:43:00:39:4d:f6:ee:b0:5a:4e:49:44:54:\n         58:5f:42:83\nSHA1 Fingerprint=FA:B7:EE:36:97:26:62:FB:2D:B0:2A:F6:BF:03:FD:E8:7C:4B:2F:9B\n",
    "e2c9409f4dcee89aa17ccf0e3f65c529886a1951": "-----BEGIN CERTIFICATE-----\nMIIFiDCCA3CgAwIBAgIIfQmX/vBH6nowDQYJKoZIhvcNAQELBQAwYjELMAkGA1UE\nBhMCQ04xMjAwBgNVBAoMKUdVQU5HIERPTkcgQ0VSVElGSUNBVEUgQVVUSE9SSVRZ\nIENPLixMVEQuMR8wHQYDVQQDDBZHRENBIFRydXN0QVVUSCBSNSBST09UMB4XDTE0\nMTEyNjA1MTMxNVoXDTQwMTIzMTE1NTk1OVowYjELMAkGA1UEBhMCQ04xMjAwBgNV\nBAoMKUdVQU5HIERPTkcgQ0VSVElGSUNBVEUgQVVUSE9SSVRZIENPLixMVEQuMR8w\nHQYDVQQDDBZHRENBIFRydXN0QVVUSCBSNSBST09UMIICIjANBgkqhkiG9w0BAQEF\nAAOCAg8AMIICCgKCAgEA2aMW8Mh0dHeb7zMNOwZ+Vfy1YI92hhJCfVZmPoiC7XJj\nDp6L3TQsAlFRwxn9WVSEyfFrs0yw6ehGXTjGoqcuEVe6ghWinI9tsJlKCvLriXBj\nTnnEt1u9ol2x8kECK62pOqPseQrsXzrj/e+APK00mxqriCZ7VqKChh/rNYmDf1+u\nKU49tm7srsHwJ5uu4/Ts765/94Y9cnrrpftZTqfrlYwiOXnhLQiPzLyRuEH3FMEj\nqcOtmkVEs7LXLM3GKeJQEK5cy4KOFxg2fZfmiJqwTTQJ9Cy5WmYqsBebnh52nUpm\nMUHfP/vFBu8btn4aRjb3ZGM74zkYI+dndRTVdVeSN72+ahsmUPI2JgaQxXABZG12\nZuGR224HwGGALrIuL4xwp9E7PLOR5G62xDtw8mySlwnNR30YwPO7ng/Wi64HtloP\nzgsMR6flPri9fcebNaBhlzpBdRfMK5Z3KpIhHtmVdiBnaM8Nvd/WHwlqmuLMc3Gk\nL30SgLdTMEZeS1SZD2fJpcjyIMGC7J0R38IC+xo70e0gmu9lZJIQDSri3nDxGGeC\njGHeuLzRL5z7D9Ar7Rt2ueQ5Vfj4oR24qoAATILnsn8JuLwwoC8N9VKejveSswoA\nHQBUlwbgsQfZxw9cZX08bVlX5O2ljelAU58VS6Bx9hoh49pwBiFYFIeFd3mqgnkC\nAwEAAaNCMEAwHQYDVR0OBBYEFOLJQJ9NzuiaoXzPDj9lxSmIahlRMA8GA1UdEwEB\n/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgGGMA0GCSqGSIb3DQEBCwUAA4ICAQDRSVfg\np8xoWLoBDysZzY2wYUWsEe1jUGn4H3++Fo/9nesLqjJHdtJnJO29fDMylyrHBYZm\nDRd9FBUb1Ov9H5r2XpdptxolpAqzkT9fNqyL7FeoPueBihhXOYV0GkLH6VsTX4/5\nCOmSdI31R9KrO9b7eGZONn356ZLpBN79SWP8bfsUcZNnL0dKt7n/HipzcEYwv1ry\nL3ml4Y0M2fmyYzeMN2WFcGpcWwlyua1jPLHd+PwyvzeG5LuOmCd+uh8W4XAR8gPf\nJWIyJyYYMoSf/wA6E7qaTfRPuBRwIrHKK5DOKcFw9C+df/KQHtZa37dG/OaG+svg\nIHZ6uqbL9XzeYqWxi+7egmaKTjowHz+Ay60nugxe19CxVsp3cbK1daFQqUBDF8Io\n2c9Si1vIY9RCPqAzekYu9wogRlR+ak8x8YF+QnQ4ZXMn7sZ8uI7XpTrXmKGcjBBV\n09tL7ECQ8s1uV9JiDnxXk7Gnbc2dg7sq5+W2O3FYrf3RRbxake5TFW/TRQl1brqQ\nXR4EzzffHqhmsYzmIGrv/EhOdJhCrylvLmrH+33RZjEizIYAfmaDDEL0vTSSwxrq\nT8p+ck0LcIymSLumoRT2+1hEmRSuqguTaaApJUqlyyvdimYHFngVV3Eb7PVHhPOe\nMTd61X8kreS8/f3MboPoDKi3QWwH3b08hpcv0g==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 9009899650740120186 (0x7d0997fef047ea7a)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=CN, O=GUANG DONG CERTIFICATE AUTHORITY CO.,LTD., CN=GDCA TrustAUTH R5 ROOT\n        Validity\n            Not Before: Nov 26 05:13:15 2014 GMT\n            Not After : Dec 31 15:59:59 2040 GMT\n        Subject: C=CN, O=GUANG DONG CERTIFICATE AUTHORITY CO.,LTD., CN=GDCA TrustAUTH R5 ROOT\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:d9:a3:16:f0:c8:74:74:77:9b:ef:33:0d:3b:06:\n                    7e:55:fc:b5:60:8f:76:86:12:42:7d:56:66:3e:88:\n                    82:ed:72:63:0e:9e:8b:dd:34:2c:02:51:51:c3:19:\n                    fd:59:54:84:c9:f1:6b:b3:4c:b0:e9:e8:46:5d:38:\n                    c6:a2:a7:2e:11:57:ba:82:15:a2:9c:8f:6d:b0:99:\n                    4a:0a:f2:eb:89:70:63:4e:79:c4:b7:5b:bd:a2:5d:\n                    b1:f2:41:02:2b:ad:a9:3a:a3:ec:79:0a:ec:5f:3a:\n                    e3:fd:ef:80:3c:ad:34:9b:1a:ab:88:26:7b:56:a2:\n                    82:86:1f:eb:35:89:83:7f:5f:ae:29:4e:3d:b6:6e:\n                    ec:ae:c1:f0:27:9b:ae:e3:f4:ec:ef:ae:7f:f7:86:\n                    3d:72:7a:eb:a5:fb:59:4e:a7:eb:95:8c:22:39:79:\n                    e1:2d:08:8f:cc:bc:91:b8:41:f7:14:c1:23:a9:c3:\n                    ad:9a:45:44:b3:b2:d7:2c:cd:c6:29:e2:50:10:ae:\n                    5c:cb:82:8e:17:18:36:7d:97:e6:88:9a:b0:4d:34:\n                    09:f4:2c:b9:5a:66:2a:b0:17:9b:9e:1e:76:9d:4a:\n                    66:31:41:df:3f:fb:c5:06:ef:1b:b6:7e:1a:46:36:\n                    f7:64:63:3b:e3:39:18:23:e7:67:75:14:d5:75:57:\n                    92:37:bd:be:6a:1b:26:50:f2:36:26:06:90:c5:70:\n                    01:64:6d:76:66:e1:91:db:6e:07:c0:61:80:2e:b2:\n                    2e:2f:8c:70:a7:d1:3b:3c:b3:91:e4:6e:b6:c4:3b:\n                    70:f2:6c:92:97:09:cd:47:7d:18:c0:f3:bb:9e:0f:\n                    d6:8b:ae:07:b6:5a:0f:ce:0b:0c:47:a7:e5:3e:b8:\n                    bd:7d:c7:9b:35:a0:61:97:3a:41:75:17:cc:2b:96:\n                    77:2a:92:21:1e:d9:95:76:20:67:68:cf:0d:bd:df:\n                    d6:1f:09:6a:9a:e2:cc:73:71:a4:2f:7d:12:80:b7:\n                    53:30:46:5e:4b:54:99:0f:67:c9:a5:c8:f2:20:c1:\n                    82:ec:9d:11:df:c2:02:fb:1a:3b:d1:ed:20:9a:ef:\n                    65:64:92:10:0d:2a:e2:de:70:f1:18:67:82:8c:61:\n                    de:b8:bc:d1:2f:9c:fb:0f:d0:2b:ed:1b:76:b9:e4:\n                    39:55:f8:f8:a1:1d:b8:aa:80:00:4c:82:e7:b2:7f:\n                    09:b8:bc:30:a0:2f:0d:f5:52:9e:8e:f7:92:b3:0a:\n                    00:1d:00:54:97:06:e0:b1:07:d9:c7:0f:5c:65:7d:\n                    3c:6d:59:57:e4:ed:a5:8d:e9:40:53:9f:15:4b:a0:\n                    71:f6:1a:21:e3:da:70:06:21:58:14:87:85:77:79:\n                    aa:82:79\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                E2:C9:40:9F:4D:CE:E8:9A:A1:7C:CF:0E:3F:65:C5:29:88:6A:19:51\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         d1:49:57:e0:a7:cc:68:58:ba:01:0f:2b:19:cd:8d:b0:61:45:\n         ac:11:ed:63:50:69:f8:1f:7f:be:16:8f:fd:9d:eb:0b:aa:32:\n         47:76:d2:67:24:ed:bd:7c:33:32:97:2a:c7:05:86:66:0d:17:\n         7d:14:15:1b:d4:eb:fd:1f:9a:f6:5e:97:69:b7:1a:25:a4:0a:\n         b3:91:3f:5f:36:ac:8b:ec:57:a8:3e:e7:81:8a:18:57:39:85:\n         74:1a:42:c7:e9:5b:13:5f:8f:f9:08:e9:92:74:8d:f5:47:d2:\n         ab:3b:d6:fb:78:66:4e:36:7d:f9:e9:92:e9:04:de:fd:49:63:\n         fc:6d:fb:14:71:93:67:2f:47:4a:b7:b9:ff:1e:2a:73:70:46:\n         30:bf:5a:f2:2f:79:a5:e1:8d:0c:d9:f9:b2:63:37:8c:37:65:\n         85:70:6a:5c:5b:09:72:b9:ad:63:3c:b1:dd:f8:fc:32:bf:37:\n         86:e4:bb:8e:98:27:7e:ba:1f:16:e1:70:11:f2:03:df:25:62:\n         32:27:26:18:32:84:9f:ff:00:3a:13:ba:9a:4d:f4:4f:b8:14:\n         70:22:b1:ca:2b:90:ce:29:c1:70:f4:2f:9d:7f:f2:90:1e:d6:\n         5a:df:b7:46:fc:e6:86:fa:cb:e0:20:76:7a:ba:a6:cb:f5:7c:\n         de:62:a5:b1:8b:ee:de:82:66:8a:4e:3a:30:1f:3f:80:cb:ad:\n         27:ba:0c:5e:d7:d0:b1:56:ca:77:71:b2:b5:75:a1:50:a9:40:\n         43:17:c2:28:d9:cf:52:8b:5b:c8:63:d4:42:3e:a0:33:7a:46:\n         2e:f7:0a:20:46:54:7e:6a:4f:31:f1:81:7e:42:74:38:65:73:\n         27:ee:c6:7c:b8:8e:d7:a5:3a:d7:98:a1:9c:8c:10:55:d3:db:\n         4b:ec:40:90:f2:cd:6e:57:d2:62:0e:7c:57:93:b1:a7:6d:cd:\n         9d:83:bb:2a:e7:e5:b6:3b:71:58:ad:fd:d1:45:bc:5a:91:ee:\n         53:15:6f:d3:45:09:75:6e:ba:90:5d:1e:04:cf:37:df:1e:a8:\n         66:b1:8c:e6:20:6a:ef:fc:48:4e:74:98:42:af:29:6f:2e:6a:\n         c7:fb:7d:d1:66:31:22:cc:86:00:7e:66:83:0c:42:f4:bd:34:\n         92:c3:1a:ea:4f:ca:7e:72:4d:0b:70:8c:a6:48:bb:a6:a1:14:\n         f6:fb:58:44:99:14:ae:aa:0b:93:69:a0:29:25:4a:a5:cb:2b:\n         dd:8a:66:07:16:78:15:57:71:1b:ec:f5:47:84:f3:9e:31:37:\n         7a:d5:7f:24:ad:e4:bc:fd:fd:cc:6e:83:e8:0c:a8:b7:41:6c:\n         07:dd:bd:3c:86:97:2f:d2\nSHA1 Fingerprint=0F:36:38:5B:81:1A:25:C3:9B:31:4E:83:CA:E9:34:66:70:CC:74:B4\n",
    "e371e09ed8a742d9db71916b9493ebc3a3d114a3": "-----BEGIN CERTIFICATE-----\nMIIFZjCCA06gAwIBAgIQCgFCgAAAAUUjz0Z8AAAAAjANBgkqhkiG9w0BAQsFADBN\nMQswCQYDVQQGEwJVUzESMBAGA1UEChMJSWRlblRydXN0MSowKAYDVQQDEyFJZGVu\nVHJ1c3QgUHVibGljIFNlY3RvciBSb290IENBIDEwHhcNMTQwMTE2MTc1MzMyWhcN\nMzQwMTE2MTc1MzMyWjBNMQswCQYDVQQGEwJVUzESMBAGA1UEChMJSWRlblRydXN0\nMSowKAYDVQQDEyFJZGVuVHJ1c3QgUHVibGljIFNlY3RvciBSb290IENBIDEwggIi\nMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQC2IpT8pEiv6EdrCvsnduTyP4o7\nekosMSqMjbCpwzFrqHd2hCa2rIFCDQjrVVi7evi8ZX3yoG2LqEfpYnYeEe4IFNGy\nRBb06tD6Hi9e28tzQa68ALBKK0CyrOE7S8ItneShm+waOh7wCLPQ5CQ1B5+ctMlS\nbdsHyo+1W/CD80/HLaXIrcuVIKQxKFdYWuSNG5qrng0M8gozOSI5Cpcu81N3uURF\n/YTLNiCBWS2ab21ISGHKTN9T0a9SvESfqy9rg3LvdYDaBjMbXcjaY8ZNzaxmMc3R\n3j6HEDbhuaR672BQssvKplbgN6+rNBM5Jeg5ZuSYeqoSmJxZZoY+rfGwyj4GD3vw\nEUs3oERte8uojHH01bWRNszwFcYr3lEXsZdMUD2xlVl8BX0tIdUAvwFnol57plzy\n9yLxkA2T26pEUWbMfXYD62qoKjgZl3YNa4ph+bz27nb9cCvdKTz4Ch5bQhyLVi9V\nGxyhLrXHFub4qjySjmm2AcG1hp2JDws4lFTo6tyePSW8Uybt1as5qsVATFSrsrTZ\n2fjXctscvG29ZV/viDUqZi/u9rNl8DONfJhBaUYPQxxp+pu10GFqzcpL2UyQRqsV\nWaFHVCkugyhfHMKiq3IXAAaOReyL4jM9f9oZRORicsPfIsbyVtTdX5Vy7W1f90gD\nW/3FKqD2cyOEEBsB5wIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/\nBAUwAwEB/zAdBgNVHQ4EFgQU43HgntinQtnbcZFrlJPrw6PRFKMwDQYJKoZIhvcN\nAQELBQADggIBAEf63QqwEZE4rU1d9+UOl1QZgkiHVIyqZJnYWv6IAcVYpZmxI1Qj\nt2odIFflAWJBF9MJ23XLblSQdf4an4EKwt3X9wnQW3IV5B4Jaj0z8yGa5hV+rVHV\nDRDtfULAj+7AmgjVQdZcDiFpboBhDhXAuM/FSRJSzL46zNQuOAXeNf0fb7iAaJg9\nTaDKQGXSc3z1i9kKlT/YPyNtGtEqJBnZhbMX73huqVjRI9PHE+1yJX9dsXNw0H8G\nlwmEKYBhHfpe/3OsoOOJuBxxFcbeMX8S3OFtm6/n6J91eEyrRjuazr8FGF1NFTwW\nmhlQBJqymm9li1JfPFgEKCXAZmExfrngdbkaqIHWchezxQMxNRF4eKLg6TCMf4Df\nWN88uieW4oA0beOY02QnrEh+KHdcxiVhJfiFDGX6xDIvpZgF5PgLZxYWxoK4Mhn5\n+bl53B/N66+rDt0b20XkeucC4pVd/GnwU2lhlXV5C15V5jgclKlZM57IcXR5f1GJ\ntshquDDIajjDbp7hNxbqBWJMWxJH7ae0s1hWx0nzfxJoCTFx8G34Tkf71oXuxVhA\nGaQdp/lLQzfcaFpPz+vCZHTetBXZ9FRUGi8c15dxVJCO2SCdUyt/q4/i6jC8UDfv\n8Ue1fXwsBOxonbRJRBD0ckscZOf85muQ3Wl9af0AVqW3rLatt8o+Ae+c\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            0a:01:42:80:00:00:01:45:23:cf:46:7c:00:00:00:02\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, O=IdenTrust, CN=IdenTrust Public Sector Root CA 1\n        Validity\n            Not Before: Jan 16 17:53:32 2014 GMT\n            Not After : Jan 16 17:53:32 2034 GMT\n        Subject: C=US, O=IdenTrust, CN=IdenTrust Public Sector Root CA 1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:b6:22:94:fc:a4:48:af:e8:47:6b:0a:fb:27:76:\n                    e4:f2:3f:8a:3b:7a:4a:2c:31:2a:8c:8d:b0:a9:c3:\n                    31:6b:a8:77:76:84:26:b6:ac:81:42:0d:08:eb:55:\n                    58:bb:7a:f8:bc:65:7d:f2:a0:6d:8b:a8:47:e9:62:\n                    76:1e:11:ee:08:14:d1:b2:44:16:f4:ea:d0:fa:1e:\n                    2f:5e:db:cb:73:41:ae:bc:00:b0:4a:2b:40:b2:ac:\n                    e1:3b:4b:c2:2d:9d:e4:a1:9b:ec:1a:3a:1e:f0:08:\n                    b3:d0:e4:24:35:07:9f:9c:b4:c9:52:6d:db:07:ca:\n                    8f:b5:5b:f0:83:f3:4f:c7:2d:a5:c8:ad:cb:95:20:\n                    a4:31:28:57:58:5a:e4:8d:1b:9a:ab:9e:0d:0c:f2:\n                    0a:33:39:22:39:0a:97:2e:f3:53:77:b9:44:45:fd:\n                    84:cb:36:20:81:59:2d:9a:6f:6d:48:48:61:ca:4c:\n                    df:53:d1:af:52:bc:44:9f:ab:2f:6b:83:72:ef:75:\n                    80:da:06:33:1b:5d:c8:da:63:c6:4d:cd:ac:66:31:\n                    cd:d1:de:3e:87:10:36:e1:b9:a4:7a:ef:60:50:b2:\n                    cb:ca:a6:56:e0:37:af:ab:34:13:39:25:e8:39:66:\n                    e4:98:7a:aa:12:98:9c:59:66:86:3e:ad:f1:b0:ca:\n                    3e:06:0f:7b:f0:11:4b:37:a0:44:6d:7b:cb:a8:8c:\n                    71:f4:d5:b5:91:36:cc:f0:15:c6:2b:de:51:17:b1:\n                    97:4c:50:3d:b1:95:59:7c:05:7d:2d:21:d5:00:bf:\n                    01:67:a2:5e:7b:a6:5c:f2:f7:22:f1:90:0d:93:db:\n                    aa:44:51:66:cc:7d:76:03:eb:6a:a8:2a:38:19:97:\n                    76:0d:6b:8a:61:f9:bc:f6:ee:76:fd:70:2b:dd:29:\n                    3c:f8:0a:1e:5b:42:1c:8b:56:2f:55:1b:1c:a1:2e:\n                    b5:c7:16:e6:f8:aa:3c:92:8e:69:b6:01:c1:b5:86:\n                    9d:89:0f:0b:38:94:54:e8:ea:dc:9e:3d:25:bc:53:\n                    26:ed:d5:ab:39:aa:c5:40:4c:54:ab:b2:b4:d9:d9:\n                    f8:d7:72:db:1c:bc:6d:bd:65:5f:ef:88:35:2a:66:\n                    2f:ee:f6:b3:65:f0:33:8d:7c:98:41:69:46:0f:43:\n                    1c:69:fa:9b:b5:d0:61:6a:cd:ca:4b:d9:4c:90:46:\n                    ab:15:59:a1:47:54:29:2e:83:28:5f:1c:c2:a2:ab:\n                    72:17:00:06:8e:45:ec:8b:e2:33:3d:7f:da:19:44:\n                    e4:62:72:c3:df:22:c6:f2:56:d4:dd:5f:95:72:ed:\n                    6d:5f:f7:48:03:5b:fd:c5:2a:a0:f6:73:23:84:10:\n                    1b:01:e7\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                E3:71:E0:9E:D8:A7:42:D9:DB:71:91:6B:94:93:EB:C3:A3:D1:14:A3\n    Signature Algorithm: sha256WithRSAEncryption\n         47:fa:dd:0a:b0:11:91:38:ad:4d:5d:f7:e5:0e:97:54:19:82:\n         48:87:54:8c:aa:64:99:d8:5a:fe:88:01:c5:58:a5:99:b1:23:\n         54:23:b7:6a:1d:20:57:e5:01:62:41:17:d3:09:db:75:cb:6e:\n         54:90:75:fe:1a:9f:81:0a:c2:dd:d7:f7:09:d0:5b:72:15:e4:\n         1e:09:6a:3d:33:f3:21:9a:e6:15:7e:ad:51:d5:0d:10:ed:7d:\n         42:c0:8f:ee:c0:9a:08:d5:41:d6:5c:0e:21:69:6e:80:61:0e:\n         15:c0:b8:cf:c5:49:12:52:cc:be:3a:cc:d4:2e:38:05:de:35:\n         fd:1f:6f:b8:80:68:98:3d:4d:a0:ca:40:65:d2:73:7c:f5:8b:\n         d9:0a:95:3f:d8:3f:23:6d:1a:d1:2a:24:19:d9:85:b3:17:ef:\n         78:6e:a9:58:d1:23:d3:c7:13:ed:72:25:7f:5d:b1:73:70:d0:\n         7f:06:97:09:84:29:80:61:1d:fa:5e:ff:73:ac:a0:e3:89:b8:\n         1c:71:15:c6:de:31:7f:12:dc:e1:6d:9b:af:e7:e8:9f:75:78:\n         4c:ab:46:3b:9a:ce:bf:05:18:5d:4d:15:3c:16:9a:19:50:04:\n         9a:b2:9a:6f:65:8b:52:5f:3c:58:04:28:25:c0:66:61:31:7e:\n         b9:e0:75:b9:1a:a8:81:d6:72:17:b3:c5:03:31:35:11:78:78:\n         a2:e0:e9:30:8c:7f:80:df:58:df:3c:ba:27:96:e2:80:34:6d:\n         e3:98:d3:64:27:ac:48:7e:28:77:5c:c6:25:61:25:f8:85:0c:\n         65:fa:c4:32:2f:a5:98:05:e4:f8:0b:67:16:16:c6:82:b8:32:\n         19:f9:f9:b9:79:dc:1f:cd:eb:af:ab:0e:dd:1b:db:45:e4:7a:\n         e7:02:e2:95:5d:fc:69:f0:53:69:61:95:75:79:0b:5e:55:e6:\n         38:1c:94:a9:59:33:9e:c8:71:74:79:7f:51:89:b6:c8:6a:b8:\n         30:c8:6a:38:c3:6e:9e:e1:37:16:ea:05:62:4c:5b:12:47:ed:\n         a7:b4:b3:58:56:c7:49:f3:7f:12:68:09:31:71:f0:6d:f8:4e:\n         47:fb:d6:85:ee:c5:58:40:19:a4:1d:a7:f9:4b:43:37:dc:68:\n         5a:4f:cf:eb:c2:64:74:de:b4:15:d9:f4:54:54:1a:2f:1c:d7:\n         97:71:54:90:8e:d9:20:9d:53:2b:7f:ab:8f:e2:ea:30:bc:50:\n         37:ef:f1:47:b5:7d:7c:2c:04:ec:68:9d:b4:49:44:10:f4:72:\n         4b:1c:64:e7:fc:e6:6b:90:dd:69:7d:69:fd:00:56:a5:b7:ac:\n         b6:ad:b7:ca:3e:01:ef:9c\nSHA1 Fingerprint=BA:29:41:60:77:98:3F:F4:F3:EF:F2:31:05:3B:2E:EA:6D:4D:45:FD\n",
    "e3fe2dfd28d00bb5bab6a2c4bf06aa058c93fb2f": "-----BEGIN CERTIFICATE-----\nMIIFjTCCA3WgAwIBAgIEGErM1jANBgkqhkiG9w0BAQsFADBWMQswCQYDVQQGEwJD\nTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9y\naXR5MRUwEwYDVQQDDAxDRkNBIEVWIFJPT1QwHhcNMTIwODA4MDMwNzAxWhcNMjkx\nMjMxMDMwNzAxWjBWMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5j\naWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRUwEwYDVQQDDAxDRkNBIEVWIFJP\nT1QwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDXXWvNED8fBVnVBU03\nsQ7smCuOFR36k0sXgiFxEFLXUWRwFsJVaU2OFW2fvwwbwuCjZ9YMrM8irq93VCpL\nTIpTUnrD7i7es3ElweldPe6hL6P3KjzJIx1qqx2hp/Hz7KDVRM8Vz3IvHWOX6Jn5\n/ZOkVIBMUtRSqy5J35DNuF++P96hyk0g1CXohClTt7GIH//62pCfCqktQT+x8Rgp\n7hZZLDRJGqgG16iI0gNyejLi6mhNbiyWZXvKWfry4t3uMCz7zEasxGPrb382KzRz\nEpR/38wmnvFyXVBlWY9ps4deMm/DGIq1lY+wejfeWkU7xzbh72fROdOXW3NiGUgt\nhxwG+3SYIElz8AXSG7Ggo7cbcNOIabla1jj0Ytwli3i/+Oh+uFzJlU9fpy25IGvP\na931DfSCt/SyZi4QKPaXWnuWFo8BGS1sbn85WAZkgwGDg8NNkt0yxoekN+kWzqot\naK8KgWU6cMGbrU1tVMoqLUuFG7OA5nBFDWteNfB/O7ic5ARwiRIlk9oKmSJgamNg\nTnYGmE69g60dWIolhdLHZR4tjsbftsbhf4oEIRUpdPA+nJCdDC7xij5aqgwJHsfV\nPKPtl8MeNPo4+QgO48BdK4PRVmrJtqhUUy54Mmc9gn900PvhtgVguXDbjgv5E1hv\ncWAQUhC5wUEJ73IfZzF4/5YFjQIDAQABo2MwYTAfBgNVHSMEGDAWgBTj/i39KNAL\ntbq2osS/BqoFjJP7LzAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAd\nBgNVHQ4EFgQU4/4t/SjQC7W6tqLEvwaqBYyT+y8wDQYJKoZIhvcNAQELBQADggIB\nACXGumvrh8vegjmWPfBEp2uEcwPenStPuiB/vHiyz5ewG5zz13ku9Ui20vsXiObT\nej/tUxPQ4i9qecsAIyjmHjdXNYmEwnZPNDatZ8POQQaIxffu2Bq41gt/UP+TqhdL\njOztUmCypAbqTuv0axn96/Ua4CUqmtzHQTb3yHQFhDmVOdYLO6Qn+gjYXB74BGBS\nESgoA//vU2YApUo0FmZ8/Qmkrp5nGm9BC2sGE5uPhnEFtC+NiWYzKXZUmhH4J/qy\nP5Hgzg0b8zAarb8iXRvTvyUFTeGSGn+ZnzxEk8rUQElsgIfXBDrDMlI1Dlb4pd19\nxIsNER9Tyx6yF7Zod1rg1MvIB671Oi6ON7fQAUtDKXeMOZePglr4UeWJoBjnaH9d\nCi77o0cOPaYjesYBx4/IXr9tgFa+iiS6M+qf4TIRnvHST4D2G0CvOJ4RUHlzEhLN\n5mydLIhyPDCBBpEi6lmt2hkuIsKNuYyH4Ga8cyNfIWRjgEj1oDwYPZTISEEdQLpe\n/v5WOaHIz16eGWRGENoXkbcFgKyLmZJ956LYBws2J+dIeWCKw9cTXPhyQN9Ky8+Z\nAAoACxGV2lZFA4gKn2fQ1XmxqI1AbQ3CekD6819kR5LLU7m7Wc5P/dAVUwHY3+vZ\n5nbv0CO7O6l5s9UCKc2Jo5YPSjXnTkLAdc0Hz+Ys63su\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 407555286 (0x184accd6)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=CN, O=China Financial Certification Authority, CN=CFCA EV ROOT\n        Validity\n            Not Before: Aug  8 03:07:01 2012 GMT\n            Not After : Dec 31 03:07:01 2029 GMT\n        Subject: C=CN, O=China Financial Certification Authority, CN=CFCA EV ROOT\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:d7:5d:6b:cd:10:3f:1f:05:59:d5:05:4d:37:b1:\n                    0e:ec:98:2b:8e:15:1d:fa:93:4b:17:82:21:71:10:\n                    52:d7:51:64:70:16:c2:55:69:4d:8e:15:6d:9f:bf:\n                    0c:1b:c2:e0:a3:67:d6:0c:ac:cf:22:ae:af:77:54:\n                    2a:4b:4c:8a:53:52:7a:c3:ee:2e:de:b3:71:25:c1:\n                    e9:5d:3d:ee:a1:2f:a3:f7:2a:3c:c9:23:1d:6a:ab:\n                    1d:a1:a7:f1:f3:ec:a0:d5:44:cf:15:cf:72:2f:1d:\n                    63:97:e8:99:f9:fd:93:a4:54:80:4c:52:d4:52:ab:\n                    2e:49:df:90:cd:b8:5f:be:3f:de:a1:ca:4d:20:d4:\n                    25:e8:84:29:53:b7:b1:88:1f:ff:fa:da:90:9f:0a:\n                    a9:2d:41:3f:b1:f1:18:29:ee:16:59:2c:34:49:1a:\n                    a8:06:d7:a8:88:d2:03:72:7a:32:e2:ea:68:4d:6e:\n                    2c:96:65:7b:ca:59:fa:f2:e2:dd:ee:30:2c:fb:cc:\n                    46:ac:c4:63:eb:6f:7f:36:2b:34:73:12:94:7f:df:\n                    cc:26:9e:f1:72:5d:50:65:59:8f:69:b3:87:5e:32:\n                    6f:c3:18:8a:b5:95:8f:b0:7a:37:de:5a:45:3b:c7:\n                    36:e1:ef:67:d1:39:d3:97:5b:73:62:19:48:2d:87:\n                    1c:06:fb:74:98:20:49:73:f0:05:d2:1b:b1:a0:a3:\n                    b7:1b:70:d3:88:69:b9:5a:d6:38:f4:62:dc:25:8b:\n                    78:bf:f8:e8:7e:b8:5c:c9:95:4f:5f:a7:2d:b9:20:\n                    6b:cf:6b:dd:f5:0d:f4:82:b7:f4:b2:66:2e:10:28:\n                    f6:97:5a:7b:96:16:8f:01:19:2d:6c:6e:7f:39:58:\n                    06:64:83:01:83:83:c3:4d:92:dd:32:c6:87:a4:37:\n                    e9:16:ce:aa:2d:68:af:0a:81:65:3a:70:c1:9b:ad:\n                    4d:6d:54:ca:2a:2d:4b:85:1b:b3:80:e6:70:45:0d:\n                    6b:5e:35:f0:7f:3b:b8:9c:e4:04:70:89:12:25:93:\n                    da:0a:99:22:60:6a:63:60:4e:76:06:98:4e:bd:83:\n                    ad:1d:58:8a:25:85:d2:c7:65:1e:2d:8e:c6:df:b6:\n                    c6:e1:7f:8a:04:21:15:29:74:f0:3e:9c:90:9d:0c:\n                    2e:f1:8a:3e:5a:aa:0c:09:1e:c7:d5:3c:a3:ed:97:\n                    c3:1e:34:fa:38:f9:08:0e:e3:c0:5d:2b:83:d1:56:\n                    6a:c9:b6:a8:54:53:2e:78:32:67:3d:82:7f:74:d0:\n                    fb:e1:b6:05:60:b9:70:db:8e:0b:f9:13:58:6f:71:\n                    60:10:52:10:b9:c1:41:09:ef:72:1f:67:31:78:ff:\n                    96:05:8d\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Authority Key Identifier: \n                keyid:E3:FE:2D:FD:28:D0:0B:B5:BA:B6:A2:C4:BF:06:AA:05:8C:93:FB:2F\n\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                E3:FE:2D:FD:28:D0:0B:B5:BA:B6:A2:C4:BF:06:AA:05:8C:93:FB:2F\n    Signature Algorithm: sha256WithRSAEncryption\n         25:c6:ba:6b:eb:87:cb:de:82:39:96:3d:f0:44:a7:6b:84:73:\n         03:de:9d:2b:4f:ba:20:7f:bc:78:b2:cf:97:b0:1b:9c:f3:d7:\n         79:2e:f5:48:b6:d2:fb:17:88:e6:d3:7a:3f:ed:53:13:d0:e2:\n         2f:6a:79:cb:00:23:28:e6:1e:37:57:35:89:84:c2:76:4f:34:\n         36:ad:67:c3:ce:41:06:88:c5:f7:ee:d8:1a:b8:d6:0b:7f:50:\n         ff:93:aa:17:4b:8c:ec:ed:52:60:b2:a4:06:ea:4e:eb:f4:6b:\n         19:fd:eb:f5:1a:e0:25:2a:9a:dc:c7:41:36:f7:c8:74:05:84:\n         39:95:39:d6:0b:3b:a4:27:fa:08:d8:5c:1e:f8:04:60:52:11:\n         28:28:03:ff:ef:53:66:00:a5:4a:34:16:66:7c:fd:09:a4:ae:\n         9e:67:1a:6f:41:0b:6b:06:13:9b:8f:86:71:05:b4:2f:8d:89:\n         66:33:29:76:54:9a:11:f8:27:fa:b2:3f:91:e0:ce:0d:1b:f3:\n         30:1a:ad:bf:22:5d:1b:d3:bf:25:05:4d:e1:92:1a:7f:99:9f:\n         3c:44:93:ca:d4:40:49:6c:80:87:d7:04:3a:c3:32:52:35:0e:\n         56:f8:a5:dd:7d:c4:8b:0d:11:1f:53:cb:1e:b2:17:b6:68:77:\n         5a:e0:d4:cb:c8:07:ae:f5:3a:2e:8e:37:b7:d0:01:4b:43:29:\n         77:8c:39:97:8f:82:5a:f8:51:e5:89:a0:18:e7:68:7f:5d:0a:\n         2e:fb:a3:47:0e:3d:a6:23:7a:c6:01:c7:8f:c8:5e:bf:6d:80:\n         56:be:8a:24:ba:33:ea:9f:e1:32:11:9e:f1:d2:4f:80:f6:1b:\n         40:af:38:9e:11:50:79:73:12:12:cd:e6:6c:9d:2c:88:72:3c:\n         30:81:06:91:22:ea:59:ad:da:19:2e:22:c2:8d:b9:8c:87:e0:\n         66:bc:73:23:5f:21:64:63:80:48:f5:a0:3c:18:3d:94:c8:48:\n         41:1d:40:ba:5e:fe:fe:56:39:a1:c8:cf:5e:9e:19:64:46:10:\n         da:17:91:b7:05:80:ac:8b:99:92:7d:e7:a2:d8:07:0b:36:27:\n         e7:48:79:60:8a:c3:d7:13:5c:f8:72:40:df:4a:cb:cf:99:00:\n         0a:00:0b:11:95:da:56:45:03:88:0a:9f:67:d0:d5:79:b1:a8:\n         8d:40:6d:0d:c2:7a:40:fa:f3:5f:64:47:92:cb:53:b9:bb:59:\n         ce:4f:fd:d0:15:53:01:d8:df:eb:d9:e6:76:ef:d0:23:bb:3b:\n         a9:79:b3:d5:02:29:cd:89:a3:96:0f:4a:35:e7:4e:42:c0:75:\n         cd:07:cf:e6:2c:eb:7b:2e\nSHA1 Fingerprint=E2:B8:29:4B:55:84:AB:6B:58:C2:90:46:6C:AC:3F:B8:39:8F:84:83\n",
    "e4af2b26711a2b4827852f52662ceff08913713e": "-----BEGIN CERTIFICATE-----\nMIIFWjCCA0KgAwIBAgIQbkepxUtHDA3sM9CJuRz04TANBgkqhkiG9w0BAQwFADBH\nMQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZpY2VzIExM\nQzEUMBIGA1UEAxMLR1RTIFJvb3QgUjEwHhcNMTYwNjIyMDAwMDAwWhcNMzYwNjIy\nMDAwMDAwWjBHMQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNl\ncnZpY2VzIExMQzEUMBIGA1UEAxMLR1RTIFJvb3QgUjEwggIiMA0GCSqGSIb3DQEB\nAQUAA4ICDwAwggIKAoICAQC2EQKLHuOhd5s73L+UPreVp0A8of2C+X0yBoJx9vaM\nf/vo27xqLpeXo4xL+Sv2sfnOhB2x+cWX3u+58qPpvBKJXqeqUqv4IyfLpLGcY9vX\nmX7wCl7raKb0xlpHDU0QM+NOsROjyBhsS+z8CZDfnWQpJSMHobTSPS5g4M/SCYe7\nzUjwTcLCeoiKu7rPWRnWr4+wB7CeMfGCwcDfLqZtbBkOtdh+JhpFAz2weaSUKK0P\nfyblqAj+lug8aJRT7oM6iCsVlgmy4HqMLnXWnOunVmSPlk9orj2XwoSPwLxAwAtc\nvfaHszVsrBhQf4TgTM2S0yDpM7xSma8ytSmzJSq0SPly4cpk9+aCEI3oncKKiPo4\nZor8Y/kB+Xj9e1x3+naH+uzfsQ55lVe0vSbv1gHR6xYKu44LtcXFilWr06zqkUsp\nzBmkMiVOKvFlRNACzqrOSbTqn3yDsEB750Orp2yjj32JgfpMpf/VjsPOS+C12LOO\nRc92wO1AK/1TD7Cn1TsNsYqiA94xrcx36m97PtbfkSIS5r762DL8EGMUUXLeXdYW\nk70paDPvOmbsB4om3xPXV2V4J95eSRQAogB/mqghtqmxlbCluQ0WEdrHbEg8QOB+\nDVrNVjzRlwW5y0vtOUucxD/SVRNuJLDWcfr0wbrM7Rv1/oFB2ACYPTrIrnqYNxgF\nlQIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNV\nHQ4EFgQU5K8rJnEaK0gnhS9SZizv8IkTcT4wDQYJKoZIhvcNAQEMBQADggIBADiW\nCu49tJYeX++dnAsznyvgyv3SjgofQXSlfKqE1OXyHuY3UjKcC9FhHb8owbZEKTV1\nd5iyfNm9dKyKaOOpMQkpAWBz40d8U6iQSifvS9efk+eCNs6aaAyC58/UEBZvXw6Z\nXPYfcX3v73svfuo21pdwCxXu11xWajOl40k4DLh9+42FpLFZXvRq4d2h9mREruZR\ngyFmxhE+885H7pwoHyXa/6xmld01D1zvICxi/ZG6qcz8WpyTgYMpl0p8WnK0OdC3\nd8t5/Wk6kjftbjhlRn7pYL15iJdfOBL07q9bgsiG1eGZbYwE8na6SfZu6W0eX6Dv\nJ4J2QPim01hcDyxC2kLGe4g0x8HYRZvBPsVhHdljUEn2NIVq4BjFbkerQUIpm/Zg\nDdIx02OYI5NaAIFItO/Nis3Jz5nu2Z6qNuFoS3FJFDYoOj0dzpqPJeaAcWErtXvM\n+SUWgeExX6GjfhaknBZqlxi9dnKlC54dNuYvoS++cJEPqOba+MSSQGwlfnuzCdyy\nF62ARPBopY+Udf90WuioAnwMCeKpSwughQtiue+hMZL77/ZRBIls6Kl0obsXs7X9\nSQ98POyDGCBDTtWTurQ0sR8WNh8M5mQ5Fkzc4P4dyKliPUDqysU0ArSuiYgzNdws\nE3PYJ/HQcu51OyLemGhmW/HGY0dVHLqlCFF1pkgl\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            6e:47:a9:c5:4b:47:0c:0d:ec:33:d0:89:b9:1c:f4:e1\n        Signature Algorithm: sha384WithRSAEncryption\n        Issuer: C=US, O=Google Trust Services LLC, CN=GTS Root R1\n        Validity\n            Not Before: Jun 22 00:00:00 2016 GMT\n            Not After : Jun 22 00:00:00 2036 GMT\n        Subject: C=US, O=Google Trust Services LLC, CN=GTS Root R1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:b6:11:02:8b:1e:e3:a1:77:9b:3b:dc:bf:94:3e:\n                    b7:95:a7:40:3c:a1:fd:82:f9:7d:32:06:82:71:f6:\n                    f6:8c:7f:fb:e8:db:bc:6a:2e:97:97:a3:8c:4b:f9:\n                    2b:f6:b1:f9:ce:84:1d:b1:f9:c5:97:de:ef:b9:f2:\n                    a3:e9:bc:12:89:5e:a7:aa:52:ab:f8:23:27:cb:a4:\n                    b1:9c:63:db:d7:99:7e:f0:0a:5e:eb:68:a6:f4:c6:\n                    5a:47:0d:4d:10:33:e3:4e:b1:13:a3:c8:18:6c:4b:\n                    ec:fc:09:90:df:9d:64:29:25:23:07:a1:b4:d2:3d:\n                    2e:60:e0:cf:d2:09:87:bb:cd:48:f0:4d:c2:c2:7a:\n                    88:8a:bb:ba:cf:59:19:d6:af:8f:b0:07:b0:9e:31:\n                    f1:82:c1:c0:df:2e:a6:6d:6c:19:0e:b5:d8:7e:26:\n                    1a:45:03:3d:b0:79:a4:94:28:ad:0f:7f:26:e5:a8:\n                    08:fe:96:e8:3c:68:94:53:ee:83:3a:88:2b:15:96:\n                    09:b2:e0:7a:8c:2e:75:d6:9c:eb:a7:56:64:8f:96:\n                    4f:68:ae:3d:97:c2:84:8f:c0:bc:40:c0:0b:5c:bd:\n                    f6:87:b3:35:6c:ac:18:50:7f:84:e0:4c:cd:92:d3:\n                    20:e9:33:bc:52:99:af:32:b5:29:b3:25:2a:b4:48:\n                    f9:72:e1:ca:64:f7:e6:82:10:8d:e8:9d:c2:8a:88:\n                    fa:38:66:8a:fc:63:f9:01:f9:78:fd:7b:5c:77:fa:\n                    76:87:fa:ec:df:b1:0e:79:95:57:b4:bd:26:ef:d6:\n                    01:d1:eb:16:0a:bb:8e:0b:b5:c5:c5:8a:55:ab:d3:\n                    ac:ea:91:4b:29:cc:19:a4:32:25:4e:2a:f1:65:44:\n                    d0:02:ce:aa:ce:49:b4:ea:9f:7c:83:b0:40:7b:e7:\n                    43:ab:a7:6c:a3:8f:7d:89:81:fa:4c:a5:ff:d5:8e:\n                    c3:ce:4b:e0:b5:d8:b3:8e:45:cf:76:c0:ed:40:2b:\n                    fd:53:0f:b0:a7:d5:3b:0d:b1:8a:a2:03:de:31:ad:\n                    cc:77:ea:6f:7b:3e:d6:df:91:22:12:e6:be:fa:d8:\n                    32:fc:10:63:14:51:72:de:5d:d6:16:93:bd:29:68:\n                    33:ef:3a:66:ec:07:8a:26:df:13:d7:57:65:78:27:\n                    de:5e:49:14:00:a2:00:7f:9a:a8:21:b6:a9:b1:95:\n                    b0:a5:b9:0d:16:11:da:c7:6c:48:3c:40:e0:7e:0d:\n                    5a:cd:56:3c:d1:97:05:b9:cb:4b:ed:39:4b:9c:c4:\n                    3f:d2:55:13:6e:24:b0:d6:71:fa:f4:c1:ba:cc:ed:\n                    1b:f5:fe:81:41:d8:00:98:3d:3a:c8:ae:7a:98:37:\n                    18:05:95\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                E4:AF:2B:26:71:1A:2B:48:27:85:2F:52:66:2C:EF:F0:89:13:71:3E\n    Signature Algorithm: sha384WithRSAEncryption\n         38:96:0a:ee:3d:b4:96:1e:5f:ef:9d:9c:0b:33:9f:2b:e0:ca:\n         fd:d2:8e:0a:1f:41:74:a5:7c:aa:84:d4:e5:f2:1e:e6:37:52:\n         32:9c:0b:d1:61:1d:bf:28:c1:b6:44:29:35:75:77:98:b2:7c:\n         d9:bd:74:ac:8a:68:e3:a9:31:09:29:01:60:73:e3:47:7c:53:\n         a8:90:4a:27:ef:4b:d7:9f:93:e7:82:36:ce:9a:68:0c:82:e7:\n         cf:d4:10:16:6f:5f:0e:99:5c:f6:1f:71:7d:ef:ef:7b:2f:7e:\n         ea:36:d6:97:70:0b:15:ee:d7:5c:56:6a:33:a5:e3:49:38:0c:\n         b8:7d:fb:8d:85:a4:b1:59:5e:f4:6a:e1:dd:a1:f6:64:44:ae:\n         e6:51:83:21:66:c6:11:3e:f3:ce:47:ee:9c:28:1f:25:da:ff:\n         ac:66:95:dd:35:0f:5c:ef:20:2c:62:fd:91:ba:a9:cc:fc:5a:\n         9c:93:81:83:29:97:4a:7c:5a:72:b4:39:d0:b7:77:cb:79:fd:\n         69:3a:92:37:ed:6e:38:65:46:7e:e9:60:bd:79:88:97:5f:38:\n         12:f4:ee:af:5b:82:c8:86:d5:e1:99:6d:8c:04:f2:76:ba:49:\n         f6:6e:e9:6d:1e:5f:a0:ef:27:82:76:40:f8:a6:d3:58:5c:0f:\n         2c:42:da:42:c6:7b:88:34:c7:c1:d8:45:9b:c1:3e:c5:61:1d:\n         d9:63:50:49:f6:34:85:6a:e0:18:c5:6e:47:ab:41:42:29:9b:\n         f6:60:0d:d2:31:d3:63:98:23:93:5a:00:81:48:b4:ef:cd:8a:\n         cd:c9:cf:99:ee:d9:9e:aa:36:e1:68:4b:71:49:14:36:28:3a:\n         3d:1d:ce:9a:8f:25:e6:80:71:61:2b:b5:7b:cc:f9:25:16:81:\n         e1:31:5f:a1:a3:7e:16:a4:9c:16:6a:97:18:bd:76:72:a5:0b:\n         9e:1d:36:e6:2f:a1:2f:be:70:91:0f:a8:e6:da:f8:c4:92:40:\n         6c:25:7e:7b:b3:09:dc:b2:17:ad:80:44:f0:68:a5:8f:94:75:\n         ff:74:5a:e8:a8:02:7c:0c:09:e2:a9:4b:0b:a0:85:0b:62:b9:\n         ef:a1:31:92:fb:ef:f6:51:04:89:6c:e8:a9:74:a1:bb:17:b3:\n         b5:fd:49:0f:7c:3c:ec:83:18:20:43:4e:d5:93:ba:b4:34:b1:\n         1f:16:36:1f:0c:e6:64:39:16:4c:dc:e0:fe:1d:c8:a9:62:3d:\n         40:ea:ca:c5:34:02:b4:ae:89:88:33:35:dc:2c:13:73:d8:27:\n         f1:d0:72:ee:75:3b:22:de:98:68:66:5b:f1:c6:63:47:55:1c:\n         ba:a5:08:51:75:a6:48:25\nSHA1 Fingerprint=E1:C9:50:E6:EF:22:F8:4C:56:45:72:8B:92:20:60:D7:D5:A7:A3:E8\n",
    "e59d5930824758ccacfa085436867b3ab5044df0": "-----BEGIN CERTIFICATE-----\nMIIDdzCCAl+gAwIBAgIEAgAAuTANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJJ\nRTESMBAGA1UEChMJQmFsdGltb3JlMRMwEQYDVQQLEwpDeWJlclRydXN0MSIwIAYD\nVQQDExlCYWx0aW1vcmUgQ3liZXJUcnVzdCBSb290MB4XDTAwMDUxMjE4NDYwMFoX\nDTI1MDUxMjIzNTkwMFowWjELMAkGA1UEBhMCSUUxEjAQBgNVBAoTCUJhbHRpbW9y\nZTETMBEGA1UECxMKQ3liZXJUcnVzdDEiMCAGA1UEAxMZQmFsdGltb3JlIEN5YmVy\nVHJ1c3QgUm9vdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKMEuyKr\nmD1X6CZymrV51Cni4eiVgLGw41uOKymaZN+hXe2wCQVt2yguzmKiYv60iNoS6zjr\nIZ3AQSsBUnuId9Mcj8e6uYi1agnnc+gRQKfRzMpijS3ljwumUNKoUMMo6vWrJYeK\nmpYcqWe4PwzV9/lSEy/CG9VwcPCPwBLKBsua4dnKM3p31vjsufFoREJIE9LAwqSu\nXmD+tqYF/LTdB1kC1FkYmGP1pWPgkAx9XbIGevOF6uvUA65ehD5f/xXtabz5OTZy\ndc93Uk3zyZAsuT3lySNTPx8kmCFcB5kpvcY67Oduhjprl3RjM71oGDHweI12v/ye\njl0qhqdNkNwnGjkCAwEAAaNFMEMwHQYDVR0OBBYEFOWdWTCCR1jMrPoIVDaGezq1\nBE3wMBIGA1UdEwEB/wQIMAYBAf8CAQMwDgYDVR0PAQH/BAQDAgEGMA0GCSqGSIb3\nDQEBBQUAA4IBAQCFDF2O5G9RaEIFoN27TyclhAO992T9Ldcw46QQF+vaKSm2eT92\n9hkTI7gQCvlYpNRhcL0EYWoSihfVCr3FvDB81ukMJY2GQE/szKN+OMY3EU/t3Wgx\njkzSswF07r51XgdIGn9w/xZchMB5hbgF/X++ZRGjD8ACtPhSNzkE1akxehi/oCr0\nEpn3o0WC4zxe9Z2etciefC7IpJ5OCBRLbf1wbWsaY71k5h+3zvDyny67G7fyUIhz\nksLi4xaNmjICq44Y3ekQEe5+NauQrz4wlHrQMz2nZQ/1/I6eYs9HRCwBXbsdtTLS\nR9I4LtD+gdwyah617jzV/OeBHRnDJELqYzmp\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 33554617 (0x20000b9)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Root\n        Validity\n            Not Before: May 12 18:46:00 2000 GMT\n            Not After : May 12 23:59:00 2025 GMT\n        Subject: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Root\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:a3:04:bb:22:ab:98:3d:57:e8:26:72:9a:b5:79:\n                    d4:29:e2:e1:e8:95:80:b1:b0:e3:5b:8e:2b:29:9a:\n                    64:df:a1:5d:ed:b0:09:05:6d:db:28:2e:ce:62:a2:\n                    62:fe:b4:88:da:12:eb:38:eb:21:9d:c0:41:2b:01:\n                    52:7b:88:77:d3:1c:8f:c7:ba:b9:88:b5:6a:09:e7:\n                    73:e8:11:40:a7:d1:cc:ca:62:8d:2d:e5:8f:0b:a6:\n                    50:d2:a8:50:c3:28:ea:f5:ab:25:87:8a:9a:96:1c:\n                    a9:67:b8:3f:0c:d5:f7:f9:52:13:2f:c2:1b:d5:70:\n                    70:f0:8f:c0:12:ca:06:cb:9a:e1:d9:ca:33:7a:77:\n                    d6:f8:ec:b9:f1:68:44:42:48:13:d2:c0:c2:a4:ae:\n                    5e:60:fe:b6:a6:05:fc:b4:dd:07:59:02:d4:59:18:\n                    98:63:f5:a5:63:e0:90:0c:7d:5d:b2:06:7a:f3:85:\n                    ea:eb:d4:03:ae:5e:84:3e:5f:ff:15:ed:69:bc:f9:\n                    39:36:72:75:cf:77:52:4d:f3:c9:90:2c:b9:3d:e5:\n                    c9:23:53:3f:1f:24:98:21:5c:07:99:29:bd:c6:3a:\n                    ec:e7:6e:86:3a:6b:97:74:63:33:bd:68:18:31:f0:\n                    78:8d:76:bf:fc:9e:8e:5d:2a:86:a7:4d:90:dc:27:\n                    1a:39\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                E5:9D:59:30:82:47:58:CC:AC:FA:08:54:36:86:7B:3A:B5:04:4D:F0\n            X509v3 Basic Constraints: critical\n                CA:TRUE, pathlen:3\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n    Signature Algorithm: sha1WithRSAEncryption\n         85:0c:5d:8e:e4:6f:51:68:42:05:a0:dd:bb:4f:27:25:84:03:\n         bd:f7:64:fd:2d:d7:30:e3:a4:10:17:eb:da:29:29:b6:79:3f:\n         76:f6:19:13:23:b8:10:0a:f9:58:a4:d4:61:70:bd:04:61:6a:\n         12:8a:17:d5:0a:bd:c5:bc:30:7c:d6:e9:0c:25:8d:86:40:4f:\n         ec:cc:a3:7e:38:c6:37:11:4f:ed:dd:68:31:8e:4c:d2:b3:01:\n         74:ee:be:75:5e:07:48:1a:7f:70:ff:16:5c:84:c0:79:85:b8:\n         05:fd:7f:be:65:11:a3:0f:c0:02:b4:f8:52:37:39:04:d5:a9:\n         31:7a:18:bf:a0:2a:f4:12:99:f7:a3:45:82:e3:3c:5e:f5:9d:\n         9e:b5:c8:9e:7c:2e:c8:a4:9e:4e:08:14:4b:6d:fd:70:6d:6b:\n         1a:63:bd:64:e6:1f:b7:ce:f0:f2:9f:2e:bb:1b:b7:f2:50:88:\n         73:92:c2:e2:e3:16:8d:9a:32:02:ab:8e:18:dd:e9:10:11:ee:\n         7e:35:ab:90:af:3e:30:94:7a:d0:33:3d:a7:65:0f:f5:fc:8e:\n         9e:62:cf:47:44:2c:01:5d:bb:1d:b5:32:d2:47:d2:38:2e:d0:\n         fe:81:dc:32:6a:1e:b5:ee:3c:d5:fc:e7:81:1d:19:c3:24:42:\n         ea:63:39:a9\nSHA1 Fingerprint=D4:DE:20:D0:5E:66:FC:53:FE:1A:50:88:2C:78:DB:28:52:CA:E4:74\n",
    "ecd7e382d2715d644cdf2e673fe7ba98ae1c0f4f": "-----BEGIN CERTIFICATE-----\nMIIFkDCCA3igAwIBAgIQBZsbV56OITLiOQe9p3d1XDANBgkqhkiG9w0BAQwFADBi\nMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3\nd3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3Qg\nRzQwHhcNMTMwODAxMTIwMDAwWhcNMzgwMTE1MTIwMDAwWjBiMQswCQYDVQQGEwJV\nUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQu\nY29tMSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqG\nSIb3DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3y\nithZwuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1If\nxp4VpX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDV\nySAdYyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiO\nDCu3T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQ\njdjUN6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/\nCNdaSaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCi\nEhtmmnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADM\nfRyVw4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QY\nuKZ3AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXK\nchYiCd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t\n9dmpsh3lGwIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIB\nhjAdBgNVHQ4EFgQU7NfjgtJxXWRM3y5nP+e6mK4cD08wDQYJKoZIhvcNAQEMBQAD\nggIBALth2X2pbL4XxJEbw6GiAI3jZGgPVs93rnD5/ZpKmbnJeFwMDF/k5hQpVgs2\nSV1EY+CtnJYYZhsjDT156W1r1lT40jzBQ0CuHVD1UvyQO7uYmWlrx8GnqGikJ9yd\n+SeuMIW59mdNOj6PWTkiU0TryF0Dyu1Qen1iIQqAyHNm0aAFYF/opbSnr6j3bTWc\nfFqK1qI4mfN4i/RN0iAL3gTujJtHgXINwBQy7zBZLq7gcfJW5GqXb5JQbZaNaHqa\nsjYUegbyJLkJEVDXCLG4iXqEI2FCKeWjzaIgQdfRnGTZ6iahixTXTBmyUEFxPT9N\ncCOGDErcgdLMMpSEDQgJlxxPwO5rIHQw0uA5NBCFIRUBCOhVMt5xSdkoF1BN5r5N\n0XWs0Mr7QbhDparTwwVETyw2m+L64kW4I1NsBm9nVX9GtUw/bihaeSbSpKhil9Ie\n4u1Ki7wb/UdKDd9nZn6yW0HQO+T0O/QEY+nvwlQAUaCKKsnOeMzV6ocEGLPOr0mI\nr/OSmbaz5mEP0oUA51Aa5BuVnRmhuZyxm7EAHu/QD09CbMkKvO5D+jpxpchNJqU1\n/YldvIViHTLSoCtU7ZpXwdv6EM8Zt4tKG48BtieVU+i2iW1bvGjUI+iLUaJW+fCm\ngKDWHrO8Dw9TdSmq6hN35N6MgSGtBxBHEa2HPQfRdbzP82Z+\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            05:9b:1b:57:9e:8e:21:32:e2:39:07:bd:a7:77:75:5c\n        Signature Algorithm: sha384WithRSAEncryption\n        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Trusted Root G4\n        Validity\n            Not Before: Aug  1 12:00:00 2013 GMT\n            Not After : Jan 15 12:00:00 2038 GMT\n        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Trusted Root G4\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:bf:e6:90:73:68:de:bb:e4:5d:4a:3c:30:22:30:\n                    69:33:ec:c2:a7:25:2e:c9:21:3d:f2:8a:d8:59:c2:\n                    e1:29:a7:3d:58:ab:76:9a:cd:ae:7b:1b:84:0d:c4:\n                    30:1f:f3:1b:a4:38:16:eb:56:c6:97:6d:1d:ab:b2:\n                    79:f2:ca:11:d2:e4:5f:d6:05:3c:52:0f:52:1f:c6:\n                    9e:15:a5:7e:be:9f:a9:57:16:59:55:72:af:68:93:\n                    70:c2:b2:ba:75:99:6a:73:32:94:d1:10:44:10:2e:\n                    df:82:f3:07:84:e6:74:3b:6d:71:e2:2d:0c:1b:ee:\n                    20:d5:c9:20:1d:63:29:2d:ce:ec:5e:4e:c8:93:f8:\n                    21:61:9b:34:eb:05:c6:5e:ec:5b:1a:bc:eb:c9:cf:\n                    cd:ac:34:40:5f:b1:7a:66:ee:77:c8:48:a8:66:57:\n                    57:9f:54:58:8e:0c:2b:b7:4f:a7:30:d9:56:ee:ca:\n                    7b:5d:e3:ad:c9:4f:5e:e5:35:e7:31:cb:da:93:5e:\n                    dc:8e:8f:80:da:b6:91:98:40:90:79:c3:78:c7:b6:\n                    b1:c4:b5:6a:18:38:03:10:8d:d8:d4:37:a4:2e:05:\n                    7d:88:f5:82:3e:10:91:70:ab:55:82:41:32:d7:db:\n                    04:73:2a:6e:91:01:7c:21:4c:d4:bc:ae:1b:03:75:\n                    5d:78:66:d9:3a:31:44:9a:33:40:bf:08:d7:5a:49:\n                    a4:c2:e6:a9:a0:67:dd:a4:27:bc:a1:4f:39:b5:11:\n                    58:17:f7:24:5c:46:8f:64:f7:c1:69:88:76:98:76:\n                    3d:59:5d:42:76:87:89:97:69:7a:48:f0:e0:a2:12:\n                    1b:66:9a:74:ca:de:4b:1e:e7:0e:63:ae:e6:d4:ef:\n                    92:92:3a:9e:3d:dc:00:e4:45:25:89:b6:9a:44:19:\n                    2b:7e:c0:94:b4:d2:61:6d:eb:33:d9:c5:df:4b:04:\n                    00:cc:7d:1c:95:c3:8f:f7:21:b2:b2:11:b7:bb:7f:\n                    f2:d5:8c:70:2c:41:60:aa:b1:63:18:44:95:1a:76:\n                    62:7e:f6:80:b0:fb:e8:64:a6:33:d1:89:07:e1:bd:\n                    b7:e6:43:a4:18:b8:a6:77:01:e1:0f:94:0c:21:1d:\n                    b2:54:29:25:89:6c:e5:0e:52:51:47:74:be:26:ac:\n                    b6:41:75:de:7a:ac:5f:8d:3f:c9:bc:d3:41:11:12:\n                    5b:e5:10:50:eb:31:c5:ca:72:16:22:09:df:7c:4c:\n                    75:3f:63:ec:21:5f:c4:20:51:6b:6f:b1:ab:86:8b:\n                    4f:c2:d6:45:5f:9d:20:fc:a1:1e:c5:c0:8f:a2:b1:\n                    7e:0a:26:99:f5:e4:69:2f:98:1d:2d:f5:d9:a9:b2:\n                    1d:e5:1b\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                EC:D7:E3:82:D2:71:5D:64:4C:DF:2E:67:3F:E7:BA:98:AE:1C:0F:4F\n    Signature Algorithm: sha384WithRSAEncryption\n         bb:61:d9:7d:a9:6c:be:17:c4:91:1b:c3:a1:a2:00:8d:e3:64:\n         68:0f:56:cf:77:ae:70:f9:fd:9a:4a:99:b9:c9:78:5c:0c:0c:\n         5f:e4:e6:14:29:56:0b:36:49:5d:44:63:e0:ad:9c:96:18:66:\n         1b:23:0d:3d:79:e9:6d:6b:d6:54:f8:d2:3c:c1:43:40:ae:1d:\n         50:f5:52:fc:90:3b:bb:98:99:69:6b:c7:c1:a7:a8:68:a4:27:\n         dc:9d:f9:27:ae:30:85:b9:f6:67:4d:3a:3e:8f:59:39:22:53:\n         44:eb:c8:5d:03:ca:ed:50:7a:7d:62:21:0a:80:c8:73:66:d1:\n         a0:05:60:5f:e8:a5:b4:a7:af:a8:f7:6d:35:9c:7c:5a:8a:d6:\n         a2:38:99:f3:78:8b:f4:4d:d2:20:0b:de:04:ee:8c:9b:47:81:\n         72:0d:c0:14:32:ef:30:59:2e:ae:e0:71:f2:56:e4:6a:97:6f:\n         92:50:6d:96:8d:68:7a:9a:b2:36:14:7a:06:f2:24:b9:09:11:\n         50:d7:08:b1:b8:89:7a:84:23:61:42:29:e5:a3:cd:a2:20:41:\n         d7:d1:9c:64:d9:ea:26:a1:8b:14:d7:4c:19:b2:50:41:71:3d:\n         3f:4d:70:23:86:0c:4a:dc:81:d2:cc:32:94:84:0d:08:09:97:\n         1c:4f:c0:ee:6b:20:74:30:d2:e0:39:34:10:85:21:15:01:08:\n         e8:55:32:de:71:49:d9:28:17:50:4d:e6:be:4d:d1:75:ac:d0:\n         ca:fb:41:b8:43:a5:aa:d3:c3:05:44:4f:2c:36:9b:e2:fa:e2:\n         45:b8:23:53:6c:06:6f:67:55:7f:46:b5:4c:3f:6e:28:5a:79:\n         26:d2:a4:a8:62:97:d2:1e:e2:ed:4a:8b:bc:1b:fd:47:4a:0d:\n         df:67:66:7e:b2:5b:41:d0:3b:e4:f4:3b:f4:04:63:e9:ef:c2:\n         54:00:51:a0:8a:2a:c9:ce:78:cc:d5:ea:87:04:18:b3:ce:af:\n         49:88:af:f3:92:99:b6:b3:e6:61:0f:d2:85:00:e7:50:1a:e4:\n         1b:95:9d:19:a1:b9:9c:b1:9b:b1:00:1e:ef:d0:0f:4f:42:6c:\n         c9:0a:bc:ee:43:fa:3a:71:a5:c8:4d:26:a5:35:fd:89:5d:bc:\n         85:62:1d:32:d2:a0:2b:54:ed:9a:57:c1:db:fa:10:cf:19:b7:\n         8b:4a:1b:8f:01:b6:27:95:53:e8:b6:89:6d:5b:bc:68:d4:23:\n         e8:8b:51:a2:56:f9:f0:a6:80:a0:d6:1e:b3:bc:0f:0f:53:75:\n         29:aa:ea:13:77:e4:de:8c:81:21:ad:07:10:47:11:ad:87:3d:\n         07:d1:75:bc:cf:f3:66:7e\nSHA1 Fingerprint=DD:FB:16:CD:49:31:C9:73:A2:03:7D:3F:C8:3A:4D:7D:77:5D:05:E4\n",
    "ed4419c0d3f0068beea47bbe42e72654c88e3676": "-----BEGIN CERTIFICATE-----\nMIIFYDCCA0igAwIBAgIQCgFCgAAAAUUjyES1AAAAAjANBgkqhkiG9w0BAQsFADBK\nMQswCQYDVQQGEwJVUzESMBAGA1UEChMJSWRlblRydXN0MScwJQYDVQQDEx5JZGVu\nVHJ1c3QgQ29tbWVyY2lhbCBSb290IENBIDEwHhcNMTQwMTE2MTgxMjIzWhcNMzQw\nMTE2MTgxMjIzWjBKMQswCQYDVQQGEwJVUzESMBAGA1UEChMJSWRlblRydXN0MScw\nJQYDVQQDEx5JZGVuVHJ1c3QgQ29tbWVyY2lhbCBSb290IENBIDEwggIiMA0GCSqG\nSIb3DQEBAQUAA4ICDwAwggIKAoICAQCnUBneP5k91DNG8W9RYYKyqU+PZ4ldhNlT\n3Qwo2dfw/66VQ3KZ+bVdfIrBQuExUHTRgQ18zZshq0PirK1ehm7zCYofWjK9ouuU\n+ehcCuz/mNKvcbO0U59Oh++SvL3sTzIwiEsXXlfEU8L2ApeN2WIrvyQfYo3fw7gp\nS0l4PJNgiCL8mdo2yMKi1CxUAGc1bnO/AljwpN3lsKImesrgNqUZFvX9t++uP0D1\nbVoE/c40yiTcdCMbXTMTEl3EASX2MN0CXZ/g1Ue9tOsbobtJSdifWwLziuQkkORi\nT0/Br4sOdBeo0XKIanoBScy0RnnGF7HamB4HWfp1IYVl3ZBWzvurpWCdxJ35UrCL\nvYf5jysjCiN2O/cz4ckA82n5S6LgTrx+kzmEB/dEcH7+B1rlsazRGMzyNeVJSQjK\nVsk9+w8YfYs7wRPCTY/JTw436R+hDmrfYi7LNQZReSzIJTj0+kuniVyc0uMNOYZK\ndHzVWYfCP04MXFL0PfdSgvHqo6z9STQaKPNBiDoT7uje/5kdX7rL6B7yuVBgwDHT\nc+XvvqDtMwt0viAgxGds8AgDelWAf0ZOlqf0Hj7h9tgJ4TNkK2PXMl6f+cB7D3hv\nl7yTmvmcEpB4eoCHFddydJxVdHixuuFucAS6T6C6aMN7/zHwcz09lCqxC0EOoP5N\niGVreTO01wIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB\n/zAdBgNVHQ4EFgQU7UQZwNPwBovupHu+QucmVMiONnYwDQYJKoZIhvcNAQELBQAD\nggIBAA2ukDL2pkt8RHYZYR4nKM1eVO8lvOMIkPkp165oCOGUAFjvLi5+U1KMtlwH\n6oi6mYtQlNeCgN9hCQCTrQ0U5s7B8jeUeLBfnLOic7iPBZM4zY0+sLj7wM+x8uwt\nLRvM7Kqas6pgghstO8OEPVeKlh6cdbjTMM1gCIOQ045U8U1mwF10A0Cj7oV+wh93\nnAbowacYXVKV7cndJZ5t+qntozo00Fl72u1Q8zW/7esUTTHHYPTa8Yec4kjixsU3\n+wYQ+nVZZjFHKdp2mhzpgq7vmrlR94gjmmmVYjzlVYA211QC//G5Xc7UI2/YRYRK\nW2XviQzdFKcgyxilJbQN+QHwotL0AMh0jqEqSI5l2xPE4iUXfeu+h1sXIFRRk0pT\nAwvsXcoz7WL9RccvW9xYoIA55vrX/hMUpu09lEpCdNTDd1lzzY9GvlU47/rokTLq\nl1gEIt44w8y8bckzOmoKaT+gyOpyj4xjhiO9bTyWnpXgSUyqorkqG5w2gXjtw+hG\n4iZZRHUe2XWJUc0QhJ1hYMtd+ZciTY6Y5uN/9lu7rs3KSoFrXgvzUeF0K+l+J6fZ\nmUlO+KWA2yUPHGNiiskzZ2s8EIPGrd6ozRaOjfAHN3Gf8qv8QfXBi+wAN10J5U6A\n7/qxXDgGpRtK4dw4LTzcqx+QGtVKnO7RcGzM7vRX+Bi6hG6H\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            0a:01:42:80:00:00:01:45:23:c8:44:b5:00:00:00:02\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, O=IdenTrust, CN=IdenTrust Commercial Root CA 1\n        Validity\n            Not Before: Jan 16 18:12:23 2014 GMT\n            Not After : Jan 16 18:12:23 2034 GMT\n        Subject: C=US, O=IdenTrust, CN=IdenTrust Commercial Root CA 1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:a7:50:19:de:3f:99:3d:d4:33:46:f1:6f:51:61:\n                    82:b2:a9:4f:8f:67:89:5d:84:d9:53:dd:0c:28:d9:\n                    d7:f0:ff:ae:95:43:72:99:f9:b5:5d:7c:8a:c1:42:\n                    e1:31:50:74:d1:81:0d:7c:cd:9b:21:ab:43:e2:ac:\n                    ad:5e:86:6e:f3:09:8a:1f:5a:32:bd:a2:eb:94:f9:\n                    e8:5c:0a:ec:ff:98:d2:af:71:b3:b4:53:9f:4e:87:\n                    ef:92:bc:bd:ec:4f:32:30:88:4b:17:5e:57:c4:53:\n                    c2:f6:02:97:8d:d9:62:2b:bf:24:1f:62:8d:df:c3:\n                    b8:29:4b:49:78:3c:93:60:88:22:fc:99:da:36:c8:\n                    c2:a2:d4:2c:54:00:67:35:6e:73:bf:02:58:f0:a4:\n                    dd:e5:b0:a2:26:7a:ca:e0:36:a5:19:16:f5:fd:b7:\n                    ef:ae:3f:40:f5:6d:5a:04:fd:ce:34:ca:24:dc:74:\n                    23:1b:5d:33:13:12:5d:c4:01:25:f6:30:dd:02:5d:\n                    9f:e0:d5:47:bd:b4:eb:1b:a1:bb:49:49:d8:9f:5b:\n                    02:f3:8a:e4:24:90:e4:62:4f:4f:c1:af:8b:0e:74:\n                    17:a8:d1:72:88:6a:7a:01:49:cc:b4:46:79:c6:17:\n                    b1:da:98:1e:07:59:fa:75:21:85:65:dd:90:56:ce:\n                    fb:ab:a5:60:9d:c4:9d:f9:52:b0:8b:bd:87:f9:8f:\n                    2b:23:0a:23:76:3b:f7:33:e1:c9:00:f3:69:f9:4b:\n                    a2:e0:4e:bc:7e:93:39:84:07:f7:44:70:7e:fe:07:\n                    5a:e5:b1:ac:d1:18:cc:f2:35:e5:49:49:08:ca:56:\n                    c9:3d:fb:0f:18:7d:8b:3b:c1:13:c2:4d:8f:c9:4f:\n                    0e:37:e9:1f:a1:0e:6a:df:62:2e:cb:35:06:51:79:\n                    2c:c8:25:38:f4:fa:4b:a7:89:5c:9c:d2:e3:0d:39:\n                    86:4a:74:7c:d5:59:87:c2:3f:4e:0c:5c:52:f4:3d:\n                    f7:52:82:f1:ea:a3:ac:fd:49:34:1a:28:f3:41:88:\n                    3a:13:ee:e8:de:ff:99:1d:5f:ba:cb:e8:1e:f2:b9:\n                    50:60:c0:31:d3:73:e5:ef:be:a0:ed:33:0b:74:be:\n                    20:20:c4:67:6c:f0:08:03:7a:55:80:7f:46:4e:96:\n                    a7:f4:1e:3e:e1:f6:d8:09:e1:33:64:2b:63:d7:32:\n                    5e:9f:f9:c0:7b:0f:78:6f:97:bc:93:9a:f9:9c:12:\n                    90:78:7a:80:87:15:d7:72:74:9c:55:74:78:b1:ba:\n                    e1:6e:70:04:ba:4f:a0:ba:68:c3:7b:ff:31:f0:73:\n                    3d:3d:94:2a:b1:0b:41:0e:a0:fe:4d:88:65:6b:79:\n                    33:b4:d7\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                ED:44:19:C0:D3:F0:06:8B:EE:A4:7B:BE:42:E7:26:54:C8:8E:36:76\n    Signature Algorithm: sha256WithRSAEncryption\n         0d:ae:90:32:f6:a6:4b:7c:44:76:19:61:1e:27:28:cd:5e:54:\n         ef:25:bc:e3:08:90:f9:29:d7:ae:68:08:e1:94:00:58:ef:2e:\n         2e:7e:53:52:8c:b6:5c:07:ea:88:ba:99:8b:50:94:d7:82:80:\n         df:61:09:00:93:ad:0d:14:e6:ce:c1:f2:37:94:78:b0:5f:9c:\n         b3:a2:73:b8:8f:05:93:38:cd:8d:3e:b0:b8:fb:c0:cf:b1:f2:\n         ec:2d:2d:1b:cc:ec:aa:9a:b3:aa:60:82:1b:2d:3b:c3:84:3d:\n         57:8a:96:1e:9c:75:b8:d3:30:cd:60:08:83:90:d3:8e:54:f1:\n         4d:66:c0:5d:74:03:40:a3:ee:85:7e:c2:1f:77:9c:06:e8:c1:\n         a7:18:5d:52:95:ed:c9:dd:25:9e:6d:fa:a9:ed:a3:3a:34:d0:\n         59:7b:da:ed:50:f3:35:bf:ed:eb:14:4d:31:c7:60:f4:da:f1:\n         87:9c:e2:48:e2:c6:c5:37:fb:06:10:fa:75:59:66:31:47:29:\n         da:76:9a:1c:e9:82:ae:ef:9a:b9:51:f7:88:23:9a:69:95:62:\n         3c:e5:55:80:36:d7:54:02:ff:f1:b9:5d:ce:d4:23:6f:d8:45:\n         84:4a:5b:65:ef:89:0c:dd:14:a7:20:cb:18:a5:25:b4:0d:f9:\n         01:f0:a2:d2:f4:00:c8:74:8e:a1:2a:48:8e:65:db:13:c4:e2:\n         25:17:7d:eb:be:87:5b:17:20:54:51:93:4a:53:03:0b:ec:5d:\n         ca:33:ed:62:fd:45:c7:2f:5b:dc:58:a0:80:39:e6:fa:d7:fe:\n         13:14:a6:ed:3d:94:4a:42:74:d4:c3:77:59:73:cd:8f:46:be:\n         55:38:ef:fa:e8:91:32:ea:97:58:04:22:de:38:c3:cc:bc:6d:\n         c9:33:3a:6a:0a:69:3f:a0:c8:ea:72:8f:8c:63:86:23:bd:6d:\n         3c:96:9e:95:e0:49:4c:aa:a2:b9:2a:1b:9c:36:81:78:ed:c3:\n         e8:46:e2:26:59:44:75:1e:d9:75:89:51:cd:10:84:9d:61:60:\n         cb:5d:f9:97:22:4d:8e:98:e6:e3:7f:f6:5b:bb:ae:cd:ca:4a:\n         81:6b:5e:0b:f3:51:e1:74:2b:e9:7e:27:a7:d9:99:49:4e:f8:\n         a5:80:db:25:0f:1c:63:62:8a:c9:33:67:6b:3c:10:83:c6:ad:\n         de:a8:cd:16:8e:8d:f0:07:37:71:9f:f2:ab:fc:41:f5:c1:8b:\n         ec:00:37:5d:09:e5:4e:80:ef:fa:b1:5c:38:06:a5:1b:4a:e1:\n         dc:38:2d:3c:dc:ab:1f:90:1a:d5:4a:9c:ee:d1:70:6c:cc:ee:\n         f4:57:f8:18:ba:84:6e:87\nSHA1 Fingerprint=DF:71:7E:AA:4A:D9:4E:C9:55:84:99:60:2D:48:DE:5F:BC:F0:3A:25\n",
    "ede76f765abf60ec495bc6a577bb7216719bc43d": "-----BEGIN CERTIFICATE-----\nMIIFYDCCA0igAwIBAgIURFc0JFuBiZs18s64KztbpybwdSgwDQYJKoZIhvcNAQEL\nBQAwSDELMAkGA1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxHjAc\nBgNVBAMTFVF1b1ZhZGlzIFJvb3QgQ0EgMiBHMzAeFw0xMjAxMTIxODU5MzJaFw00\nMjAxMTIxODU5MzJaMEgxCzAJBgNVBAYTAkJNMRkwFwYDVQQKExBRdW9WYWRpcyBM\naW1pdGVkMR4wHAYDVQQDExVRdW9WYWRpcyBSb290IENBIDIgRzMwggIiMA0GCSqG\nSIb3DQEBAQUAA4ICDwAwggIKAoICAQChriWyARjcV4g/Ruv5r+LrI3HimtFhZiFf\nqq8nUeVuGxbULX1QsFN3vXg6YOJkApt8hpvWGo6t/x8Vf9WVHhLL5hSEBMHfNrMW\nn4rjyduYNM7YMxcoRvynyfDStNVNCXJJ+fKH46nafaF9a7I6JaltUkSs+L5u+9ym\nc5GQYaYDFCDy54ejiK2toIz/pgslUiXnFgHVy7g1gQyjO/Dh4fxaXc6AcW34Sas+\nO7q414AB+6XrW7PFXmAqMaCvN+ggOp+oMiwMzAkd056OXbxMmO7FGmh77FOm6RQ1\no9/NgJ8MSPsc9PG/Srj61YxxSscfrf5BmrODXfKEVu+lV0POKa2Mq1W/xPtbAd0j\nIaFYAI7D0GoT7RPjEiuA3GfmlbLNHiJuKvhB1PLKFAeNilUSxmn1uIZoL1NesNKq\nIcGY5jDjZ1XHm26sGahVpkUG0CM62+tlXSoREfA7T8pt9DTEceT/AFr2XK4jYIVz\n8eQQsSWu1ZK7E8EM4DnatDlXtas1qnIhO4M15zHfeiFuuDIIfR0ykRVKYnLP43eh\nvNURG3YBZwjgQQvD6xVu+KQZ2aKrr+InUlYrAoosFCT5v0ICvybIxo/gbjh9Uy3l\n7ZizlWNof/k19N+IxWA1ksB8aRxhlRbQ694Lrz4EEEVlWFA4r0jyWbYW8jwNkALG\ncC4BrTwV1wIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIB\nBjAdBgNVHQ4EFgQU7edvdlq/YOxJW8ald7tyFnGbxD0wDQYJKoZIhvcNAQELBQAD\nggIBAJHfgD9DCX5xwvfrs4iP4VGyvD11+ShdyLyZm3tdquXK4Qr36LLTn91nMX66\nAarHakE7kNQIXLJgapDwyM4DYvmL7ftuKtwGTTwpD4kWilhMSA/ohGHqPHKmd+RC\nroijQ1h5fq7KpVMNqT1wvSAZYaRsOPxDMuHBR//47PERIjKWnML2W2mWeyAMQ0Ga\nW/ZZGYjeVYg3UQt4XAoeo0L9x52ID8DyeAIkVJOviYeIyUqAHerQbj5hLja7NQ4n\nlv1mNDthcnPxFlxHBlRJAHpYErAK74X9sbgzdWqTHBLmYF5vHX/JHyPLhGGfHoJE\n+V+tYlUkmlKY7VHnoX6XOuYvHxHaU4AshZ6rNRDbIl9qxV6XU/IyAgkwo1jwDQHV\ncsaxfGl7w/U2Rcxhbl5MlMVerugOXou/983g7aEOGzPuVBj+D77vfoRrQ+NwmNtd\ndbINWQeFFSM51vHfqSYP1kjHs6Yi9TM3WpVHn3u6GBVv/9YUZINJ0gpnIdsPNWNg\nKCLjsZWDzYWm3S8P52dSbrsvhXz1SnPnxT7AvSESBT/8twNJAlvIJebiVDj1eYeM\nHVOyToV7BjjHLPj4sHKNJeV3UvQDHEimUF+IIDBu8oJDqz2XhOdT+yHBTw8imoa4\nWSr2Rz0ZiC3oheGe7IUIarFsNMkd7EgrO3jtZsSOeWmD3n+M\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            44:57:34:24:5b:81:89:9b:35:f2:ce:b8:2b:3b:5b:a7:26:f0:75:28\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 2 G3\n        Validity\n            Not Before: Jan 12 18:59:32 2012 GMT\n            Not After : Jan 12 18:59:32 2042 GMT\n        Subject: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 2 G3\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:a1:ae:25:b2:01:18:dc:57:88:3f:46:eb:f9:af:\n                    e2:eb:23:71:e2:9a:d1:61:66:21:5f:aa:af:27:51:\n                    e5:6e:1b:16:d4:2d:7d:50:b0:53:77:bd:78:3a:60:\n                    e2:64:02:9b:7c:86:9b:d6:1a:8e:ad:ff:1f:15:7f:\n                    d5:95:1e:12:cb:e6:14:84:04:c1:df:36:b3:16:9f:\n                    8a:e3:c9:db:98:34:ce:d8:33:17:28:46:fc:a7:c9:\n                    f0:d2:b4:d5:4d:09:72:49:f9:f2:87:e3:a9:da:7d:\n                    a1:7d:6b:b2:3a:25:a9:6d:52:44:ac:f8:be:6e:fb:\n                    dc:a6:73:91:90:61:a6:03:14:20:f2:e7:87:a3:88:\n                    ad:ad:a0:8c:ff:a6:0b:25:52:25:e7:16:01:d5:cb:\n                    b8:35:81:0c:a3:3b:f0:e1:e1:fc:5a:5d:ce:80:71:\n                    6d:f8:49:ab:3e:3b:ba:b8:d7:80:01:fb:a5:eb:5b:\n                    b3:c5:5e:60:2a:31:a0:af:37:e8:20:3a:9f:a8:32:\n                    2c:0c:cc:09:1d:d3:9e:8e:5d:bc:4c:98:ee:c5:1a:\n                    68:7b:ec:53:a6:e9:14:35:a3:df:cd:80:9f:0c:48:\n                    fb:1c:f4:f1:bf:4a:b8:fa:d5:8c:71:4a:c7:1f:ad:\n                    fe:41:9a:b3:83:5d:f2:84:56:ef:a5:57:43:ce:29:\n                    ad:8c:ab:55:bf:c4:fb:5b:01:dd:23:21:a1:58:00:\n                    8e:c3:d0:6a:13:ed:13:e3:12:2b:80:dc:67:e6:95:\n                    b2:cd:1e:22:6e:2a:f8:41:d4:f2:ca:14:07:8d:8a:\n                    55:12:c6:69:f5:b8:86:68:2f:53:5e:b0:d2:aa:21:\n                    c1:98:e6:30:e3:67:55:c7:9b:6e:ac:19:a8:55:a6:\n                    45:06:d0:23:3a:db:eb:65:5d:2a:11:11:f0:3b:4f:\n                    ca:6d:f4:34:c4:71:e4:ff:00:5a:f6:5c:ae:23:60:\n                    85:73:f1:e4:10:b1:25:ae:d5:92:bb:13:c1:0c:e0:\n                    39:da:b4:39:57:b5:ab:35:aa:72:21:3b:83:35:e7:\n                    31:df:7a:21:6e:b8:32:08:7d:1d:32:91:15:4a:62:\n                    72:cf:e3:77:a1:bc:d5:11:1b:76:01:67:08:e0:41:\n                    0b:c3:eb:15:6e:f8:a4:19:d9:a2:ab:af:e2:27:52:\n                    56:2b:02:8a:2c:14:24:f9:bf:42:02:bf:26:c8:c6:\n                    8f:e0:6e:38:7d:53:2d:e5:ed:98:b3:95:63:68:7f:\n                    f9:35:f4:df:88:c5:60:35:92:c0:7c:69:1c:61:95:\n                    16:d0:eb:de:0b:af:3e:04:10:45:65:58:50:38:af:\n                    48:f2:59:b6:16:f2:3c:0d:90:02:c6:70:2e:01:ad:\n                    3c:15:d7\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                ED:E7:6F:76:5A:BF:60:EC:49:5B:C6:A5:77:BB:72:16:71:9B:C4:3D\n    Signature Algorithm: sha256WithRSAEncryption\n         91:df:80:3f:43:09:7e:71:c2:f7:eb:b3:88:8f:e1:51:b2:bc:\n         3d:75:f9:28:5d:c8:bc:99:9b:7b:5d:aa:e5:ca:e1:0a:f7:e8:\n         b2:d3:9f:dd:67:31:7e:ba:01:aa:c7:6a:41:3b:90:d4:08:5c:\n         b2:60:6a:90:f0:c8:ce:03:62:f9:8b:ed:fb:6e:2a:dc:06:4d:\n         3c:29:0f:89:16:8a:58:4c:48:0f:e8:84:61:ea:3c:72:a6:77:\n         e4:42:ae:88:a3:43:58:79:7e:ae:ca:a5:53:0d:a9:3d:70:bd:\n         20:19:61:a4:6c:38:fc:43:32:e1:c1:47:ff:f8:ec:f1:11:22:\n         32:96:9c:c2:f6:5b:69:96:7b:20:0c:43:41:9a:5b:f6:59:19:\n         88:de:55:88:37:51:0b:78:5c:0a:1e:a3:42:fd:c7:9d:88:0f:\n         c0:f2:78:02:24:54:93:af:89:87:88:c9:4a:80:1d:ea:d0:6e:\n         3e:61:2e:36:bb:35:0e:27:96:fd:66:34:3b:61:72:73:f1:16:\n         5c:47:06:54:49:00:7a:58:12:b0:0a:ef:85:fd:b1:b8:33:75:\n         6a:93:1c:12:e6:60:5e:6f:1d:7f:c9:1f:23:cb:84:61:9f:1e:\n         82:44:f9:5f:ad:62:55:24:9a:52:98:ed:51:e7:a1:7e:97:3a:\n         e6:2f:1f:11:da:53:80:2c:85:9e:ab:35:10:db:22:5f:6a:c5:\n         5e:97:53:f2:32:02:09:30:a3:58:f0:0d:01:d5:72:c6:b1:7c:\n         69:7b:c3:f5:36:45:cc:61:6e:5e:4c:94:c5:5e:ae:e8:0e:5e:\n         8b:bf:f7:cd:e0:ed:a1:0e:1b:33:ee:54:18:fe:0f:be:ef:7e:\n         84:6b:43:e3:70:98:db:5d:75:b2:0d:59:07:85:15:23:39:d6:\n         f1:df:a9:26:0f:d6:48:c7:b3:a6:22:f5:33:37:5a:95:47:9f:\n         7b:ba:18:15:6f:ff:d6:14:64:83:49:d2:0a:67:21:db:0f:35:\n         63:60:28:22:e3:b1:95:83:cd:85:a6:dd:2f:0f:e7:67:52:6e:\n         bb:2f:85:7c:f5:4a:73:e7:c5:3e:c0:bd:21:12:05:3f:fc:b7:\n         03:49:02:5b:c8:25:e6:e2:54:38:f5:79:87:8c:1d:53:b2:4e:\n         85:7b:06:38:c7:2c:f8:f8:b0:72:8d:25:e5:77:52:f4:03:1c:\n         48:a6:50:5f:88:20:30:6e:f2:82:43:ab:3d:97:84:e7:53:fb:\n         21:c1:4f:0f:22:9a:86:b8:59:2a:f6:47:3d:19:88:2d:e8:85:\n         e1:9e:ec:85:08:6a:b1:6c:34:c9:1d:ec:48:2b:3b:78:ed:66:\n         c4:8e:79:69:83:de:7f:8c\nSHA1 Fingerprint=09:3C:61:F3:8B:8B:DC:7D:55:DF:75:38:02:05:00:E1:25:F5:C8:36\n",
    "ee6b493c7a3f0de3b109b78ac8ab199f733350e7": "-----BEGIN CERTIFICATE-----\nMIIEMDCCAxigAwIBAgIJANqb7HHzA7AZMA0GCSqGSIb3DQEBCwUAMIGkMQswCQYD\nVQQGEwJQQTEPMA0GA1UECAwGUGFuYW1hMRQwEgYDVQQHDAtQYW5hbWEgQ2l0eTEk\nMCIGA1UECgwbVHJ1c3RDb3IgU3lzdGVtcyBTLiBkZSBSLkwuMScwJQYDVQQLDB5U\ncnVzdENvciBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxHzAdBgNVBAMMFlRydXN0Q29y\nIFJvb3RDZXJ0IENBLTEwHhcNMTYwMjA0MTIzMjE2WhcNMjkxMjMxMTcyMzE2WjCB\npDELMAkGA1UEBhMCUEExDzANBgNVBAgMBlBhbmFtYTEUMBIGA1UEBwwLUGFuYW1h\nIENpdHkxJDAiBgNVBAoMG1RydXN0Q29yIFN5c3RlbXMgUy4gZGUgUi5MLjEnMCUG\nA1UECwweVHJ1c3RDb3IgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MR8wHQYDVQQDDBZU\ncnVzdENvciBSb290Q2VydCBDQS0xMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB\nCgKCAQEAv463leLCJhJrMxnHQFgKq1mqjQCj/IDHUHuO1CAmujIS2CNUSSUQIpid\nRtLByZ5OGy4sDjjzGiVoHKZaBeYei0i/mJZ0PmnK6bV4pQa81QBeCQryJ3pS/C3V\nseq0iWEk8xoT26nPUu0MJLq5nux+AHT6k61sKZKuUbS701e/s/OojZz0JEsq1pme\n9J7+wH5COucLlVPat2gOkEz7cD+PSiyU8ybdY2mplNgQTsVHCJCZGxdNuWxu72CV\nEY4hgLW9oHPY0LJ3xEXqWib7ZnZ2+AYfYW0PVcWDtxBWcgYHpfOxGgMFZA6dWorW\nhnAbJN7+KIor0Gqw/Hqi3LJ5DotlDwIDAQABo2MwYTAdBgNVHQ4EFgQU7mtJPHo/\nDeOxCbeKyKsZn3MzUOcwHwYDVR0jBBgwFoAU7mtJPHo/DeOxCbeKyKsZn3MzUOcw\nDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcNAQELBQAD\nggEBACUY1JGPE+6PHh0RU9otRCkZoB5rMZ5NDp6tPVxBb5UrJKF5mDo4Nvu7Zp5I\n/5CQ7z3UuJu0h3U/IJvOcs+hVcFNZKIZBqEHMwwLKeXx6quj7LUKdJDHfXLy11yf\nke+Ri7fc7Waiz45mO7yfOgLgJ90WmMCV1Aqk5IGadZQ1nJBfiDcGrVmVCrDRZ9MZ\nyonnMlo2HD6CqFqTvsbQZJG2z9m2GM/bftJlo6bEjhcxwft+dtvTheNYsnd6djts\nL1Ac59v2Z3kf9YKVmgenFK+P3CghZwnS1k1aHBkcjndcw5QkPTJrS37UeJSDvjdN\nzl/HHk484IkzlQsPpTLWPFp5LBk=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            da:9b:ec:71:f3:03:b0:19\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor RootCert CA-1\n        Validity\n            Not Before: Feb  4 12:32:16 2016 GMT\n            Not After : Dec 31 17:23:16 2029 GMT\n        Subject: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor RootCert CA-1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:bf:8e:b7:95:e2:c2:26:12:6b:33:19:c7:40:58:\n                    0a:ab:59:aa:8d:00:a3:fc:80:c7:50:7b:8e:d4:20:\n                    26:ba:32:12:d8:23:54:49:25:10:22:98:9d:46:d2:\n                    c1:c9:9e:4e:1b:2e:2c:0e:38:f3:1a:25:68:1c:a6:\n                    5a:05:e6:1e:8b:48:bf:98:96:74:3e:69:ca:e9:b5:\n                    78:a5:06:bc:d5:00:5e:09:0a:f2:27:7a:52:fc:2d:\n                    d5:b1:ea:b4:89:61:24:f3:1a:13:db:a9:cf:52:ed:\n                    0c:24:ba:b9:9e:ec:7e:00:74:fa:93:ad:6c:29:92:\n                    ae:51:b4:bb:d3:57:bf:b3:f3:a8:8d:9c:f4:24:4b:\n                    2a:d6:99:9e:f4:9e:fe:c0:7e:42:3a:e7:0b:95:53:\n                    da:b7:68:0e:90:4c:fb:70:3f:8f:4a:2c:94:f3:26:\n                    dd:63:69:a9:94:d8:10:4e:c5:47:08:90:99:1b:17:\n                    4d:b9:6c:6e:ef:60:95:11:8e:21:80:b5:bd:a0:73:\n                    d8:d0:b2:77:c4:45:ea:5a:26:fb:66:76:76:f8:06:\n                    1f:61:6d:0f:55:c5:83:b7:10:56:72:06:07:a5:f3:\n                    b1:1a:03:05:64:0e:9d:5a:8a:d6:86:70:1b:24:de:\n                    fe:28:8a:2b:d0:6a:b0:fc:7a:a2:dc:b2:79:0e:8b:\n                    65:0f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                EE:6B:49:3C:7A:3F:0D:E3:B1:09:B7:8A:C8:AB:19:9F:73:33:50:E7\n            X509v3 Authority Key Identifier: \n                keyid:EE:6B:49:3C:7A:3F:0D:E3:B1:09:B7:8A:C8:AB:19:9F:73:33:50:E7\n\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         25:18:d4:91:8f:13:ee:8f:1e:1d:11:53:da:2d:44:29:19:a0:\n         1e:6b:31:9e:4d:0e:9e:ad:3d:5c:41:6f:95:2b:24:a1:79:98:\n         3a:38:36:fb:bb:66:9e:48:ff:90:90:ef:3d:d4:b8:9b:b4:87:\n         75:3f:20:9b:ce:72:cf:a1:55:c1:4d:64:a2:19:06:a1:07:33:\n         0c:0b:29:e5:f1:ea:ab:a3:ec:b5:0a:74:90:c7:7d:72:f2:d7:\n         5c:9f:91:ef:91:8b:b7:dc:ed:66:a2:cf:8e:66:3b:bc:9f:3a:\n         02:e0:27:dd:16:98:c0:95:d4:0a:a4:e4:81:9a:75:94:35:9c:\n         90:5f:88:37:06:ad:59:95:0a:b0:d1:67:d3:19:ca:89:e7:32:\n         5a:36:1c:3e:82:a8:5a:93:be:c6:d0:64:91:b6:cf:d9:b6:18:\n         cf:db:7e:d2:65:a3:a6:c4:8e:17:31:c1:fb:7e:76:db:d3:85:\n         e3:58:b2:77:7a:76:3b:6c:2f:50:1c:e7:db:f6:67:79:1f:f5:\n         82:95:9a:07:a7:14:af:8f:dc:28:21:67:09:d2:d6:4d:5a:1c:\n         19:1c:8e:77:5c:c3:94:24:3d:32:6b:4b:7e:d4:78:94:83:be:\n         37:4d:ce:5f:c7:1e:4e:3c:e0:89:33:95:0b:0f:a5:32:d6:3c:\n         5a:79:2c:19\nSHA1 Fingerprint=FF:BD:CD:E7:82:C8:43:5E:3C:6F:26:86:5C:CA:A8:3A:45:5B:C3:0A\n",
    "f08f593800b3f58f9a960cd5ebfa7baa17e81312": "-----BEGIN CERTIFICATE-----\nMIIFODCCAyCgAwIBAgIRAJW+FqD3LkbxezmCcvqLzZYwDQYJKoZIhvcNAQEFBQAw\nNzEUMBIGA1UECgwLVGVsaWFTb25lcmExHzAdBgNVBAMMFlRlbGlhU29uZXJhIFJv\nb3QgQ0EgdjEwHhcNMDcxMDE4MTIwMDUwWhcNMzIxMDE4MTIwMDUwWjA3MRQwEgYD\nVQQKDAtUZWxpYVNvbmVyYTEfMB0GA1UEAwwWVGVsaWFTb25lcmEgUm9vdCBDQSB2\nMTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMK+6yfwIaPzaSZVfp3F\nVRaRXP3vIb9TgHot0pGMYzHw7CTww6XScnwQbfQ3t+XmfHnqjLWCi65ItqwA3GV1\n7CpNX8GH9SBlK4GoRz6JI5UwFpB/6FcHSOcZrr9FZ7E3GwYq/t75rH2D+1665I+X\nZ75Ljo1kB1c4VWk0Nj0TSO9P4tNmHqTPGrdeNjPUtAa9GAH9d4RQAEX1jF3oI7x+\n/jXh7VB7qTCNGdMJjmhnXb88lxhTuylixcpecsHHltTbLaC0H2kD7OriUPEMPPCs\n81Mt8Bz17Ww5OXOAFshSsCPN4D7c3TxHoLs1iuKYaIu+5b9y7tL6pe0S7fyYGKkm\ndtwoSxAgHNN/Fnct7W+A90m7UwW7XWjH1Mh1Fj+JWov3F0fUTPHSiXk+TT2YqGHe\nOh7S+F4D4MHJHIzTjU3TlTazN19jY5szFPAtJmtTfImMMsJu7D0hADnJoWjiUIMu\nsDor8zagrC/kb2HCUQk5PotTubtn2txTuXZZNp1D5SDgPTJghSJRt8czu90VL6R4\npgd7gUY2BIbdeTXHlSw7sKMXNeVzH7RcWe/a6hBle3rQf5+ztCo3O3CLm1u5K7fs\nslESl1MpWtTwEhDcTwK7EpIvYtQ/aUN8Ddb8WHUBiJ1YFkveupD/RwGJBmr2X7KQ\narMCpgKIv7NHfirZ1fpoeDVNAgMBAAGjPzA9MA8GA1UdEwEB/wQFMAMBAf8wCwYD\nVR0PBAQDAgEGMB0GA1UdDgQWBBTwj1k4ALP1j5qWDNXr+nuqF+gTEjANBgkqhkiG\n9w0BAQUFAAOCAgEAvuRcYk4k9AwI//DTDGjkk0kiP0Qnb7tt3oNmzqjMDfz1mgbl\ndxSR651Be5kqhOX//CHBXfDkH1e3damhXwIm/9fH907eT/j3HEbAek9ALCI18Bmx\n0GtnLLCo4MBANzX2hFxc469CeP6nyQ1Q6g2EdvZR74NTxnr/DlZJLo961gzmJ1Tj\nTQpgcmLNkQfWpb/ImWvtxBnmq0wROMVvMeJuScg/doAmAyYp4Db29iBT4xdwNBed\nY2gea+zDTYa4EzAvXUYNR0PVG6pZDrlcjQZIrXSHX8f8MVRBE+LHIQ6e4B4N4cB7\nQ4WQxYpYxmUKeFfyxiMPAdkgS94P+5KFdSpcc41teyWRyu5FrgZLAMzTsVlQ2jqI\nOylDRl6XK1TOU2+NSueW+r9xDkKLfP0ooNBIytrEgUy7onOTJsjrDNYmiLbAJM+7\nvVvrdX3pCI6GMyx5dwlppYn8s3CQh3aP0yK7Qs69cwsgJirQmz1wHiRszYd2qReW\nt88NkvuOGKmYSdGe/mBEciG5Ge3C9THxOUiIkCR1VBatzvT4aRRkOfujuLpwQMcn\nHL/EVlP6Y2XQ8xwOFvVrhlhNGNTkDY6lnVuR3HYkUD/GKvvZt5y11ubQ2egZixVx\nSK236thZiNSQvxaz2emsWWFUyBy6ysHK4bkgTI86k4mloMy/0/Z1pHWWbVY=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            95:be:16:a0:f7:2e:46:f1:7b:39:82:72:fa:8b:cd:96\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: O=TeliaSonera, CN=TeliaSonera Root CA v1\n        Validity\n            Not Before: Oct 18 12:00:50 2007 GMT\n            Not After : Oct 18 12:00:50 2032 GMT\n        Subject: O=TeliaSonera, CN=TeliaSonera Root CA v1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:c2:be:eb:27:f0:21:a3:f3:69:26:55:7e:9d:c5:\n                    55:16:91:5c:fd:ef:21:bf:53:80:7a:2d:d2:91:8c:\n                    63:31:f0:ec:24:f0:c3:a5:d2:72:7c:10:6d:f4:37:\n                    b7:e5:e6:7c:79:ea:8c:b5:82:8b:ae:48:b6:ac:00:\n                    dc:65:75:ec:2a:4d:5f:c1:87:f5:20:65:2b:81:a8:\n                    47:3e:89:23:95:30:16:90:7f:e8:57:07:48:e7:19:\n                    ae:bf:45:67:b1:37:1b:06:2a:fe:de:f9:ac:7d:83:\n                    fb:5e:ba:e4:8f:97:67:be:4b:8e:8d:64:07:57:38:\n                    55:69:34:36:3d:13:48:ef:4f:e2:d3:66:1e:a4:cf:\n                    1a:b7:5e:36:33:d4:b4:06:bd:18:01:fd:77:84:50:\n                    00:45:f5:8c:5d:e8:23:bc:7e:fe:35:e1:ed:50:7b:\n                    a9:30:8d:19:d3:09:8e:68:67:5d:bf:3c:97:18:53:\n                    bb:29:62:c5:ca:5e:72:c1:c7:96:d4:db:2d:a0:b4:\n                    1f:69:03:ec:ea:e2:50:f1:0c:3c:f0:ac:f3:53:2d:\n                    f0:1c:f5:ed:6c:39:39:73:80:16:c8:52:b0:23:cd:\n                    e0:3e:dc:dd:3c:47:a0:bb:35:8a:e2:98:68:8b:be:\n                    e5:bf:72:ee:d2:fa:a5:ed:12:ed:fc:98:18:a9:26:\n                    76:dc:28:4b:10:20:1c:d3:7f:16:77:2d:ed:6f:80:\n                    f7:49:bb:53:05:bb:5d:68:c7:d4:c8:75:16:3f:89:\n                    5a:8b:f7:17:47:d4:4c:f1:d2:89:79:3e:4d:3d:98:\n                    a8:61:de:3a:1e:d2:f8:5e:03:e0:c1:c9:1c:8c:d3:\n                    8d:4d:d3:95:36:b3:37:5f:63:63:9b:33:14:f0:2d:\n                    26:6b:53:7c:89:8c:32:c2:6e:ec:3d:21:00:39:c9:\n                    a1:68:e2:50:83:2e:b0:3a:2b:f3:36:a0:ac:2f:e4:\n                    6f:61:c2:51:09:39:3e:8b:53:b9:bb:67:da:dc:53:\n                    b9:76:59:36:9d:43:e5:20:e0:3d:32:60:85:22:51:\n                    b7:c7:33:bb:dd:15:2f:a4:78:a6:07:7b:81:46:36:\n                    04:86:dd:79:35:c7:95:2c:3b:b0:a3:17:35:e5:73:\n                    1f:b4:5c:59:ef:da:ea:10:65:7b:7a:d0:7f:9f:b3:\n                    b4:2a:37:3b:70:8b:9b:5b:b9:2b:b7:ec:b2:51:12:\n                    97:53:29:5a:d4:f0:12:10:dc:4f:02:bb:12:92:2f:\n                    62:d4:3f:69:43:7c:0d:d6:fc:58:75:01:88:9d:58:\n                    16:4b:de:ba:90:ff:47:01:89:06:6a:f6:5f:b2:90:\n                    6a:b3:02:a6:02:88:bf:b3:47:7e:2a:d9:d5:fa:68:\n                    78:35:4d\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: \n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                F0:8F:59:38:00:B3:F5:8F:9A:96:0C:D5:EB:FA:7B:AA:17:E8:13:12\n    Signature Algorithm: sha1WithRSAEncryption\n         be:e4:5c:62:4e:24:f4:0c:08:ff:f0:d3:0c:68:e4:93:49:22:\n         3f:44:27:6f:bb:6d:de:83:66:ce:a8:cc:0d:fc:f5:9a:06:e5:\n         77:14:91:eb:9d:41:7b:99:2a:84:e5:ff:fc:21:c1:5d:f0:e4:\n         1f:57:b7:75:a9:a1:5f:02:26:ff:d7:c7:f7:4e:de:4f:f8:f7:\n         1c:46:c0:7a:4f:40:2c:22:35:f0:19:b1:d0:6b:67:2c:b0:a8:\n         e0:c0:40:37:35:f6:84:5c:5c:e3:af:42:78:fe:a7:c9:0d:50:\n         ea:0d:84:76:f6:51:ef:83:53:c6:7a:ff:0e:56:49:2e:8f:7a:\n         d6:0c:e6:27:54:e3:4d:0a:60:72:62:cd:91:07:d6:a5:bf:c8:\n         99:6b:ed:c4:19:e6:ab:4c:11:38:c5:6f:31:e2:6e:49:c8:3f:\n         76:80:26:03:26:29:e0:36:f6:f6:20:53:e3:17:70:34:17:9d:\n         63:68:1e:6b:ec:c3:4d:86:b8:13:30:2f:5d:46:0d:47:43:d5:\n         1b:aa:59:0e:b9:5c:8d:06:48:ad:74:87:5f:c7:fc:31:54:41:\n         13:e2:c7:21:0e:9e:e0:1e:0d:e1:c0:7b:43:85:90:c5:8a:58:\n         c6:65:0a:78:57:f2:c6:23:0f:01:d9:20:4b:de:0f:fb:92:85:\n         75:2a:5c:73:8d:6d:7b:25:91:ca:ee:45:ae:06:4b:00:cc:d3:\n         b1:59:50:da:3a:88:3b:29:43:46:5e:97:2b:54:ce:53:6f:8d:\n         4a:e7:96:fa:bf:71:0e:42:8b:7c:fd:28:a0:d0:48:ca:da:c4:\n         81:4c:bb:a2:73:93:26:c8:eb:0c:d6:26:88:b6:c0:24:cf:bb:\n         bd:5b:eb:75:7d:e9:08:8e:86:33:2c:79:77:09:69:a5:89:fc:\n         b3:70:90:87:76:8f:d3:22:bb:42:ce:bd:73:0b:20:26:2a:d0:\n         9b:3d:70:1e:24:6c:cd:87:76:a9:17:96:b7:cf:0d:92:fb:8e:\n         18:a9:98:49:d1:9e:fe:60:44:72:21:b9:19:ed:c2:f5:31:f1:\n         39:48:88:90:24:75:54:16:ad:ce:f4:f8:69:14:64:39:fb:a3:\n         b8:ba:70:40:c7:27:1c:bf:c4:56:53:fa:63:65:d0:f3:1c:0e:\n         16:f5:6b:86:58:4d:18:d4:e4:0d:8e:a5:9d:5b:91:dc:76:24:\n         50:3f:c6:2a:fb:d9:b7:9c:b5:d6:e6:d0:d9:e8:19:8b:15:71:\n         48:ad:b7:ea:d8:59:88:d4:90:bf:16:b3:d9:e9:ac:59:61:54:\n         c8:1c:ba:ca:c1:ca:e1:b9:20:4c:8f:3a:93:89:a5:a0:cc:bf:\n         d3:f6:75:a4:75:96:6d:56\nSHA1 Fingerprint=43:13:BB:96:F1:D5:86:9B:C1:4E:6A:92:F6:CF:F6:34:69:87:82:37\n",
    "f2c013e082433efbee2f673296355cdbb8cb02d0": "-----BEGIN CERTIFICATE-----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\n4SVhM7JZG+Ju1zdXtg2pEto=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 1478 (0x5c6)\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 3\n        Validity\n            Not Before: Nov 24 19:11:23 2006 GMT\n            Not After : Nov 24 19:06:44 2031 GMT\n        Subject: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 3\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:cc:57:42:16:54:9c:e6:98:d3:d3:4d:ee:fe:ed:\n                    c7:9f:43:39:4a:65:b3:e8:16:88:34:db:0d:59:91:\n                    74:cf:92:b8:04:40:ad:02:4b:31:ab:bc:8d:91:68:\n                    d8:20:0e:1a:01:e2:1a:7b:4e:17:5d:e2:8a:b7:3f:\n                    99:1a:cd:eb:61:ab:c2:65:a6:1f:b7:b7:bd:b7:8f:\n                    fc:fd:70:8f:0b:a0:67:be:01:a2:59:cf:71:e6:0f:\n                    29:76:ff:b1:56:79:45:2b:1f:9e:7a:54:e8:a3:29:\n                    35:68:a4:01:4f:0f:a4:2e:37:ef:1b:bf:e3:8f:10:\n                    a8:72:ab:58:57:e7:54:86:c8:c9:f3:5b:da:2c:da:\n                    5d:8e:6e:3c:a3:3e:da:fb:82:e5:dd:f2:5c:b2:05:\n                    33:6f:8a:36:ce:d0:13:4e:ff:bf:4a:0c:34:4c:a6:\n                    c3:21:bd:50:04:55:eb:b1:bb:9d:fb:45:1e:64:15:\n                    de:55:01:8c:02:76:b5:cb:a1:3f:42:69:bc:2f:bd:\n                    68:43:16:56:89:2a:37:61:91:fd:a6:ae:4e:c0:cb:\n                    14:65:94:37:4b:92:06:ef:04:d0:c8:9c:88:db:0b:\n                    7b:81:af:b1:3d:2a:c4:65:3a:78:b6:ee:dc:80:b1:\n                    d2:d3:99:9c:3a:ee:6b:5a:6b:b3:8d:b7:d5:ce:9c:\n                    c2:be:a5:4b:2f:16:b1:9e:68:3b:06:6f:ae:7d:9f:\n                    f8:de:ec:cc:29:a7:98:a3:25:43:2f:ef:f1:5f:26:\n                    e1:88:4d:f8:5e:6e:d7:d9:14:6e:19:33:69:a7:3b:\n                    84:89:93:c4:53:55:13:a1:51:78:40:f8:b8:c9:a2:\n                    ee:7b:ba:52:42:83:9e:14:ed:05:52:5a:59:56:a7:\n                    97:fc:9d:3f:0a:29:d8:dc:4f:91:0e:13:bc:de:95:\n                    a4:df:8b:99:be:ac:9b:33:88:ef:b5:81:af:1b:c6:\n                    22:53:c8:f6:c7:ee:97:14:b0:c5:7c:78:52:c8:f0:\n                    ce:6e:77:60:84:a6:e9:2a:76:20:ed:58:01:17:30:\n                    93:e9:1a:8b:e0:73:63:d9:6a:92:94:49:4e:b4:ad:\n                    4a:85:c4:a3:22:30:fc:09:ed:68:22:73:a6:88:0c:\n                    55:21:58:c5:e1:3a:9f:2a:dd:ca:e1:90:e0:d9:73:\n                    ab:6c:80:b8:e8:0b:64:93:a0:9c:8c:19:ff:b3:d2:\n                    0c:ec:91:26:87:8a:b3:a2:e1:70:8f:2c:0a:e5:cd:\n                    6d:68:51:eb:da:3f:05:7f:8b:32:e6:13:5c:6b:fe:\n                    5f:40:e2:22:c8:b4:b4:64:4f:d6:ba:7d:48:3e:a8:\n                    69:0c:d7:bb:86:71:c9:73:b8:3f:3b:9d:25:4b:da:\n                    ff:40:eb\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Certificate Policies: \n                Policy: 1.3.6.1.4.1.8024.0.3\n                  User Notice:\n                    Explicit Text: Any use of this Certificate constitutes acceptance of the QuoVadis Root CA 3 Certificate Policy / Certification Practice Statement.\n                  CPS: http://www.quovadisglobal.com/cps\n\n            X509v3 Key Usage: \n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                F2:C0:13:E0:82:43:3E:FB:EE:2F:67:32:96:35:5C:DB:B8:CB:02:D0\n            X509v3 Authority Key Identifier: \n                keyid:F2:C0:13:E0:82:43:3E:FB:EE:2F:67:32:96:35:5C:DB:B8:CB:02:D0\n                DirName:/C=BM/O=QuoVadis Limited/CN=QuoVadis Root CA 3\n                serial:05:C6\n\n    Signature Algorithm: sha1WithRSAEncryption\n         4f:ad:a0:2c:4c:fa:c0:f2:6f:f7:66:55:ab:23:34:ee:e7:29:\n         da:c3:5b:b6:b0:83:d9:d0:d0:e2:21:fb:f3:60:a7:3b:5d:60:\n         53:27:a2:9b:f6:08:22:2a:e7:bf:a0:72:e5:9c:24:6a:31:b1:\n         90:7a:27:db:84:11:89:27:a6:77:5a:38:d7:bf:ac:86:fc:ee:\n         5d:83:bc:06:c6:d1:77:6b:0f:6d:24:2f:4b:7a:6c:a7:07:96:\n         ca:e3:84:9f:ad:88:8b:1d:ab:16:8d:5b:66:17:d9:16:f4:8b:\n         80:d2:dd:f8:b2:76:c3:fc:38:13:aa:0c:de:42:69:2b:6e:f3:\n         3c:eb:80:27:db:f5:a6:44:0d:9f:5a:55:59:0b:d5:0d:52:48:\n         c5:ae:9f:f2:2f:80:c5:ea:32:50:35:12:97:2e:c1:e1:ff:f1:\n         23:88:51:38:9f:f2:66:56:76:e7:0f:51:97:a5:52:0c:4d:49:\n         51:95:36:3d:bf:a2:4b:0c:10:1d:86:99:4c:aa:f3:72:11:93:\n         e4:ea:f6:9b:da:a8:5d:a7:4d:b7:9e:02:ae:73:00:c8:da:23:\n         03:e8:f9:ea:19:74:62:00:94:cb:22:20:be:94:a7:59:b5:82:\n         6a:be:99:79:7a:a9:f2:4a:24:52:f7:74:fd:ba:4e:e6:a8:1d:\n         02:6e:b1:0d:80:44:c1:ae:d3:23:37:5f:bb:85:7c:2b:92:2e:\n         e8:7e:a5:8b:dd:99:e1:bf:27:6f:2d:5d:aa:7b:87:fe:0a:dd:\n         4b:fc:8e:f5:26:e4:6e:70:42:6e:33:ec:31:9e:7b:93:c1:e4:\n         c9:69:1a:3d:c0:6b:4e:22:6d:ee:ab:58:4d:c6:d0:41:c1:2b:\n         ea:4f:12:87:5e:eb:45:d8:6c:f5:98:02:d3:a0:d8:55:8a:06:\n         99:19:a2:a0:77:d1:30:9e:ac:cc:75:ee:83:f5:b0:62:39:cf:\n         6c:57:e2:4c:d2:91:0b:0e:75:28:1b:9a:bf:fd:1a:43:f1:ca:\n         77:fb:3b:8f:61:b8:69:28:16:42:04:5e:70:2a:1c:21:d8:8f:\n         e1:bd:23:5b:2d:74:40:92:d9:63:19:0d:73:dd:69:bc:62:47:\n         bc:e0:74:2b:b2:eb:7d:be:41:1b:b5:c0:46:c5:a1:22:cb:5f:\n         4e:c1:28:92:de:18:ba:d5:2a:28:bb:11:8b:17:93:98:99:60:\n         94:5c:23:cf:5a:27:97:5e:0b:05:06:93:37:1e:3b:69:36:eb:\n         a9:9e:61:1d:8f:32:da:8e:0c:d6:74:3e:7b:09:24:da:01:77:\n         47:c4:3b:cd:34:8c:99:f5:ca:e1:25:61:33:b2:59:1b:e2:6e:\n         d7:37:57:b6:0d:a9:12:da\nSHA1 Fingerprint=1F:49:14:F7:D8:74:95:1D:DD:AE:02:C0:BE:FD:3A:2D:82:75:51:85\n",
    "f77dc5fdc4e89a1b7764a7f51da0ccbf87609a6d": "-----BEGIN CERTIFICATE-----\nMIIFgzCCA2ugAwIBAgIPXZONMGc2yAYdGsdUhGkHMA0GCSqGSIb3DQEBCwUAMDsx\nCzAJBgNVBAYTAkVTMREwDwYDVQQKDAhGTk1ULVJDTTEZMBcGA1UECwwQQUMgUkFJ\nWiBGTk1ULVJDTTAeFw0wODEwMjkxNTU5NTZaFw0zMDAxMDEwMDAwMDBaMDsxCzAJ\nBgNVBAYTAkVTMREwDwYDVQQKDAhGTk1ULVJDTTEZMBcGA1UECwwQQUMgUkFJWiBG\nTk1ULVJDTTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBALpxgHpMhm5/\nyBNtwMZ9HACXjywMI7sQmkCpGreHiPibVmr75nuOi5KOpyVdWRHbNi63URcfqQgf\nBBckWKo3Shjf5TnUV/3XwSyRAZHiItQDwFj8d0fsjz50Q7qsNI1NOHZnjrDIbzAz\nWHFctPVrbtQBULgTfmxKo0nRIBnuvMApGGWn3v7v3QqQIecaZ5JCEJhfTzC8PhxF\ntBDXaEAUwED653cXeuYLj2VbPNmaUtu1vZ5Gzz3rkQUCwJaydkxNEJY7kvqcfw+Z\n374jNUUeAlz+taibmSXaXvMiwzn15Cou08YfxGyqxRxqAQVKL9LFwag0Jl1mpdIC\nIfkYtwb1TplvqKtMUejPUBjFd8g5CSxJkjKZqLsXF3mwWsXmo8RZZUc1g16p6DUL\nmbvkzSDGm0oGObVo/CK67lWMK07q87Hj/LaZmtVC+nFNCM+HHmpxffnTtOmlcYF7\nwk5HlqX2doWjKI/pgG6BU6VtX7hI+cL5NqYuSf+4lsKMB7ObiFj86xsc3i1w4peS\nMKGJ47xVqCfWS+2QrYv6YyVZLag13cqXM7zlzced0ezvXg5KkAYmY6252TUtB7p2\nZSysV4999AeU14ECll2jB0nVetBX+RvnU0Z1qrB5QstocQjpYL05ac70r8NWQMet\nUqIJ5G+GR4of6ygnXYMgrwTJbFaai0b1AgMBAAGjgYMwgYAwDwYDVR0TAQH/BAUw\nAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFPd9xf3E6Jobd2Sn9R2gzL+H\nYJptMD4GA1UdIAQ3MDUwMwYEVR0gADArMCkGCCsGAQUFBwIBFh1odHRwOi8vd3d3\nLmNlcnQuZm5tdC5lcy9kcGNzLzANBgkqhkiG9w0BAQsFAAOCAgEAB5BK3/MjTvDD\nnFFlm5wioooMhfNzKWtN/gHiqQxjAb8EZ6WdmF/9ARP67Jpi6Yb+tmLSbkyU+8B1\nRXxlDPiyN8+sD8+Nb/kZ94/sHvJwnvDKuO+3/3Y3dlv2bojzr2IyIpMNOmqOFGYM\nLVN0V2Ue1bLdI4E7pWYjJ2cJj+F3qkPNZVEI7VFY/uY5+ctHhKQV8Xa7pO6kO8Rf\n77IzlhEYt8llvhjho6Tc+hj507wTmzl6NLrTQfv6MooqtyuGC2mDOL7Nii4LcK2N\nJpLuHvUBKwrZ1pebbuCoGRw6IYsMHkCtA+fdZn71uSANA+iW+YJF1DngoABd15jm\nfZ5nc8OaKveri6E6FO80vFIOiZiaBECEHX5FaZNXzuvO+FB8TxxuBEOb+dY7Ixjp\n6o7RTUaN8Tvkasq6+yO3m/qZASlaWFot4/nUbQ4mrcFuNLwy+AwF+mWj2zs3gyLp\n1txyM/1d8iC9djwj2ij3+RvrWWTV3F9yfiD8zYm1kGdNYno/Tq0dwzn+evQoFt9B\n9kiABdcPUXmsEKvU7ANm5mqwujGSQkBqvjrTcuFqN1W8rB2Vt2lh8kORdOag0wok\nRqEIr9baRRmW1FMdW4R58MD3R++Lj8UGrp1MYp3/RgT408m2ECVAdf4WqslKYIYv\nuu8wd+RU4riEmViAqhOLUTpPSPaLtrM=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            5d:93:8d:30:67:36:c8:06:1d:1a:c7:54:84:69:07\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=ES, O=FNMT-RCM, OU=AC RAIZ FNMT-RCM\n        Validity\n            Not Before: Oct 29 15:59:56 2008 GMT\n            Not After : Jan  1 00:00:00 2030 GMT\n        Subject: C=ES, O=FNMT-RCM, OU=AC RAIZ FNMT-RCM\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:ba:71:80:7a:4c:86:6e:7f:c8:13:6d:c0:c6:7d:\n                    1c:00:97:8f:2c:0c:23:bb:10:9a:40:a9:1a:b7:87:\n                    88:f8:9b:56:6a:fb:e6:7b:8e:8b:92:8e:a7:25:5d:\n                    59:11:db:36:2e:b7:51:17:1f:a9:08:1f:04:17:24:\n                    58:aa:37:4a:18:df:e5:39:d4:57:fd:d7:c1:2c:91:\n                    01:91:e2:22:d4:03:c0:58:fc:77:47:ec:8f:3e:74:\n                    43:ba:ac:34:8d:4d:38:76:67:8e:b0:c8:6f:30:33:\n                    58:71:5c:b4:f5:6b:6e:d4:01:50:b8:13:7e:6c:4a:\n                    a3:49:d1:20:19:ee:bc:c0:29:18:65:a7:de:fe:ef:\n                    dd:0a:90:21:e7:1a:67:92:42:10:98:5f:4f:30:bc:\n                    3e:1c:45:b4:10:d7:68:40:14:c0:40:fa:e7:77:17:\n                    7a:e6:0b:8f:65:5b:3c:d9:9a:52:db:b5:bd:9e:46:\n                    cf:3d:eb:91:05:02:c0:96:b2:76:4c:4d:10:96:3b:\n                    92:fa:9c:7f:0f:99:df:be:23:35:45:1e:02:5c:fe:\n                    b5:a8:9b:99:25:da:5e:f3:22:c3:39:f5:e4:2a:2e:\n                    d3:c6:1f:c4:6c:aa:c5:1c:6a:01:05:4a:2f:d2:c5:\n                    c1:a8:34:26:5d:66:a5:d2:02:21:f9:18:b7:06:f5:\n                    4e:99:6f:a8:ab:4c:51:e8:cf:50:18:c5:77:c8:39:\n                    09:2c:49:92:32:99:a8:bb:17:17:79:b0:5a:c5:e6:\n                    a3:c4:59:65:47:35:83:5e:a9:e8:35:0b:99:bb:e4:\n                    cd:20:c6:9b:4a:06:39:b5:68:fc:22:ba:ee:55:8c:\n                    2b:4e:ea:f3:b1:e3:fc:b6:99:9a:d5:42:fa:71:4d:\n                    08:cf:87:1e:6a:71:7d:f9:d3:b4:e9:a5:71:81:7b:\n                    c2:4e:47:96:a5:f6:76:85:a3:28:8f:e9:80:6e:81:\n                    53:a5:6d:5f:b8:48:f9:c2:f9:36:a6:2e:49:ff:b8:\n                    96:c2:8c:07:b3:9b:88:58:fc:eb:1b:1c:de:2d:70:\n                    e2:97:92:30:a1:89:e3:bc:55:a8:27:d6:4b:ed:90:\n                    ad:8b:fa:63:25:59:2d:a8:35:dd:ca:97:33:bc:e5:\n                    cd:c7:9d:d1:ec:ef:5e:0e:4a:90:06:26:63:ad:b9:\n                    d9:35:2d:07:ba:76:65:2c:ac:57:8f:7d:f4:07:94:\n                    d7:81:02:96:5d:a3:07:49:d5:7a:d0:57:f9:1b:e7:\n                    53:46:75:aa:b0:79:42:cb:68:71:08:e9:60:bd:39:\n                    69:ce:f4:af:c3:56:40:c7:ad:52:a2:09:e4:6f:86:\n                    47:8a:1f:eb:28:27:5d:83:20:af:04:c9:6c:56:9a:\n                    8b:46:f5\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                F7:7D:C5:FD:C4:E8:9A:1B:77:64:A7:F5:1D:A0:CC:BF:87:60:9A:6D\n            X509v3 Certificate Policies: \n                Policy: X509v3 Any Policy\n                  CPS: http://www.cert.fnmt.es/dpcs/\n\n    Signature Algorithm: sha256WithRSAEncryption\n         07:90:4a:df:f3:23:4e:f0:c3:9c:51:65:9b:9c:22:a2:8a:0c:\n         85:f3:73:29:6b:4d:fe:01:e2:a9:0c:63:01:bf:04:67:a5:9d:\n         98:5f:fd:01:13:fa:ec:9a:62:e9:86:fe:b6:62:d2:6e:4c:94:\n         fb:c0:75:45:7c:65:0c:f8:b2:37:cf:ac:0f:cf:8d:6f:f9:19:\n         f7:8f:ec:1e:f2:70:9e:f0:ca:b8:ef:b7:ff:76:37:76:5b:f6:\n         6e:88:f3:af:62:32:22:93:0d:3a:6a:8e:14:66:0c:2d:53:74:\n         57:65:1e:d5:b2:dd:23:81:3b:a5:66:23:27:67:09:8f:e1:77:\n         aa:43:cd:65:51:08:ed:51:58:fe:e6:39:f9:cb:47:84:a4:15:\n         f1:76:bb:a4:ee:a4:3b:c4:5f:ef:b2:33:96:11:18:b7:c9:65:\n         be:18:e1:a3:a4:dc:fa:18:f9:d3:bc:13:9b:39:7a:34:ba:d3:\n         41:fb:fa:32:8a:2a:b7:2b:86:0b:69:83:38:be:cd:8a:2e:0b:\n         70:ad:8d:26:92:ee:1e:f5:01:2b:0a:d9:d6:97:9b:6e:e0:a8:\n         19:1c:3a:21:8b:0c:1e:40:ad:03:e7:dd:66:7e:f5:b9:20:0d:\n         03:e8:96:f9:82:45:d4:39:e0:a0:00:5d:d7:98:e6:7d:9e:67:\n         73:c3:9a:2a:f7:ab:8b:a1:3a:14:ef:34:bc:52:0e:89:98:9a:\n         04:40:84:1d:7e:45:69:93:57:ce:eb:ce:f8:50:7c:4f:1c:6e:\n         04:43:9b:f9:d6:3b:23:18:e9:ea:8e:d1:4d:46:8d:f1:3b:e4:\n         6a:ca:ba:fb:23:b7:9b:fa:99:01:29:5a:58:5a:2d:e3:f9:d4:\n         6d:0e:26:ad:c1:6e:34:bc:32:f8:0c:05:fa:65:a3:db:3b:37:\n         83:22:e9:d6:dc:72:33:fd:5d:f2:20:bd:76:3c:23:da:28:f7:\n         f9:1b:eb:59:64:d5:dc:5f:72:7e:20:fc:cd:89:b5:90:67:4d:\n         62:7a:3f:4e:ad:1d:c3:39:fe:7a:f4:28:16:df:41:f6:48:80:\n         05:d7:0f:51:79:ac:10:ab:d4:ec:03:66:e6:6a:b0:ba:31:92:\n         42:40:6a:be:3a:d3:72:e1:6a:37:55:bc:ac:1d:95:b7:69:61:\n         f2:43:91:74:e6:a0:d3:0a:24:46:a1:08:af:d6:da:45:19:96:\n         d4:53:1d:5b:84:79:f0:c0:f7:47:ef:8b:8f:c5:06:ae:9d:4c:\n         62:9d:ff:46:04:f8:d3:c9:b6:10:25:40:75:fe:16:aa:c9:4a:\n         60:86:2f:ba:ef:30:77:e4:54:e2:b8:84:99:58:80:aa:13:8b:\n         51:3a:4f:48:f6:8b:b6:b3\nSHA1 Fingerprint=EC:50:35:07:B2:15:C4:95:62:19:E2:A8:9A:5B:42:99:2C:4C:2C:20\n",
    "f924ac0fb2b5f879c0fa60881bc4d94d029e1719": "-----BEGIN CERTIFICATE-----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\nd0jQ\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            a3:da:42:7e:a4:b1:ae:da\n        Signature Algorithm: sha1WithRSAEncryption\n        Issuer: C=EU, L=Madrid (see current address at www.camerfirma.com/address)/serialNumber=A82743287, O=AC Camerfirma S.A., CN=Chambers of Commerce Root - 2008\n        Validity\n            Not Before: Aug  1 12:29:50 2008 GMT\n            Not After : Jul 31 12:29:50 2038 GMT\n        Subject: C=EU, L=Madrid (see current address at www.camerfirma.com/address)/serialNumber=A82743287, O=AC Camerfirma S.A., CN=Chambers of Commerce Root - 2008\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:af:00:cb:70:37:2b:80:5a:4a:3a:6c:78:94:7d:\n                    a3:7f:1a:1f:f6:35:d5:bd:db:cb:0d:44:72:3e:26:\n                    b2:90:52:ba:63:3b:28:58:6f:a5:b3:6d:94:a6:f3:\n                    dd:64:0c:55:f6:f6:e7:f2:22:22:80:5e:e1:62:c6:\n                    b6:29:e1:81:6c:f2:bf:e5:7d:32:6a:54:a0:32:19:\n                    59:fe:1f:8b:d7:3d:60:86:85:24:6f:e3:11:b3:77:\n                    3e:20:96:35:21:6b:b3:08:d9:70:2e:64:f7:84:92:\n                    53:d6:0e:b0:90:8a:8a:e3:87:8d:06:d3:bd:90:0e:\n                    e2:99:a1:1b:86:0e:da:9a:0a:bb:0b:61:50:06:52:\n                    f1:9e:7f:76:ec:cb:0f:d0:1e:0d:cf:99:30:3d:1c:\n                    c4:45:10:58:ac:d6:d3:e8:d7:e5:ea:c5:01:07:77:\n                    d6:51:e6:03:7f:8a:48:a5:4d:68:75:b9:e9:bc:9e:\n                    4e:19:71:f5:32:4b:9c:6d:60:19:0b:fb:cc:9d:75:\n                    dc:bf:26:cd:8f:93:78:39:79:73:5e:25:0e:ca:5c:\n                    eb:77:12:07:cb:64:41:47:72:93:ab:50:c3:eb:09:\n                    76:64:34:d2:39:b7:76:11:09:0d:76:45:c4:a9:ae:\n                    3d:6a:af:b5:7d:65:2f:94:58:10:ec:5c:7c:af:7e:\n                    e2:b6:18:d9:d0:9b:4e:5a:49:df:a9:66:0b:cc:3c:\n                    c6:78:7c:a7:9c:1d:e3:ce:8e:53:be:05:de:60:0f:\n                    6b:e5:1a:db:3f:e3:e1:21:c9:29:c1:f1:eb:07:9c:\n                    52:1b:01:44:51:3c:7b:25:d7:c4:e5:52:54:5d:25:\n                    07:ca:16:20:b8:ad:e4:41:ee:7a:08:fe:99:6f:83:\n                    a6:91:02:b0:6c:36:55:6a:e7:7d:f5:96:e6:ca:81:\n                    d6:97:f1:94:83:e9:ed:b0:b1:6b:12:69:1e:ac:fb:\n                    5d:a9:c5:98:e9:b4:5b:58:7a:be:3d:a2:44:3a:63:\n                    59:d4:0b:25:de:1b:4f:bd:e5:01:9e:cd:d2:29:d5:\n                    9f:17:19:0a:6f:bf:0c:90:d3:09:5f:d9:e3:8a:35:\n                    cc:79:5a:4d:19:37:92:b7:c4:c1:ad:af:f4:79:24:\n                    9a:b2:01:0b:b1:af:5c:96:f3:80:32:fb:5c:3d:98:\n                    f1:a0:3f:4a:de:be:af:94:2e:d9:55:9a:17:6e:60:\n                    9d:63:6c:b8:63:c9:ae:81:5c:18:35:e0:90:bb:be:\n                    3c:4f:37:22:b9:7e:eb:cf:9e:77:21:a6:3d:38:81:\n                    fb:48:da:31:3d:2b:e3:89:f5:d0:b5:bd:7e:e0:50:\n                    c4:12:89:b3:23:9a:10:31:85:db:ae:6f:ef:38:33:\n                    18:76:11\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE, pathlen:12\n            X509v3 Subject Key Identifier: \n                F9:24:AC:0F:B2:B5:F8:79:C0:FA:60:88:1B:C4:D9:4D:02:9E:17:19\n            X509v3 Authority Key Identifier: \n                keyid:F9:24:AC:0F:B2:B5:F8:79:C0:FA:60:88:1B:C4:D9:4D:02:9E:17:19\n                DirName:/C=EU/L=Madrid (see current address at www.camerfirma.com/address)/serialNumber=A82743287/O=AC Camerfirma S.A./CN=Chambers of Commerce Root - 2008\n                serial:A3:DA:42:7E:A4:B1:AE:DA\n\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Certificate Policies: \n                Policy: X509v3 Any Policy\n                  CPS: http://policy.camerfirma.com\n\n    Signature Algorithm: sha1WithRSAEncryption\n         90:12:af:22:35:c2:a3:39:f0:2e:de:e9:b5:e9:78:7c:48:be:\n         3f:7d:45:92:5e:e9:da:b1:19:fc:16:3c:9f:b4:5b:66:9e:6a:\n         e7:c3:b9:5d:88:e8:0f:ad:cf:23:0f:de:25:3a:5e:cc:4f:a5:\n         c1:b5:2d:ac:24:d2:58:07:de:a2:cf:69:84:60:33:e8:10:0d:\n         13:a9:23:d0:85:e5:8e:7b:a6:9e:3d:72:13:72:33:f5:aa:7d:\n         c6:63:1f:08:f4:fe:01:7f:24:cf:2b:2c:54:09:de:e2:2b:6d:\n         92:c6:39:4f:16:ea:3c:7e:7a:46:d4:45:6a:46:a8:eb:75:82:\n         56:a7:ab:a0:7c:68:13:33:f6:9d:30:f0:6f:27:39:24:23:2a:\n         90:fd:90:29:35:f2:93:df:34:a5:c6:f7:f8:ef:8c:0f:62:4a:\n         7c:ae:d3:f5:54:f8:8d:b6:9a:56:87:16:82:3a:33:ab:5a:22:\n         08:f7:82:ba:ea:2e:e0:47:9a:b4:b5:45:a3:05:3b:d9:dc:2e:\n         45:40:3b:ea:dc:7f:e8:3b:eb:d1:ec:26:d8:35:a4:30:c5:3a:\n         ac:57:9e:b3:76:a5:20:7b:f9:1e:4a:05:62:01:a6:28:75:60:\n         97:92:0d:6e:3e:4d:37:43:0d:92:15:9c:18:22:cd:51:99:a0:\n         29:1a:3c:5f:8a:32:33:5b:30:c7:89:2f:47:98:0f:a3:03:c6:\n         f6:f1:ac:df:32:f0:d9:81:1a:e4:9c:bd:f6:80:14:f0:d1:2c:\n         b9:85:f5:d8:a3:b1:c8:a5:21:e5:1c:13:97:ee:0e:bd:df:29:\n         a9:ef:34:53:5b:d3:e4:6a:13:84:06:b6:32:02:c4:52:ae:22:\n         d2:dc:b2:21:42:1a:da:40:f0:29:c9:ec:0a:0c:5c:e2:d0:ba:\n         cc:48:d3:37:0a:cc:12:0a:8a:79:b0:3d:03:7f:69:4b:f4:34:\n         20:7d:b3:34:ea:8e:4b:64:f5:3e:fd:b3:23:67:15:0d:04:b8:\n         f0:2d:c1:09:51:3c:b2:6c:15:f0:a5:23:d7:83:74:e4:e5:2e:\n         c9:fe:98:27:42:c6:ab:c6:9e:b0:d0:5b:38:a5:9b:50:de:7e:\n         18:98:b5:45:3b:f6:79:b4:e8:f7:1a:7b:06:83:fb:d0:8b:da:\n         bb:c7:bd:18:ab:08:6f:3c:80:6b:40:3f:19:19:ba:65:8a:e6:\n         be:d5:5c:d3:36:d7:ef:40:52:24:60:38:67:04:31:ec:8f:f3:\n         82:c6:de:b9:55:f3:3b:31:91:5a:dc:b5:08:15:ad:76:25:0a:\n         0d:7b:2e:87:e2:0c:a6:06:bc:26:10:6d:37:9d:ec:dd:78:8c:\n         7c:80:c5:f0:d9:77:48:d0\nSHA1 Fingerprint=78:6A:74:AC:76:AB:14:7F:9C:6A:30:50:BA:9E:A8:7E:FE:9A:CE:3C\n",
    "f960bbd4e3d534f6b8f5068025a773db4669a89e": "-----BEGIN CERTIFICATE-----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\nmKVx01QT2WDz9UtmT/rx7iASjbSsV7FFY6GsdqnC+w==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 6248227494352943350 (0x56b629cd34bc78f6)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com EV Root Certification Authority RSA R2\n        Validity\n            Not Before: May 31 18:14:37 2017 GMT\n            Not After : May 30 18:14:37 2042 GMT\n        Subject: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com EV Root Certification Authority RSA R2\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:8f:36:65:40:e1:d6:4d:c0:d7:b4:e9:46:da:6b:\n                    ea:33:47:cd:4c:f9:7d:7d:be:bd:2d:3d:f0:db:78:\n                    e1:86:a5:d9:ba:09:57:68:ed:57:3e:a0:d0:08:41:\n                    83:e7:28:41:24:1f:e3:72:15:d0:01:1a:fb:5e:70:\n                    23:b2:cb:9f:39:e3:cf:c5:4e:c6:92:6d:26:c6:7b:\n                    bb:b3:da:27:9d:0a:86:e9:81:37:05:fe:f0:71:71:\n                    ec:c3:1c:e9:63:a2:17:14:9d:ef:1b:67:d3:85:55:\n                    02:02:d6:49:c9:cc:5a:e1:b1:f7:6f:32:9f:c9:d4:\n                    3b:88:41:a8:9c:bd:cb:ab:db:6d:7b:09:1f:a2:4c:\n                    72:90:da:2b:08:fc:cf:3c:54:ce:67:0f:a8:cf:5d:\n                    96:19:0b:c4:e3:72:eb:ad:d1:7d:1d:27:ef:92:eb:\n                    10:bf:5b:eb:3b:af:cf:80:dd:c1:d2:96:04:5b:7a:\n                    7e:a4:a9:3c:38:76:a4:62:8e:a0:39:5e:ea:77:cf:\n                    5d:00:59:8f:66:2c:3e:07:a2:a3:05:26:11:69:97:\n                    ea:85:b7:0f:96:0b:4b:c8:40:e1:50:ba:2e:8a:cb:\n                    f7:0f:9a:22:e7:7f:9a:37:13:cd:f2:4d:13:6b:21:\n                    d1:c0:cc:22:f2:a1:46:f6:44:69:9c:ca:61:35:07:\n                    00:6f:d6:61:08:11:ea:ba:b8:f6:e9:b3:60:e5:4d:\n                    b9:ec:9f:14:66:c9:57:58:db:cd:87:69:f8:8a:86:\n                    12:03:47:bf:66:13:76:ac:77:7d:34:24:85:83:cd:\n                    d7:aa:9c:90:1a:9f:21:2c:7f:78:b7:64:b8:d8:e8:\n                    a6:f4:78:b3:55:cb:84:d2:32:c4:78:ae:a3:8f:61:\n                    dd:ce:08:53:ad:ec:88:fc:15:e4:9a:0d:e6:9f:1a:\n                    77:ce:4c:8f:b8:14:15:3d:62:9c:86:38:06:00:66:\n                    12:e4:59:76:5a:53:c0:02:98:a2:10:2b:68:44:7b:\n                    8e:79:ce:33:4a:76:aa:5b:81:16:1b:b5:8a:d8:d0:\n                    00:7b:5e:62:b4:09:d6:86:63:0e:a6:05:95:49:ba:\n                    28:8b:88:93:b2:34:1c:d8:a4:55:6e:b7:1c:d0:de:\n                    99:55:3b:23:f4:22:e0:f9:29:66:26:ec:20:50:77:\n                    db:4a:0b:8f:be:e5:02:60:70:41:5e:d4:ae:50:39:\n                    22:14:26:cb:b2:3b:73:74:55:47:07:79:81:39:a8:\n                    30:13:44:e5:04:8a:ae:96:13:25:42:0f:b9:53:c4:\n                    9b:fc:cd:e4:1c:de:3c:fa:ab:d6:06:4a:1f:67:a6:\n                    98:30:1c:dd:2c:db:dc:18:95:57:66:c6:ff:5c:8b:\n                    56:f5:77\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Authority Key Identifier: \n                keyid:F9:60:BB:D4:E3:D5:34:F6:B8:F5:06:80:25:A7:73:DB:46:69:A8:9E\n\n            X509v3 Subject Key Identifier: \n                F9:60:BB:D4:E3:D5:34:F6:B8:F5:06:80:25:A7:73:DB:46:69:A8:9E\n            X509v3 Key Usage: critical\n                Digital Signature, Certificate Sign, CRL Sign\n    Signature Algorithm: sha256WithRSAEncryption\n         56:b3:8e:cb:0a:9d:49:8e:bf:a4:c4:91:bb:66:17:05:51:98:\n         75:fb:e5:50:2c:7a:9e:f1:14:fa:ab:d3:8a:3e:ff:91:29:8f:\n         63:8b:d8:b4:a9:54:01:0d:be:93:86:2f:f9:4a:6d:c7:5e:f5:\n         57:f9:ca:55:1c:12:be:47:0f:36:c5:df:6a:b7:db:75:c2:47:\n         25:7f:b9:f1:63:f8:68:2d:55:04:d1:f2:8d:b0:a4:cf:bc:3c:\n         5e:1f:78:e7:a5:a0:20:70:b0:04:c5:b7:f7:72:a7:de:22:0d:\n         bd:33:25:46:8c:64:92:26:e3:3e:2e:63:96:da:9b:8c:3d:f8:\n         18:09:d7:03:cc:7d:86:82:e0:ca:04:07:51:50:d7:ff:92:d5:\n         0c:ef:da:86:9f:99:d7:eb:b7:af:68:e2:39:26:94:ba:68:b7:\n         bf:83:d3:ea:7a:67:3d:62:67:ae:25:e5:72:e8:e2:e4:ec:ae:\n         12:f6:4b:2b:3c:9f:e9:b0:40:f3:38:54:b3:fd:b7:68:c8:da:\n         c6:8f:51:3c:b2:fb:91:dc:1c:e7:9b:9d:e1:b7:0d:72:8f:e2:\n         a4:c4:a9:78:f9:eb:14:ac:c6:43:05:c2:65:39:28:18:02:c3:\n         82:b2:9d:05:be:65:ed:96:5f:65:74:3c:fb:09:35:2e:7b:9c:\n         13:fd:1b:0f:5d:c7:6d:81:3a:56:0f:cc:3b:e1:af:02:2f:22:\n         ac:46:ca:46:3c:a0:1c:4c:d6:44:b4:5e:2e:5c:15:66:09:e1:\n         26:29:fe:c6:52:61:ba:b1:73:ff:c3:0c:9c:e5:6c:6a:94:3f:\n         14:ca:40:16:95:84:f3:59:a9:ac:5f:4c:61:93:6d:d1:3b:cc:\n         a2:95:0c:22:a6:67:67:44:2e:b9:d9:d2:8a:41:b3:66:0b:5a:\n         fb:7d:23:a5:f2:1a:b0:ff:de:9b:83:94:2e:d1:3f:df:92:b7:\n         91:af:05:3b:65:c7:a0:6c:b1:cd:62:12:c3:90:1b:e3:25:ce:\n         34:bc:6f:77:76:b1:10:c3:f7:05:1a:c0:d6:af:74:62:48:17:\n         77:92:69:90:61:1c:de:95:80:74:54:8f:18:1c:c3:f3:03:d0:\n         bf:a4:43:75:86:53:18:7a:0a:2e:09:1c:36:9f:91:fd:82:8a:\n         22:4b:d1:0e:50:25:dd:cb:03:0c:17:c9:83:00:08:4e:35:4d:\n         8a:8b:ed:f0:02:94:66:2c:44:7f:cb:95:27:96:17:ad:09:30:\n         ac:b6:71:17:6e:8b:17:f6:1c:09:d4:2d:3b:98:a5:71:d3:54:\n         13:d9:60:f3:f5:4b:66:4f:fa:f1:ee:20:12:8d:b4:ac:57:b1:\n         45:63:a1:ac:76:a9:c2:fb\nSHA1 Fingerprint=74:3A:F0:52:9B:D0:32:A0:F4:4A:83:CD:D4:BA:A9:7B:7C:2E:C4:9A\n",
    "fb5a48d0802040f2a8e90007691977a7e6c3f4cf": "-----BEGIN CERTIFICATE-----\nMIICKzCCAbGgAwIBAgIKe3G2gla4EnycqDAKBggqhkjOPQQDAzBaMQswCQYDVQQG\nEwJVUzETMBEGA1UECxMKZW1TaWduIFBLSTEUMBIGA1UEChMLZU11ZGhyYSBJbmMx\nIDAeBgNVBAMTF2VtU2lnbiBFQ0MgUm9vdCBDQSAtIEMzMB4XDTE4MDIxODE4MzAw\nMFoXDTQzMDIxODE4MzAwMFowWjELMAkGA1UEBhMCVVMxEzARBgNVBAsTCmVtU2ln\nbiBQS0kxFDASBgNVBAoTC2VNdWRocmEgSW5jMSAwHgYDVQQDExdlbVNpZ24gRUND\nIFJvb3QgQ0EgLSBDMzB2MBAGByqGSM49AgEGBSuBBAAiA2IABP2lYa57JhAd6bci\nMK4G9IGzsUJxlTm801Ljr6/58pc1kjZGDoeVjbk5Wum739D+yAdBPLtVb4Ojavti\nsIGJAnB9SMVK4+kiVCJNk7tCDK93nCOmfddhEc5lx/h//vXyqaNCMEAwHQYDVR0O\nBBYEFPtaSNCAIEDyqOkAB2kZd6fmw/TPMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMB\nAf8EBTADAQH/MAoGCCqGSM49BAMDA2gAMGUCMQC02C8Cif22TGK6Q04ThHK1rt0c\n3ta13FaPWEBaLd4gTCKDypOofu4SQMfWh0/434UCMBwUZOR8loMRnLDRWmFLpg9J\n0wD8ofzkpf9/rdcw0Md3f76BB1UwUCAU9Vc4CqgxUQ==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            7b:71:b6:82:56:b8:12:7c:9c:a8\n        Signature Algorithm: ecdsa-with-SHA384\n        Issuer: C=US, OU=emSign PKI, O=eMudhra Inc, CN=emSign ECC Root CA - C3\n        Validity\n            Not Before: Feb 18 18:30:00 2018 GMT\n            Not After : Feb 18 18:30:00 2043 GMT\n        Subject: C=US, OU=emSign PKI, O=eMudhra Inc, CN=emSign ECC Root CA - C3\n        Subject Public Key Info:\n            Public Key Algorithm: id-ecPublicKey\n                Public-Key: (384 bit)\n                pub:\n                    04:fd:a5:61:ae:7b:26:10:1d:e9:b7:22:30:ae:06:\n                    f4:81:b3:b1:42:71:95:39:bc:d3:52:e3:af:af:f9:\n                    f2:97:35:92:36:46:0e:87:95:8d:b9:39:5a:e9:bb:\n                    df:d0:fe:c8:07:41:3c:bb:55:6f:83:a3:6a:fb:62:\n                    b0:81:89:02:70:7d:48:c5:4a:e3:e9:22:54:22:4d:\n                    93:bb:42:0c:af:77:9c:23:a6:7d:d7:61:11:ce:65:\n                    c7:f8:7f:fe:f5:f2:a9\n                ASN1 OID: secp384r1\n                NIST CURVE: P-384\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                FB:5A:48:D0:80:20:40:F2:A8:E9:00:07:69:19:77:A7:E6:C3:F4:CF\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: ecdsa-with-SHA384\n         30:65:02:31:00:b4:d8:2f:02:89:fd:b6:4c:62:ba:43:4e:13:\n         84:72:b5:ae:dd:1c:de:d6:b5:dc:56:8f:58:40:5a:2d:de:20:\n         4c:22:83:ca:93:a8:7e:ee:12:40:c7:d6:87:4f:f8:df:85:02:\n         30:1c:14:64:e4:7c:96:83:11:9c:b0:d1:5a:61:4b:a6:0f:49:\n         d3:00:fc:a1:fc:e4:a5:ff:7f:ad:d7:30:d0:c7:77:7f:be:81:\n         07:55:30:50:20:14:f5:57:38:0a:a8:31:51\nSHA1 Fingerprint=B6:AF:43:C2:9B:81:53:7D:F6:EF:6B:C3:1F:1F:60:15:0C:EE:48:66\n",
    "fbef0d869eb0e3dda9b9f121177f3efcf0772b1a": "-----BEGIN CERTIFICATE-----\nMIIDlDCCAnygAwIBAgIKMfXkYgxsWO3W2DANBgkqhkiG9w0BAQsFADBnMQswCQYD\nVQQGEwJJTjETMBEGA1UECxMKZW1TaWduIFBLSTElMCMGA1UEChMcZU11ZGhyYSBU\nZWNobm9sb2dpZXMgTGltaXRlZDEcMBoGA1UEAxMTZW1TaWduIFJvb3QgQ0EgLSBH\nMTAeFw0xODAyMTgxODMwMDBaFw00MzAyMTgxODMwMDBaMGcxCzAJBgNVBAYTAklO\nMRMwEQYDVQQLEwplbVNpZ24gUEtJMSUwIwYDVQQKExxlTXVkaHJhIFRlY2hub2xv\nZ2llcyBMaW1pdGVkMRwwGgYDVQQDExNlbVNpZ24gUm9vdCBDQSAtIEcxMIIBIjAN\nBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAk0u76WaK7p1b1TST0Bsew+eeuGQz\nf2N4aLTNLnF115sgxk0pvLZoYIr3IZpWNVrzdr3YzZr/k1ZLpVkGoZM0Kd0WNHVO\n8oG0x5ZOrRkVUkr+PHB1cM2vK6sVmjM8qrOLqs1D/fXqcP/tzxE7lM5OMhbTI0Aq\nd7OvPAEsbO2ZLIvZTmmYsvePQbAyeGHWDV/D+qJAkh1cF+ZwPjXnorfCYuKrpDhM\ntTk1b+oDafo6VGiFbdbyL0NVHpENDtjVaqSW0RM8LHhQ6DqS0hdW5TUaQBw+jSzt\nOd9C4INBdN+jzcKGYEho42kLVACL5HZpIQ15TjQIXhTCzLG3rdd8cIrHhQIDAQAB\no0IwQDAdBgNVHQ4EFgQU++8Nhp6w492pufEhF38+/PB3KxowDgYDVR0PAQH/BAQD\nAgEGMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAFn/8oz1h31x\nPaOfG1vR2vjTnGs2vZupYeveFix0PZ7mddrXuqe8QhfnPZHr5X3dPpzxz5KsbEjM\nwiI/aTvFthUvozXGaCocV685743QNcMYDHsAVhzNixl03r4PEuDQqqE/AjSxcM6d\nGNYIAwlG7mDgfrbESQRRfXBgvKqy/3lyeqYdPV8q+Mri/Tm3R7nrft8EI6/6nAYH\n6ftjk4BAtcZsCjEozgyfz7MjNYBBjWzEN3uBL4ChQEKF6dk4jeihU80Bv2noWgby\nRQuQ+q7hv53yrlc8pa6yVvSLZUDp/TGBLPQ5Cdjua6e0ph0VpZj3AYHYhX3zUVxx\niN66zB+Afko=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            31:f5:e4:62:0c:6c:58:ed:d6:d8\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=IN, OU=emSign PKI, O=eMudhra Technologies Limited, CN=emSign Root CA - G1\n        Validity\n            Not Before: Feb 18 18:30:00 2018 GMT\n            Not After : Feb 18 18:30:00 2043 GMT\n        Subject: C=IN, OU=emSign PKI, O=eMudhra Technologies Limited, CN=emSign Root CA - G1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:93:4b:bb:e9:66:8a:ee:9d:5b:d5:34:93:d0:1b:\n                    1e:c3:e7:9e:b8:64:33:7f:63:78:68:b4:cd:2e:71:\n                    75:d7:9b:20:c6:4d:29:bc:b6:68:60:8a:f7:21:9a:\n                    56:35:5a:f3:76:bd:d8:cd:9a:ff:93:56:4b:a5:59:\n                    06:a1:93:34:29:dd:16:34:75:4e:f2:81:b4:c7:96:\n                    4e:ad:19:15:52:4a:fe:3c:70:75:70:cd:af:2b:ab:\n                    15:9a:33:3c:aa:b3:8b:aa:cd:43:fd:f5:ea:70:ff:\n                    ed:cf:11:3b:94:ce:4e:32:16:d3:23:40:2a:77:b3:\n                    af:3c:01:2c:6c:ed:99:2c:8b:d9:4e:69:98:b2:f7:\n                    8f:41:b0:32:78:61:d6:0d:5f:c3:fa:a2:40:92:1d:\n                    5c:17:e6:70:3e:35:e7:a2:b7:c2:62:e2:ab:a4:38:\n                    4c:b5:39:35:6f:ea:03:69:fa:3a:54:68:85:6d:d6:\n                    f2:2f:43:55:1e:91:0d:0e:d8:d5:6a:a4:96:d1:13:\n                    3c:2c:78:50:e8:3a:92:d2:17:56:e5:35:1a:40:1c:\n                    3e:8d:2c:ed:39:df:42:e0:83:41:74:df:a3:cd:c2:\n                    86:60:48:68:e3:69:0b:54:00:8b:e4:76:69:21:0d:\n                    79:4e:34:08:5e:14:c2:cc:b1:b7:ad:d7:7c:70:8a:\n                    c7:85\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                FB:EF:0D:86:9E:B0:E3:DD:A9:B9:F1:21:17:7F:3E:FC:F0:77:2B:1A\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: sha256WithRSAEncryption\n         59:ff:f2:8c:f5:87:7d:71:3d:a3:9f:1b:5b:d1:da:f8:d3:9c:\n         6b:36:bd:9b:a9:61:eb:de:16:2c:74:3d:9e:e6:75:da:d7:ba:\n         a7:bc:42:17:e7:3d:91:eb:e5:7d:dd:3e:9c:f1:cf:92:ac:6c:\n         48:cc:c2:22:3f:69:3b:c5:b6:15:2f:a3:35:c6:68:2a:1c:57:\n         af:39:ef:8d:d0:35:c3:18:0c:7b:00:56:1c:cd:8b:19:74:de:\n         be:0f:12:e0:d0:aa:a1:3f:02:34:b1:70:ce:9d:18:d6:08:03:\n         09:46:ee:60:e0:7e:b6:c4:49:04:51:7d:70:60:bc:aa:b2:ff:\n         79:72:7a:a6:1d:3d:5f:2a:f8:ca:e2:fd:39:b7:47:b9:eb:7e:\n         df:04:23:af:fa:9c:06:07:e9:fb:63:93:80:40:b5:c6:6c:0a:\n         31:28:ce:0c:9f:cf:b3:23:35:80:41:8d:6c:c4:37:7b:81:2f:\n         80:a1:40:42:85:e9:d9:38:8d:e8:a1:53:cd:01:bf:69:e8:5a:\n         06:f2:45:0b:90:fa:ae:e1:bf:9d:f2:ae:57:3c:a5:ae:b2:56:\n         f4:8b:65:40:e9:fd:31:81:2c:f4:39:09:d8:ee:6b:a7:b4:a6:\n         1d:15:a5:98:f7:01:81:d8:85:7d:f3:51:5c:71:88:de:ba:cc:\n         1f:80:7e:4a\nSHA1 Fingerprint=8A:C7:AD:8F:73:AC:4E:C1:B5:75:4D:A5:40:F4:FC:CF:7C:B5:8E:8C\n",
    "fdda14c49f30de21bd1e4239fcab632349e0f184": "-----BEGIN CERTIFICATE-----\nMIIEMzCCAxugAwIBAgIDCYPzMA0GCSqGSIb3DQEBCwUAME0xCzAJBgNVBAYTAkRF\nMRUwEwYDVQQKDAxELVRydXN0IEdtYkgxJzAlBgNVBAMMHkQtVFJVU1QgUm9vdCBD\nbGFzcyAzIENBIDIgMjAwOTAeFw0wOTExMDUwODM1NThaFw0yOTExMDUwODM1NTha\nME0xCzAJBgNVBAYTAkRFMRUwEwYDVQQKDAxELVRydXN0IEdtYkgxJzAlBgNVBAMM\nHkQtVFJVU1QgUm9vdCBDbGFzcyAzIENBIDIgMjAwOTCCASIwDQYJKoZIhvcNAQEB\nBQADggEPADCCAQoCggEBANOySs96R+91myP6Oi/WUEWJNTrGa9v+2wBoqOADER03\nUAifTUpolDWzU9GUY6cgVq/eUXjsKj3zSEhQPgrfRlWLJ23DEE0NkVJD2IfgXU42\ntSHKXzlABF9bfsyjxiupQB7ZNoTWSPOSHjRGICTBpFGOShrvUD9pXRl/RcPHAY9R\nySPocq60vFYJfxLLHLGvKZAKyVXMD9O0Gu1HNVpK7ZxzBCHQqr0ME7UAyiZsxGsM\nlFqVlNpQmvH/pStmMaTJOKDfHR+4CS7zp+hnUquVH+BGPtikw8paxTGA6Eian5Rp\n/hnd2HN8gcqW3o7tszIFZYQ05ub9VxC1X3a/L7AQDcUCAwEAAaOCARowggEWMA8G\nA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFP3aFMSfMN4hvR5COfyrYyNJ4PGEMA4G\nA1UdDwEB/wQEAwIBBjCB0wYDVR0fBIHLMIHIMIGAoH6gfIZ6bGRhcDovL2RpcmVj\ndG9yeS5kLXRydXN0Lm5ldC9DTj1ELVRSVVNUJTIwUm9vdCUyMENsYXNzJTIwMyUy\nMENBJTIwMiUyMDIwMDksTz1ELVRydXN0JTIwR21iSCxDPURFP2NlcnRpZmljYXRl\ncmV2b2NhdGlvbmxpc3QwQ6BBoD+GPWh0dHA6Ly93d3cuZC10cnVzdC5uZXQvY3Js\nL2QtdHJ1c3Rfcm9vdF9jbGFzc18zX2NhXzJfMjAwOS5jcmwwDQYJKoZIhvcNAQEL\nBQADggEBAH+X2zDI36ScfSF6gHDOFBJpiBSVYEQBrLLpME+bUMJm2H6NMLVwMeni\nacfzcNsgFYbQDfC+rAF1hM5+n02/t2A7nPPKHeJeaNijnZflQGDSNiH+0LS4F9p0\no3/U37CYAqxva2ssJSRyoWXuJVrl5jLn8t+rSfrzkGkj2wTZ51xY/GXUl77M/C4K\nzCUqNQT4YJEVdT1B/yMfGchs64JTBKbkTCJNjYy6zltz7GRUUG3RnFX7acM2w4y8\nPIWmawomDeCTmGCufsYkl4phX5GOZpIJhzbNi5stPvZR1FDUWSi9g/LMKHtThm3Y\nJohw1+qRzT65ysCQblrGXnRl11z+o+I=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 623603 (0x983f3)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=DE, O=D-Trust GmbH, CN=D-TRUST Root Class 3 CA 2 2009\n        Validity\n            Not Before: Nov  5 08:35:58 2009 GMT\n            Not After : Nov  5 08:35:58 2029 GMT\n        Subject: C=DE, O=D-Trust GmbH, CN=D-TRUST Root Class 3 CA 2 2009\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:d3:b2:4a:cf:7a:47:ef:75:9b:23:fa:3a:2f:d6:\n                    50:45:89:35:3a:c6:6b:db:fe:db:00:68:a8:e0:03:\n                    11:1d:37:50:08:9f:4d:4a:68:94:35:b3:53:d1:94:\n                    63:a7:20:56:af:de:51:78:ec:2a:3d:f3:48:48:50:\n                    3e:0a:df:46:55:8b:27:6d:c3:10:4d:0d:91:52:43:\n                    d8:87:e0:5d:4e:36:b5:21:ca:5f:39:40:04:5f:5b:\n                    7e:cc:a3:c6:2b:a9:40:1e:d9:36:84:d6:48:f3:92:\n                    1e:34:46:20:24:c1:a4:51:8e:4a:1a:ef:50:3f:69:\n                    5d:19:7f:45:c3:c7:01:8f:51:c9:23:e8:72:ae:b4:\n                    bc:56:09:7f:12:cb:1c:b1:af:29:90:0a:c9:55:cc:\n                    0f:d3:b4:1a:ed:47:35:5a:4a:ed:9c:73:04:21:d0:\n                    aa:bd:0c:13:b5:00:ca:26:6c:c4:6b:0c:94:5a:95:\n                    94:da:50:9a:f1:ff:a5:2b:66:31:a4:c9:38:a0:df:\n                    1d:1f:b8:09:2e:f3:a7:e8:67:52:ab:95:1f:e0:46:\n                    3e:d8:a4:c3:ca:5a:c5:31:80:e8:48:9a:9f:94:69:\n                    fe:19:dd:d8:73:7c:81:ca:96:de:8e:ed:b3:32:05:\n                    65:84:34:e6:e6:fd:57:10:b5:5f:76:bf:2f:b0:10:\n                    0d:c5\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Subject Key Identifier: \n                FD:DA:14:C4:9F:30:DE:21:BD:1E:42:39:FC:AB:63:23:49:E0:F1:84\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 CRL Distribution Points: \n\n                Full Name:\n                  URI:ldap://directory.d-trust.net/CN=D-TRUST%20Root%20Class%203%20CA%202%202009,O=D-Trust%20GmbH,C=DE?certificaterevocationlist\n\n                Full Name:\n                  URI:http://www.d-trust.net/crl/d-trust_root_class_3_ca_2_2009.crl\n\n    Signature Algorithm: sha256WithRSAEncryption\n         7f:97:db:30:c8:df:a4:9c:7d:21:7a:80:70:ce:14:12:69:88:\n         14:95:60:44:01:ac:b2:e9:30:4f:9b:50:c2:66:d8:7e:8d:30:\n         b5:70:31:e9:e2:69:c7:f3:70:db:20:15:86:d0:0d:f0:be:ac:\n         01:75:84:ce:7e:9f:4d:bf:b7:60:3b:9c:f3:ca:1d:e2:5e:68:\n         d8:a3:9d:97:e5:40:60:d2:36:21:fe:d0:b4:b8:17:da:74:a3:\n         7f:d4:df:b0:98:02:ac:6f:6b:6b:2c:25:24:72:a1:65:ee:25:\n         5a:e5:e6:32:e7:f2:df:ab:49:fa:f3:90:69:23:db:04:d9:e7:\n         5c:58:fc:65:d4:97:be:cc:fc:2e:0a:cc:25:2a:35:04:f8:60:\n         91:15:75:3d:41:ff:23:1f:19:c8:6c:eb:82:53:04:a6:e4:4c:\n         22:4d:8d:8c:ba:ce:5b:73:ec:64:54:50:6d:d1:9c:55:fb:69:\n         c3:36:c3:8c:bc:3c:85:a6:6b:0a:26:0d:e0:93:98:60:ae:7e:\n         c6:24:97:8a:61:5f:91:8e:66:92:09:87:36:cd:8b:9b:2d:3e:\n         f6:51:d4:50:d4:59:28:bd:83:f2:cc:28:7b:53:86:6d:d8:26:\n         88:70:d7:ea:91:cd:3e:b9:ca:c0:90:6e:5a:c6:5e:74:65:d7:\n         5c:fe:a3:e2\nSHA1 Fingerprint=58:E8:AB:B0:36:15:33:FB:80:F7:9B:1B:6D:29:D3:FF:8D:5F:00:F0\n",
    "fea1e0701e2a0339525a42be5c91857a18aa4db5": "-----BEGIN CERTIFICATE-----\nMIIDczCCAlugAwIBAgILAK7PALrEzzL4Q7IwDQYJKoZIhvcNAQELBQAwVjELMAkG\nA1UEBhMCVVMxEzARBgNVBAsTCmVtU2lnbiBQS0kxFDASBgNVBAoTC2VNdWRocmEg\nSW5jMRwwGgYDVQQDExNlbVNpZ24gUm9vdCBDQSAtIEMxMB4XDTE4MDIxODE4MzAw\nMFoXDTQzMDIxODE4MzAwMFowVjELMAkGA1UEBhMCVVMxEzARBgNVBAsTCmVtU2ln\nbiBQS0kxFDASBgNVBAoTC2VNdWRocmEgSW5jMRwwGgYDVQQDExNlbVNpZ24gUm9v\ndCBDQSAtIEMxMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAz+upufGZ\nBczYKCFK83M0UYRWEPWgTywS4/oTmifQz/l5GnRfHXk5/Fv4cI7gklL35CX5VIPZ\nHdPIWoU/Xse2B+4+wM6ar6xWQio5JXDWv7V7Nq2s9nPczdcdioOl+yuQFTdrHCZH\n3DspVpNqs8FqOp099cGXOFgFixwR4+S0uF2FHYP+eF8LRWgYSKVGczQ7/g/IdrvH\nGPMF0Ybzhe3nudkyrVWIzqa2kbBPrH4VI5b2P/AgNBbeCsbEBEV5f6f9vtKppa+c\nxSMq9zwhbL2vj07FOrLzNBL834AaSaTUqZX3noleoomslMuoaJuvimUnzYnu3Yy1\naylwQ6BpC+S5DwIDAQABo0IwQDAdBgNVHQ4EFgQU/qHgcB4qAzlSWkK+XJGFehiq\nTbUwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEL\nBQADggEBAMJKVvoVIXsoounlHfv4LcQ5lkFMOycsxGwYFYDGrK9HWS8mC+M2sO87\n/kOXSTKZEhVb3xEp/6tT+LvBeA+snFOvV71ojD1pM/CjoCNjO2RnIkSt1XHLVip4\nkqNPEjE2NuLe/gDEo2APJ62gsIq1NnpSob0n9CAnYuhNlCQT5AoE6TyrLshDCUrG\nYQTlSTR+08TI9Q/Aqum6VF7zYytPT1DU/rl7mYw9wC68AivTxEDkigcxHpvOJpkT\n+xHqmiIMERnHXhuBUDDIlhJu58tBf5E7oke3VIAb3ADMmpDqw8NQBmIMMMAVSKeo\nWXzhriKi4gp6D/piq1JM4fHfyr6DDUI=\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number:\n            ae:cf:00:ba:c4:cf:32:f8:43:b2\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=US, OU=emSign PKI, O=eMudhra Inc, CN=emSign Root CA - C1\n        Validity\n            Not Before: Feb 18 18:30:00 2018 GMT\n            Not After : Feb 18 18:30:00 2043 GMT\n        Subject: C=US, OU=emSign PKI, O=eMudhra Inc, CN=emSign Root CA - C1\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (2048 bit)\n                Modulus:\n                    00:cf:eb:a9:b9:f1:99:05:cc:d8:28:21:4a:f3:73:\n                    34:51:84:56:10:f5:a0:4f:2c:12:e3:fa:13:9a:27:\n                    d0:cf:f9:79:1a:74:5f:1d:79:39:fc:5b:f8:70:8e:\n                    e0:92:52:f7:e4:25:f9:54:83:d9:1d:d3:c8:5a:85:\n                    3f:5e:c7:b6:07:ee:3e:c0:ce:9a:af:ac:56:42:2a:\n                    39:25:70:d6:bf:b5:7b:36:ad:ac:f6:73:dc:cd:d7:\n                    1d:8a:83:a5:fb:2b:90:15:37:6b:1c:26:47:dc:3b:\n                    29:56:93:6a:b3:c1:6a:3a:9d:3d:f5:c1:97:38:58:\n                    05:8b:1c:11:e3:e4:b4:b8:5d:85:1d:83:fe:78:5f:\n                    0b:45:68:18:48:a5:46:73:34:3b:fe:0f:c8:76:bb:\n                    c7:18:f3:05:d1:86:f3:85:ed:e7:b9:d9:32:ad:55:\n                    88:ce:a6:b6:91:b0:4f:ac:7e:15:23:96:f6:3f:f0:\n                    20:34:16:de:0a:c6:c4:04:45:79:7f:a7:fd:be:d2:\n                    a9:a5:af:9c:c5:23:2a:f7:3c:21:6c:bd:af:8f:4e:\n                    c5:3a:b2:f3:34:12:fc:df:80:1a:49:a4:d4:a9:95:\n                    f7:9e:89:5e:a2:89:ac:94:cb:a8:68:9b:af:8a:65:\n                    27:cd:89:ee:dd:8c:b5:6b:29:70:43:a0:69:0b:e4:\n                    b9:0f\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Subject Key Identifier: \n                FE:A1:E0:70:1E:2A:03:39:52:5A:42:BE:5C:91:85:7A:18:AA:4D:B5\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n    Signature Algorithm: sha256WithRSAEncryption\n         c2:4a:56:fa:15:21:7b:28:a2:e9:e5:1d:fb:f8:2d:c4:39:96:\n         41:4c:3b:27:2c:c4:6c:18:15:80:c6:ac:af:47:59:2f:26:0b:\n         e3:36:b0:ef:3b:fe:43:97:49:32:99:12:15:5b:df:11:29:ff:\n         ab:53:f8:bb:c1:78:0f:ac:9c:53:af:57:bd:68:8c:3d:69:33:\n         f0:a3:a0:23:63:3b:64:67:22:44:ad:d5:71:cb:56:2a:78:92:\n         a3:4f:12:31:36:36:e2:de:fe:00:c4:a3:60:0f:27:ad:a0:b0:\n         8a:b5:36:7a:52:a1:bd:27:f4:20:27:62:e8:4d:94:24:13:e4:\n         0a:04:e9:3c:ab:2e:c8:43:09:4a:c6:61:04:e5:49:34:7e:d3:\n         c4:c8:f5:0f:c0:aa:e9:ba:54:5e:f3:63:2b:4f:4f:50:d4:fe:\n         b9:7b:99:8c:3d:c0:2e:bc:02:2b:d3:c4:40:e4:8a:07:31:1e:\n         9b:ce:26:99:13:fb:11:ea:9a:22:0c:11:19:c7:5e:1b:81:50:\n         30:c8:96:12:6e:e7:cb:41:7f:91:3b:a2:47:b7:54:80:1b:dc:\n         00:cc:9a:90:ea:c3:c3:50:06:62:0c:30:c0:15:48:a7:a8:59:\n         7c:e1:ae:22:a2:e2:0a:7a:0f:fa:62:ab:52:4c:e1:f1:df:ca:\n         be:83:0d:42\nSHA1 Fingerprint=E7:2E:F1:DF:FC:B2:09:28:CF:5D:D4:D5:67:37:B1:51:CB:86:4F:01\n",
    "feab0090989e24fca9cc1a8afb27b8bf306ea83b": "-----BEGIN CERTIFICATE-----\nMIIFcDCCA1igAwIBAgIEAJiWjTANBgkqhkiG9w0BAQsFADBYMQswCQYDVQQGEwJO\nTDEeMBwGA1UECgwVU3RhYXQgZGVyIE5lZGVybGFuZGVuMSkwJwYDVQQDDCBTdGFh\ndCBkZXIgTmVkZXJsYW5kZW4gRVYgUm9vdCBDQTAeFw0xMDEyMDgxMTE5MjlaFw0y\nMjEyMDgxMTEwMjhaMFgxCzAJBgNVBAYTAk5MMR4wHAYDVQQKDBVTdGFhdCBkZXIg\nTmVkZXJsYW5kZW4xKTAnBgNVBAMMIFN0YWF0IGRlciBOZWRlcmxhbmRlbiBFViBS\nb290IENBMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA48d+ifkkSzrS\nM4M1LGns3Amk41GoJSt5uAg94JG6hIXGhaTK5skuU6TJJB79VWZxXSzFYGgEt9nC\nUiY4iKTWO0Cmws0/zZiTs1QUWJZV1VD+hq2kY39ch/aO5ieSZxeSAgMs3NZmdO3d\nZ//BYY1jTw+bbRcwJu+r0h8QoPnFfxZpgQNH7R5ojXKhTbImxrpsX23Wr9GxE46p\nrfNeaXUmGD5BKyF/7otdBwadQ8QpCiv8Kj6GyzyDOvnJDdrFmeK8eEEzduG/L13l\npJhQDBXd4Pqcfzho0LKmeqfRMb1+ilgnQ7O6M5HTp5gVXJrm0w912fxBmJc+qiXb\nj5IusHsMX/FjqTf5m3VpTCgmJdrV8hJwRVXj33NeN/UhbJCONVrJ0yPr08C+eKxC\nKFhmpUZtcALXEPlLVPxdhkqHz3/KRawRWrUgUY0viEeXOcDPusBCAUCZSCELa6fS\n/ZbV0b5GnUngC6agIk440ME8MLxwjyx1zNDFjFE7PZQIZCZhfbnDZY8UnCHQqv0X\ncgOPvZuM5l5Tnrmd74K74bzickFbIZTTRTeU0d8JOV3nI6qaHcptqAqGhYqCvkIH\n1vI4gnPah1vlPNOePqc7nvQDs/nxfRN0Av+7oeX6AHkcpmZBiFxgV6YuCcS6/ZrP\npx9Aw7vMWgpVSzs4dlG4Y4uElBbmVvMCAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB\n/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFP6rAJCYniT8qcwaivsnuL8wbqg7\nMA0GCSqGSIb3DQEBCwUAA4ICAQDPdyxuVr5Os7aEAJSrR8kN0nbHhp8dB9O2tLsI\neK9p0gtJ3jPFrK3CiAJ9Brc1AsFgyb/E6JTe1NOpEyVa/m6irn0F3H3zbPB+po3u\n2dfOWBfoqSmuc0iH55vKbimhZF8ZE/euBhD/UcabTVUlT5OZEAFTdfETzsemQUHS\nv4ilf0X8rLiltTMMgsT7B/Zq5SWEXwbKwYY5EdtYzXc7LMJMD16a4/CrPmEbUCTC\nwPTxGfARKbalGAKb12NMcIxHowNDXLldRqANb/9Zjr7dn3LDWyvfjFvO5QxGbJKy\nCqNMVEIYFRIYvdr8unRu/8G2oGTYqV9Vrp9canaW2HNnh/tNf1zuacpzEPuKqf2e\nvTY4SUmH9A4U8OmHuD+nT3pajnnUk+S7aFKErGzp85hwVXIy+TSrK0m1zSBi5Dp6\nZ2Orltxtrpfs/J92VoguZs9btsmksNcFuuEnL5O7Jiqik7Ab846+HUCjuTaPPoIa\nGl6I6lD4WeKDRikL40Rc4ZW2aZCaFG+XroHPaO+Zmr615+F/+PoTRxZMzG0IQOeL\neG9QgkRQP2YGiqtDhFZKDyAthg710tvSeopLzaXoTvFeJiUBWSOgftL2fiFX1ye8\nFVdMpEbB4IMeDExNH08GGeL5qPQ6gqGyeUN51q1veieQA6TqJIc/2b3Z6fJfUEkc\n7uzXLg==\n-----END CERTIFICATE-----\nCertificate:\n    Data:\n        Version: 3 (0x2)\n        Serial Number: 10000013 (0x98968d)\n        Signature Algorithm: sha256WithRSAEncryption\n        Issuer: C=NL, O=Staat der Nederlanden, CN=Staat der Nederlanden EV Root CA\n        Validity\n            Not Before: Dec  8 11:19:29 2010 GMT\n            Not After : Dec  8 11:10:28 2022 GMT\n        Subject: C=NL, O=Staat der Nederlanden, CN=Staat der Nederlanden EV Root CA\n        Subject Public Key Info:\n            Public Key Algorithm: rsaEncryption\n                RSA Public-Key: (4096 bit)\n                Modulus:\n                    00:e3:c7:7e:89:f9:24:4b:3a:d2:33:83:35:2c:69:\n                    ec:dc:09:a4:e3:51:a8:25:2b:79:b8:08:3d:e0:91:\n                    ba:84:85:c6:85:a4:ca:e6:c9:2e:53:a4:c9:24:1e:\n                    fd:55:66:71:5d:2c:c5:60:68:04:b7:d9:c2:52:26:\n                    38:88:a4:d6:3b:40:a6:c2:cd:3f:cd:98:93:b3:54:\n                    14:58:96:55:d5:50:fe:86:ad:a4:63:7f:5c:87:f6:\n                    8e:e6:27:92:67:17:92:02:03:2c:dc:d6:66:74:ed:\n                    dd:67:ff:c1:61:8d:63:4f:0f:9b:6d:17:30:26:ef:\n                    ab:d2:1f:10:a0:f9:c5:7f:16:69:81:03:47:ed:1e:\n                    68:8d:72:a1:4d:b2:26:c6:ba:6c:5f:6d:d6:af:d1:\n                    b1:13:8e:a9:ad:f3:5e:69:75:26:18:3e:41:2b:21:\n                    7f:ee:8b:5d:07:06:9d:43:c4:29:0a:2b:fc:2a:3e:\n                    86:cb:3c:83:3a:f9:c9:0d:da:c5:99:e2:bc:78:41:\n                    33:76:e1:bf:2f:5d:e5:a4:98:50:0c:15:dd:e0:fa:\n                    9c:7f:38:68:d0:b2:a6:7a:a7:d1:31:bd:7e:8a:58:\n                    27:43:b3:ba:33:91:d3:a7:98:15:5c:9a:e6:d3:0f:\n                    75:d9:fc:41:98:97:3e:aa:25:db:8f:92:2e:b0:7b:\n                    0c:5f:f1:63:a9:37:f9:9b:75:69:4c:28:26:25:da:\n                    d5:f2:12:70:45:55:e3:df:73:5e:37:f5:21:6c:90:\n                    8e:35:5a:c9:d3:23:eb:d3:c0:be:78:ac:42:28:58:\n                    66:a5:46:6d:70:02:d7:10:f9:4b:54:fc:5d:86:4a:\n                    87:cf:7f:ca:45:ac:11:5a:b5:20:51:8d:2f:88:47:\n                    97:39:c0:cf:ba:c0:42:01:40:99:48:21:0b:6b:a7:\n                    d2:fd:96:d5:d1:be:46:9d:49:e0:0b:a6:a0:22:4e:\n                    38:d0:c1:3c:30:bc:70:8f:2c:75:cc:d0:c5:8c:51:\n                    3b:3d:94:08:64:26:61:7d:b9:c3:65:8f:14:9c:21:\n                    d0:aa:fd:17:72:03:8f:bd:9b:8c:e6:5e:53:9e:b9:\n                    9d:ef:82:bb:e1:bc:e2:72:41:5b:21:94:d3:45:37:\n                    94:d1:df:09:39:5d:e7:23:aa:9a:1d:ca:6d:a8:0a:\n                    86:85:8a:82:be:42:07:d6:f2:38:82:73:da:87:5b:\n                    e5:3c:d3:9e:3e:a7:3b:9e:f4:03:b3:f9:f1:7d:13:\n                    74:02:ff:bb:a1:e5:fa:00:79:1c:a6:66:41:88:5c:\n                    60:57:a6:2e:09:c4:ba:fd:9a:cf:a7:1f:40:c3:bb:\n                    cc:5a:0a:55:4b:3b:38:76:51:b8:63:8b:84:94:16:\n                    e6:56:f3\n                Exponent: 65537 (0x10001)\n        X509v3 extensions:\n            X509v3 Basic Constraints: critical\n                CA:TRUE\n            X509v3 Key Usage: critical\n                Certificate Sign, CRL Sign\n            X509v3 Subject Key Identifier: \n                FE:AB:00:90:98:9E:24:FC:A9:CC:1A:8A:FB:27:B8:BF:30:6E:A8:3B\n    Signature Algorithm: sha256WithRSAEncryption\n         cf:77:2c:6e:56:be:4e:b3:b6:84:00:94:ab:47:c9:0d:d2:76:\n         c7:86:9f:1d:07:d3:b6:b4:bb:08:78:af:69:d2:0b:49:de:33:\n         c5:ac:ad:c2:88:02:7d:06:b7:35:02:c1:60:c9:bf:c4:e8:94:\n         de:d4:d3:a9:13:25:5a:fe:6e:a2:ae:7d:05:dc:7d:f3:6c:f0:\n         7e:a6:8d:ee:d9:d7:ce:58:17:e8:a9:29:ae:73:48:87:e7:9b:\n         ca:6e:29:a1:64:5f:19:13:f7:ae:06:10:ff:51:c6:9b:4d:55:\n         25:4f:93:99:10:01:53:75:f1:13:ce:c7:a6:41:41:d2:bf:88:\n         a5:7f:45:fc:ac:b8:a5:b5:33:0c:82:c4:fb:07:f6:6a:e5:25:\n         84:5f:06:ca:c1:86:39:11:db:58:cd:77:3b:2c:c2:4c:0f:5e:\n         9a:e3:f0:ab:3e:61:1b:50:24:c2:c0:f4:f1:19:f0:11:29:b6:\n         a5:18:02:9b:d7:63:4c:70:8c:47:a3:03:43:5c:b9:5d:46:a0:\n         0d:6f:ff:59:8e:be:dd:9f:72:c3:5b:2b:df:8c:5b:ce:e5:0c:\n         46:6c:92:b2:0a:a3:4c:54:42:18:15:12:18:bd:da:fc:ba:74:\n         6e:ff:c1:b6:a0:64:d8:a9:5f:55:ae:9f:5c:6a:76:96:d8:73:\n         67:87:fb:4d:7f:5c:ee:69:ca:73:10:fb:8a:a9:fd:9e:bd:36:\n         38:49:49:87:f4:0e:14:f0:e9:87:b8:3f:a7:4f:7a:5a:8e:79:\n         d4:93:e4:bb:68:52:84:ac:6c:e9:f3:98:70:55:72:32:f9:34:\n         ab:2b:49:b5:cd:20:62:e4:3a:7a:67:63:ab:96:dc:6d:ae:97:\n         ec:fc:9f:76:56:88:2e:66:cf:5b:b6:c9:a4:b0:d7:05:ba:e1:\n         27:2f:93:bb:26:2a:a2:93:b0:1b:f3:8e:be:1d:40:a3:b9:36:\n         8f:3e:82:1a:1a:5e:88:ea:50:f8:59:e2:83:46:29:0b:e3:44:\n         5c:e1:95:b6:69:90:9a:14:6f:97:ae:81:cf:68:ef:99:9a:be:\n         b5:e7:e1:7f:f8:fa:13:47:16:4c:cc:6d:08:40:e7:8b:78:6f:\n         50:82:44:50:3f:66:06:8a:ab:43:84:56:4a:0f:20:2d:86:0e:\n         f5:d2:db:d2:7a:8a:4b:cd:a5:e8:4e:f1:5e:26:25:01:59:23:\n         a0:7e:d2:f6:7e:21:57:d7:27:bc:15:57:4c:a4:46:c1:e0:83:\n         1e:0c:4c:4d:1f:4f:06:19:e2:f9:a8:f4:3a:82:a1:b2:79:43:\n         79:d6:ad:6f:7a:27:90:03:a4:ea:24:87:3f:d9:bd:d9:e9:f2:\n         5f:50:49:1c:ee:ec:d7:2e\nSHA1 Fingerprint=76:E2:7E:C1:4F:DB:82:C1:C0:A6:75:B5:05:BE:3D:29:B4:ED:DB:BB\n"
}
