"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
var ApiKey_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiKey = exports.AllowRoutesAction = exports.AllowPlacesAction = exports.AllowMapsAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("aws-cdk-lib/core");
const aws_location_1 = require("aws-cdk-lib/aws-location");
const util_1 = require("./util");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * Actions for Maps that an API key resource grants permissions to perform.
 *
 * @see https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocationservicemaps.html
 */
var AllowMapsAction;
(function (AllowMapsAction) {
    /**
     * Allows getting static map images.
     */
    AllowMapsAction["GET_STATIC_MAP"] = "geo-maps:GetStaticMap";
    /**
     * Allows getting map tiles for rendering.
     */
    AllowMapsAction["GET_TILE"] = "geo-maps:GetTile";
    /**
     * Allows any maps actions.
     */
    AllowMapsAction["ANY"] = "geo-maps:*";
})(AllowMapsAction || (exports.AllowMapsAction = AllowMapsAction = {}));
/**
 * Actions for Places that an API key resource grants permissions to perform.
 *
 * @see https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocationserviceplaces.html
 */
var AllowPlacesAction;
(function (AllowPlacesAction) {
    /**
     * Allows auto-completion of search text.
     */
    AllowPlacesAction["AUTOCOMPLETE"] = "geo-places:Autocomplete";
    /**
     * Allows finding geo coordinates of a known place.
     */
    AllowPlacesAction["GEOCODE"] = "geo-places:Geocode";
    /**
     * Allows getting details of a place.
     */
    AllowPlacesAction["GET_PLACE"] = "geo-places:GetPlace";
    /**
     * Allows getting nearest address to geo coordinates.
     */
    AllowPlacesAction["REVERSE_GEOCODE"] = "geo-places:ReverseGeocode";
    /**
     * Allows category based places search around geo coordinates.
     */
    AllowPlacesAction["SEARCH_NEARBY"] = "geo-places:SearchNearby";
    /**
     * Allows place or address search based on free-form text.
     */
    AllowPlacesAction["SEARCH_TEXT"] = "geo-places:SearchText";
    /**
     * Allows suggestions based on an incomplete or misspelled query.
     */
    AllowPlacesAction["SUGGEST"] = "geo-places:Suggest";
    /**
     * Allows any places actions.
     */
    AllowPlacesAction["ANY"] = "geo-places:*";
})(AllowPlacesAction || (exports.AllowPlacesAction = AllowPlacesAction = {}));
/**
 * Actions for Routes that an API key resource grants permissions to perform.
 *
 * @see https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlocationserviceroutes.html
 */
var AllowRoutesAction;
(function (AllowRoutesAction) {
    /**
     * Allows isoline calculation.
     */
    AllowRoutesAction["CALCULATE_ISOLINES"] = "geo-routes:CalculateIsolines";
    /**
     * Allows point to point routing.
     */
    AllowRoutesAction["CALCULATE_ROUTES"] = "geo-routes:CalculateRoutes";
    /**
     * Allows matrix routing.
     */
    AllowRoutesAction["CALCULATE_ROUTE_MATRIX"] = "geo-routes:CalculateRouteMatrix";
    /**
     * Allows computing the best sequence of waypoints.
     */
    AllowRoutesAction["OPTIMIZE_WAYPOINTS"] = "geo-routes:OptimizeWaypoints";
    /**
     * Allows snapping GPS points to a likely route.
     */
    AllowRoutesAction["SNAP_TO_ROADS"] = "geo-routes:SnapToRoads";
    /**
     * Allows any routes actions.
     */
    AllowRoutesAction["ANY"] = "geo-routes:*";
})(AllowRoutesAction || (exports.AllowRoutesAction = AllowRoutesAction = {}));
/**
 * An API Key
 *
 * @see https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html
 */
let ApiKey = ApiKey_1 = class ApiKey extends core_1.Resource {
    /**
     * Use an existing api key by name
     */
    static fromApiKeyName(scope, id, apiKeyName) {
        const apiKeyArn = core_1.Stack.of(scope).formatArn({
            service: 'geo',
            resource: 'api-key',
            resourceName: apiKeyName,
        });
        return ApiKey_1.fromApiKeyArn(scope, id, apiKeyArn);
    }
    /**
     * Use an existing api key by ARN
     */
    static fromApiKeyArn(scope, id, apiKeyArn) {
        const parsedArn = core_1.Stack.of(scope).splitArn(apiKeyArn, core_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parsedArn.resourceName) {
            throw new core_1.UnscopedValidationError(`API Key Arn ${apiKeyArn} does not have a resource name.`);
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.apiKeyName = parsedArn.resourceName;
                this.apiKeyArn = apiKeyArn;
            }
        }
        return new Import(scope, id, {
            account: parsedArn.account,
            region: parsedArn.region,
        });
    }
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.apiKeyName ?? core_1.Lazy.string({ produce: () => (0, util_1.generateUniqueId)(this) }),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_alpha_ApiKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiKey);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.description && !core_1.Token.isUnresolved(props.description) && props.description.length > 1000) {
            throw new core_1.ValidationError(`\`description\` must be between 0 and 1000 characters. Received: ${props.description.length} characters`, this);
        }
        if (props.apiKeyName !== undefined && !core_1.Token.isUnresolved(props.apiKeyName)) {
            if (props.apiKeyName.length < 1 || props.apiKeyName.length > 100) {
                throw new core_1.ValidationError(`\`apiKeyName\` must be between 1 and 100 characters, got: ${props.apiKeyName.length} characters.`, this);
            }
            if (!/^[-._\w]+$/.test(props.apiKeyName)) {
                throw new core_1.ValidationError(`\`apiKeyName\` must contain only alphanumeric characters, hyphens, periods and underscores, got: ${props.apiKeyName}.`, this);
            }
        }
        if (props.expireTime !== undefined && props.noExpiry === true) {
            throw new core_1.ValidationError('`expireTime` must not be set when `noExpiry` has value true.', this);
        }
        if (props.expireTime === undefined && props.noExpiry !== true) {
            throw new core_1.ValidationError('`expireTime` must be set when `noExpiry` is false or undefined.', this);
        }
        if (!props.allowMapsActions && !props.allowPlacesActions && !props.allowRoutesActions) {
            throw new core_1.ValidationError('At least one of `allowMapsActions`, `allowPlacesActions`, or `allowRoutesActions` must be specified.', this);
        }
        if (props.allowReferers !== undefined &&
            (props.allowReferers.length < 1 || props.allowReferers.length > 5)) {
            throw new core_1.ValidationError(`\`allowReferers\` must be between 1 and 5 elements, got: ${props.allowReferers.length} elements.`, this);
        }
        const apiKey = new aws_location_1.CfnAPIKey(this, 'Resource', {
            keyName: this.physicalName,
            description: props.description,
            expireTime: props.expireTime?.toISOString(),
            forceDelete: props.forceDelete,
            forceUpdate: props.forceUpdate,
            noExpiry: props.noExpiry,
            restrictions: this._renderRestrictions(props),
        });
        this.apiKeyName = apiKey.ref;
        this.apiKeyArn = apiKey.attrArn;
        this.apiKeyCreateTime = apiKey.attrCreateTime;
        this.apiKeyUpdateTime = apiKey.attrUpdateTime;
    }
    /**
     * Renders the restrictions property for API Keys
     *
     * NOTE: added allowResources are AWS managed resources.
     */
    _renderRestrictions(props) {
        let allowResources = [];
        if (props.allowMapsActions) {
            allowResources.push(`arn:${core_1.Aws.PARTITION}:geo-maps:${core_1.Stack.of(this).region}::provider/default`);
        }
        if (props.allowPlacesActions) {
            allowResources.push(`arn:${core_1.Aws.PARTITION}:geo-places:${core_1.Stack.of(this).region}::provider/default`);
        }
        if (props.allowRoutesActions) {
            allowResources.push(`arn:${core_1.Aws.PARTITION}:geo-routes:${core_1.Stack.of(this).region}::provider/default`);
        }
        return {
            allowActions: [
                ...props.allowMapsActions ?? [],
                ...props.allowPlacesActions ?? [],
                ...props.allowRoutesActions ?? [],
            ].map((action) => action.toString()),
            allowReferers: props.allowReferers,
            allowResources,
        };
    }
};
exports.ApiKey = ApiKey;
_a = JSII_RTTI_SYMBOL_1;
ApiKey[_a] = { fqn: "@aws-cdk/aws-location-alpha.ApiKey", version: "2.203.1-alpha.0" };
/** Uniquely identifies this class. */
ApiKey.PROPERTY_INJECTION_ID = '@aws-cdk.aws-location-alpha.ApiKey';
exports.ApiKey = ApiKey = ApiKey_1 = __decorate([
    prop_injectable_1.propertyInjectable
], ApiKey);
//# sourceMappingURL=data:application/json;base64,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