import * as iam from 'aws-cdk-lib/aws-iam';
import * as kms from 'aws-cdk-lib/aws-kms';
import { IResource, Resource } from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
/**
 * A Geofence Collection
 */
export interface IGeofenceCollection extends IResource {
    /**
     * The name of the geofence collection
     *
     * @attribute
     */
    readonly geofenceCollectionName: string;
    /**
     * The Amazon Resource Name (ARN) of the geofence collection resource
     *
     * @attribute Arn, CollectionArn
     */
    readonly geofenceCollectionArn: string;
}
/**
 * Properties for a geofence collection
 */
export interface GeofenceCollectionProps {
    /**
     * A name for the geofence collection
     *
     * Must be between 1 and 100 characters and contain only alphanumeric characters,
     * hyphens, periods and underscores.
     *
     * @default - A name is automatically generated
     */
    readonly geofenceCollectionName?: string;
    /**
     * A description for the geofence collection
     *
     * @default - no description
     */
    readonly description?: string;
    /**
     * The customer managed to encrypt your data.
     *
     * @default - Use an AWS managed key
     * @see https://docs.aws.amazon.com/location/latest/developerguide/encryption-at-rest.html
     */
    readonly kmsKey?: kms.IKey;
}
/**
 * A Geofence Collection
 *
 * @see https://docs.aws.amazon.com/location/latest/developerguide/geofence-tracker-concepts.html#geofence-overview
 */
export declare class GeofenceCollection extends Resource implements IGeofenceCollection {
    /** Uniquely identifies this class. */
    static readonly PROPERTY_INJECTION_ID: string;
    /**
     * Use an existing geofence collection by name
     */
    static fromGeofenceCollectionName(scope: Construct, id: string, geofenceCollectionName: string): IGeofenceCollection;
    /**
     * Use an existing geofence collection by ARN
     */
    static fromGeofenceCollectionArn(scope: Construct, id: string, geofenceCollectionArn: string): IGeofenceCollection;
    readonly geofenceCollectionName: string;
    readonly geofenceCollectionArn: string;
    /**
     * The timestamp for when the geofence collection resource was created in ISO 8601 format
     *
     * @attribute
     */
    readonly geofenceCollectionCreateTime: string;
    /**
     * The timestamp for when the geofence collection resource was last updated in ISO 8601 format
     *
     * @attribute
     */
    readonly geofenceCollectionUpdateTime: string;
    constructor(scope: Construct, id: string, props?: GeofenceCollectionProps);
    /**
     * Grant the given principal identity permissions to perform the actions on this geofence collection.
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * Grant the given identity permissions to read this geofence collection
     *
     * @see https://docs.aws.amazon.com/location/latest/developerguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-read-only-geofences
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
}
