"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
var GeofenceCollection_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeofenceCollection = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_location_1 = require("aws-cdk-lib/aws-location");
const util_1 = require("./util");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * A Geofence Collection
 *
 * @see https://docs.aws.amazon.com/location/latest/developerguide/geofence-tracker-concepts.html#geofence-overview
 */
let GeofenceCollection = GeofenceCollection_1 = class GeofenceCollection extends core_1.Resource {
    /**
     * Use an existing geofence collection by name
     */
    static fromGeofenceCollectionName(scope, id, geofenceCollectionName) {
        const geofenceCollectionArn = core_1.Stack.of(scope).formatArn({
            service: 'geo',
            resource: 'geofence-collection',
            resourceName: geofenceCollectionName,
        });
        return GeofenceCollection_1.fromGeofenceCollectionArn(scope, id, geofenceCollectionArn);
    }
    /**
     * Use an existing geofence collection by ARN
     */
    static fromGeofenceCollectionArn(scope, id, geofenceCollectionArn) {
        const parsedArn = core_1.Stack.of(scope).splitArn(geofenceCollectionArn, core_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parsedArn.resourceName) {
            throw new core_1.UnscopedValidationError(`Geofence Collection Arn ${geofenceCollectionArn} does not have a resource name.`);
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.geofenceCollectionName = parsedArn.resourceName;
                this.geofenceCollectionArn = geofenceCollectionArn;
            }
        }
        return new Import(scope, id, {
            account: parsedArn.account,
            region: parsedArn.region,
        });
    }
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.geofenceCollectionName ?? core_1.Lazy.string({ produce: () => (0, util_1.generateUniqueId)(this) }),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_alpha_GeofenceCollectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GeofenceCollection);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.description && !core_1.Token.isUnresolved(props.description) && props.description.length > 1000) {
            throw new core_1.ValidationError(`\`description\` must be between 0 and 1000 characters. Received: ${props.description.length} characters`, this);
        }
        if (props.geofenceCollectionName !== undefined && !core_1.Token.isUnresolved(props.geofenceCollectionName)) {
            if (props.geofenceCollectionName.length < 1 || props.geofenceCollectionName.length > 100) {
                throw new core_1.ValidationError(`\`geofenceCollectionName\` must be between 1 and 100 characters, got: ${props.geofenceCollectionName.length} characters.`, this);
            }
            if (!/^[-._\w]+$/.test(props.geofenceCollectionName)) {
                throw new core_1.ValidationError(`\`geofenceCollectionName\` must contain only alphanumeric characters, hyphens, periods and underscores, got: ${props.geofenceCollectionName}.`, this);
            }
        }
        const geofenceCollection = new aws_location_1.CfnGeofenceCollection(this, 'Resource', {
            collectionName: this.physicalName,
            description: props.description,
            kmsKeyId: props.kmsKey?.keyArn,
        });
        this.geofenceCollectionName = geofenceCollection.ref;
        this.geofenceCollectionArn = geofenceCollection.attrArn;
        this.geofenceCollectionCreateTime = geofenceCollection.attrCreateTime;
        this.geofenceCollectionUpdateTime = geofenceCollection.attrUpdateTime;
    }
    /**
     * Grant the given principal identity permissions to perform the actions on this geofence collection.
     */
    grant(grantee, ...actions) {
        return iam.Grant.addToPrincipal({
            grantee: grantee,
            actions: actions,
            resourceArns: [this.geofenceCollectionArn],
        });
    }
    /**
     * Grant the given identity permissions to read this geofence collection
     *
     * @see https://docs.aws.amazon.com/location/latest/developerguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-read-only-geofences
     */
    grantRead(grantee) {
        return this.grant(grantee, 'geo:ListGeofences', 'geo:GetGeofence');
    }
};
exports.GeofenceCollection = GeofenceCollection;
_a = JSII_RTTI_SYMBOL_1;
GeofenceCollection[_a] = { fqn: "@aws-cdk/aws-location-alpha.GeofenceCollection", version: "2.203.1-alpha.0" };
/** Uniquely identifies this class. */
GeofenceCollection.PROPERTY_INJECTION_ID = '@aws-cdk.aws-location-alpha.GeofenceCollection';
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], GeofenceCollection.prototype, "grant", null);
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], GeofenceCollection.prototype, "grantRead", null);
exports.GeofenceCollection = GeofenceCollection = GeofenceCollection_1 = __decorate([
    prop_injectable_1.propertyInjectable
], GeofenceCollection);
//# sourceMappingURL=data:application/json;base64,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