"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
var Map_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Map = exports.PoliticalView = exports.Style = exports.CustomLayer = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_location_1 = require("aws-cdk-lib/aws-location");
const util_1 = require("./util");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * An additional layer you can enable for a map style.
 */
var CustomLayer;
(function (CustomLayer) {
    /**
     * The POI custom layer adds a richer set of places, such as shops, services, restaurants, attractions, and other points of interest to your map.
     * Currently only the VectorEsriNavigation map style supports the POI custom layer.
     */
    CustomLayer["POI"] = "POI";
})(CustomLayer || (exports.CustomLayer = CustomLayer = {}));
/**
 * The map style selected from an available data provider.
 *
 * @see https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html
 */
var Style;
(function (Style) {
    /**
     * The Esri Navigation map style, which provides a detailed basemap for the world symbolized
     * with a custom navigation map style that's designed for use during the day in mobile devices.
     * It also includes a richer set of places, such as shops, services, restaurants, attractions,
     * and other points of interest. Enable the POI layer by setting it in CustomLayers to leverage
     * the additional places data.
     */
    Style["VECTOR_ESRI_NAVIGATION"] = "VectorEsriNavigation";
    /**
     * The Esri Imagery map style. A raster basemap that provides one meter or better
     * satellite and aerial imagery in many parts of the world and lower resolution
     * satellite imagery worldwide.
     */
    Style["RASTER_ESRI_IMAGERY"] = "RasterEsriImagery";
    /**
     * The Esri Light Gray Canvas map style, which provides a detailed vector basemap
     * with a light gray, neutral background style with minimal colors, labels, and features
     * that's designed to draw attention to your thematic content.
     */
    Style["VECTOR_ESRI_LIGHT_GRAY_CANVAS"] = "VectorEsriLightGrayCanvas";
    /**
     * The Esri Light map style, which provides a detailed vector basemap
     * with a classic Esri map style.
     */
    Style["VECTOR_ESRI_TOPOGRAPHIC"] = "VectorEsriTopographic";
    /**
     * The Esri Street Map style, which provides a detailed vector basemap for the world
     * symbolized with a classic Esri street map style. The vector tile layer is similar
     * in content and style to the World Street Map raster map.
     */
    Style["VECTOR_ESRI_STREETS"] = "VectorEsriStreets";
    /**
     * The Esri Dark Gray Canvas map style. A vector basemap with a dark gray,
     * neutral background with minimal colors, labels, and features that's designed
     * to draw attention to your thematic content.
     */
    Style["VECTOR_ESRI_DARK_GRAY_CANVAS"] = "VectorEsriDarkGrayCanvas";
    /**
     * A default HERE map style containing a neutral, global map and its features
     * including roads, buildings, landmarks, and water features. It also now includes
     * a fully designed map of Japan.
     */
    Style["VECTOR_HERE_EXPLORE"] = "VectorHereExplore";
    /**
     * A global map containing high resolution satellite imagery.
     */
    Style["RASTER_HERE_EXPLORE_SATELLITE"] = "RasterHereExploreSatellite";
    /**
     * A global map displaying the road network, street names, and city labels
     * over satellite imagery. This style will automatically retrieve both raster
     * and vector tiles, and your charges will be based on total tiles retrieved.
     */
    Style["HYBRID_HERE_EXPLORE_SATELLITE"] = "HybridHereExploreSatellite";
    /**
     * The HERE Contrast (Berlin) map style is a high contrast detailed base map
     * of the world that blends 3D and 2D rendering.
     */
    Style["VECTOR_HERE_CONTRAST"] = "VectorHereContrast";
    /**
     * A global map containing truck restrictions and attributes (e.g. width / height / HAZMAT)
     * symbolized with highlighted segments and icons on top of HERE Explore to support
     * use cases within transport and logistics.
     */
    Style["VECTOR_HERE_EXPLORE_TRUCK"] = "VectorHereExploreTruck";
    /**
     * The Grab Standard Light map style provides a basemap with detailed land use coloring,
     * area names, roads, landmarks, and points of interest covering Southeast Asia.
     */
    Style["VECTOR_GRAB_STANDARD_LIGHT"] = "VectorGrabStandardLight";
    /**
     * The Grab Standard Dark map style provides a dark variation of the standard basemap
     * covering Southeast Asia.
     */
    Style["VECTOR_GRAB_STANDARD_DARK"] = "VectorGrabStandardDark";
    /**
     * The Open Data Standard Light map style provides a detailed basemap for the world
     * suitable for website and mobile application use. The map includes highways major roads,
     * minor roads, railways, water features, cities, parks, landmarks, building footprints,
     * and administrative boundaries.
     */
    Style["VECTOR_OPEN_DATA_STANDARD_LIGHT"] = "VectorOpenDataStandardLight";
    /**
     * Open Data Standard Dark is a dark-themed map style that provides a detailed basemap
     * for the world suitable for website and mobile application use. The map includes highways
     * major roads, minor roads, railways, water features, cities, parks, landmarks,
     * building footprints, and administrative boundaries.
     */
    Style["VECTOR_OPEN_DATA_STANDARD_DARK"] = "VectorOpenDataStandardDark";
    /**
     * The Open Data Visualization Light map style is a light-themed style with muted colors
     * and fewer features that aids in understanding overlaid data.
     */
    Style["VECTOR_OPEN_DATA_VISUALIZATION_LIGHT"] = "VectorOpenDataVisualizationLight";
    /**
     * The Open Data Visualization Dark map style is a dark-themed style with muted colors
     * and fewer features that aids in understanding overlaid data.
     */
    Style["VECTOR_OPEN_DATA_VISUALIZATION_DARK"] = "VectorOpenDataVisualizationDark";
})(Style || (exports.Style = Style = {}));
/**
 * The map political view.
 */
var PoliticalView;
(function (PoliticalView) {
    /**
     * An India (IND) political view
     */
    PoliticalView["INDIA"] = "IND";
})(PoliticalView || (exports.PoliticalView = PoliticalView = {}));
/**
 * The Amazon Location Service Map
 *
 * @see https://docs.aws.amazon.com/location/latest/developerguide/map-concepts.html
 */
let Map = Map_1 = class Map extends core_1.Resource {
    /**
     * Use an existing map by name
     */
    static fromMapName(scope, id, mapName) {
        const mapArn = core_1.Stack.of(scope).formatArn({
            service: 'geo',
            resource: 'map',
            resourceName: mapName,
        });
        return Map_1.fromMapArn(scope, id, mapArn);
    }
    /**
     * Use an existing map by ARN
     */
    static fromMapArn(scope, id, mapArn) {
        const parsedArn = core_1.Stack.of(scope).splitArn(mapArn, core_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parsedArn.resourceName) {
            throw new core_1.UnscopedValidationError(`Map Arn ${mapArn} does not have a resource name.`);
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.mapName = parsedArn.resourceName;
                this.mapArn = mapArn;
            }
        }
        return new Import(scope, id, {
            account: parsedArn.account,
            region: parsedArn.region,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.mapName ?? core_1.Lazy.string({ produce: () => (0, util_1.generateUniqueId)(this) }),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_alpha_MapProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Map);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.description && !core_1.Token.isUnresolved(props.description) && props.description.length > 1000) {
            throw new core_1.ValidationError(`\`description\` must be between 0 and 1000 characters, got: ${props.description.length} characters.`, this);
        }
        if (props.mapName !== undefined && !core_1.Token.isUnresolved(props.mapName)) {
            if (props.mapName.length < 1 || props.mapName.length > 100) {
                throw new core_1.ValidationError(`\`mapName\` must be between 1 and 100 characters, got: ${props.mapName.length} characters.`, this);
            }
            if (!/^[-._\w]+$/.test(props.mapName)) {
                throw new core_1.ValidationError(`\`mapName\` must contain only alphanumeric characters, hyphens, periods and underscores, got: ${props.mapName}.`, this);
            }
        }
        const map = new aws_location_1.CfnMap(this, 'Resource', {
            configuration: {
                style: props.style,
                customLayers: props.customLayers,
                politicalView: props.politicalView,
            },
            mapName: this.physicalName,
            description: props.description,
        });
        this.mapName = map.ref;
        this.mapArn = map.attrArn;
        this.mapCreateTime = map.attrCreateTime;
        this.mapUpdateTime = map.attrUpdateTime;
    }
    /**
     * Grant the given principal identity permissions to perform the actions on this map.
     */
    grant(grantee, ...actions) {
        return iam.Grant.addToPrincipal({
            grantee: grantee,
            actions: actions,
            resourceArns: [this.mapArn],
        });
    }
    /**
     * Grant the given identity permissions to rendering a map resource
     * @See https://docs.aws.amazon.com/location/latest/developerguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-get-map-tiles
     */
    grantRendering(grantee) {
        return this.grant(grantee, 'geo:GetMapTile', 'geo:GetMapSprites', 'geo:GetMapGlyphs', 'geo:GetMapStyleDescriptor');
    }
};
exports.Map = Map;
_a = JSII_RTTI_SYMBOL_1;
Map[_a] = { fqn: "@aws-cdk/aws-location-alpha.Map", version: "2.203.1-alpha.0" };
/** Uniquely identifies this class. */
Map.PROPERTY_INJECTION_ID = '@aws-cdk.aws-location-alpha.Map';
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Map.prototype, "grant", null);
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Map.prototype, "grantRendering", null);
exports.Map = Map = Map_1 = __decorate([
    prop_injectable_1.propertyInjectable
], Map);
//# sourceMappingURL=data:application/json;base64,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