"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
var PlaceIndex_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaceIndex = exports.IntendedUse = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_location_1 = require("aws-cdk-lib/aws-location");
const util_1 = require("./util");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * Intend use for the results of an operation
 */
var IntendedUse;
(function (IntendedUse) {
    /**
     * The results won't be stored
     */
    IntendedUse["SINGLE_USE"] = "SingleUse";
    /**
     * The result can be cached or stored in a database
     */
    IntendedUse["STORAGE"] = "Storage";
})(IntendedUse || (exports.IntendedUse = IntendedUse = {}));
/**
 * A Place Index
 *
 * @see https://docs.aws.amazon.com/location/latest/developerguide/places-concepts.html
 */
let PlaceIndex = PlaceIndex_1 = class PlaceIndex extends core_1.Resource {
    /**
     * Use an existing place index by name
     */
    static fromPlaceIndexName(scope, id, placeIndexName) {
        const placeIndexArn = core_1.Stack.of(scope).formatArn({
            service: 'geo',
            resource: 'place-index',
            resourceName: placeIndexName,
        });
        return PlaceIndex_1.fromPlaceIndexArn(scope, id, placeIndexArn);
    }
    /**
     * Use an existing place index by ARN
     */
    static fromPlaceIndexArn(scope, id, placeIndexArn) {
        const parsedArn = core_1.Stack.of(scope).splitArn(placeIndexArn, core_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parsedArn.resourceName) {
            throw new core_1.UnscopedValidationError(`Place Index Arn ${placeIndexArn} does not have a resource name.`);
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.placeIndexName = parsedArn.resourceName;
                this.placeIndexArn = placeIndexArn;
            }
        }
        return new Import(scope, id, {
            account: parsedArn.account,
            region: parsedArn.region,
        });
    }
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.placeIndexName ?? core_1.Lazy.string({ produce: () => (0, util_1.generateUniqueId)(this) }),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_alpha_PlaceIndexProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PlaceIndex);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.description && !core_1.Token.isUnresolved(props.description) && props.description.length > 1000) {
            throw new core_1.ValidationError(`\`description\` must be between 0 and 1000 characters. Received: ${props.description.length} characters`, this);
        }
        if (props.placeIndexName !== undefined && !core_1.Token.isUnresolved(props.placeIndexName)) {
            if (props.placeIndexName.length < 1 || props.placeIndexName.length > 100) {
                throw new core_1.ValidationError(`\`placeIndexName\` must be between 1 and 100 characters, got: ${props.placeIndexName.length} characters.`, this);
            }
            if (!/^[-._\w]+$/.test(props.placeIndexName)) {
                throw new core_1.ValidationError(`\`placeIndexName\` must contain only alphanumeric characters, hyphens, periods and underscores, got: ${props.placeIndexName}.`, this);
            }
        }
        const placeIndex = new aws_location_1.CfnPlaceIndex(this, 'Resource', {
            indexName: this.physicalName,
            dataSource: props.dataSource ?? util_1.DataSource.ESRI,
            dataSourceConfiguration: props.intendedUse
                ? { intendedUse: props.intendedUse }
                : undefined,
            description: props.description,
        });
        this.placeIndexName = placeIndex.ref;
        this.placeIndexArn = placeIndex.attrArn;
        this.placeIndexCreateTime = placeIndex.attrCreateTime;
        this.placeIndexUpdateTime = placeIndex.attrUpdateTime;
    }
    /**
     * Grant the given principal identity permissions to perform the actions on this place index.
     */
    grant(grantee, ...actions) {
        return iam.Grant.addToPrincipal({
            grantee: grantee,
            actions: actions,
            resourceArns: [this.placeIndexArn],
        });
    }
    /**
     * Grant the given identity permissions to search using this index
     */
    grantSearch(grantee) {
        return this.grant(grantee, 'geo:SearchPlaceIndexForPosition', 'geo:SearchPlaceIndexForSuggestions', 'geo:SearchPlaceIndexForText');
    }
};
exports.PlaceIndex = PlaceIndex;
_a = JSII_RTTI_SYMBOL_1;
PlaceIndex[_a] = { fqn: "@aws-cdk/aws-location-alpha.PlaceIndex", version: "2.203.1-alpha.0" };
/** Uniquely identifies this class. */
PlaceIndex.PROPERTY_INJECTION_ID = '@aws-cdk.aws-location-alpha.PlaceIndex';
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], PlaceIndex.prototype, "grant", null);
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], PlaceIndex.prototype, "grantSearch", null);
exports.PlaceIndex = PlaceIndex = PlaceIndex_1 = __decorate([
    prop_injectable_1.propertyInjectable
], PlaceIndex);
//# sourceMappingURL=data:application/json;base64,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