import * as iam from 'aws-cdk-lib/aws-iam';
import { IResource, Resource } from 'aws-cdk-lib/core';
import { Construct } from 'constructs';
import { DataSource } from './util';
/**
 * A Route Calculator
 */
export interface IRouteCalculator extends IResource {
    /**
     * The name of the route calculator
     *
     * @attribute
     */
    readonly routeCalculatorName: string;
    /**
     * The Amazon Resource Name (ARN) of the route calculator resource
     *
     * @attribute Arn,CalculatorArn
     */
    readonly routeCalculatorArn: string;
}
/**
 * Properties for a route calculator
 */
export interface RouteCalculatorProps {
    /**
     * A name for the route calculator
     *
     * Must be between 1 and 100 characters and contain only alphanumeric characters,
     * hyphens, periods and underscores.
     *
     * @default - A name is automatically generated
     */
    readonly routeCalculatorName?: string;
    /**
     * Data source for the route calculator
     */
    readonly dataSource: DataSource;
    /**
     * A description for the route calculator
     *
     * @default - no description
     */
    readonly description?: string;
}
/**
 * A Route Calculator
 *
 * @see https://docs.aws.amazon.com/location/latest/developerguide/places-concepts.html
 */
export declare class RouteCalculator extends Resource implements IRouteCalculator {
    /** Uniquely identifies this class. */
    static readonly PROPERTY_INJECTION_ID: string;
    /**
     * Use an existing route calculator by name
     */
    static fromRouteCalculatorName(scope: Construct, id: string, routeCalculatorName: string): IRouteCalculator;
    /**
     * Use an existing route calculator by ARN
     */
    static fromRouteCalculatorArn(scope: Construct, id: string, routeCalculatorArn: string): IRouteCalculator;
    readonly routeCalculatorName: string;
    readonly routeCalculatorArn: string;
    /**
     * The timestamp for when the route calculator resource was created in ISO 8601 format
     *
     * @attribute
     */
    readonly routeCalculatorCreateTime: string;
    /**
     * The timestamp for when the route calculator resource was last updated in ISO 8601 format
     *
     * @attribute
     */
    readonly routeCalculatorUpdateTime: string;
    constructor(scope: Construct, id: string, props: RouteCalculatorProps);
    /**
     * Grant the given principal identity permissions to perform the actions on this route calculator.
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * Grant the given identity permissions to access to a route calculator resource to calculate a route.
     *
     * @see https://docs.aws.amazon.com/location/latest/developerguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-calculate-route
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
}
