"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
var RouteCalculator_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RouteCalculator = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_location_1 = require("aws-cdk-lib/aws-location");
const util_1 = require("./util");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * A Route Calculator
 *
 * @see https://docs.aws.amazon.com/location/latest/developerguide/places-concepts.html
 */
let RouteCalculator = RouteCalculator_1 = class RouteCalculator extends core_1.Resource {
    /**
     * Use an existing route calculator by name
     */
    static fromRouteCalculatorName(scope, id, routeCalculatorName) {
        const routeCalculatorArn = core_1.Stack.of(scope).formatArn({
            service: 'geo',
            resource: 'route-calculator',
            resourceName: routeCalculatorName,
        });
        return RouteCalculator_1.fromRouteCalculatorArn(scope, id, routeCalculatorArn);
    }
    /**
     * Use an existing route calculator by ARN
     */
    static fromRouteCalculatorArn(scope, id, routeCalculatorArn) {
        const parsedArn = core_1.Stack.of(scope).splitArn(routeCalculatorArn, core_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parsedArn.resourceName) {
            throw new core_1.UnscopedValidationError(`Route Calculator Arn ${routeCalculatorArn} does not have a resource name.`);
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.routeCalculatorName = parsedArn.resourceName;
                this.routeCalculatorArn = routeCalculatorArn;
            }
        }
        return new Import(scope, id, {
            account: parsedArn.account,
            region: parsedArn.region,
        });
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.routeCalculatorName ?? core_1.Lazy.string({ produce: () => (0, util_1.generateUniqueId)(this) }),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_alpha_RouteCalculatorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RouteCalculator);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.description && !core_1.Token.isUnresolved(props.description) && props.description.length > 1000) {
            throw new core_1.ValidationError(`\`description\` must be between 0 and 1000 characters. Received: ${props.description.length} characters`, this);
        }
        if (props.routeCalculatorName !== undefined && !core_1.Token.isUnresolved(props.routeCalculatorName)) {
            if (props.routeCalculatorName.length < 1 || props.routeCalculatorName.length > 100) {
                throw new core_1.ValidationError(`\`routeCalculatorName\` must be between 1 and 100 characters, got: ${props.routeCalculatorName.length} characters.`, this);
            }
            if (!/^[-._\w]+$/.test(props.routeCalculatorName)) {
                throw new core_1.ValidationError(`\`routeCalculatorName\` must contain only alphanumeric characters, hyphens, periods and underscores, got: ${props.routeCalculatorName}.`, this);
            }
        }
        const routeCalculator = new aws_location_1.CfnRouteCalculator(this, 'Resource', {
            calculatorName: this.physicalName,
            dataSource: props.dataSource ?? util_1.DataSource.ESRI,
            description: props.description,
        });
        this.routeCalculatorName = routeCalculator.ref;
        this.routeCalculatorArn = routeCalculator.attrArn;
        this.routeCalculatorCreateTime = routeCalculator.attrCreateTime;
        this.routeCalculatorUpdateTime = routeCalculator.attrUpdateTime;
    }
    /**
     * Grant the given principal identity permissions to perform the actions on this route calculator.
     */
    grant(grantee, ...actions) {
        return iam.Grant.addToPrincipal({
            grantee: grantee,
            actions: actions,
            resourceArns: [this.routeCalculatorArn],
        });
    }
    /**
     * Grant the given identity permissions to access to a route calculator resource to calculate a route.
     *
     * @see https://docs.aws.amazon.com/location/latest/developerguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-calculate-route
     */
    grantRead(grantee) {
        return this.grant(grantee, 'geo:CalculateRoute');
    }
};
exports.RouteCalculator = RouteCalculator;
_a = JSII_RTTI_SYMBOL_1;
RouteCalculator[_a] = { fqn: "@aws-cdk/aws-location-alpha.RouteCalculator", version: "2.203.1-alpha.0" };
/** Uniquely identifies this class. */
RouteCalculator.PROPERTY_INJECTION_ID = '@aws-cdk.aws-location-alpha.RouteCalculator';
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], RouteCalculator.prototype, "grant", null);
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], RouteCalculator.prototype, "grantRead", null);
exports.RouteCalculator = RouteCalculator = RouteCalculator_1 = __decorate([
    prop_injectable_1.propertyInjectable
], RouteCalculator);
//# sourceMappingURL=data:application/json;base64,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