"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
var Tracker_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tracker = exports.PositionFiltering = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_location_1 = require("aws-cdk-lib/aws-location");
const util_1 = require("./util");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
/**
 * The position filtering for the tracker resource
 */
var PositionFiltering;
(function (PositionFiltering) {
    /**
     * Location updates are evaluated against linked geofence collections, but not every location update is stored.
     * If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID.
     */
    PositionFiltering["TIME_BASED"] = "TimeBased";
    /**
     * If the device has moved less than 30 m (98.4 ft), location updates are ignored.
     * Location updates within this area are neither evaluated against linked geofence collections, nor stored.
     * This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through.
     * Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map.
     */
    PositionFiltering["DISTANCE_BASED"] = "DistanceBased";
    /**
     * If the device has moved less than the measured accuracy, location updates are ignored.
     * For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m,
     * the second update is ignored if the device has moved less than 15 m.
     * Ignored location updates are neither evaluated against linked geofence collections, nor stored.
     * This can reduce the effects of GPS noise when displaying device trajectories on a map,
     * and can help control your costs by reducing the number of geofence evaluations.
     */
    PositionFiltering["ACCURACY_BASED"] = "AccuracyBased";
})(PositionFiltering || (exports.PositionFiltering = PositionFiltering = {}));
/**
 * A Tracker
 *
 * @see https://docs.aws.amazon.com/location/latest/developerguide/geofence-tracker-concepts.html#tracking-overview
 */
let Tracker = Tracker_1 = class Tracker extends core_1.Resource {
    /**
     * Use an existing tracker by name
     */
    static fromTrackerName(scope, id, trackerName) {
        const trackerArn = core_1.Stack.of(scope).formatArn({
            service: 'geo',
            resource: 'tracker',
            resourceName: trackerName,
        });
        return Tracker_1.fromTrackerArn(scope, id, trackerArn);
    }
    /**
     * Use an existing tracker by ARN
     */
    static fromTrackerArn(scope, id, trackerArn) {
        const parsedArn = core_1.Stack.of(scope).splitArn(trackerArn, core_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parsedArn.resourceName) {
            throw new core_1.UnscopedValidationError(`Tracker Arn ${trackerArn} does not have a resource name.`);
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.trackerName = parsedArn.resourceName;
                this.trackerArn = trackerArn;
            }
        }
        return new Import(scope, id, {
            account: parsedArn.account,
            region: parsedArn.region,
        });
    }
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.trackerName ?? core_1.Lazy.string({ produce: () => (0, util_1.generateUniqueId)(this) }),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_alpha_TrackerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Tracker);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.description && !core_1.Token.isUnresolved(props.description) && props.description.length > 1000) {
            throw new core_1.ValidationError(`\`description\` must be between 0 and 1000 characters. Received: ${props.description.length} characters`, this);
        }
        if (props.trackerName !== undefined && !core_1.Token.isUnresolved(props.trackerName)) {
            if (props.trackerName.length < 1 || props.trackerName.length > 100) {
                throw new core_1.ValidationError(`\`trackerName\` must be between 1 and 100 characters, got: ${props.trackerName.length} characters.`, this);
            }
            if (!/^[-._\w]+$/.test(props.trackerName)) {
                throw new core_1.ValidationError(`\`trackerName\` must contain only alphanumeric characters, hyphens, periods and underscores, got: ${props.trackerName}.`, this);
            }
        }
        if (!core_1.Token.isUnresolved(props.kmsKey)
            && !props.kmsKey
            && props.kmsKeyEnableGeospatialQueries) {
            throw new core_1.ValidationError('`kmsKeyEnableGeospatialQueries` can only be enabled that are configured to use an AWS KMS customer managed key', this);
        }
        const tracker = new aws_location_1.CfnTracker(this, 'Resource', {
            trackerName: this.physicalName,
            description: props.description,
            eventBridgeEnabled: props.eventBridgeEnabled,
            kmsKeyEnableGeospatialQueries: props.kmsKeyEnableGeospatialQueries,
            kmsKeyId: props.kmsKey?.keyArn,
            positionFiltering: props.positionFiltering,
        });
        props.geofenceCollections?.forEach((collection) => {
            new aws_location_1.CfnTrackerConsumer(this, `TrackerConsumer${collection.node.id}`, {
                consumerArn: collection.geofenceCollectionArn,
                trackerName: core_1.Lazy.string({ produce: () => this.trackerName }),
            });
        });
        this.trackerName = tracker.ref;
        this.trackerArn = tracker.attrArn;
        this.trackerCreateTime = tracker.attrCreateTime;
        this.trackerUpdateTime = tracker.attrUpdateTime;
    }
    /**
     * Add Geofence Collections which are associated to the tracker resource.
     */
    addGeofenceCollections(...geofenceCollections) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_location_alpha_IGeofenceCollection(geofenceCollections);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addGeofenceCollections);
            }
            throw error;
        }
        geofenceCollections.forEach((collection) => {
            new aws_location_1.CfnTrackerConsumer(this, `TrackerConsumer${collection.node.id}`, {
                consumerArn: collection.geofenceCollectionArn,
                trackerName: core_1.Lazy.string({ produce: () => this.trackerName }),
            });
        });
    }
    /**
     * Grant the given principal identity permissions to perform the actions on this tracker.
     */
    grant(grantee, ...actions) {
        return iam.Grant.addToPrincipal({
            grantee: grantee,
            actions: actions,
            resourceArns: [this.trackerArn],
        });
    }
    /**
     * Grant the given identity permissions to update device positions for a tracker
     *
     * @see https://docs.aws.amazon.com/location/latest/developerguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-read-only-trackers
     */
    grantUpdateDevicePositions(grantee) {
        return this.grant(grantee, 'geo:BatchUpdateDevicePosition');
    }
    /**
     * Grant the given identity permissions to read device positions from a tracker
     *
     * @see https://docs.aws.amazon.com/location/latest/developerguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-read-only-trackers
     */
    grantRead(grantee) {
        return iam.Grant.addToPrincipal({
            grantee,
            actions: [
                'geo:BatchGetDevicePosition',
                'geo:GetDevicePosition',
                'geo:GetDevicePositionHistory',
            ],
            resourceArns: [`${this.trackerArn}/*`],
        });
    }
};
exports.Tracker = Tracker;
_a = JSII_RTTI_SYMBOL_1;
Tracker[_a] = { fqn: "@aws-cdk/aws-location-alpha.Tracker", version: "2.203.1-alpha.0" };
/** Uniquely identifies this class. */
Tracker.PROPERTY_INJECTION_ID = '@aws-cdk.aws-location-alpha.Tracker';
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Tracker.prototype, "addGeofenceCollections", null);
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Tracker.prototype, "grant", null);
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Tracker.prototype, "grantUpdateDevicePositions", null);
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Tracker.prototype, "grantRead", null);
exports.Tracker = Tracker = Tracker_1 = __decorate([
    prop_injectable_1.propertyInjectable
], Tracker);
//# sourceMappingURL=data:application/json;base64,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