"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataSource = void 0;
exports.generateUniqueId = generateUniqueId;
const core_1 = require("aws-cdk-lib/core");
function generateUniqueId(context) {
    const name = core_1.Names.uniqueId(context);
    if (name.length > 100) {
        return name.substring(0, 50) + name.substring(name.length - 50);
    }
    return name;
}
/**
 * Data source for a place index
 */
var DataSource;
(function (DataSource) {
    /**
     * Esri
     *
     * @see https://docs.aws.amazon.com/location/latest/developerguide/esri.html
     */
    DataSource["ESRI"] = "Esri";
    /**
     * Grab provides routing functionality for Southeast Asia.
     *
     * @see https://docs.aws.amazon.com/location/latest/developerguide/grab.html
     */
    DataSource["GRAB"] = "Grab";
    /**
     * HERE
     *
     * @see https://docs.aws.amazon.com/location/latest/developerguide/HERE.html
     */
    DataSource["HERE"] = "Here";
})(DataSource || (exports.DataSource = DataSource = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBR0EsNENBTUM7QUFURCwyQ0FBeUM7QUFHekMsU0FBZ0IsZ0JBQWdCLENBQUMsT0FBbUI7SUFDbEQsTUFBTSxJQUFJLEdBQUcsWUFBSyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUNyQyxJQUFJLElBQUksQ0FBQyxNQUFNLEdBQUcsR0FBRyxFQUFFLENBQUM7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxNQUFNLEdBQUcsRUFBRSxDQUFDLENBQUM7SUFDbEUsQ0FBQztJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQUVEOztHQUVHO0FBQ0gsSUFBWSxVQXFCWDtBQXJCRCxXQUFZLFVBQVU7SUFDcEI7Ozs7T0FJRztJQUNILDJCQUFhLENBQUE7SUFFYjs7OztPQUlHO0lBQ0gsMkJBQWEsQ0FBQTtJQUViOzs7O09BSUc7SUFDSCwyQkFBYSxDQUFBO0FBQ2YsQ0FBQyxFQXJCVyxVQUFVLDBCQUFWLFVBQVUsUUFxQnJCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgTmFtZXMgfSBmcm9tICdhd3MtY2RrLWxpYi9jb3JlJztcbmltcG9ydCB7IElDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuZXhwb3J0IGZ1bmN0aW9uIGdlbmVyYXRlVW5pcXVlSWQoY29udGV4dDogSUNvbnN0cnVjdCk6IHN0cmluZyB7XG4gIGNvbnN0IG5hbWUgPSBOYW1lcy51bmlxdWVJZChjb250ZXh0KTtcbiAgaWYgKG5hbWUubGVuZ3RoID4gMTAwKSB7XG4gICAgcmV0dXJuIG5hbWUuc3Vic3RyaW5nKDAsIDUwKSArIG5hbWUuc3Vic3RyaW5nKG5hbWUubGVuZ3RoIC0gNTApO1xuICB9XG4gIHJldHVybiBuYW1lO1xufVxuXG4vKipcbiAqIERhdGEgc291cmNlIGZvciBhIHBsYWNlIGluZGV4XG4gKi9cbmV4cG9ydCBlbnVtIERhdGFTb3VyY2Uge1xuICAvKipcbiAgICogRXNyaVxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9sb2NhdGlvbi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZXNyaS5odG1sXG4gICAqL1xuICBFU1JJID0gJ0VzcmknLFxuXG4gIC8qKlxuICAgKiBHcmFiIHByb3ZpZGVzIHJvdXRpbmcgZnVuY3Rpb25hbGl0eSBmb3IgU291dGhlYXN0IEFzaWEuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xvY2F0aW9uL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9ncmFiLmh0bWxcbiAgICovXG4gIEdSQUIgPSAnR3JhYicsXG5cbiAgLyoqXG4gICAqIEhFUkVcbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbG9jYXRpb24vbGF0ZXN0L2RldmVsb3Blcmd1aWRlL0hFUkUuaHRtbFxuICAgKi9cbiAgSEVSRSA9ICdIZXJlJyxcbn1cbiJdfQ==