base_mappings = {
    "curve_mappings": {
        "4A_PRES": "4A_PRESS",
        "A16L": "RSHA",
        "A28H": "RMED",
        "A40L": "RDEP",
        "AC": "AC",
        "ACS": "ACS",
        "AI": "AI",
        "AI10": "RSHA",
        "AI60": "RMED",
        "AI90": "RDEP",
        "AO10": "RSHA",
        "AO60": "RMED",
        "AO90": "RDEP",
        "APLC": "APLC",
        "AT10": "RSHA",
        "AT60": "RMED",
        "AT90": "RDEP",
        "BFV": "BFV",
        "BFV_UHR": "BFV",
        "BPHI": "BPHI",
        "BS": "BS",
        "CAL": "CALI",
        "CALI": "CALI",
        "CALS": "CALI",
        "CGR": "CGR",
        "CMRT": "MRP",
        "CNC": "NEU",
        "DCAV": "CALI",
        "DCOR": "DENC",
        "DEN": "DEN",
        "DENC": "DENC",
        "DEN_VIRGIN": "DEN_VIRGIN",
        "DRHO": "DENC",
        "DT": "AC",
        "DTC": "AC",
        "DTCO": "AC",
        "DTS": "ACS",
        "DTSM": "ACS",
        "FFV": "FFV",
        "FFV_UHR": "FFV",
        "FPRESS": "FPRESS",
        "GR": "GR",
        "GRMA": "GR",
        "GR_EDTC": "GR",
        "HAC": "AC",
        "HCAL": "CALI",
        "HCGR": "CGR",
        "HCNC": "NEU",
        "HCNL": "NEU",
        "HCOR": "DENC",
        "HCORR": "DENC",
        "HDAR": "CALI",
        "HDEN": "DEN",
        "HDRA": "DENC",
        "HDRH": "DENC",
        "HDT": "AC",
        "HFK": "K",
        "HGR": "GR",
        "HPHI": "NEU",
        "HRD": "RDEP",
        "HRHO": "DEN",
        "HRM": "RMED",
        "HRS": "RMIC",
        "HSGR": "SGR",
        "HTHO": "TH",
        "HURA": "U",
        "IDDR": "DENC",
        "IDPE": "PEF",
        "IDRO": "DEN",
        "ILD": "RDEP",
        "ILM": "RMED",
        "K": "K",
        "LLD": "RDEP",
        "LLS": "RSHA",
        "M": "M",
        "MRP": "MRP",
        "MSFL": "RMIC",
        "NEU": "NEU",
        "NPHI": "NEU",
        "NPOR": "NEU",
        "P16L": "RSHA",
        "P28L": "RMED",
        "P40H": "RDEP",
        "P40L": "RDEP",
        "PE": "PEF",
        "PEB": "PEF",
        "PEF": "PEF",
        "PEFZ": "PEF",
        "POTA": "K",
        "RD": "RDEP",
        "RDEP": "RDEP",
        "RH72_1DF": "RH",
        "RHGA": "RHGE",
        "RHGE": "RHGE",
        "RHO8": "DEN",
        "RHOB": "DEN",
        "RHOZ": "DEN",
        "RMED": "RMED",
        "RMIC": "RMIC",
        "RMLL": "RMIC",
        "ROBB": "DEN",
        "ROP": "ROP",
        "RS": "RSHA",
        "RSHA": "RSHA",
        "RT": "RT",
        "RT_HRLT": "RDEP",
        "RV72_1DF": "RV",
        "RXO": "RXO",
        "RXOZ": "RXO",
        "RXO_ADT": "RXO",
        "RXO_HRLT": "RXO",
        "SFLU": "SFLU",
        "SGR": "SGR",
        "SHAR": "RSHA",
        "SP": "SP",
        "SPBR": "SP",
        "TEMP": "TEMP",
        "TH": "TH",
        "THOR": "TH",
        "TNPH": "NEU",
        "U": "U",
        "UCAV": "CALI",
        "URAN": "U",
        "WANH": "WANH",
        "WCAR": "WCAR",
        "WCLA": "WCLA",
        "WCLC": "WCLC",
        "WCOA": "WCOA",
        "WDOL": "WDOL",
        "WEVA": "WEVA",
        "WPYR": "WPYR",
        "WQFM": "WQFM",
        "WSID": "WSID",
        "ZCOR": "DENC",
        "ZDEN": "DEN",
        "ZONE": "lsuName",
        "lsuName": "lsuName",
        "wellName": "well_name",
        "well_name": "well_name",
        "WELL": "well_name",
        "well": "well_name",
    },
    "formations_map": {
        "UPPER ROTLIEGEND1 FM": 290,
        "UPPER ROTLIEGEND2 FM": 260,
        "KUPFERSCHIEFER FM": 257,
        "ZECHSTEIN FM": 255,  # new
        "BUNTER SHALE FM": 250,  # new, in Bacton GP
        "BUNTER SANDSTONE FM": 249,  # new, in Bacton GP
        "SMITH BANK FM": 248,
        "TEIST FM": 240,
        "LOMVI FM": 235,
        "SKAGERRAK FM": 228,
        "ALKE FM": 227,
        "LUNDE FM": 214,
        "GASSUM FM": 203,
        "RAUDE FM": 202,
        "EIRIKSSON FM": 198,
        "aaRE FM": 197,
        "AMUNDSEN FM": 195.5,
        "NANSEN FM": 195,
        "JOHANSEN FM": 194,
        "FJERRITSLEV FM": 187,
        "BURTON FM": 186,
        "TILJE FM": 185.5,
        "COOK FM": 185,
        "DRAKE FM": 180,
        "ROR FM": 179,
        "TOFTE FM": 177,
        "BRYNE FM": 174.5,
        "SLEIPNER FM": 174,
        "BROOM FM": 173.5,
        "RANNOCH FM": 173,
        "OSEBERG FM": 172.5,
        "ETIVE FM": 172,
        "ILE FM": 171,
        "NOT FM": 167.5,
        "NESS FM": 167,
        "RATTRAY FM": 166,
        "TARBERT FM": 165.5,
        "GARN FM": 165,
        "HEATHER FM": 164.5,
        "INTRA HEATHER FM SS": 164.5,
        "HUGIN FM": 164,
        "KROSSFJORD FM": 163.5,
        "SANDNES FM": 163,
        "FENSFJORD FM": 162.5,
        "MELKE FM": 161,
        "INTRA MELKE FM SS": 161,
        "HAUGESUND FM": 159.5,
        "EGERSUND FM": 158.5,
        "ULA FM": 158,
        "SPEKK FM": 157.5,
        "SOGNEFJORD FM": 157,
        "BRAE FM": 156.5,  # new, maybe informal
        "DRAUPNE FM": 156,
        "INTRA DRAUPNE FM SS": 156,
        "BoeRGLUM UNIT": 153,
        "ELDFISK FM": 152.5,
        "TAU FM": 152,
        "FARSUND FM": 149,
        "ROGN FM": 148,
        "FLEKKEFJORD FM": 146,
        "MANDAL FM": 142,
        "aaSGARD FM": 141,
        "INTRA aaSGARD FM SS": 141,
        "SAUDA FM": 140,
        "LYR FM": 137,
        "MIME FM": 134,
        "TUXEN FM": 128,
        "SOLA FM": 124,
        "RAN SANDSTONE UNITS": 122,
        "GRaaSEL FM": 116,
        "LANGE FM": 115,
        "AGAT FM": 110,
        "RoeDBY FM": 108,
        "HIDRA FM": 97,
        "SVARTE FM": 96,
        "BLODoeKS FM": 92,
        "HOD FM": 87,
        "TRYGGVASON FM": 86,
        "KVITNOS FM": 85.5,
        "LYSING FM": 85,
        "KYRRE FM": 84,
        "MAGNE FM": 77,  # new in .py file
        "HARDRaaDE FM": 75,
        "DELFIN FM (INFORMAL)": 70,
        "TOR FM": 69,
        "JORSALFARE FM": 68,
        "NISE FM": 67,
        "EKOFISK FM": 64,
        "VaaLE FM": 62.5,
        "TY FM": 62,
        "SPRINGAR FM": 61,
        "VIDAR FM": 60,
        "EGGA FM (INFORMAL)": 59,
        "MAUREEN FM": 58,
        "ANDREW FM": 57.5,
        "LISTA FM": 57,
        "TANG FM": 56,
        "HEIMDAL FM": 55,
        "HERMOD FM": 54.5,
        "FISKEBANK FM": 54,
        "SELE FM": 53.5,
        "FORTIES FM": 53,
        "TARE FM": 52,
        "BALDER FM": 51,
        "INTRA BALDER FM SS": 51,
        "BRYGGE FM": 50,
        "FRIGG FM": 45,
        "HORDA FM": 35,
        "MOLO FM": 33,
        "GRID FM": 32,
        "LARK FM": 22,
        "ULL FM": 26,
        "VADE FM": 25,
        "SKADE FM": 18,
        "NORA FM": 16,
        "KAI FM": 15,
        "EIR (INFORMAL) FM": 13,
        "UTSIRA FM": 8,
        "NAUST FM": 4,
        # Barents sea
        "FALK FM": 308,
        "UGLE FM": 320,
        "oeRN FM": 299,
        "FUGLEN FM": 161,
        "HEKKINGEN FM": 151,
        "KLIPPFISK FM": 135,
        "KNURR FM": 137,
        "KOLJE FM": 119,
        "KOLMULE FM": 111,
        "HAVERT FM": 252,
        "KLAPPMYSS FM": 248,
        "KOBBE FM": 243,
        "STEINKOBBE FM": 245,
        "ISBJoeRN FM": 286,
        "POLARREV FM": 291,
        "ULV FM": 285,
        "RoeYE FM": 269,
        "oeRRET FM": 265,
        "KVEITE FM": 83,
        "KVITING FM": 78,
        "TORSK FM": 40,
        "SNADD FM": 234,
        "NORDMELA FM": 191,
        "SToe FM": 176,
        "FRUHOLMEN FM": 224,
        "TUBaaEN FM": 204,
        "BLaeREROT FM": 339,
        "TETTEGRAS FM": 342,
        "SOLDOGG FM": 336,
    },
    "groups_map": {
        "BASEMENT": 444,  # Pre-Devonian, set to be equal to silur
        "ROTLIEGEND GP": 295,
        "ZECHSTEIN GP": 259,
        "BACTON GP": 252,  # new
        "HEGRE GP": 249.5,
        "LOLLAND GP": 229,  # new
        "JYLLAND GP": 220,  # new
        "RED BEDS (INFORMAL)": 226,
        "GREY BEDS (INFORMAL)": 212,
        "MORS GP": 210,  # new
        "STATFJORD GP": 204,
        "BaaT GP": 201,
        "DUNLIN GP": 196,
        "VESTLAND GP": 175,
        "FANGST GP": 171.5,
        "FLADEN GP": 169,
        "BRENT GP": 168,
        "VIKING GP": 162,
        "BOKNFJORD GP": 160,
        "TYNE GP": 159,
        "CROMER KNOLL GP": 140,
        "SHETLAND GP": 98,
        "ROGALAND GP": 61,
        "HORDALAND GP": 40,
        "NORDLAND GP": 12,
        # Barents sea
        "BILLEFJORDEN GP": 350,
        "GIPSDALEN GP": 310,
        "ADVENTDALEN GP": 143,
        "SASSENDALEN GP": 245,
        "BJARMELAND GP": 290,
        "TEMPELFJORDEN GP": 270,
        "NYGRUNNEN GP": 80,
        "SOTBAKKEN GP": 50,
        "KAPP TOSCANA GP": 200,
    },
    "systems_map": {
        "CAMBRIAN SY": 513,
        "ORDOVICIAN SY": 465,
        "SILURIAN SY": 432,
        "DEVONIAN SY": 388,
        "CARBONIFEROUS SY": 359,
        "PERMIAN SY": 329,
        "TRIASSIC SY": 227,
        "JURASSIC SY": 173,
        "CRETACEOUS SY": 106,
        "PALEOGENE SY": 45,
        # Add "s" to the names to don't mix them with:
        "ROGALANDS SY": 61,  # aligns with paleocene
        "HORDALANDS SY": 40,  # stretches across eocene and oligocene
        "NORDLANDS SY": 12,  # sretches across neogene and quaternary
    },
}
