# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['falocalrepo_server']

package_data = \
{'': ['*'],
 'falocalrepo_server': ['static/*', 'static/styles/*', 'templates/*']}

install_requires = \
['Jinja2>=3.1.2,<4.0.0',
 'Pillow>=9.2.0,<10.0.0',
 'bbcode>=1.1.0,<2.0.0',
 'beautifulsoup4>=4.11.1,<5.0.0',
 'chardet>=5.0.0,<6.0.0',
 'click-help-colors>=0.9.1,<0.10.0',
 'click>=8.1.3,<9.0.0',
 'falocalrepo-database>=5.4.0,<5.5.0',
 'fastapi>=0.85.1,<0.86.0',
 'htmlmin>=0.1.12,<0.2.0',
 'lxml>=4.9.1,<5.0.0',
 'uvicorn>=0.18.3,<0.19.0']

entry_points = \
{'console_scripts': ['falocalrepo-server = falocalrepo_server.__main__:main']}

setup_kwargs = {
    'name': 'falocalrepo-server',
    'version': '3.3.2',
    'description': 'Web interface for falocalrepo.',
    'long_description': '<div align="center">\n\n<img alt="logo" width="400" src="https://raw.githubusercontent.com/FurryCoders/Logos/main/logos/falocalrepo-server-transparent.png">\n\n# FALocalRepo-Server\n\nWeb interface for [falocalrepo](https://pypi.org/project/falocalrepo/).\n\n[![](https://img.shields.io/github/v/tag/FurryCoders/falocalrepo-server?label=github&sort=date&logo=github&color=blue)](https://github.com/FurryCoders/falocalrepo-server)\n[![](https://img.shields.io/pypi/v/falocalrepo-server?logo=pypi)](https://pypi.org/project/falocalrepo-server/)\n[![](https://img.shields.io/pypi/pyversions/falocalrepo-server?logo=Python)](https://www.python.org)\n[![](https://img.shields.io/badge/Bootstrap-5.2.0-7952B3?logo=bootstrap&logoColor=white)](https://getbootstrap.com)\n\n</div>\n\n## Installation & Requirements\n\nTo install the program it is sufficient to use Python pip and get the package `falocalrepo-server`.\n\n```shell\npip install falocalrepo-server\n```\n\nPython 3.10 or above is needed to run this program, all other dependencies are handled by pip during installation. For\ninformation on how to install Python on your computer, refer to the official\nwebsite [Python.org](https://www.python.org/).\n\nFor the program to run, a properly formatted database created by falocalrepo needs to be present in the same folder.\n\nThe styling is based on the [Boostrap CSS framework](https://getbootstrap.com).\n\n_Note:_ When upgrading to a new version the styling may be broken to due to the browser using the old stylesheet in its\ncache. To fix it, simply delete the browser cache to fetch the new version.f\n\n## Usage\n\n```\nfalocalrepo-server <database> [--host HOST] [--port PORT] [--ssl-cert SSL_CERT] [--ssl-key SSL_KEY] \n                   [--redirect-http REDIRECT_PORT] [--auth <username>:<password>] [--precache] [--no-browser]\n```\n\nThe server needs one argument pointing at the location of a valid [falocalrepo](https://pypi.org/project/falocalrepo/)\ndatabase and accepts optional arguments to manually set host, port, and an SSL certificate with key. By default, the\nserver is run on 0.0.0.0:80 for HTTP (without certificate) and 0.0.0.0:443 for HTTPS (with certificate).\n\nThe `--precache` options can be used to prepare an initial cache of results from the database to speed up searches.\n\nWhen the app has finished loading, it automatically opens a browser window. To avoid this, use the `--no-browser`\noption.\n\n### Redirect Mode\n\nThe optional `--redirect-http` argument changes the app mode to redirection. In this mode the app runs a tiny server\nthat redirects all HTTP requests it receives on `http://HOST:PORT` to `https://HOST:REDIRECT_PORT`.\n\n_Note:_ In redirect mode the `database` argument is not checked, so a simple `.` is sufficient.<br/>\n_Note:_ In redirect mode the app does not operate the database portion of the server. To run in redirect and server\nmode, two separate instances of the program are needed.\n\nOnce the server is running the web app can be accessed at the address shown in the terminal.\n\n### Authentication\n\nThe `--auth` option allows setting up a username and password to access the server using the HTTP Basic authentication\nprotocol.\n\n### Arguments\n\n| Argument          | Default                                          |\n|-------------------|--------------------------------------------------|\n| `database`        | None, mandatory argument                         |\n| `--host`          | 0.0.0.0                                          |\n| `--port`          | 80 if no SSL certificate is given, 443 otherwise |\n| `--ssl-cert`      | None                                             |\n| `--ssl-key`       | None                                             |\n| `--redirect-http` | None                                             |\n| `--auth`          | None                                             |\n| `--precache`      | False                                            |\n| `--no-browser`    | True                                             |\n\n### Examples\n\n```shell\n# Launch an HTTP server reachable from other machines using the server\'s hostname/IP\nfalocalrepo-server ~/FA.db\n```\n\n```shell\n# Launch a localhost-only server on port 8080\nfalocalrepo-server ~/FA.db --host 127.0.0.1 --port 8080\n```\n\n```shell\n# Launch a redirect server that listens to port 80 and redirects to port 443 on host 0.0.0.0\nfalocalrepo-server . --host 0.0.0.0 --port 80 --redirect-htpp 443\n```\n\n```shell\n# Launch a server with basic authentication using \'mickey\' as username and \'mouse\' as password\nfalocalrepo-server ~/FA.db --auth mickey:mouse\n```\n\n```shell\n# Launch an HTTPS server reachable from other machines using the server\'s hostname/IP\nfalocalrepo-server ~/FA.db --ssl-cert ~/FA.certificates/certificate.crt --ssl-key ~/FA.certificates/private.key \n```\n\n```shell\n# Launch a localhost-only HTTPS server on port 8443\nfalocalrepo-server ~/FA.db --host 127.0.0.1 --port 8443 --ssl-cert ~/FA.certificates/certificate.crt --ssl-key ~/FA.certificates/private.key \n```\n\n## Routes\n\n_Note:_ All the following paths are meant as paths from `<host>:<port>`.\n\n| Route                                          | Destination                                                                             |\n|------------------------------------------------|-----------------------------------------------------------------------------------------|\n| `/`                                            | Show home page with general information regarding the database                          |\n| `/search/`                                     | Redirects to `/search/submissions/`                                                     |\n| `/search/submissions/`                         | Search & browse submissions                                                             |\n| `/search/journals/`                            | Search & browse journals                                                                |\n| `/search/users/`                               | Search & browse users                                                                   |\n| `/settings/`                                   | Change default search settings                                                          |\n| `/user/<username>/`                            | Show information regarding a specific user                                              |\n| `/user/<username>/icon/`                       | Redirect to username\'s icon on Fur Affinity                                             |\n| `/user/<username>/thumbnail/`                  | Redirect to username\'s icon on Fur Affinity                                             |\n| `/gallery/<username>/`                         | Browse & search a user\'s gallery submissions                                            |\n| `/scraps/<username>/`                          | Browse & search a user\'s scraps submissions                                             |\n| `/submissions/<username>/`                     | Browse & search a user\'s gallery & scraps submissions                                   | \n| `/favorites/<username>/`                       | Browse & search a user\'s favorite submissions                                           |\n| `/mentions/<username>/`                        | Browse & search the submissions where the user is mentioned                             |\n| `/journals/<username>/`                        | Browse & search a user\'s journals                                                       |\n| `/full/<submission id>/`                       | Redirect to `/submission/<submission id>/`                                              |\n| `/view/<submission id>/`                       | Redirect to `/submission/<submission id>/`                                              |\n| `/submission/<submission id>/`                 | View a submission                                                                       |\n| `/submission/<submission id>/file/`            | Open the first submission file                                                          |\n| `/submission/<submission id>/file/<n>/`        | Open the nth first submission file                                                      |\n| `/submission/<submission id>/files/`           | Download all the submission files as a zip                                              |\n| `/submission/<submission id>/files/<n1>-<n2>/` | Download submissions files from index n1 to index n2 (0 indexed inclusive)              |\n| `/submission/<submission id>/thumbnail/`       | Open a submission thumbnail (generated for image submissions if no thumbnail is stored) |\n| `/submission/<submission id>/zip/`             | Download a submission\'s file, description, and metadata as a ZIP archive                |\n| `/journal/<journal id>/`                       | View a journal                                                                          |\n| `/journal/<journal id>/zip/`                   | Download a journal\'s content and metadata as a ZIP archive                              |\n\n### JSON API Routes\n\nThe following routes return information as JSON responses. They can be reached with `GET` and `POST` requests, the\nformer supports sending body fields as URL parameters.\n\n| Route                              | Destination                                                                                                                                                     | Body                                                                                 |\n|------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------|\n| `/json/search/<table>/`            | Perform a search on the database. The query field in the body uses the same [syntax](#query-language) as the query field in the [search page](#browse--search). | `{query?: str, offset?: int, limit?: int, sort?: str, order?: Union["asc", "desc"]}` |\n| `/json/user/<username>`            | Get user metadata and total submissions/journals                                                                                                                | None                                                                                 |\n| `/json/submission/<submission id>` | Get submission metadata and comments                                                                                                                            | None                                                                                 |\n| `/json/journal/<journal id>`       | Get journal metadata and comments                                                                                                                               | None                                                                                 |\n\n## Pages\n\n_Note:_ the images used in the following sections were taken using light mode, but all pages also support dark mode.\n\n### Home\n\nThe home page displays general information about the database and contains links to browse and search pages for the\nvarious tables.\n\nThe information table displays the total number of submissions, journals, and users together with the version of the\ndatabase. Clicking on any of the counters open the relevant search & browse page.\n\n### Browse & Search\n\nThe browse and search pages allow to explore the submissions/journals contained in the database. Searches are performed\ncase-insensitively using a simple syntax in the form `@field term [[| &] term ...]` which allows logic operators,\nparentheses and start/end of field matching, see [Query Language](#query-language) for details.\n\nSearch terms for submissions and journals default to the `any` field if none is used, while the `username` field is used\nfor users searches.\n\nThe controls at the top of the page allow to query the database and control the visualisation of the results.\n\n<div align="center">\n<img alt="" src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/search-form.png" width="600">\n</div>\n\nThe _Search_ input allows to insert the search query.\n\nThe _Field_ menu allows to insert a specific search field using a simple dropdown menu.\n\nThe _Sort_ and adjacent order menus change the sorting field and order of the search results. Submissions and journals\ndefault to descending ID, while users default to ascending username.\n\nThe _View_ menu allows changing between the (default) grid view to a list (table) view\n\nThe _Search_ button submits the search request using the current query and sorting settings.\n\nThe _Browse_ button resets the current search query and reverts to browse mode (all entries).\n\nThe _FA_ button opens the current search on Fur Affinity, translating the shared search and sorting fields (tags,\nauthor, description, and fileurl/fileext). The button is only available when searching submissions.\n\nThe gear button opens the search settings, the question mark button shows a quick help about the query language.\n\nUnder the search controls are the number of results and current page.\n\n<div align="center">\n<img alt="" src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/search-nav.png" width="400">\n</div>\n\nUnder the results numbers are the page controls. _First_ leads to page 1, _Prev_ leads to the previous page, _Next_\nleads to the next page, and _Last_ leads to the last page. These controls are also available at the bottom of the page.\n\nIn grid view, the results are presented using cards containing the same information as the list view, with the addition\nof thumbnails for submissions. When searching for submissions or journals, clicking on the card footer (containing the\ndate and author) will open the author\'s page. Submissions with more than one file will display a small counter with the\nnumber of files in the upper right corner of the card.\n\n<div align="center">\n<img src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/search-card.png" width="200">\n</div>\n\nIn list view, the results are presented in a table with the most important columns: ID, AUTHOR, DATE, and TITLE (\nsubmissions and journals); USERNAME, FOLDERS, and ACTIVE (users). On small screens some of these columns are shortened\nor removed.\n\n<div align="center">\n<img src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/search-list.png" width="800">\n</div>\n\n#### Compatibility with Fur Affinity Search\n\nMost Fur Affinity search queries (and links) are fully compatible with the program.\n\nExcept for the _NOT_ (!) operator, which follows different syntax rules, all Fur Affinity search fields are fully\nsupported: `@lower` (treated as `@author`), `@keywords` (treated as `@tags`), `@message` (treated as `@description`)\n, `@title` (treated as `@title`), `@filename` (treated as `@fileurl`).\n\n#### Query Language\n\nThe query language used for this server is based on and improves the search syntax currently used by the Fur Affinity\nwebsite. Its basic elements are:\n\n* `@<field>` field specifier (e.g. `@title`), all database columns are available as search fields.\n  See [falocalrepo-database](https://pypi.org/project/falocalrepo-database/) for details on the available columns.\n* `()` parentheses, they can be used for better logic operations\n* `&` _AND_ logic operator, used between search terms\n* `|` _OR_ logic operator, used between search terms\n* `!` _NOT_ logic operator, used as prefix of search terms\n* `""` quotes, allow searching for literal strings without needing to escape\n* `%` match 0 or more characters\n* `_` match exactly 1 character\n* `^` start of field, when used at the start of a search term, it matches the beginning of the field\n* `$` end of field, when used at the end of a search term, it matches the end of the field\n\nAll other strings are considered search terms.\n\nThe search uses the `@any` field by default for submissions and journals, allowing to do general searches without\nspecifying a field. The `@any` field does not include the `FAVORITE`, `FILESAVED`, `USERUPDATE`, and `ACTIVE` fields and\nmust be searched manually using the respective query fields. When searching users, `@username` is the default field.\n\nSearch terms that are not separated by a logic operator are considered _AND_ terms (i.e. `a b c` -> `a & b & c`).\n\nExcept for the `ID`, `FILESAVED`, `USERUPDATE`, and `ACTIVE` fields, all search terms are searched through the\nwhole content of the various fields: i.e. `@description cat` will match any item whose description field contains "cat".\nTo match items that contain only "cat" (or start with, end with, etc.), the `%`, `_`, `^`, and `$` operators need to be\nused (e.g. `@description ^cat`).\n\nSearch terms for `ID`, `FILESAVED`, `USERUPDATE`, and `ACTIVE` are matched exactly as they are: i.e. `@id 1` will match\nonly items whose ID field is exactly equal to "1", to match items that contain "1" the `%`, `_`, `^`, or `$` operators\nneed to be used (e.g. `@id %1%`).\n\n##### Examples\n\nSearch for journals/submissions containing water and either otter, lutrine, or mustelid, or water and either cat or\nfeline:\n\n`water ((otter | lutrine | mustelid) | (cat | feline))`\n\n`@any water & ((otter | lutrine | mustelid) | (cat | feline))`\n\nSearch for journals/submissions containing "cat" or "feline" but neither "mouse" nor "rodent":\n\n`(cat | feline) !mouse !rodent`\n\nSearch for general-rated submissions uploaded by a user whose name starts with "tom" that contain either "volleyball"\nor "volley" and "ball" separated by one character (e.g. "volley-ball") in any field:\n\n`@rating general @author tom% @any (volleyball | volley_ball)`\n\n`(volleyball | volley_ball) @rating general @author tom%`\n\nSearch for journals/submissions uploaded in 2020 except for March:\n\n`@date ^2020 !^2020-03`\n\nSearch for submissions uploaded in March 2021 (meaning the date has to start with `2021-03`) whose tags contain the\nexact tag "ball":\n\n`@date ^2021-03 @tags "|ball|"`\n\n`@date ^2021-03 @tags \\|ball\\|`\n\nSearch for journals/submissions where a specific user named "tom" is mentioned:\n\n`@mentions "|tom|"`\n\n`@mentions \\|tom\\|`\n\nSearch for submissions whose only favorite is a user named "alex":\n\n`@favorite ^\\|alex\\|$`\n\nSearch for users whose names contain "mark":\n\n`@username %mark%`\n\nSearch for journals/submissions whose title ends with "100%":\n\n`@title 100\\%$`\n\nSearch for journals/submissions whose title is exactly "cat":\n\n`@title ^cat$`\n\nSearch for text submissions with PDF files:\n\n`@type text @fileext pdf`\n\n### Search Settings\n\nThe search settings page allows modifying the sorting, ordering, and viewing option that are applied by default to the\nvarious searches. Settings can be saved to the database if it is writable, otherwise they are simply saved for the\ncurrent session and reset when the program stops.\n\nSettings values are saved in the `SETTINGS` table with the `SERVER.SEARCH` setting name.\n\n### User\n\nThe user page shows information about submissions and journals related to a user (gallery, scraps, favorites, mentions,\nand journals) and what folders have been set for download. See [falocalrepo](https://pypi.org/project/falocalrepo/) for\nmore details on this. The user\'s profile will be displayed if present in the database.\n\nClicking on any of the counters opens the relevant results via the search interface, allowing to refine the search\nfurther.\n\nThe _Next_ and _Prev_ buttons move to the respective users in ascending alphabetical order.\n\n### Submission\n\nThe submission page shows the submission file(s) (if present), the submission metadata, and the description.\n\nImage, audio, video, and plain text submission files are displayed directly in the page, others (e.g. PDF files) will\ndisplay a link to open them. Clicking on image files will enlarge them to fill the width of the screen for easier\nviewing. Video files can be enlarged by using the zoom button under them.\n\nWhen a submission has two or more files, a toolbar appears below the file section with buttons to switch between the\ndifferent files, show the files in a grid view, and enlarge non-image files (text, video, etc.).\n\n<div align="center">\n<img alt="" src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/buttons-file-switcher.png" width="200">\n</div>\n\nThe metadata table contains clickable links to the user\'s page (see [User](#user) for details), tags, category, species,\ngender, rating, folder (gallery/scraps), and to user pages of favouring and mentioned users.\n\nThe description is displayed as-is except for user icons, which are replaced by `@username` styled links to avoid\ndisplay errors caused by expired icon links.\n\nUnder the metadata table are a number of buttons that allow to access the submission file, open its Fur Affinity\ncounterpart, and navigate the other submissions from the author.\n\n<div align="center">\n<img alt="" src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/buttons-submission.png" width="400">\n</div>\n\nThe download _File_ button downloads the submission file (if present). If more than one file is present, then the button\ndownloads a zip file containing all submission files.\n\nThe download _ZIP_ button generates a ZIP file containing the submission file, submission thumbnail, description HTML,\nand metadata and comments in JSON format.\n\nThe _FA_ button opens the submission on Fur Affinity\n\nThe _Next_ and _Prev_ buttons lead to the next more recent and the previous less recent submissions respectively.\n\nThe _Gallery_, _All_, and _Scraps_ buttons open a search page with the user\'s gallery submissions, scraps and gallery\nsubmissions together, and scraps submissions respectively.\n\nTo view the currently selected submission file when scrolling down the page, the button in the lower right corner can be\nused to open the image in a floating overlay that will remain at the top of the page view.\n\n<img alt="" src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/buttons-submission-overlay.png" width="50">\n\nThe comments to the submission can be found below the description, and can be reached quickly by clicking on the\nfloating comments button that appears in the lower right corner of the screen if the submission has comments.\n\n<img alt="" src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/buttons-comments-link.png" width="50">\n\nEach comment contains the author (with a link to their user page), post date, and links to the comment itself and, if\nthe comment is a reply, its parent comments.\n\n<div align="center">\n<img alt="" src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/comment-card.png" width="400">\n</div>\n\nThe button furthest to the left (arrow pointing up and to the left) links to the first comment in a reply chain. The\nmiddle button (bent arrow pointing to the left) links to the previous comment in the reply chain. The link button\nfurthest to the right is a link to that specific comment.\n\n### Journal\n\nThe journal page shows the journal metadata and content.\n\nThe metadata table contains clickable links to the user\'s page (see [User](#user) for details) and to user pages of\nmentioned users.\n\nUnder the metadata table are a number of buttons that allow to download the journal, open its Fur Affinity counterpart,\nand navigate the other journals from the same user.\n\n<div align="center">\n<img alt="" src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/buttons-journal.png" width="400">\n</div>\n\nThe download _ZIP_ button generates a ZIP file containing the journal content HTML and metadata and comments in JSON\nformat.\n\nThe _FA_ button opens the journal on Fur Affinity\n\nThe _Next_ and _Prev_ buttons lead to the next more recent, and the previous less recent journals respectively.\n\nThe _All_ button opens a search page with all the user\'s journals.\n\nThe comments to the journal can be found below the journal text, and can be reached quickly by clicking on the floating\ncomments button that appears in the lower right corner of the screen if the journal has comments.\n\n<img alt="" src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/buttons-comments-link.png" width="50">\n\nEach comment contains the author (with a link to their user page), post date, and links to the comment itself and, if\nthe comment is a reply, its parent comments.\n\n<div align="center">\n<img alt="" src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/comment-card.png" width="400">\n</div>\n\nThe button furthest to the left (arrow pointing up and to the left) links to the first comment in a reply chain. The\nmiddle button (bent arrow pointing to the left) links to the previous comment in the reply chain. The link button\nfurthest to the right is a link to that specific comment.\n\n### BBCode\n\nWhen the database is in BBCode mode a new buttons appears along submission descriptions, journal contents, and user\nprofiles to switch between the rendered HTML and the BBCode stored in the database.\n\n<div align="center">\n<img alt="" src="https://raw.githubusercontent.com/FurryCoders/falocalrepo-server/master/doc/buttons-bbcode.png" width="120">\n</div>\n\n_Note:_ the BBCode to HTML conversion is still a work in progress and some content may be rendered incorrectly; please\nopen\nan [issue](https://github.com/FurryCoders/falocalrepo-server/issues) if you encounter any error :)\n',
    'author': 'Matteo Campinoti',
    'author_email': 'matteo.campinoti94@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FurryCoders/falocalrepo-server',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
