# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-08-27 13:15
from __future__ import unicode_literals

import uuid

import django.db.models.deletion
import jsonfield.fields
from django.db import migrations, models

import eox_audit_model.constants
import eox_audit_model.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='AuditModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.UUIDField(default=uuid.uuid4, editable=False, unique=True, verbose_name=b'Public identifier')),
                ('action', models.CharField(max_length=150)),
                ('audit_date_stamp', models.DateTimeField(auto_now_add=True)),
                ('input_parameters', models.TextField(blank=True, null=True)),
                ('captured_logs', models.TextField(blank=True, null=True)),
                ('traceback_log', models.TextField(blank=True, null=True)),
                ('method_name', models.CharField(max_length=150)),
                ('output_parameters', models.TextField(blank=True, null=True)),
                ('performer', models.CharField(default=eox_audit_model.models.get_current_performer, max_length=150)),
                ('status', models.PositiveIntegerField(choices=[(0, b'FAIL'), (1, b'SUCCESS')], default=eox_audit_model.constants.Status(1))),
                ('ip', models.CharField(default=eox_audit_model.models.get_current_ip, max_length=150)),
                ('site', models.ForeignKey(default=eox_audit_model.models.get_current_site, on_delete=django.db.models.deletion.CASCADE, to='sites.Site')),
            ],
        ),
    ]
