

restart_ignore = {'PW': ['max_seconds', 'nstep', 'restart_mode',
                         'electron_maxstep',
                         'scf_must_converge',
                         'mixing_mode',
                         'mixing_beta',
                         'mixing_ndim',
                         'mixing_fixed_ns',
                         'diagonalization',
                         'diago_cg_maxiter',
                         'diago_david_ndim',
                         'diago_full_acc',
                         'startingpot',
                         'startingwfc',
                         'tqr',
                         'real_space',
                         'title',
                         'disk_io',
                         'wf_collect',
                         'outdir',
                         'pseudo_dir',
                         #
                         'diago_thr_init',
                         'tprnfor',
                         ]}

default = {
    'PW': {'disk_io': {'scf': 'low', 'nscf': 'medium', 'bands': 'medium', 'relax': 'medium', 'md': 'medium', 'vc-relax': 'medium', 'vc-md': 'medium'},
           'nstep': {'scf': 1, 'nscf': 1, 'bands': 1, 'relax': 50, 'md': 50, 'vc-relax': 50, 'vc-md': 50},
           'pseudo_dir': '$HOME/espresso/pseudo/',
           },
}

Ha2Ry = {
    'ecutwfc',
    'ecutrho',
    'ecutfock',
    # 'degauss',  # not sure
    'etot_conv_thr',
    'forc_conv_thr',
}

qe_namespace = {'BANDS': {'BANDS': {'filband': ['CHARACTER', []],
                                    'filp': ['CHARACTER', []],
                                    'firstk, lastk': ['INTEGER', []],
                                    'lp': ['LOGICAL', []],
                                    'lsigma(i), i=1,3': ['LOGICAL', []],
                                    'lsym': ['LOGICAL', []],
                                    'no_overlap': ['LOGICAL', []],
                                    'outdir': ['CHARACTER', []],
                                    'plot_2d': ['LOGICAL', []],
                                    'prefix': ['CHARACTER', []],
                                    'spin_component': ['INTEGER', []]}},
                'DOS': {'DOS': {'DeltaE': ['REAL', []],
                                'Emin, Emax': ['REAL', []],
                                'bz_sum': ['CHARACTER',
                                           ['smearing',
                                            'tetrahedra',
                                            'tetrahedra_lin',
                                            'tetrahedra_opt']],
                                'degauss': ['REAL', []],
                                'fildos': ['CHARACTER', []],
                                'ngauss': ['INTEGER', []],
                                'outdir': ['CHARACTER', []],
                                'prefix': ['CHARACTER', []]}},
                'NEB': {'PATH': {'CI_scheme': ['CHARACTER', ['no-CI', 'auto', 'manual']],
                                 'ds': ['REAL', []],
                                 'fcp_mu': ['REAL', []],
                                 'fcp_tot_charge_first': ['REAL', []],
                                 'fcp_tot_charge_last': ['REAL', []],
                                 'first_last_opt': ['LOGICAL', []],
                                 'k_max, k_min': ['REAL', []],
                                 'lfcpopt': ['LOGICAL', []],
                                 'minimum_image': ['LOGICAL', []],
                                 'nstep_path': ['INTEGER', []],
                                 'num_of_images': ['INTEGER', []],
                                 'opt_scheme': ['CHARACTER',
                                                ['sd',
                                                 'broyden',
                                                 'broyden2',
                                                 'quick-min',
                                                 'langevin']],
                                 'path_thr': ['REAL', []],
                                 'restart_mode': ['CHARACTER', ['from_scratch', 'restart']],
                                 'string_method': ['CHARACTER', ['neb', 'smd']],
                                 'temp_req': ['REAL', []],
                                 'use_freezing': ['LOGICAL', []],
                                 'use_masses': ['LOGICAL', []]},
                        'ATOMIC_POSITIONS': {},
                        'CLIMBING_IMAGES': {'index1, index2, ... indexN': ['INTEGER', []]}},
                'PP': {'INPUTPP': {'degauss_ldos': ['REAL', []],
                                   'delta_e': ['REAL', []],
                                   'emax': ['REAL', []],
                                   'emin': ['REAL', []],
                                   'filplot': ['CHARACTER', []],
                                   'kband(i), i=1,2': ['INTEGER', []],
                                   'kpoint(i), i=1,2': ['INTEGER', []],
                                   'lsign': ['LOGICAL', []],
                                   'outdir': ['CHARACTER', []],
                                   'plot_num': ['INTEGER', []],
                                   'prefix': ['CHARACTER', []],
                                   'sample_bias': ['REAL', []],
                                   'spin_component': ['INTEGER', []],
                                   'spin_component(i), i=1,2': ['INTEGER', []]},
                       'PLOT': {'e1(i), \n\t\te2(i), \n\t\t \n\t\t  i=1,3': ['REAL', []],
                                'e1(i), \n\t\te2(i), \n\t\te3(i), \n\t\t \n\t\t  i=1,3': ['REAL',
                                                                                          []],
                                'e1(i), i=1,3': ['REAL', []],
                                'fileout': ['CHARACTER', []],
                                'filepp(i), i=1,nfile': ['CHARACTER', []],
                                'iflag': ['INTEGER', []],
                                'interpolation': ['CHARACTER', ['fourier', 'bspline']],
                                'nfile': ['INTEGER', []],
                                'nx': ['INTEGER', []],
                                'nx, ny': ['INTEGER', []],
                                'nx, ny, nz': ['INTEGER', []],
                                'output_format': ['INTEGER', []],
                                'radius': ['REAL', []],
                                'weight(i), i=1,nfile': ['REAL', []],
                                'x0(i), i=1,3': ['REAL', []]}},
                'PROJWFC': {'PROJWFC': {'DeltaE': ['REAL', []],
                                        'Emin, Emax': ['REAL', []],
                                        'degauss': ['REAL', []],
                                        'filpdos': ['CHARACTER', []],
                                        'filproj': ['CHARACTER', []],
                                        'irmax(3,n_proj_boxes)': ['INTEGER', []],
                                        'irmin(3,n_proj_boxes)': ['INTEGER', []],
                                        'kresolveddos': ['LOGICAL', []],
                                        'lbinary_data': ['LOGICAL', []],
                                        'lsym': ['LOGICAL', []],
                                        'lwrite_overlaps': ['LOGICAL', []],
                                        'n_proj_boxes': ['INTEGER', []],
                                        'ngauss': ['INTEGER', []],
                                        'outdir': ['CHARACTER', []],
                                        'pawproj': ['LOGICAL', []],
                                        'plotboxes': ['LOGICAL', []],
                                        'prefix': ['CHARACTER', []],
                                        'tdosinboxes': ['LOGICAL', []]}},
                'PW': {'CELL': {'cell_dofree': ['CHARACTER',
                                                ['all',
                                                 'ibrav',
                                                 'x',
                                                 'y',
                                                 'z',
                                                 'xy',
                                                 'xz',
                                                 'yz',
                                                 'xyz',
                                                 'shape',
                                                 'volume',
                                                 '2Dxy',
                                                 '2Dshape',
                                                 'epitaxial_ab',
                                                 'epitaxial_ac',
                                                 'epitaxial_bc']],
                                'cell_dynamics': ['CHARACTER',
                                                  ['none',
                                                   'sd',
                                                   'damp-pr',
                                                   'damp-w',
                                                   'bfgs',
                                                   'none',
                                                   'pr',
                                                   'w']],
                                'cell_factor': ['REAL', []],
                                'press': ['REAL', []],
                                'press_conv_thr': ['REAL', []],
                                'wmass': ['REAL', []]},
                       'CONTROL': {'calculation': ['CHARACTER',
                                                   ['scf',
                                                    'nscf',
                                                    'bands',
                                                    'relax',
                                                    'md',
                                                    'vc-relax',
                                                    'vc-md']],
                                   'dipfield': ['LOGICAL', []],
                                   'disk_io': ['CHARACTER',
                                               ['high', 'medium', 'low', 'nowf', 'none']],
                                   'dt': ['REAL', []],
                                   'etot_conv_thr': ['REAL', []],
                                   'forc_conv_thr': ['REAL', []],
                                   'gate': ['LOGICAL', []],
                                   'gdir': ['INTEGER', []],
                                   'iprint': ['INTEGER', []],
                                   'lberry': ['LOGICAL', []],
                                   'lelfield': ['LOGICAL', []],
                                   'lfcpopt': ['LOGICAL', []],
                                   'lkpoint_dir': ['LOGICAL', []],
                                   'lorbm': ['LOGICAL', []],
                                   'max_seconds': ['REAL', []],
                                   'nberrycyc': ['INTEGER', []],
                                   'nppstr': ['INTEGER', []],
                                   'nstep': ['INTEGER', []],
                                   'outdir': ['CHARACTER', []],
                                   'prefix': ['CHARACTER', []],
                                   'pseudo_dir': ['CHARACTER', []],
                                   'restart_mode': ['CHARACTER', ['from_scratch', 'restart']],
                                   'tefield': ['LOGICAL', []],
                                   'title': ['CHARACTER', []],
                                   'tprnfor': ['LOGICAL', []],
                                   'tstress': ['LOGICAL', []],
                                   'verbosity': ['CHARACTER', ['high', 'low']],
                                   'wf_collect': ['LOGICAL', []],
                                   'wfcdir': ['CHARACTER', []]},
                       'ELECTRONS': {'adaptive_thr': ['LOGICAL', []],
                                     'conv_thr': ['REAL', []],
                                     'conv_thr_init': ['REAL', []],
                                     'conv_thr_multi': ['REAL', []],
                                     'diago_cg_maxiter': ['INTEGER', []],
                                     'diago_david_ndim': ['INTEGER', []],
                                     'diago_full_acc': ['LOGICAL', []],
                                     'diago_thr_init': ['REAL', []],
                                     'diagonalization': ['CHARACTER',
                                                         ['david',
                                                          'cg',
                                                          'ppcg',
                                                          'paro',
                                                          'ParO']],
                                     'efield': ['REAL', []],
                                     'efield_cart(i), i=1,3': ['REAL', []],
                                     'efield_phase': ['CHARACTER', ['read', 'write', 'none']],
                                     'electron_maxstep': ['INTEGER', []],
                                     'mixing_beta': ['REAL', []],
                                     'mixing_fixed_ns': ['INTEGER', []],
                                     'mixing_mode': ['CHARACTER',
                                                     ['plain', 'TF', 'local-TF']],
                                     'mixing_ndim': ['INTEGER', []],
                                     'real_space': ['LOGICAL', []],
                                     'scf_must_converge': ['LOGICAL', []],
                                     'startingpot': ['CHARACTER', ['atomic', 'file']],
                                     'startingwfc': ['CHARACTER',
                                                     ['atomic',
                                                      'atomic+random',
                                                      'random',
                                                      'file']],
                                     'tqr': ['LOGICAL', []]},
                       'IONS': {'bfgs_ndim': ['INTEGER', []],
                                'delta_t': ['REAL', []],
                                'ion_dynamics': ['CHARACTER',
                                                 ['bfgs',
                                                  'damp',
                                                  'verlet',
                                                  'langevin',
                                                  'langevin-smc',
                                                  'bfgs',
                                                  'damp',
                                                  'beeman']],
                                'ion_positions': ['CHARACTER', ['default', 'from_input']],
                                'ion_temperature': ['CHARACTER',
                                                    ['rescaling',
                                                     'rescale-v',
                                                     'rescale-T',
                                                     'reduce-T',
                                                     'berendsen',
                                                     'andersen',
                                                     'svr',
                                                     'initial',
                                                     'not_controlled']],
                                'ion_velocities': ['CHARACTER', ['default', 'from_input']],
                                'nraise': ['INTEGER', []],
                                'pot_extrapolation': ['CHARACTER',
                                                      ['none',
                                                       'atomic',
                                                       'first_order',
                                                       'second_order']],
                                'refold_pos': ['LOGICAL', []],
                                'remove_rigid_rot': ['LOGICAL', []],
                                'tempw': ['REAL', []],
                                'tolp': ['REAL', []],
                                'trust_radius_ini': ['REAL', []],
                                'trust_radius_max': ['REAL', []],
                                'trust_radius_min': ['REAL', []],
                                'upscale': ['REAL', []],
                                'w_1': ['REAL', []],
                                'w_2': ['REAL', []],
                                'wfc_extrapolation': ['CHARACTER',
                                                      ['none',
                                                       'first_order',
                                                       'second_order']]},
                       'SYSTEM': {'A, B, C, cosAB, cosAC, cosBC': ['REAL', []],
                                  'Hubbard_J(i,ityp), (i,ityp) = (1,1) ... (3,ntyp)': ['REAL',
                                                                                       []],
                                  'Hubbard_J0(i), i=1,ntype': ['REAL', []],
                                  'Hubbard_U(i), i=1,ntyp': ['REAL', []],
                                  'Hubbard_V(na,nb,k), (na,nb,k) = (1,1,1) ... (natx,27*natx,4)': ['REAL',
                                                                                                   []],
                                  'Hubbard_alpha(i), i=1,ntyp': ['REAL', []],
                                  'Hubbard_beta(i), i=1,ntyp': ['REAL', []],
                                  'Hubbard_parameters': ['CHARACTER', ['input', 'file']],
                                  'U_projection_type': ['CHARACTER',
                                                        ['atomic',
                                                         'ortho-atomic',
                                                         'norm-atomic',
                                                         'file',
                                                         'pseudo']],
                                  'ace': ['LOGICAL', []],
                                  'angle1(i), i=1,ntyp': ['REAL', []],
                                  'angle2(i), i=1,ntyp': ['REAL', []],
                                  'assume_isolated': ['CHARACTER',
                                                      ['none',
                                                       'makov-payne',
                                                       'm-p',
                                                       'mp',
                                                       'martyna-tuckerman',
                                                       'm-t',
                                                       'mt',
                                                       'esm',
                                                       '2D']],
                                  'block': ['LOGICAL', []],
                                  'block_1': ['REAL', []],
                                  'block_2': ['REAL', []],
                                  'block_height': ['REAL', []],
                                  'celldm(i), i=1,6': ['REAL', []],
                                  'constrained_magnetization': ['CHARACTER', []],
                                  'degauss': ['REAL', []],
                                  'dftd3_threebody': ['LOGICAL', []],
                                  'dftd3_version': ['integer',
                                                    ['dftd3_version=2',
                                                     'dftd3_version=3',
                                                     'dftd3_version=4',
                                                     'dftd3_version=5',
                                                     'dftd3_version=6']],
                                  'eamp': ['REAL', []],
                                  'ecfixed': ['REAL', []],
                                  'ecutfock': ['REAL', []],
                                  'ecutrho': ['REAL', []],
                                  'ecutvcut': ['REAL', []],
                                  'ecutwfc': ['REAL', []],
                                  'edir': ['INTEGER', []],
                                  'emaxpos': ['REAL', []],
                                  'ensemble_energies': ['LOGICAL', []],
                                  'eopreg': ['REAL', []],
                                  'esm_bc': ['CHARACTER', []],
                                  'esm_efield': ['REAL', []],
                                  'esm_nfit': ['INTEGER', []],
                                  'esm_w': ['REAL', []],
                                  'exx_fraction': ['REAL', []],
                                  'exxdiv_treatment': ['CHARACTER',
                                                       ['gygi-baldereschi',
                                                        'vcut_spherical',
                                                        'vcut_ws',
                                                        'none']],
                                  'fcp_mu': ['REAL', []],
                                  'fixed_magnetization(i), i=1,3': ['REAL', []],
                                  'force_symmorphic': ['LOGICAL', []],
                                  'ibrav': ['INTEGER', []],
                                  'input_dft': ['CHARACTER', []],
                                  'lambda': ['REAL', []],
                                  'lda_plus_u': ['LOGICAL', []],
                                  'lda_plus_u_kind': ['INTEGER', []],
                                  'lforcet': ['LOGICAL', []],
                                  'localization_thr': ['REAL', []],
                                  'london': ['LOGICAL', []],
                                  'london_c6(i), i=1,ntyp': ['REAL', []],
                                  'london_rcut': ['REAL', []],
                                  'london_rvdw(i), i=1,ntyp': ['REAL', []],
                                  'london_s6': ['REAL', []],
                                  'lspinorb': ['LOGICAL', []],
                                  'nat': ['INTEGER', []],
                                  'nbnd': ['INTEGER', []],
                                  'no_t_rev': ['LOGICAL', []],
                                  'noinv': ['LOGICAL', []],
                                  'noncolin': ['LOGICAL', []],
                                  'nosym': ['LOGICAL', []],
                                  'nosym_evc': ['LOGICAL', []],
                                  'nqx1, nqx2, nqx3': ['INTEGER', []],
                                  'nr1, nr2, nr3': ['INTEGER', []],
                                  'nr1s, nr2s, nr3s': ['INTEGER', []],
                                  'nspin': ['INTEGER', []],
                                  'ntyp': ['INTEGER', []],
                                  'occupations': ['CHARACTER',
                                                  ['smearing',
                                                   'tetrahedra',
                                                   'tetrahedra_lin',
                                                   'tetrahedra_opt',
                                                   'fixed',
                                                   'from_input']],
                                  'one_atom_occupations': ['LOGICAL', []],
                                  'origin_choice': ['INTEGER', []],
                                  'q2sigma': ['REAL', []],
                                  'qcutz': ['REAL', []],
                                  'relaxz': ['LOGICAL', []],
                                  'report': ['INTEGER', []],
                                  'rhombohedral': ['LOGICAL', []],
                                  'screening_parameter': ['REAL', []],
                                  'smearing': ['CHARACTER',
                                               ['gaussian',
                                                'gauss',
                                                'methfessel-paxton',
                                                'm-p',
                                                'mp',
                                                'marzari-vanderbilt',
                                                'cold',
                                                'm-v',
                                                'mv',
                                                'fermi-dirac',
                                                'f-d',
                                                'fd']],
                                  'space_group': ['INTEGER', []],
                                  'starting_charge(i), i=1,ntyp': ['REAL', []],
                                  'starting_magnetization(i), i=1,ntyp': ['REAL', []],
                                  'starting_ns_eigenvalue(m,ispin,ityp), (m,ispin,ityp) = (1,1,1) ... (2*lmax+1,nspin or npol,ntyp)': ['REAL',
                                                                                                                                       []],
                                  'starting_spin_angle': ['LOGICAL', []],
                                  'tot_charge': ['REAL', []],
                                  'tot_magnetization': ['REAL', []],
                                  'ts_vdw_econv_thr': ['REAL', []],
                                  'ts_vdw_isolated': ['LOGICAL', []],
                                  'uniqueb': ['LOGICAL', []],
                                  'use_all_frac': ['LOGICAL', []],
                                  'vdw_corr': ['CHARACTER', []],
                                  'x_gamma_extrapolation': ['LOGICAL', []],
                                  'xdm': ['LOGICAL', []],
                                  'xdm_a1': ['REAL', []],
                                  'xdm_a2': ['REAL', []],
                                  'zgate': ['REAL', []]},
                       'ATOMIC_FORCES': {'X': ['CHARACTER', []], 'fx, fy, fz': ['REAL', []]},
                       'ATOMIC_POSITIONS': {"Card's options:": ["Card's options:",
                                                                ['alat',
                                                                 'bohr',
                                                                 'angstrom',
                                                                 'crystal',
                                                                 'crystal_sg']],
                                            'X': ['CHARACTER', []],
                                            'if_pos(1), if_pos(2), if_pos(3)': ['INTEGER', []],
                                            'x, y, z': ['REAL', []]},
                       'ATOMIC_SPECIES': {'Mass_X': ['REAL', []],
                                          'PseudoPot_X': ['CHARACTER', []],
                                          'X': ['CHARACTER', []]},
                       'ATOMIC_VELOCITIES': {'V': ['CHARACTER', []],
                                             'vx, vy, vz': ['REAL', []]},
                       'CELL_PARAMETERS': {"Card's options:": ["Card's options:", []],
                                           'v1, v2, v3': ['REAL', []]},
                       'CONSTRAINTS': {'constr(1), constr(2), constr(3), constr(4)': ['', []],
                                       'constr_target': ['REAL', []],
                                       'constr_tol': ['REAL', []],
                                       'constr_type': ['CHARACTER',
                                                       ['type_coord',
                                                        'atom_coord',
                                                        'distance',
                                                        'planar_angle',
                                                        'torsional_angle',
                                                        'bennett_proj']],
                                       'nconstr': ['INTEGER', []]},
                       'K_POINTS': {"Card's options:": ["Card's options:",
                                                        ['tpiba',
                                                         'automatic',
                                                         'crystal',
                                                         'gamma',
                                                         'tpiba_b',
                                                         'crystal_b',
                                                         'tpiba_c',
                                                         'crystal_c']],
                                    'nk1, nk2, nk3': ['INTEGER', []],
                                    'nks': ['INTEGER', []],
                                    'sk1, sk2, sk3': ['INTEGER', []],
                                    'xk_x, xk_y, xk_z, wk': ['REAL', []]},
                       'OCCUPATIONS': {'f_inp1': ['REAL', []], 'f_inp2': ['REAL', []]}}}

default_parameters = {'BANDS': {'BANDS': {'filband': 'bands.out',
                                          'filp': 'p_avg.dat',
                                          'firstk, lastk': 1e+30,
                                          'lp': False,
                                          'lsigma(i), i=1,3': True,
                                          'lsym': True,
                                          'no_overlap': True,
                                          'outdir': 'valueoftheESPRESSO_TMPDIRenvironmentvariableifset;\n'
                                          'currentdirectory(./)otherwise',
                                          'plot_2d': False,
                                          'prefix': 'pwscf',
                                          'spin_component': 1e+30}},
                      'DOS': {'DOS': {'DeltaE': 1e+30,
                                      'Emin, Emax': 1e+30,
                                      'bz_sum': 'smearingifdegaussisgivenininput;\n'
                                      'optionsreadfromthexmldatafileotherwise.',
                                      'degauss': 1e+30,
                                      'fildos': 'prefix.dos',
                                      'ngauss': 1e+30,
                                      'outdir': 'valueoftheESPRESSO_TMPDIRenvironmentvariableifset;\n'
                                      'currentdirectory(./)otherwise',
                                      'prefix': 'pwscf'}},
                      'NEB': {'PATH': {'CI_scheme': 'no-CI',
                                       'ds': 1.0,
                                       'fcp_mu': 1e+30,
                                       'fcp_tot_charge_first': 1e+30,
                                       'fcp_tot_charge_last': 1e+30,
                                       'first_last_opt': False,
                                       'k_max, k_min': 1e+30,
                                       'lfcpopt': True,
                                       'minimum_image': False,
                                       'nstep_path': 1,
                                       'num_of_images': 0,
                                       'opt_scheme': 'quick-min',
                                       'path_thr': 1e+30,
                                       'restart_mode': 'from_scratch',
                                       'string_method': 'neb',
                                       'temp_req': 1e+30,
                                       'use_freezing': False,
                                       'use_masses': False},
                              'ATOMIC_POSITIONS': {},
                              'CLIMBING_IMAGES': {'index1, index2, ... indexN': 1e+30}},
                      'PP': {'INPUTPP': {'degauss_ldos': 1e+30,
                                         'delta_e': 1e+30,
                                         'emax': 1e+30,
                                         'emin': 1e+30,
                                         'filplot': '',
                                         'kband(i), i=1,2': 1e+30,
                                         'kpoint(i), i=1,2': 1e+30,
                                         'lsign': True,
                                         'outdir': 'valueoftheESPRESSO_TMPDIRenvironmentvariableifset;\n'
                                         'currentdirectory(./)otherwise',
                                         'plot_num': 1e+30,
                                         'prefix': '',
                                         'sample_bias': 1e+30,
                                         'spin_component': 0,
                                         'spin_component(i), i=1,2': 1e+30},
                             'PLOT': {'e1(i), \n\t\te2(i), \n\t\t \n\t\t  i=1,3': 1e+30,
                                      'e1(i), \n\t\te2(i), \n\t\te3(i), \n\t\t \n\t\t  i=1,3': 1e+30,
                                      'e1(i), i=1,3': 1e+30,
                                      'fileout': 'standardoutput',
                                      'filepp(i), i=1,nfile': 'filepp(1)=filplot',
                                      'iflag': 1e+30,
                                      'interpolation': 'fourier',
                                      'nfile': 1e+30,
                                      'nx': 1e+30,
                                      'nx, ny': 1e+30,
                                      'nx, ny, nz': 1e+30,
                                      'output_format': 1e+30,
                                      'radius': 1e+30,
                                      'weight(i), i=1,nfile': 1e+30,
                                      'x0(i), i=1,3': 1e+30}},
                      'PROJWFC': {'PROJWFC': {'DeltaE': 1e+30,
                                              'Emin, Emax': 1e+30,
                                              'degauss': 0.0,
                                              'filpdos': '(valueofprefixvariable)',
                                              'filproj': '(standardoutput)',
                                              'irmax(3,n_proj_boxes)': 1e+30,
                                              'irmin(3,n_proj_boxes)': 1e+30,
                                              'kresolveddos': False,
                                              'lbinary_data': False,
                                              'lsym': True,
                                              'lwrite_overlaps': False,
                                              'n_proj_boxes': 1,
                                              'ngauss': 0,
                                              'outdir': 'valueoftheESPRESSO_TMPDIRenvironmentvariableifset;\n'
                                              'currentdirectory(./)otherwise',
                                              'pawproj': False,
                                              'plotboxes': False,
                                              'prefix': 'pwscf',
                                              'tdosinboxes': False}},
                      'PW': {'CELL': {'cell_dofree': 'all',
                                      'cell_dynamics': '',
                                      'cell_factor': 1e+30,
                                      'press': 0.0,
                                      'press_conv_thr': 1e+30,
                                      'wmass': 1e+30},
                             'CONTROL': {'calculation': 'scf',
                                         'dipfield': False,
                                         'disk_io': 'seebelow',
                                         'dt': 20.0,
                                         'etot_conv_thr': 0.0001,
                                         'forc_conv_thr': 0.001,
                                         'gate': True,
                                         'gdir': 1e+30,
                                         'iprint': 1e+30,
                                         'lberry': False,
                                         'lelfield': False,
                                         'lfcpopt': True,
                                         'lkpoint_dir': True,
                                         'lorbm': False,
                                         'max_seconds': 1e+30,
                                         'nberrycyc': 1,
                                         'nppstr': 1e+30,
                                         'nstep': 1e+30,
                                         'outdir': 'valueoftheESPRESSO_TMPDIRenvironmentvariableifset;\n'
                                         'currentdirectory(./)otherwise',
                                         'prefix': 'pwscf',
                                         'pseudo_dir': 'valueofthe$ESPRESSO_PSEUDOenvironmentvariableifset;\n'
                                         '$HOME/espresso/pseudo/otherwise',
                                         'restart_mode': 'from_scratch',
                                         'tefield': False,
                                         'title': '',
                                         'tprnfor': True,
                                         'tstress': False,
                                         'verbosity': 'low',
                                         'wf_collect': True,
                                         'wfcdir': 'sameasoutdir'},
                             'ELECTRONS': {'adaptive_thr': False,
                                           'conv_thr': 1e-06,
                                           'conv_thr_init': 0.001,
                                           'conv_thr_multi': 0.1,
                                           'diago_cg_maxiter': 1e+30,
                                           'diago_david_ndim': 2,
                                           'diago_full_acc': False,
                                           'diago_thr_init': 1e+30,
                                           'diagonalization': 'david',
                                           'efield': 0.0,
                                           'efield_cart(i), i=1,3': 1e+30,
                                           'efield_phase': 'none',
                                           'electron_maxstep': 100,
                                           'mixing_beta': 0.7,
                                           'mixing_fixed_ns': 0,
                                           'mixing_mode': 'plain',
                                           'mixing_ndim': 8,
                                           'real_space': False,
                                           'scf_must_converge': True,
                                           'startingpot': '',
                                           'startingwfc': 'atomic+random',
                                           'tqr': False},
                             'IONS': {'bfgs_ndim': 1,
                                      'delta_t': 1.0,
                                      'ion_dynamics': '',
                                      'ion_positions': 'default',
                                      'ion_temperature': 'not_controlled',
                                      'ion_velocities': 'default',
                                      'nraise': 1,
                                      'pot_extrapolation': 'atomic',
                                      'refold_pos': False,
                                      'remove_rigid_rot': False,
                                      'tempw': 300.0,
                                      'tolp': 100.0,
                                      'trust_radius_ini': 0.5,
                                      'trust_radius_max': 0.8,
                                      'trust_radius_min': 0.001,
                                      'upscale': 100.0,
                                      'w_1': 0.01,
                                      'w_2': 0.5,
                                      'wfc_extrapolation': 'none'},
                             'SYSTEM': {'A, B, C, cosAB, cosAC, cosBC': 1e+30,
                                        'Hubbard_J(i,ityp), (i,ityp) = (1,1) ... (3,ntyp)': 1e+30,
                                        'Hubbard_J0(i), i=1,ntype': 1e+30,
                                        'Hubbard_U(i), i=1,ntyp': 1e+30,
                                        'Hubbard_V(na,nb,k), (na,nb,k) = (1,1,1) ... (natx,27*natx,4)': 1e+30,
                                        'Hubbard_alpha(i), i=1,ntyp': 1e+30,
                                        'Hubbard_beta(i), i=1,ntyp': 1e+30,
                                        'Hubbard_parameters': 'input',
                                        'U_projection_type': 'atomic',
                                        'ace': True,
                                        'angle1(i), i=1,ntyp': 1e+30,
                                        'angle2(i), i=1,ntyp': 1e+30,
                                        'assume_isolated': 'none',
                                        'block': False,
                                        'block_1': 0.45,
                                        'block_2': 0.55,
                                        'block_height': 0.1,
                                        'celldm(i), i=1,6': 1e+30,
                                        'constrained_magnetization': '',
                                        'degauss': 1e+30,
                                        'dftd3_threebody': True,
                                        'dftd3_version': 3,
                                        'eamp': 1e+30,
                                        'ecfixed': 0.0,
                                        'ecutfock': 1e+30,
                                        'ecutrho': 1e+30,
                                        'ecutvcut': 1e+30,
                                        'ecutwfc': 1e+30,
                                        'edir': 1e+30,
                                        'emaxpos': 0.5,
                                        'ensemble_energies': False,
                                        'eopreg': 0.1,
                                        'esm_bc': '',
                                        'esm_efield': 1e+30,
                                        'esm_nfit': 1e+30,
                                        'esm_w': 1e+30,
                                        'exx_fraction': 1e+30,
                                        'exxdiv_treatment': 'gygi-baldereschi',
                                        'fcp_mu': 1e+30,
                                        'fixed_magnetization(i), i=1,3': 1e+30,
                                        'force_symmorphic': False,
                                        'ibrav': 1e+30,
                                        'input_dft': 'readfrompseudopotentialfiles',
                                        'lambda': 1e+30,
                                        'lda_plus_u': True,
                                        'lda_plus_u_kind': 0,
                                        'lforcet': True,
                                        'localization_thr': 0.0,
                                        'london': False,
                                        'london_c6(i), i=1,ntyp': 1e+30,
                                        'london_rcut': 200.0,
                                        'london_rvdw(i), i=1,ntyp': 1e+30,
                                        'london_s6': 0.75,
                                        'lspinorb': True,
                                        'nat': 1e+30,
                                        'nbnd': 1e+30,
                                        'no_t_rev': False,
                                        'noinv': False,
                                        'noncolin': False,
                                        'nosym': False,
                                        'nosym_evc': False,
                                        'nqx1, nqx2, nqx3': 1e+30,
                                        'nr1, nr2, nr3': 1e+30,
                                        'nr1s, nr2s, nr3s': 1e+30,
                                        'nspin': 1,
                                        'ntyp': 1e+30,
                                        'occupations': '',
                                        'one_atom_occupations': False,
                                        'origin_choice': 1,
                                        'q2sigma': 0.1,
                                        'qcutz': 0.0,
                                        'relaxz': False,
                                        'report': -1,
                                        'rhombohedral': True,
                                        'screening_parameter': 0.106,
                                        'smearing': 'gaussian',
                                        'space_group': 0,
                                        'starting_charge(i), i=1,ntyp': 0.0,
                                        'starting_magnetization(i), i=1,ntyp': 1e+30,
                                        'starting_ns_eigenvalue(m,ispin,ityp), (m,ispin,ityp) = (1,1,1) ... (2*lmax+1,nspin or npol,ntyp)': 1e+30,
                                        'starting_spin_angle': False,
                                        'tot_charge': 0.0,
                                        'tot_magnetization': 1e+30,
                                        'ts_vdw_econv_thr': 1e-06,
                                        'ts_vdw_isolated': False,
                                        'uniqueb': False,
                                        'use_all_frac': False,
                                        'vdw_corr': '',
                                        'x_gamma_extrapolation': True,
                                        'xdm': False,
                                        'xdm_a1': 0.6836,
                                        'xdm_a2': 1.5045,
                                        'zgate': 0.5},
                             'ATOMIC_FORCES': {'X': '', 'fx, fy, fz': 1e+30},
                             'ATOMIC_POSITIONS': {"Card's options:": '(DEPRECATED)alat',
                                                  'X': '',
                                                  'if_pos(1), if_pos(2), if_pos(3)': 1,
                                                  'x, y, z': 1e+30},
                             'ATOMIC_SPECIES': {'Mass_X': 1e+30, 'PseudoPot_X': '', 'X': ''},
                             'ATOMIC_VELOCITIES': {'V': '', 'vx, vy, vz': 1e+30},
                             'CELL_PARAMETERS': {"Card's options:": '', 'v1, v2, v3': 1e+30},
                             'CONSTRAINTS': {'constr(1), constr(2), constr(3), constr(4)': '',
                                             'constr_target': 1e+30,
                                             'constr_tol': 1e+30,
                                             'constr_type': '',
                                             'nconstr': 1e+30},
                             'K_POINTS': {"Card's options:": 'tbipa',
                                          'nk1, nk2, nk3': 1e+30,
                                          'nks': 1e+30,
                                          'sk1, sk2, sk3': 1e+30,
                                          'xk_x, xk_y, xk_z, wk': 1e+30},
                             'OCCUPATIONS': {'f_inp1': 1e+30, 'f_inp2': 1e+30}}}
