"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSipRule = exports.TriggerType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const customResource_1 = require("./customResource");
const sipRuleValidator_1 = require("./sipRuleValidator");
var TriggerType;
(function (TriggerType) {
    TriggerType["TO_PHONE_NUMBER"] = "ToPhoneNumber";
    TriggerType["REQUEST_URI_HOSTNAME"] = "RequestUriHostname";
})(TriggerType = exports.TriggerType || (exports.TriggerType = {}));
class ChimeSipRule extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, triggerType, triggerValue, targetApplications } = props;
        sipRuleValidator_1.sipRuleValidator(props);
        const sipRuleRequest = new customResource_1.ChimeResources(this, 'sipRuleRequest', {
            resourceType: 'SMARule',
            uid: uid,
            properties: {
                name: name !== null && name !== void 0 ? name : uid,
                triggerType: triggerType,
                triggerValue: triggerValue,
                targetApplications: targetApplications,
            },
        });
        this.sipRuleId =
            sipRuleRequest.chimeCustomResource.getAttString('sipRuleId');
    }
}
exports.ChimeSipRule = ChimeSipRule;
_a = JSII_RTTI_SYMBOL_1;
ChimeSipRule[_a] = { fqn: "cdk-amazon-chime-resources.ChimeSipRule", version: "0.0.73" };
//# sourceMappingURL=data:application/json;base64,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