# mypy-boto3-dynamodb

[![PyPI - mypy-boto3-dynamodb](https://img.shields.io/pypi/v/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.DynamoDB 1.14.5](https://boto3.amazonaws.com/v1/documentation/api/1.14.5/reference/services/dynamodb.html#DynamoDB) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `DynamoDB` service.

```bash
python -m pip install boto3-stubs[dynamodb]
```

## How to use

### Client annotations

`DynamoDBClient` provides annotations for `boto3.client("dynamodb")`.

```python
import boto3

from mypy_boto3_dynamodb import DynamoDBClient, DynamoDBServiceResource
from mypy_boto3_dynamodb.paginator import (
    ListBackupsPaginator,
    ListTablesPaginator,
    ListTagsOfResourcePaginator,
    QueryPaginator,
    ScanPaginator,
)
from mypy_boto3_dynamodb.service_resource import ServiceResourceTablesCollection, Table
from mypy_boto3_dynamodb.type_defs import ArchivalSummaryTypeDef, ...
from mypy_boto3_dynamodb.waiter import TableExistsWaiter, TableNotExistsWaiter

client: DynamoDBClient = boto3.client("dynamodb")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DynamoDBClient = session.client("dynamodb")
```

### Paginators annotations

`mypy_boto3_dynamodb.paginator` module contains type annotations for all paginators.

```python

client: DynamoDBClient = boto3.client("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_backups_paginator: ListBackupsPaginator = client.get_paginator("list_backups")
list_tables_paginator: ListTablesPaginator = client.get_paginator("list_tables")
list_tags_of_resource_paginator: ListTagsOfResourcePaginator = client.get_paginator("list_tags_of_resource")
query_paginator: QueryPaginator = client.get_paginator("query")
scan_paginator: ScanPaginator = client.get_paginator("scan")
```


### Waiters annotations

`mypy_boto3_dynamodb.waiter` module contains type annotations for all waiters.

```python

client: DynamoDBClient = boto3.client("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
table_exists_waiter: TableExistsWaiter = client.get_waiter("table_exists")
table_not_exists_waiter: TableNotExistsWaiter = client.get_waiter("table_not_exists")
```


### Service Resource annotations

`DynamoDBServiceResource` provides annotations for `boto3.resource("dynamodb")`.

```python

resource: DynamoDBServiceResource = boto3.resource("dynamodb")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: DynamoDBServiceResource = session.resource("dynamodb")
```


### Other resources annotations

`mypy_boto3_dynamodb.service_resource` module contains type annotations for all resources.

```python

resource: DynamoDBServiceResource = boto3.resource("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_table: Table = resource.Table(...)
```



### Collections annotations

`mypy_boto3_dynamodb.service_resource` module contains type annotations
for all `DynamoDBServiceResource` collections.

```python

resource: DynamoDBServiceResource = boto3.resource("dynamodb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
tables: dynamodb_resources.ServiceResourceTablesCollection = resource.tables
```




### Typed dictionations

`mypy_boto3_dynamodb.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> ArchivalSummaryTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_dynamodb` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("dynamodb")
resource = boto3.resource("dynamodb")

session_client = boto3.Session().client("dynamodb")
session_resource = boto3.Session().resource("dynamodb")
```
