# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class BrandedCallList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the BrandedCallList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.preview.trusted_comms.branded_call.BrandedCallList
        :rtype: twilio.rest.preview.trusted_comms.branded_call.BrandedCallList
        """
        super(BrandedCallList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Business/BrandedCalls'.format(**self._solution)

    def create(self, from_, to, reason, call_sid=values.unset):
        """
        Create the BrandedCallInstance

        :param unicode from_: Twilio number from which to brand the call
        :param unicode to: The terminating Phone Number
        :param unicode reason: The business reason for this phone call
        :param unicode call_sid: The Call sid this Branded Call should link to

        :returns: The created BrandedCallInstance
        :rtype: twilio.rest.preview.trusted_comms.branded_call.BrandedCallInstance
        """
        data = values.of({'From': from_, 'To': to, 'Reason': reason, 'CallSid': call_sid, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return BrandedCallInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.BrandedCallList>'


class BrandedCallPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the BrandedCallPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.preview.trusted_comms.branded_call.BrandedCallPage
        :rtype: twilio.rest.preview.trusted_comms.branded_call.BrandedCallPage
        """
        super(BrandedCallPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of BrandedCallInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.trusted_comms.branded_call.BrandedCallInstance
        :rtype: twilio.rest.preview.trusted_comms.branded_call.BrandedCallInstance
        """
        return BrandedCallInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.BrandedCallPage>'


class BrandedCallInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the BrandedCallInstance

        :returns: twilio.rest.preview.trusted_comms.branded_call.BrandedCallInstance
        :rtype: twilio.rest.preview.trusted_comms.branded_call.BrandedCallInstance
        """
        super(BrandedCallInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'bg_color': payload.get('bg_color'),
            'brand_sid': payload.get('brand_sid'),
            'branded_channel_sid': payload.get('branded_channel_sid'),
            'business_sid': payload.get('business_sid'),
            'call_sid': payload.get('call_sid'),
            'caller': payload.get('caller'),
            'created_at': deserialize.iso8601_datetime(payload.get('created_at')),
            'font_color': payload.get('font_color'),
            'from_': payload.get('from'),
            'logo': payload.get('logo'),
            'phone_number_sid': payload.get('phone_number_sid'),
            'reason': payload.get('reason'),
            'sid': payload.get('sid'),
            'status': payload.get('status'),
            'to': payload.get('to'),
            'url': payload.get('url'),
            'use_case': payload.get('use_case'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def account_sid(self):
        """
        :returns: Account Sid.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def bg_color(self):
        """
        :returns: Background color of the current phone call
        :rtype: unicode
        """
        return self._properties['bg_color']

    @property
    def brand_sid(self):
        """
        :returns: Brand Sid.
        :rtype: unicode
        """
        return self._properties['brand_sid']

    @property
    def branded_channel_sid(self):
        """
        :returns: Branded Channel Sid.
        :rtype: unicode
        """
        return self._properties['branded_channel_sid']

    @property
    def business_sid(self):
        """
        :returns: Business Sid.
        :rtype: unicode
        """
        return self._properties['business_sid']

    @property
    def call_sid(self):
        """
        :returns: A string that uniquely identifies this phone call.
        :rtype: unicode
        """
        return self._properties['call_sid']

    @property
    def caller(self):
        """
        :returns: Caller name of the current phone call
        :rtype: unicode
        """
        return self._properties['caller']

    @property
    def created_at(self):
        """
        :returns: The date this current phone call was created
        :rtype: datetime
        """
        return self._properties['created_at']

    @property
    def font_color(self):
        """
        :returns: Font color of the current phone call
        :rtype: unicode
        """
        return self._properties['font_color']

    @property
    def from_(self):
        """
        :returns: The originating phone number
        :rtype: unicode
        """
        return self._properties['from_']

    @property
    def logo(self):
        """
        :returns: Logo URL of the caller
        :rtype: unicode
        """
        return self._properties['logo']

    @property
    def phone_number_sid(self):
        """
        :returns: Phone Number Sid.
        :rtype: unicode
        """
        return self._properties['phone_number_sid']

    @property
    def reason(self):
        """
        :returns: The business reason for this current phone call
        :rtype: unicode
        """
        return self._properties['reason']

    @property
    def sid(self):
        """
        :returns: A string that uniquely identifies this current branded phone call.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def status(self):
        """
        :returns: The status of the current phone call
        :rtype: unicode
        """
        return self._properties['status']

    @property
    def to(self):
        """
        :returns: The terminating phone number
        :rtype: unicode
        """
        return self._properties['to']

    @property
    def url(self):
        """
        :returns: The URL of this resource.
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def use_case(self):
        """
        :returns: The use case for the current phone call
        :rtype: unicode
        """
        return self._properties['use_case']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.BrandedCallInstance>'
