# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class RecordingList(ListResource):

    def __init__(self, version, trunk_sid):
        """
        Initialize the RecordingList

        :param Version version: Version that contains the resource
        :param trunk_sid: The trunk_sid

        :returns: twilio.rest.trunking.v1.trunk.recording.RecordingList
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingList
        """
        super(RecordingList, self).__init__(version)

        # Path Solution
        self._solution = {'trunk_sid': trunk_sid, }

    def get(self):
        """
        Constructs a RecordingContext

        :returns: twilio.rest.trunking.v1.trunk.recording.RecordingContext
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingContext
        """
        return RecordingContext(self._version, trunk_sid=self._solution['trunk_sid'], )

    def __call__(self):
        """
        Constructs a RecordingContext

        :returns: twilio.rest.trunking.v1.trunk.recording.RecordingContext
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingContext
        """
        return RecordingContext(self._version, trunk_sid=self._solution['trunk_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Trunking.V1.RecordingList>'


class RecordingPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the RecordingPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param trunk_sid: The trunk_sid

        :returns: twilio.rest.trunking.v1.trunk.recording.RecordingPage
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingPage
        """
        super(RecordingPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of RecordingInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.trunking.v1.trunk.recording.RecordingInstance
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingInstance
        """
        return RecordingInstance(self._version, payload, trunk_sid=self._solution['trunk_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Trunking.V1.RecordingPage>'


class RecordingContext(InstanceContext):

    def __init__(self, version, trunk_sid):
        """
        Initialize the RecordingContext

        :param Version version: Version that contains the resource
        :param trunk_sid: The SID of the Trunk from which to fetch the recording settings.

        :returns: twilio.rest.trunking.v1.trunk.recording.RecordingContext
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingContext
        """
        super(RecordingContext, self).__init__(version)

        # Path Solution
        self._solution = {'trunk_sid': trunk_sid, }
        self._uri = '/Trunks/{trunk_sid}/Recording'.format(**self._solution)

    def fetch(self):
        """
        Fetch the RecordingInstance

        :returns: The fetched RecordingInstance
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return RecordingInstance(self._version, payload, trunk_sid=self._solution['trunk_sid'], )

    def update(self):
        """
        Update the RecordingInstance

        :returns: The updated RecordingInstance
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingInstance
        """
        payload = self._version.update(method='POST', uri=self._uri, )

        return RecordingInstance(self._version, payload, trunk_sid=self._solution['trunk_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Trunking.V1.RecordingContext {}>'.format(context)


class RecordingInstance(InstanceResource):

    class RecordingMode(object):
        DO_NOT_RECORD = "do-not-record"
        RECORD_FROM_RINGING = "record-from-ringing"
        RECORD_FROM_ANSWER = "record-from-answer"
        RECORD_FROM_RINGING_DUAL = "record-from-ringing-dual"
        RECORD_FROM_ANSWER_DUAL = "record-from-answer-dual"

    class RecordingTrim(object):
        TRIM_SILENCE = "trim-silence"
        DO_NOT_TRIM = "do-not-trim"

    def __init__(self, version, payload, trunk_sid):
        """
        Initialize the RecordingInstance

        :returns: twilio.rest.trunking.v1.trunk.recording.RecordingInstance
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingInstance
        """
        super(RecordingInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'mode': payload.get('mode'),
            'trim': payload.get('trim'),
            'url': payload.get('url'),
            'trunk_sid': payload.get('trunk_sid'),
        }

        # Context
        self._context = None
        self._solution = {'trunk_sid': trunk_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: RecordingContext for this RecordingInstance
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingContext
        """
        if self._context is None:
            self._context = RecordingContext(self._version, trunk_sid=self._solution['trunk_sid'], )
        return self._context

    @property
    def mode(self):
        """
        :returns: The recording mode for the trunk.
        :rtype: RecordingInstance.RecordingMode
        """
        return self._properties['mode']

    @property
    def trim(self):
        """
        :returns: The recording trim setting for the trunk.
        :rtype: RecordingInstance.RecordingTrim
        """
        return self._properties['trim']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def trunk_sid(self):
        """
        :returns: The trunk_sid
        :rtype: unicode
        """
        return self._properties['trunk_sid']

    def fetch(self):
        """
        Fetch the RecordingInstance

        :returns: The fetched RecordingInstance
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingInstance
        """
        return self._proxy.fetch()

    def update(self):
        """
        Update the RecordingInstance

        :returns: The updated RecordingInstance
        :rtype: twilio.rest.trunking.v1.trunk.recording.RecordingInstance
        """
        return self._proxy.update()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Trunking.V1.RecordingInstance {}>'.format(context)
