"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpOrigin = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudfront = require("@aws-cdk/aws-cloudfront");
/**
 * An Origin for an HTTP server or S3 bucket configured for website hosting.
 *
 * @stability stable
 */
class HttpOrigin extends cloudfront.OriginBase {
    /**
     * @stability stable
     */
    constructor(domainName, props = {}) {
        super(domainName, props);
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_origins_HttpOriginProps(props);
        validateSecondsInRangeOrUndefined('readTimeout', 1, 180, props.readTimeout);
        validateSecondsInRangeOrUndefined('keepaliveTimeout', 1, 60, props.keepaliveTimeout);
    }
    /**
     * @stability stable
     */
    renderCustomOriginConfig() {
        var _b, _c, _d, _e;
        return {
            originSslProtocols: (_b = this.props.originSslProtocols) !== null && _b !== void 0 ? _b : [cloudfront.OriginSslPolicy.TLS_V1_2],
            originProtocolPolicy: (_c = this.props.protocolPolicy) !== null && _c !== void 0 ? _c : cloudfront.OriginProtocolPolicy.HTTPS_ONLY,
            httpPort: this.props.httpPort,
            httpsPort: this.props.httpsPort,
            originReadTimeout: (_d = this.props.readTimeout) === null || _d === void 0 ? void 0 : _d.toSeconds(),
            originKeepaliveTimeout: (_e = this.props.keepaliveTimeout) === null || _e === void 0 ? void 0 : _e.toSeconds(),
        };
    }
}
exports.HttpOrigin = HttpOrigin;
_a = JSII_RTTI_SYMBOL_1;
HttpOrigin[_a] = { fqn: "@aws-cdk/aws-cloudfront-origins.HttpOrigin", version: "1.143.0" };
/**
 * Throws an error if a duration is defined and not an integer number of seconds within a range.
 */
function validateSecondsInRangeOrUndefined(name, min, max, duration) {
    if (duration === undefined) {
        return;
    }
    const value = duration.toSeconds();
    if (!Number.isInteger(value) || value < min || value > max) {
        throw new Error(`${name}: Must be an int between ${min} and ${max} seconds (inclusive); received ${value}.`);
    }
}
//# sourceMappingURL=data:application/json;base64,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