# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/54_tens.ipynb.

# %% auto 0
__all__ = ['dtype', 'DType', 'datatype', 'DataType', 'Tensor', 'Device', 'Layer', 'Module', 'Dataset', 'DataLoader', 'DataModule']

# %% ../nbs/54_tens.ipynb 6
import inspect
from numbers import Number

# %% ../nbs/54_tens.ipynb 8
import types
from typing import (
    Type, TypeAlias, Tuple,
    ClassVar, Any, Optional, Callable, Iterable, ForwardRef
)
from typing import TypeAlias, List, Union, Iterable, List

# %% ../nbs/54_tens.ipynb 11
try:
    import torch
    torchtype = torch.dtype
    tensor = torch.Tensor
    device = torch.device
    module = torch.nn.Module
except ImportError:
    # Define a placeholder type if torch is not installed
    tensor = 'torch.Tensor'
    device = 'torch.device'
    torchtype = 'torch.dtype'
    module = 'torch.nn.Module'

# %% ../nbs/54_tens.ipynb 12
try:
    from torch.utils.data import (
        Dataset as dataset, 
        DataLoader as dataloader
    )    
except ImportError:
    tudata = 'torch.utils.data'
    dataset = ForwardRef(f'{tudata}.Dataset', module=tudata, is_class=True)
    dataloader = ForwardRef(f'{tudata}.DataLoader', module=tudata, is_class=True)

# %% ../nbs/54_tens.ipynb 13
try:
    from pytorch_lightning import (LightningDataModule as pldm)
except ImportError:
    pl = 'pytorch_lightning'
    pldm = ForwardRef(f'{pl}.LightningDataModule', module='pytorch_lightning', is_class=True)

# %% ../nbs/54_tens.ipynb 16
#| export


# %% ../nbs/54_tens.ipynb 18
from .nums import Numbers

# %% ../nbs/54_tens.ipynb 21
dtype: TypeAlias = torchtype
DType: TypeAlias = dtype
datatype: TypeAlias = dtype
DataType: TypeAlias = dtype

# %% ../nbs/54_tens.ipynb 22
Tensor: TypeAlias = tensor
Device: TypeAlias = device

# %% ../nbs/54_tens.ipynb 23
Layer: TypeAlias = module
Module: TypeAlias = Layer

# %% ../nbs/54_tens.ipynb 25
Dataset: TypeAlias = dataset
DataLoader: TypeAlias = dataloader

# %% ../nbs/54_tens.ipynb 26
DataModule: TypeAlias = pldm
