# qumranica
Python connector to the [qumranica](https://qumranica.org) [api](https://api.qumranica.org/swagger) (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 0.7.2
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install qumranica
```
(you may need to run `pip` with root permission: `sudo pip install qumranica`)

Then import the package:
```python
import qumranica
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import qumranica
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import qumranica
from qumranica.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = qumranica.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Bearer
configuration = qumranica.Configuration(
    host = "http://localhost",
    api_key = {
        'Authorization': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'


# Enter a context with an instance of the API client
with qumranica.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = qumranica.ArtefactApi(api_client)
    edition_id = 56 # int | Unique Id of the desired edition
artefact_group_id = 56 # int | Unique Id of the artefact group to be deleted

    try:
        # Deletes the specified artefact group.
        api_response = api_instance.v1_editions_edition_id_artefact_groups_artefact_group_id_delete(edition_id, artefact_group_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ArtefactApi->v1_editions_edition_id_artefact_groups_artefact_group_id_delete: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ArtefactApi* | [**v1_editions_edition_id_artefact_groups_artefact_group_id_delete**](docs/ArtefactApi.md#v1_editions_edition_id_artefact_groups_artefact_group_id_delete) | **DELETE** /v1/editions/{editionId}/artefact-groups/{artefactGroupId} | Deletes the specified artefact group.
*ArtefactApi* | [**v1_editions_edition_id_artefact_groups_artefact_group_id_get**](docs/ArtefactApi.md#v1_editions_edition_id_artefact_groups_artefact_group_id_get) | **GET** /v1/editions/{editionId}/artefact-groups/{artefactGroupId} | Gets the details of a specific artefact group in the edition
*ArtefactApi* | [**v1_editions_edition_id_artefact_groups_artefact_group_id_put**](docs/ArtefactApi.md#v1_editions_edition_id_artefact_groups_artefact_group_id_put) | **PUT** /v1/editions/{editionId}/artefact-groups/{artefactGroupId} | Updates the details of an artefact group.  The artefact group will now only contain the artefacts listed in the JSON payload.  If the name is null, no change will be made, otherwise the name will also be updated.
*ArtefactApi* | [**v1_editions_edition_id_artefact_groups_get**](docs/ArtefactApi.md#v1_editions_edition_id_artefact_groups_get) | **GET** /v1/editions/{editionId}/artefact-groups | Gets a listing of all artefact groups in the edition
*ArtefactApi* | [**v1_editions_edition_id_artefact_groups_post**](docs/ArtefactApi.md#v1_editions_edition_id_artefact_groups_post) | **POST** /v1/editions/{editionId}/artefact-groups | Creates a new artefact group with the submitted data.  The new artefact must have a list of artefacts that belong to the group.  It is not necessary to give the group a name.
*ArtefactApi* | [**v1_editions_edition_id_artefacts_artefact_id_delete**](docs/ArtefactApi.md#v1_editions_edition_id_artefacts_artefact_id_delete) | **DELETE** /v1/editions/{editionId}/artefacts/{artefactId} | Deletes the specified artefact
*ArtefactApi* | [**v1_editions_edition_id_artefacts_artefact_id_get**](docs/ArtefactApi.md#v1_editions_edition_id_artefacts_artefact_id_get) | **GET** /v1/editions/{editionId}/artefacts/{artefactId} | Provides a listing of all artefacts that are part of the specified edition
*ArtefactApi* | [**v1_editions_edition_id_artefacts_artefact_id_put**](docs/ArtefactApi.md#v1_editions_edition_id_artefacts_artefact_id_put) | **PUT** /v1/editions/{editionId}/artefacts/{artefactId} | Updates the specified artefact.  There are many possible attributes that can be changed for  an artefact.  The caller should only input only those that  should be changed. Attributes with a null value will be ignored.  For instance, setting the mask to null or \&quot;\&quot; will result in  no changes to the current mask, and no value for the mask will  be returned (or broadcast). Likewise, the transformation, name,  or status message may be set to null and no change will be made  to those entities (though any unchanged values will be returned  along with the changed values and also broadcast to co-editors).
*ArtefactApi* | [**v1_editions_edition_id_artefacts_artefact_id_rois_get**](docs/ArtefactApi.md#v1_editions_edition_id_artefacts_artefact_id_rois_get) | **GET** /v1/editions/{editionId}/artefacts/{artefactId}/rois | Provides a listing of all rois belonging to an artefact in the specified edition
*ArtefactApi* | [**v1_editions_edition_id_artefacts_artefact_id_text_fragments_get**](docs/ArtefactApi.md#v1_editions_edition_id_artefacts_artefact_id_text_fragments_get) | **GET** /v1/editions/{editionId}/artefacts/{artefactId}/text-fragments | Provides a listing of text fragments that have text in the specified artefact.  With the optional query parameter \&quot;suggested\&quot;, this endpoint will also return  any text fragment that the system suggests might have text in the artefact.
*ArtefactApi* | [**v1_editions_edition_id_artefacts_batch_transformation_post**](docs/ArtefactApi.md#v1_editions_edition_id_artefacts_batch_transformation_post) | **POST** /v1/editions/{editionId}/artefacts/batch-transformation | Updates the positional data for a batch of artefacts
*ArtefactApi* | [**v1_editions_edition_id_artefacts_get**](docs/ArtefactApi.md#v1_editions_edition_id_artefacts_get) | **GET** /v1/editions/{editionId}/artefacts | Provides a listing of all artefacts that are part of the specified edition
*ArtefactApi* | [**v1_editions_edition_id_artefacts_post**](docs/ArtefactApi.md#v1_editions_edition_id_artefacts_post) | **POST** /v1/editions/{editionId}/artefacts | Creates a new artefact with the provided data.  If no mask is provided, a placeholder mask will be created with the values:  \&quot;POLYGON((0 0,1 1,1 0,0 0))\&quot; (the system requires a valid WKT polygon mask for  every artefact). It is not recommended to leave the mask, name, or work status  blank or null. It will often be advantageous to leave the transformation null  when first creating a new artefact.
*CatalogueApi* | [**v1_catalogue_confirm_match_iaa_edition_catalog_to_text_fragment_id_delete**](docs/CatalogueApi.md#v1_catalogue_confirm_match_iaa_edition_catalog_to_text_fragment_id_delete) | **DELETE** /v1/catalogue/confirm-match/{iaaEditionCatalogToTextFragmentId} | Remove an existing imaged object and text fragment match, which is not correct
*CatalogueApi* | [**v1_catalogue_confirm_match_iaa_edition_catalog_to_text_fragment_id_post**](docs/CatalogueApi.md#v1_catalogue_confirm_match_iaa_edition_catalog_to_text_fragment_id_post) | **POST** /v1/catalogue/confirm-match/{iaaEditionCatalogToTextFragmentId} | Confirm the correctness of an existing imaged object and text fragment match
*CatalogueApi* | [**v1_catalogue_editions_edition_id_imaged_object_text_fragment_matches_get**](docs/CatalogueApi.md#v1_catalogue_editions_edition_id_imaged_object_text_fragment_matches_get) | **GET** /v1/catalogue/editions/{editionId}/imaged-object-text-fragment-matches | Get a listing of all corresponding imaged objects and transcribed text fragment in a specified edition
*CatalogueApi* | [**v1_catalogue_imaged_objects_imaged_object_id_text_fragments_get**](docs/CatalogueApi.md#v1_catalogue_imaged_objects_imaged_object_id_text_fragments_get) | **GET** /v1/catalogue/imaged-objects/{imagedObjectId}/text-fragments | Get a listing of all text fragments matches that correspond to an imaged object
*CatalogueApi* | [**v1_catalogue_manuscripts_manuscript_id_imaged_object_text_fragment_matches_get**](docs/CatalogueApi.md#v1_catalogue_manuscripts_manuscript_id_imaged_object_text_fragment_matches_get) | **GET** /v1/catalogue/manuscripts/{manuscriptId}/imaged-object-text-fragment-matches | Get a listing of all corresponding imaged objects and transcribed text fragment in a specified manuscript
*CatalogueApi* | [**v1_catalogue_post**](docs/CatalogueApi.md#v1_catalogue_post) | **POST** /v1/catalogue | Create a new matched pair for an imaged object and a text fragment along with the edition princeps information
*CatalogueApi* | [**v1_catalogue_text_fragments_text_fragment_id_imaged_objects_get**](docs/CatalogueApi.md#v1_catalogue_text_fragments_text_fragment_id_imaged_objects_get) | **GET** /v1/catalogue/text-fragments/{textFragmentId}/imaged-objects | Get a listing of all imaged objects that matches that correspond to a transcribed text fragment
*EditionApi* | [**v1_editions_admin_share_requests_get**](docs/EditionApi.md#v1_editions_admin_share_requests_get) | **GET** /v1/editions/admin-share-requests | Get a list of requests issued by the current user for other users  to become editors of a shared edition
*EditionApi* | [**v1_editions_confirm_editorship_token_post**](docs/EditionApi.md#v1_editions_confirm_editorship_token_post) | **POST** /v1/editions/confirm-editorship/{token} | Confirm addition of an editor to the specified edition
*EditionApi* | [**v1_editions_edition_id_add_editor_request_post**](docs/EditionApi.md#v1_editions_edition_id_add_editor_request_post) | **POST** /v1/editions/{editionId}/add-editor-request | Adds an editor to the specified edition
*EditionApi* | [**v1_editions_edition_id_delete**](docs/EditionApi.md#v1_editions_edition_id_delete) | **DELETE** /v1/editions/{editionId} | Provides details about the specified edition and all accessible alternate editions
*EditionApi* | [**v1_editions_edition_id_editors_editor_email_id_put**](docs/EditionApi.md#v1_editions_edition_id_editors_editor_email_id_put) | **PUT** /v1/editions/{editionId}/editors/{editorEmailId} | Changes the rights for an editor of the specified edition
*EditionApi* | [**v1_editions_edition_id_get**](docs/EditionApi.md#v1_editions_edition_id_get) | **GET** /v1/editions/{editionId} | Provides details about the specified edition and all accessible alternate editions
*EditionApi* | [**v1_editions_edition_id_post**](docs/EditionApi.md#v1_editions_edition_id_post) | **POST** /v1/editions/{editionId} | Creates a copy of the specified edition
*EditionApi* | [**v1_editions_edition_id_put**](docs/EditionApi.md#v1_editions_edition_id_put) | **PUT** /v1/editions/{editionId} | Updates data for the specified edition
*EditionApi* | [**v1_editions_edition_id_script_collection_get**](docs/EditionApi.md#v1_editions_edition_id_script_collection_get) | **GET** /v1/editions/{editionId}/script-collection | Provides spatial data for all letters in the edition
*EditionApi* | [**v1_editions_edition_id_script_lines_get**](docs/EditionApi.md#v1_editions_edition_id_script_lines_get) | **GET** /v1/editions/{editionId}/script-lines | Provides spatial data for all letters in the edition organized and oriented  by lines.
*EditionApi* | [**v1_editions_editor_invitations_get**](docs/EditionApi.md#v1_editions_editor_invitations_get) | **GET** /v1/editions/editor-invitations | Get a list of invitations issued to the current user to become an editor of a shared edition
*EditionApi* | [**v1_editions_get**](docs/EditionApi.md#v1_editions_get) | **GET** /v1/editions | Provides a listing of all editions accessible to the current user
*ImagedObjectApi* | [**v1_editions_edition_id_imaged_objects_get**](docs/ImagedObjectApi.md#v1_editions_edition_id_imaged_objects_get) | **GET** /v1/editions/{editionId}/imaged-objects | Provides a listing of imaged objects related to the specified edition, can include images and also their masks with  optional.
*ImagedObjectApi* | [**v1_editions_edition_id_imaged_objects_imaged_object_id_get**](docs/ImagedObjectApi.md#v1_editions_edition_id_imaged_objects_imaged_object_id_get) | **GET** /v1/editions/{editionId}/imaged-objects/{imagedObjectId} | Provides information for the specified imaged object related to the specified edition, can include images and also  their masks with optional.
*ImagedObjectApi* | [**v1_imaged_objects_imaged_object_id_get**](docs/ImagedObjectApi.md#v1_imaged_objects_imaged_object_id_get) | **GET** /v1/imaged-objects/{imagedObjectId} | Provides information for the specified imaged object.
*ImagedObjectApi* | [**v1_imaged_objects_imaged_object_id_text_fragments_get**](docs/ImagedObjectApi.md#v1_imaged_objects_imaged_object_id_text_fragments_get) | **GET** /v1/imaged-objects/{imagedObjectId}/text-fragments | Provides a list of all text fragments that should correspond to the imaged object.
*ImagedObjectApi* | [**v1_imaged_objects_institutions_get**](docs/ImagedObjectApi.md#v1_imaged_objects_institutions_get) | **GET** /v1/imaged-objects/institutions | Provides a list of all institutional image providers.
*ImagedObjectApi* | [**v1_imaged_objects_institutions_institution_name_get**](docs/ImagedObjectApi.md#v1_imaged_objects_institutions_institution_name_get) | **GET** /v1/imaged-objects/institutions/{institutionName} | Provides a list of all institutional image providers.
*RoiApi* | [**v1_editions_edition_id_rois_batch_edit_post**](docs/RoiApi.md#v1_editions_edition_id_rois_batch_edit_post) | **POST** /v1/editions/{editionId}/rois/batch-edit | Processes a series of create/update/delete ROI requests in the given edition of a scroll
*RoiApi* | [**v1_editions_edition_id_rois_batch_post**](docs/RoiApi.md#v1_editions_edition_id_rois_batch_post) | **POST** /v1/editions/{editionId}/rois/batch | Creates new sign ROI&#39;s in the given edition of a scroll
*RoiApi* | [**v1_editions_edition_id_rois_batch_put**](docs/RoiApi.md#v1_editions_edition_id_rois_batch_put) | **PUT** /v1/editions/{editionId}/rois/batch | Update existing sign ROI&#39;s in the given edition of a scroll
*RoiApi* | [**v1_editions_edition_id_rois_post**](docs/RoiApi.md#v1_editions_edition_id_rois_post) | **POST** /v1/editions/{editionId}/rois | Creates new sign ROI in the given edition of a scroll
*RoiApi* | [**v1_editions_edition_id_rois_roi_id_delete**](docs/RoiApi.md#v1_editions_edition_id_rois_roi_id_delete) | **DELETE** /v1/editions/{editionId}/rois/{roiId} | Deletes a sign ROI from the given edition of a scroll
*RoiApi* | [**v1_editions_edition_id_rois_roi_id_get**](docs/RoiApi.md#v1_editions_edition_id_rois_roi_id_get) | **GET** /v1/editions/{editionId}/rois/{roiId} | Get the details for a ROI in the given edition of a scroll
*RoiApi* | [**v1_editions_edition_id_rois_roi_id_put**](docs/RoiApi.md#v1_editions_edition_id_rois_roi_id_put) | **PUT** /v1/editions/{editionId}/rois/{roiId} | Update an existing sign ROI in the given edition of a scroll
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_attributes_attribute_id_delete**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_attributes_attribute_id_delete) | **DELETE** /v1/editions/{editionId}/sign-interpretations-attributes/{attributeId} | Delete an attribute from an edition
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_attributes_attribute_id_put**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_attributes_attribute_id_put) | **PUT** /v1/editions/{editionId}/sign-interpretations-attributes/{attributeId} | Change the details of an attribute in an edition
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_attributes_get**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_attributes_get) | **GET** /v1/editions/{editionId}/sign-interpretations-attributes | Retrieve a list of all possible attributes for an edition
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_attributes_post**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_attributes_post) | **POST** /v1/editions/{editionId}/sign-interpretations-attributes | Create a new attribute for an edition
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_post**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_post) | **POST** /v1/editions/{editionId}/sign-interpretations | Creates a new sign interpretation
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_delete**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_delete) | **DELETE** /v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/attributes/{attributeValueId} | This deletes the specified attribute value from the specified sign interpretation.
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_put**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_put) | **PUT** /v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/attributes/{attributeValueId} | This changes the values of the specified sign interpretation attribute,  mainly used to change commentary.
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_post**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_post) | **POST** /v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/attributes | This adds a new attribute to the specified sign interpretation.
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_sign_interpretation_id_commentary_put**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_sign_interpretation_id_commentary_put) | **PUT** /v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/commentary | Updates the commentary of a sign interpretation
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_sign_interpretation_id_delete**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_sign_interpretation_id_delete) | **DELETE** /v1/editions/{editionId}/sign-interpretations/{signInterpretationId} | Deletes the sign interpretation in the route. The endpoint automatically manages the sign stream  by connecting all the deleted sign&#39;s next and previous nodes.
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_sign_interpretation_id_get**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_sign_interpretation_id_get) | **GET** /v1/editions/{editionId}/sign-interpretations/{signInterpretationId} | Retrieve the details of a sign interpretation in an edition
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_sign_interpretation_id_link_to_next_sign_interpretation_id_post**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_sign_interpretation_id_link_to_next_sign_interpretation_id_post) | **POST** /v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/link-to/{nextSignInterpretationId} | Links two sign interpretations in the edition&#39;s sign stream
*SignInterpretationApi* | [**v1_editions_edition_id_sign_interpretations_sign_interpretation_id_unlink_from_next_sign_interpretation_id_post**](docs/SignInterpretationApi.md#v1_editions_edition_id_sign_interpretations_sign_interpretation_id_unlink_from_next_sign_interpretation_id_post) | **POST** /v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/unlink-from/{nextSignInterpretationId} | Links two sign interpretations in the edition&#39;s sign stream
*TextApi* | [**v1_editions_edition_id_lines_line_id_get**](docs/TextApi.md#v1_editions_edition_id_lines_line_id_get) | **GET** /v1/editions/{editionId}/lines/{lineId} | Retrieves all signs and their data from the given line
*TextApi* | [**v1_editions_edition_id_text_fragments_get**](docs/TextApi.md#v1_editions_edition_id_text_fragments_get) | **GET** /v1/editions/{editionId}/text-fragments | Retrieves the ids of all Fragments of all fragments in the given edition of a scroll
*TextApi* | [**v1_editions_edition_id_text_fragments_post**](docs/TextApi.md#v1_editions_edition_id_text_fragments_post) | **POST** /v1/editions/{editionId}/text-fragments | Creates a new text fragment in the given edition of a scroll
*TextApi* | [**v1_editions_edition_id_text_fragments_text_fragment_id_artefacts_get**](docs/TextApi.md#v1_editions_edition_id_text_fragments_text_fragment_id_artefacts_get) | **GET** /v1/editions/{editionId}/text-fragments/{textFragmentId}/artefacts | Retrieves the ids of all Artefacts in the given textFragmentName
*TextApi* | [**v1_editions_edition_id_text_fragments_text_fragment_id_get**](docs/TextApi.md#v1_editions_edition_id_text_fragments_text_fragment_id_get) | **GET** /v1/editions/{editionId}/text-fragments/{textFragmentId} | Retrieves all signs and their data from the given textFragmentName
*TextApi* | [**v1_editions_edition_id_text_fragments_text_fragment_id_lines_get**](docs/TextApi.md#v1_editions_edition_id_text_fragments_text_fragment_id_lines_get) | **GET** /v1/editions/{editionId}/text-fragments/{textFragmentId}/lines | Retrieves the ids of all lines in the given textFragmentName
*TextApi* | [**v1_editions_edition_id_text_fragments_text_fragment_id_put**](docs/TextApi.md#v1_editions_edition_id_text_fragments_text_fragment_id_put) | **PUT** /v1/editions/{editionId}/text-fragments/{textFragmentId} | Updates the specified text fragment with the submitted properties
*UserApi* | [**v1_users_change_forgotten_password_post**](docs/UserApi.md#v1_users_change_forgotten_password_post) | **POST** /v1/users/change-forgotten-password | Uses the secret token from /users/forgot-password to validate a reset of the user&#39;s password
*UserApi* | [**v1_users_change_password_post**](docs/UserApi.md#v1_users_change_password_post) | **POST** /v1/users/change-password | Changes the password for the currently logged in user
*UserApi* | [**v1_users_change_unactivated_email_post**](docs/UserApi.md#v1_users_change_unactivated_email_post) | **POST** /v1/users/change-unactivated-email | Allows a user who has not yet activated their account to change their email address. This will not work if the user  account associated with the email address has already been activated
*UserApi* | [**v1_users_confirm_registration_post**](docs/UserApi.md#v1_users_confirm_registration_post) | **POST** /v1/users/confirm-registration | Confirms registration of new user account.
*UserApi* | [**v1_users_forgot_password_post**](docs/UserApi.md#v1_users_forgot_password_post) | **POST** /v1/users/forgot-password | Sends a secret token to the user&#39;s email to allow password reset.
*UserApi* | [**v1_users_get**](docs/UserApi.md#v1_users_get) | **GET** /v1/users | Provides the user details for a user with valid JWT in the Authorize header
*UserApi* | [**v1_users_login_post**](docs/UserApi.md#v1_users_login_post) | **POST** /v1/users/login | Provides a JWT bearer token for valid email and password
*UserApi* | [**v1_users_post**](docs/UserApi.md#v1_users_post) | **POST** /v1/users | Creates a new user with the submitted data.
*UserApi* | [**v1_users_put**](docs/UserApi.md#v1_users_put) | **PUT** /v1/users | Updates a user&#39;s registration details.  Note that the if the email address has changed, the account will be set to  inactive until the account is activated with the secret token.
*UserApi* | [**v1_users_resend_activation_email_post**](docs/UserApi.md#v1_users_resend_activation_email_post) | **POST** /v1/users/resend-activation-email | Sends a new activation email for the user&#39;s account. This will not work if the user account associated with the  email address has already been activated.
*UtilApi* | [**v1_utils_repair_wkt_polygon_post**](docs/UtilApi.md#v1_utils_repair_wkt_polygon_post) | **POST** /v1/utils/repair-wkt-polygon | Checks a WKT polygon to ensure validity. If the polygon is invalid,  it attempts to construct a valid polygon that matches the original  as closely as possible.


## Documentation For Models

 - [AccountActivationRequestDTO](docs/AccountActivationRequestDTO.md)
 - [AdminEditorRequestDTO](docs/AdminEditorRequestDTO.md)
 - [AdminEditorRequestListDTO](docs/AdminEditorRequestListDTO.md)
 - [ArtefactDTO](docs/ArtefactDTO.md)
 - [ArtefactDataDTO](docs/ArtefactDataDTO.md)
 - [ArtefactDataListDTO](docs/ArtefactDataListDTO.md)
 - [ArtefactGroupDTO](docs/ArtefactGroupDTO.md)
 - [ArtefactGroupListDTO](docs/ArtefactGroupListDTO.md)
 - [ArtefactListDTO](docs/ArtefactListDTO.md)
 - [ArtefactTextFragmentMatchDTO](docs/ArtefactTextFragmentMatchDTO.md)
 - [ArtefactTextFragmentMatchListDTO](docs/ArtefactTextFragmentMatchListDTO.md)
 - [AttributeDTO](docs/AttributeDTO.md)
 - [AttributeListDTO](docs/AttributeListDTO.md)
 - [AttributeValueDTO](docs/AttributeValueDTO.md)
 - [BatchEditRoiDTO](docs/BatchEditRoiDTO.md)
 - [BatchEditRoiResponseDTO](docs/BatchEditRoiResponseDTO.md)
 - [BatchUpdateArtefactPlacementDTO](docs/BatchUpdateArtefactPlacementDTO.md)
 - [BatchUpdatedArtefactTransformDTO](docs/BatchUpdatedArtefactTransformDTO.md)
 - [CatalogueMatchDTO](docs/CatalogueMatchDTO.md)
 - [CatalogueMatchInputDTO](docs/CatalogueMatchInputDTO.md)
 - [CatalogueMatchListDTO](docs/CatalogueMatchListDTO.md)
 - [CharacterShapeDTO](docs/CharacterShapeDTO.md)
 - [CommentaryCreateDTO](docs/CommentaryCreateDTO.md)
 - [CommentaryDTO](docs/CommentaryDTO.md)
 - [CreateArtefactDTO](docs/CreateArtefactDTO.md)
 - [CreateArtefactGroupDTO](docs/CreateArtefactGroupDTO.md)
 - [CreateAttributeDTO](docs/CreateAttributeDTO.md)
 - [CreateAttributeValueDTO](docs/CreateAttributeValueDTO.md)
 - [CreateTextFragmentDTO](docs/CreateTextFragmentDTO.md)
 - [DeleteDTO](docs/DeleteDTO.md)
 - [DeleteTokenDTO](docs/DeleteTokenDTO.md)
 - [DetailedEditorRightsDTO](docs/DetailedEditorRightsDTO.md)
 - [DetailedUserDTO](docs/DetailedUserDTO.md)
 - [DetailedUserTokenDTO](docs/DetailedUserTokenDTO.md)
 - [Direction](docs/Direction.md)
 - [EditionCopyDTO](docs/EditionCopyDTO.md)
 - [EditionDTO](docs/EditionDTO.md)
 - [EditionEntities](docs/EditionEntities.md)
 - [EditionGroupDTO](docs/EditionGroupDTO.md)
 - [EditionListDTO](docs/EditionListDTO.md)
 - [EditionManuscriptMetricsDTO](docs/EditionManuscriptMetricsDTO.md)
 - [EditionScriptCollectionDTO](docs/EditionScriptCollectionDTO.md)
 - [EditionScriptLinesDTO](docs/EditionScriptLinesDTO.md)
 - [EditionUpdateRequestDTO](docs/EditionUpdateRequestDTO.md)
 - [EditorDTO](docs/EditorDTO.md)
 - [EditorInvitationDTO](docs/EditorInvitationDTO.md)
 - [EditorInvitationListDTO](docs/EditorInvitationListDTO.md)
 - [ImageDTO](docs/ImageDTO.md)
 - [ImageInstitutionDTO](docs/ImageInstitutionDTO.md)
 - [ImageInstitutionListDTO](docs/ImageInstitutionListDTO.md)
 - [ImageStackDTO](docs/ImageStackDTO.md)
 - [ImagedObjectDTO](docs/ImagedObjectDTO.md)
 - [ImagedObjectListDTO](docs/ImagedObjectListDTO.md)
 - [ImagedObjectTextFragmentMatchDTO](docs/ImagedObjectTextFragmentMatchDTO.md)
 - [ImagedObjectTextFragmentMatchListDTO](docs/ImagedObjectTextFragmentMatchListDTO.md)
 - [InstitutionalImageDTO](docs/InstitutionalImageDTO.md)
 - [InstitutionalImageListDTO](docs/InstitutionalImageListDTO.md)
 - [InterpretationAttributeCreateDTO](docs/InterpretationAttributeCreateDTO.md)
 - [InterpretationAttributeDTO](docs/InterpretationAttributeDTO.md)
 - [InterpretationRoiDTO](docs/InterpretationRoiDTO.md)
 - [InterpretationRoiDTOList](docs/InterpretationRoiDTOList.md)
 - [InviteEditorDTO](docs/InviteEditorDTO.md)
 - [Lighting](docs/Lighting.md)
 - [LineDTO](docs/LineDTO.md)
 - [LineDataDTO](docs/LineDataDTO.md)
 - [LineDataListDTO](docs/LineDataListDTO.md)
 - [LineTextDTO](docs/LineTextDTO.md)
 - [LoginRequestDTO](docs/LoginRequestDTO.md)
 - [NewUserRequestDTO](docs/NewUserRequestDTO.md)
 - [NextSignInterpretationDTO](docs/NextSignInterpretationDTO.md)
 - [PermissionDTO](docs/PermissionDTO.md)
 - [PlacementDTO](docs/PlacementDTO.md)
 - [ResendUserAccountActivationRequestDTO](docs/ResendUserAccountActivationRequestDTO.md)
 - [ResetForgottenUserPasswordRequestDTO](docs/ResetForgottenUserPasswordRequestDTO.md)
 - [ResetLoggedInUserPasswordRequestDTO](docs/ResetLoggedInUserPasswordRequestDTO.md)
 - [ResetUserPasswordRequestDTO](docs/ResetUserPasswordRequestDTO.md)
 - [ScriptArtefactCharactersDTO](docs/ScriptArtefactCharactersDTO.md)
 - [ScriptLineDTO](docs/ScriptLineDTO.md)
 - [ScriptTextFragmentDTO](docs/ScriptTextFragmentDTO.md)
 - [SetInterpretationRoiDTO](docs/SetInterpretationRoiDTO.md)
 - [SetInterpretationRoiDTOList](docs/SetInterpretationRoiDTOList.md)
 - [SideDesignation](docs/SideDesignation.md)
 - [SignDTO](docs/SignDTO.md)
 - [SignInterpretationCreateDTO](docs/SignInterpretationCreateDTO.md)
 - [SignInterpretationDTO](docs/SignInterpretationDTO.md)
 - [SignInterpretationListDTO](docs/SignInterpretationListDTO.md)
 - [SimpleImageDTO](docs/SimpleImageDTO.md)
 - [SimpleImageListDTO](docs/SimpleImageListDTO.md)
 - [TextEditionDTO](docs/TextEditionDTO.md)
 - [TextFragmentDTO](docs/TextFragmentDTO.md)
 - [TextFragmentDataDTO](docs/TextFragmentDataDTO.md)
 - [TextFragmentDataListDTO](docs/TextFragmentDataListDTO.md)
 - [TranslateDTO](docs/TranslateDTO.md)
 - [UnactivatedEmailUpdateRequestDTO](docs/UnactivatedEmailUpdateRequestDTO.md)
 - [UpdateArtefactDTO](docs/UpdateArtefactDTO.md)
 - [UpdateArtefactGroupDTO](docs/UpdateArtefactGroupDTO.md)
 - [UpdateArtefactPlacementDTO](docs/UpdateArtefactPlacementDTO.md)
 - [UpdateAttributeDTO](docs/UpdateAttributeDTO.md)
 - [UpdateAttributeValueDTO](docs/UpdateAttributeValueDTO.md)
 - [UpdateEditionManuscriptMetricsDTO](docs/UpdateEditionManuscriptMetricsDTO.md)
 - [UpdateEditorRightsDTO](docs/UpdateEditorRightsDTO.md)
 - [UpdateInterpretationRoiDTO](docs/UpdateInterpretationRoiDTO.md)
 - [UpdateInterpretationRoiDTOList](docs/UpdateInterpretationRoiDTOList.md)
 - [UpdateTextFragmentDTO](docs/UpdateTextFragmentDTO.md)
 - [UpdatedArtefactPlacementDTO](docs/UpdatedArtefactPlacementDTO.md)
 - [UpdatedInterpretationRoiDTO](docs/UpdatedInterpretationRoiDTO.md)
 - [UpdatedInterpretationRoiDTOList](docs/UpdatedInterpretationRoiDTOList.md)
 - [UserDTO](docs/UserDTO.md)
 - [UserUpdateRequestDTO](docs/UserUpdateRequestDTO.md)
 - [WktPolygonDTO](docs/WktPolygonDTO.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author




