# coding: utf-8

"""
    SQE API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from qumranica.api_client import ApiClient
from qumranica.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ArtefactApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def v1_editions_edition_id_artefact_groups_artefact_group_id_delete(self, edition_id, artefact_group_id, **kwargs):  # noqa: E501
        """Deletes the specified artefact group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefact_groups_artefact_group_id_delete(edition_id, artefact_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_group_id: Unique Id of the artefact group to be deleted (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeleteDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefact_groups_artefact_group_id_delete_with_http_info(edition_id, artefact_group_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefact_groups_artefact_group_id_delete_with_http_info(self, edition_id, artefact_group_id, **kwargs):  # noqa: E501
        """Deletes the specified artefact group.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefact_groups_artefact_group_id_delete_with_http_info(edition_id, artefact_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_group_id: Unique Id of the artefact group to be deleted (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeleteDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'artefact_group_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefact_groups_artefact_group_id_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefact_groups_artefact_group_id_delete`")  # noqa: E501
        # verify the required parameter 'artefact_group_id' is set
        if self.api_client.client_side_validation and ('artefact_group_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['artefact_group_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `artefact_group_id` when calling `v1_editions_edition_id_artefact_groups_artefact_group_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'artefact_group_id' in local_var_params:
            path_params['artefactGroupId'] = local_var_params['artefact_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefact-groups/{artefactGroupId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefact_groups_artefact_group_id_get(self, edition_id, artefact_group_id, **kwargs):  # noqa: E501
        """Gets the details of a specific artefact group in the edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefact_groups_artefact_group_id_get(edition_id, artefact_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_group_id: Id of the desired artefact group (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArtefactGroupDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefact_groups_artefact_group_id_get_with_http_info(edition_id, artefact_group_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefact_groups_artefact_group_id_get_with_http_info(self, edition_id, artefact_group_id, **kwargs):  # noqa: E501
        """Gets the details of a specific artefact group in the edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefact_groups_artefact_group_id_get_with_http_info(edition_id, artefact_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_group_id: Id of the desired artefact group (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArtefactGroupDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'artefact_group_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefact_groups_artefact_group_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefact_groups_artefact_group_id_get`")  # noqa: E501
        # verify the required parameter 'artefact_group_id' is set
        if self.api_client.client_side_validation and ('artefact_group_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['artefact_group_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `artefact_group_id` when calling `v1_editions_edition_id_artefact_groups_artefact_group_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'artefact_group_id' in local_var_params:
            path_params['artefactGroupId'] = local_var_params['artefact_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefact-groups/{artefactGroupId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtefactGroupDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefact_groups_artefact_group_id_put(self, edition_id, artefact_group_id, **kwargs):  # noqa: E501
        """Updates the details of an artefact group.  The artefact group will now only contain the artefacts listed in the JSON payload.  If the name is null, no change will be made, otherwise the name will also be updated.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefact_groups_artefact_group_id_put(edition_id, artefact_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_group_id: Id of the artefact group to be updated (required)
        :param UpdateArtefactGroupDTO update_artefact_group_dto: Parameters that the artefact group should be changed to
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArtefactGroupDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefact_groups_artefact_group_id_put_with_http_info(edition_id, artefact_group_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefact_groups_artefact_group_id_put_with_http_info(self, edition_id, artefact_group_id, **kwargs):  # noqa: E501
        """Updates the details of an artefact group.  The artefact group will now only contain the artefacts listed in the JSON payload.  If the name is null, no change will be made, otherwise the name will also be updated.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefact_groups_artefact_group_id_put_with_http_info(edition_id, artefact_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_group_id: Id of the artefact group to be updated (required)
        :param UpdateArtefactGroupDTO update_artefact_group_dto: Parameters that the artefact group should be changed to
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArtefactGroupDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'artefact_group_id',
            'update_artefact_group_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefact_groups_artefact_group_id_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefact_groups_artefact_group_id_put`")  # noqa: E501
        # verify the required parameter 'artefact_group_id' is set
        if self.api_client.client_side_validation and ('artefact_group_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['artefact_group_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `artefact_group_id` when calling `v1_editions_edition_id_artefact_groups_artefact_group_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'artefact_group_id' in local_var_params:
            path_params['artefactGroupId'] = local_var_params['artefact_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_artefact_group_dto' in local_var_params:
            body_params = local_var_params['update_artefact_group_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefact-groups/{artefactGroupId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtefactGroupDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefact_groups_get(self, edition_id, **kwargs):  # noqa: E501
        """Gets a listing of all artefact groups in the edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefact_groups_get(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArtefactGroupListDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefact_groups_get_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefact_groups_get_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Gets a listing of all artefact groups in the edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefact_groups_get_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArtefactGroupListDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefact_groups_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefact_groups_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefact-groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtefactGroupListDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefact_groups_post(self, edition_id, **kwargs):  # noqa: E501
        """Creates a new artefact group with the submitted data.  The new artefact must have a list of artefacts that belong to the group.  It is not necessary to give the group a name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefact_groups_post(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param CreateArtefactGroupDTO create_artefact_group_dto: Parameters of the new artefact group
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArtefactGroupDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefact_groups_post_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefact_groups_post_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Creates a new artefact group with the submitted data.  The new artefact must have a list of artefacts that belong to the group.  It is not necessary to give the group a name.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefact_groups_post_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param CreateArtefactGroupDTO create_artefact_group_dto: Parameters of the new artefact group
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArtefactGroupDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'create_artefact_group_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefact_groups_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefact_groups_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_artefact_group_dto' in local_var_params:
            body_params = local_var_params['create_artefact_group_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefact-groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtefactGroupDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefacts_artefact_id_delete(self, edition_id, artefact_id, **kwargs):  # noqa: E501
        """Deletes the specified artefact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_artefact_id_delete(edition_id, artefact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_id: Unique Id of the desired artefact (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefacts_artefact_id_delete_with_http_info(edition_id, artefact_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefacts_artefact_id_delete_with_http_info(self, edition_id, artefact_id, **kwargs):  # noqa: E501
        """Deletes the specified artefact  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_artefact_id_delete_with_http_info(edition_id, artefact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_id: Unique Id of the desired artefact (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'artefact_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefacts_artefact_id_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefacts_artefact_id_delete`")  # noqa: E501
        # verify the required parameter 'artefact_id' is set
        if self.api_client.client_side_validation and ('artefact_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['artefact_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `artefact_id` when calling `v1_editions_edition_id_artefacts_artefact_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'artefact_id' in local_var_params:
            path_params['artefactId'] = local_var_params['artefact_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefacts/{artefactId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefacts_artefact_id_get(self, edition_id, artefact_id, **kwargs):  # noqa: E501
        """Provides a listing of all artefacts that are part of the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_artefact_id_get(edition_id, artefact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_id: Unique Id of the desired artefact (required)
        :param list[str] optional: Add \"masks\" to include artefact polygons and \"images\" to include image data
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArtefactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefacts_artefact_id_get_with_http_info(edition_id, artefact_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefacts_artefact_id_get_with_http_info(self, edition_id, artefact_id, **kwargs):  # noqa: E501
        """Provides a listing of all artefacts that are part of the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_artefact_id_get_with_http_info(edition_id, artefact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_id: Unique Id of the desired artefact (required)
        :param list[str] optional: Add \"masks\" to include artefact polygons and \"images\" to include image data
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArtefactDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'artefact_id',
            'optional'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefacts_artefact_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefacts_artefact_id_get`")  # noqa: E501
        # verify the required parameter 'artefact_id' is set
        if self.api_client.client_side_validation and ('artefact_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['artefact_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `artefact_id` when calling `v1_editions_edition_id_artefacts_artefact_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'artefact_id' in local_var_params:
            path_params['artefactId'] = local_var_params['artefact_id']  # noqa: E501

        query_params = []
        if 'optional' in local_var_params and local_var_params['optional'] is not None:  # noqa: E501
            query_params.append(('optional', local_var_params['optional']))  # noqa: E501
            collection_formats['optional'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefacts/{artefactId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtefactDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefacts_artefact_id_put(self, edition_id, artefact_id, **kwargs):  # noqa: E501
        """Updates the specified artefact.  There are many possible attributes that can be changed for  an artefact.  The caller should only input only those that  should be changed. Attributes with a null value will be ignored.  For instance, setting the mask to null or \"\" will result in  no changes to the current mask, and no value for the mask will  be returned (or broadcast). Likewise, the transformation, name,  or status message may be set to null and no change will be made  to those entities (though any unchanged values will be returned  along with the changed values and also broadcast to co-editors).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_artefact_id_put(edition_id, artefact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_id: Unique Id of the desired artefact (required)
        :param UpdateArtefactDTO update_artefact_dto: An UpdateArtefactDTO with the desired alterations to the artefact
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArtefactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefacts_artefact_id_put_with_http_info(edition_id, artefact_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefacts_artefact_id_put_with_http_info(self, edition_id, artefact_id, **kwargs):  # noqa: E501
        """Updates the specified artefact.  There are many possible attributes that can be changed for  an artefact.  The caller should only input only those that  should be changed. Attributes with a null value will be ignored.  For instance, setting the mask to null or \"\" will result in  no changes to the current mask, and no value for the mask will  be returned (or broadcast). Likewise, the transformation, name,  or status message may be set to null and no change will be made  to those entities (though any unchanged values will be returned  along with the changed values and also broadcast to co-editors).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_artefact_id_put_with_http_info(edition_id, artefact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_id: Unique Id of the desired artefact (required)
        :param UpdateArtefactDTO update_artefact_dto: An UpdateArtefactDTO with the desired alterations to the artefact
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArtefactDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'artefact_id',
            'update_artefact_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefacts_artefact_id_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefacts_artefact_id_put`")  # noqa: E501
        # verify the required parameter 'artefact_id' is set
        if self.api_client.client_side_validation and ('artefact_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['artefact_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `artefact_id` when calling `v1_editions_edition_id_artefacts_artefact_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'artefact_id' in local_var_params:
            path_params['artefactId'] = local_var_params['artefact_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_artefact_dto' in local_var_params:
            body_params = local_var_params['update_artefact_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefacts/{artefactId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtefactDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefacts_artefact_id_rois_get(self, edition_id, artefact_id, **kwargs):  # noqa: E501
        """Provides a listing of all rois belonging to an artefact in the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_artefact_id_rois_get(edition_id, artefact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_id: Unique Id of the desired artefact (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InterpretationRoiDTOList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefacts_artefact_id_rois_get_with_http_info(edition_id, artefact_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefacts_artefact_id_rois_get_with_http_info(self, edition_id, artefact_id, **kwargs):  # noqa: E501
        """Provides a listing of all rois belonging to an artefact in the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_artefact_id_rois_get_with_http_info(edition_id, artefact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_id: Unique Id of the desired artefact (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InterpretationRoiDTOList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'artefact_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefacts_artefact_id_rois_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefacts_artefact_id_rois_get`")  # noqa: E501
        # verify the required parameter 'artefact_id' is set
        if self.api_client.client_side_validation and ('artefact_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['artefact_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `artefact_id` when calling `v1_editions_edition_id_artefacts_artefact_id_rois_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'artefact_id' in local_var_params:
            path_params['artefactId'] = local_var_params['artefact_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefacts/{artefactId}/rois', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InterpretationRoiDTOList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefacts_artefact_id_text_fragments_get(self, edition_id, artefact_id, **kwargs):  # noqa: E501
        """Provides a listing of text fragments that have text in the specified artefact.  With the optional query parameter \"suggested\", this endpoint will also return  any text fragment that the system suggests might have text in the artefact.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_artefact_id_text_fragments_get(edition_id, artefact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_id: Unique Id of the desired artefact (required)
        :param list[str] optional: Add \"suggested\" to include possible matches suggested by the system
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArtefactTextFragmentMatchListDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefacts_artefact_id_text_fragments_get_with_http_info(edition_id, artefact_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefacts_artefact_id_text_fragments_get_with_http_info(self, edition_id, artefact_id, **kwargs):  # noqa: E501
        """Provides a listing of text fragments that have text in the specified artefact.  With the optional query parameter \"suggested\", this endpoint will also return  any text fragment that the system suggests might have text in the artefact.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_artefact_id_text_fragments_get_with_http_info(edition_id, artefact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param int artefact_id: Unique Id of the desired artefact (required)
        :param list[str] optional: Add \"suggested\" to include possible matches suggested by the system
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArtefactTextFragmentMatchListDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'artefact_id',
            'optional'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefacts_artefact_id_text_fragments_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefacts_artefact_id_text_fragments_get`")  # noqa: E501
        # verify the required parameter 'artefact_id' is set
        if self.api_client.client_side_validation and ('artefact_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['artefact_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `artefact_id` when calling `v1_editions_edition_id_artefacts_artefact_id_text_fragments_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'artefact_id' in local_var_params:
            path_params['artefactId'] = local_var_params['artefact_id']  # noqa: E501

        query_params = []
        if 'optional' in local_var_params and local_var_params['optional'] is not None:  # noqa: E501
            query_params.append(('optional', local_var_params['optional']))  # noqa: E501
            collection_formats['optional'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefacts/{artefactId}/text-fragments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtefactTextFragmentMatchListDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefacts_batch_transformation_post(self, edition_id, **kwargs):  # noqa: E501
        """Updates the positional data for a batch of artefacts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_batch_transformation_post(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param BatchUpdateArtefactPlacementDTO batch_update_artefact_placement_dto: A BatchUpdateArtefactTransformDTO with a list of the desired updates
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchUpdatedArtefactTransformDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefacts_batch_transformation_post_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefacts_batch_transformation_post_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Updates the positional data for a batch of artefacts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_batch_transformation_post_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param BatchUpdateArtefactPlacementDTO batch_update_artefact_placement_dto: A BatchUpdateArtefactTransformDTO with a list of the desired updates
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchUpdatedArtefactTransformDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'batch_update_artefact_placement_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefacts_batch_transformation_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefacts_batch_transformation_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'batch_update_artefact_placement_dto' in local_var_params:
            body_params = local_var_params['batch_update_artefact_placement_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefacts/batch-transformation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchUpdatedArtefactTransformDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefacts_get(self, edition_id, **kwargs):  # noqa: E501
        """Provides a listing of all artefacts that are part of the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_get(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param list[str] optional: Add \"masks\" to include artefact polygons and \"images\" to include image data
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArtefactListDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefacts_get_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefacts_get_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Provides a listing of all artefacts that are part of the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_get_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param list[str] optional: Add \"masks\" to include artefact polygons and \"images\" to include image data
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArtefactListDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'optional'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefacts_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefacts_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []
        if 'optional' in local_var_params and local_var_params['optional'] is not None:  # noqa: E501
            query_params.append(('optional', local_var_params['optional']))  # noqa: E501
            collection_formats['optional'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefacts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtefactListDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_artefacts_post(self, edition_id, **kwargs):  # noqa: E501
        """Creates a new artefact with the provided data.  If no mask is provided, a placeholder mask will be created with the values:  \"POLYGON((0 0,1 1,1 0,0 0))\" (the system requires a valid WKT polygon mask for  every artefact). It is not recommended to leave the mask, name, or work status  blank or null. It will often be advantageous to leave the transformation null  when first creating a new artefact.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_post(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param CreateArtefactDTO create_artefact_dto: A CreateArtefactDTO with the data for the new artefact
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ArtefactDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_artefacts_post_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_artefacts_post_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Creates a new artefact with the provided data.  If no mask is provided, a placeholder mask will be created with the values:  \"POLYGON((0 0,1 1,1 0,0 0))\" (the system requires a valid WKT polygon mask for  every artefact). It is not recommended to leave the mask, name, or work status  blank or null. It will often be advantageous to leave the transformation null  when first creating a new artefact.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_artefacts_post_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param CreateArtefactDTO create_artefact_dto: A CreateArtefactDTO with the data for the new artefact
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ArtefactDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'create_artefact_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_artefacts_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_artefacts_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_artefact_dto' in local_var_params:
            body_params = local_var_params['create_artefact_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/artefacts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ArtefactDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
