# coding: utf-8

"""
    SQE API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from qumranica.api_client import ApiClient
from qumranica.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class EditionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def v1_editions_admin_share_requests_get(self, **kwargs):  # noqa: E501
        """Get a list of requests issued by the current user for other users  to become editors of a shared edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_admin_share_requests_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AdminEditorRequestListDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_admin_share_requests_get_with_http_info(**kwargs)  # noqa: E501

    def v1_editions_admin_share_requests_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of requests issued by the current user for other users  to become editors of a shared edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_admin_share_requests_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AdminEditorRequestListDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_admin_share_requests_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/admin-share-requests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminEditorRequestListDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_confirm_editorship_token_post(self, token, **kwargs):  # noqa: E501
        """Confirm addition of an editor to the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_confirm_editorship_token_post(token, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str token: JWT for verifying the request confirmation (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DetailedEditorRightsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_confirm_editorship_token_post_with_http_info(token, **kwargs)  # noqa: E501

    def v1_editions_confirm_editorship_token_post_with_http_info(self, token, **kwargs):  # noqa: E501
        """Confirm addition of an editor to the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_confirm_editorship_token_post_with_http_info(token, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str token: JWT for verifying the request confirmation (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DetailedEditorRightsDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'token'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_confirm_editorship_token_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'token' is set
        if self.api_client.client_side_validation and ('token' not in local_var_params or  # noqa: E501
                                                        local_var_params['token'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `token` when calling `v1_editions_confirm_editorship_token_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'token' in local_var_params:
            path_params['token'] = local_var_params['token']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/confirm-editorship/{token}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DetailedEditorRightsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_add_editor_request_post(self, edition_id, **kwargs):  # noqa: E501
        """Adds an editor to the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_add_editor_request_post(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param InviteEditorDTO invite_editor_dto: JSON object with the attributes of the new editor
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_add_editor_request_post_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_add_editor_request_post_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Adds an editor to the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_add_editor_request_post_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param InviteEditorDTO invite_editor_dto: JSON object with the attributes of the new editor
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'invite_editor_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_add_editor_request_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_add_editor_request_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invite_editor_dto' in local_var_params:
            body_params = local_var_params['invite_editor_dto']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/add-editor-request', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_delete(self, edition_id, **kwargs):  # noqa: E501
        """Provides details about the specified edition and all accessible alternate editions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_delete(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param list[str] optional: Optional parameters: 'deleteForAllEditors'
        :param str token: token required when using optional 'deleteForAllEditors'
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DeleteTokenDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_delete_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_delete_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Provides details about the specified edition and all accessible alternate editions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_delete_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param list[str] optional: Optional parameters: 'deleteForAllEditors'
        :param str token: token required when using optional 'deleteForAllEditors'
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DeleteTokenDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'optional',
            'token'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []
        if 'optional' in local_var_params and local_var_params['optional'] is not None:  # noqa: E501
            query_params.append(('optional', local_var_params['optional']))  # noqa: E501
            collection_formats['optional'] = 'multi'  # noqa: E501
        if 'token' in local_var_params and local_var_params['token'] is not None:  # noqa: E501
            query_params.append(('token', local_var_params['token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeleteTokenDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_editors_editor_email_id_put(self, edition_id, editor_email_id, **kwargs):  # noqa: E501
        """Changes the rights for an editor of the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_editors_editor_email_id_put(edition_id, editor_email_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param str editor_email_id: Email address of the editor whose permissions are being changed (required)
        :param UpdateEditorRightsDTO update_editor_rights_dto: JSON object with the attributes of the new editor
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DetailedEditorRightsDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_editors_editor_email_id_put_with_http_info(edition_id, editor_email_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_editors_editor_email_id_put_with_http_info(self, edition_id, editor_email_id, **kwargs):  # noqa: E501
        """Changes the rights for an editor of the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_editors_editor_email_id_put_with_http_info(edition_id, editor_email_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param str editor_email_id: Email address of the editor whose permissions are being changed (required)
        :param UpdateEditorRightsDTO update_editor_rights_dto: JSON object with the attributes of the new editor
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DetailedEditorRightsDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'editor_email_id',
            'update_editor_rights_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_editors_editor_email_id_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_editors_editor_email_id_put`")  # noqa: E501
        # verify the required parameter 'editor_email_id' is set
        if self.api_client.client_side_validation and ('editor_email_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['editor_email_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `editor_email_id` when calling `v1_editions_edition_id_editors_editor_email_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'editor_email_id' in local_var_params:
            path_params['editorEmailId'] = local_var_params['editor_email_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_editor_rights_dto' in local_var_params:
            body_params = local_var_params['update_editor_rights_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/editors/{editorEmailId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DetailedEditorRightsDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_get(self, edition_id, **kwargs):  # noqa: E501
        """Provides details about the specified edition and all accessible alternate editions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_get(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EditionGroupDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_get_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_get_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Provides details about the specified edition and all accessible alternate editions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_get_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EditionGroupDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EditionGroupDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_post(self, edition_id, **kwargs):  # noqa: E501
        """Creates a copy of the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_post(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param EditionCopyDTO edition_copy_dto: JSON object with the attributes to be changed in the copied edition
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EditionDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_post_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_post_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Creates a copy of the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_post_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param EditionCopyDTO edition_copy_dto: JSON object with the attributes to be changed in the copied edition
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EditionDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'edition_copy_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'edition_copy_dto' in local_var_params:
            body_params = local_var_params['edition_copy_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EditionDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_put(self, edition_id, **kwargs):  # noqa: E501
        """Updates data for the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_put(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param EditionUpdateRequestDTO edition_update_request_dto: JSON object with the attributes to be updated
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EditionDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_put_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_put_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Updates data for the specified edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_put_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param EditionUpdateRequestDTO edition_update_request_dto: JSON object with the attributes to be updated
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EditionDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'edition_update_request_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'edition_update_request_dto' in local_var_params:
            body_params = local_var_params['edition_update_request_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EditionDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_script_collection_get(self, edition_id, **kwargs):  # noqa: E501
        """Provides spatial data for all letters in the edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_script_collection_get(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EditionScriptCollectionDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_script_collection_get_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_script_collection_get_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Provides spatial data for all letters in the edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_script_collection_get_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EditionScriptCollectionDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_script_collection_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_script_collection_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/script-collection', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EditionScriptCollectionDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_script_lines_get(self, edition_id, **kwargs):  # noqa: E501
        """Provides spatial data for all letters in the edition organized and oriented  by lines.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_script_lines_get(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EditionScriptLinesDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_script_lines_get_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_script_lines_get_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Provides spatial data for all letters in the edition organized and oriented  by lines.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_script_lines_get_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Unique Id of the desired edition (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EditionScriptLinesDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_script_lines_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_script_lines_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/script-lines', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EditionScriptLinesDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_editor_invitations_get(self, **kwargs):  # noqa: E501
        """Get a list of invitations issued to the current user to become an editor of a shared edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_editor_invitations_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EditorInvitationListDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_editor_invitations_get_with_http_info(**kwargs)  # noqa: E501

    def v1_editions_editor_invitations_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of invitations issued to the current user to become an editor of a shared edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_editor_invitations_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EditorInvitationListDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_editor_invitations_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/editor-invitations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EditorInvitationListDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_get(self, **kwargs):  # noqa: E501
        """Provides a listing of all editions accessible to the current user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EditionListDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_get_with_http_info(**kwargs)  # noqa: E501

    def v1_editions_get_with_http_info(self, **kwargs):  # noqa: E501
        """Provides a listing of all editions accessible to the current user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EditionListDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EditionListDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
