# coding: utf-8

"""
    SQE API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from qumranica.api_client import ApiClient
from qumranica.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RoiApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def v1_editions_edition_id_rois_batch_edit_post(self, edition_id, **kwargs):  # noqa: E501
        """Processes a series of create/update/delete ROI requests in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_batch_edit_post(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param BatchEditRoiDTO batch_edit_roi_dto: A JSON object with all the roi edits to be performed
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchEditRoiResponseDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_rois_batch_edit_post_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_rois_batch_edit_post_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Processes a series of create/update/delete ROI requests in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_batch_edit_post_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param BatchEditRoiDTO batch_edit_roi_dto: A JSON object with all the roi edits to be performed
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchEditRoiResponseDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'batch_edit_roi_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_rois_batch_edit_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_rois_batch_edit_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'batch_edit_roi_dto' in local_var_params:
            body_params = local_var_params['batch_edit_roi_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/rois/batch-edit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchEditRoiResponseDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_rois_batch_post(self, edition_id, **kwargs):  # noqa: E501
        """Creates new sign ROI's in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_batch_post(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param SetInterpretationRoiDTOList set_interpretation_roi_dto_list: A JSON object with an array of the new ROI's to be created
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InterpretationRoiDTOList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_rois_batch_post_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_rois_batch_post_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Creates new sign ROI's in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_batch_post_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param SetInterpretationRoiDTOList set_interpretation_roi_dto_list: A JSON object with an array of the new ROI's to be created
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InterpretationRoiDTOList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'set_interpretation_roi_dto_list'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_rois_batch_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_rois_batch_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_interpretation_roi_dto_list' in local_var_params:
            body_params = local_var_params['set_interpretation_roi_dto_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/rois/batch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InterpretationRoiDTOList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_rois_batch_put(self, edition_id, **kwargs):  # noqa: E501
        """Update existing sign ROI's in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_batch_put(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param UpdateInterpretationRoiDTOList update_interpretation_roi_dto_list: A JSON object with an array of the updated ROI details
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdatedInterpretationRoiDTOList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_rois_batch_put_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_rois_batch_put_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Update existing sign ROI's in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_batch_put_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param UpdateInterpretationRoiDTOList update_interpretation_roi_dto_list: A JSON object with an array of the updated ROI details
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdatedInterpretationRoiDTOList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'update_interpretation_roi_dto_list'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_rois_batch_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_rois_batch_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_interpretation_roi_dto_list' in local_var_params:
            body_params = local_var_params['update_interpretation_roi_dto_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/rois/batch', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdatedInterpretationRoiDTOList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_rois_post(self, edition_id, **kwargs):  # noqa: E501
        """Creates new sign ROI in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_post(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param SetInterpretationRoiDTO set_interpretation_roi_dto: A JSON object with the new ROI to be created
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InterpretationRoiDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_rois_post_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_rois_post_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Creates new sign ROI in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_post_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param SetInterpretationRoiDTO set_interpretation_roi_dto: A JSON object with the new ROI to be created
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InterpretationRoiDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'set_interpretation_roi_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_rois_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_rois_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_interpretation_roi_dto' in local_var_params:
            body_params = local_var_params['set_interpretation_roi_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/rois', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InterpretationRoiDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_rois_roi_id_delete(self, edition_id, roi_id, **kwargs):  # noqa: E501
        """Deletes a sign ROI from the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_roi_id_delete(edition_id, roi_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param int roi_id: Id of the ROI to be deleted (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_rois_roi_id_delete_with_http_info(edition_id, roi_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_rois_roi_id_delete_with_http_info(self, edition_id, roi_id, **kwargs):  # noqa: E501
        """Deletes a sign ROI from the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_roi_id_delete_with_http_info(edition_id, roi_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param int roi_id: Id of the ROI to be deleted (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'roi_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_rois_roi_id_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_rois_roi_id_delete`")  # noqa: E501
        # verify the required parameter 'roi_id' is set
        if self.api_client.client_side_validation and ('roi_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['roi_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `roi_id` when calling `v1_editions_edition_id_rois_roi_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'roi_id' in local_var_params:
            path_params['roiId'] = local_var_params['roi_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/rois/{roiId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_rois_roi_id_get(self, edition_id, roi_id, **kwargs):  # noqa: E501
        """Get the details for a ROI in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_roi_id_get(edition_id, roi_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param int roi_id: A JSON object with the new ROI to be created (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InterpretationRoiDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_rois_roi_id_get_with_http_info(edition_id, roi_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_rois_roi_id_get_with_http_info(self, edition_id, roi_id, **kwargs):  # noqa: E501
        """Get the details for a ROI in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_roi_id_get_with_http_info(edition_id, roi_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param int roi_id: A JSON object with the new ROI to be created (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InterpretationRoiDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'roi_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_rois_roi_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_rois_roi_id_get`")  # noqa: E501
        # verify the required parameter 'roi_id' is set
        if self.api_client.client_side_validation and ('roi_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['roi_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `roi_id` when calling `v1_editions_edition_id_rois_roi_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'roi_id' in local_var_params:
            path_params['roiId'] = local_var_params['roi_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/rois/{roiId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InterpretationRoiDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_rois_roi_id_put(self, edition_id, roi_id, **kwargs):  # noqa: E501
        """Update an existing sign ROI in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_roi_id_put(edition_id, roi_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param int roi_id: Id of the ROI to be updated (required)
        :param SetInterpretationRoiDTO set_interpretation_roi_dto: A JSON object with the updated ROI details
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: UpdatedInterpretationRoiDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_rois_roi_id_put_with_http_info(edition_id, roi_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_rois_roi_id_put_with_http_info(self, edition_id, roi_id, **kwargs):  # noqa: E501
        """Update an existing sign ROI in the given edition of a scroll  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_rois_roi_id_put_with_http_info(edition_id, roi_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: Id of the edition (required)
        :param int roi_id: Id of the ROI to be updated (required)
        :param SetInterpretationRoiDTO set_interpretation_roi_dto: A JSON object with the updated ROI details
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(UpdatedInterpretationRoiDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'roi_id',
            'set_interpretation_roi_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_rois_roi_id_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_rois_roi_id_put`")  # noqa: E501
        # verify the required parameter 'roi_id' is set
        if self.api_client.client_side_validation and ('roi_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['roi_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `roi_id` when calling `v1_editions_edition_id_rois_roi_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'roi_id' in local_var_params:
            path_params['roiId'] = local_var_params['roi_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_interpretation_roi_dto' in local_var_params:
            body_params = local_var_params['set_interpretation_roi_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/rois/{roiId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpdatedInterpretationRoiDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
