# coding: utf-8

"""
    SQE API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from qumranica.api_client import ApiClient
from qumranica.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SignInterpretationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def v1_editions_edition_id_sign_interpretations_attributes_attribute_id_delete(self, edition_id, attribute_id, **kwargs):  # noqa: E501
        """Delete an attribute from an edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_attributes_attribute_id_delete(edition_id, attribute_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: The ID of the edition being edited (required)
        :param int attribute_id: The ID of the attribute to delete (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_attributes_attribute_id_delete_with_http_info(edition_id, attribute_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_attributes_attribute_id_delete_with_http_info(self, edition_id, attribute_id, **kwargs):  # noqa: E501
        """Delete an attribute from an edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_attributes_attribute_id_delete_with_http_info(edition_id, attribute_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: The ID of the edition being edited (required)
        :param int attribute_id: The ID of the attribute to delete (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'attribute_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_attributes_attribute_id_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_attributes_attribute_id_delete`")  # noqa: E501
        # verify the required parameter 'attribute_id' is set
        if self.api_client.client_side_validation and ('attribute_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['attribute_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attribute_id` when calling `v1_editions_edition_id_sign_interpretations_attributes_attribute_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'attribute_id' in local_var_params:
            path_params['attributeId'] = local_var_params['attribute_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations-attributes/{attributeId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_attributes_attribute_id_put(self, edition_id, attribute_id, **kwargs):  # noqa: E501
        """Change the details of an attribute in an edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_attributes_attribute_id_put(edition_id, attribute_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: The ID of the edition being edited (required)
        :param int attribute_id: The ID of the attribute to update (required)
        :param UpdateAttributeDTO update_attribute_dto: The details of the updated attribute
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AttributeDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_attributes_attribute_id_put_with_http_info(edition_id, attribute_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_attributes_attribute_id_put_with_http_info(self, edition_id, attribute_id, **kwargs):  # noqa: E501
        """Change the details of an attribute in an edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_attributes_attribute_id_put_with_http_info(edition_id, attribute_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: The ID of the edition being edited (required)
        :param int attribute_id: The ID of the attribute to update (required)
        :param UpdateAttributeDTO update_attribute_dto: The details of the updated attribute
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AttributeDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'attribute_id',
            'update_attribute_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_attributes_attribute_id_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_attributes_attribute_id_put`")  # noqa: E501
        # verify the required parameter 'attribute_id' is set
        if self.api_client.client_side_validation and ('attribute_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['attribute_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attribute_id` when calling `v1_editions_edition_id_sign_interpretations_attributes_attribute_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'attribute_id' in local_var_params:
            path_params['attributeId'] = local_var_params['attribute_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_attribute_dto' in local_var_params:
            body_params = local_var_params['update_attribute_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations-attributes/{attributeId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttributeDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_attributes_get(self, edition_id, **kwargs):  # noqa: E501
        """Retrieve a list of all possible attributes for an edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_attributes_get(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: The ID of the edition being searched (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AttributeListDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_attributes_get_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_attributes_get_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Retrieve a list of all possible attributes for an edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_attributes_get_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: The ID of the edition being searched (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AttributeListDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_attributes_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_attributes_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations-attributes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttributeListDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_attributes_post(self, edition_id, **kwargs):  # noqa: E501
        """Create a new attribute for an edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_attributes_post(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: The ID of the edition being edited (required)
        :param CreateAttributeDTO create_attribute_dto: The details of the new attribute
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AttributeDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_attributes_post_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_attributes_post_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Create a new attribute for an edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_attributes_post_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: The ID of the edition being edited (required)
        :param CreateAttributeDTO create_attribute_dto: The details of the new attribute
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AttributeDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'create_attribute_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_attributes_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_attributes_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_attribute_dto' in local_var_params:
            body_params = local_var_params['create_attribute_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations-attributes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttributeDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_post(self, edition_id, **kwargs):  # noqa: E501
        """Creates a new sign interpretation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_post(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param SignInterpretationCreateDTO sign_interpretation_create_dto: New sign interpretation data to be added
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SignInterpretationListDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_post_with_http_info(edition_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_post_with_http_info(self, edition_id, **kwargs):  # noqa: E501
        """Creates a new sign interpretation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_post_with_http_info(edition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param SignInterpretationCreateDTO sign_interpretation_create_dto: New sign interpretation data to be added
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SignInterpretationListDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'sign_interpretation_create_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sign_interpretation_create_dto' in local_var_params:
            body_params = local_var_params['sign_interpretation_create_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SignInterpretationListDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_delete(self, edition_id, sign_interpretation_id, attribute_value_id, **kwargs):  # noqa: E501
        """This deletes the specified attribute value from the specified sign interpretation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_delete(edition_id, sign_interpretation_id, attribute_value_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: ID of the sign interpretation being altered (required)
        :param int attribute_value_id: Id of the attribute being removed (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_delete_with_http_info(edition_id, sign_interpretation_id, attribute_value_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_delete_with_http_info(self, edition_id, sign_interpretation_id, attribute_value_id, **kwargs):  # noqa: E501
        """This deletes the specified attribute value from the specified sign interpretation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_delete_with_http_info(edition_id, sign_interpretation_id, attribute_value_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: ID of the sign interpretation being altered (required)
        :param int attribute_value_id: Id of the attribute being removed (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'sign_interpretation_id',
            'attribute_value_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_delete`")  # noqa: E501
        # verify the required parameter 'sign_interpretation_id' is set
        if self.api_client.client_side_validation and ('sign_interpretation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['sign_interpretation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `sign_interpretation_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_delete`")  # noqa: E501
        # verify the required parameter 'attribute_value_id' is set
        if self.api_client.client_side_validation and ('attribute_value_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['attribute_value_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attribute_value_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'sign_interpretation_id' in local_var_params:
            path_params['signInterpretationId'] = local_var_params['sign_interpretation_id']  # noqa: E501
        if 'attribute_value_id' in local_var_params:
            path_params['attributeValueId'] = local_var_params['attribute_value_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/attributes/{attributeValueId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_put(self, edition_id, sign_interpretation_id, attribute_value_id, **kwargs):  # noqa: E501
        """This changes the values of the specified sign interpretation attribute,  mainly used to change commentary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_put(edition_id, sign_interpretation_id, attribute_value_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: ID of the sign interpretation being altered (required)
        :param int attribute_value_id: Id of the attribute value to be altered (required)
        :param InterpretationAttributeCreateDTO interpretation_attribute_create_dto: New details of the attribute
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SignInterpretationDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_put_with_http_info(edition_id, sign_interpretation_id, attribute_value_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_put_with_http_info(self, edition_id, sign_interpretation_id, attribute_value_id, **kwargs):  # noqa: E501
        """This changes the values of the specified sign interpretation attribute,  mainly used to change commentary.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_put_with_http_info(edition_id, sign_interpretation_id, attribute_value_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: ID of the sign interpretation being altered (required)
        :param int attribute_value_id: Id of the attribute value to be altered (required)
        :param InterpretationAttributeCreateDTO interpretation_attribute_create_dto: New details of the attribute
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SignInterpretationDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'sign_interpretation_id',
            'attribute_value_id',
            'interpretation_attribute_create_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_put`")  # noqa: E501
        # verify the required parameter 'sign_interpretation_id' is set
        if self.api_client.client_side_validation and ('sign_interpretation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['sign_interpretation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `sign_interpretation_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_put`")  # noqa: E501
        # verify the required parameter 'attribute_value_id' is set
        if self.api_client.client_side_validation and ('attribute_value_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['attribute_value_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attribute_value_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_attribute_value_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'sign_interpretation_id' in local_var_params:
            path_params['signInterpretationId'] = local_var_params['sign_interpretation_id']  # noqa: E501
        if 'attribute_value_id' in local_var_params:
            path_params['attributeValueId'] = local_var_params['attribute_value_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'interpretation_attribute_create_dto' in local_var_params:
            body_params = local_var_params['interpretation_attribute_create_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/attributes/{attributeValueId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SignInterpretationDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_post(self, edition_id, sign_interpretation_id, **kwargs):  # noqa: E501
        """This adds a new attribute to the specified sign interpretation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_post(edition_id, sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: ID of the sign interpretation for adding a new attribute (required)
        :param InterpretationAttributeCreateDTO interpretation_attribute_create_dto: Details of the attribute to be added
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SignInterpretationDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_post_with_http_info(edition_id, sign_interpretation_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_post_with_http_info(self, edition_id, sign_interpretation_id, **kwargs):  # noqa: E501
        """This adds a new attribute to the specified sign interpretation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_post_with_http_info(edition_id, sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: ID of the sign interpretation for adding a new attribute (required)
        :param InterpretationAttributeCreateDTO interpretation_attribute_create_dto: Details of the attribute to be added
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SignInterpretationDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'sign_interpretation_id',
            'interpretation_attribute_create_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_post`")  # noqa: E501
        # verify the required parameter 'sign_interpretation_id' is set
        if self.api_client.client_side_validation and ('sign_interpretation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['sign_interpretation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `sign_interpretation_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_attributes_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'sign_interpretation_id' in local_var_params:
            path_params['signInterpretationId'] = local_var_params['sign_interpretation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'interpretation_attribute_create_dto' in local_var_params:
            body_params = local_var_params['interpretation_attribute_create_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/attributes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SignInterpretationDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_commentary_put(self, edition_id, sign_interpretation_id, **kwargs):  # noqa: E501
        """Updates the commentary of a sign interpretation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_commentary_put(edition_id, sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: ID of the sign interpretation whose commentary is being changed (required)
        :param CommentaryCreateDTO commentary_create_dto: The new commentary for the sign interpretation
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SignInterpretationDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_commentary_put_with_http_info(edition_id, sign_interpretation_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_commentary_put_with_http_info(self, edition_id, sign_interpretation_id, **kwargs):  # noqa: E501
        """Updates the commentary of a sign interpretation  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_commentary_put_with_http_info(edition_id, sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: ID of the sign interpretation whose commentary is being changed (required)
        :param CommentaryCreateDTO commentary_create_dto: The new commentary for the sign interpretation
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SignInterpretationDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'sign_interpretation_id',
            'commentary_create_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_sign_interpretation_id_commentary_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_commentary_put`")  # noqa: E501
        # verify the required parameter 'sign_interpretation_id' is set
        if self.api_client.client_side_validation and ('sign_interpretation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['sign_interpretation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `sign_interpretation_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_commentary_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'sign_interpretation_id' in local_var_params:
            path_params['signInterpretationId'] = local_var_params['sign_interpretation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'commentary_create_dto' in local_var_params:
            body_params = local_var_params['commentary_create_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/commentary', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SignInterpretationDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_delete(self, edition_id, sign_interpretation_id, **kwargs):  # noqa: E501
        """Deletes the sign interpretation in the route. The endpoint automatically manages the sign stream  by connecting all the deleted sign's next and previous nodes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_delete(edition_id, sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: ID of the sign interpretation being deleted (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_delete_with_http_info(edition_id, sign_interpretation_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_delete_with_http_info(self, edition_id, sign_interpretation_id, **kwargs):  # noqa: E501
        """Deletes the sign interpretation in the route. The endpoint automatically manages the sign stream  by connecting all the deleted sign's next and previous nodes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_delete_with_http_info(edition_id, sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: ID of the sign interpretation being deleted (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'sign_interpretation_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_sign_interpretation_id_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_delete`")  # noqa: E501
        # verify the required parameter 'sign_interpretation_id' is set
        if self.api_client.client_side_validation and ('sign_interpretation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['sign_interpretation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `sign_interpretation_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'sign_interpretation_id' in local_var_params:
            path_params['signInterpretationId'] = local_var_params['sign_interpretation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations/{signInterpretationId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_get(self, edition_id, sign_interpretation_id, **kwargs):  # noqa: E501
        """Retrieve the details of a sign interpretation in an edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_get(edition_id, sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: The ID of the edition being searched (required)
        :param int sign_interpretation_id: The desired sign interpretation id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SignInterpretationDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_get_with_http_info(edition_id, sign_interpretation_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_get_with_http_info(self, edition_id, sign_interpretation_id, **kwargs):  # noqa: E501
        """Retrieve the details of a sign interpretation in an edition  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_get_with_http_info(edition_id, sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: The ID of the edition being searched (required)
        :param int sign_interpretation_id: The desired sign interpretation id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SignInterpretationDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'sign_interpretation_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_sign_interpretation_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_get`")  # noqa: E501
        # verify the required parameter 'sign_interpretation_id' is set
        if self.api_client.client_side_validation and ('sign_interpretation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['sign_interpretation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `sign_interpretation_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'sign_interpretation_id' in local_var_params:
            path_params['signInterpretationId'] = local_var_params['sign_interpretation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations/{signInterpretationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SignInterpretationDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_link_to_next_sign_interpretation_id_post(self, edition_id, sign_interpretation_id, next_sign_interpretation_id, **kwargs):  # noqa: E501
        """Links two sign interpretations in the edition's sign stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_link_to_next_sign_interpretation_id_post(edition_id, sign_interpretation_id, next_sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: The sign interpretation to be linked to the nextSignInterpretationId (required)
        :param int next_sign_interpretation_id: The sign interpretation to become the new next sign interpretation (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SignInterpretationDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_link_to_next_sign_interpretation_id_post_with_http_info(edition_id, sign_interpretation_id, next_sign_interpretation_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_link_to_next_sign_interpretation_id_post_with_http_info(self, edition_id, sign_interpretation_id, next_sign_interpretation_id, **kwargs):  # noqa: E501
        """Links two sign interpretations in the edition's sign stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_link_to_next_sign_interpretation_id_post_with_http_info(edition_id, sign_interpretation_id, next_sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: The sign interpretation to be linked to the nextSignInterpretationId (required)
        :param int next_sign_interpretation_id: The sign interpretation to become the new next sign interpretation (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SignInterpretationDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'sign_interpretation_id',
            'next_sign_interpretation_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_sign_interpretation_id_link_to_next_sign_interpretation_id_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_link_to_next_sign_interpretation_id_post`")  # noqa: E501
        # verify the required parameter 'sign_interpretation_id' is set
        if self.api_client.client_side_validation and ('sign_interpretation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['sign_interpretation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `sign_interpretation_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_link_to_next_sign_interpretation_id_post`")  # noqa: E501
        # verify the required parameter 'next_sign_interpretation_id' is set
        if self.api_client.client_side_validation and ('next_sign_interpretation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['next_sign_interpretation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `next_sign_interpretation_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_link_to_next_sign_interpretation_id_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'sign_interpretation_id' in local_var_params:
            path_params['signInterpretationId'] = local_var_params['sign_interpretation_id']  # noqa: E501
        if 'next_sign_interpretation_id' in local_var_params:
            path_params['nextSignInterpretationId'] = local_var_params['next_sign_interpretation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/link-to/{nextSignInterpretationId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SignInterpretationDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_unlink_from_next_sign_interpretation_id_post(self, edition_id, sign_interpretation_id, next_sign_interpretation_id, **kwargs):  # noqa: E501
        """Links two sign interpretations in the edition's sign stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_unlink_from_next_sign_interpretation_id_post(edition_id, sign_interpretation_id, next_sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: The sign interpretation to be unlinked from the nextSignInterpretationId (required)
        :param int next_sign_interpretation_id: The sign interpretation to removed as next sign interpretation (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SignInterpretationDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_unlink_from_next_sign_interpretation_id_post_with_http_info(edition_id, sign_interpretation_id, next_sign_interpretation_id, **kwargs)  # noqa: E501

    def v1_editions_edition_id_sign_interpretations_sign_interpretation_id_unlink_from_next_sign_interpretation_id_post_with_http_info(self, edition_id, sign_interpretation_id, next_sign_interpretation_id, **kwargs):  # noqa: E501
        """Links two sign interpretations in the edition's sign stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v1_editions_edition_id_sign_interpretations_sign_interpretation_id_unlink_from_next_sign_interpretation_id_post_with_http_info(edition_id, sign_interpretation_id, next_sign_interpretation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int edition_id: ID of the edition being changed (required)
        :param int sign_interpretation_id: The sign interpretation to be unlinked from the nextSignInterpretationId (required)
        :param int next_sign_interpretation_id: The sign interpretation to removed as next sign interpretation (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SignInterpretationDTO, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edition_id',
            'sign_interpretation_id',
            'next_sign_interpretation_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v1_editions_edition_id_sign_interpretations_sign_interpretation_id_unlink_from_next_sign_interpretation_id_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edition_id' is set
        if self.api_client.client_side_validation and ('edition_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['edition_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edition_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_unlink_from_next_sign_interpretation_id_post`")  # noqa: E501
        # verify the required parameter 'sign_interpretation_id' is set
        if self.api_client.client_side_validation and ('sign_interpretation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['sign_interpretation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `sign_interpretation_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_unlink_from_next_sign_interpretation_id_post`")  # noqa: E501
        # verify the required parameter 'next_sign_interpretation_id' is set
        if self.api_client.client_side_validation and ('next_sign_interpretation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['next_sign_interpretation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `next_sign_interpretation_id` when calling `v1_editions_edition_id_sign_interpretations_sign_interpretation_id_unlink_from_next_sign_interpretation_id_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'edition_id' in local_var_params:
            path_params['editionId'] = local_var_params['edition_id']  # noqa: E501
        if 'sign_interpretation_id' in local_var_params:
            path_params['signInterpretationId'] = local_var_params['sign_interpretation_id']  # noqa: E501
        if 'next_sign_interpretation_id' in local_var_params:
            path_params['nextSignInterpretationId'] = local_var_params['next_sign_interpretation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/editions/{editionId}/sign-interpretations/{signInterpretationId}/unlink-from/{nextSignInterpretationId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SignInterpretationDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
