# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAuthenticatorResult',
    'AwaitableGetAuthenticatorResult',
    'get_authenticator',
    'get_authenticator_output',
]

@pulumi.output_type
class GetAuthenticatorResult:
    """
    A collection of values returned by getAuthenticator.
    """
    def __init__(__self__, id=None, key=None, name=None, provider_auth_port=None, provider_hostname=None, provider_instance_id=None, provider_json=None, provider_type=None, provider_user_name_template=None, settings=None, status=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provider_auth_port and not isinstance(provider_auth_port, int):
            raise TypeError("Expected argument 'provider_auth_port' to be a int")
        pulumi.set(__self__, "provider_auth_port", provider_auth_port)
        if provider_hostname and not isinstance(provider_hostname, str):
            raise TypeError("Expected argument 'provider_hostname' to be a str")
        pulumi.set(__self__, "provider_hostname", provider_hostname)
        if provider_instance_id and not isinstance(provider_instance_id, str):
            raise TypeError("Expected argument 'provider_instance_id' to be a str")
        pulumi.set(__self__, "provider_instance_id", provider_instance_id)
        if provider_json and not isinstance(provider_json, str):
            raise TypeError("Expected argument 'provider_json' to be a str")
        pulumi.set(__self__, "provider_json", provider_json)
        if provider_type and not isinstance(provider_type, str):
            raise TypeError("Expected argument 'provider_type' to be a str")
        pulumi.set(__self__, "provider_type", provider_type)
        if provider_user_name_template and not isinstance(provider_user_name_template, str):
            raise TypeError("Expected argument 'provider_user_name_template' to be a str")
        pulumi.set(__self__, "provider_user_name_template", provider_user_name_template)
        if settings and not isinstance(settings, str):
            raise TypeError("Expected argument 'settings' to be a str")
        pulumi.set(__self__, "settings", settings)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the authenticator.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the authenticator.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="providerAuthPort")
    def provider_auth_port(self) -> int:
        """
        (Specific to `security_key`) The provider server port (for example 1812).
        """
        return pulumi.get(self, "provider_auth_port")

    @property
    @pulumi.getter(name="providerHostname")
    def provider_hostname(self) -> str:
        """
        (Specific to `security_key`) Server host name or IP address.
        """
        return pulumi.get(self, "provider_hostname")

    @property
    @pulumi.getter(name="providerInstanceId")
    def provider_instance_id(self) -> str:
        """
        (Specific to `security_key`) App Instance ID.
        """
        return pulumi.get(self, "provider_instance_id")

    @property
    @pulumi.getter(name="providerJson")
    def provider_json(self) -> str:
        return pulumi.get(self, "provider_json")

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        Provider type.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="providerUserNameTemplate")
    def provider_user_name_template(self) -> str:
        """
        Username template expected by the provider.
        """
        return pulumi.get(self, "provider_user_name_template")

    @property
    @pulumi.getter
    def settings(self) -> str:
        """
        Settings for the authenticator (expressed in JSON).
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the Authenticator.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of Authenticator.
        """
        return pulumi.get(self, "type")


class AwaitableGetAuthenticatorResult(GetAuthenticatorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthenticatorResult(
            id=self.id,
            key=self.key,
            name=self.name,
            provider_auth_port=self.provider_auth_port,
            provider_hostname=self.provider_hostname,
            provider_instance_id=self.provider_instance_id,
            provider_json=self.provider_json,
            provider_type=self.provider_type,
            provider_user_name_template=self.provider_user_name_template,
            settings=self.settings,
            status=self.status,
            type=self.type)


def get_authenticator(id: Optional[str] = None,
                      key: Optional[str] = None,
                      name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthenticatorResult:
    """
    > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.

    Use this data source to retrieve an authenticator.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_authenticator(name="Security Question")
    ```

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_authenticator(key="okta_email")
    ```


    :param str id: ID of the authenticator.
    :param str key: A human-readable string that identifies the authenticator.
    :param str name: Name of the authenticator.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['key'] = key
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getAuthenticator:getAuthenticator', __args__, opts=opts, typ=GetAuthenticatorResult).value

    return AwaitableGetAuthenticatorResult(
        id=__ret__.id,
        key=__ret__.key,
        name=__ret__.name,
        provider_auth_port=__ret__.provider_auth_port,
        provider_hostname=__ret__.provider_hostname,
        provider_instance_id=__ret__.provider_instance_id,
        provider_json=__ret__.provider_json,
        provider_type=__ret__.provider_type,
        provider_user_name_template=__ret__.provider_user_name_template,
        settings=__ret__.settings,
        status=__ret__.status,
        type=__ret__.type)


@_utilities.lift_output_func(get_authenticator)
def get_authenticator_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                             key: Optional[pulumi.Input[Optional[str]]] = None,
                             name: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuthenticatorResult]:
    """
    > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.

    Use this data source to retrieve an authenticator.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_authenticator(name="Security Question")
    ```

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_authenticator(key="okta_email")
    ```


    :param str id: ID of the authenticator.
    :param str key: A human-readable string that identifies the authenticator.
    :param str name: Name of the authenticator.
    """
    ...
