# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 expression_value: pulumi.Input[str],
                 group_assignments: pulumi.Input[Sequence[pulumi.Input[str]]],
                 expression_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remove_assigned_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[str] expression_value: The expression value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_assignments: The list of group ids to assign the users to.
        :param pulumi.Input[str] expression_type: The expression type to use to invoke the rule. The default
               is `"urn:okta:expression:1.0"`.
        :param pulumi.Input[str] name: The name of the Group Rule (min character 1; max characters 50).
        :param pulumi.Input[bool] remove_assigned_users: This tells the provider to remove users added by this rule from the assigned
               group after destroying this resource. Default is `false`.
        :param pulumi.Input[str] status: The status of the group rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: The list of user IDs that would be excluded when rules are processed.
        """
        pulumi.set(__self__, "expression_value", expression_value)
        pulumi.set(__self__, "group_assignments", group_assignments)
        if expression_type is not None:
            pulumi.set(__self__, "expression_type", expression_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remove_assigned_users is not None:
            pulumi.set(__self__, "remove_assigned_users", remove_assigned_users)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users_excludeds is not None:
            pulumi.set(__self__, "users_excludeds", users_excludeds)

    @property
    @pulumi.getter(name="expressionValue")
    def expression_value(self) -> pulumi.Input[str]:
        """
        The expression value.
        """
        return pulumi.get(self, "expression_value")

    @expression_value.setter
    def expression_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression_value", value)

    @property
    @pulumi.getter(name="groupAssignments")
    def group_assignments(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of group ids to assign the users to.
        """
        return pulumi.get(self, "group_assignments")

    @group_assignments.setter
    def group_assignments(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "group_assignments", value)

    @property
    @pulumi.getter(name="expressionType")
    def expression_type(self) -> Optional[pulumi.Input[str]]:
        """
        The expression type to use to invoke the rule. The default
        is `"urn:okta:expression:1.0"`.
        """
        return pulumi.get(self, "expression_type")

    @expression_type.setter
    def expression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Group Rule (min character 1; max characters 50).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="removeAssignedUsers")
    def remove_assigned_users(self) -> Optional[pulumi.Input[bool]]:
        """
        This tells the provider to remove users added by this rule from the assigned
        group after destroying this resource. Default is `false`.
        """
        return pulumi.get(self, "remove_assigned_users")

    @remove_assigned_users.setter
    def remove_assigned_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_assigned_users", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the group rule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of user IDs that would be excluded when rules are processed.
        """
        return pulumi.get(self, "users_excludeds")

    @users_excludeds.setter
    def users_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users_excludeds", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 expression_type: Optional[pulumi.Input[str]] = None,
                 expression_value: Optional[pulumi.Input[str]] = None,
                 group_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remove_assigned_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[str] expression_type: The expression type to use to invoke the rule. The default
               is `"urn:okta:expression:1.0"`.
        :param pulumi.Input[str] expression_value: The expression value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_assignments: The list of group ids to assign the users to.
        :param pulumi.Input[str] name: The name of the Group Rule (min character 1; max characters 50).
        :param pulumi.Input[bool] remove_assigned_users: This tells the provider to remove users added by this rule from the assigned
               group after destroying this resource. Default is `false`.
        :param pulumi.Input[str] status: The status of the group rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: The list of user IDs that would be excluded when rules are processed.
        """
        if expression_type is not None:
            pulumi.set(__self__, "expression_type", expression_type)
        if expression_value is not None:
            pulumi.set(__self__, "expression_value", expression_value)
        if group_assignments is not None:
            pulumi.set(__self__, "group_assignments", group_assignments)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if remove_assigned_users is not None:
            pulumi.set(__self__, "remove_assigned_users", remove_assigned_users)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users_excludeds is not None:
            pulumi.set(__self__, "users_excludeds", users_excludeds)

    @property
    @pulumi.getter(name="expressionType")
    def expression_type(self) -> Optional[pulumi.Input[str]]:
        """
        The expression type to use to invoke the rule. The default
        is `"urn:okta:expression:1.0"`.
        """
        return pulumi.get(self, "expression_type")

    @expression_type.setter
    def expression_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression_type", value)

    @property
    @pulumi.getter(name="expressionValue")
    def expression_value(self) -> Optional[pulumi.Input[str]]:
        """
        The expression value.
        """
        return pulumi.get(self, "expression_value")

    @expression_value.setter
    def expression_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression_value", value)

    @property
    @pulumi.getter(name="groupAssignments")
    def group_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of group ids to assign the users to.
        """
        return pulumi.get(self, "group_assignments")

    @group_assignments.setter
    def group_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_assignments", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Group Rule (min character 1; max characters 50).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="removeAssignedUsers")
    def remove_assigned_users(self) -> Optional[pulumi.Input[bool]]:
        """
        This tells the provider to remove users added by this rule from the assigned
        group after destroying this resource. Default is `false`.
        """
        return pulumi.get(self, "remove_assigned_users")

    @remove_assigned_users.setter
    def remove_assigned_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_assigned_users", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the group rule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of user IDs that would be excluded when rules are processed.
        """
        return pulumi.get(self, "users_excludeds")

    @users_excludeds.setter
    def users_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users_excludeds", value)


class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expression_type: Optional[pulumi.Input[str]] = None,
                 expression_value: Optional[pulumi.Input[str]] = None,
                 group_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remove_assigned_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Creates an Okta Group Rule.

        This resource allows you to create and configure an Okta Group Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.group.Rule("example",
            expression_type="urn:okta:expression:1.0",
            expression_value="String.startsWith(user.firstName,\\"andy\\")",
            group_assignments=["<group id>"],
            status="ACTIVE")
        ```

        ## Import

        An Okta Group Rule can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:group/rule:Rule example &#60;group rule id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] expression_type: The expression type to use to invoke the rule. The default
               is `"urn:okta:expression:1.0"`.
        :param pulumi.Input[str] expression_value: The expression value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_assignments: The list of group ids to assign the users to.
        :param pulumi.Input[str] name: The name of the Group Rule (min character 1; max characters 50).
        :param pulumi.Input[bool] remove_assigned_users: This tells the provider to remove users added by this rule from the assigned
               group after destroying this resource. Default is `false`.
        :param pulumi.Input[str] status: The status of the group rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: The list of user IDs that would be excluded when rules are processed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Okta Group Rule.

        This resource allows you to create and configure an Okta Group Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.group.Rule("example",
            expression_type="urn:okta:expression:1.0",
            expression_value="String.startsWith(user.firstName,\\"andy\\")",
            group_assignments=["<group id>"],
            status="ACTIVE")
        ```

        ## Import

        An Okta Group Rule can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:group/rule:Rule example &#60;group rule id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expression_type: Optional[pulumi.Input[str]] = None,
                 expression_value: Optional[pulumi.Input[str]] = None,
                 group_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 remove_assigned_users: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["expression_type"] = expression_type
            if expression_value is None and not opts.urn:
                raise TypeError("Missing required property 'expression_value'")
            __props__.__dict__["expression_value"] = expression_value
            if group_assignments is None and not opts.urn:
                raise TypeError("Missing required property 'group_assignments'")
            __props__.__dict__["group_assignments"] = group_assignments
            __props__.__dict__["name"] = name
            __props__.__dict__["remove_assigned_users"] = remove_assigned_users
            __props__.__dict__["status"] = status
            __props__.__dict__["users_excludeds"] = users_excludeds
        super(Rule, __self__).__init__(
            'okta:group/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            expression_type: Optional[pulumi.Input[str]] = None,
            expression_value: Optional[pulumi.Input[str]] = None,
            group_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            remove_assigned_users: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] expression_type: The expression type to use to invoke the rule. The default
               is `"urn:okta:expression:1.0"`.
        :param pulumi.Input[str] expression_value: The expression value.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_assignments: The list of group ids to assign the users to.
        :param pulumi.Input[str] name: The name of the Group Rule (min character 1; max characters 50).
        :param pulumi.Input[bool] remove_assigned_users: This tells the provider to remove users added by this rule from the assigned
               group after destroying this resource. Default is `false`.
        :param pulumi.Input[str] status: The status of the group rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: The list of user IDs that would be excluded when rules are processed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["expression_type"] = expression_type
        __props__.__dict__["expression_value"] = expression_value
        __props__.__dict__["group_assignments"] = group_assignments
        __props__.__dict__["name"] = name
        __props__.__dict__["remove_assigned_users"] = remove_assigned_users
        __props__.__dict__["status"] = status
        __props__.__dict__["users_excludeds"] = users_excludeds
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="expressionType")
    def expression_type(self) -> pulumi.Output[Optional[str]]:
        """
        The expression type to use to invoke the rule. The default
        is `"urn:okta:expression:1.0"`.
        """
        return pulumi.get(self, "expression_type")

    @property
    @pulumi.getter(name="expressionValue")
    def expression_value(self) -> pulumi.Output[str]:
        """
        The expression value.
        """
        return pulumi.get(self, "expression_value")

    @property
    @pulumi.getter(name="groupAssignments")
    def group_assignments(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of group ids to assign the users to.
        """
        return pulumi.get(self, "group_assignments")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Group Rule (min character 1; max characters 50).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="removeAssignedUsers")
    def remove_assigned_users(self) -> pulumi.Output[Optional[bool]]:
        """
        This tells the provider to remove users added by this rule from the assigned
        group after destroying this resource. Default is `false`.
        """
        return pulumi.get(self, "remove_assigned_users")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        The status of the group rule.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of user IDs that would be excluded when rules are processed.
        """
        return pulumi.get(self, "users_excludeds")

