/* Stamen's website (http://maps.stamen.com) as of 2019-08-28 says that the
 * maps they host may be used free of charge.  For http access, use a url like
 * http://{s}.tile.stamen.com/toner-lite/{z}/{x}/{y}.png */
let StamenAttribution = 'Map tiles by <a href="http://stamen.com">Stamen ' +
  'Design</a>, under <a href="http://creativecommons.org/licenses/by/3.0">' +
  'CC BY 3.0</a>. Data by <a href="http://openstreetmap.org">OpenStreetMap' +
  '</a>, under <a href="http://www.openstreetmap.org/copyright">ODbL</a>.';

/* Per Carto's website regarding basemap attribution: https://carto.com/help/working-with-data/attribution/#basemaps */
let CartoAttribution = 'Map tiles by <a href="https://carto.com">Carto</a>, under CC BY 3.0. Data by <a href="https://www.openstreetmap.org/">OpenStreetMap</a>, under ODbL.'

// Create ProviderViewModel based on different imagery sources
// - these can be used without Cesium Ion
var imageryViewModels = [];

imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'OpenStreetMap',
  iconUrl: Cesium.buildModuleUrl('Widgets/Images/ImageryProviders/openStreetMap.png'),
  tooltip: 'OpenStreetMap (OSM) is a collaborative project to create a free editable \
map of the world.\nhttp://www.openstreetmap.org',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',
      subdomains: 'abc',
      minimumLevel: 0,
      maximumLevel: 19
    });
  }
}));
imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'Positron',
  tooltip: 'CartoDB Positron basemap',
  iconUrl: 'http://a.basemaps.cartocdn.com/light_all/5/15/12.png',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'http://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png',
      credit: CartoAttribution,
      minimumLevel: 0,
      maximumLevel: 18
    });
  }
}));
imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'Positron without labels',
  tooltip: 'CartoDB Positron without labels basemap',
  iconUrl: 'http://a.basemaps.cartocdn.com/rastertiles/light_nolabels/5/15/12.png',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'https://{s}.basemaps.cartocdn.com/rastertiles/light_nolabels/{z}/{x}/{y}.png',
      credit: CartoAttribution,
      minimumLevel: 0,
      maximumLevel: 18
    });
  }
}));
imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'Dark Matter',
  tooltip: 'CartoDB Dark Matter basemap',
  iconUrl: 'http://a.basemaps.cartocdn.com/rastertiles/dark_all/5/15/12.png',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'https://{s}.basemaps.cartocdn.com/rastertiles/dark_all/{z}/{x}/{y}.png',
      credit: CartoAttribution,
      minimumLevel: 0,
      maximumLevel: 18
    });
  }
}));
imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'Dark Matter without labels',
  tooltip: 'CartoDB Dark Matter without labels basemap',
  iconUrl: 'http://a.basemaps.cartocdn.com/rastertiles/dark_nolabels/5/15/12.png',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'https://{s}.basemaps.cartocdn.com/rastertiles/dark_nolabels/{z}/{x}/{y}.png',
      credit: CartoAttribution,
      minimumLevel: 0,
      maximumLevel: 18
    });
  }
}));
imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'Voyager',
  tooltip: 'CartoDB Voyager basemap',
  iconUrl: 'http://a.basemaps.cartocdn.com/rastertiles/voyager_labels_under/5/15/12.png',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'https://{s}.basemaps.cartocdn.com/rastertiles/voyager_labels_under/{z}/{x}/{y}.png',
      credit: CartoAttribution,
      minimumLevel: 0,
      maximumLevel: 18
    });
  }
}));
imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'Voyager without labels',
  tooltip: 'CartoDB Voyager without labels basemap',
  iconUrl: 'http://a.basemaps.cartocdn.com/rastertiles/voyager_nolabels/5/15/12.png',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'https://{s}.basemaps.cartocdn.com/rastertiles/voyager_nolabels/{z}/{x}/{y}.png',
      credit: CartoAttribution,
      minimumLevel: 0,
      maximumLevel: 18
    });
  }
}));
imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'National Map Satellite',
  iconUrl: 'https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryOnly/MapServer/tile/4/6/4',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryOnly/MapServer/tile/{z}/{y}/{x}',
      credit: 'Tile data from <a href="https://basemap.nationalmap.gov/">USGS</a>',
      minimumLevel: 0,
      maximumLevel: 16
    });
  }
}));
imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'Stamen Terrain',
  iconUrl: 'https://stamen-tiles-a.a.ssl.fastly.net/terrain/5/15/12.png',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'https://stamen-tiles-{s}.a.ssl.fastly.net/terrain/{z}/{x}/{y}.png',
      credit: StamenAttribution,
      subdomains: 'abcd',
      minimumLevel: 0,
      maximumLevel: 14
    });
  }
}));
imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'Stamen Terrain Background',
  iconUrl: 'https://stamen-tiles-a.a.ssl.fastly.net/terrain-background/5/15/12.png',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'https://stamen-tiles-{s}.a.ssl.fastly.net/terrain-background/{z}/{x}/{y}.png',
      credit: StamenAttribution,
      subdomains: 'abcd',
      minimumLevel: 0,
      maximumLevel: 14
    });
  }
}));
imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'Stamen Toner',
  iconUrl: 'https://stamen-tiles-a.a.ssl.fastly.net/toner/5/15/12.png',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'https://stamen-tiles-{s}.a.ssl.fastly.net/toner/{z}/{x}/{y}.png',
      credit: StamenAttribution,
      subdomains: 'abcd',
      minimumLevel: 0,
      maximumLevel: 14
    });
  }
}));
imageryViewModels.push(new Cesium.ProviderViewModel({
  name: 'Stamen Toner Lite',
  iconUrl: 'https://stamen-tiles-a.a.ssl.fastly.net/toner-lite/5/15/12.png',
  creationFunction: function() {
    return new Cesium.UrlTemplateImageryProvider({
      url: 'https://stamen-tiles-{s}.a.ssl.fastly.net/toner-lite/{z}/{x}/{y}.png',
      credit: StamenAttribution,
      subdomains: 'abcd',
      minimumLevel: 0,
      maximumLevel: 14
    });
  }
}));

// Initialize the viewer - this works without a token!
viewer = new Cesium.Viewer('cesiumContainer', {
  imageryProviderViewModels: imageryViewModels,
  selectedImageryProviderViewModel: imageryViewModels[8], // Terrain
  animation: false,
  timeline: false,
  infoBox: false,
  geocoder: false,
  fullscreenButton: false,
  selectionIndicator: false,
  terrainProvider: undefined,  //Cesium.Ion.defaultAccessToken ? Cesium.createWorldTerrain() : undefined,
  navigationInstructionsInitiallyVisible: false,
});
viewer.scene.fog.enabled = false;


// if no token, remove terrain
if (Cesium.Ion.defaultAccessToken === undefined) {
  // Remove the Terrain section of the baseLayerPicker
  viewer.baseLayerPicker.viewModel.terrainProviderViewModels.removeAll()
}
