import type { NormalModuleReplacementPlugin } from 'webpack';
export declare type ModuleFederationLibrary = {
    type: string;
    name: string;
};
export declare type WorkspaceLibrary = {
    name: string;
    root: string;
    importKey: string | undefined;
};
export declare type SharedWorkspaceLibraryConfig = {
    getAliases: () => Record<string, string>;
    getLibraries: (eager?: boolean) => Record<string, SharedLibraryConfig>;
    getReplacementPlugin: () => NormalModuleReplacementPlugin;
};
export declare type Remotes = string[] | [remoteName: string, remoteUrl: string][];
export interface SharedLibraryConfig {
    singleton?: boolean;
    strictVersion?: boolean;
    requiredVersion?: false | string;
    eager?: boolean;
}
export declare type SharedFunction = (libraryName: string, sharedConfig: SharedLibraryConfig) => undefined | false | SharedLibraryConfig;
export declare type AdditionalSharedConfig = Array<string | [libraryName: string, sharedConfig: SharedLibraryConfig] | {
    libraryName: string;
    sharedConfig: SharedLibraryConfig;
}>;
export interface ModuleFederationConfig {
    name: string;
    remotes?: Remotes;
    library?: ModuleFederationLibrary;
    exposes?: Record<string, string>;
    shared?: SharedFunction;
    additionalShared?: AdditionalSharedConfig;
}
export declare type WorkspaceLibrarySecondaryEntryPoint = {
    name: string;
    path: string;
};
