# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['workflow']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.27.1,<3.0.0', 'six>=1.16.0,<2.0.0']

setup_kwargs = {
    'name': 'alfred-workflow-tddschn',
    'version': '0.1.4',
    'description': 'Full-featured helper library for writing Alfred 2/3/4 workflows, with Python 3',
    'long_description': '\n<div align="center">\n  <img src="./icon.png" alt="alfred-workflow-tddschn logo" height="200">\n</div>\n\nNote: this is a fork of the amazing [https://github.com/deanishe/alfred-workflow][repo] and has some differences. \n\nalfred-workflow-tddschn\n===============\n\nA helper library in Python for authors of workflows for [Alfred 3 and 4][alfred].\n\n<!-- [![Build Status][shield-travis]][travis] -->\n[![Build Status][shield-github]][action-github]\n[![Coverage Status][shield-coveralls]][coveralls]\n[![Development Status][shield-status]][pypi]\n[![Latest Version][shield-version]][pypi]\n[![Supported Python Versions][shield-pyversions]][pypi]\n\n<!-- [![Downloads][shield-download]][pypi] -->\n\nSupports Alfred 3 and Alfred 4 on macOS 10.7+ (Python 3.7+).\n\nalfred-workflow-tddschn takes the grunt work out of writing a workflow by giving you the tools to create a fast and featureful Alfred workflow from an API, application or library in minutes.\n\nAlways supports all current Alfred features.\n\n\nFeatures\n--------\n\n- Auto-saved settings API for your workflow\n- Super-simple data caching with expiry\n- Fuzzy filtering (with smart diacritic folding)\n- Keychain support for secure storage of passwords, API keys etc.\n- Background tasks to keep your workflow responsive\n- Simple generation of Alfred JSON feedback\n- Full support of Alfred\'s AppleScript/JXA API\n- Catches and logs workflow errors for easier development and support\n- "Magic" arguments to help development/debugging\n- Unicode support\n- Pre-configured logging\n- Automatically check for workflow updates via GitHub releases\n- Post notifications via Notification Center\n\n\n### Alfred 4+ features ###\n\n- Advanced modifiers\n- Alfred 4-only updates (won\'t break older Alfred installs)\n\n\nContents\n--------\n\n\n- [alfred-workflow-tddschn](#alfred-workflow-tddschn)\n  - [Features](#features)\n    - [Alfred 4+ features](#alfred-4-features)\n  - [Contents](#contents)\n  - [Installation](#installation)\n    - [With pip](#with-pip)\n    - [From source](#from-source)\n  - [Usage](#usage)\n    - [Workflow script skeleton](#workflow-script-skeleton)\n    - [Examples](#examples)\n      - [Keychain access](#keychain-access)\n  - [Documentation](#documentation)\n    - [Dash docset](#dash-docset)\n  - [Licensing, thanks](#licensing-thanks)\n  - [Contributing](#contributing)\n    - [Adding a workflow to the list](#adding-a-workflow-to-the-list)\n    - [Bug reports, pull requests](#bug-reports-pull-requests)\n    - [Contributors](#contributors)\n  - [Workflows using alfred-workflow-tddschn](#workflows-using-alfred-workflow-tddschn)\n\n\n\n<a name="installation"></a>\nInstallation\n------------\n\n**Note**: If you\'re new to Alfred workflows, check out\n[the tutorial][docs-tutorial] in the docs.\n\n\n<a name="with-pip"></a>\n### With pip ###\n\nYou can install alfred-workflow-tddschn directly into your workflow with:\n\n```bash\n# from your workflow directory\npip install --target=. alfred-workflow-tddschn\n```\n\nYou can install any other library available on the [Cheese Shop][cheeseshop] the same way. See the [pip documentation][pip-docs] for more information.\n\nIt is highly advisable to bundle all your workflow\'s dependencies with your workflow in this way. That way, it will "just work".\n\n\n<a name="from-source"></a>\n### From source ###\n\n1. Download the `alfred-workflow-X.X.X.zip` from the [GitHub releases page][releases].\n2. Extract the ZIP archive and place the `workflow` directory in the root folder of your workflow (where `info.plist` is).\n\nYour workflow should look something like this:\n\n    Your Workflow/\n        info.plist\n        icon.png\n        workflow/\n            __init__.py\n            background.py\n            notify.py\n            Notify.tgz\n            update.py\n            version\n            workflow.py\n        yourscript.py\n        etc.\n\nAlternatively, you can clone/download the alfred-workflow-tddschn [repository][repo] and copy the `workflow` subdirectory to your workflow\'s root directory.\n\n\n<a name="usage"></a>\nUsage\n-----\n\nA few examples of how to use alfred-workflow-tddschn.\n\n\n<a name="workflow-script-skeleton"></a>\n### Workflow script skeleton ###\n\nSet up your workflow scripts as follows (if you wish to use the built-in error handling or `sys.path` modification):\n\n```python\n#!/usr/bin/python\n# encoding: utf-8\n\nimport sys\n\n# Workflow3 supports Alfred 3\'s new features. The `Workflow` class\n# is also compatible with Alfred 2.\nfrom workflow import Workflow3\n\n\ndef main(wf):\n    # The Workflow3 instance will be passed to the function\n    # you call from `Workflow3.run`.\n    # Not super useful, as the `wf` object created in\n    # the `if __name__ ...` clause below is global...\n    #\n    # Your imports go here if you want to catch import errors, which\n    # is not a bad idea, or if the modules/packages are in a directory\n    # added via `Workflow3(libraries=...)`\n    import somemodule\n    import anothermodule\n\n    # Get args from Workflow3, already in normalized Unicode.\n    # This is also necessary for "magic" arguments to work.\n    args = wf.args\n\n    # Do stuff here ...\n\n    # Add an item to Alfred feedback\n    wf.add_item(u\'Item title\', u\'Item subtitle\')\n\n    # Send output to Alfred. You can only call this once.\n    # Well, you *can* call it multiple times, but subsequent calls\n    # are ignored (otherwise the JSON sent to Alfred would be invalid).\n    wf.send_feedback()\n\n\nif __name__ == \'__main__\':\n    # Create a global `Workflow3` object\n    wf = Workflow3()\n    # Call your entry function via `Workflow3.run()` to enable its\n    # helper functions, like exception catching, ARGV normalization,\n    # magic arguments etc.\n    sys.exit(wf.run(main))\n```\n\n\n<a name="examples"></a>\n### Examples ###\n\nCache data for 30 seconds:\n\n```python\ndef get_web_data():\n    import json\n    from urllib import request\n    with request.urlopen(\'http://www.example.com\') as f:\n      data = f.read().decode(\'utf-8\')\n    return json.loads(data)\n\ndef main(wf):\n    # Save data from `get_web_data` for 30 seconds under\n    # the key ``example``\n    data = wf.cached_data(\'example\', get_web_data, max_age=30)\n    for datum in data:\n        wf.add_item(datum[\'title\'], datum[\'author\'])\n\n    wf.send_feedback()\n```\n\n<a name="keychain-access"></a>\n#### Keychain access ####\n\nSave password:\n\n```python\nwf = Workflow()\nwf.save_password(\'name of account\', \'password1lolz\')\n```\n\nRetrieve password:\n\n```python\nwf = Workflow()\nwf.get_password(\'name of account\')\n```\n\n\n<a name="documentation"></a>\nDocumentation\n-------------\n\nThe full documentation, including API docs and a tutorial, can be found at [deanishe.net][docs].\n\n\n<a name="dash-docset"></a>\n### Dash docset ###\n\nThe documentation is also available as a [Dash docset][dash].\n\n\n<a name="licensing-thanks"></a>\nLicensing, thanks\n-----------------\n\nThe code and the documentation are released under the MIT and [Creative Commons Attribution-NonCommercial][cc] Licenses respectively. See [License.txt](License.txt) for details.\n\nThe documentation was generated using [Sphinx][sphinx] and a modified version of the [Alabaster][alabaster] theme by [bitprophet][bitprophet].\n\nMany of the cooler ideas in alfred-workflow-tddschn were inspired by [Alfred2-Ruby-Template][ruby-template] by Zhaocai.\n\nThe Keychain parser was based on [Python-Keyring][python-keyring] by Jason R. Coombs.\n\n\n<a name="contributing"></a>\nContributing\n------------\n\n\n<a name="adding-a-workflow-to-the-list"></a>\n### Adding a workflow to the list ###\n\nIf you want to add a workflow to the [list of workflows using alfred-workflow-tddschn][docs-workflows], **don\'t add it to the docs!** The list is machine-generated from [Packal.org][packal] and the [`library_workflows.tsv`](extras/library_workflows.tsv) file. If your workflow is available on [Packal][packal], it will be added on the next update. If not, please add it to [`library_workflows.tsv`](extras/library_workflows.tsv), and submit a corresponding pull request.\n\nThe list is not auto-updated, so if you\'ve released a workflow and are keen to see it in this list, please [open an issue][issues] asking me to update the list.\n\n\n<a name="bug-reports-pull-requests"></a>\n### Bug reports, pull requests ###\n\nPlease see [the documentation][docs-contributing].\n\n\n<a name="contributors"></a>\n### Contributors ###\n\n- [Dean Jackson][deanishe]\n- [Stephen Margheim][smargh]\n- [Fabio Niephaus][fniephaus]\n- [Owen Min][owenwater]\n\n\n<a name="workflows-using-alfred-workflow"></a>\nWorkflows using alfred-workflow-tddschn\n-------------------------------\n\n[Here is a list][docs-workflows] of some of the many workflows based on alfred-workflow-tddschn.\n\n\n[alfred]: http://www.alfredapp.com/\n[alfred-workflow-scaffold]: https://github.com/NorthIsUp/alfred-workflow-scaffold\n[awv2]: https://github.com/tddschn/alfred-workflow-tddschn/tree/v2\n[alabaster]: https://github.com/bitprophet/alabaster\n[bitprophet]: https://github.com/bitprophet\n[cc]: https://creativecommons.org/licenses/by-nc/4.0/legalcode\n[coveralls]: https://coveralls.io/r/tddschn/alfred-workflow-tddschn?branch=master\n[deanishe]: https://github.com/deanishe\n[docs-contributing]: http://www.deanishe.net/alfred-workflow/contributing.html\n[docs-tutorial]: http://www.deanishe.net/alfred-workflow/tutorial.html\n[docs-api]: http://www.deanishe.net/alfred-workflow/api/\n[docs]: http://www.deanishe.net/alfred-workflow/\n[docs-workflows]: http://www.deanishe.net/alfred-workflow/aw-workflows.html\n[dash]: https://github.com/tddschn/alfred-workflow-tddschn/raw/master/docs/alfred-workflow-tddschn.docset.zip\n[fniephaus]: https://github.com/fniephaus\n[owenwater]: https://github.com/owenwater\n[issues]: https://github.com/tddschn/alfred-workflow-tddschn/issues\n[landscape]: https://landscape.io/github/tddschn/alfred-workflow-tddschn/master\n[packal]: http://www.packal.org/\n[pep8]: http://legacy.python.org/dev/peps/pep-0008/\n[pulls]: https://github.com/tddschn/alfred-workflow-tddschn/pulls\n[pypi]: https://pypi.python.org/pypi/alfred-workflow-tddschn/\n[releases]: https://github.com/tddschn/alfred-workflow-tddschn/releases\n[repo]: https://github.com/tddschn/alfred-workflow-tddschn\n[urllib]: https://docs.python.org/3/library/urllib.html\n[rtd]: https://readthedocs.org/\n[shield-coveralls]: https://coveralls.io/repos/github/tddschn/alfred-workflow-tddschn/badge.svg?branch=master\n[shield-docs]: https://readthedocs.org/projects/alfredworkflow/badge/?version=latest&style=flat\n[shield-download]: https://img.shields.io/pypi/dm/alfred-workflow-tddschn.svg?style=flat\n[shield-github]: https://github.com/tddschn/alfred-workflow-tddschn/workflows/CI/badge.svg\n[action-github]: https://github.com/tddschn/alfred-workflow-tddschn/actions?query=workflow%3ACI\n[shield-health]: https://landscape.io/github/tddschn/alfred-workflow-tddschn/master/landscape.png?style=flat\n[shield-License]: https://pypip.in/license/alfred-workflow-tddschn/badge.svg?style=flat\n[shield-status]: https://img.shields.io/pypi/status/alfred-workflow-tddschn.svg?style=flat\n[shield-travis]: https://travis-ci.org/tddschn/alfred-workflow-tddschn.svg?branch=master&style=flat\n[shield-version]: https://img.shields.io/pypi/v/alfred-workflow-tddschn.svg?style=flat\n[shield-pyversions]: https://img.shields.io/pypi/pyversions/alfred-workflow-tddschn.svg?style=flat\n[smargh]: https://github.com/smargh\n[sphinx]: http://sphinx-doc.org/\n[travis]: https://travis-ci.org/tddschn/alfred-workflow-tddschn\n[cheeseshop]: https://pypi.python.org/pypi\n[pip-docs]: https://pip.pypa.io/en/latest/\n[ruby-template]: http://zhaocai.github.io/alfred2-ruby-template/\n[python-keyring]: https://pypi.python.org/pypi/keyring\n',
    'author': 'Xinyuan Chen',
    'author_email': '45612704+tddschn@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/tddschn/alfred-workflow-py3',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
