# Generated by Django 4.0.4 on 2022-05-01 19:28

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import enumfields.fields
import medux.settings.definitions


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('common', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ScopedSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('namespace', models.CharField(max_length=25)),
                ('key', models.CharField(max_length=255)),
                ('value', models.CharField(max_length=255)),
                ('scope', enumfields.fields.EnumIntegerField(enum=medux.settings.definitions.Scope)),
                ('group', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='auth.group')),
                ('tenant', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='common.tenant', verbose_name='Tenant')),
                ('user', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Scoped settings',
                'verbose_name_plural': 'Scoped settings',
                'ordering': ['namespace', 'key', 'scope'],
                'permissions': [('change_own_user_settings', "Can change own user's scoped settings"), ('change_own_tenant_settings', "Can change own tenant's scoped settings"), ('change_group_settings', "Can change groups' scoped settings")],
                'unique_together': {('namespace', 'key', 'scope', 'user'), ('namespace', 'key', 'scope', 'group')},
            },
        ),
    ]
