# generated by datamodel-codegen:
#   filename:  openapi-lock.json

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import BaseModel, Field, PositiveInt, constr


class AppSpecId(BaseModel):
    app_spec_id: str = Field(..., title='App Spec Id')


class AppSubType(str, Enum):
    SESSION = 'SESSION'
    LABEL_STUDIO = 'LABEL_STUDIO'


class AppType(str, Enum):
    CUSTOM = 'CUSTOM'
    RUN = 'RUN'
    DEPLOYMENT = 'DEPLOYMENT'


class Auth0Metadata(BaseModel):
    auth0_domain: str = Field(..., title='Auth0 Domain')
    auth0_client_id: str = Field(..., title='Auth0 Client Id')


class AuthToken(BaseModel):
    token: str = Field(..., title='Token')
    token_type: Literal['bearer'] = Field(..., title='Token Type')
    user_id: str = Field(..., title='User Id')
    is_activated: bool = Field(..., title='Is Activated')


class BlobArtifact(BaseModel):
    blob_artifact_id: str = Field(..., title='Blob Artifact Id')
    created_at: datetime = Field(..., title='Created At')
    updated_at: datetime = Field(..., title='Updated At')
    bytes_hash: str = Field(..., title='Bytes Hash')
    bytes_size: int = Field(..., title='Bytes Size')
    tag: Optional[str] = Field(None, title='Tag')
    name: Optional[str] = Field(None, title='Name')


class BlobArtifactFile(BaseModel):
    path: str = Field(..., title='Path')
    is_directory: Optional[bool] = Field(False, title='Is Directory')
    path_prefix: Optional[str] = Field(None, title='Path Prefix')


class BlobArtifactId(BaseModel):
    blob_artifact_id: str = Field(..., title='Blob Artifact Id')


class BlobArtifactSignedURL(BaseModel):
    blob_artifact_id: str = Field(..., title='Blob Artifact Id')
    blob_artifact_name: str = Field(..., title='Blob Artifact Name')
    blob_filename: str = Field(..., title='Blob Filename')
    signed_url: str = Field(..., title='Signed Url')
    bytes_size: int = Field(..., title='Bytes Size')
    file_path: Optional[str] = Field(None, title='File Path')


class BlobArtifactUploadSignedURL(BaseModel):
    blob_artifact_id: str = Field(..., title='Blob Artifact Id')
    signed_url: str = Field(..., title='Signed Url')


class BodyAddUserToProject(BaseModel):
    username: str = Field(..., title='Username')


class BodyCreateVolume(BaseModel):
    name: str = Field(..., title='Name')


class BodyLoginToken(BaseModel):
    token: str = Field(..., title='Auth0 ID token')
    cli: Optional[bool] = Field(False, title='Cli')


class BodyNewProject(BaseModel):
    project_id: constr(
        regex=r'^[A-Za-z][A-Za-z0-9_-]*$', min_length=4, max_length=50
    ) = Field(
        ...,
        description='This is the unique name to be associated with your new project',
        title='Project ID',
    )
    display_name: constr(min_length=4, max_length=20) = Field(
        ...,
        description='An optional name for your project that will be shown in the UI',
        title='Display Name',
    )


class BodyPredictByName(BaseModel):
    example: bytes = Field(..., title='Example')


class BodyPutSecret(BaseModel):
    secret_value: constr(min_length=1, max_length=4096) = Field(
        ..., title='Secret Value'
    )


class BodySignup(BaseModel):
    signup_token: str = Field(..., title='Sign up token')


class BodyUpdateSourceCode(BaseModel):
    source_code_name: Optional[str] = Field(None, title='Source Code Name')
    description: Optional[str] = Field(None, title='Source Code Description')


class BodyUpdateSshPublicKey(BaseModel):
    ssh_public_key: str = Field(..., title='Ssh Public Key')


class CreateServiceAccountResponse(BaseModel):
    service_account_id: str = Field(..., title='Service Account Id')
    key: str = Field(..., title='Key')


class DeleteResult(str, Enum):
    NOT_FOUND = 'NOT_FOUND'
    DELETED = 'DELETED'


class DeploymentInstanceId(BaseModel):
    deployment_id: str = Field(..., title='Deployment Id')


class DownloadByNameMountSpecRequest(BaseModel):
    path: constr(regex=r'/mnt/(?!slingshot).+') = Field(
        ..., description='The path to mount into the environment.', title='Path'
    )
    mode: Literal['DOWNLOAD'] = Field(
        ..., description='The mode to use for the mount.', title='Mode'
    )
    name: str = Field(
        ...,
        description='The name of the asset to mount. Either name or tag should be set, but not both.',
        title='Name',
    )


class DownloadByTagMountSpecRequest(BaseModel):
    path: constr(regex=r'/mnt/(?!slingshot).+') = Field(
        ..., description='The path to mount into the environment.', title='Path'
    )
    mode: Literal['DOWNLOAD'] = Field(
        ..., description='The mode to use for the mount.', title='Mode'
    )
    tag: str = Field(
        ...,
        description='The artifact selector. If multiple matching artifacts contain the tag, the latest one will be used.  Either name or tag should be set, but not both.',
        title='Tag',
    )


class ErrorCode(str, Enum):
    unknown = 'unknown'
    invalid_signup_token = 'invalid_signup_token'
    username_already_taken = 'username_already_taken'
    deployment_not_deployed = 'deployment_not_deployed'
    app_already_started = 'app_already_started'
    app_already_exists = 'app_already_exists'
    app_is_deleted = 'app_is_deleted'
    exec_env_not_found = 'exec_env_not_found'
    volume_does_not_exist = 'volume_does_not_exist'
    volume_is_locked = 'volume_is_locked'
    volume_already_exists = 'volume_already_exists'
    volume_name_invalid = 'volume_name_invalid'
    artifact_is_unzipping = 'artifact_is_unzipping'
    entity_does_not_exist = 'entity_does_not_exist'
    multiple_gpus_not_allowed = 'multiple_gpus_not_allowed'


class EvaluateDeploymentBody(BaseModel):
    deployment_id: str = Field(..., title='Deployment Id')
    evaluation_deployment_id: Optional[str] = Field(
        None, title='Evaluation Deployment Id'
    )
    evaluation_test_set_id: str = Field(..., title='Evaluation Test Set Id')
    batch_size: Optional[int] = Field(None, title='Batch Size')


class EvaluationTestSetId(BaseModel):
    evaluation_test_set_id: str = Field(..., title='Evaluation Test Set Id')


class EvaluationTestSetResultId(BaseModel):
    evaluation_test_set_result_id: str = Field(
        ..., title='Evaluation Test Set Result Id'
    )


class ExecutionEnvironmentSpecId(BaseModel):
    execution_environment_spec_id: str = Field(
        ..., title='Execution Environment Spec Id'
    )


class GpuType(str, Enum):
    T4 = 'T4'
    L4 = 'L4'
    A100 = 'A100'
    CPU = 'CPU'


class HasAppInstanceId(BaseModel):
    app_instance_id: str = Field(..., title='App Instance Id')


class Healthcheck(BaseModel):
    db: Literal['OK'] = Field(..., title='Db')


class HttpErrorBody(BaseModel):
    error: str = Field(..., title='Error')


class LatencyQuantiles(BaseModel):
    count: int = Field(..., title='Count')
    p50: Optional[float] = Field(None, title='P50')
    p90: Optional[float] = Field(None, title='P90')
    p95: Optional[float] = Field(None, title='P95')
    p99: Optional[float] = Field(None, title='P99')


class LogLine(BaseModel):
    timestamp: datetime = Field(..., title='Timestamp')
    log: str = Field(..., title='Log')


class MachineSize(str, Enum):
    T4 = 'T4'
    L4 = 'L4'
    A100 = 'A100'
    A100_8X = 'A100_8X'
    CPU_1X = 'CPU_1X'
    CPU_2X = 'CPU_2X'
    CPU_4X = 'CPU_4X'
    CPU_8X = 'CPU_8X'


class MachineSpecs(BaseModel):
    cpu_request: str = Field(..., title='Cpu Request')
    memory_request: str = Field(..., title='Memory Request')
    gpu_request: int = Field(..., title='Gpu Request')
    cpu_limit: str = Field(..., title='Cpu Limit')
    memory_limit: str = Field(..., title='Memory Limit')
    gpu_limit: int = Field(..., title='Gpu Limit')
    gpu_type: Optional[GpuType] = 'CPU'


class MachineType(str, Enum):
    T4 = 'T4'
    L4 = 'L4'
    A100 = 'A100'
    CPU_TINY = 'CPU_TINY'
    CPU_SMALL = 'CPU_SMALL'
    CPU_MEDIUM = 'CPU_MEDIUM'
    CPU_LARGE = 'CPU_LARGE'


class OpenAIChatRequest(BaseModel):
    type: Optional[Literal['chat']] = Field('chat', title='Type')
    model: str = Field(..., title='Model')
    messages: List[Dict[str, str]] = Field(..., title='Messages')
    temperature: Optional[float] = Field(None, title='Temperature')
    top_p: Optional[float] = Field(None, title='Top P')
    n: Optional[int] = Field(None, title='N')
    stop: Optional[Union[str, List[str]]] = Field(None, title='Stop')
    max_tokens: Optional[int] = Field(None, title='Max Tokens')
    presence_penalty: Optional[float] = Field(None, title='Presence Penalty')
    frequency_penalty: Optional[float] = Field(None, title='Frequency Penalty')
    logit_bias: Optional[Dict[str, float]] = Field(None, title='Logit Bias')
    user: Optional[str] = Field(None, title='User')


class OpenAIChoice(BaseModel):
    index: int = Field(..., title='Index')
    message: Dict[str, str] = Field(..., title='Message')
    finish_reason: str = Field(..., title='Finish Reason')


class OpenAICompletionChoice(BaseModel):
    text: str = Field(..., title='Text')
    index: int = Field(..., title='Index')
    logprobs: Optional[Any] = Field(None, title='Logprobs')
    finish_reason: str = Field(..., title='Finish Reason')


class OpenAICompletionRequest(BaseModel):
    type: Optional[Literal['completion']] = Field('completion', title='Type')
    model: str = Field(..., title='Model')
    prompt: Optional[Union[str, List]] = Field(None, title='Prompt')
    suffix: Optional[str] = Field(None, title='Suffix')
    max_tokens: Optional[int] = Field(None, title='Max Tokens')
    temperature: Optional[float] = Field(None, title='Temperature')
    top_p: Optional[float] = Field(None, title='Top P')
    n: Optional[int] = Field(None, title='N')
    logprops: Optional[int] = Field(None, title='Logprops')
    echo: Optional[bool] = Field(None, title='Echo')
    stop: Optional[Union[str, List[str]]] = Field(None, title='Stop')
    presence_penalty: Optional[float] = Field(None, title='Presence Penalty')
    frequency_penalty: Optional[float] = Field(None, title='Frequency Penalty')
    best_of: Optional[int] = Field(None, title='Best Of')
    logit_bias: Optional[Dict[str, float]] = Field(None, title='Logit Bias')
    user: Optional[str] = Field(None, title='User')


class OpenAIEmbeddingObject(BaseModel):
    object: str = Field(..., title='Object')
    embedding: List[float] = Field(..., title='Embedding')
    index: int = Field(..., title='Index')


class OpenAIEmbeddingRequest(BaseModel):
    type: Optional[Literal['embedding']] = Field('embedding', title='Type')
    model: str = Field(..., title='Model')
    input: Union[str, List] = Field(..., title='Input')
    user: Optional[str] = Field(None, title='User')


class OpenAIUsage(BaseModel):
    prompt_tokens: int = Field(..., title='Prompt Tokens')
    completion_tokens: Optional[int] = Field(None, title='Completion Tokens')
    total_tokens: int = Field(..., title='Total Tokens')


class PriceData(BaseModel):
    cpu_credits_per_sec: float = Field(..., title='Cpu Credits Per Sec')
    mem_credits_per_sec: float = Field(..., title='Mem Credits Per Sec')
    gpu_credits_per_sec: float = Field(..., title='Gpu Credits Per Sec')


class ProjectId(BaseModel):
    project_id: str = Field(..., title='Project Id')


class PromptOpenAIBody(BaseModel):
    openai_request: Union[
        OpenAIChatRequest, OpenAICompletionRequest, OpenAIEmbeddingRequest
    ] = Field(..., discriminator='type', title='Openai Request')
    idempotence_key: Optional[constr(max_length=32)] = Field(
        None,
        description='If specified, the request will be idempotent. If a previous request with the same idempotence key is pending, the previous response will be returned instead of sending a new request to OpenAI. If absent, the request will be sent to OpenAI regardless of whether a previous request with the same parameters is pending.',
        title='Idempotence Key',
    )
    active_throttling: Optional[Union[bool, PositiveInt]] = Field(
        False,
        description='When enabled, slingshot throttles the request based on a token consumption estimate. This can be used to control token spend and minimise OpenAI rate-limiting. If an integer value is passed rather than True, the value is used as the maximum number of amortised tokens to spend per minute.',
        title='Active Throttling',
    )


class PutResult(str, Enum):
    CREATED = 'CREATED'
    UPDATED = 'UPDATED'
    NO_CHANGE = 'NO_CHANGE'


class RequestedAptPackage(BodyCreateVolume):
    pass


class Pin(str, Enum):
    field__ = '=='
    field_ = '@'
    field___1 = '>='
    field___2 = '<='
    field__1 = '>'
    field__2 = '<'
    field___3 = '~='


class RequestedRequirement(BaseModel):
    library: str = Field(..., title='Library')
    version: Optional[str] = Field(None, title='Version')
    pin: Optional[Pin] = Field(None, title='Pin')


class RunCreate(BaseModel):
    run_id: str = Field(..., title='Run Id')
    run_name: str = Field(..., title='Run Name')
    created_at: datetime = Field(..., title='Created At')


class ServiceAccountToken(BaseModel):
    token: str = Field(..., title='Token')
    service_account_id: str = Field(..., title='Service Account Id')


class SlingshotLogicalError(BaseModel):
    message: str = Field(..., title='Message')
    code: ErrorCode
    metadata: Dict[str, str] = Field(..., title='Metadata')


class SourceCode(BaseModel):
    source_code_id: str = Field(..., title='Source Code Id')
    source_code_name: str = Field(..., title='Source Code Name')
    description: Optional[str] = Field(None, title='Description')
    project_id: str = Field(..., title='Project Id')
    created_at: datetime = Field(..., title='Created At')
    blob_artifact: BlobArtifact


class SourceCodeResponse(BaseModel):
    data: Optional[SourceCode] = None
    error: Optional[SlingshotLogicalError] = None


class SshPort(BaseModel):
    ssh_port: int = Field(..., title='Ssh Port')


class SshPortResponse(BaseModel):
    data: Optional[SshPort] = None
    error: Optional[SlingshotLogicalError] = None


class StrResponse(BaseModel):
    data: Optional[str] = Field(None, title='Data')
    error: Optional[SlingshotLogicalError] = None


class UploadBlobArtifactBody(BaseModel):
    filename: str = Field(..., title='Filename')
    is_zipped_directory: bool = Field(..., title='Is Zipped Directory')
    tag: Optional[str] = Field(None, title='Tag')


class UploadMountSpecRequest(BaseModel):
    path: constr(regex=r'/mnt/(?!slingshot).+') = Field(
        ..., description='The path to mount into the environment.', title='Path'
    )
    mode: Literal['UPLOAD'] = Field(
        ..., description='The mode to use for the mount.', title='Mode'
    )
    tag: Optional[str] = Field(
        None, description='Optional tag to attach to the written artifact.', title='Tag'
    )


class UploadedSourceCode(BaseModel):
    source_code_id: str = Field(..., title='Source Code Id')
    source_code_name: str = Field(..., title='Source Code Name')


class UploadedSourceCodeResponse(BaseModel):
    data: Optional[UploadedSourceCode] = None
    error: Optional[SlingshotLogicalError] = None


class UsageRange(str, Enum):
    HOURLY = 'HOURLY'
    DAILY = 'DAILY'
    MONTHLY = 'MONTHLY'


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title='Location')
    msg: str = Field(..., title='Message')
    type: str = Field(..., title='Error Type')


class VolumeMountSpecRequest(BaseModel):
    path: constr(regex=r'/mnt/(?!slingshot).+') = Field(
        ..., description='The path to mount into the environment.', title='Path'
    )
    mode: Literal['VOLUME'] = Field(
        ..., description='The mode to use for the mount.', title='Mode'
    )
    name: str = Field(..., description='The name of the volume to mount.', title='Name')


class AppSpecIdResponse(BaseModel):
    data: Optional[AppSpecId] = None
    error: Optional[SlingshotLogicalError] = None


class Auth0MetadataResponse(BaseModel):
    data: Optional[Auth0Metadata] = None
    error: Optional[SlingshotLogicalError] = None


class AuthTokenResponse(BaseModel):
    data: Optional[AuthToken] = None
    error: Optional[SlingshotLogicalError] = None


class BlobArtifactIdResponse(BaseModel):
    data: Optional[BlobArtifactId] = None
    error: Optional[SlingshotLogicalError] = None


class BlobArtifactSignedURLManyResponse(BaseModel):
    data: Optional[List[BlobArtifactSignedURL]] = Field(None, title='Data')
    error: Optional[SlingshotLogicalError] = None


class BlobArtifactSignedURLResponse(BaseModel):
    data: Optional[BlobArtifactSignedURL] = None
    error: Optional[SlingshotLogicalError] = None


class BlobArtifactUploadSignedURLResponse(BaseModel):
    data: Optional[BlobArtifactUploadSignedURL] = None
    error: Optional[SlingshotLogicalError] = None


class BoolResponse(BaseModel):
    data: Optional[bool] = Field(None, title='Data')
    error: Optional[SlingshotLogicalError] = None


class CreateAppBody(BaseModel):
    name: str = Field(..., title='Name')
    command: Optional[str] = Field(None, title='Command')
    exec_env_spec_id: str = Field(..., title='Exec Env Spec Id')
    machine_size: MachineSize
    attach_project_credentials: bool = Field(..., title='Attach Project Credentials')
    mounts: List[
        Union[
            DownloadByNameMountSpecRequest,
            DownloadByTagMountSpecRequest,
            UploadMountSpecRequest,
            VolumeMountSpecRequest,
        ]
    ] = Field(..., title='Mounts')
    config_variables: Optional[Dict[str, Any]] = Field(None, title='Config Variables')
    app_port: Optional[int] = Field(None, title='App Port')
    batch_size: Optional[PositiveInt] = Field(None, title='Batch Size')
    batch_interval: Optional[PositiveInt] = Field(None, title='Batch Interval')
    soft_concurrency: Optional[PositiveInt] = Field(None, title='Soft Concurrency')
    app_type: AppType
    app_sub_type: Optional[AppSubType] = None


class CreateEnvironmentSpecResponse(BaseModel):
    data: Optional[List[Union[ExecutionEnvironmentSpecId, bool]]] = Field(
        None, max_items=2, min_items=2, title='Data'
    )
    error: Optional[SlingshotLogicalError] = None


class CreateServiceAccountResponseResponse(BaseModel):
    data: Optional[CreateServiceAccountResponse] = None
    error: Optional[SlingshotLogicalError] = None


class DeleteResultResponse(BaseModel):
    data: Optional[DeleteResult] = None
    error: Optional[SlingshotLogicalError] = None


class DeploymentInstanceIdResponse(BaseModel):
    data: Optional[DeploymentInstanceId] = None
    error: Optional[SlingshotLogicalError] = None


class EvaluationTestSetIdResponse(BaseModel):
    data: Optional[EvaluationTestSetId] = None
    error: Optional[SlingshotLogicalError] = None


class EvaluationTestSetResultIdResponse(BaseModel):
    data: Optional[EvaluationTestSetResultId] = None
    error: Optional[SlingshotLogicalError] = None


class ExecutionEnvironmentSpecRequestBody(BaseModel):
    name: str = Field(..., description='Name of the environment.', title='Name')
    python_packages: List[RequestedRequirement] = Field(
        ...,
        description='List of Python packages to install in the environment.',
        title='Python packages',
    )
    apt_packages: List[RequestedAptPackage] = Field(
        ...,
        description='List of APT packages to install in the environment.',
        title='APT packages',
    )
    gpu_drivers: bool = Field(
        ...,
        description='Flag to install GPU drivers in the environment.',
        title='GPU Drivers',
    )
    force_create_environment: Optional[bool] = Field(
        False,
        description='Whether to require that a new environment be created. Otherwise, an existing environment will be used if it is compatible.',
        title='Force Create Environment',
    )


class GpuCountMachineSize(BaseModel):
    gpu_count: int = Field(..., title='Gpu Count')
    machine_size: MachineSize
    specs: MachineSpecs
    machine_costs: PriceData


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title='Detail')


class HasAppInstanceIdResponse(BaseModel):
    data: Optional[HasAppInstanceId] = None
    error: Optional[SlingshotLogicalError] = None


class HealthcheckResponse(BaseModel):
    data: Optional[Healthcheck] = None
    error: Optional[SlingshotLogicalError] = None


class ListBlobArtifactFilesResponse(BaseModel):
    data: Optional[List[BlobArtifactFile]] = Field(None, title='Data')
    error: Optional[SlingshotLogicalError] = None


class LogsResponse(BaseModel):
    data: Optional[List[LogLine]] = Field(None, title='Data')
    error: Optional[SlingshotLogicalError] = None


class MachineTypeDetails(BaseModel):
    display_name: str = Field(..., title='Display Name')
    gpu_count_machine_sizes: List[GpuCountMachineSize] = Field(
        ..., title='Gpu Count Machine Sizes'
    )
    vram_gb: Optional[int] = Field(0, title='Vram Gb')
    gpu_type: Optional[GpuType] = 'CPU'
    replaced_by: Optional[str] = Field(None, title='Replaced By')


class MachineTypeListItem(BaseModel):
    name: MachineType
    details: MachineTypeDetails


class OpenAIChatResponse(BaseModel):
    id: str = Field(..., title='Id')
    object: str = Field(..., title='Object')
    created: int = Field(..., title='Created')
    choices: List[OpenAIChoice] = Field(..., title='Choices')
    usage: OpenAIUsage


class OpenAICompletionResponse(BaseModel):
    id: str = Field(..., title='Id')
    object: str = Field(..., title='Object')
    created: int = Field(..., title='Created')
    model: str = Field(..., title='Model')
    choices: List[OpenAICompletionChoice] = Field(..., title='Choices')
    usage: OpenAIUsage


class OpenAIEmbeddingResponse(BaseModel):
    object: str = Field(..., title='Object')
    data: List[OpenAIEmbeddingObject] = Field(..., title='Data')
    model: str = Field(..., title='Model')
    usage: OpenAIUsage


class OpenAIResponse(BaseModel):
    data: Optional[
        Union[OpenAIEmbeddingResponse, OpenAIChatResponse, OpenAICompletionResponse]
    ] = Field(None, title='Data')
    error: Optional[SlingshotLogicalError] = None


class PredictionResponse(BaseModel):
    data: Optional[Dict[str, Any]] = Field(None, title='Data')
    error: Optional[SlingshotLogicalError] = None


class ProjectIdResponse(BaseModel):
    data: Optional[ProjectId] = None
    error: Optional[SlingshotLogicalError] = None


class PutResultResponse(BaseModel):
    data: Optional[PutResult] = None
    error: Optional[SlingshotLogicalError] = None


class ResponseOK(BaseModel):
    data: Optional[Literal['OK']] = Field('OK', title='Data')
    error: Optional[SlingshotLogicalError] = None


class RunCreateResponse(BaseModel):
    data: Optional[RunCreate] = None
    error: Optional[SlingshotLogicalError] = None


class ServiceAccountTokenResponse(BaseModel):
    data: Optional[ServiceAccountToken] = None
    error: Optional[SlingshotLogicalError] = None


class StartAppBody(BaseModel):
    machine_size: MachineSize
    config_variables: Optional[Dict[str, Any]] = Field(None, title='Config Variables')
    mounts: List[
        Union[
            DownloadByNameMountSpecRequest,
            DownloadByTagMountSpecRequest,
            UploadMountSpecRequest,
            VolumeMountSpecRequest,
        ]
    ] = Field(..., title='Mounts')
    exec_env_id: str = Field(..., title='Exec Env Id')
    cmd: str = Field(..., description='Command to run', title='Cmd')
    attach_project_credentials: bool = Field(..., title='Attach Project Credentials')
    source_code_id: Optional[str] = Field(None, title='Source Code Id')
    app_port: Optional[int] = Field(None, title='App Port')


class StartDeploymentBody(BaseModel):
    machine_size: MachineSize
    config_variables: Optional[Dict[str, Any]] = Field(None, title='Config Variables')
    mounts: List[
        Union[
            DownloadByNameMountSpecRequest,
            DownloadByTagMountSpecRequest,
            UploadMountSpecRequest,
            VolumeMountSpecRequest,
        ]
    ] = Field(..., title='Mounts')
    exec_env_id: str = Field(..., title='Exec Env Id')
    cmd: str = Field(..., description='Command to run', title='Cmd')
    attach_project_credentials: bool = Field(..., title='Attach Project Credentials')
    source_code_id: str = Field(..., title='Source Code Id')
    batch_size: Optional[PositiveInt] = Field(None, title='Batch Size')
    batch_interval: Optional[PositiveInt] = Field(None, title='Batch Interval')


class StartRunBody(BaseModel):
    machine_size: MachineSize
    config_variables: Optional[Dict[str, Any]] = Field(None, title='Config Variables')
    mounts: List[
        Union[
            DownloadByNameMountSpecRequest,
            DownloadByTagMountSpecRequest,
            UploadMountSpecRequest,
            VolumeMountSpecRequest,
        ]
    ] = Field(..., title='Mounts')
    exec_env_id: str = Field(..., title='Exec Env Id')
    cmd: str = Field(..., description='Command to run', title='Cmd')
    attach_project_credentials: bool = Field(..., title='Attach Project Credentials')
    source_code_id: str = Field(..., title='Source Code Id')


class UpdateAppBody(BaseModel):
    name: Optional[str] = Field(None, title='Name')
    command: Optional[str] = Field(None, title='Command')
    exec_env_spec_id: str = Field(..., title='Exec Env Spec Id')
    machine_size: MachineSize
    attach_project_credentials: bool = Field(..., title='Attach Project Credentials')
    mounts: List[
        Union[
            DownloadByNameMountSpecRequest,
            DownloadByTagMountSpecRequest,
            UploadMountSpecRequest,
            VolumeMountSpecRequest,
        ]
    ] = Field(..., title='Mounts')
    config_variables: Optional[Dict[str, Any]] = Field(None, title='Config Variables')
    app_port: Optional[int] = Field(None, title='App Port')
    batch_size: Optional[PositiveInt] = Field(None, title='Batch Size')
    batch_interval: Optional[PositiveInt] = Field(None, title='Batch Interval')
    soft_concurrency: Optional[PositiveInt] = Field(None, title='Soft Concurrency')


class UsageBinsLatencyQuantiles(BaseModel):
    bins_start: List[datetime] = Field(..., title='Start time of each bin')
    usage_range: UsageRange = Field(..., title='Range of each bin')
    data: List[LatencyQuantiles] = Field(..., title='Data values of each bin')


class UsageBinsLatencyQuantilesResponse(BaseModel):
    data: Optional[UsageBinsLatencyQuantiles] = None
    error: Optional[SlingshotLogicalError] = None
