"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhoneAssociation = exports.ChimeResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/* eslint-disable @typescript-eslint/indent */
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const cr = require("aws-cdk-lib/custom-resources");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class ChimeResources extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambda = this.ensureLambda();
        const ChimeResourceProvider = new cr.Provider(this, 'ChimeResourceProvider', {
            onEventHandler: this.lambda,
        });
        this.chimeCustomResource = new aws_cdk_lib_1.CustomResource(this, 'ChimeCustomResource', {
            serviceToken: ChimeResourceProvider.serviceToken,
            properties: { ...props },
        });
    }
    ensureLambda() {
        const stack = cdk.Stack.of(this);
        const constructName = 'ChimeResources';
        const existing = stack.node.tryFindChild(constructName);
        if (existing) {
            return existing;
        }
        const chimeCustomResourceRole = new iam.Role(this, 'ChimeResourcesRole', {
            description: 'Chime Resources',
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            inlinePolicies: {
                ['chimePolicy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'chime:CreateSipRule',
                                'chime:DeleteSipRule',
                                'chime:UpdateSipRule',
                                'chime:GetSipRule',
                                'chime:CreateSipMediaApplication',
                                'chime:DeleteSipMediaApplication',
                                'chime:GetPhoneNumberOrder',
                                'chime:SearchAvailablePhoneNumbers',
                                'chime:CreatePhoneNumberOrder',
                                'chime:DeletePhoneNumber',
                                'chime:GetPhoneNumber',
                                'chime:CreateVoiceConnector',
                                'chime:PutVoiceConnectorStreamingConfiguration',
                                'chime:PutVoiceConnectorTermination',
                                'chime:PutVoiceConnectorOrigination',
                                'chime:ListPhoneNumbers',
                                'chime:AssociatePhoneNumbersWithVoiceConnector',
                                'chime:DisassociatePhoneNumbersFromVoiceConnector',
                                'chime:DeleteVoiceConnector',
                                'lambda:GetPolicy',
                                'lambda:AddPermission',
                                'iam:PutRolePolicy',
                                'iam:CreateServiceLinkedRole',
                            ],
                        }),
                        new iam.PolicyStatement({
                            resources: [
                                `arn:aws:ssm:${stack.region}:${stack.account}:parameter/chime/*`,
                            ],
                            actions: [
                                'ssm:PutParameter',
                                'ssm:GetParameter',
                                'ssm:DeleteParameter',
                            ],
                        }),
                    ],
                }),
            },
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const fn = new lambda.Function(stack, constructName, {
            runtime: lambda.Runtime.PYTHON_3_9,
            code: lambda.Code.fromAsset(path.join(__dirname, '../resources')),
            handler: 'index.handler',
            architecture: lambda.Architecture.ARM_64,
            role: chimeCustomResourceRole,
            timeout: cdk.Duration.minutes(1),
        });
        return fn;
    }
}
exports.ChimeResources = ChimeResources;
_a = JSII_RTTI_SYMBOL_1;
ChimeResources[_a] = { fqn: "cdk-amazon-chime-resources.ChimeResources", version: "0.0.8" };
class PhoneAssociation extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.phoneAssociationResource = new custom_resources_1.AwsCustomResource(this, 'phoneAssociation', {
            onCreate: {
                service: 'Chime',
                action: 'associatePhoneNumbersWithVoiceConnector',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                    ForceAssociate: true,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(cdk.Names.uniqueId(this)),
            },
            onDelete: {
                service: 'Chime',
                action: 'disassociatePhoneNumbersFromVoiceConnector',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(cdk.Names.uniqueId(this)),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
}
exports.PhoneAssociation = PhoneAssociation;
_b = JSII_RTTI_SYMBOL_1;
PhoneAssociation[_b] = { fqn: "cdk-amazon-chime-resources.PhoneAssociation", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,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