<a id="mypy-boto3-ec2"></a>

# mypy-boto3-ec2

[![PyPI - mypy-boto3-ec2](https://img.shields.io/pypi/v/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-ec2?color=blue)](https://pypistats.org/packages/mypy-boto3-ec2)

![boto3.typed](https://github.com/youtype/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3.EC2 1.24.14](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/ec2.html#EC2)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 7.7.1](https://github.com/youtype/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ec2 docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ec2/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/youtype/mypy_boto3_builder/raw/main/demo.gif)

- [mypy-boto3-ec2](#mypy-boto3-ec2)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
    - [From conda-forge](#from-conda-forge)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [How it works](#how-it-works)
  - [What's new](#what's-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
  - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `EC2`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `EC2` service.

```bash
# install with boto3 type annotations
python -m pip install 'boto3-stubs[ec2]'


# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'boto3-stubs-lite[ec2]'


# standalone installation
python -m pip install mypy-boto3-ec2
```

<a id="from-conda-forge"></a>

### From conda-forge

Installing `mypy-boto3-ec2` from the `conda-forge` channel can be achieved by
adding `conda-forge` to your channels with:

```bash
conda config --add channels conda-forge
conda config --set channel_priority strict
```

Once the `conda-forge` channel has been enabled, `mypy-boto3-ec2` can be
installed with:

```bash
conda install mypy-boto3-ec2
```

It is possible to list all of the versions of `mypy-boto3-ec2` available on
your platform with:

```bash
conda search mypy-boto3-ec2 --channel conda-forge
```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
python -m pip uninstall -y mypy-boto3-ec2
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs[ec2]` in your environment:

```bash
python -m pip install 'boto3-stubs[ec2]'
```

Both type checking and code completion should now work. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

Install `boto3-stubs-lite[ec2]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[ec2]'`
```

Both type checking and code completion should now work. Explicit type
annotations **are required**.

Use `boto3-stubs` package instead for implicit type discovery.

<a id="emacs"></a>

### Emacs

- Install `boto3-stubs` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[ec2]'
```

- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed `boto3-stubs`

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="sublime-text"></a>

### Sublime Text

- Install `boto3-stubs[ec2]` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[ec2]'
```

- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs[ec2]` in your environment:

```bash
python -m pip install 'boto3-stubs[ec2]'`
```

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `npm i -g pyright`
- Install `boto3-stubs[ec2]` in your environment:

```bash
python -m pip install 'boto3-stubs[ec2]'
```

Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`EC2Client` provides annotations for `boto3.client("ec2")`.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2Client

client: EC2Client = Session().client("ec2")

# now client usage is checked by mypy and IDE should provide code completion
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_ec2.paginator` module contains type annotations for all paginators.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2Client
from mypy_boto3_ec2.paginator import (
    DescribeAddressesAttributePaginator,
    DescribeByoipCidrsPaginator,
    DescribeCapacityReservationFleetsPaginator,
    DescribeCapacityReservationsPaginator,
    DescribeCarrierGatewaysPaginator,
    DescribeClassicLinkInstancesPaginator,
    DescribeClientVpnAuthorizationRulesPaginator,
    DescribeClientVpnConnectionsPaginator,
    DescribeClientVpnEndpointsPaginator,
    DescribeClientVpnRoutesPaginator,
    DescribeClientVpnTargetNetworksPaginator,
    DescribeCoipPoolsPaginator,
    DescribeDhcpOptionsPaginator,
    DescribeEgressOnlyInternetGatewaysPaginator,
    DescribeExportImageTasksPaginator,
    DescribeFastLaunchImagesPaginator,
    DescribeFastSnapshotRestoresPaginator,
    DescribeFleetsPaginator,
    DescribeFlowLogsPaginator,
    DescribeFpgaImagesPaginator,
    DescribeHostReservationOfferingsPaginator,
    DescribeHostReservationsPaginator,
    DescribeHostsPaginator,
    DescribeIamInstanceProfileAssociationsPaginator,
    DescribeImportImageTasksPaginator,
    DescribeImportSnapshotTasksPaginator,
    DescribeInstanceCreditSpecificationsPaginator,
    DescribeInstanceEventWindowsPaginator,
    DescribeInstanceStatusPaginator,
    DescribeInstanceTypeOfferingsPaginator,
    DescribeInstanceTypesPaginator,
    DescribeInstancesPaginator,
    DescribeInternetGatewaysPaginator,
    DescribeIpamPoolsPaginator,
    DescribeIpamScopesPaginator,
    DescribeIpamsPaginator,
    DescribeIpv6PoolsPaginator,
    DescribeLaunchTemplateVersionsPaginator,
    DescribeLaunchTemplatesPaginator,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator,
    DescribeLocalGatewayRouteTableVpcAssociationsPaginator,
    DescribeLocalGatewayRouteTablesPaginator,
    DescribeLocalGatewayVirtualInterfaceGroupsPaginator,
    DescribeLocalGatewayVirtualInterfacesPaginator,
    DescribeLocalGatewaysPaginator,
    DescribeManagedPrefixListsPaginator,
    DescribeMovingAddressesPaginator,
    DescribeNatGatewaysPaginator,
    DescribeNetworkAclsPaginator,
    DescribeNetworkInsightsAccessScopeAnalysesPaginator,
    DescribeNetworkInsightsAccessScopesPaginator,
    DescribeNetworkInsightsAnalysesPaginator,
    DescribeNetworkInsightsPathsPaginator,
    DescribeNetworkInterfacePermissionsPaginator,
    DescribeNetworkInterfacesPaginator,
    DescribePrefixListsPaginator,
    DescribePrincipalIdFormatPaginator,
    DescribePublicIpv4PoolsPaginator,
    DescribeReplaceRootVolumeTasksPaginator,
    DescribeReservedInstancesModificationsPaginator,
    DescribeReservedInstancesOfferingsPaginator,
    DescribeRouteTablesPaginator,
    DescribeScheduledInstanceAvailabilityPaginator,
    DescribeScheduledInstancesPaginator,
    DescribeSecurityGroupRulesPaginator,
    DescribeSecurityGroupsPaginator,
    DescribeSnapshotTierStatusPaginator,
    DescribeSnapshotsPaginator,
    DescribeSpotFleetInstancesPaginator,
    DescribeSpotFleetRequestsPaginator,
    DescribeSpotInstanceRequestsPaginator,
    DescribeSpotPriceHistoryPaginator,
    DescribeStaleSecurityGroupsPaginator,
    DescribeStoreImageTasksPaginator,
    DescribeSubnetsPaginator,
    DescribeTagsPaginator,
    DescribeTrafficMirrorFiltersPaginator,
    DescribeTrafficMirrorSessionsPaginator,
    DescribeTrafficMirrorTargetsPaginator,
    DescribeTransitGatewayAttachmentsPaginator,
    DescribeTransitGatewayConnectPeersPaginator,
    DescribeTransitGatewayConnectsPaginator,
    DescribeTransitGatewayMulticastDomainsPaginator,
    DescribeTransitGatewayPeeringAttachmentsPaginator,
    DescribeTransitGatewayRouteTablesPaginator,
    DescribeTransitGatewayVpcAttachmentsPaginator,
    DescribeTransitGatewaysPaginator,
    DescribeTrunkInterfaceAssociationsPaginator,
    DescribeVolumeStatusPaginator,
    DescribeVolumesPaginator,
    DescribeVolumesModificationsPaginator,
    DescribeVpcClassicLinkDnsSupportPaginator,
    DescribeVpcEndpointConnectionNotificationsPaginator,
    DescribeVpcEndpointConnectionsPaginator,
    DescribeVpcEndpointServiceConfigurationsPaginator,
    DescribeVpcEndpointServicePermissionsPaginator,
    DescribeVpcEndpointServicesPaginator,
    DescribeVpcEndpointsPaginator,
    DescribeVpcPeeringConnectionsPaginator,
    DescribeVpcsPaginator,
    GetAssociatedIpv6PoolCidrsPaginator,
    GetGroupsForCapacityReservationPaginator,
    GetInstanceTypesFromInstanceRequirementsPaginator,
    GetIpamAddressHistoryPaginator,
    GetIpamPoolAllocationsPaginator,
    GetIpamPoolCidrsPaginator,
    GetIpamResourceCidrsPaginator,
    GetManagedPrefixListAssociationsPaginator,
    GetManagedPrefixListEntriesPaginator,
    GetSpotPlacementScoresPaginator,
    GetTransitGatewayAttachmentPropagationsPaginator,
    GetTransitGatewayMulticastDomainAssociationsPaginator,
    GetTransitGatewayPrefixListReferencesPaginator,
    GetTransitGatewayRouteTableAssociationsPaginator,
    GetTransitGatewayRouteTablePropagationsPaginator,
    GetVpnConnectionDeviceTypesPaginator,
    ListImagesInRecycleBinPaginator,
    ListSnapshotsInRecycleBinPaginator,
    SearchLocalGatewayRoutesPaginator,
    SearchTransitGatewayMulticastGroupsPaginator,
)

client: EC2Client = Session().client("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_addresses_attribute_paginator: DescribeAddressesAttributePaginator = client.get_paginator("describe_addresses_attribute")
describe_byoip_cidrs_paginator: DescribeByoipCidrsPaginator = client.get_paginator("describe_byoip_cidrs")
describe_capacity_reservation_fleets_paginator: DescribeCapacityReservationFleetsPaginator = client.get_paginator("describe_capacity_reservation_fleets")
describe_capacity_reservations_paginator: DescribeCapacityReservationsPaginator = client.get_paginator("describe_capacity_reservations")
describe_carrier_gateways_paginator: DescribeCarrierGatewaysPaginator = client.get_paginator("describe_carrier_gateways")
describe_classic_link_instances_paginator: DescribeClassicLinkInstancesPaginator = client.get_paginator("describe_classic_link_instances")
describe_client_vpn_authorization_rules_paginator: DescribeClientVpnAuthorizationRulesPaginator = client.get_paginator("describe_client_vpn_authorization_rules")
describe_client_vpn_connections_paginator: DescribeClientVpnConnectionsPaginator = client.get_paginator("describe_client_vpn_connections")
describe_client_vpn_endpoints_paginator: DescribeClientVpnEndpointsPaginator = client.get_paginator("describe_client_vpn_endpoints")
describe_client_vpn_routes_paginator: DescribeClientVpnRoutesPaginator = client.get_paginator("describe_client_vpn_routes")
describe_client_vpn_target_networks_paginator: DescribeClientVpnTargetNetworksPaginator = client.get_paginator("describe_client_vpn_target_networks")
describe_coip_pools_paginator: DescribeCoipPoolsPaginator = client.get_paginator("describe_coip_pools")
describe_dhcp_options_paginator: DescribeDhcpOptionsPaginator = client.get_paginator("describe_dhcp_options")
describe_egress_only_internet_gateways_paginator: DescribeEgressOnlyInternetGatewaysPaginator = client.get_paginator("describe_egress_only_internet_gateways")
describe_export_image_tasks_paginator: DescribeExportImageTasksPaginator = client.get_paginator("describe_export_image_tasks")
describe_fast_launch_images_paginator: DescribeFastLaunchImagesPaginator = client.get_paginator("describe_fast_launch_images")
describe_fast_snapshot_restores_paginator: DescribeFastSnapshotRestoresPaginator = client.get_paginator("describe_fast_snapshot_restores")
describe_fleets_paginator: DescribeFleetsPaginator = client.get_paginator("describe_fleets")
describe_flow_logs_paginator: DescribeFlowLogsPaginator = client.get_paginator("describe_flow_logs")
describe_fpga_images_paginator: DescribeFpgaImagesPaginator = client.get_paginator("describe_fpga_images")
describe_host_reservation_offerings_paginator: DescribeHostReservationOfferingsPaginator = client.get_paginator("describe_host_reservation_offerings")
describe_host_reservations_paginator: DescribeHostReservationsPaginator = client.get_paginator("describe_host_reservations")
describe_hosts_paginator: DescribeHostsPaginator = client.get_paginator("describe_hosts")
describe_iam_instance_profile_associations_paginator: DescribeIamInstanceProfileAssociationsPaginator = client.get_paginator("describe_iam_instance_profile_associations")
describe_import_image_tasks_paginator: DescribeImportImageTasksPaginator = client.get_paginator("describe_import_image_tasks")
describe_import_snapshot_tasks_paginator: DescribeImportSnapshotTasksPaginator = client.get_paginator("describe_import_snapshot_tasks")
describe_instance_credit_specifications_paginator: DescribeInstanceCreditSpecificationsPaginator = client.get_paginator("describe_instance_credit_specifications")
describe_instance_event_windows_paginator: DescribeInstanceEventWindowsPaginator = client.get_paginator("describe_instance_event_windows")
describe_instance_status_paginator: DescribeInstanceStatusPaginator = client.get_paginator("describe_instance_status")
describe_instance_type_offerings_paginator: DescribeInstanceTypeOfferingsPaginator = client.get_paginator("describe_instance_type_offerings")
describe_instance_types_paginator: DescribeInstanceTypesPaginator = client.get_paginator("describe_instance_types")
describe_instances_paginator: DescribeInstancesPaginator = client.get_paginator("describe_instances")
describe_internet_gateways_paginator: DescribeInternetGatewaysPaginator = client.get_paginator("describe_internet_gateways")
describe_ipam_pools_paginator: DescribeIpamPoolsPaginator = client.get_paginator("describe_ipam_pools")
describe_ipam_scopes_paginator: DescribeIpamScopesPaginator = client.get_paginator("describe_ipam_scopes")
describe_ipams_paginator: DescribeIpamsPaginator = client.get_paginator("describe_ipams")
describe_ipv6_pools_paginator: DescribeIpv6PoolsPaginator = client.get_paginator("describe_ipv6_pools")
describe_launch_template_versions_paginator: DescribeLaunchTemplateVersionsPaginator = client.get_paginator("describe_launch_template_versions")
describe_launch_templates_paginator: DescribeLaunchTemplatesPaginator = client.get_paginator("describe_launch_templates")
describe_local_gateway_route_table_virtual_interface_group_associations_paginator: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_virtual_interface_group_associations")
describe_local_gateway_route_table_vpc_associations_paginator: DescribeLocalGatewayRouteTableVpcAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_vpc_associations")
describe_local_gateway_route_tables_paginator: DescribeLocalGatewayRouteTablesPaginator = client.get_paginator("describe_local_gateway_route_tables")
describe_local_gateway_virtual_interface_groups_paginator: DescribeLocalGatewayVirtualInterfaceGroupsPaginator = client.get_paginator("describe_local_gateway_virtual_interface_groups")
describe_local_gateway_virtual_interfaces_paginator: DescribeLocalGatewayVirtualInterfacesPaginator = client.get_paginator("describe_local_gateway_virtual_interfaces")
describe_local_gateways_paginator: DescribeLocalGatewaysPaginator = client.get_paginator("describe_local_gateways")
describe_managed_prefix_lists_paginator: DescribeManagedPrefixListsPaginator = client.get_paginator("describe_managed_prefix_lists")
describe_moving_addresses_paginator: DescribeMovingAddressesPaginator = client.get_paginator("describe_moving_addresses")
describe_nat_gateways_paginator: DescribeNatGatewaysPaginator = client.get_paginator("describe_nat_gateways")
describe_network_acls_paginator: DescribeNetworkAclsPaginator = client.get_paginator("describe_network_acls")
describe_network_insights_access_scope_analyses_paginator: DescribeNetworkInsightsAccessScopeAnalysesPaginator = client.get_paginator("describe_network_insights_access_scope_analyses")
describe_network_insights_access_scopes_paginator: DescribeNetworkInsightsAccessScopesPaginator = client.get_paginator("describe_network_insights_access_scopes")
describe_network_insights_analyses_paginator: DescribeNetworkInsightsAnalysesPaginator = client.get_paginator("describe_network_insights_analyses")
describe_network_insights_paths_paginator: DescribeNetworkInsightsPathsPaginator = client.get_paginator("describe_network_insights_paths")
describe_network_interface_permissions_paginator: DescribeNetworkInterfacePermissionsPaginator = client.get_paginator("describe_network_interface_permissions")
describe_network_interfaces_paginator: DescribeNetworkInterfacesPaginator = client.get_paginator("describe_network_interfaces")
describe_prefix_lists_paginator: DescribePrefixListsPaginator = client.get_paginator("describe_prefix_lists")
describe_principal_id_format_paginator: DescribePrincipalIdFormatPaginator = client.get_paginator("describe_principal_id_format")
describe_public_ipv4_pools_paginator: DescribePublicIpv4PoolsPaginator = client.get_paginator("describe_public_ipv4_pools")
describe_replace_root_volume_tasks_paginator: DescribeReplaceRootVolumeTasksPaginator = client.get_paginator("describe_replace_root_volume_tasks")
describe_reserved_instances_modifications_paginator: DescribeReservedInstancesModificationsPaginator = client.get_paginator("describe_reserved_instances_modifications")
describe_reserved_instances_offerings_paginator: DescribeReservedInstancesOfferingsPaginator = client.get_paginator("describe_reserved_instances_offerings")
describe_route_tables_paginator: DescribeRouteTablesPaginator = client.get_paginator("describe_route_tables")
describe_scheduled_instance_availability_paginator: DescribeScheduledInstanceAvailabilityPaginator = client.get_paginator("describe_scheduled_instance_availability")
describe_scheduled_instances_paginator: DescribeScheduledInstancesPaginator = client.get_paginator("describe_scheduled_instances")
describe_security_group_rules_paginator: DescribeSecurityGroupRulesPaginator = client.get_paginator("describe_security_group_rules")
describe_security_groups_paginator: DescribeSecurityGroupsPaginator = client.get_paginator("describe_security_groups")
describe_snapshot_tier_status_paginator: DescribeSnapshotTierStatusPaginator = client.get_paginator("describe_snapshot_tier_status")
describe_snapshots_paginator: DescribeSnapshotsPaginator = client.get_paginator("describe_snapshots")
describe_spot_fleet_instances_paginator: DescribeSpotFleetInstancesPaginator = client.get_paginator("describe_spot_fleet_instances")
describe_spot_fleet_requests_paginator: DescribeSpotFleetRequestsPaginator = client.get_paginator("describe_spot_fleet_requests")
describe_spot_instance_requests_paginator: DescribeSpotInstanceRequestsPaginator = client.get_paginator("describe_spot_instance_requests")
describe_spot_price_history_paginator: DescribeSpotPriceHistoryPaginator = client.get_paginator("describe_spot_price_history")
describe_stale_security_groups_paginator: DescribeStaleSecurityGroupsPaginator = client.get_paginator("describe_stale_security_groups")
describe_store_image_tasks_paginator: DescribeStoreImageTasksPaginator = client.get_paginator("describe_store_image_tasks")
describe_subnets_paginator: DescribeSubnetsPaginator = client.get_paginator("describe_subnets")
describe_tags_paginator: DescribeTagsPaginator = client.get_paginator("describe_tags")
describe_traffic_mirror_filters_paginator: DescribeTrafficMirrorFiltersPaginator = client.get_paginator("describe_traffic_mirror_filters")
describe_traffic_mirror_sessions_paginator: DescribeTrafficMirrorSessionsPaginator = client.get_paginator("describe_traffic_mirror_sessions")
describe_traffic_mirror_targets_paginator: DescribeTrafficMirrorTargetsPaginator = client.get_paginator("describe_traffic_mirror_targets")
describe_transit_gateway_attachments_paginator: DescribeTransitGatewayAttachmentsPaginator = client.get_paginator("describe_transit_gateway_attachments")
describe_transit_gateway_connect_peers_paginator: DescribeTransitGatewayConnectPeersPaginator = client.get_paginator("describe_transit_gateway_connect_peers")
describe_transit_gateway_connects_paginator: DescribeTransitGatewayConnectsPaginator = client.get_paginator("describe_transit_gateway_connects")
describe_transit_gateway_multicast_domains_paginator: DescribeTransitGatewayMulticastDomainsPaginator = client.get_paginator("describe_transit_gateway_multicast_domains")
describe_transit_gateway_peering_attachments_paginator: DescribeTransitGatewayPeeringAttachmentsPaginator = client.get_paginator("describe_transit_gateway_peering_attachments")
describe_transit_gateway_route_tables_paginator: DescribeTransitGatewayRouteTablesPaginator = client.get_paginator("describe_transit_gateway_route_tables")
describe_transit_gateway_vpc_attachments_paginator: DescribeTransitGatewayVpcAttachmentsPaginator = client.get_paginator("describe_transit_gateway_vpc_attachments")
describe_transit_gateways_paginator: DescribeTransitGatewaysPaginator = client.get_paginator("describe_transit_gateways")
describe_trunk_interface_associations_paginator: DescribeTrunkInterfaceAssociationsPaginator = client.get_paginator("describe_trunk_interface_associations")
describe_volume_status_paginator: DescribeVolumeStatusPaginator = client.get_paginator("describe_volume_status")
describe_volumes_paginator: DescribeVolumesPaginator = client.get_paginator("describe_volumes")
describe_volumes_modifications_paginator: DescribeVolumesModificationsPaginator = client.get_paginator("describe_volumes_modifications")
describe_vpc_classic_link_dns_support_paginator: DescribeVpcClassicLinkDnsSupportPaginator = client.get_paginator("describe_vpc_classic_link_dns_support")
describe_vpc_endpoint_connection_notifications_paginator: DescribeVpcEndpointConnectionNotificationsPaginator = client.get_paginator("describe_vpc_endpoint_connection_notifications")
describe_vpc_endpoint_connections_paginator: DescribeVpcEndpointConnectionsPaginator = client.get_paginator("describe_vpc_endpoint_connections")
describe_vpc_endpoint_service_configurations_paginator: DescribeVpcEndpointServiceConfigurationsPaginator = client.get_paginator("describe_vpc_endpoint_service_configurations")
describe_vpc_endpoint_service_permissions_paginator: DescribeVpcEndpointServicePermissionsPaginator = client.get_paginator("describe_vpc_endpoint_service_permissions")
describe_vpc_endpoint_services_paginator: DescribeVpcEndpointServicesPaginator = client.get_paginator("describe_vpc_endpoint_services")
describe_vpc_endpoints_paginator: DescribeVpcEndpointsPaginator = client.get_paginator("describe_vpc_endpoints")
describe_vpc_peering_connections_paginator: DescribeVpcPeeringConnectionsPaginator = client.get_paginator("describe_vpc_peering_connections")
describe_vpcs_paginator: DescribeVpcsPaginator = client.get_paginator("describe_vpcs")
get_associated_ipv6_pool_cidrs_paginator: GetAssociatedIpv6PoolCidrsPaginator = client.get_paginator("get_associated_ipv6_pool_cidrs")
get_groups_for_capacity_reservation_paginator: GetGroupsForCapacityReservationPaginator = client.get_paginator("get_groups_for_capacity_reservation")
get_instance_types_from_instance_requirements_paginator: GetInstanceTypesFromInstanceRequirementsPaginator = client.get_paginator("get_instance_types_from_instance_requirements")
get_ipam_address_history_paginator: GetIpamAddressHistoryPaginator = client.get_paginator("get_ipam_address_history")
get_ipam_pool_allocations_paginator: GetIpamPoolAllocationsPaginator = client.get_paginator("get_ipam_pool_allocations")
get_ipam_pool_cidrs_paginator: GetIpamPoolCidrsPaginator = client.get_paginator("get_ipam_pool_cidrs")
get_ipam_resource_cidrs_paginator: GetIpamResourceCidrsPaginator = client.get_paginator("get_ipam_resource_cidrs")
get_managed_prefix_list_associations_paginator: GetManagedPrefixListAssociationsPaginator = client.get_paginator("get_managed_prefix_list_associations")
get_managed_prefix_list_entries_paginator: GetManagedPrefixListEntriesPaginator = client.get_paginator("get_managed_prefix_list_entries")
get_spot_placement_scores_paginator: GetSpotPlacementScoresPaginator = client.get_paginator("get_spot_placement_scores")
get_transit_gateway_attachment_propagations_paginator: GetTransitGatewayAttachmentPropagationsPaginator = client.get_paginator("get_transit_gateway_attachment_propagations")
get_transit_gateway_multicast_domain_associations_paginator: GetTransitGatewayMulticastDomainAssociationsPaginator = client.get_paginator("get_transit_gateway_multicast_domain_associations")
get_transit_gateway_prefix_list_references_paginator: GetTransitGatewayPrefixListReferencesPaginator = client.get_paginator("get_transit_gateway_prefix_list_references")
get_transit_gateway_route_table_associations_paginator: GetTransitGatewayRouteTableAssociationsPaginator = client.get_paginator("get_transit_gateway_route_table_associations")
get_transit_gateway_route_table_propagations_paginator: GetTransitGatewayRouteTablePropagationsPaginator = client.get_paginator("get_transit_gateway_route_table_propagations")
get_vpn_connection_device_types_paginator: GetVpnConnectionDeviceTypesPaginator = client.get_paginator("get_vpn_connection_device_types")
list_images_in_recycle_bin_paginator: ListImagesInRecycleBinPaginator = client.get_paginator("list_images_in_recycle_bin")
list_snapshots_in_recycle_bin_paginator: ListSnapshotsInRecycleBinPaginator = client.get_paginator("list_snapshots_in_recycle_bin")
search_local_gateway_routes_paginator: SearchLocalGatewayRoutesPaginator = client.get_paginator("search_local_gateway_routes")
search_transit_gateway_multicast_groups_paginator: SearchTransitGatewayMulticastGroupsPaginator = client.get_paginator("search_transit_gateway_multicast_groups")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_ec2.waiter` module contains type annotations for all waiters.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2Client
from mypy_boto3_ec2.waiter import (
    BundleTaskCompleteWaiter,
    ConversionTaskCancelledWaiter,
    ConversionTaskCompletedWaiter,
    ConversionTaskDeletedWaiter,
    CustomerGatewayAvailableWaiter,
    ExportTaskCancelledWaiter,
    ExportTaskCompletedWaiter,
    ImageAvailableWaiter,
    ImageExistsWaiter,
    InstanceExistsWaiter,
    InstanceRunningWaiter,
    InstanceStatusOkWaiter,
    InstanceStoppedWaiter,
    InstanceTerminatedWaiter,
    InternetGatewayExistsWaiter,
    KeyPairExistsWaiter,
    NatGatewayAvailableWaiter,
    NatGatewayDeletedWaiter,
    NetworkInterfaceAvailableWaiter,
    PasswordDataAvailableWaiter,
    SecurityGroupExistsWaiter,
    SnapshotCompletedWaiter,
    SpotInstanceRequestFulfilledWaiter,
    SubnetAvailableWaiter,
    SystemStatusOkWaiter,
    VolumeAvailableWaiter,
    VolumeDeletedWaiter,
    VolumeInUseWaiter,
    VpcAvailableWaiter,
    VpcExistsWaiter,
    VpcPeeringConnectionDeletedWaiter,
    VpcPeeringConnectionExistsWaiter,
    VpnConnectionAvailableWaiter,
    VpnConnectionDeletedWaiter,
)

client: EC2Client = Session().client("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
bundle_task_complete_waiter: BundleTaskCompleteWaiter = client.get_waiter("bundle_task_complete")
conversion_task_cancelled_waiter: ConversionTaskCancelledWaiter = client.get_waiter("conversion_task_cancelled")
conversion_task_completed_waiter: ConversionTaskCompletedWaiter = client.get_waiter("conversion_task_completed")
conversion_task_deleted_waiter: ConversionTaskDeletedWaiter = client.get_waiter("conversion_task_deleted")
customer_gateway_available_waiter: CustomerGatewayAvailableWaiter = client.get_waiter("customer_gateway_available")
export_task_cancelled_waiter: ExportTaskCancelledWaiter = client.get_waiter("export_task_cancelled")
export_task_completed_waiter: ExportTaskCompletedWaiter = client.get_waiter("export_task_completed")
image_available_waiter: ImageAvailableWaiter = client.get_waiter("image_available")
image_exists_waiter: ImageExistsWaiter = client.get_waiter("image_exists")
instance_exists_waiter: InstanceExistsWaiter = client.get_waiter("instance_exists")
instance_running_waiter: InstanceRunningWaiter = client.get_waiter("instance_running")
instance_status_ok_waiter: InstanceStatusOkWaiter = client.get_waiter("instance_status_ok")
instance_stopped_waiter: InstanceStoppedWaiter = client.get_waiter("instance_stopped")
instance_terminated_waiter: InstanceTerminatedWaiter = client.get_waiter("instance_terminated")
internet_gateway_exists_waiter: InternetGatewayExistsWaiter = client.get_waiter("internet_gateway_exists")
key_pair_exists_waiter: KeyPairExistsWaiter = client.get_waiter("key_pair_exists")
nat_gateway_available_waiter: NatGatewayAvailableWaiter = client.get_waiter("nat_gateway_available")
nat_gateway_deleted_waiter: NatGatewayDeletedWaiter = client.get_waiter("nat_gateway_deleted")
network_interface_available_waiter: NetworkInterfaceAvailableWaiter = client.get_waiter("network_interface_available")
password_data_available_waiter: PasswordDataAvailableWaiter = client.get_waiter("password_data_available")
security_group_exists_waiter: SecurityGroupExistsWaiter = client.get_waiter("security_group_exists")
snapshot_completed_waiter: SnapshotCompletedWaiter = client.get_waiter("snapshot_completed")
spot_instance_request_fulfilled_waiter: SpotInstanceRequestFulfilledWaiter = client.get_waiter("spot_instance_request_fulfilled")
subnet_available_waiter: SubnetAvailableWaiter = client.get_waiter("subnet_available")
system_status_ok_waiter: SystemStatusOkWaiter = client.get_waiter("system_status_ok")
volume_available_waiter: VolumeAvailableWaiter = client.get_waiter("volume_available")
volume_deleted_waiter: VolumeDeletedWaiter = client.get_waiter("volume_deleted")
volume_in_use_waiter: VolumeInUseWaiter = client.get_waiter("volume_in_use")
vpc_available_waiter: VpcAvailableWaiter = client.get_waiter("vpc_available")
vpc_exists_waiter: VpcExistsWaiter = client.get_waiter("vpc_exists")
vpc_peering_connection_deleted_waiter: VpcPeeringConnectionDeletedWaiter = client.get_waiter("vpc_peering_connection_deleted")
vpc_peering_connection_exists_waiter: VpcPeeringConnectionExistsWaiter = client.get_waiter("vpc_peering_connection_exists")
vpn_connection_available_waiter: VpnConnectionAvailableWaiter = client.get_waiter("vpn_connection_available")
vpn_connection_deleted_waiter: VpnConnectionDeletedWaiter = client.get_waiter("vpn_connection_deleted")
```

<a id="service-resource-annotations"></a>

### Service Resource annotations

`EC2ServiceResource` provides annotations for `boto3.resource("ec2")`.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2ServiceResource

resource: EC2ServiceResource = Session().resource("ec2")

# now resource usage is checked by mypy and IDE should provide code completion
```

<a id="other-resources-annotations"></a>

### Other resources annotations

`mypy_boto3_ec2.service_resource` module contains type annotations for all
resources.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2ServiceResource
from mypy_boto3_ec2.service_resource import (
    ClassicAddress,
    DhcpOptions,
    Image,
    Instance,
    InternetGateway,
    KeyPair,
    KeyPairInfo,
    NetworkAcl,
    NetworkInterface,
    NetworkInterfaceAssociation,
    PlacementGroup,
    Route,
    RouteTable,
    RouteTableAssociation,
    SecurityGroup,
    Snapshot,
    Subnet,
    Tag,
    Volume,
    Vpc,
    VpcPeeringConnection,
    VpcAddress,
)

resource: EC2ServiceResource = Session().resource("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_classic_address: ClassicAddress = resource.ClassicAddress(...)
my_dhcp_options: DhcpOptions = resource.DhcpOptions(...)
my_image: Image = resource.Image(...)
my_instance: Instance = resource.Instance(...)
my_internet_gateway: InternetGateway = resource.InternetGateway(...)
my_key_pair: KeyPair = resource.KeyPair(...)
my_key_pair_info: KeyPairInfo = resource.KeyPairInfo(...)
my_network_acl: NetworkAcl = resource.NetworkAcl(...)
my_network_interface: NetworkInterface = resource.NetworkInterface(...)
my_network_interface_association: NetworkInterfaceAssociation = resource.NetworkInterfaceAssociation(...)
my_placement_group: PlacementGroup = resource.PlacementGroup(...)
my_route: Route = resource.Route(...)
my_route_table: RouteTable = resource.RouteTable(...)
my_route_table_association: RouteTableAssociation = resource.RouteTableAssociation(...)
my_security_group: SecurityGroup = resource.SecurityGroup(...)
my_snapshot: Snapshot = resource.Snapshot(...)
my_subnet: Subnet = resource.Subnet(...)
my_tag: Tag = resource.Tag(...)
my_volume: Volume = resource.Volume(...)
my_vpc: Vpc = resource.Vpc(...)
my_vpc_peering_connection: VpcPeeringConnection = resource.VpcPeeringConnection(...)
my_vpc_address: VpcAddress = resource.VpcAddress(...)
```

<a id="collections-annotations"></a>

### Collections annotations

`mypy_boto3_ec2.service_resource` module contains type annotations for all
`EC2ServiceResource` collections.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2ServiceResource
from mypy_boto3_ec2.service_resource import (
    ServiceResourceClassicAddressesCollection,
    ServiceResourceDhcpOptionsSetsCollection,
    ServiceResourceImagesCollection,
    ServiceResourceInstancesCollection,
    ServiceResourceInternetGatewaysCollection,
    ServiceResourceKeyPairsCollection,
    ServiceResourceNetworkAclsCollection,
    ServiceResourceNetworkInterfacesCollection,
    ServiceResourcePlacementGroupsCollection,
    ServiceResourceRouteTablesCollection,
    ServiceResourceSecurityGroupsCollection,
    ServiceResourceSnapshotsCollection,
    ServiceResourceSubnetsCollection,
    ServiceResourceVolumesCollection,
    ServiceResourceVpcAddressesCollection,
    ServiceResourceVpcPeeringConnectionsCollection,
    ServiceResourceVpcsCollection,
)

resource: EC2ServiceResource = Session().resource("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
classic_addresses: ec2_resources.ServiceResourceClassicAddressesCollection = resource.classic_addresses
dhcp_options_sets: ec2_resources.ServiceResourceDhcpOptionsSetsCollection = resource.dhcp_options_sets
images: ec2_resources.ServiceResourceImagesCollection = resource.images
instances: ec2_resources.ServiceResourceInstancesCollection = resource.instances
internet_gateways: ec2_resources.ServiceResourceInternetGatewaysCollection = resource.internet_gateways
key_pairs: ec2_resources.ServiceResourceKeyPairsCollection = resource.key_pairs
network_acls: ec2_resources.ServiceResourceNetworkAclsCollection = resource.network_acls
network_interfaces: ec2_resources.ServiceResourceNetworkInterfacesCollection = resource.network_interfaces
placement_groups: ec2_resources.ServiceResourcePlacementGroupsCollection = resource.placement_groups
route_tables: ec2_resources.ServiceResourceRouteTablesCollection = resource.route_tables
security_groups: ec2_resources.ServiceResourceSecurityGroupsCollection = resource.security_groups
snapshots: ec2_resources.ServiceResourceSnapshotsCollection = resource.snapshots
subnets: ec2_resources.ServiceResourceSubnetsCollection = resource.subnets
volumes: ec2_resources.ServiceResourceVolumesCollection = resource.volumes
vpc_addresses: ec2_resources.ServiceResourceVpcAddressesCollection = resource.vpc_addresses
vpc_peering_connections: ec2_resources.ServiceResourceVpcPeeringConnectionsCollection = resource.vpc_peering_connections
vpcs: ec2_resources.ServiceResourceVpcsCollection = resource.vpcs
```

<a id="literals"></a>

### Literals

`mypy_boto3_ec2.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_ec2.literals import (
    AcceleratorManufacturerType,
    AcceleratorNameType,
    AcceleratorTypeType,
    AccountAttributeNameType,
    ActivityStatusType,
    AddressAttributeNameType,
    AddressFamilyType,
    AffinityType,
    AllocationStateType,
    AllocationStrategyType,
    AllowsMultipleInstanceTypesType,
    AnalysisStatusType,
    ApplianceModeSupportValueType,
    ArchitectureTypeType,
    ArchitectureValuesType,
    AssociatedNetworkTypeType,
    AssociationStatusCodeType,
    AttachmentStatusType,
    AutoAcceptSharedAssociationsValueType,
    AutoAcceptSharedAttachmentsValueType,
    AutoPlacementType,
    AvailabilityZoneOptInStatusType,
    AvailabilityZoneStateType,
    BareMetalType,
    BatchStateType,
    BgpStatusType,
    BootModeTypeType,
    BootModeValuesType,
    BundleTaskCompleteWaiterName,
    BundleTaskStateType,
    BurstablePerformanceType,
    ByoipCidrStateType,
    CancelBatchErrorCodeType,
    CancelSpotInstanceRequestStateType,
    CapacityReservationFleetStateType,
    CapacityReservationInstancePlatformType,
    CapacityReservationPreferenceType,
    CapacityReservationStateType,
    CapacityReservationTenancyType,
    CarrierGatewayStateType,
    ClientCertificateRevocationListStatusCodeType,
    ClientVpnAuthenticationTypeType,
    ClientVpnAuthorizationRuleStatusCodeType,
    ClientVpnConnectionStatusCodeType,
    ClientVpnEndpointAttributeStatusCodeType,
    ClientVpnEndpointStatusCodeType,
    ClientVpnRouteStatusCodeType,
    ConnectionNotificationStateType,
    ConnectionNotificationTypeType,
    ConnectivityTypeType,
    ContainerFormatType,
    ConversionTaskCancelledWaiterName,
    ConversionTaskCompletedWaiterName,
    ConversionTaskDeletedWaiterName,
    ConversionTaskStateType,
    CopyTagsFromSourceType,
    CpuManufacturerType,
    CurrencyCodeValuesType,
    CustomerGatewayAvailableWaiterName,
    DatafeedSubscriptionStateType,
    DefaultRouteTableAssociationValueType,
    DefaultRouteTablePropagationValueType,
    DefaultTargetCapacityTypeType,
    DeleteFleetErrorCodeType,
    DeleteQueuedReservedInstancesErrorCodeType,
    DescribeAddressesAttributePaginatorName,
    DescribeByoipCidrsPaginatorName,
    DescribeCapacityReservationFleetsPaginatorName,
    DescribeCapacityReservationsPaginatorName,
    DescribeCarrierGatewaysPaginatorName,
    DescribeClassicLinkInstancesPaginatorName,
    DescribeClientVpnAuthorizationRulesPaginatorName,
    DescribeClientVpnConnectionsPaginatorName,
    DescribeClientVpnEndpointsPaginatorName,
    DescribeClientVpnRoutesPaginatorName,
    DescribeClientVpnTargetNetworksPaginatorName,
    DescribeCoipPoolsPaginatorName,
    DescribeDhcpOptionsPaginatorName,
    DescribeEgressOnlyInternetGatewaysPaginatorName,
    DescribeExportImageTasksPaginatorName,
    DescribeFastLaunchImagesPaginatorName,
    DescribeFastSnapshotRestoresPaginatorName,
    DescribeFleetsPaginatorName,
    DescribeFlowLogsPaginatorName,
    DescribeFpgaImagesPaginatorName,
    DescribeHostReservationOfferingsPaginatorName,
    DescribeHostReservationsPaginatorName,
    DescribeHostsPaginatorName,
    DescribeIamInstanceProfileAssociationsPaginatorName,
    DescribeImportImageTasksPaginatorName,
    DescribeImportSnapshotTasksPaginatorName,
    DescribeInstanceCreditSpecificationsPaginatorName,
    DescribeInstanceEventWindowsPaginatorName,
    DescribeInstanceStatusPaginatorName,
    DescribeInstanceTypeOfferingsPaginatorName,
    DescribeInstanceTypesPaginatorName,
    DescribeInstancesPaginatorName,
    DescribeInternetGatewaysPaginatorName,
    DescribeIpamPoolsPaginatorName,
    DescribeIpamScopesPaginatorName,
    DescribeIpamsPaginatorName,
    DescribeIpv6PoolsPaginatorName,
    DescribeLaunchTemplateVersionsPaginatorName,
    DescribeLaunchTemplatesPaginatorName,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginatorName,
    DescribeLocalGatewayRouteTableVpcAssociationsPaginatorName,
    DescribeLocalGatewayRouteTablesPaginatorName,
    DescribeLocalGatewayVirtualInterfaceGroupsPaginatorName,
    DescribeLocalGatewayVirtualInterfacesPaginatorName,
    DescribeLocalGatewaysPaginatorName,
    DescribeManagedPrefixListsPaginatorName,
    DescribeMovingAddressesPaginatorName,
    DescribeNatGatewaysPaginatorName,
    DescribeNetworkAclsPaginatorName,
    DescribeNetworkInsightsAccessScopeAnalysesPaginatorName,
    DescribeNetworkInsightsAccessScopesPaginatorName,
    DescribeNetworkInsightsAnalysesPaginatorName,
    DescribeNetworkInsightsPathsPaginatorName,
    DescribeNetworkInterfacePermissionsPaginatorName,
    DescribeNetworkInterfacesPaginatorName,
    DescribePrefixListsPaginatorName,
    DescribePrincipalIdFormatPaginatorName,
    DescribePublicIpv4PoolsPaginatorName,
    DescribeReplaceRootVolumeTasksPaginatorName,
    DescribeReservedInstancesModificationsPaginatorName,
    DescribeReservedInstancesOfferingsPaginatorName,
    DescribeRouteTablesPaginatorName,
    DescribeScheduledInstanceAvailabilityPaginatorName,
    DescribeScheduledInstancesPaginatorName,
    DescribeSecurityGroupRulesPaginatorName,
    DescribeSecurityGroupsPaginatorName,
    DescribeSnapshotTierStatusPaginatorName,
    DescribeSnapshotsPaginatorName,
    DescribeSpotFleetInstancesPaginatorName,
    DescribeSpotFleetRequestsPaginatorName,
    DescribeSpotInstanceRequestsPaginatorName,
    DescribeSpotPriceHistoryPaginatorName,
    DescribeStaleSecurityGroupsPaginatorName,
    DescribeStoreImageTasksPaginatorName,
    DescribeSubnetsPaginatorName,
    DescribeTagsPaginatorName,
    DescribeTrafficMirrorFiltersPaginatorName,
    DescribeTrafficMirrorSessionsPaginatorName,
    DescribeTrafficMirrorTargetsPaginatorName,
    DescribeTransitGatewayAttachmentsPaginatorName,
    DescribeTransitGatewayConnectPeersPaginatorName,
    DescribeTransitGatewayConnectsPaginatorName,
    DescribeTransitGatewayMulticastDomainsPaginatorName,
    DescribeTransitGatewayPeeringAttachmentsPaginatorName,
    DescribeTransitGatewayRouteTablesPaginatorName,
    DescribeTransitGatewayVpcAttachmentsPaginatorName,
    DescribeTransitGatewaysPaginatorName,
    DescribeTrunkInterfaceAssociationsPaginatorName,
    DescribeVolumeStatusPaginatorName,
    DescribeVolumesModificationsPaginatorName,
    DescribeVolumesPaginatorName,
    DescribeVpcClassicLinkDnsSupportPaginatorName,
    DescribeVpcEndpointConnectionNotificationsPaginatorName,
    DescribeVpcEndpointConnectionsPaginatorName,
    DescribeVpcEndpointServiceConfigurationsPaginatorName,
    DescribeVpcEndpointServicePermissionsPaginatorName,
    DescribeVpcEndpointServicesPaginatorName,
    DescribeVpcEndpointsPaginatorName,
    DescribeVpcPeeringConnectionsPaginatorName,
    DescribeVpcsPaginatorName,
    DestinationFileFormatType,
    DeviceTypeType,
    DiskImageFormatType,
    DiskTypeType,
    DnsNameStateType,
    DnsRecordIpTypeType,
    DnsSupportValueType,
    DomainTypeType,
    EbsEncryptionSupportType,
    EbsNvmeSupportType,
    EbsOptimizedSupportType,
    ElasticGpuStateType,
    ElasticGpuStatusType,
    EnaSupportType,
    EndDateTypeType,
    EphemeralNvmeSupportType,
    EventCodeType,
    EventTypeType,
    ExcessCapacityTerminationPolicyType,
    ExportEnvironmentType,
    ExportTaskCancelledWaiterName,
    ExportTaskCompletedWaiterName,
    ExportTaskStateType,
    FastLaunchResourceTypeType,
    FastLaunchStateCodeType,
    FastSnapshotRestoreStateCodeType,
    FindingsFoundType,
    FleetActivityStatusType,
    FleetCapacityReservationTenancyType,
    FleetCapacityReservationUsageStrategyType,
    FleetEventTypeType,
    FleetExcessCapacityTerminationPolicyType,
    FleetInstanceMatchCriteriaType,
    FleetOnDemandAllocationStrategyType,
    FleetReplacementStrategyType,
    FleetStateCodeType,
    FleetTypeType,
    FlowLogsResourceTypeType,
    FpgaImageAttributeNameType,
    FpgaImageStateCodeType,
    GatewayAssociationStateType,
    GatewayTypeType,
    GetAssociatedIpv6PoolCidrsPaginatorName,
    GetGroupsForCapacityReservationPaginatorName,
    GetInstanceTypesFromInstanceRequirementsPaginatorName,
    GetIpamAddressHistoryPaginatorName,
    GetIpamPoolAllocationsPaginatorName,
    GetIpamPoolCidrsPaginatorName,
    GetIpamResourceCidrsPaginatorName,
    GetManagedPrefixListAssociationsPaginatorName,
    GetManagedPrefixListEntriesPaginatorName,
    GetSpotPlacementScoresPaginatorName,
    GetTransitGatewayAttachmentPropagationsPaginatorName,
    GetTransitGatewayMulticastDomainAssociationsPaginatorName,
    GetTransitGatewayPrefixListReferencesPaginatorName,
    GetTransitGatewayRouteTableAssociationsPaginatorName,
    GetTransitGatewayRouteTablePropagationsPaginatorName,
    GetVpnConnectionDeviceTypesPaginatorName,
    HostRecoveryType,
    HostTenancyType,
    HostnameTypeType,
    HttpTokensStateType,
    HypervisorTypeType,
    IamInstanceProfileAssociationStateType,
    Igmpv2SupportValueType,
    ImageAttributeNameType,
    ImageAvailableWaiterName,
    ImageExistsWaiterName,
    ImageStateType,
    ImageTypeValuesType,
    InstanceAttributeNameType,
    InstanceAutoRecoveryStateType,
    InstanceEventWindowStateType,
    InstanceExistsWaiterName,
    InstanceGenerationType,
    InstanceHealthStatusType,
    InstanceInterruptionBehaviorType,
    InstanceLifecycleType,
    InstanceLifecycleTypeType,
    InstanceMatchCriteriaType,
    InstanceMetadataEndpointStateType,
    InstanceMetadataOptionsStateType,
    InstanceMetadataProtocolStateType,
    InstanceMetadataTagsStateType,
    InstanceRunningWaiterName,
    InstanceStateNameType,
    InstanceStatusOkWaiterName,
    InstanceStoppedWaiterName,
    InstanceStorageEncryptionSupportType,
    InstanceTerminatedWaiterName,
    InstanceTypeHypervisorType,
    InstanceTypeType,
    InterfacePermissionTypeType,
    InterfaceProtocolTypeType,
    InternetGatewayExistsWaiterName,
    IpAddressTypeType,
    IpamAddressHistoryResourceTypeType,
    IpamComplianceStatusType,
    IpamManagementStateType,
    IpamOverlapStatusType,
    IpamPoolAllocationResourceTypeType,
    IpamPoolAwsServiceType,
    IpamPoolCidrFailureCodeType,
    IpamPoolCidrStateType,
    IpamPoolStateType,
    IpamResourceTypeType,
    IpamScopeStateType,
    IpamScopeTypeType,
    IpamStateType,
    Ipv6SupportValueType,
    KeyFormatType,
    KeyPairExistsWaiterName,
    KeyTypeType,
    LaunchTemplateAutoRecoveryStateType,
    LaunchTemplateErrorCodeType,
    LaunchTemplateHttpTokensStateType,
    LaunchTemplateInstanceMetadataEndpointStateType,
    LaunchTemplateInstanceMetadataOptionsStateType,
    LaunchTemplateInstanceMetadataProtocolIpv6Type,
    LaunchTemplateInstanceMetadataTagsStateType,
    ListImagesInRecycleBinPaginatorName,
    ListSnapshotsInRecycleBinPaginatorName,
    ListingStateType,
    ListingStatusType,
    LocalGatewayRouteStateType,
    LocalGatewayRouteTypeType,
    LocalStorageType,
    LocalStorageTypeType,
    LocationTypeType,
    LogDestinationTypeType,
    MarketTypeType,
    MembershipTypeType,
    ModifyAvailabilityZoneOptInStatusType,
    MonitoringStateType,
    MoveStatusType,
    MulticastSupportValueType,
    NatGatewayAvailableWaiterName,
    NatGatewayDeletedWaiterName,
    NatGatewayStateType,
    NetworkInterfaceAttributeType,
    NetworkInterfaceAvailableWaiterName,
    NetworkInterfaceCreationTypeType,
    NetworkInterfacePermissionStateCodeType,
    NetworkInterfaceStatusType,
    NetworkInterfaceTypeType,
    OfferingClassTypeType,
    OfferingTypeValuesType,
    OnDemandAllocationStrategyType,
    OperationTypeType,
    PartitionLoadFrequencyType,
    PasswordDataAvailableWaiterName,
    PayerResponsibilityType,
    PaymentOptionType,
    PermissionGroupType,
    PlacementGroupStateType,
    PlacementGroupStrategyType,
    PlacementStrategyType,
    PlatformValuesType,
    PrefixListStateType,
    PrincipalTypeType,
    ProductCodeValuesType,
    ProtocolType,
    ProtocolValueType,
    RIProductDescriptionType,
    RecurringChargeFrequencyType,
    ReplaceRootVolumeTaskStateType,
    ReplacementStrategyType,
    ReportInstanceReasonCodesType,
    ReportStatusTypeType,
    ReservationStateType,
    ReservedInstanceStateType,
    ResetFpgaImageAttributeNameType,
    ResetImageAttributeNameType,
    ResourceTypeType,
    RootDeviceTypeType,
    RouteOriginType,
    RouteStateType,
    RouteTableAssociationStateCodeType,
    RuleActionType,
    SearchLocalGatewayRoutesPaginatorName,
    SearchTransitGatewayMulticastGroupsPaginatorName,
    SecurityGroupExistsWaiterName,
    SelfServicePortalType,
    ServiceConnectivityTypeType,
    ServiceStateType,
    ServiceTypeType,
    ShutdownBehaviorType,
    SnapshotAttributeNameType,
    SnapshotCompletedWaiterName,
    SnapshotStateType,
    SpotAllocationStrategyType,
    SpotInstanceInterruptionBehaviorType,
    SpotInstanceRequestFulfilledWaiterName,
    SpotInstanceStateType,
    SpotInstanceTypeType,
    StateType,
    StaticSourcesSupportValueType,
    StatusNameType,
    StatusType,
    StatusTypeType,
    StorageTierType,
    SubnetAvailableWaiterName,
    SubnetCidrBlockStateCodeType,
    SubnetCidrReservationTypeType,
    SubnetStateType,
    SummaryStatusType,
    SystemStatusOkWaiterName,
    TargetCapacityUnitTypeType,
    TargetStorageTierType,
    TelemetryStatusType,
    TenancyType,
    TieringOperationStatusType,
    TpmSupportValuesType,
    TrafficDirectionType,
    TrafficMirrorFilterRuleFieldType,
    TrafficMirrorNetworkServiceType,
    TrafficMirrorRuleActionType,
    TrafficMirrorSessionFieldType,
    TrafficMirrorTargetTypeType,
    TrafficTypeType,
    TransitGatewayAssociationStateType,
    TransitGatewayAttachmentResourceTypeType,
    TransitGatewayAttachmentStateType,
    TransitGatewayConnectPeerStateType,
    TransitGatewayMulitcastDomainAssociationStateType,
    TransitGatewayMulticastDomainStateType,
    TransitGatewayPrefixListReferenceStateType,
    TransitGatewayPropagationStateType,
    TransitGatewayRouteStateType,
    TransitGatewayRouteTableStateType,
    TransitGatewayRouteTypeType,
    TransitGatewayStateType,
    TransportProtocolType,
    TunnelInsideIpVersionType,
    UnlimitedSupportedInstanceFamilyType,
    UnsuccessfulInstanceCreditSpecificationErrorCodeType,
    UsageClassTypeType,
    VirtualizationTypeType,
    VolumeAttachmentStateType,
    VolumeAttributeNameType,
    VolumeAvailableWaiterName,
    VolumeDeletedWaiterName,
    VolumeInUseWaiterName,
    VolumeModificationStateType,
    VolumeStateType,
    VolumeStatusInfoStatusType,
    VolumeStatusNameType,
    VolumeTypeType,
    VpcAttributeNameType,
    VpcAvailableWaiterName,
    VpcCidrBlockStateCodeType,
    VpcEndpointTypeType,
    VpcExistsWaiterName,
    VpcPeeringConnectionDeletedWaiterName,
    VpcPeeringConnectionExistsWaiterName,
    VpcPeeringConnectionStateReasonCodeType,
    VpcStateType,
    VpcTenancyType,
    VpnConnectionAvailableWaiterName,
    VpnConnectionDeletedWaiterName,
    VpnEcmpSupportValueType,
    VpnProtocolType,
    VpnStateType,
    VpnStaticRouteSourceType,
    WeekDayType,
    scopeType,
    EC2ServiceName,
    ServiceName,
    ResourceServiceName,
    PaginatorName,
    WaiterName,
    RegionName,
)

def check_value(value: AcceleratorManufacturerType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_ec2.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_ec2.type_defs import (
    AcceleratorCountRequestTypeDef,
    AcceleratorCountTypeDef,
    AcceleratorTotalMemoryMiBRequestTypeDef,
    AcceleratorTotalMemoryMiBTypeDef,
    TargetConfigurationRequestTypeDef,
    ResponseMetadataTypeDef,
    AcceptTransitGatewayMulticastDomainAssociationsRequestRequestTypeDef,
    AcceptTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    AcceptTransitGatewayVpcAttachmentRequestRequestTypeDef,
    AcceptVpcEndpointConnectionsRequestRequestTypeDef,
    AcceptVpcPeeringConnectionRequestRequestTypeDef,
    AcceptVpcPeeringConnectionRequestVpcPeeringConnectionAcceptTypeDef,
    AccountAttributeValueTypeDef,
    ActiveInstanceTypeDef,
    AddIpamOperatingRegionTypeDef,
    AddPrefixListEntryTypeDef,
    AnalysisComponentTypeDef,
    PtrUpdateStatusTypeDef,
    TagTypeDef,
    AdvertiseByoipCidrRequestRequestTypeDef,
    ByoipCidrTypeDef,
    AllocateIpamPoolCidrRequestRequestTypeDef,
    IpamPoolAllocationTypeDef,
    AllowedPrincipalTypeDef,
    AlternatePathHintTypeDef,
    PortRangeTypeDef,
    AnalysisLoadBalancerListenerTypeDef,
    AnalysisRouteTableRouteTypeDef,
    ApplySecurityGroupsToClientVpnTargetNetworkRequestRequestTypeDef,
    AssignIpv6AddressesRequestRequestTypeDef,
    AssignPrivateIpAddressesRequestNetworkInterfaceAssignPrivateIpAddressesTypeDef,
    AssignPrivateIpAddressesRequestRequestTypeDef,
    AssignedPrivateIpAddressTypeDef,
    Ipv4PrefixSpecificationTypeDef,
    AssociateAddressRequestClassicAddressAssociateTypeDef,
    AssociateAddressRequestRequestTypeDef,
    AssociateAddressRequestVpcAddressAssociateTypeDef,
    AssociateClientVpnTargetNetworkRequestRequestTypeDef,
    AssociationStatusTypeDef,
    AssociateDhcpOptionsRequestDhcpOptionsAssociateWithVpcTypeDef,
    AssociateDhcpOptionsRequestRequestTypeDef,
    AssociateDhcpOptionsRequestVpcAssociateDhcpOptionsTypeDef,
    AssociateEnclaveCertificateIamRoleRequestRequestTypeDef,
    IamInstanceProfileSpecificationTypeDef,
    AssociateRouteTableRequestRequestTypeDef,
    AssociateRouteTableRequestRouteTableAssociateWithSubnetTypeDef,
    RouteTableAssociationStateTypeDef,
    AssociateSubnetCidrBlockRequestRequestTypeDef,
    AssociateTransitGatewayMulticastDomainRequestRequestTypeDef,
    AssociateTransitGatewayRouteTableRequestRequestTypeDef,
    TransitGatewayAssociationTypeDef,
    AssociateTrunkInterfaceRequestRequestTypeDef,
    AssociateVpcCidrBlockRequestRequestTypeDef,
    AssociatedRoleTypeDef,
    AssociatedTargetNetworkTypeDef,
    AthenaIntegrationTypeDef,
    AttachClassicLinkVpcRequestInstanceAttachClassicLinkVpcTypeDef,
    AttachClassicLinkVpcRequestRequestTypeDef,
    AttachClassicLinkVpcRequestVpcAttachClassicLinkInstanceTypeDef,
    AttachInternetGatewayRequestInternetGatewayAttachToVpcTypeDef,
    AttachInternetGatewayRequestRequestTypeDef,
    AttachInternetGatewayRequestVpcAttachInternetGatewayTypeDef,
    AttachNetworkInterfaceRequestNetworkInterfaceAttachTypeDef,
    AttachNetworkInterfaceRequestRequestTypeDef,
    AttachVolumeRequestInstanceAttachVolumeTypeDef,
    AttachVolumeRequestRequestTypeDef,
    AttachVolumeRequestVolumeAttachToInstanceTypeDef,
    AttachVpnGatewayRequestRequestTypeDef,
    VpcAttachmentTypeDef,
    AttributeBooleanValueTypeDef,
    AttributeValueTypeDef,
    ClientVpnAuthorizationRuleStatusTypeDef,
    AuthorizeClientVpnIngressRequestRequestTypeDef,
    AvailabilityZoneMessageTypeDef,
    InstanceCapacityTypeDef,
    BaselineEbsBandwidthMbpsRequestTypeDef,
    BaselineEbsBandwidthMbpsTypeDef,
    BlobAttributeValueTypeDef,
    EbsBlockDeviceTypeDef,
    BundleTaskErrorTypeDef,
    CancelBundleTaskRequestRequestTypeDef,
    CancelCapacityReservationFleetErrorTypeDef,
    CancelCapacityReservationFleetsRequestRequestTypeDef,
    CapacityReservationFleetCancellationStateTypeDef,
    CancelCapacityReservationRequestRequestTypeDef,
    CancelConversionRequestRequestTypeDef,
    CancelExportTaskRequestRequestTypeDef,
    CancelImportTaskRequestRequestTypeDef,
    CancelReservedInstancesListingRequestRequestTypeDef,
    CancelSpotFleetRequestsErrorTypeDef,
    CancelSpotFleetRequestsRequestRequestTypeDef,
    CancelSpotFleetRequestsSuccessItemTypeDef,
    CancelSpotInstanceRequestsRequestRequestTypeDef,
    CancelledSpotInstanceRequestTypeDef,
    FleetCapacityReservationTypeDef,
    CapacityReservationGroupTypeDef,
    CapacityReservationOptionsRequestTypeDef,
    CapacityReservationOptionsTypeDef,
    CapacityReservationTargetResponseTypeDef,
    CapacityReservationTargetTypeDef,
    CertificateAuthenticationRequestTypeDef,
    CertificateAuthenticationTypeDef,
    CidrAuthorizationContextTypeDef,
    CidrBlockTypeDef,
    ClassicLinkDnsSupportTypeDef,
    GroupIdentifierTypeDef,
    ClassicLoadBalancerTypeDef,
    ClientCertificateRevocationListStatusTypeDef,
    ClientConnectOptionsTypeDef,
    ClientVpnEndpointAttributeStatusTypeDef,
    ClientDataTypeDef,
    ClientLoginBannerOptionsTypeDef,
    ClientLoginBannerResponseOptionsTypeDef,
    DirectoryServiceAuthenticationRequestTypeDef,
    FederatedAuthenticationRequestTypeDef,
    DirectoryServiceAuthenticationTypeDef,
    FederatedAuthenticationTypeDef,
    ClientVpnConnectionStatusTypeDef,
    ClientVpnEndpointStatusTypeDef,
    ConnectionLogResponseOptionsTypeDef,
    ClientVpnRouteStatusTypeDef,
    CoipAddressUsageTypeDef,
    ConfirmProductInstanceRequestRequestTypeDef,
    ConnectionLogOptionsTypeDef,
    ConnectionNotificationTypeDef,
    CopyFpgaImageRequestRequestTypeDef,
    CopyImageRequestRequestTypeDef,
    CpuOptionsRequestTypeDef,
    CpuOptionsTypeDef,
    ReservationFleetInstanceSpecificationTypeDef,
    CreateClientVpnRouteRequestRequestTypeDef,
    CreateDefaultSubnetRequestRequestTypeDef,
    CreateDefaultVpcRequestRequestTypeDef,
    NewDhcpConfigurationTypeDef,
    TargetCapacitySpecificationRequestTypeDef,
    DestinationOptionsRequestTypeDef,
    StorageLocationTypeDef,
    InstanceEventWindowTimeRangeRequestTypeDef,
    ExportToS3TaskSpecificationTypeDef,
    RequestIpamResourceTagTypeDef,
    CreateLocalGatewayRouteRequestRequestTypeDef,
    LocalGatewayRouteTypeDef,
    IcmpTypeCodeTypeDef,
    CreateNetworkInterfacePermissionRequestRequestTypeDef,
    InstanceIpv6AddressTypeDef,
    Ipv4PrefixSpecificationRequestTypeDef,
    Ipv6PrefixSpecificationRequestTypeDef,
    PrivateIpAddressSpecificationTypeDef,
    PriceScheduleSpecificationTypeDef,
    CreateRouteRequestRequestTypeDef,
    CreateRouteRequestRouteTableCreateRouteTypeDef,
    InstanceSpecificationTypeDef,
    CreateSpotDatafeedSubscriptionRequestRequestTypeDef,
    S3ObjectTagTypeDef,
    TrafficMirrorPortRangeRequestTypeDef,
    TransitGatewayConnectRequestBgpOptionsTypeDef,
    CreateTransitGatewayConnectRequestOptionsTypeDef,
    CreateTransitGatewayMulticastDomainRequestOptionsTypeDef,
    CreateTransitGatewayPrefixListReferenceRequestRequestTypeDef,
    TransitGatewayRequestOptionsTypeDef,
    CreateTransitGatewayRouteRequestRequestTypeDef,
    CreateTransitGatewayVpcAttachmentRequestOptionsTypeDef,
    CreateVolumePermissionTypeDef,
    CreateVpcEndpointConnectionNotificationRequestRequestTypeDef,
    DnsOptionsSpecificationTypeDef,
    CreateVpnConnectionRouteRequestRequestTypeDef,
    CreditSpecificationRequestTypeDef,
    CreditSpecificationTypeDef,
    DeleteCarrierGatewayRequestRequestTypeDef,
    DeleteClientVpnEndpointRequestRequestTypeDef,
    DeleteClientVpnRouteRequestRequestTypeDef,
    DeleteCustomerGatewayRequestRequestTypeDef,
    DeleteDhcpOptionsRequestDhcpOptionsDeleteTypeDef,
    DeleteDhcpOptionsRequestRequestTypeDef,
    DeleteEgressOnlyInternetGatewayRequestRequestTypeDef,
    DeleteFleetErrorTypeDef,
    DeleteFleetSuccessItemTypeDef,
    DeleteFleetsRequestRequestTypeDef,
    DeleteFlowLogsRequestRequestTypeDef,
    DeleteFpgaImageRequestRequestTypeDef,
    DeleteInstanceEventWindowRequestRequestTypeDef,
    InstanceEventWindowStateChangeTypeDef,
    DeleteInternetGatewayRequestInternetGatewayDeleteTypeDef,
    DeleteInternetGatewayRequestRequestTypeDef,
    DeleteIpamPoolRequestRequestTypeDef,
    DeleteIpamRequestRequestTypeDef,
    DeleteIpamScopeRequestRequestTypeDef,
    DeleteKeyPairRequestKeyPairDeleteTypeDef,
    DeleteKeyPairRequestKeyPairInfoDeleteTypeDef,
    DeleteKeyPairRequestRequestTypeDef,
    DeleteLaunchTemplateRequestRequestTypeDef,
    DeleteLaunchTemplateVersionsRequestRequestTypeDef,
    ResponseErrorTypeDef,
    DeleteLaunchTemplateVersionsResponseSuccessItemTypeDef,
    DeleteLocalGatewayRouteRequestRequestTypeDef,
    DeleteLocalGatewayRouteTableVpcAssociationRequestRequestTypeDef,
    DeleteManagedPrefixListRequestRequestTypeDef,
    DeleteNatGatewayRequestRequestTypeDef,
    DeleteNetworkAclEntryRequestNetworkAclDeleteEntryTypeDef,
    DeleteNetworkAclEntryRequestRequestTypeDef,
    DeleteNetworkAclRequestNetworkAclDeleteTypeDef,
    DeleteNetworkAclRequestRequestTypeDef,
    DeleteNetworkInsightsAccessScopeAnalysisRequestRequestTypeDef,
    DeleteNetworkInsightsAccessScopeRequestRequestTypeDef,
    DeleteNetworkInsightsAnalysisRequestRequestTypeDef,
    DeleteNetworkInsightsPathRequestRequestTypeDef,
    DeleteNetworkInterfacePermissionRequestRequestTypeDef,
    DeleteNetworkInterfaceRequestNetworkInterfaceDeleteTypeDef,
    DeleteNetworkInterfaceRequestRequestTypeDef,
    DeletePlacementGroupRequestPlacementGroupDeleteTypeDef,
    DeletePlacementGroupRequestRequestTypeDef,
    DeletePublicIpv4PoolRequestRequestTypeDef,
    DeleteQueuedReservedInstancesErrorTypeDef,
    DeleteQueuedReservedInstancesRequestRequestTypeDef,
    SuccessfulQueuedPurchaseDeletionTypeDef,
    DeleteRouteRequestRequestTypeDef,
    DeleteRouteRequestRouteDeleteTypeDef,
    DeleteRouteTableRequestRequestTypeDef,
    DeleteRouteTableRequestRouteTableDeleteTypeDef,
    DeleteSecurityGroupRequestRequestTypeDef,
    DeleteSecurityGroupRequestSecurityGroupDeleteTypeDef,
    DeleteSnapshotRequestRequestTypeDef,
    DeleteSnapshotRequestSnapshotDeleteTypeDef,
    DeleteSpotDatafeedSubscriptionRequestRequestTypeDef,
    DeleteSubnetCidrReservationRequestRequestTypeDef,
    DeleteSubnetRequestRequestTypeDef,
    DeleteSubnetRequestSubnetDeleteTypeDef,
    DeleteTagsRequestTagDeleteTypeDef,
    DeleteTrafficMirrorFilterRequestRequestTypeDef,
    DeleteTrafficMirrorFilterRuleRequestRequestTypeDef,
    DeleteTrafficMirrorSessionRequestRequestTypeDef,
    DeleteTrafficMirrorTargetRequestRequestTypeDef,
    DeleteTransitGatewayConnectPeerRequestRequestTypeDef,
    DeleteTransitGatewayConnectRequestRequestTypeDef,
    DeleteTransitGatewayMulticastDomainRequestRequestTypeDef,
    DeleteTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    DeleteTransitGatewayPrefixListReferenceRequestRequestTypeDef,
    DeleteTransitGatewayRequestRequestTypeDef,
    DeleteTransitGatewayRouteRequestRequestTypeDef,
    DeleteTransitGatewayRouteTableRequestRequestTypeDef,
    DeleteTransitGatewayVpcAttachmentRequestRequestTypeDef,
    DeleteVolumeRequestRequestTypeDef,
    DeleteVolumeRequestVolumeDeleteTypeDef,
    DeleteVpcEndpointConnectionNotificationsRequestRequestTypeDef,
    DeleteVpcEndpointServiceConfigurationsRequestRequestTypeDef,
    DeleteVpcEndpointsRequestRequestTypeDef,
    DeleteVpcPeeringConnectionRequestRequestTypeDef,
    DeleteVpcPeeringConnectionRequestVpcPeeringConnectionDeleteTypeDef,
    DeleteVpcRequestRequestTypeDef,
    DeleteVpcRequestVpcDeleteTypeDef,
    DeleteVpnConnectionRequestRequestTypeDef,
    DeleteVpnConnectionRouteRequestRequestTypeDef,
    DeleteVpnGatewayRequestRequestTypeDef,
    DeprovisionByoipCidrRequestRequestTypeDef,
    DeprovisionIpamPoolCidrRequestRequestTypeDef,
    DeprovisionPublicIpv4PoolCidrRequestRequestTypeDef,
    DeregisterImageRequestImageDeregisterTypeDef,
    DeregisterImageRequestRequestTypeDef,
    DeregisterInstanceTagAttributeRequestTypeDef,
    InstanceTagNotificationAttributeTypeDef,
    DeregisterTransitGatewayMulticastGroupMembersRequestRequestTypeDef,
    TransitGatewayMulticastDeregisteredGroupMembersTypeDef,
    DeregisterTransitGatewayMulticastGroupSourcesRequestRequestTypeDef,
    TransitGatewayMulticastDeregisteredGroupSourcesTypeDef,
    DescribeAccountAttributesRequestRequestTypeDef,
    PaginatorConfigTypeDef,
    DescribeAddressesAttributeRequestRequestTypeDef,
    FilterTypeDef,
    DescribeAggregateIdFormatRequestRequestTypeDef,
    IdFormatTypeDef,
    WaiterConfigTypeDef,
    DescribeByoipCidrsRequestRequestTypeDef,
    DescribeConversionTasksRequestRequestTypeDef,
    FastLaunchLaunchTemplateSpecificationResponseTypeDef,
    FastLaunchSnapshotConfigurationResponseTypeDef,
    DescribeFastSnapshotRestoreSuccessItemTypeDef,
    DescribeFleetHistoryRequestRequestTypeDef,
    DescribeFpgaImageAttributeRequestRequestTypeDef,
    HostOfferingTypeDef,
    DescribeIdFormatRequestRequestTypeDef,
    DescribeIdentityIdFormatRequestRequestTypeDef,
    DescribeImageAttributeRequestImageDescribeAttributeTypeDef,
    DescribeImageAttributeRequestRequestTypeDef,
    DescribeInstanceAttributeRequestInstanceDescribeAttributeTypeDef,
    DescribeInstanceAttributeRequestRequestTypeDef,
    InstanceCreditSpecificationTypeDef,
    DescribeInstanceEventNotificationAttributesRequestRequestTypeDef,
    InstanceTypeOfferingTypeDef,
    MovingAddressStatusTypeDef,
    DescribeNetworkInterfaceAttributeRequestNetworkInterfaceDescribeAttributeTypeDef,
    DescribeNetworkInterfaceAttributeRequestRequestTypeDef,
    NetworkInterfaceAttachmentTypeDef,
    PrefixListTypeDef,
    DescribePrincipalIdFormatRequestRequestTypeDef,
    RegionTypeDef,
    ScheduledInstanceRecurrenceRequestTypeDef,
    SlotDateTimeRangeRequestTypeDef,
    SlotStartTimeRangeRequestTypeDef,
    DescribeSecurityGroupReferencesRequestRequestTypeDef,
    SecurityGroupReferenceTypeDef,
    DescribeSnapshotAttributeRequestRequestTypeDef,
    DescribeSnapshotAttributeRequestSnapshotDescribeAttributeTypeDef,
    ProductCodeTypeDef,
    DescribeSpotDatafeedSubscriptionRequestRequestTypeDef,
    DescribeSpotFleetInstancesRequestRequestTypeDef,
    DescribeSpotFleetRequestHistoryRequestRequestTypeDef,
    DescribeSpotFleetRequestsRequestRequestTypeDef,
    SpotPriceTypeDef,
    DescribeStaleSecurityGroupsRequestRequestTypeDef,
    StoreImageTaskResultTypeDef,
    TagDescriptionTypeDef,
    DescribeVolumeAttributeRequestRequestTypeDef,
    DescribeVolumeAttributeRequestVolumeDescribeAttributeTypeDef,
    VolumeModificationTypeDef,
    DescribeVpcAttributeRequestRequestTypeDef,
    DescribeVpcAttributeRequestVpcDescribeAttributeTypeDef,
    DescribeVpcClassicLinkDnsSupportRequestRequestTypeDef,
    DestinationOptionsResponseTypeDef,
    DetachClassicLinkVpcRequestInstanceDetachClassicLinkVpcTypeDef,
    DetachClassicLinkVpcRequestRequestTypeDef,
    DetachClassicLinkVpcRequestVpcDetachClassicLinkInstanceTypeDef,
    DetachInternetGatewayRequestInternetGatewayDetachFromVpcTypeDef,
    DetachInternetGatewayRequestRequestTypeDef,
    DetachInternetGatewayRequestVpcDetachInternetGatewayTypeDef,
    DetachNetworkInterfaceRequestNetworkInterfaceDetachTypeDef,
    DetachNetworkInterfaceRequestRequestTypeDef,
    DetachVolumeRequestInstanceDetachVolumeTypeDef,
    DetachVolumeRequestRequestTypeDef,
    DetachVolumeRequestVolumeDetachFromInstanceTypeDef,
    DetachVpnGatewayRequestRequestTypeDef,
    DisableEbsEncryptionByDefaultRequestRequestTypeDef,
    DisableFastLaunchRequestRequestTypeDef,
    DisableFastSnapshotRestoreStateErrorTypeDef,
    DisableFastSnapshotRestoreSuccessItemTypeDef,
    DisableFastSnapshotRestoresRequestRequestTypeDef,
    DisableImageDeprecationRequestRequestTypeDef,
    DisableIpamOrganizationAdminAccountRequestRequestTypeDef,
    DisableSerialConsoleAccessRequestRequestTypeDef,
    DisableTransitGatewayRouteTablePropagationRequestRequestTypeDef,
    TransitGatewayPropagationTypeDef,
    DisableVgwRoutePropagationRequestRequestTypeDef,
    DisableVpcClassicLinkDnsSupportRequestRequestTypeDef,
    DisableVpcClassicLinkRequestRequestTypeDef,
    DisableVpcClassicLinkRequestVpcDisableClassicLinkTypeDef,
    DisassociateAddressRequestClassicAddressDisassociateTypeDef,
    DisassociateAddressRequestNetworkInterfaceAssociationDeleteTypeDef,
    DisassociateAddressRequestRequestTypeDef,
    DisassociateClientVpnTargetNetworkRequestRequestTypeDef,
    DisassociateEnclaveCertificateIamRoleRequestRequestTypeDef,
    DisassociateIamInstanceProfileRequestRequestTypeDef,
    DisassociateRouteTableRequestRequestTypeDef,
    DisassociateRouteTableRequestRouteTableAssociationDeleteTypeDef,
    DisassociateRouteTableRequestServiceResourceDisassociateRouteTableTypeDef,
    DisassociateSubnetCidrBlockRequestRequestTypeDef,
    DisassociateTransitGatewayMulticastDomainRequestRequestTypeDef,
    DisassociateTransitGatewayRouteTableRequestRequestTypeDef,
    DisassociateTrunkInterfaceRequestRequestTypeDef,
    DisassociateVpcCidrBlockRequestRequestTypeDef,
    DiskImageDescriptionTypeDef,
    DiskImageDetailTypeDef,
    VolumeDetailTypeDef,
    DiskImageVolumeDescriptionTypeDef,
    DiskInfoTypeDef,
    DnsEntryTypeDef,
    DnsOptionsTypeDef,
    DnsServersOptionsModifyStructureTypeDef,
    EbsOptimizedInfoTypeDef,
    EbsInstanceBlockDeviceSpecificationTypeDef,
    EbsInstanceBlockDeviceTypeDef,
    EfaInfoTypeDef,
    InternetGatewayAttachmentTypeDef,
    ElasticGpuAssociationTypeDef,
    ElasticGpuHealthTypeDef,
    ElasticGpuSpecificationResponseTypeDef,
    ElasticGpuSpecificationTypeDef,
    ElasticInferenceAcceleratorAssociationTypeDef,
    ElasticInferenceAcceleratorTypeDef,
    EnableEbsEncryptionByDefaultRequestRequestTypeDef,
    FastLaunchLaunchTemplateSpecificationRequestTypeDef,
    FastLaunchSnapshotConfigurationRequestTypeDef,
    EnableFastSnapshotRestoreStateErrorTypeDef,
    EnableFastSnapshotRestoreSuccessItemTypeDef,
    EnableFastSnapshotRestoresRequestRequestTypeDef,
    EnableImageDeprecationRequestRequestTypeDef,
    EnableIpamOrganizationAdminAccountRequestRequestTypeDef,
    EnableSerialConsoleAccessRequestRequestTypeDef,
    EnableTransitGatewayRouteTablePropagationRequestRequestTypeDef,
    EnableVgwRoutePropagationRequestRequestTypeDef,
    EnableVolumeIORequestRequestTypeDef,
    EnableVolumeIORequestVolumeEnableIoTypeDef,
    EnableVpcClassicLinkDnsSupportRequestRequestTypeDef,
    EnableVpcClassicLinkRequestRequestTypeDef,
    EnableVpcClassicLinkRequestVpcEnableClassicLinkTypeDef,
    EnclaveOptionsRequestTypeDef,
    EnclaveOptionsTypeDef,
    EventInformationTypeDef,
    TransitGatewayRouteTableRouteTypeDef,
    ExportClientVpnClientCertificateRevocationListRequestRequestTypeDef,
    ExportClientVpnClientConfigurationRequestRequestTypeDef,
    ExportTaskS3LocationRequestTypeDef,
    ExportTaskS3LocationTypeDef,
    ExportToS3TaskTypeDef,
    InstanceExportDetailsTypeDef,
    TargetCapacitySpecificationTypeDef,
    FleetLaunchTemplateSpecificationRequestTypeDef,
    FleetLaunchTemplateSpecificationTypeDef,
    PlacementTypeDef,
    PlacementResponseTypeDef,
    FleetSpotCapacityRebalanceRequestTypeDef,
    FleetSpotCapacityRebalanceTypeDef,
    FpgaDeviceMemoryInfoTypeDef,
    LoadPermissionTypeDef,
    FpgaImageStateTypeDef,
    PciIdTypeDef,
    GetAssociatedEnclaveCertificateIamRolesRequestRequestTypeDef,
    GetAssociatedIpv6PoolCidrsRequestRequestTypeDef,
    Ipv6CidrAssociationTypeDef,
    GetCapacityReservationUsageRequestRequestTypeDef,
    InstanceUsageTypeDef,
    GetConsoleOutputRequestInstanceConsoleOutputTypeDef,
    GetConsoleOutputRequestRequestTypeDef,
    GetConsoleScreenshotRequestRequestTypeDef,
    GetDefaultCreditSpecificationRequestRequestTypeDef,
    InstanceFamilyCreditSpecificationTypeDef,
    GetEbsDefaultKmsKeyIdRequestRequestTypeDef,
    GetEbsEncryptionByDefaultRequestRequestTypeDef,
    GetGroupsForCapacityReservationRequestRequestTypeDef,
    GetHostReservationPurchasePreviewRequestRequestTypeDef,
    PurchaseTypeDef,
    InstanceTypeInfoFromInstanceRequirementsTypeDef,
    GetInstanceUefiDataRequestRequestTypeDef,
    GetIpamAddressHistoryRequestRequestTypeDef,
    IpamAddressHistoryRecordTypeDef,
    GetLaunchTemplateDataRequestRequestTypeDef,
    GetManagedPrefixListAssociationsRequestRequestTypeDef,
    PrefixListAssociationTypeDef,
    GetManagedPrefixListEntriesRequestRequestTypeDef,
    PrefixListEntryTypeDef,
    GetNetworkInsightsAccessScopeAnalysisFindingsRequestRequestTypeDef,
    GetNetworkInsightsAccessScopeContentRequestRequestTypeDef,
    GetPasswordDataRequestInstancePasswordDataTypeDef,
    GetPasswordDataRequestRequestTypeDef,
    ReservationValueTypeDef,
    GetSerialConsoleAccessStatusRequestRequestTypeDef,
    SpotPlacementScoreTypeDef,
    TransitGatewayAttachmentPropagationTypeDef,
    TransitGatewayRouteTableAssociationTypeDef,
    TransitGatewayRouteTablePropagationTypeDef,
    GetVpnConnectionDeviceSampleConfigurationRequestRequestTypeDef,
    GetVpnConnectionDeviceTypesRequestRequestTypeDef,
    VpnConnectionDeviceTypeTypeDef,
    GpuDeviceMemoryInfoTypeDef,
    HibernationOptionsRequestTypeDef,
    HibernationOptionsTypeDef,
    HostInstanceTypeDef,
    HostPropertiesTypeDef,
    IKEVersionsListValueTypeDef,
    IKEVersionsRequestListValueTypeDef,
    IamInstanceProfileTypeDef,
    LaunchPermissionTypeDef,
    UserBucketTypeDef,
    ImageRecycleBinInfoTypeDef,
    StateReasonTypeDef,
    ImportClientVpnClientCertificateRevocationListRequestRequestTypeDef,
    ImportImageLicenseConfigurationRequestTypeDef,
    ImportImageLicenseConfigurationResponseTypeDef,
    UserDataTypeDef,
    InferenceDeviceInfoTypeDef,
    InstanceCountTypeDef,
    InstanceCreditSpecificationRequestTypeDef,
    InstanceEventWindowTimeRangeTypeDef,
    InstanceIpv4PrefixTypeDef,
    InstanceIpv6AddressRequestTypeDef,
    InstanceIpv6PrefixTypeDef,
    InstanceMaintenanceOptionsRequestTypeDef,
    InstanceMaintenanceOptionsTypeDef,
    SpotMarketOptionsTypeDef,
    InstanceMetadataOptionsRequestTypeDef,
    InstanceMetadataOptionsResponseTypeDef,
    MonitoringTypeDef,
    InstanceNetworkInterfaceAssociationTypeDef,
    InstanceNetworkInterfaceAttachmentTypeDef,
    MemoryGiBPerVCpuRequestTypeDef,
    MemoryMiBRequestTypeDef,
    NetworkInterfaceCountRequestTypeDef,
    TotalLocalStorageGBRequestTypeDef,
    VCpuCountRangeRequestTypeDef,
    MemoryGiBPerVCpuTypeDef,
    MemoryMiBTypeDef,
    NetworkInterfaceCountTypeDef,
    TotalLocalStorageGBTypeDef,
    VCpuCountRangeTypeDef,
    InstanceStateTypeDef,
    InstanceStatusDetailsTypeDef,
    InstanceStatusEventTypeDef,
    LicenseConfigurationTypeDef,
    PrivateDnsNameOptionsResponseTypeDef,
    MemoryInfoTypeDef,
    PlacementGroupInfoTypeDef,
    ProcessorInfoTypeDef,
    VCpuInfoTypeDef,
    IpRangeTypeDef,
    Ipv6RangeTypeDef,
    PrefixListIdTypeDef,
    UserIdGroupPairTypeDef,
    IpamCidrAuthorizationContextTypeDef,
    IpamOperatingRegionTypeDef,
    IpamPoolCidrFailureReasonTypeDef,
    IpamResourceTagTypeDef,
    Ipv4PrefixSpecificationResponseTypeDef,
    Ipv6CidrBlockTypeDef,
    PoolCidrBlockTypeDef,
    Ipv6PrefixSpecificationResponseTypeDef,
    Ipv6PrefixSpecificationTypeDef,
    LastErrorTypeDef,
    RunInstancesMonitoringEnabledTypeDef,
    SpotPlacementTypeDef,
    LaunchTemplateEbsBlockDeviceRequestTypeDef,
    LaunchTemplateEbsBlockDeviceTypeDef,
    LaunchTemplateCpuOptionsRequestTypeDef,
    LaunchTemplateCpuOptionsTypeDef,
    LaunchTemplateElasticInferenceAcceleratorResponseTypeDef,
    LaunchTemplateElasticInferenceAcceleratorTypeDef,
    LaunchTemplateEnclaveOptionsRequestTypeDef,
    LaunchTemplateEnclaveOptionsTypeDef,
    LaunchTemplateHibernationOptionsRequestTypeDef,
    LaunchTemplateHibernationOptionsTypeDef,
    LaunchTemplateIamInstanceProfileSpecificationRequestTypeDef,
    LaunchTemplateIamInstanceProfileSpecificationTypeDef,
    LaunchTemplateInstanceMaintenanceOptionsRequestTypeDef,
    LaunchTemplateInstanceMaintenanceOptionsTypeDef,
    LaunchTemplateSpotMarketOptionsRequestTypeDef,
    LaunchTemplateSpotMarketOptionsTypeDef,
    LaunchTemplateInstanceMetadataOptionsRequestTypeDef,
    LaunchTemplateInstanceMetadataOptionsTypeDef,
    LaunchTemplateLicenseConfigurationRequestTypeDef,
    LaunchTemplateLicenseConfigurationTypeDef,
    LaunchTemplatePlacementRequestTypeDef,
    LaunchTemplatePlacementTypeDef,
    LaunchTemplatePrivateDnsNameOptionsRequestTypeDef,
    LaunchTemplatePrivateDnsNameOptionsTypeDef,
    LaunchTemplateSpecificationTypeDef,
    LaunchTemplatesMonitoringRequestTypeDef,
    LaunchTemplatesMonitoringTypeDef,
    LicenseConfigurationRequestTypeDef,
    ListImagesInRecycleBinRequestRequestTypeDef,
    ListSnapshotsInRecycleBinRequestRequestTypeDef,
    SnapshotRecycleBinInfoTypeDef,
    LoadPermissionRequestTypeDef,
    ModifyAddressAttributeRequestRequestTypeDef,
    ModifyAvailabilityZoneGroupRequestRequestTypeDef,
    ModifyCapacityReservationFleetRequestRequestTypeDef,
    ModifyCapacityReservationRequestRequestTypeDef,
    ModifyDefaultCreditSpecificationRequestRequestTypeDef,
    ModifyEbsDefaultKmsKeyIdRequestRequestTypeDef,
    ModifyHostsRequestRequestTypeDef,
    ModifyIdFormatRequestRequestTypeDef,
    ModifyIdentityIdFormatRequestRequestTypeDef,
    SuccessfulInstanceCreditSpecificationItemTypeDef,
    ModifyInstanceEventStartTimeRequestRequestTypeDef,
    ModifyInstanceMaintenanceOptionsRequestRequestTypeDef,
    ModifyInstanceMetadataOptionsRequestRequestTypeDef,
    ModifyInstancePlacementRequestRequestTypeDef,
    RemoveIpamOperatingRegionTypeDef,
    ModifyIpamResourceCidrRequestRequestTypeDef,
    ModifyIpamScopeRequestRequestTypeDef,
    ModifyLaunchTemplateRequestRequestTypeDef,
    RemovePrefixListEntryTypeDef,
    NetworkInterfaceAttachmentChangesTypeDef,
    ModifyPrivateDnsNameOptionsRequestRequestTypeDef,
    ReservedInstancesConfigurationTypeDef,
    ModifySnapshotTierRequestRequestTypeDef,
    ModifyTrafficMirrorFilterNetworkServicesRequestRequestTypeDef,
    ModifyTrafficMirrorSessionRequestRequestTypeDef,
    ModifyTransitGatewayOptionsTypeDef,
    ModifyTransitGatewayPrefixListReferenceRequestRequestTypeDef,
    ModifyTransitGatewayVpcAttachmentRequestOptionsTypeDef,
    ModifyVolumeRequestRequestTypeDef,
    ModifyVpcEndpointConnectionNotificationRequestRequestTypeDef,
    ModifyVpcEndpointServiceConfigurationRequestRequestTypeDef,
    ModifyVpcEndpointServicePayerResponsibilityRequestRequestTypeDef,
    ModifyVpcEndpointServicePermissionsRequestRequestTypeDef,
    PeeringConnectionOptionsRequestTypeDef,
    PeeringConnectionOptionsTypeDef,
    ModifyVpcTenancyRequestRequestTypeDef,
    ModifyVpnConnectionOptionsRequestRequestTypeDef,
    ModifyVpnConnectionRequestRequestTypeDef,
    ModifyVpnTunnelCertificateRequestRequestTypeDef,
    Phase1DHGroupNumbersRequestListValueTypeDef,
    Phase1EncryptionAlgorithmsRequestListValueTypeDef,
    Phase1IntegrityAlgorithmsRequestListValueTypeDef,
    Phase2DHGroupNumbersRequestListValueTypeDef,
    Phase2EncryptionAlgorithmsRequestListValueTypeDef,
    Phase2IntegrityAlgorithmsRequestListValueTypeDef,
    MonitorInstancesRequestInstanceMonitorTypeDef,
    MonitorInstancesRequestRequestTypeDef,
    MoveAddressToVpcRequestRequestTypeDef,
    MoveByoipCidrToIpamRequestRequestTypeDef,
    NatGatewayAddressTypeDef,
    ProvisionedBandwidthTypeDef,
    NetworkAclAssociationTypeDef,
    NetworkCardInfoTypeDef,
    NetworkInterfaceAssociationTypeDef,
    NetworkInterfaceIpv6AddressTypeDef,
    NetworkInterfacePermissionStateTypeDef,
    PacketHeaderStatementRequestTypeDef,
    PacketHeaderStatementTypeDef,
    ResourceStatementRequestTypeDef,
    ResourceStatementTypeDef,
    PeeringAttachmentStatusTypeDef,
    PeeringTgwInfoTypeDef,
    Phase1DHGroupNumbersListValueTypeDef,
    Phase1EncryptionAlgorithmsListValueTypeDef,
    Phase1IntegrityAlgorithmsListValueTypeDef,
    Phase2DHGroupNumbersListValueTypeDef,
    Phase2EncryptionAlgorithmsListValueTypeDef,
    Phase2IntegrityAlgorithmsListValueTypeDef,
    PriceScheduleTypeDef,
    PricingDetailTypeDef,
    PrivateDnsDetailsTypeDef,
    PrivateDnsNameConfigurationTypeDef,
    PrivateDnsNameOptionsOnLaunchTypeDef,
    PrivateDnsNameOptionsRequestTypeDef,
    PropagatingVgwTypeDef,
    ProvisionPublicIpv4PoolCidrRequestRequestTypeDef,
    PublicIpv4PoolRangeTypeDef,
    PurchaseRequestTypeDef,
    ReservedInstanceLimitPriceTypeDef,
    RebootInstancesRequestInstanceRebootTypeDef,
    RebootInstancesRequestRequestTypeDef,
    RecurringChargeTypeDef,
    ReferencedSecurityGroupTypeDef,
    RegisterInstanceTagAttributeRequestTypeDef,
    RegisterTransitGatewayMulticastGroupMembersRequestRequestTypeDef,
    TransitGatewayMulticastRegisteredGroupMembersTypeDef,
    RegisterTransitGatewayMulticastGroupSourcesRequestRequestTypeDef,
    TransitGatewayMulticastRegisteredGroupSourcesTypeDef,
    RejectTransitGatewayMulticastDomainAssociationsRequestRequestTypeDef,
    RejectTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    RejectTransitGatewayVpcAttachmentRequestRequestTypeDef,
    RejectVpcEndpointConnectionsRequestRequestTypeDef,
    RejectVpcPeeringConnectionRequestRequestTypeDef,
    RejectVpcPeeringConnectionRequestVpcPeeringConnectionRejectTypeDef,
    ReleaseAddressRequestClassicAddressReleaseTypeDef,
    ReleaseAddressRequestRequestTypeDef,
    ReleaseAddressRequestVpcAddressReleaseTypeDef,
    ReleaseHostsRequestRequestTypeDef,
    ReleaseIpamPoolAllocationRequestRequestTypeDef,
    ReplaceNetworkAclAssociationRequestNetworkAclReplaceAssociationTypeDef,
    ReplaceNetworkAclAssociationRequestRequestTypeDef,
    ReplaceRouteRequestRequestTypeDef,
    ReplaceRouteRequestRouteReplaceTypeDef,
    ReplaceRouteTableAssociationRequestRequestTypeDef,
    ReplaceRouteTableAssociationRequestRouteTableAssociationReplaceSubnetTypeDef,
    ReplaceTransitGatewayRouteRequestRequestTypeDef,
    ReportInstanceStatusRequestInstanceReportStatusTypeDef,
    ReportInstanceStatusRequestRequestTypeDef,
    ReservedInstancesIdTypeDef,
    ResetAddressAttributeRequestRequestTypeDef,
    ResetEbsDefaultKmsKeyIdRequestRequestTypeDef,
    ResetFpgaImageAttributeRequestRequestTypeDef,
    ResetImageAttributeRequestImageResetAttributeTypeDef,
    ResetImageAttributeRequestRequestTypeDef,
    ResetInstanceAttributeRequestInstanceResetAttributeTypeDef,
    ResetInstanceAttributeRequestInstanceResetKernelTypeDef,
    ResetInstanceAttributeRequestInstanceResetRamdiskTypeDef,
    ResetInstanceAttributeRequestInstanceResetSourceDestCheckTypeDef,
    ResetInstanceAttributeRequestRequestTypeDef,
    ResetNetworkInterfaceAttributeRequestNetworkInterfaceResetAttributeTypeDef,
    ResetNetworkInterfaceAttributeRequestRequestTypeDef,
    ResetSnapshotAttributeRequestRequestTypeDef,
    ResetSnapshotAttributeRequestSnapshotResetAttributeTypeDef,
    RestoreAddressToClassicRequestRequestTypeDef,
    RestoreImageFromRecycleBinRequestRequestTypeDef,
    RestoreManagedPrefixListVersionRequestRequestTypeDef,
    RestoreSnapshotFromRecycleBinRequestRequestTypeDef,
    RestoreSnapshotTierRequestRequestTypeDef,
    RevokeClientVpnIngressRequestRequestTypeDef,
    RouteTypeDef,
    S3StorageTypeDef,
    ScheduledInstanceRecurrenceTypeDef,
    ScheduledInstancesEbsTypeDef,
    ScheduledInstancesIamInstanceProfileTypeDef,
    ScheduledInstancesIpv6AddressTypeDef,
    ScheduledInstancesMonitoringTypeDef,
    ScheduledInstancesPlacementTypeDef,
    ScheduledInstancesPrivateIpAddressConfigTypeDef,
    TransitGatewayMulticastGroupTypeDef,
    SecurityGroupIdentifierTypeDef,
    SecurityGroupRuleDescriptionTypeDef,
    SecurityGroupRuleRequestTypeDef,
    SendDiagnosticInterruptRequestRequestTypeDef,
    ServiceTypeDetailTypeDef,
    ServiceResourceClassicAddressRequestTypeDef,
    ServiceResourceDhcpOptionsRequestTypeDef,
    ServiceResourceImageRequestTypeDef,
    ServiceResourceInstanceRequestTypeDef,
    ServiceResourceInternetGatewayRequestTypeDef,
    ServiceResourceKeyPairRequestTypeDef,
    ServiceResourceNetworkAclRequestTypeDef,
    ServiceResourceNetworkInterfaceAssociationRequestTypeDef,
    ServiceResourceNetworkInterfaceRequestTypeDef,
    ServiceResourcePlacementGroupRequestTypeDef,
    ServiceResourceRouteRequestTypeDef,
    ServiceResourceRouteTableAssociationRequestTypeDef,
    ServiceResourceRouteTableRequestTypeDef,
    ServiceResourceSecurityGroupRequestTypeDef,
    ServiceResourceSnapshotRequestTypeDef,
    ServiceResourceSubnetRequestTypeDef,
    ServiceResourceTagRequestTypeDef,
    ServiceResourceVolumeRequestTypeDef,
    ServiceResourceVpcAddressRequestTypeDef,
    ServiceResourceVpcPeeringConnectionRequestTypeDef,
    ServiceResourceVpcRequestTypeDef,
    UserBucketDetailsTypeDef,
    SpotCapacityRebalanceTypeDef,
    SpotInstanceStateFaultTypeDef,
    SpotFleetMonitoringTypeDef,
    SpotInstanceStatusTypeDef,
    StartInstancesRequestInstanceStartTypeDef,
    StartInstancesRequestRequestTypeDef,
    StartVpcEndpointServicePrivateDnsVerificationRequestRequestTypeDef,
    StopInstancesRequestInstanceStopTypeDef,
    StopInstancesRequestRequestTypeDef,
    SubnetAssociationTypeDef,
    SubnetCidrBlockStateTypeDef,
    TargetConfigurationTypeDef,
    TargetGroupTypeDef,
    TerminateClientVpnConnectionsRequestRequestTypeDef,
    TerminateInstancesRequestInstanceTerminateTypeDef,
    TerminateInstancesRequestRequestTypeDef,
    TrafficMirrorPortRangeTypeDef,
    TransitGatewayAttachmentAssociationTypeDef,
    TransitGatewayAttachmentBgpConfigurationTypeDef,
    TransitGatewayConnectOptionsTypeDef,
    TransitGatewayMulticastDomainOptionsTypeDef,
    TransitGatewayOptionsTypeDef,
    TransitGatewayPrefixListAttachmentTypeDef,
    TransitGatewayRouteAttachmentTypeDef,
    TransitGatewayVpcAttachmentOptionsTypeDef,
    UnassignIpv6AddressesRequestRequestTypeDef,
    UnassignPrivateIpAddressesRequestNetworkInterfaceUnassignPrivateIpAddressesTypeDef,
    UnassignPrivateIpAddressesRequestRequestTypeDef,
    UnmonitorInstancesRequestInstanceUnmonitorTypeDef,
    UnmonitorInstancesRequestRequestTypeDef,
    UnsuccessfulInstanceCreditSpecificationItemErrorTypeDef,
    UnsuccessfulItemErrorTypeDef,
    ValidationErrorTypeDef,
    VgwTelemetryTypeDef,
    VolumeAttachmentTypeDef,
    VolumeStatusActionTypeDef,
    VolumeStatusAttachmentStatusTypeDef,
    VolumeStatusDetailsTypeDef,
    VolumeStatusEventTypeDef,
    VpcCidrBlockStateTypeDef,
    VpcPeeringConnectionOptionsDescriptionTypeDef,
    VpcPeeringConnectionStateReasonTypeDef,
    VpnStaticRouteTypeDef,
    WithdrawByoipCidrRequestRequestTypeDef,
    AcceptReservedInstancesExchangeQuoteRequestRequestTypeDef,
    GetReservedInstancesExchangeQuoteRequestRequestTypeDef,
    AcceptReservedInstancesExchangeQuoteResultTypeDef,
    AllocateAddressResultTypeDef,
    AllocateHostsResultTypeDef,
    ApplySecurityGroupsToClientVpnTargetNetworkResultTypeDef,
    AssignIpv6AddressesResultTypeDef,
    AssociateAddressResultTypeDef,
    AssociateEnclaveCertificateIamRoleResultTypeDef,
    AttachClassicLinkVpcResultTypeDef,
    AttachNetworkInterfaceResultTypeDef,
    CancelCapacityReservationResultTypeDef,
    CancelImportTaskResultTypeDef,
    ConfirmProductInstanceResultTypeDef,
    CopyFpgaImageResultTypeDef,
    CopyImageResultTypeDef,
    CpuOptionsResponseMetadataTypeDef,
    CreateFpgaImageResultTypeDef,
    CreateImageResultTypeDef,
    CreatePublicIpv4PoolResultTypeDef,
    CreateRestoreImageTaskResultTypeDef,
    CreateRouteResultTypeDef,
    CreateStoreImageTaskResultTypeDef,
    DeleteEgressOnlyInternetGatewayResultTypeDef,
    DeleteFpgaImageResultTypeDef,
    DeleteNatGatewayResultTypeDef,
    DeleteNetworkInsightsAccessScopeAnalysisResultTypeDef,
    DeleteNetworkInsightsAccessScopeResultTypeDef,
    DeleteNetworkInsightsAnalysisResultTypeDef,
    DeleteNetworkInsightsPathResultTypeDef,
    DeleteNetworkInterfacePermissionResultTypeDef,
    DeletePublicIpv4PoolResultTypeDef,
    DeleteTrafficMirrorFilterResultTypeDef,
    DeleteTrafficMirrorFilterRuleResultTypeDef,
    DeleteTrafficMirrorSessionResultTypeDef,
    DeleteTrafficMirrorTargetResultTypeDef,
    DeleteVpcPeeringConnectionResultTypeDef,
    DeprovisionPublicIpv4PoolCidrResultTypeDef,
    DetachClassicLinkVpcResultTypeDef,
    DisableEbsEncryptionByDefaultResultTypeDef,
    DisableImageDeprecationResultTypeDef,
    DisableIpamOrganizationAdminAccountResultTypeDef,
    DisableSerialConsoleAccessResultTypeDef,
    DisableVpcClassicLinkDnsSupportResultTypeDef,
    DisableVpcClassicLinkResultTypeDef,
    DisassociateEnclaveCertificateIamRoleResultTypeDef,
    DisassociateTrunkInterfaceResultTypeDef,
    EmptyResponseMetadataTypeDef,
    EnableEbsEncryptionByDefaultResultTypeDef,
    EnableImageDeprecationResultTypeDef,
    EnableIpamOrganizationAdminAccountResultTypeDef,
    EnableSerialConsoleAccessResultTypeDef,
    EnableVpcClassicLinkDnsSupportResultTypeDef,
    EnableVpcClassicLinkResultTypeDef,
    EnclaveOptionsResponseMetadataTypeDef,
    ExportClientVpnClientConfigurationResultTypeDef,
    ExportTransitGatewayRoutesResultTypeDef,
    GetConsoleOutputResultTypeDef,
    GetConsoleScreenshotResultTypeDef,
    GetEbsDefaultKmsKeyIdResultTypeDef,
    GetEbsEncryptionByDefaultResultTypeDef,
    GetFlowLogsIntegrationTemplateResultTypeDef,
    GetInstanceUefiDataResultTypeDef,
    GetPasswordDataResultTypeDef,
    GetSerialConsoleAccessStatusResultTypeDef,
    GetVpnConnectionDeviceSampleConfigurationResultTypeDef,
    HibernationOptionsResponseMetadataTypeDef,
    IamInstanceProfileResponseMetadataTypeDef,
    ImportClientVpnClientCertificateRevocationListResultTypeDef,
    InstanceMaintenanceOptionsResponseMetadataTypeDef,
    InstanceMetadataOptionsResponseResponseMetadataTypeDef,
    InstanceStateResponseMetadataTypeDef,
    ModifyAvailabilityZoneGroupResultTypeDef,
    ModifyCapacityReservationFleetResultTypeDef,
    ModifyCapacityReservationResultTypeDef,
    ModifyClientVpnEndpointResultTypeDef,
    ModifyEbsDefaultKmsKeyIdResultTypeDef,
    ModifyFleetResultTypeDef,
    ModifyInstanceCapacityReservationAttributesResultTypeDef,
    ModifyInstanceMaintenanceOptionsResultTypeDef,
    ModifyInstancePlacementResultTypeDef,
    ModifyPrivateDnsNameOptionsResultTypeDef,
    ModifyReservedInstancesResultTypeDef,
    ModifySecurityGroupRulesResultTypeDef,
    ModifySnapshotTierResultTypeDef,
    ModifySpotFleetRequestResponseTypeDef,
    ModifyVpcEndpointConnectionNotificationResultTypeDef,
    ModifyVpcEndpointResultTypeDef,
    ModifyVpcEndpointServiceConfigurationResultTypeDef,
    ModifyVpcEndpointServicePayerResponsibilityResultTypeDef,
    ModifyVpcEndpointServicePermissionsResultTypeDef,
    ModifyVpcTenancyResultTypeDef,
    MonitoringResponseMetadataTypeDef,
    MoveAddressToVpcResultTypeDef,
    NetworkInterfaceAssociationResponseMetadataTypeDef,
    NetworkInterfaceAttachmentResponseMetadataTypeDef,
    PlacementResponseMetadataTypeDef,
    PrivateDnsNameOptionsOnLaunchResponseMetadataTypeDef,
    PrivateDnsNameOptionsResponseResponseMetadataTypeDef,
    PurchaseReservedInstancesOfferingResultTypeDef,
    RegisterImageResultTypeDef,
    RejectVpcPeeringConnectionResultTypeDef,
    ReleaseIpamPoolAllocationResultTypeDef,
    ReplaceNetworkAclAssociationResultTypeDef,
    RequestSpotFleetResponseTypeDef,
    ResetEbsDefaultKmsKeyIdResultTypeDef,
    ResetFpgaImageAttributeResultTypeDef,
    RestoreAddressToClassicResultTypeDef,
    RestoreImageFromRecycleBinResultTypeDef,
    RestoreSnapshotFromRecycleBinResultTypeDef,
    RestoreSnapshotTierResultTypeDef,
    RouteTableAssociationStateResponseMetadataTypeDef,
    RunScheduledInstancesResultTypeDef,
    StartVpcEndpointServicePrivateDnsVerificationResultTypeDef,
    StateReasonResponseMetadataTypeDef,
    UnassignIpv6AddressesResultTypeDef,
    UpdateSecurityGroupRuleDescriptionsEgressResultTypeDef,
    UpdateSecurityGroupRuleDescriptionsIngressResultTypeDef,
    VolumeAttachmentResponseMetadataTypeDef,
    VpcPeeringConnectionStateReasonResponseMetadataTypeDef,
    AccountAttributeTypeDef,
    DescribeFleetInstancesResultTypeDef,
    DescribeSpotFleetInstancesResponseTypeDef,
    AdditionalDetailTypeDef,
    AnalysisLoadBalancerTargetTypeDef,
    AddressAttributeTypeDef,
    AddressTypeDef,
    CapacityReservationTypeDef,
    CarrierGatewayTypeDef,
    CoipPoolTypeDef,
    CopySnapshotResultTypeDef,
    CreateSecurityGroupResultTypeDef,
    CreateTagsRequestDhcpOptionsCreateTagsTypeDef,
    CreateTagsRequestImageCreateTagsTypeDef,
    CreateTagsRequestInstanceCreateTagsTypeDef,
    CreateTagsRequestInternetGatewayCreateTagsTypeDef,
    CreateTagsRequestNetworkAclCreateTagsTypeDef,
    CreateTagsRequestNetworkInterfaceCreateTagsTypeDef,
    CreateTagsRequestRequestTypeDef,
    CreateTagsRequestRouteTableCreateTagsTypeDef,
    CreateTagsRequestSecurityGroupCreateTagsTypeDef,
    CreateTagsRequestServiceResourceCreateTagsTypeDef,
    CreateTagsRequestSnapshotCreateTagsTypeDef,
    CreateTagsRequestSubnetCreateTagsTypeDef,
    CreateTagsRequestVolumeCreateTagsTypeDef,
    CreateTagsRequestVpcCreateTagsTypeDef,
    CustomerGatewayTypeDef,
    DeleteTagsRequestRequestTypeDef,
    HostReservationTypeDef,
    ImportKeyPairResultTypeDef,
    InstanceDeleteTagsRequestTypeDef,
    InstanceEventWindowAssociationRequestTypeDef,
    InstanceEventWindowAssociationTargetTypeDef,
    InstanceEventWindowDisassociationRequestTypeDef,
    IpamScopeTypeDef,
    KeyPairInfoTypeDef,
    KeyPairTypeDef,
    LaunchTemplateTagSpecificationRequestTypeDef,
    LaunchTemplateTagSpecificationTypeDef,
    LaunchTemplateTypeDef,
    LocalGatewayRouteTableTypeDef,
    LocalGatewayRouteTableVirtualInterfaceGroupAssociationTypeDef,
    LocalGatewayRouteTableVpcAssociationTypeDef,
    LocalGatewayTypeDef,
    LocalGatewayVirtualInterfaceGroupTypeDef,
    LocalGatewayVirtualInterfaceTypeDef,
    ManagedPrefixListTypeDef,
    NetworkInsightsAccessScopeAnalysisTypeDef,
    NetworkInsightsAccessScopeTypeDef,
    NetworkInsightsPathTypeDef,
    PlacementGroupTypeDef,
    ReplaceRootVolumeTaskTypeDef,
    SnapshotInfoTypeDef,
    SnapshotResponseMetadataTypeDef,
    SnapshotTierStatusTypeDef,
    SnapshotTypeDef,
    SpotFleetTagSpecificationTypeDef,
    SubnetCidrReservationTypeDef,
    TagSpecificationTypeDef,
    TrafficMirrorSessionTypeDef,
    TrafficMirrorTargetTypeDef,
    TransitGatewayRouteTableTypeDef,
    TrunkInterfaceAssociationTypeDef,
    VpcClassicLinkTypeDef,
    AdvertiseByoipCidrResultTypeDef,
    DeprovisionByoipCidrResultTypeDef,
    DescribeByoipCidrsResultTypeDef,
    MoveByoipCidrToIpamResultTypeDef,
    ProvisionByoipCidrResultTypeDef,
    WithdrawByoipCidrResultTypeDef,
    AllocateIpamPoolCidrResultTypeDef,
    GetIpamPoolAllocationsResultTypeDef,
    DescribeVpcEndpointServicePermissionsResultTypeDef,
    AnalysisAclRuleTypeDef,
    AnalysisPacketHeaderTypeDef,
    AnalysisSecurityGroupRuleTypeDef,
    AssignPrivateIpAddressesResultTypeDef,
    AssociateClientVpnTargetNetworkResultTypeDef,
    DisassociateClientVpnTargetNetworkResultTypeDef,
    TargetNetworkTypeDef,
    AssociateIamInstanceProfileRequestRequestTypeDef,
    ReplaceIamInstanceProfileAssociationRequestRequestTypeDef,
    AssociateRouteTableResultTypeDef,
    ReplaceRouteTableAssociationResultTypeDef,
    RouteTableAssociationTypeDef,
    AssociateTransitGatewayRouteTableResultTypeDef,
    DisassociateTransitGatewayRouteTableResultTypeDef,
    GetAssociatedEnclaveCertificateIamRolesResultTypeDef,
    IntegrateServicesTypeDef,
    AttachVpnGatewayResultTypeDef,
    VpnGatewayTypeDef,
    DescribeVpcAttributeResultTypeDef,
    ModifySubnetAttributeRequestRequestTypeDef,
    ModifyVolumeAttributeRequestRequestTypeDef,
    ModifyVolumeAttributeRequestVolumeModifyAttributeTypeDef,
    ModifyVpcAttributeRequestRequestTypeDef,
    ModifyVpcAttributeRequestVpcModifyAttributeTypeDef,
    DhcpConfigurationTypeDef,
    AuthorizationRuleTypeDef,
    AuthorizeClientVpnIngressResultTypeDef,
    RevokeClientVpnIngressResultTypeDef,
    AvailabilityZoneTypeDef,
    AvailableCapacityTypeDef,
    BlockDeviceMappingTypeDef,
    FailedCapacityReservationFleetCancellationResultTypeDef,
    CancelSpotFleetRequestsErrorItemTypeDef,
    CancelSpotInstanceRequestsResultTypeDef,
    CapacityReservationFleetTypeDef,
    CreateCapacityReservationFleetResultTypeDef,
    GetGroupsForCapacityReservationResultTypeDef,
    OnDemandOptionsRequestTypeDef,
    OnDemandOptionsTypeDef,
    CapacityReservationSpecificationResponseResponseMetadataTypeDef,
    CapacityReservationSpecificationResponseTypeDef,
    LaunchTemplateCapacityReservationSpecificationResponseTypeDef,
    CapacityReservationSpecificationTypeDef,
    LaunchTemplateCapacityReservationSpecificationRequestTypeDef,
    DescribeVpcClassicLinkDnsSupportResultTypeDef,
    ClassicLinkInstanceTypeDef,
    ClassicLoadBalancersConfigTypeDef,
    ExportClientVpnClientCertificateRevocationListResultTypeDef,
    ClientConnectResponseOptionsTypeDef,
    ClientVpnAuthenticationRequestTypeDef,
    ClientVpnAuthenticationTypeDef,
    ClientVpnConnectionTypeDef,
    TerminateConnectionStatusTypeDef,
    CreateClientVpnEndpointResultTypeDef,
    DeleteClientVpnEndpointResultTypeDef,
    ClientVpnRouteTypeDef,
    CreateClientVpnRouteResultTypeDef,
    DeleteClientVpnRouteResultTypeDef,
    GetCoipPoolUsageResultTypeDef,
    CreateVpcEndpointConnectionNotificationResultTypeDef,
    DescribeVpcEndpointConnectionNotificationsResultTypeDef,
    ModifyInstanceEventWindowRequestRequestTypeDef,
    ModifyIpamPoolRequestRequestTypeDef,
    CreateLocalGatewayRouteResultTypeDef,
    DeleteLocalGatewayRouteResultTypeDef,
    SearchLocalGatewayRoutesResultTypeDef,
    CreateNetworkAclEntryRequestNetworkAclCreateEntryTypeDef,
    CreateNetworkAclEntryRequestRequestTypeDef,
    NetworkAclEntryTypeDef,
    ReplaceNetworkAclEntryRequestNetworkAclReplaceEntryTypeDef,
    ReplaceNetworkAclEntryRequestRequestTypeDef,
    InstanceNetworkInterfaceSpecificationTypeDef,
    CreateReservedInstancesListingRequestRequestTypeDef,
    CreateStoreImageTaskRequestRequestTypeDef,
    CreateTrafficMirrorFilterRuleRequestRequestTypeDef,
    ModifyTrafficMirrorFilterRuleRequestRequestTypeDef,
    CreateVolumePermissionModificationsTypeDef,
    ModifyVpcEndpointRequestRequestTypeDef,
    DeleteFleetErrorItemTypeDef,
    DeleteInstanceEventWindowResultTypeDef,
    DeleteLaunchTemplateVersionsResponseErrorItemTypeDef,
    FailedQueuedPurchaseDeletionTypeDef,
    DeregisterInstanceEventNotificationAttributesRequestRequestTypeDef,
    DeregisterInstanceEventNotificationAttributesResultTypeDef,
    DescribeInstanceEventNotificationAttributesResultTypeDef,
    RegisterInstanceEventNotificationAttributesResultTypeDef,
    DeregisterTransitGatewayMulticastGroupMembersResultTypeDef,
    DeregisterTransitGatewayMulticastGroupSourcesResultTypeDef,
    DescribeAddressesAttributeRequestDescribeAddressesAttributePaginateTypeDef,
    DescribeByoipCidrsRequestDescribeByoipCidrsPaginateTypeDef,
    DescribePrincipalIdFormatRequestDescribePrincipalIdFormatPaginateTypeDef,
    DescribeSpotFleetInstancesRequestDescribeSpotFleetInstancesPaginateTypeDef,
    DescribeSpotFleetRequestsRequestDescribeSpotFleetRequestsPaginateTypeDef,
    DescribeStaleSecurityGroupsRequestDescribeStaleSecurityGroupsPaginateTypeDef,
    DescribeVpcClassicLinkDnsSupportRequestDescribeVpcClassicLinkDnsSupportPaginateTypeDef,
    GetAssociatedIpv6PoolCidrsRequestGetAssociatedIpv6PoolCidrsPaginateTypeDef,
    GetGroupsForCapacityReservationRequestGetGroupsForCapacityReservationPaginateTypeDef,
    GetIpamAddressHistoryRequestGetIpamAddressHistoryPaginateTypeDef,
    GetManagedPrefixListAssociationsRequestGetManagedPrefixListAssociationsPaginateTypeDef,
    GetManagedPrefixListEntriesRequestGetManagedPrefixListEntriesPaginateTypeDef,
    GetVpnConnectionDeviceTypesRequestGetVpnConnectionDeviceTypesPaginateTypeDef,
    ListImagesInRecycleBinRequestListImagesInRecycleBinPaginateTypeDef,
    ListSnapshotsInRecycleBinRequestListSnapshotsInRecycleBinPaginateTypeDef,
    DescribeAddressesRequestRequestTypeDef,
    DescribeAvailabilityZonesRequestRequestTypeDef,
    DescribeBundleTasksRequestRequestTypeDef,
    DescribeCapacityReservationFleetsRequestDescribeCapacityReservationFleetsPaginateTypeDef,
    DescribeCapacityReservationFleetsRequestRequestTypeDef,
    DescribeCapacityReservationsRequestDescribeCapacityReservationsPaginateTypeDef,
    DescribeCapacityReservationsRequestRequestTypeDef,
    DescribeCarrierGatewaysRequestDescribeCarrierGatewaysPaginateTypeDef,
    DescribeCarrierGatewaysRequestRequestTypeDef,
    DescribeClassicLinkInstancesRequestDescribeClassicLinkInstancesPaginateTypeDef,
    DescribeClassicLinkInstancesRequestRequestTypeDef,
    DescribeClientVpnAuthorizationRulesRequestDescribeClientVpnAuthorizationRulesPaginateTypeDef,
    DescribeClientVpnAuthorizationRulesRequestRequestTypeDef,
    DescribeClientVpnConnectionsRequestDescribeClientVpnConnectionsPaginateTypeDef,
    DescribeClientVpnConnectionsRequestRequestTypeDef,
    DescribeClientVpnEndpointsRequestDescribeClientVpnEndpointsPaginateTypeDef,
    DescribeClientVpnEndpointsRequestRequestTypeDef,
    DescribeClientVpnRoutesRequestDescribeClientVpnRoutesPaginateTypeDef,
    DescribeClientVpnRoutesRequestRequestTypeDef,
    DescribeClientVpnTargetNetworksRequestDescribeClientVpnTargetNetworksPaginateTypeDef,
    DescribeClientVpnTargetNetworksRequestRequestTypeDef,
    DescribeCoipPoolsRequestDescribeCoipPoolsPaginateTypeDef,
    DescribeCoipPoolsRequestRequestTypeDef,
    DescribeCustomerGatewaysRequestRequestTypeDef,
    DescribeDhcpOptionsRequestDescribeDhcpOptionsPaginateTypeDef,
    DescribeDhcpOptionsRequestRequestTypeDef,
    DescribeEgressOnlyInternetGatewaysRequestDescribeEgressOnlyInternetGatewaysPaginateTypeDef,
    DescribeEgressOnlyInternetGatewaysRequestRequestTypeDef,
    DescribeElasticGpusRequestRequestTypeDef,
    DescribeExportImageTasksRequestDescribeExportImageTasksPaginateTypeDef,
    DescribeExportImageTasksRequestRequestTypeDef,
    DescribeExportTasksRequestRequestTypeDef,
    DescribeFastLaunchImagesRequestDescribeFastLaunchImagesPaginateTypeDef,
    DescribeFastLaunchImagesRequestRequestTypeDef,
    DescribeFastSnapshotRestoresRequestDescribeFastSnapshotRestoresPaginateTypeDef,
    DescribeFastSnapshotRestoresRequestRequestTypeDef,
    DescribeFleetInstancesRequestRequestTypeDef,
    DescribeFleetsRequestDescribeFleetsPaginateTypeDef,
    DescribeFleetsRequestRequestTypeDef,
    DescribeFlowLogsRequestDescribeFlowLogsPaginateTypeDef,
    DescribeFlowLogsRequestRequestTypeDef,
    DescribeFpgaImagesRequestDescribeFpgaImagesPaginateTypeDef,
    DescribeFpgaImagesRequestRequestTypeDef,
    DescribeHostReservationOfferingsRequestDescribeHostReservationOfferingsPaginateTypeDef,
    DescribeHostReservationOfferingsRequestRequestTypeDef,
    DescribeHostReservationsRequestDescribeHostReservationsPaginateTypeDef,
    DescribeHostReservationsRequestRequestTypeDef,
    DescribeHostsRequestDescribeHostsPaginateTypeDef,
    DescribeHostsRequestRequestTypeDef,
    DescribeIamInstanceProfileAssociationsRequestDescribeIamInstanceProfileAssociationsPaginateTypeDef,
    DescribeIamInstanceProfileAssociationsRequestRequestTypeDef,
    DescribeImagesRequestRequestTypeDef,
    DescribeImportImageTasksRequestDescribeImportImageTasksPaginateTypeDef,
    DescribeImportImageTasksRequestRequestTypeDef,
    DescribeImportSnapshotTasksRequestDescribeImportSnapshotTasksPaginateTypeDef,
    DescribeImportSnapshotTasksRequestRequestTypeDef,
    DescribeInstanceCreditSpecificationsRequestDescribeInstanceCreditSpecificationsPaginateTypeDef,
    DescribeInstanceCreditSpecificationsRequestRequestTypeDef,
    DescribeInstanceEventWindowsRequestDescribeInstanceEventWindowsPaginateTypeDef,
    DescribeInstanceEventWindowsRequestRequestTypeDef,
    DescribeInstanceStatusRequestDescribeInstanceStatusPaginateTypeDef,
    DescribeInstanceStatusRequestRequestTypeDef,
    DescribeInstanceTypeOfferingsRequestDescribeInstanceTypeOfferingsPaginateTypeDef,
    DescribeInstanceTypeOfferingsRequestRequestTypeDef,
    DescribeInstanceTypesRequestDescribeInstanceTypesPaginateTypeDef,
    DescribeInstanceTypesRequestRequestTypeDef,
    DescribeInstancesRequestDescribeInstancesPaginateTypeDef,
    DescribeInstancesRequestRequestTypeDef,
    DescribeInternetGatewaysRequestDescribeInternetGatewaysPaginateTypeDef,
    DescribeInternetGatewaysRequestRequestTypeDef,
    DescribeIpamPoolsRequestDescribeIpamPoolsPaginateTypeDef,
    DescribeIpamPoolsRequestRequestTypeDef,
    DescribeIpamScopesRequestDescribeIpamScopesPaginateTypeDef,
    DescribeIpamScopesRequestRequestTypeDef,
    DescribeIpamsRequestDescribeIpamsPaginateTypeDef,
    DescribeIpamsRequestRequestTypeDef,
    DescribeIpv6PoolsRequestDescribeIpv6PoolsPaginateTypeDef,
    DescribeIpv6PoolsRequestRequestTypeDef,
    DescribeKeyPairsRequestRequestTypeDef,
    DescribeLaunchTemplateVersionsRequestDescribeLaunchTemplateVersionsPaginateTypeDef,
    DescribeLaunchTemplateVersionsRequestRequestTypeDef,
    DescribeLaunchTemplatesRequestDescribeLaunchTemplatesPaginateTypeDef,
    DescribeLaunchTemplatesRequestRequestTypeDef,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginateTypeDef,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestRequestTypeDef,
    DescribeLocalGatewayRouteTableVpcAssociationsRequestDescribeLocalGatewayRouteTableVpcAssociationsPaginateTypeDef,
    DescribeLocalGatewayRouteTableVpcAssociationsRequestRequestTypeDef,
    DescribeLocalGatewayRouteTablesRequestDescribeLocalGatewayRouteTablesPaginateTypeDef,
    DescribeLocalGatewayRouteTablesRequestRequestTypeDef,
    DescribeLocalGatewayVirtualInterfaceGroupsRequestDescribeLocalGatewayVirtualInterfaceGroupsPaginateTypeDef,
    DescribeLocalGatewayVirtualInterfaceGroupsRequestRequestTypeDef,
    DescribeLocalGatewayVirtualInterfacesRequestDescribeLocalGatewayVirtualInterfacesPaginateTypeDef,
    DescribeLocalGatewayVirtualInterfacesRequestRequestTypeDef,
    DescribeLocalGatewaysRequestDescribeLocalGatewaysPaginateTypeDef,
    DescribeLocalGatewaysRequestRequestTypeDef,
    DescribeManagedPrefixListsRequestDescribeManagedPrefixListsPaginateTypeDef,
    DescribeManagedPrefixListsRequestRequestTypeDef,
    DescribeMovingAddressesRequestDescribeMovingAddressesPaginateTypeDef,
    DescribeMovingAddressesRequestRequestTypeDef,
    DescribeNatGatewaysRequestDescribeNatGatewaysPaginateTypeDef,
    DescribeNatGatewaysRequestRequestTypeDef,
    DescribeNetworkAclsRequestDescribeNetworkAclsPaginateTypeDef,
    DescribeNetworkAclsRequestRequestTypeDef,
    DescribeNetworkInsightsAccessScopeAnalysesRequestDescribeNetworkInsightsAccessScopeAnalysesPaginateTypeDef,
    DescribeNetworkInsightsAccessScopeAnalysesRequestRequestTypeDef,
    DescribeNetworkInsightsAccessScopesRequestDescribeNetworkInsightsAccessScopesPaginateTypeDef,
    DescribeNetworkInsightsAccessScopesRequestRequestTypeDef,
    DescribeNetworkInsightsAnalysesRequestDescribeNetworkInsightsAnalysesPaginateTypeDef,
    DescribeNetworkInsightsAnalysesRequestRequestTypeDef,
    DescribeNetworkInsightsPathsRequestDescribeNetworkInsightsPathsPaginateTypeDef,
    DescribeNetworkInsightsPathsRequestRequestTypeDef,
    DescribeNetworkInterfacePermissionsRequestDescribeNetworkInterfacePermissionsPaginateTypeDef,
    DescribeNetworkInterfacePermissionsRequestRequestTypeDef,
    DescribeNetworkInterfacesRequestDescribeNetworkInterfacesPaginateTypeDef,
    DescribeNetworkInterfacesRequestRequestTypeDef,
    DescribePlacementGroupsRequestRequestTypeDef,
    DescribePrefixListsRequestDescribePrefixListsPaginateTypeDef,
    DescribePrefixListsRequestRequestTypeDef,
    DescribePublicIpv4PoolsRequestDescribePublicIpv4PoolsPaginateTypeDef,
    DescribePublicIpv4PoolsRequestRequestTypeDef,
    DescribeRegionsRequestRequestTypeDef,
    DescribeReplaceRootVolumeTasksRequestDescribeReplaceRootVolumeTasksPaginateTypeDef,
    DescribeReplaceRootVolumeTasksRequestRequestTypeDef,
    DescribeReservedInstancesListingsRequestRequestTypeDef,
    DescribeReservedInstancesModificationsRequestDescribeReservedInstancesModificationsPaginateTypeDef,
    DescribeReservedInstancesModificationsRequestRequestTypeDef,
    DescribeReservedInstancesOfferingsRequestDescribeReservedInstancesOfferingsPaginateTypeDef,
    DescribeReservedInstancesOfferingsRequestRequestTypeDef,
    DescribeReservedInstancesRequestRequestTypeDef,
    DescribeRouteTablesRequestDescribeRouteTablesPaginateTypeDef,
    DescribeRouteTablesRequestRequestTypeDef,
    DescribeSecurityGroupRulesRequestDescribeSecurityGroupRulesPaginateTypeDef,
    DescribeSecurityGroupRulesRequestRequestTypeDef,
    DescribeSecurityGroupsRequestDescribeSecurityGroupsPaginateTypeDef,
    DescribeSecurityGroupsRequestRequestTypeDef,
    DescribeSnapshotTierStatusRequestDescribeSnapshotTierStatusPaginateTypeDef,
    DescribeSnapshotTierStatusRequestRequestTypeDef,
    DescribeSnapshotsRequestDescribeSnapshotsPaginateTypeDef,
    DescribeSnapshotsRequestRequestTypeDef,
    DescribeSpotInstanceRequestsRequestDescribeSpotInstanceRequestsPaginateTypeDef,
    DescribeSpotInstanceRequestsRequestRequestTypeDef,
    DescribeSpotPriceHistoryRequestDescribeSpotPriceHistoryPaginateTypeDef,
    DescribeSpotPriceHistoryRequestRequestTypeDef,
    DescribeStoreImageTasksRequestDescribeStoreImageTasksPaginateTypeDef,
    DescribeStoreImageTasksRequestRequestTypeDef,
    DescribeSubnetsRequestDescribeSubnetsPaginateTypeDef,
    DescribeSubnetsRequestRequestTypeDef,
    DescribeTagsRequestDescribeTagsPaginateTypeDef,
    DescribeTagsRequestRequestTypeDef,
    DescribeTrafficMirrorFiltersRequestDescribeTrafficMirrorFiltersPaginateTypeDef,
    DescribeTrafficMirrorFiltersRequestRequestTypeDef,
    DescribeTrafficMirrorSessionsRequestDescribeTrafficMirrorSessionsPaginateTypeDef,
    DescribeTrafficMirrorSessionsRequestRequestTypeDef,
    DescribeTrafficMirrorTargetsRequestDescribeTrafficMirrorTargetsPaginateTypeDef,
    DescribeTrafficMirrorTargetsRequestRequestTypeDef,
    DescribeTransitGatewayAttachmentsRequestDescribeTransitGatewayAttachmentsPaginateTypeDef,
    DescribeTransitGatewayAttachmentsRequestRequestTypeDef,
    DescribeTransitGatewayConnectPeersRequestDescribeTransitGatewayConnectPeersPaginateTypeDef,
    DescribeTransitGatewayConnectPeersRequestRequestTypeDef,
    DescribeTransitGatewayConnectsRequestDescribeTransitGatewayConnectsPaginateTypeDef,
    DescribeTransitGatewayConnectsRequestRequestTypeDef,
    DescribeTransitGatewayMulticastDomainsRequestDescribeTransitGatewayMulticastDomainsPaginateTypeDef,
    DescribeTransitGatewayMulticastDomainsRequestRequestTypeDef,
    DescribeTransitGatewayPeeringAttachmentsRequestDescribeTransitGatewayPeeringAttachmentsPaginateTypeDef,
    DescribeTransitGatewayPeeringAttachmentsRequestRequestTypeDef,
    DescribeTransitGatewayRouteTablesRequestDescribeTransitGatewayRouteTablesPaginateTypeDef,
    DescribeTransitGatewayRouteTablesRequestRequestTypeDef,
    DescribeTransitGatewayVpcAttachmentsRequestDescribeTransitGatewayVpcAttachmentsPaginateTypeDef,
    DescribeTransitGatewayVpcAttachmentsRequestRequestTypeDef,
    DescribeTransitGatewaysRequestDescribeTransitGatewaysPaginateTypeDef,
    DescribeTransitGatewaysRequestRequestTypeDef,
    DescribeTrunkInterfaceAssociationsRequestDescribeTrunkInterfaceAssociationsPaginateTypeDef,
    DescribeTrunkInterfaceAssociationsRequestRequestTypeDef,
    DescribeVolumeStatusRequestDescribeVolumeStatusPaginateTypeDef,
    DescribeVolumeStatusRequestRequestTypeDef,
    DescribeVolumeStatusRequestVolumeDescribeStatusTypeDef,
    DescribeVolumesModificationsRequestDescribeVolumesModificationsPaginateTypeDef,
    DescribeVolumesModificationsRequestRequestTypeDef,
    DescribeVolumesRequestDescribeVolumesPaginateTypeDef,
    DescribeVolumesRequestRequestTypeDef,
    DescribeVpcClassicLinkRequestRequestTypeDef,
    DescribeVpcEndpointConnectionNotificationsRequestDescribeVpcEndpointConnectionNotificationsPaginateTypeDef,
    DescribeVpcEndpointConnectionNotificationsRequestRequestTypeDef,
    DescribeVpcEndpointConnectionsRequestDescribeVpcEndpointConnectionsPaginateTypeDef,
    DescribeVpcEndpointConnectionsRequestRequestTypeDef,
    DescribeVpcEndpointServiceConfigurationsRequestDescribeVpcEndpointServiceConfigurationsPaginateTypeDef,
    DescribeVpcEndpointServiceConfigurationsRequestRequestTypeDef,
    DescribeVpcEndpointServicePermissionsRequestDescribeVpcEndpointServicePermissionsPaginateTypeDef,
    DescribeVpcEndpointServicePermissionsRequestRequestTypeDef,
    DescribeVpcEndpointServicesRequestDescribeVpcEndpointServicesPaginateTypeDef,
    DescribeVpcEndpointServicesRequestRequestTypeDef,
    DescribeVpcEndpointsRequestDescribeVpcEndpointsPaginateTypeDef,
    DescribeVpcEndpointsRequestRequestTypeDef,
    DescribeVpcPeeringConnectionsRequestDescribeVpcPeeringConnectionsPaginateTypeDef,
    DescribeVpcPeeringConnectionsRequestRequestTypeDef,
    DescribeVpcsRequestDescribeVpcsPaginateTypeDef,
    DescribeVpcsRequestRequestTypeDef,
    DescribeVpnConnectionsRequestRequestTypeDef,
    DescribeVpnGatewaysRequestRequestTypeDef,
    ExportTransitGatewayRoutesRequestRequestTypeDef,
    GetCoipPoolUsageRequestRequestTypeDef,
    GetIpamPoolAllocationsRequestGetIpamPoolAllocationsPaginateTypeDef,
    GetIpamPoolAllocationsRequestRequestTypeDef,
    GetIpamPoolCidrsRequestGetIpamPoolCidrsPaginateTypeDef,
    GetIpamPoolCidrsRequestRequestTypeDef,
    GetIpamResourceCidrsRequestGetIpamResourceCidrsPaginateTypeDef,
    GetIpamResourceCidrsRequestRequestTypeDef,
    GetSubnetCidrReservationsRequestRequestTypeDef,
    GetTransitGatewayAttachmentPropagationsRequestGetTransitGatewayAttachmentPropagationsPaginateTypeDef,
    GetTransitGatewayAttachmentPropagationsRequestRequestTypeDef,
    GetTransitGatewayMulticastDomainAssociationsRequestGetTransitGatewayMulticastDomainAssociationsPaginateTypeDef,
    GetTransitGatewayMulticastDomainAssociationsRequestRequestTypeDef,
    GetTransitGatewayPrefixListReferencesRequestGetTransitGatewayPrefixListReferencesPaginateTypeDef,
    GetTransitGatewayPrefixListReferencesRequestRequestTypeDef,
    GetTransitGatewayRouteTableAssociationsRequestGetTransitGatewayRouteTableAssociationsPaginateTypeDef,
    GetTransitGatewayRouteTableAssociationsRequestRequestTypeDef,
    GetTransitGatewayRouteTablePropagationsRequestGetTransitGatewayRouteTablePropagationsPaginateTypeDef,
    GetTransitGatewayRouteTablePropagationsRequestRequestTypeDef,
    SearchLocalGatewayRoutesRequestRequestTypeDef,
    SearchLocalGatewayRoutesRequestSearchLocalGatewayRoutesPaginateTypeDef,
    SearchTransitGatewayMulticastGroupsRequestRequestTypeDef,
    SearchTransitGatewayMulticastGroupsRequestSearchTransitGatewayMulticastGroupsPaginateTypeDef,
    SearchTransitGatewayRoutesRequestRequestTypeDef,
    DescribeAggregateIdFormatResultTypeDef,
    DescribeIdFormatResultTypeDef,
    DescribeIdentityIdFormatResultTypeDef,
    PrincipalIdFormatTypeDef,
    DescribeBundleTasksRequestBundleTaskCompleteWaitTypeDef,
    DescribeConversionTasksRequestConversionTaskCancelledWaitTypeDef,
    DescribeConversionTasksRequestConversionTaskCompletedWaitTypeDef,
    DescribeConversionTasksRequestConversionTaskDeletedWaitTypeDef,
    DescribeCustomerGatewaysRequestCustomerGatewayAvailableWaitTypeDef,
    DescribeExportTasksRequestExportTaskCancelledWaitTypeDef,
    DescribeExportTasksRequestExportTaskCompletedWaitTypeDef,
    DescribeImagesRequestImageAvailableWaitTypeDef,
    DescribeImagesRequestImageExistsWaitTypeDef,
    DescribeInstanceStatusRequestInstanceStatusOkWaitTypeDef,
    DescribeInstanceStatusRequestSystemStatusOkWaitTypeDef,
    DescribeInstancesRequestInstanceExistsWaitTypeDef,
    DescribeInstancesRequestInstanceRunningWaitTypeDef,
    DescribeInstancesRequestInstanceStoppedWaitTypeDef,
    DescribeInstancesRequestInstanceTerminatedWaitTypeDef,
    DescribeInternetGatewaysRequestInternetGatewayExistsWaitTypeDef,
    DescribeKeyPairsRequestKeyPairExistsWaitTypeDef,
    DescribeNatGatewaysRequestNatGatewayAvailableWaitTypeDef,
    DescribeNatGatewaysRequestNatGatewayDeletedWaitTypeDef,
    DescribeNetworkInterfacesRequestNetworkInterfaceAvailableWaitTypeDef,
    DescribeSecurityGroupsRequestSecurityGroupExistsWaitTypeDef,
    DescribeSnapshotsRequestSnapshotCompletedWaitTypeDef,
    DescribeSpotInstanceRequestsRequestSpotInstanceRequestFulfilledWaitTypeDef,
    DescribeSubnetsRequestSubnetAvailableWaitTypeDef,
    DescribeVolumesRequestVolumeAvailableWaitTypeDef,
    DescribeVolumesRequestVolumeDeletedWaitTypeDef,
    DescribeVolumesRequestVolumeInUseWaitTypeDef,
    DescribeVpcPeeringConnectionsRequestVpcPeeringConnectionDeletedWaitTypeDef,
    DescribeVpcPeeringConnectionsRequestVpcPeeringConnectionExistsWaitTypeDef,
    DescribeVpcsRequestVpcAvailableWaitTypeDef,
    DescribeVpcsRequestVpcExistsWaitTypeDef,
    DescribeVpnConnectionsRequestVpnConnectionAvailableWaitTypeDef,
    DescribeVpnConnectionsRequestVpnConnectionDeletedWaitTypeDef,
    GetPasswordDataRequestPasswordDataAvailableWaitTypeDef,
    DescribeFastLaunchImagesSuccessItemTypeDef,
    DisableFastLaunchResultTypeDef,
    EnableFastLaunchResultTypeDef,
    DescribeFastSnapshotRestoresResultTypeDef,
    DescribeHostReservationOfferingsResultTypeDef,
    DescribeInstanceCreditSpecificationsResultTypeDef,
    DescribeInstanceTypeOfferingsResultTypeDef,
    DescribeMovingAddressesResultTypeDef,
    DescribeNetworkInterfaceAttributeResultTypeDef,
    DescribePrefixListsResultTypeDef,
    DescribeRegionsResultTypeDef,
    DescribeScheduledInstanceAvailabilityRequestDescribeScheduledInstanceAvailabilityPaginateTypeDef,
    DescribeScheduledInstanceAvailabilityRequestRequestTypeDef,
    DescribeScheduledInstancesRequestDescribeScheduledInstancesPaginateTypeDef,
    DescribeScheduledInstancesRequestRequestTypeDef,
    DescribeSecurityGroupReferencesResultTypeDef,
    DescribeSnapshotAttributeResultTypeDef,
    DescribeVolumeAttributeResultTypeDef,
    DescribeSpotPriceHistoryResultTypeDef,
    DescribeStoreImageTasksResultTypeDef,
    DescribeTagsResultTypeDef,
    DescribeVolumesModificationsResultTypeDef,
    ModifyVolumeResultTypeDef,
    FlowLogTypeDef,
    DisableFastSnapshotRestoreStateErrorItemTypeDef,
    DisableTransitGatewayRouteTablePropagationResultTypeDef,
    EnableTransitGatewayRouteTablePropagationResultTypeDef,
    DiskImageTypeDef,
    ImportVolumeRequestRequestTypeDef,
    ImportInstanceVolumeDetailItemTypeDef,
    ImportVolumeTaskDetailsTypeDef,
    InstanceStorageInfoTypeDef,
    VpcEndpointConnectionTypeDef,
    ModifyClientVpnEndpointRequestRequestTypeDef,
    EbsInfoTypeDef,
    InstanceBlockDeviceMappingSpecificationTypeDef,
    InstanceBlockDeviceMappingTypeDef,
    EgressOnlyInternetGatewayTypeDef,
    InternetGatewayTypeDef,
    ElasticGpusTypeDef,
    EnableFastLaunchRequestRequestTypeDef,
    EnableFastSnapshotRestoreStateErrorItemTypeDef,
    HistoryRecordEntryTypeDef,
    HistoryRecordTypeDef,
    ExportImageResultTypeDef,
    ExportImageTaskTypeDef,
    ExportTaskTypeDef,
    FleetSpotMaintenanceStrategiesRequestTypeDef,
    FleetSpotMaintenanceStrategiesTypeDef,
    FpgaDeviceInfoTypeDef,
    FpgaImageAttributeTypeDef,
    FpgaImageTypeDef,
    GetAssociatedIpv6PoolCidrsResultTypeDef,
    GetCapacityReservationUsageResultTypeDef,
    GetDefaultCreditSpecificationResultTypeDef,
    ModifyDefaultCreditSpecificationResultTypeDef,
    GetHostReservationPurchasePreviewResultTypeDef,
    PurchaseHostReservationResultTypeDef,
    GetInstanceTypesFromInstanceRequirementsResultTypeDef,
    GetIpamAddressHistoryResultTypeDef,
    GetManagedPrefixListAssociationsResultTypeDef,
    GetManagedPrefixListEntriesResultTypeDef,
    ReservedInstanceReservationValueTypeDef,
    GetSpotPlacementScoresResultTypeDef,
    GetTransitGatewayAttachmentPropagationsResultTypeDef,
    GetTransitGatewayRouteTableAssociationsResultTypeDef,
    GetTransitGatewayRouteTablePropagationsResultTypeDef,
    GetVpnConnectionDeviceTypesResultTypeDef,
    GpuDeviceInfoTypeDef,
    IamInstanceProfileAssociationTypeDef,
    LaunchPermissionModificationsTypeDef,
    ImageDiskContainerTypeDef,
    SnapshotDiskContainerTypeDef,
    ListImagesInRecycleBinResultTypeDef,
    ImportInstanceLaunchSpecificationTypeDef,
    InferenceAcceleratorInfoTypeDef,
    ModifyInstanceCreditSpecificationRequestRequestTypeDef,
    LaunchTemplateInstanceNetworkInterfaceSpecificationRequestTypeDef,
    InstanceMarketOptionsRequestTypeDef,
    ModifyInstanceMetadataOptionsResultTypeDef,
    InstanceMonitoringTypeDef,
    InstancePrivateIpAddressTypeDef,
    InstanceRequirementsRequestTypeDef,
    InstanceRequirementsTypeDef,
    InstanceStateChangeTypeDef,
    InstanceStatusSummaryTypeDef,
    ModifyInstanceEventStartTimeResultTypeDef,
    IpPermissionTypeDef,
    StaleIpPermissionTypeDef,
    ProvisionIpamPoolCidrRequestRequestTypeDef,
    IpamTypeDef,
    IpamPoolCidrTypeDef,
    IpamPoolTypeDef,
    IpamResourceCidrTypeDef,
    Ipv6PoolTypeDef,
    LaunchTemplateInstanceNetworkInterfaceSpecificationTypeDef,
    LaunchTemplateBlockDeviceMappingRequestTypeDef,
    LaunchTemplateBlockDeviceMappingTypeDef,
    LaunchTemplateInstanceMarketOptionsRequestTypeDef,
    LaunchTemplateInstanceMarketOptionsTypeDef,
    ListSnapshotsInRecycleBinResultTypeDef,
    LoadPermissionModificationsTypeDef,
    ModifyIpamRequestRequestTypeDef,
    ModifyManagedPrefixListRequestRequestTypeDef,
    ModifyNetworkInterfaceAttributeRequestNetworkInterfaceModifyAttributeTypeDef,
    ModifyNetworkInterfaceAttributeRequestRequestTypeDef,
    ModifyReservedInstancesRequestRequestTypeDef,
    ReservedInstancesModificationResultTypeDef,
    ModifyTransitGatewayRequestRequestTypeDef,
    ModifyTransitGatewayVpcAttachmentRequestRequestTypeDef,
    ModifyVpcPeeringConnectionOptionsRequestRequestTypeDef,
    ModifyVpcPeeringConnectionOptionsResultTypeDef,
    ModifyVpnTunnelOptionsSpecificationTypeDef,
    VpnTunnelOptionsSpecificationTypeDef,
    NatGatewayTypeDef,
    NetworkInfoTypeDef,
    NetworkInterfacePrivateIpAddressTypeDef,
    NetworkInterfacePermissionTypeDef,
    PathStatementRequestTypeDef,
    ThroughResourcesStatementRequestTypeDef,
    PathStatementTypeDef,
    ThroughResourcesStatementTypeDef,
    TransitGatewayPeeringAttachmentTypeDef,
    TunnelOptionTypeDef,
    ReservedInstancesListingTypeDef,
    ProvisionPublicIpv4PoolCidrResultTypeDef,
    PublicIpv4PoolTypeDef,
    PurchaseScheduledInstancesRequestRequestTypeDef,
    PurchaseReservedInstancesOfferingRequestRequestTypeDef,
    ReservedInstancesOfferingTypeDef,
    ReservedInstancesTypeDef,
    SecurityGroupRuleTypeDef,
    RegisterInstanceEventNotificationAttributesRequestRequestTypeDef,
    RegisterTransitGatewayMulticastGroupMembersResultTypeDef,
    RegisterTransitGatewayMulticastGroupSourcesResultTypeDef,
    StorageTypeDef,
    ScheduledInstanceAvailabilityTypeDef,
    ScheduledInstanceTypeDef,
    ScheduledInstancesBlockDeviceMappingTypeDef,
    ScheduledInstancesNetworkInterfaceTypeDef,
    SearchTransitGatewayMulticastGroupsResultTypeDef,
    VpcEndpointTypeDef,
    SecurityGroupRuleUpdateTypeDef,
    ServiceConfigurationTypeDef,
    ServiceDetailTypeDef,
    SnapshotDetailTypeDef,
    SnapshotTaskDetailTypeDef,
    SpotMaintenanceStrategiesTypeDef,
    SpotDatafeedSubscriptionTypeDef,
    TransitGatewayMulticastDomainAssociationTypeDef,
    TransitGatewayMulticastDomainAssociationsTypeDef,
    SubnetIpv6CidrBlockAssociationTypeDef,
    TargetReservationValueTypeDef,
    TargetGroupsConfigTypeDef,
    TrafficMirrorFilterRuleTypeDef,
    TransitGatewayAttachmentTypeDef,
    TransitGatewayConnectPeerConfigurationTypeDef,
    TransitGatewayConnectTypeDef,
    TransitGatewayMulticastDomainTypeDef,
    TransitGatewayTypeDef,
    TransitGatewayPrefixListReferenceTypeDef,
    TransitGatewayRouteTypeDef,
    TransitGatewayVpcAttachmentTypeDef,
    UnsuccessfulInstanceCreditSpecificationItemTypeDef,
    UnsuccessfulItemTypeDef,
    ValidationWarningTypeDef,
    VolumeResponseMetadataTypeDef,
    VolumeTypeDef,
    VolumeStatusInfoTypeDef,
    VpcCidrBlockAssociationTypeDef,
    VpcIpv6CidrBlockAssociationTypeDef,
    VpcPeeringConnectionVpcInfoResponseMetadataTypeDef,
    VpcPeeringConnectionVpcInfoTypeDef,
    DescribeAccountAttributesResultTypeDef,
    DescribeAddressesAttributeResultTypeDef,
    ModifyAddressAttributeResultTypeDef,
    ResetAddressAttributeResultTypeDef,
    DescribeAddressesResultTypeDef,
    CreateCapacityReservationResultTypeDef,
    DescribeCapacityReservationsResultTypeDef,
    CreateCarrierGatewayResultTypeDef,
    DeleteCarrierGatewayResultTypeDef,
    DescribeCarrierGatewaysResultTypeDef,
    DescribeCoipPoolsResultTypeDef,
    CreateCustomerGatewayResultTypeDef,
    DescribeCustomerGatewaysResultTypeDef,
    DescribeHostReservationsResultTypeDef,
    AssociateInstanceEventWindowRequestRequestTypeDef,
    InstanceEventWindowTypeDef,
    DisassociateInstanceEventWindowRequestRequestTypeDef,
    CreateIpamScopeResultTypeDef,
    DeleteIpamScopeResultTypeDef,
    DescribeIpamScopesResultTypeDef,
    ModifyIpamScopeResultTypeDef,
    DescribeKeyPairsResultTypeDef,
    DeleteLaunchTemplateResultTypeDef,
    DescribeLaunchTemplatesResultTypeDef,
    ModifyLaunchTemplateResultTypeDef,
    DescribeLocalGatewayRouteTablesResultTypeDef,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResultTypeDef,
    CreateLocalGatewayRouteTableVpcAssociationResultTypeDef,
    DeleteLocalGatewayRouteTableVpcAssociationResultTypeDef,
    DescribeLocalGatewayRouteTableVpcAssociationsResultTypeDef,
    DescribeLocalGatewaysResultTypeDef,
    DescribeLocalGatewayVirtualInterfaceGroupsResultTypeDef,
    DescribeLocalGatewayVirtualInterfacesResultTypeDef,
    CreateManagedPrefixListResultTypeDef,
    DeleteManagedPrefixListResultTypeDef,
    DescribeManagedPrefixListsResultTypeDef,
    ModifyManagedPrefixListResultTypeDef,
    RestoreManagedPrefixListVersionResultTypeDef,
    DescribeNetworkInsightsAccessScopeAnalysesResultTypeDef,
    StartNetworkInsightsAccessScopeAnalysisResultTypeDef,
    DescribeNetworkInsightsAccessScopesResultTypeDef,
    CreateNetworkInsightsPathResultTypeDef,
    DescribeNetworkInsightsPathsResultTypeDef,
    CreatePlacementGroupResultTypeDef,
    DescribePlacementGroupsResultTypeDef,
    CreateReplaceRootVolumeTaskResultTypeDef,
    DescribeReplaceRootVolumeTasksResultTypeDef,
    CreateSnapshotsResultTypeDef,
    DescribeSnapshotTierStatusResultTypeDef,
    DescribeSnapshotsResultTypeDef,
    CreateSubnetCidrReservationResultTypeDef,
    DeleteSubnetCidrReservationResultTypeDef,
    GetSubnetCidrReservationsResultTypeDef,
    AllocateAddressRequestRequestTypeDef,
    AllocateHostsRequestRequestTypeDef,
    CopySnapshotRequestRequestTypeDef,
    CopySnapshotRequestSnapshotCopyTypeDef,
    CreateCapacityReservationFleetRequestRequestTypeDef,
    CreateCapacityReservationRequestRequestTypeDef,
    CreateCarrierGatewayRequestRequestTypeDef,
    CreateCustomerGatewayRequestRequestTypeDef,
    CreateDhcpOptionsRequestRequestTypeDef,
    CreateDhcpOptionsRequestServiceResourceCreateDhcpOptionsTypeDef,
    CreateEgressOnlyInternetGatewayRequestRequestTypeDef,
    CreateFlowLogsRequestRequestTypeDef,
    CreateFpgaImageRequestRequestTypeDef,
    CreateInstanceEventWindowRequestRequestTypeDef,
    CreateInstanceExportTaskRequestRequestTypeDef,
    CreateInternetGatewayRequestRequestTypeDef,
    CreateInternetGatewayRequestServiceResourceCreateInternetGatewayTypeDef,
    CreateIpamPoolRequestRequestTypeDef,
    CreateIpamRequestRequestTypeDef,
    CreateIpamScopeRequestRequestTypeDef,
    CreateKeyPairRequestRequestTypeDef,
    CreateKeyPairRequestServiceResourceCreateKeyPairTypeDef,
    CreateLocalGatewayRouteTableVpcAssociationRequestRequestTypeDef,
    CreateManagedPrefixListRequestRequestTypeDef,
    CreateNatGatewayRequestRequestTypeDef,
    CreateNetworkAclRequestRequestTypeDef,
    CreateNetworkAclRequestServiceResourceCreateNetworkAclTypeDef,
    CreateNetworkAclRequestVpcCreateNetworkAclTypeDef,
    CreateNetworkInsightsPathRequestRequestTypeDef,
    CreateNetworkInterfaceRequestRequestTypeDef,
    CreateNetworkInterfaceRequestServiceResourceCreateNetworkInterfaceTypeDef,
    CreateNetworkInterfaceRequestSubnetCreateNetworkInterfaceTypeDef,
    CreatePlacementGroupRequestRequestTypeDef,
    CreatePlacementGroupRequestServiceResourceCreatePlacementGroupTypeDef,
    CreatePublicIpv4PoolRequestRequestTypeDef,
    CreateReplaceRootVolumeTaskRequestRequestTypeDef,
    CreateRestoreImageTaskRequestRequestTypeDef,
    CreateRouteTableRequestRequestTypeDef,
    CreateRouteTableRequestServiceResourceCreateRouteTableTypeDef,
    CreateRouteTableRequestVpcCreateRouteTableTypeDef,
    CreateSecurityGroupRequestRequestTypeDef,
    CreateSecurityGroupRequestServiceResourceCreateSecurityGroupTypeDef,
    CreateSecurityGroupRequestVpcCreateSecurityGroupTypeDef,
    CreateSnapshotRequestRequestTypeDef,
    CreateSnapshotRequestServiceResourceCreateSnapshotTypeDef,
    CreateSnapshotRequestVolumeCreateSnapshotTypeDef,
    CreateSnapshotsRequestRequestTypeDef,
    CreateSubnetCidrReservationRequestRequestTypeDef,
    CreateSubnetRequestRequestTypeDef,
    CreateSubnetRequestServiceResourceCreateSubnetTypeDef,
    CreateSubnetRequestVpcCreateSubnetTypeDef,
    CreateTrafficMirrorFilterRequestRequestTypeDef,
    CreateTrafficMirrorSessionRequestRequestTypeDef,
    CreateTrafficMirrorTargetRequestRequestTypeDef,
    CreateTransitGatewayConnectPeerRequestRequestTypeDef,
    CreateTransitGatewayConnectRequestRequestTypeDef,
    CreateTransitGatewayMulticastDomainRequestRequestTypeDef,
    CreateTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    CreateTransitGatewayRequestRequestTypeDef,
    CreateTransitGatewayRouteTableRequestRequestTypeDef,
    CreateTransitGatewayVpcAttachmentRequestRequestTypeDef,
    CreateVolumeRequestRequestTypeDef,
    CreateVolumeRequestServiceResourceCreateVolumeTypeDef,
    CreateVpcEndpointRequestRequestTypeDef,
    CreateVpcEndpointServiceConfigurationRequestRequestTypeDef,
    CreateVpcPeeringConnectionRequestRequestTypeDef,
    CreateVpcPeeringConnectionRequestServiceResourceCreateVpcPeeringConnectionTypeDef,
    CreateVpcPeeringConnectionRequestVpcRequestVpcPeeringConnectionTypeDef,
    CreateVpcRequestRequestTypeDef,
    CreateVpcRequestServiceResourceCreateVpcTypeDef,
    CreateVpnGatewayRequestRequestTypeDef,
    ExportImageRequestRequestTypeDef,
    ImportKeyPairRequestRequestTypeDef,
    ImportKeyPairRequestServiceResourceImportKeyPairTypeDef,
    ProvisionByoipCidrRequestRequestTypeDef,
    PurchaseHostReservationRequestRequestTypeDef,
    StartNetworkInsightsAccessScopeAnalysisRequestRequestTypeDef,
    StartNetworkInsightsAnalysisRequestRequestTypeDef,
    CreateTrafficMirrorSessionResultTypeDef,
    DescribeTrafficMirrorSessionsResultTypeDef,
    ModifyTrafficMirrorSessionResultTypeDef,
    CreateTrafficMirrorTargetResultTypeDef,
    DescribeTrafficMirrorTargetsResultTypeDef,
    CreateTransitGatewayRouteTableResultTypeDef,
    DeleteTransitGatewayRouteTableResultTypeDef,
    DescribeTransitGatewayRouteTablesResultTypeDef,
    AssociateTrunkInterfaceResultTypeDef,
    DescribeTrunkInterfaceAssociationsResultTypeDef,
    DescribeVpcClassicLinkResultTypeDef,
    ExplanationTypeDef,
    PathComponentTypeDef,
    DescribeClientVpnTargetNetworksResultTypeDef,
    RouteTableTypeDef,
    GetFlowLogsIntegrationTemplateRequestRequestTypeDef,
    CreateVpnGatewayResultTypeDef,
    DescribeVpnGatewaysResultTypeDef,
    DhcpOptionsTypeDef,
    DescribeClientVpnAuthorizationRulesResultTypeDef,
    DescribeAvailabilityZonesResultTypeDef,
    HostTypeDef,
    CreateImageRequestInstanceCreateImageTypeDef,
    CreateImageRequestRequestTypeDef,
    ImageAttributeTypeDef,
    ImageTypeDef,
    RegisterImageRequestRequestTypeDef,
    RegisterImageRequestServiceResourceRegisterImageTypeDef,
    CancelCapacityReservationFleetsResultTypeDef,
    CancelSpotFleetRequestsResponseTypeDef,
    DescribeCapacityReservationFleetsResultTypeDef,
    ModifyInstanceCapacityReservationAttributesRequestRequestTypeDef,
    DescribeClassicLinkInstancesResultTypeDef,
    CreateClientVpnEndpointRequestRequestTypeDef,
    ClientVpnEndpointTypeDef,
    DescribeClientVpnConnectionsResultTypeDef,
    TerminateClientVpnConnectionsResultTypeDef,
    DescribeClientVpnRoutesResultTypeDef,
    NetworkAclTypeDef,
    LaunchSpecificationTypeDef,
    RequestSpotLaunchSpecificationTypeDef,
    ModifySnapshotAttributeRequestRequestTypeDef,
    ModifySnapshotAttributeRequestSnapshotModifyAttributeTypeDef,
    DeleteFleetsResultTypeDef,
    DeleteLaunchTemplateVersionsResultTypeDef,
    DeleteQueuedReservedInstancesResultTypeDef,
    DescribePrincipalIdFormatResultTypeDef,
    DescribeFastLaunchImagesResultTypeDef,
    DescribeFlowLogsResultTypeDef,
    DisableFastSnapshotRestoreErrorItemTypeDef,
    ImportInstanceTaskDetailsTypeDef,
    DescribeVpcEndpointConnectionsResultTypeDef,
    ModifyInstanceAttributeRequestInstanceModifyAttributeTypeDef,
    ModifyInstanceAttributeRequestRequestTypeDef,
    InstanceAttributeTypeDef,
    CreateEgressOnlyInternetGatewayResultTypeDef,
    DescribeEgressOnlyInternetGatewaysResultTypeDef,
    CreateInternetGatewayResultTypeDef,
    DescribeInternetGatewaysResultTypeDef,
    DescribeElasticGpusResultTypeDef,
    EnableFastSnapshotRestoreErrorItemTypeDef,
    DescribeFleetHistoryResultTypeDef,
    DescribeSpotFleetRequestHistoryResponseTypeDef,
    DescribeExportImageTasksResultTypeDef,
    CreateInstanceExportTaskResultTypeDef,
    DescribeExportTasksResultTypeDef,
    SpotOptionsRequestTypeDef,
    SpotOptionsTypeDef,
    FpgaInfoTypeDef,
    DescribeFpgaImageAttributeResultTypeDef,
    ModifyFpgaImageAttributeResultTypeDef,
    DescribeFpgaImagesResultTypeDef,
    GpuInfoTypeDef,
    AssociateIamInstanceProfileResultTypeDef,
    DescribeIamInstanceProfileAssociationsResultTypeDef,
    DisassociateIamInstanceProfileResultTypeDef,
    ReplaceIamInstanceProfileAssociationResultTypeDef,
    ModifyImageAttributeRequestImageModifyAttributeTypeDef,
    ModifyImageAttributeRequestRequestTypeDef,
    ImportImageRequestRequestTypeDef,
    ImportSnapshotRequestRequestTypeDef,
    ImportInstanceRequestRequestTypeDef,
    RunInstancesRequestRequestTypeDef,
    RunInstancesRequestServiceResourceCreateInstancesTypeDef,
    RunInstancesRequestSubnetCreateInstancesTypeDef,
    MonitorInstancesResultTypeDef,
    UnmonitorInstancesResultTypeDef,
    InstanceNetworkInterfaceTypeDef,
    FleetLaunchTemplateOverridesRequestTypeDef,
    GetInstanceTypesFromInstanceRequirementsRequestGetInstanceTypesFromInstanceRequirementsPaginateTypeDef,
    GetInstanceTypesFromInstanceRequirementsRequestRequestTypeDef,
    InstanceRequirementsWithMetadataRequestTypeDef,
    FleetLaunchTemplateOverridesTypeDef,
    LaunchTemplateOverridesTypeDef,
    SpotFleetLaunchSpecificationTypeDef,
    StartInstancesResultTypeDef,
    StopInstancesResultTypeDef,
    TerminateInstancesResultTypeDef,
    InstanceStatusTypeDef,
    AuthorizeSecurityGroupEgressRequestRequestTypeDef,
    AuthorizeSecurityGroupEgressRequestSecurityGroupAuthorizeEgressTypeDef,
    AuthorizeSecurityGroupIngressRequestRequestTypeDef,
    AuthorizeSecurityGroupIngressRequestSecurityGroupAuthorizeIngressTypeDef,
    RevokeSecurityGroupEgressRequestRequestTypeDef,
    RevokeSecurityGroupEgressRequestSecurityGroupRevokeEgressTypeDef,
    RevokeSecurityGroupEgressResultTypeDef,
    RevokeSecurityGroupIngressRequestRequestTypeDef,
    RevokeSecurityGroupIngressRequestSecurityGroupRevokeIngressTypeDef,
    RevokeSecurityGroupIngressResultTypeDef,
    SecurityGroupTypeDef,
    UpdateSecurityGroupRuleDescriptionsEgressRequestRequestTypeDef,
    UpdateSecurityGroupRuleDescriptionsIngressRequestRequestTypeDef,
    StaleSecurityGroupTypeDef,
    CreateIpamResultTypeDef,
    DeleteIpamResultTypeDef,
    DescribeIpamsResultTypeDef,
    ModifyIpamResultTypeDef,
    DeprovisionIpamPoolCidrResultTypeDef,
    GetIpamPoolCidrsResultTypeDef,
    ProvisionIpamPoolCidrResultTypeDef,
    CreateIpamPoolResultTypeDef,
    DeleteIpamPoolResultTypeDef,
    DescribeIpamPoolsResultTypeDef,
    ModifyIpamPoolResultTypeDef,
    GetIpamResourceCidrsResultTypeDef,
    ModifyIpamResourceCidrResultTypeDef,
    DescribeIpv6PoolsResultTypeDef,
    RequestLaunchTemplateDataTypeDef,
    ResponseLaunchTemplateDataTypeDef,
    ModifyFpgaImageAttributeRequestRequestTypeDef,
    ReservedInstancesModificationTypeDef,
    ModifyVpnTunnelOptionsRequestRequestTypeDef,
    VpnConnectionOptionsSpecificationTypeDef,
    CreateNatGatewayResultTypeDef,
    DescribeNatGatewaysResultTypeDef,
    NetworkInterfaceTypeDef,
    CreateNetworkInterfacePermissionResultTypeDef,
    DescribeNetworkInterfacePermissionsResultTypeDef,
    AccessScopePathRequestTypeDef,
    AccessScopePathTypeDef,
    AcceptTransitGatewayPeeringAttachmentResultTypeDef,
    CreateTransitGatewayPeeringAttachmentResultTypeDef,
    DeleteTransitGatewayPeeringAttachmentResultTypeDef,
    DescribeTransitGatewayPeeringAttachmentsResultTypeDef,
    RejectTransitGatewayPeeringAttachmentResultTypeDef,
    VpnConnectionOptionsTypeDef,
    CancelReservedInstancesListingResultTypeDef,
    CreateReservedInstancesListingResultTypeDef,
    DescribeReservedInstancesListingsResultTypeDef,
    DescribePublicIpv4PoolsResultTypeDef,
    DescribeReservedInstancesOfferingsResultTypeDef,
    DescribeReservedInstancesResultTypeDef,
    AuthorizeSecurityGroupEgressResultTypeDef,
    AuthorizeSecurityGroupIngressResultTypeDef,
    DescribeSecurityGroupRulesResultTypeDef,
    BundleInstanceRequestRequestTypeDef,
    BundleTaskTypeDef,
    DescribeScheduledInstanceAvailabilityResultTypeDef,
    DescribeScheduledInstancesResultTypeDef,
    PurchaseScheduledInstancesResultTypeDef,
    ScheduledInstancesLaunchSpecificationTypeDef,
    CreateVpcEndpointResultTypeDef,
    DescribeVpcEndpointsResultTypeDef,
    ModifySecurityGroupRulesRequestRequestTypeDef,
    CreateVpcEndpointServiceConfigurationResultTypeDef,
    DescribeVpcEndpointServiceConfigurationsResultTypeDef,
    DescribeVpcEndpointServicesResultTypeDef,
    ImportImageResultTypeDef,
    ImportImageTaskTypeDef,
    ImportSnapshotResultTypeDef,
    ImportSnapshotTaskTypeDef,
    CreateSpotDatafeedSubscriptionResultTypeDef,
    DescribeSpotDatafeedSubscriptionResultTypeDef,
    GetTransitGatewayMulticastDomainAssociationsResultTypeDef,
    AcceptTransitGatewayMulticastDomainAssociationsResultTypeDef,
    AssociateTransitGatewayMulticastDomainResultTypeDef,
    DisassociateTransitGatewayMulticastDomainResultTypeDef,
    RejectTransitGatewayMulticastDomainAssociationsResultTypeDef,
    AssociateSubnetCidrBlockResultTypeDef,
    DisassociateSubnetCidrBlockResultTypeDef,
    SubnetTypeDef,
    GetReservedInstancesExchangeQuoteResultTypeDef,
    LoadBalancersConfigTypeDef,
    CreateTrafficMirrorFilterRuleResultTypeDef,
    ModifyTrafficMirrorFilterRuleResultTypeDef,
    TrafficMirrorFilterTypeDef,
    DescribeTransitGatewayAttachmentsResultTypeDef,
    TransitGatewayConnectPeerTypeDef,
    CreateTransitGatewayConnectResultTypeDef,
    DeleteTransitGatewayConnectResultTypeDef,
    DescribeTransitGatewayConnectsResultTypeDef,
    CreateTransitGatewayMulticastDomainResultTypeDef,
    DeleteTransitGatewayMulticastDomainResultTypeDef,
    DescribeTransitGatewayMulticastDomainsResultTypeDef,
    CreateTransitGatewayResultTypeDef,
    DeleteTransitGatewayResultTypeDef,
    DescribeTransitGatewaysResultTypeDef,
    ModifyTransitGatewayResultTypeDef,
    CreateTransitGatewayPrefixListReferenceResultTypeDef,
    DeleteTransitGatewayPrefixListReferenceResultTypeDef,
    GetTransitGatewayPrefixListReferencesResultTypeDef,
    ModifyTransitGatewayPrefixListReferenceResultTypeDef,
    CreateTransitGatewayRouteResultTypeDef,
    DeleteTransitGatewayRouteResultTypeDef,
    ReplaceTransitGatewayRouteResultTypeDef,
    SearchTransitGatewayRoutesResultTypeDef,
    AcceptTransitGatewayVpcAttachmentResultTypeDef,
    CreateTransitGatewayVpcAttachmentResultTypeDef,
    DeleteTransitGatewayVpcAttachmentResultTypeDef,
    DescribeTransitGatewayVpcAttachmentsResultTypeDef,
    ModifyTransitGatewayVpcAttachmentResultTypeDef,
    RejectTransitGatewayVpcAttachmentResultTypeDef,
    ModifyInstanceCreditSpecificationResultTypeDef,
    AcceptVpcEndpointConnectionsResultTypeDef,
    CreateFlowLogsResultTypeDef,
    DeleteFlowLogsResultTypeDef,
    DeleteVpcEndpointConnectionNotificationsResultTypeDef,
    DeleteVpcEndpointServiceConfigurationsResultTypeDef,
    DeleteVpcEndpointsResultTypeDef,
    ModifyHostsResultTypeDef,
    RejectVpcEndpointConnectionsResultTypeDef,
    ReleaseHostsResultTypeDef,
    CreateLaunchTemplateResultTypeDef,
    DescribeVolumesResultTypeDef,
    VolumeStatusItemTypeDef,
    AssociateVpcCidrBlockResultTypeDef,
    DisassociateVpcCidrBlockResultTypeDef,
    VpcTypeDef,
    VpcPeeringConnectionTypeDef,
    AssociateInstanceEventWindowResultTypeDef,
    CreateInstanceEventWindowResultTypeDef,
    DescribeInstanceEventWindowsResultTypeDef,
    DisassociateInstanceEventWindowResultTypeDef,
    ModifyInstanceEventWindowResultTypeDef,
    AccessScopeAnalysisFindingTypeDef,
    NetworkInsightsAnalysisTypeDef,
    CreateRouteTableResultTypeDef,
    DescribeRouteTablesResultTypeDef,
    CreateDhcpOptionsResultTypeDef,
    DescribeDhcpOptionsResultTypeDef,
    DescribeHostsResultTypeDef,
    DescribeImagesResultTypeDef,
    DescribeClientVpnEndpointsResultTypeDef,
    CreateNetworkAclResultTypeDef,
    DescribeNetworkAclsResultTypeDef,
    SpotInstanceRequestTypeDef,
    RequestSpotInstancesRequestRequestTypeDef,
    DisableFastSnapshotRestoresResultTypeDef,
    ConversionTaskTypeDef,
    EnableFastSnapshotRestoresResultTypeDef,
    InstanceTypeInfoTypeDef,
    InstanceTypeDef,
    FleetLaunchTemplateConfigRequestTypeDef,
    GetSpotPlacementScoresRequestGetSpotPlacementScoresPaginateTypeDef,
    GetSpotPlacementScoresRequestRequestTypeDef,
    FleetLaunchTemplateConfigTypeDef,
    LaunchTemplateAndOverridesResponseTypeDef,
    LaunchTemplateConfigTypeDef,
    DescribeInstanceStatusResultTypeDef,
    DescribeSecurityGroupsResultTypeDef,
    DescribeStaleSecurityGroupsResultTypeDef,
    CreateLaunchTemplateRequestRequestTypeDef,
    CreateLaunchTemplateVersionRequestRequestTypeDef,
    GetLaunchTemplateDataResultTypeDef,
    LaunchTemplateVersionTypeDef,
    DescribeReservedInstancesModificationsResultTypeDef,
    CreateVpnConnectionRequestRequestTypeDef,
    CreateNetworkInterfaceResultTypeDef,
    DescribeNetworkInterfacesResultTypeDef,
    CreateNetworkInsightsAccessScopeRequestRequestTypeDef,
    NetworkInsightsAccessScopeContentTypeDef,
    VpnConnectionTypeDef,
    BundleInstanceResultTypeDef,
    CancelBundleTaskResultTypeDef,
    DescribeBundleTasksResultTypeDef,
    RunScheduledInstancesRequestRequestTypeDef,
    DescribeImportImageTasksResultTypeDef,
    DescribeImportSnapshotTasksResultTypeDef,
    CreateDefaultSubnetResultTypeDef,
    CreateSubnetResultTypeDef,
    DescribeSubnetsResultTypeDef,
    CreateTrafficMirrorFilterResultTypeDef,
    DescribeTrafficMirrorFiltersResultTypeDef,
    ModifyTrafficMirrorFilterNetworkServicesResultTypeDef,
    CreateTransitGatewayConnectPeerResultTypeDef,
    DeleteTransitGatewayConnectPeerResultTypeDef,
    DescribeTransitGatewayConnectPeersResultTypeDef,
    DescribeVolumeStatusResultTypeDef,
    CreateDefaultVpcResultTypeDef,
    CreateVpcResultTypeDef,
    DescribeVpcsResultTypeDef,
    AcceptVpcPeeringConnectionResultTypeDef,
    CreateVpcPeeringConnectionResultTypeDef,
    DescribeVpcPeeringConnectionsResultTypeDef,
    GetNetworkInsightsAccessScopeAnalysisFindingsResultTypeDef,
    DescribeNetworkInsightsAnalysesResultTypeDef,
    StartNetworkInsightsAnalysisResultTypeDef,
    DescribeSpotInstanceRequestsResultTypeDef,
    RequestSpotInstancesResultTypeDef,
    DescribeConversionTasksResultTypeDef,
    ImportInstanceResultTypeDef,
    ImportVolumeResultTypeDef,
    DescribeInstanceTypesResultTypeDef,
    ReservationResponseMetadataTypeDef,
    ReservationTypeDef,
    CreateFleetRequestRequestTypeDef,
    ModifyFleetRequestRequestTypeDef,
    CreateFleetErrorTypeDef,
    CreateFleetInstanceTypeDef,
    DescribeFleetErrorTypeDef,
    DescribeFleetsInstancesTypeDef,
    ModifySpotFleetRequestRequestRequestTypeDef,
    SpotFleetRequestConfigDataTypeDef,
    CreateLaunchTemplateVersionResultTypeDef,
    DescribeLaunchTemplateVersionsResultTypeDef,
    CreateNetworkInsightsAccessScopeResultTypeDef,
    GetNetworkInsightsAccessScopeContentResultTypeDef,
    CreateVpnConnectionResultTypeDef,
    DescribeVpnConnectionsResultTypeDef,
    ModifyVpnConnectionOptionsResultTypeDef,
    ModifyVpnConnectionResultTypeDef,
    ModifyVpnTunnelCertificateResultTypeDef,
    ModifyVpnTunnelOptionsResultTypeDef,
    DescribeInstancesResultTypeDef,
    CreateFleetResultTypeDef,
    FleetDataTypeDef,
    RequestSpotFleetRequestRequestTypeDef,
    SpotFleetRequestConfigTypeDef,
    DescribeFleetsResultTypeDef,
    DescribeSpotFleetRequestsResponseTypeDef,
)

def get_structure() -> AcceleratorCountRequestTypeDef:
    return {
      ...
    }
```

<a id="how-it-works"></a>

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for `boto3`
updates. It delivers a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type
  annotations extracted from the documentation (blame `botocore` docs if types
  are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

<a id="what's-new"></a>

## What's new

<a id="implemented-features"></a>

### Implemented features

- Fully type annotated `boto3`, `botocore` and `aiobotocore` libraries
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client`, `ServiceResource`, `Resource`, `Waiter` `Paginator` type
  annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.session` calls
- Auto discovery of types for `session.client` and `session.session` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections
- Auto discovery of types for `aiobotocore.Session.create_client` calls

<a id="latest-changes"></a>

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/youtype/mypy_boto3_builder/releases).

<a id="versioning"></a>

## Versioning

`mypy-boto3-ec2` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="thank-you"></a>

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

<a id="documentation"></a>

## Documentation

All services type annotations can be found in
[boto3 docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ec2/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder/issues/)
repository.
